/*
 * Decompiled with CFR 0.152.
 */
package net.nand.util.i18n.mgr;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    protected final ResourceBundle bundle;

    public StringManager(String bundlePath) {
        this.bundle = ResourceBundle.getBundle(bundlePath);
    }

    public StringManager(String bundlePath, Locale loc) {
        this.bundle = ResourceBundle.getBundle(bundlePath, loc);
    }

    public static final Locale parseLocale(String loc) throws IllegalArgumentException {
        if (loc == null || loc.isEmpty()) {
            return Locale.getDefault();
        }
        String[] lc = loc.split("_");
        if (lc.length == 1) {
            return new Locale(lc[0]);
        }
        if (lc.length == 2) {
            return new Locale(lc[0], lc[1]);
        }
        return new Locale(lc[0], lc[1], lc[2]);
    }

    public final String get(String key) throws MissingResourceException {
        return this.bundle.getString(key);
    }

    public final String get(String key, Object ... arguments) throws MissingResourceException {
        return MessageFormat.format(this.bundle.getString(key), arguments);
    }
}

