/*
 * Decompiled with CFR 0.152.
 */
package soc.baseclient;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import soc.baseclient.ServerConnectInfo;
import soc.disableDebug.D;
import soc.game.GameAction;
import soc.game.ResourceSet;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCCity;
import soc.game.SOCFortress;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCInventory;
import soc.game.SOCInventoryItem;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCRoutePiece;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.game.SOCSpecialItem;
import soc.game.SOCTradeOffer;
import soc.game.SOCVillage;
import soc.message.SOCAcceptOffer;
import soc.message.SOCBCastTextMsg;
import soc.message.SOCBankTrade;
import soc.message.SOCBoardLayout;
import soc.message.SOCBoardLayout2;
import soc.message.SOCBuildRequest;
import soc.message.SOCBuyDevCardRequest;
import soc.message.SOCCancelBuildRequest;
import soc.message.SOCChangeFace;
import soc.message.SOCChannelMembers;
import soc.message.SOCChannelTextMsg;
import soc.message.SOCChannels;
import soc.message.SOCChoosePlayer;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCClearTradeMsg;
import soc.message.SOCDeclinePlayerRequest;
import soc.message.SOCDeleteChannel;
import soc.message.SOCDeleteGame;
import soc.message.SOCDevCardAction;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiceResultResources;
import soc.message.SOCDiscard;
import soc.message.SOCDiscardRequest;
import soc.message.SOCEndTurn;
import soc.message.SOCFirstPlayer;
import soc.message.SOCGameElements;
import soc.message.SOCGameMembers;
import soc.message.SOCGameOptionInfo;
import soc.message.SOCGameServerText;
import soc.message.SOCGameState;
import soc.message.SOCGameStats;
import soc.message.SOCGameTextMsg;
import soc.message.SOCGames;
import soc.message.SOCGamesWithOptions;
import soc.message.SOCInventoryItemAction;
import soc.message.SOCJoinChannel;
import soc.message.SOCJoinChannelAuth;
import soc.message.SOCJoinGame;
import soc.message.SOCJoinGameAuth;
import soc.message.SOCLargestArmy;
import soc.message.SOCLastSettlement;
import soc.message.SOCLeaveAll;
import soc.message.SOCLeaveChannel;
import soc.message.SOCLeaveGame;
import soc.message.SOCLongestRoad;
import soc.message.SOCMakeOffer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;
import soc.message.SOCMovePiece;
import soc.message.SOCMoveRobber;
import soc.message.SOCNewChannel;
import soc.message.SOCNewGame;
import soc.message.SOCNewGameWithOptions;
import soc.message.SOCPickResourceType;
import soc.message.SOCPickResources;
import soc.message.SOCPieceValue;
import soc.message.SOCPlayDevCardRequest;
import soc.message.SOCPlayerElement;
import soc.message.SOCPlayerElements;
import soc.message.SOCPlayerStats;
import soc.message.SOCPotentialSettlements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectConnection;
import soc.message.SOCRejectOffer;
import soc.message.SOCRemovePiece;
import soc.message.SOCResetBoardAuth;
import soc.message.SOCResourceCount;
import soc.message.SOCRevealFogHex;
import soc.message.SOCRobberyResult;
import soc.message.SOCRollDice;
import soc.message.SOCServerPing;
import soc.message.SOCSetLastAction;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetSeatLock;
import soc.message.SOCSetShipRouteClosed;
import soc.message.SOCSetSpecialItem;
import soc.message.SOCSetTurn;
import soc.message.SOCSimpleAction;
import soc.message.SOCSimpleRequest;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCStatusMessage;
import soc.message.SOCTurn;
import soc.message.SOCUndoNotAllowedReasonText;
import soc.message.SOCUndoPutPiece;
import soc.message.SOCVersion;
import soc.server.genericServer.StringConnection;
import soc.util.SOCFeatureSet;
import soc.util.Version;

public class SOCDisplaylessPlayerClient
implements Runnable {
    public static final String PROP_JSETTLERS_DEBUG_TRAFFIC = "jsettlers.debug.traffic";
    public static final String PROP_JSETTLERS_DEBUG_CLIENT_GAMEOPT3P = "jsettlers.debug.client.gameopt3p";
    protected static String STATSPREFEX = "  [";
    protected String doc;
    protected String lastMessage;
    protected long nextServerPingExpectedAt;
    protected final ServerConnectInfo serverConnectInfo;
    public SOCGameOptionSet knownOpts = SOCGameOptionSet.getAllKnownOptions();
    protected boolean allOptsReceived = true;
    protected Socket sock;
    protected DataInputStream in;
    protected DataOutputStream out;
    protected StringConnection sLocal;
    protected int sVersion;
    protected int sLocalVersion;
    protected SOCFeatureSet sFeatures;
    protected SOCFeatureSet sLocalFeatures;
    protected Thread reader = null;
    protected Exception ex = null;
    protected boolean connected = false;
    protected boolean rejected = false;
    protected String nickname = null;
    protected String password = null;
    protected boolean gotPassword;
    protected Hashtable<String, ?> channels = new Hashtable();
    protected Hashtable<String, SOCGame> games = new Hashtable();
    protected boolean debugTraffic;
    protected boolean ignorePlayerStats = true;

    public SOCDisplaylessPlayerClient(ServerConnectInfo sci, boolean visual) throws IllegalArgumentException {
        if (sci == null) {
            throw new IllegalArgumentException("sci");
        }
        this.serverConnectInfo = sci;
        this.sVersion = -1;
        this.sLocalVersion = -1;
        if (null != System.getProperty(PROP_JSETTLERS_DEBUG_TRAFFIC)) {
            this.debugTraffic = true;
        }
    }

    public String getNickname() {
        return this.nickname;
    }

    public SOCGame getGame(String gaName) {
        return this.games.get(gaName);
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setName("robot-netread-" + this.nickname);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            while (this.connected) {
                String s = this.sLocal == null ? this.in.readUTF() : this.sLocal.readNext();
                SOCMessage msg = SOCMessage.toMsg(s);
                if (msg != null) {
                    this.treat(msg);
                    continue;
                }
                if (!this.debugTraffic) continue;
                soc.debug.D.ebugERROR(this.nickname + ": Could not parse net message: " + s);
            }
        }
        catch (InterruptedIOException e) {
            this.ex = e;
            System.err.println("Socket timeout in run: " + e);
        }
        catch (IOException e) {
            if (!this.connected) {
                return;
            }
            this.ex = e;
            this.destroy();
        }
    }

    public void resend() {
        if (this.lastMessage != null) {
            this.put(this.lastMessage);
        }
    }

    public synchronized boolean put(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("null");
        }
        this.lastMessage = s;
        if (this.debugTraffic || D.ebugIsEnabled()) {
            soc.debug.D.ebugPrintlnINFO("OUT - " + this.nickname + " - " + s);
        }
        if (this.ex != null || !this.connected) {
            return false;
        }
        try {
            if (this.sLocal == null) {
                this.out.writeUTF(s);
                this.out.flush();
            } else {
                this.sLocal.put(s);
            }
        }
        catch (InterruptedIOException x) {
            System.err.println("Socket timeout in put: " + x);
        }
        catch (IOException e) {
            this.ex = e;
            System.err.println("could not write to the net: " + this.ex);
            this.destroy();
            return false;
        }
        return true;
    }

    public void treat(SOCMessage mes) {
        this.treat(mes, false);
    }

    protected void treat(SOCMessage mes, boolean didDebugPrintAlready) {
        if (mes == null) {
            return;
        }
        if (!(!this.debugTraffic && !D.ebugIsEnabled() || didDebugPrintAlready || mes instanceof SOCServerPing && this.nextServerPingExpectedAt != 0L && Math.abs(System.currentTimeMillis() - this.nextServerPingExpectedAt) <= 66000L)) {
            soc.debug.D.ebugPrintlnINFO("IN - " + this.nickname + " - " + mes.toString());
        }
        int typ = mes.getType();
        if (mes instanceof SOCMessageForGame) {
            this.nextServerPingExpectedAt = 0L;
        }
        try {
            switch (typ) {
                case 9998: {
                    this.handleVERSION(this.sLocal != null, (SOCVersion)mes);
                    break;
                }
                case 1069: {
                    this.handleSTATUSMESSAGE((SOCStatusMessage)mes);
                    break;
                }
                case 9999: {
                    this.handleSERVERPING((SOCServerPing)mes);
                    break;
                }
                case 1020: {
                    this.handleJOINCHANNELAUTH((SOCJoinChannelAuth)mes);
                    break;
                }
                case 1004: {
                    this.handleJOINCHANNEL((SOCJoinChannel)mes);
                    break;
                }
                case 1002: {
                    this.handleCHANNELMEMBERS((SOCChannelMembers)mes);
                    break;
                }
                case 1001: {
                    this.handleNEWCHANNEL((SOCNewChannel)mes);
                    break;
                }
                case 1003: {
                    this.handleCHANNELS((SOCChannels)mes);
                    break;
                }
                case 1005: {
                    this.handleCHANNELTEXTMSG((SOCChannelTextMsg)mes);
                    break;
                }
                case 1006: {
                    this.handleLEAVECHANNEL((SOCLeaveChannel)mes);
                    break;
                }
                case 1007: {
                    this.handleDELETECHANNEL((SOCDeleteChannel)mes);
                    break;
                }
                case 1019: {
                    this.handleGAMES((SOCGames)mes);
                    break;
                }
                case 1083: {
                    this.handleGAMESWITHOPTIONS((SOCGamesWithOptions)mes);
                    break;
                }
                case 1021: {
                    this.handleJOINGAMEAUTH((SOCJoinGameAuth)mes, this.sLocal != null);
                    break;
                }
                case 1013: {
                    this.handleJOINGAME((SOCJoinGame)mes);
                    break;
                }
                case 1011: {
                    this.handleLEAVEGAME((SOCLeaveGame)mes);
                    break;
                }
                case 1016: {
                    this.handleNEWGAME((SOCNewGame)mes);
                    break;
                }
                case 1079: {
                    this.handleNEWGAMEWITHOPTIONS((SOCNewGameWithOptions)mes);
                    break;
                }
                case 1015: {
                    this.handleDELETEGAME((SOCDeleteGame)mes);
                    break;
                }
                case 1017: {
                    this.handleGAMEMEMBERS((SOCGameMembers)mes);
                    break;
                }
                case 1061: {
                    this.handleGAMESTATS((SOCGameStats)mes);
                    break;
                }
                case 1010: {
                    this.handleGAMETEXTMSG((SOCGameTextMsg)mes);
                    break;
                }
                case 1062: {
                    this.handleBCASTTEXTMSG((SOCBCastTextMsg)mes);
                    break;
                }
                case 1012: {
                    this.handleSITDOWN((SOCSitDown)mes);
                    break;
                }
                case 1014: {
                    SOCDisplaylessPlayerClient.handleBOARDLAYOUT((SOCBoardLayout)mes, this.games.get(((SOCBoardLayout)mes).getGame()));
                    break;
                }
                case 1084: {
                    SOCDisplaylessPlayerClient.handleBOARDLAYOUT2((SOCBoardLayout2)mes, this.games.get(((SOCBoardLayout2)mes).getGame()));
                    break;
                }
                case 1018: {
                    SOCDisplaylessPlayerClient.handleSTARTGAME(this.games, (SOCStartGame)mes);
                    break;
                }
                case 1025: {
                    this.handleGAMESTATE((SOCGameState)mes);
                    break;
                }
                case 1055: {
                    this.handleSETTURN((SOCSetTurn)mes);
                    break;
                }
                case 1054: {
                    this.handleFIRSTPLAYER((SOCFirstPlayer)mes);
                    break;
                }
                case 1026: {
                    this.handleTURN((SOCTurn)mes);
                    break;
                }
                case 1024: {
                    this.handlePLAYERELEMENT((SOCPlayerElement)mes);
                    break;
                }
                case 1086: {
                    this.handlePLAYERELEMENTS((SOCPlayerElements)mes);
                    break;
                }
                case 1096: {
                    this.handleGAMEELEMENTS((SOCGameElements)mes);
                    break;
                }
                case 1063: {
                    this.handleRESOURCECOUNT((SOCResourceCount)mes);
                    break;
                }
                case 1060: {
                    SOCDisplaylessPlayerClient.handleLASTSETTLEMENT((SOCLastSettlement)mes, this.games.get(((SOCLastSettlement)mes).getGame()));
                    break;
                }
                case 1028: {
                    this.handleDICERESULT((SOCDiceResult)mes);
                    break;
                }
                case 1009: {
                    SOCPutPiece ppm = (SOCPutPiece)mes;
                    SOCDisplaylessPlayerClient.handlePUTPIECE(ppm, this.games.get(ppm.getGame()));
                    break;
                }
                case 1044: {
                    this.handleCANCELBUILDREQUEST((SOCCancelBuildRequest)mes);
                    break;
                }
                case 1033: {
                    SOCDisplaylessPlayerClient.handleDISCARD((SOCDiscard)mes, this.games.get(((SOCDiscard)mes).getGame()));
                    break;
                }
                case 1034: {
                    this.handleMOVEROBBER((SOCMoveRobber)mes);
                    break;
                }
                case 1029: {
                    this.handleDISCARDREQUEST((SOCDiscardRequest)mes);
                    break;
                }
                case 1036: {
                    this.handleCHOOSEPLAYERREQUEST((SOCChoosePlayerRequest)mes);
                    break;
                }
                case 1041: {
                    this.handleMAKEOFFER((SOCMakeOffer)mes);
                    break;
                }
                case 1038: {
                    this.handleCLEAROFFER((SOCClearOffer)mes);
                    break;
                }
                case 1037: {
                    this.handleREJECTOFFER((SOCRejectOffer)mes);
                    break;
                }
                case 1039: {
                    SOCDisplaylessPlayerClient.handleACCEPTOFFER((SOCAcceptOffer)mes, this.games.get(((SOCMessageForGame)((Object)mes)).getGame()));
                    break;
                }
                case 1042: {
                    this.handleCLEARTRADEMSG((SOCClearTradeMsg)mes);
                    break;
                }
                case 1040: {
                    SOCDisplaylessPlayerClient.handleBANKTRADE((SOCBankTrade)mes, this.games.get(((SOCMessageForGame)((Object)mes)).getGame()));
                    break;
                }
                case 1047: {
                    this.handleDEVCARDCOUNT((SOCDevCardCount)mes);
                    break;
                }
                case 1046: {
                    this.handleDEVCARDACTION(this.sLocal != null, (SOCDevCardAction)mes);
                    break;
                }
                case 1048: {
                    this.handleSETPLAYEDDEVCARD((SOCSetPlayedDevCard)mes);
                    break;
                }
                case 1057: {
                    SOCDisplaylessPlayerClient.handlePOTENTIALSETTLEMENTS((SOCPotentialSettlements)mes, this.games.get(((SOCPotentialSettlements)mes).getGame()));
                    break;
                }
                case 1058: {
                    this.handleCHANGEFACE((SOCChangeFace)mes);
                    break;
                }
                case 1059: {
                    this.handleREJECTCONNECTION((SOCRejectConnection)mes);
                    break;
                }
                case 1066: {
                    this.handleLONGESTROAD((SOCLongestRoad)mes);
                    break;
                }
                case 1067: {
                    this.handleLARGESTARMY((SOCLargestArmy)mes);
                    break;
                }
                case 1068: {
                    this.handleSETSEATLOCK((SOCSetSeatLock)mes);
                    break;
                }
                case 1074: {
                    this.handleRESETBOARDAUTH((SOCResetBoardAuth)mes);
                    break;
                }
                case 1082: {
                    this.handleGAMEOPTIONINFO((SOCGameOptionInfo)mes);
                    break;
                }
                case 1085: {
                    SOCPlayer pn;
                    if (this.ignorePlayerStats) break;
                    SOCGame ga = this.games.get(((SOCPlayerStats)mes).getGame());
                    if (ga != null && (pn = ga.getPlayer(this.nickname)) != null) {
                        SOCDisplaylessPlayerClient.handlePLAYERSTATS((SOCPlayerStats)mes, ga, pn.getPlayerNumber());
                    }
                    break;
                }
                case 1090: {
                    SOCDisplaylessPlayerClient.handleSIMPLEACTION((SOCSimpleAction)mes, this.games.get(((SOCSimpleAction)mes).getGame()));
                    break;
                }
                case 1091: {
                    this.handleGAMESERVERTEXT((SOCGameServerText)mes);
                    break;
                }
                case 1092: {
                    this.handleDICERESULTRESOURCES((SOCDiceResultResources)mes);
                    break;
                }
                case 1093: {
                    this.handleMOVEPIECE((SOCMovePiece)mes);
                    break;
                }
                case 1094: {
                    this.handleREMOVEPIECE((SOCRemovePiece)mes);
                    break;
                }
                case 10001: {
                    this.handleREVEALFOGHEX((SOCRevealFogHex)mes);
                    break;
                }
                case 1095: {
                    this.handlePIECEVALUE((SOCPieceValue)mes);
                    break;
                }
                case 1098: {
                    SOCDisplaylessPlayerClient.handleINVENTORYITEMACTION(this.games, (SOCInventoryItemAction)mes);
                    break;
                }
                case 1099: {
                    SOCDisplaylessPlayerClient.handleSETSPECIALITEM(this.games, (SOCSetSpecialItem)mes);
                    break;
                }
                case 1102: {
                    SOCDisplaylessPlayerClient.handleROBBERYRESULT((SOCRobberyResult)mes, this.games.get(((SOCMessageForGame)((Object)mes)).getGame()));
                    break;
                }
                case 1052: {
                    SOCDisplaylessPlayerClient.handlePICKRESOURCES((SOCPickResources)mes, this.games.get(((SOCMessageForGame)((Object)mes)).getGame()));
                    break;
                }
                case 1104: {
                    SOCDisplaylessPlayerClient.handleDECLINEPLAYERREQUEST((SOCDeclinePlayerRequest)mes, this.games.get(((SOCMessageForGame)((Object)mes)).getGame()));
                    break;
                }
                case 1105: {
                    SOCDisplaylessPlayerClient.handleUNDOPUTPIECE((SOCUndoPutPiece)mes, this.games.get(((SOCUndoPutPiece)mes).getGame()));
                    break;
                }
                case 1106: {
                    SOCDisplaylessPlayerClient.handleSETLASTACTION((SOCSetLastAction)mes, this.games.get(((SOCSetLastAction)mes).getGame()));
                    break;
                }
                case 1107: {
                    SOCDisplaylessPlayerClient.handleUNDONOTALLOWEDREASONTEXT((SOCUndoNotAllowedReasonText)mes, this.games.get(((SOCUndoNotAllowedReasonText)mes).getGame()));
                    break;
                }
                case 10002: {
                    SOCDisplaylessPlayerClient.handleSETSHIPROUTECLOSED((SOCSetShipRouteClosed)mes, this.games.get(((SOCSetShipRouteClosed)mes).getGame()));
                }
            }
        }
        catch (Exception e) {
            System.out.println("SOCDisplaylessPlayerClient treat ERROR - " + e.getMessage());
            e.printStackTrace();
            System.out.println("  For message: " + mes);
        }
    }

    protected void handleSTATUSMESSAGE(SOCStatusMessage mes) {
        if (mes.getStatusValue() == 23) {
            this.disconnect();
        }
    }

    protected void handleSERVERPING(SOCServerPing mes) {
        long now = System.currentTimeMillis();
        boolean hidePingDebug = this.debugTraffic && this.nextServerPingExpectedAt != 0L && Math.abs(now - this.nextServerPingExpectedAt) <= 66000L;
        this.nextServerPingExpectedAt = now + (long)mes.getSleepTime();
        if (hidePingDebug) {
            this.debugTraffic = false;
        }
        this.put(mes.toCmd());
        if (hidePingDebug) {
            this.debugTraffic = true;
        }
    }

    protected void handleJOINCHANNELAUTH(SOCJoinChannelAuth mes) {
        this.gotPassword = true;
    }

    protected void handleVERSION(boolean isLocal, SOCVersion mes) {
        SOCFeatureSet feats;
        D.ebugPrintlnINFO("handleVERSION: " + mes);
        int vers = mes.getVersionNumber();
        SOCFeatureSet sOCFeatureSet = feats = vers >= 1119 ? new SOCFeatureSet(mes.feats) : new SOCFeatureSet(true, true);
        if (isLocal) {
            this.sLocalVersion = vers;
            this.sLocalFeatures = feats;
        } else {
            this.sVersion = vers;
            this.sFeatures = feats;
        }
        int ourVers = Version.versionNumber();
        if (vers != ourVers) {
            String errmsg = "Internal error SOCDisplaylessPlayerClient.handleVERSION: Server must be same as our version " + ourVers + ", not " + vers;
            System.err.println(errmsg);
            this.ex = new IllegalStateException(errmsg);
            this.destroy();
        }
    }

    protected void handleJOINCHANNEL(SOCJoinChannel mes) {
    }

    protected void handleCHANNELMEMBERS(SOCChannelMembers mes) {
    }

    protected void handleNEWCHANNEL(SOCNewChannel mes) {
    }

    protected void handleCHANNELS(SOCChannels mes) {
    }

    protected void handleBCASTTEXTMSG(SOCBCastTextMsg mes) {
    }

    protected void handleCHANNELTEXTMSG(SOCChannelTextMsg mes) {
    }

    protected void handleLEAVECHANNEL(SOCLeaveChannel mes) {
    }

    protected void handleDELETECHANNEL(SOCDeleteChannel mes) {
    }

    protected void handleGAMES(SOCGames mes) {
    }

    protected void handleGAMESWITHOPTIONS(SOCGamesWithOptions mes) {
    }

    protected void handleJOINGAMEAUTH(SOCJoinGameAuth mes, boolean isPractice) {
        SOCGameOptionSet opts;
        this.gotPassword = true;
        int bh = mes.getBoardHeight();
        int bw = mes.getBoardWidth();
        if (bh != 0 || bw != 0) {
            opts = new SOCGameOptionSet();
            SOCGameOption opt = this.knownOpts.getKnownOption("_BHW", true);
            opt.setIntValue(bh << 8 | bw);
            opts.put(opt);
        } else {
            opts = null;
        }
        SOCGame ga = new SOCGame(mes.getGame(), opts, this.knownOpts);
        ga.isPractice = isPractice;
        ga.serverVersion = isPractice ? this.sLocalVersion : this.sVersion;
        this.games.put(mes.getGame(), ga);
    }

    protected void handleJOINGAME(SOCJoinGame mes) {
    }

    protected void handleLEAVEGAME(SOCLeaveGame mes) {
        String gn = mes.getGame();
        SOCGame ga = this.games.get(gn);
        if (ga == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(mes.getNickname());
        if (player != null) {
            ga.removePlayer(mes.getNickname(), false);
        }
    }

    protected void handleNEWGAME(SOCNewGame mes) {
    }

    protected void handleNEWGAMEWITHOPTIONS(SOCNewGameWithOptions mes) {
    }

    protected void handleDELETEGAME(SOCDeleteGame mes) {
    }

    protected void handleGAMEMEMBERS(SOCGameMembers mes) {
    }

    protected void handleGAMESTATS(SOCGameStats mes) {
        SOCDisplaylessPlayerClient.handleGAMESTATS(mes, this.games.get(mes.getGame()));
    }

    public static final void handleGAMESTATS(SOCGameStats mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        if (mes.getStatType() != 2) {
            return;
        }
        long[] stats = mes.getScores();
        long timeCreated = stats[0];
        long timeFinished = stats[2];
        long timeNow = System.currentTimeMillis() / 1000L;
        if (timeCreated > timeNow) {
            return;
        }
        ga.setTimeSinceCreated((int)(timeNow - timeCreated));
        if (timeFinished > timeCreated) {
            ga.setDurationSecondsFinished((int)(timeFinished - timeCreated));
        }
    }

    protected void handleGAMETEXTMSG(SOCGameTextMsg mes) {
    }

    protected void handleGAMESERVERTEXT(SOCGameServerText mes) {
    }

    protected void handleDICERESULTRESOURCES(SOCDiceResultResources mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handleDICERESULTRESOURCES(mes, ga, this.nickname, false);
    }

    public static final void handleDICERESULTRESOURCES(SOCDiceResultResources mes, SOCGame ga, String nickname, boolean skipResourceCount) {
        int n = mes.playerNum.size();
        for (int p = 0; p < n; ++p) {
            SOCResourceSet rs = mes.playerRsrc.get(p);
            int pn = mes.playerNum.get(p);
            SOCPlayer pl = ga.getPlayer(pn);
            pl.addRolledResources(rs);
            if (skipResourceCount) continue;
            SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, pl, pn, 100, SOCPlayerElement.PEType.RESOURCE_COUNT, mes.playerResTotal.get(p), nickname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SOCGame handleSITDOWN(SOCSitDown mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return null;
        }
        int pn = mes.getPlayerNumber();
        String plName = mes.getNickname();
        SOCPlayer player = null;
        ga.takeMonitor();
        try {
            ga.addPlayer(plName, pn);
            player = ga.getPlayer(pn);
            player.setRobotFlag(mes.isRobot(), false);
        }
        catch (Exception e) {
            System.out.println("Exception caught - " + e);
            e.printStackTrace();
            SOCGame sOCGame = null;
            return sOCGame;
        }
        finally {
            ga.releaseMonitor();
        }
        if (this.nickname.equals(plName) && (ga.isPractice || this.sVersion >= 2300)) {
            player.getInventory().clear();
        }
        return ga;
    }

    public static void handleBOARDLAYOUT(SOCBoardLayout mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        SOCBoard bd = ga.getBoard();
        bd.setHexLayout(mes.getHexLayout());
        bd.setNumberLayout(mes.getNumberLayout());
        bd.setRobberHex(mes.getRobberHex(), false);
        ga.updateAtBoardLayout();
    }

    public static boolean handleBOARDLAYOUT2(SOCBoardLayout2 mes, SOCGame ga) {
        if (ga == null) {
            return false;
        }
        SOCBoard bd = ga.getBoard();
        int bef = mes.getBoardEncodingFormat();
        if (bef == 3) {
            HashMap<String, int[]> others;
            int[] x;
            int[] portLayout;
            ((SOCBoardLarge)bd).setLandHexLayout(mes.getIntArrayPart("LH"));
            ga.setPlayersLandHexCoordinates();
            int hex = mes.getIntPart("RH");
            if (hex != 0) {
                bd.setRobberHex(hex, false);
            }
            if ((hex = mes.getIntPart("PH")) != 0) {
                ((SOCBoardLarge)bd).setPirateHex(hex, false);
            }
            if ((portLayout = mes.getIntArrayPart("PL")) != null) {
                bd.setPortsLayout(portLayout);
            }
            if ((x = mes.getIntArrayPart("PX")) != null) {
                ((SOCBoardLarge)bd).setPlayerExcludedLandAreas(x);
            }
            if ((x = mes.getIntArrayPart("RX")) != null) {
                ((SOCBoardLarge)bd).setRobberExcludedLandAreas(x);
            }
            if ((x = mes.getIntArrayPart("CV")) != null) {
                ((SOCBoardLarge)bd).setVillageAndClothLayout(x);
            }
            if ((x = mes.getIntArrayPart("LS")) != null) {
                ((SOCBoardLarge)bd).addLoneLegalSettlements(ga, x);
            }
            if ((others = mes.getAddedParts()) != null) {
                ((SOCBoardLarge)bd).setAddedLayoutParts(others);
            }
        } else if (bef <= 2) {
            bd.setHexLayout(mes.getIntArrayPart("HL"));
            bd.setNumberLayout(mes.getIntArrayPart("NL"));
            bd.setRobberHex(mes.getIntPart("RH"), false);
            int[] portLayout = mes.getIntArrayPart("PL");
            if (portLayout != null) {
                bd.setPortsLayout(portLayout);
            }
        } else {
            System.err.println("Cannot recognize game encoding v" + bef + " for game " + ga.getName());
            return false;
        }
        ga.updateAtBoardLayout();
        return true;
    }

    protected static void handleSTARTGAME(Hashtable<String, SOCGame> games, SOCStartGame mes) {
        SOCGame ga = games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handleGAMESTATE(ga, mes.getGameState());
        SOCDisplaylessPlayerClient.handleSTARTGAME_checkIsBotsOnly(ga);
    }

    public static final void handleSTARTGAME_checkIsBotsOnly(SOCGame ga) {
        boolean isBotsOnly = true;
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            if (ga.isSeatVacant(pn) || ga.getPlayer(pn).isRobot()) continue;
            isBotsOnly = false;
            break;
        }
        ga.isBotsOnly = isBotsOnly;
    }

    protected void handleGAMESTATE(SOCGameState mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga != null) {
            SOCDisplaylessPlayerClient.handleGAMESTATE(ga, mes.getState());
        }
    }

    public static void handleGAMESTATE(SOCGame ga, int newState) {
        if (newState == 0) {
            return;
        }
        ga.setGameState(newState);
    }

    public static void handleDECLINEPLAYERREQUEST(SOCDeclinePlayerRequest mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        int currState = mes.gameState;
        if (currState != 0 && currState != ga.getGameState()) {
            SOCDisplaylessPlayerClient.handleGAMESTATE(ga, currState);
        }
    }

    protected void handleSETTURN(SOCSetTurn mes) {
        SOCDisplaylessPlayerClient.handleGAMEELEMENT(this.games.get(mes.getGame()), SOCGameElements.GEType.CURRENT_PLAYER, mes.getPlayerNumber());
    }

    protected void handleFIRSTPLAYER(SOCFirstPlayer mes) {
        SOCDisplaylessPlayerClient.handleGAMEELEMENT(this.games.get(mes.getGame()), SOCGameElements.GEType.FIRST_PLAYER, mes.getPlayerNumber());
    }

    protected void handleTURN(SOCTurn mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handleGAMESTATE(ga, mes.getGameState());
        ga.setCurrentPlayerNumber(mes.getPlayerNumber());
        ga.updateAtTurn();
    }

    protected void handlePLAYERELEMENTS(SOCPlayerElements mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int pn = mes.getPlayerNumber();
        SOCPlayer pl = pn != -1 ? ga.getPlayer(pn) : null;
        int action = mes.getAction();
        int[] etypes = mes.getElementTypes();
        int[] amounts = mes.getAmounts();
        for (int i = 0; i < etypes.length; ++i) {
            SOCDisplaylessPlayerClient.handlePLAYERELEMENT(ga, pl, pn, action, SOCPlayerElement.PEType.valueOf(etypes[i]), amounts[i], this.nickname);
        }
        if (action == 100 && etypes.length == 5 && etypes[0] == 1 && pl != null && ga.getGameState() == 15) {
            pl.getResources().setAmount(0, 6);
        }
    }

    protected void handlePLAYERELEMENT(SOCPlayerElement mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int pn = mes.getPlayerNumber();
        int action = mes.getAction();
        int amount = mes.getAmount();
        SOCPlayerElement.PEType etype = SOCPlayerElement.PEType.valueOf(mes.getElementType());
        SOCDisplaylessPlayerClient.handlePLAYERELEMENT(ga, null, pn, action, etype, amount, this.nickname);
    }

    public static final void handlePLAYERELEMENT(SOCGame ga, SOCPlayer pl, int pn, int action, SOCPlayerElement.PEType etype, int amount, String nickname) {
        if (ga == null || etype == null) {
            return;
        }
        if (pl == null && pn != -1) {
            pl = ga.getPlayer(pn);
        }
        switch (etype) {
            case ROADS: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 0, amount);
                break;
            }
            case SETTLEMENTS: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 1, amount);
                break;
            }
            case CITIES: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 2, amount);
                break;
            }
            case SHIPS: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 3, amount);
                break;
            }
            case NUMKNIGHTS: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numKnights(ga, pl, action, amount);
                break;
            }
            case CLAY: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 1, amount);
                break;
            }
            case ORE: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 2, amount);
                break;
            }
            case SHEEP: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 3, amount);
                break;
            }
            case WHEAT: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 4, amount);
                break;
            }
            case WOOD: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 5, amount);
                break;
            }
            case UNKNOWN_RESOURCE: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 6, amount);
                break;
            }
            default: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, pl, pn, action, etype, amount, nickname);
            }
        }
    }

    public static void handlePLAYERELEMENT_simple(SOCGame ga, SOCPlayer pl, int pn, int action, SOCPlayerElement.PEType etype, int val, String cliNickname) {
        if (etype == null) {
            return;
        }
        if (pl == null && pn != -1) {
            pl = ga.getPlayer(pn);
        }
        block1 : switch (etype) {
            case ASK_SPECIAL_BUILD: {
                if (0 != val) {
                    try {
                        ga.askSpecialBuild(pn, false);
                    }
                    catch (RuntimeException runtimeException) {}
                    break;
                }
                pl.setAskedSpecialBuild(false);
                break;
            }
            case HAS_SPECIAL_BUILT: {
                pl.setSpecialBuilt(0 != val);
                break;
            }
            case RESOURCE_COUNT: {
                SOCResourceSet rsrcs = pl.getResources();
                if (val == rsrcs.getTotal() || cliNickname != null && pl.getName().equals(cliNickname)) break;
                int numKnown = rsrcs.getKnownTotal();
                if (numKnown <= val) {
                    rsrcs.setAmount(val - numKnown, 6);
                    break;
                }
                rsrcs.clear();
                rsrcs.setAmount(val, 6);
                break;
            }
            case LAST_SETTLEMENT_NODE: {
                pl.setLastSettlementCoord(val);
                break;
            }
            case PLAYED_DEV_CARD_FLAG: {
                boolean changeTo;
                boolean bl = changeTo = val != 0;
                if (pn != -1) {
                    pl.setPlayedDevCard(changeTo);
                    if (changeTo) break;
                    ga.setPlacingRobberForKnightCard(false);
                    break;
                }
                for (int p = 0; p < ga.maxPlayers; ++p) {
                    ga.getPlayer(p).setPlayedDevCard(changeTo);
                }
                break;
            }
            case DISCARD_FLAG: {
                pl.setNeedToDiscard(val != 0);
                break;
            }
            case NUM_PLAYED_DEV_CARD_DISC: {
                pl.numDISCCards = val;
                break;
            }
            case NUM_PLAYED_DEV_CARD_MONO: {
                pl.numMONOCards = val;
                break;
            }
            case NUM_PLAYED_DEV_CARD_ROADS: {
                pl.numRBCards = val;
                break;
            }
            case NUM_UNDOS_REMAINING: {
                pl.setUndosRemaining(val);
                break;
            }
            case NUM_PICK_GOLD_HEX_RESOURCES: {
                pl.setNeedToPickGoldHexResources(val);
                break;
            }
            case SCENARIO_SVP: {
                pl.setSpecialVP(val);
                break;
            }
            case PLAYEREVENTS_BITMASK: {
                pl.setPlayerEvents(val);
                break;
            }
            case SCENARIO_SVP_LANDAREAS_BITMASK: {
                pl.setScenarioSVPLandAreas(val);
                break;
            }
            case STARTING_LANDAREAS: {
                pl.setStartingLandAreasEncoded(val);
                break;
            }
            case SCENARIO_CLOTH_COUNT: {
                if (pn != -1) {
                    pl.setCloth(val);
                    break;
                }
                ((SOCBoardLarge)ga.getBoard()).setCloth(val);
                break;
            }
            case SCENARIO_WARSHIP_COUNT: {
                switch (action) {
                    case 100: {
                        int prevNum = pl.getNumWarships();
                        pl.setNumWarships(val);
                        if (val >= prevNum) break block1;
                        ga.setLastAction(null);
                        break;
                    }
                    case 101: {
                        pl.setNumWarships(pl.getNumWarships() + val);
                        ga.setLastAction(new GameAction(GameAction.ActionType.SHIP_CONVERT_TO_WARSHIP));
                    }
                }
                break;
            }
        }
    }

    public static void handlePLAYERELEMENT_numPieces(SOCPlayer pl, int action, int pieceType, int amount) {
        switch (action) {
            case 100: {
                pl.setNumPieces(pieceType, amount);
                break;
            }
            case 101: {
                pl.setNumPieces(pieceType, pl.getNumPieces(pieceType) + amount);
                break;
            }
            case 102: {
                pl.setNumPieces(pieceType, pl.getNumPieces(pieceType) - amount);
            }
        }
    }

    public static void handlePLAYERELEMENT_numKnights(SOCGame ga, SOCPlayer pl, int action, int amount) {
        switch (action) {
            case 100: {
                pl.setNumKnights(amount);
                break;
            }
            case 101: {
                pl.setNumKnights(pl.getNumKnights() + amount);
                break;
            }
            case 102: {
                pl.setNumKnights(pl.getNumKnights() - amount);
            }
        }
        ga.updateLargestArmy();
    }

    public static void handlePLAYERELEMENT_numRsrc(SOCPlayer pl, int action, int rtype, int amount) {
        switch (action) {
            case 100: {
                pl.getResources().setAmount(amount, rtype);
                break;
            }
            case 101: {
                pl.getResources().add(amount, rtype);
                break;
            }
            case 102: {
                pl.getResources().subtract(amount, rtype, true);
            }
        }
    }

    protected void handleGAMEELEMENTS(SOCGameElements mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int[] etypes = mes.getElementTypes();
        int[] values = mes.getValues();
        for (int i = 0; i < etypes.length; ++i) {
            SOCDisplaylessPlayerClient.handleGAMEELEMENT(ga, SOCGameElements.GEType.valueOf(etypes[i]), values[i]);
        }
    }

    public static final void handleGAMEELEMENT(SOCGame ga, SOCGameElements.GEType etype, int value) {
        if (ga == null || etype == null) {
            return;
        }
        switch (etype) {
            case ROUND_COUNT: {
                ga.setRoundCount(value);
                break;
            }
            case DEV_CARD_COUNT: {
                ga.setNumDevCards(value);
                break;
            }
            case FIRST_PLAYER: {
                ga.setFirstPlayer(value);
                break;
            }
            case CURRENT_PLAYER: {
                ga.setCurrentPlayerNumber(value);
                break;
            }
            case LARGEST_ARMY_PLAYER: {
                ga.setPlayerWithLargestArmy(value != -1 ? ga.getPlayer(value) : null);
                break;
            }
            case LONGEST_ROAD_PLAYER: {
                ga.setPlayerWithLongestRoad(value != -1 ? ga.getPlayer(value) : null);
                break;
            }
            case SPECIAL_BUILDING_AFTER_PLAYER: {
                ga.setSpecialBuildingPlayerNumberAfter(value);
                break;
            }
            case SHIP_PLACED_THIS_TURN_EDGE: {
                ga.addShipPlacedThisTurn(value);
                break;
            }
            case IS_PLACING_ROBBER_FOR_KNIGHT_CARD_FLAG: {
                ga.setPlacingRobberForKnightCard(value != 0);
                break;
            }
            case HAS_BUILT_CITY_N7C: {
                ga.setHasBuiltCity(value != 0);
                break;
            }
        }
    }

    protected void handleRESOURCECOUNT(SOCResourceCount mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, null, mes.getPlayerNumber(), 100, SOCPlayerElement.PEType.RESOURCE_COUNT, mes.getCount(), this.nickname);
    }

    public static final void handleLASTSETTLEMENT(SOCLastSettlement mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, null, mes.getPlayerNumber(), 100, SOCPlayerElement.PEType.LAST_SETTLEMENT_NODE, mes.getCoordinates(), null);
    }

    protected void handleDICERESULT(SOCDiceResult mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        ga.setCurrentDice(mes.getResult());
    }

    public static void handlePUTPIECE(SOCPutPiece mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        int pieceType = mes.getPieceType();
        int coord = mes.getCoordinates();
        SOCPlayer pl = pieceType != 5 ? ga.getPlayer(mes.getPlayerNumber()) : null;
        switch (pieceType) {
            case 0: {
                ga.putPiece(new SOCRoad(pl, coord, null));
                break;
            }
            case 1: {
                ga.putPiece(new SOCSettlement(pl, coord, null));
                break;
            }
            case 2: {
                ga.putPiece(new SOCCity(pl, coord, null));
                break;
            }
            case 3: {
                ga.putPiece(new SOCShip(pl, coord, null));
                break;
            }
            case 4: {
                ga.putPiece(new SOCFortress(pl, coord, ga.getBoard()));
                break;
            }
            case 5: {
                ga.putPiece(new SOCVillage(coord, ga.getBoard()));
                break;
            }
            default: {
                System.err.println("Displayless.handlePUTPIECE: game " + ga.getName() + ": Unknown pieceType " + pieceType);
            }
        }
    }

    protected void handleCANCELBUILDREQUEST(SOCCancelBuildRequest mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int sta = ga.getGameState();
        if (sta != 6 && sta != 11 && sta != 13) {
            return;
        }
        if (mes.getPieceType() != 1) {
            return;
        }
        SOCPlayer pl = ga.getPlayer(ga.getCurrentPlayerNumber());
        SOCSettlement pp = new SOCSettlement(pl, pl.getLastSettlementCoord(), null);
        ga.undoPutInitSettlement(pp);
    }

    public static SOCPlayer handleDISCARD(SOCDiscard mes, SOCGame ga) {
        if (ga == null) {
            return null;
        }
        int pn = mes.getPlayerNumber();
        if (pn < 0 || pn >= ga.maxPlayers) {
            return null;
        }
        SOCPlayer pl = ga.getPlayer(pn);
        ResourceSet res = mes.getResources();
        for (int rtype = 1; rtype <= 6; ++rtype) {
            int amount = res.getAmount(rtype);
            if (amount == 0) continue;
            SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, 102, rtype, amount);
        }
        return pl;
    }

    protected void handleMOVEROBBER(SOCMoveRobber mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        ga.setPlacingRobberForKnightCard(false);
        ga.setLastAction(null);
        int newHex = mes.getCoordinates();
        if (newHex > 0) {
            ga.getBoard().setRobberHex(newHex, true);
        } else {
            ((SOCBoardLarge)ga.getBoard()).setPirateHex(-newHex, true);
        }
    }

    protected void handleDISCARDREQUEST(SOCDiscardRequest mes) {
    }

    protected void handleCHOOSEPLAYERREQUEST(SOCChoosePlayerRequest mes) {
    }

    public static void handleROBBERYRESULT(SOCRobberyResult mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        int perpPN = mes.perpPN;
        int victimPN = mes.victimPN;
        int amount = mes.amount;
        SOCResourceSet resSet = mes.resSet;
        if (mes.isGainLose && amount == 0 && resSet == null) {
            return;
        }
        SOCPlayer perp = perpPN >= 0 ? ga.getPlayer(perpPN) : null;
        SOCPlayer victim = victimPN >= 0 ? ga.getPlayer(victimPN) : null;
        SOCPlayerElement.PEType peType = mes.peType;
        if (peType != null) {
            if (mes.isGainLose) {
                if (perp != null) {
                    SOCDisplaylessPlayerClient.handlePLAYERELEMENT(ga, perp, perpPN, 101, peType, amount, null);
                }
                if (victim != null) {
                    SOCDisplaylessPlayerClient.handlePLAYERELEMENT(ga, victim, victimPN, 102, peType, amount, null);
                }
            } else {
                if (perp != null) {
                    SOCDisplaylessPlayerClient.handlePLAYERELEMENT(ga, perp, perpPN, 100, peType, amount, null);
                }
                if (victim != null) {
                    SOCDisplaylessPlayerClient.handlePLAYERELEMENT(ga, victim, victimPN, 100, peType, mes.victimAmount, null);
                }
            }
        } else if (resSet != null) {
            for (int rtype = 1; rtype <= 5; ++rtype) {
                int amt = resSet.getAmount(rtype);
                if (amt == 0) continue;
                if (perp != null) {
                    SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(perp, 101, rtype, amt);
                }
                if (victim == null) continue;
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(victim, 102, rtype, amt);
            }
        } else {
            int resType = mes.resType;
            if (mes.isGainLose) {
                if (perp != null) {
                    SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(perp, 101, resType, amount);
                }
                if (victim != null) {
                    SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(victim, 102, resType, amount);
                }
            } else {
                if (perp != null) {
                    SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(perp, 100, resType, amount);
                }
                if (victim != null) {
                    SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(victim, 100, resType, mes.victimAmount);
                }
            }
        }
    }

    protected void handleMAKEOFFER(SOCMakeOffer mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCTradeOffer offer = mes.getOffer();
        ga.getPlayer(offer.getFrom()).setCurrentOffer(offer);
    }

    protected void handleCLEAROFFER(SOCClearOffer mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int pn = mes.getPlayerNumber();
        if (pn != -1) {
            ga.getPlayer(pn).setCurrentOffer(null);
        } else {
            for (int i = 0; i < ga.maxPlayers; ++i) {
                ga.getPlayer(i).setCurrentOffer(null);
            }
        }
    }

    protected void handleREJECTOFFER(SOCRejectOffer mes) {
    }

    public static void handleACCEPTOFFER(SOCAcceptOffer mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        SOCResourceSet resToAccPl = mes.getResToAcceptingPlayer();
        if (resToAccPl == null) {
            return;
        }
        int offPN = mes.getOfferingNumber();
        int accPN = mes.getAcceptingNumber();
        SOCResourceSet resToOffPl = mes.getResToOfferingPlayer();
        SOCPlayer offPl = ga.getPlayer(offPN);
        SOCTradeOffer offOffered = offPl.getCurrentOffer();
        if (offOffered != null && resToOffPl.equals(offOffered.getGetSet()) && resToAccPl.equals(offOffered.getGiveSet())) {
            ga.makeTrade(offPN, accPN);
        } else {
            SOCResourceSet accPlRes = ga.getPlayer(accPN).getResources();
            SOCResourceSet offPlRes = offPl.getResources();
            accPlRes.add(resToAccPl);
            accPlRes.subtract(resToOffPl, true);
            offPlRes.add(resToOffPl);
            offPlRes.subtract(resToAccPl, true);
        }
    }

    protected void handleCLEARTRADEMSG(SOCClearTradeMsg mes) {
    }

    public static boolean handleBANKTRADE(SOCBankTrade mes, SOCGame ga) {
        if (ga == null) {
            return false;
        }
        ga.setLastAction(null);
        ga.getPlayer(mes.getPlayerNumber()).makeBankTrade(mes.getGiveSet(), mes.getGetSet());
        return true;
    }

    protected void handleDEVCARDCOUNT(SOCDevCardCount mes) {
        SOCDisplaylessPlayerClient.handleGAMEELEMENT(this.games.get(mes.getGame()), SOCGameElements.GEType.DEV_CARD_COUNT, mes.getNumDevCards());
    }

    protected void handleDEVCARDACTION(boolean isPractice, SOCDevCardAction mes) {
        if (mes.getCardTypes() != null) {
            return;
        }
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
        int ctype = mes.getCardType();
        if (!isPractice && this.sVersion < 2000) {
            if (ctype == 0) {
                ctype = 9;
            } else if (ctype == 9) {
                ctype = 0;
            }
        }
        this.handleDEVCARDACTION(ga, player, mes.getAction(), ctype);
    }

    protected void handleDEVCARDACTION(SOCGame ga, SOCPlayer player, int act, int ctype) {
        switch (act) {
            case 0: {
                player.getInventory().addDevCard(1, 1, ctype);
                break;
            }
            case 1: {
                player.getInventory().removeDevCard(0, ctype);
                player.updateDevCardsPlayed(ctype, false);
                if (ctype != 9 || ga.isGameOptionSet("_SC_PIRI")) break;
                ga.setPlacingRobberForKnightCard(true);
                break;
            }
            case 3: {
                player.getInventory().addDevCard(1, 0, ctype);
                break;
            }
            case 2: {
                player.getInventory().addDevCard(1, 1, ctype);
                break;
            }
            case 6: {
                player.getInventory().removeDevCard(0, ctype);
                break;
            }
            case 5: {
                player.getInventory().removeDevCard(1, ctype);
            }
        }
    }

    protected void handleSETPLAYEDDEVCARD(SOCSetPlayedDevCard mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, null, mes.getPlayerNumber(), 100, SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, mes.hasPlayedDevCard() ? 1 : 0, null);
    }

    public static boolean handlePICKRESOURCES(SOCPickResources mes, SOCGame ga) {
        SOCPlayer pl = ga.getPlayer(mes.getPlayerNumber());
        if (pl == null) {
            return false;
        }
        if (ga.getGameState() == 52) {
            ga.setLastAction(null);
        }
        pl.getResources().add(mes.getResources());
        return true;
    }

    public static boolean handleINVENTORYITEMACTION(Hashtable<String, SOCGame> games, SOCInventoryItemAction mes) {
        SOCGame ga = games.get(mes.getGame());
        if (ga == null) {
            return false;
        }
        if (mes.playerNumber == -1 || mes.action == 5) {
            return true;
        }
        SOCPlayer pl = ga.getPlayer(mes.playerNumber);
        if (pl == null) {
            return false;
        }
        SOCInventory inv = pl.getInventory();
        SOCInventoryItem item = null;
        switch (mes.action) {
            case 2: 
            case 3: {
                inv.addItem(SOCInventoryItem.createForScenario(ga, mes.itemType, mes.action == 2, mes.isKept, mes.isVP, mes.canCancelPlay));
                break;
            }
            case 6: {
                if (mes.isKept) {
                    inv.keepPlayedItem(mes.itemType);
                } else {
                    item = inv.removeItem(2, mes.itemType);
                }
                if (!SOCInventoryItem.isPlayForPlacement(ga, mes.itemType)) break;
            }
            case 7: {
                if (item == null) {
                    item = SOCInventoryItem.createForScenario(ga, mes.itemType, true, mes.isKept, mes.isVP, mes.canCancelPlay);
                }
                ga.setPlacingItem(item);
                break;
            }
            case 8: {
                inv.removeItem(2, mes.itemType);
                break;
            }
            case 9: {
                inv.removeItem(mes.isKept ? 3 : 1, mes.itemType);
            }
        }
        return false;
    }

    public static void handlePOTENTIALSETTLEMENTS(SOCPotentialSettlements mes, SOCGame ga) throws IllegalStateException {
        SOCPlayer pl;
        int[] loneSettles;
        if (ga == null) {
            return;
        }
        List<Integer> ps = mes.getPotentialSettlements(false);
        HashSet<Integer>[] lan = mes.landAreasLegalNodes;
        int[][] legalSeaEdges = mes.legalSeaEdges;
        int pn = mes.getPlayerNumber();
        if (ga.hasSeaBoard) {
            SOCBoardLarge bl = (SOCBoardLarge)ga.getBoard();
            if (pn == -1 || pn == 0 && bl.getLegalSettlements().isEmpty()) {
                bl.setLegalSettlements(ps, mes.startingLandArea, lan);
            }
            loneSettles = bl.getAddedLayoutPart("LS");
        } else {
            loneSettles = null;
        }
        if (ps == null) {
            ps = mes.getPotentialSettlements(true);
        }
        if (pn != -1) {
            pl = ga.getPlayer(pn);
            pl.setPotentialAndLegalSettlements(ps, true, lan);
            if (loneSettles != null) {
                pl.addLegalSettlement(loneSettles[pn], false);
            }
            if (legalSeaEdges != null) {
                pl.setRestrictedLegalShips(legalSeaEdges[0]);
            }
        } else {
            for (pn = ga.maxPlayers - 1; pn >= 0; --pn) {
                pl = ga.getPlayer(pn);
                pl.setPotentialAndLegalSettlements(ps, true, lan);
                if (loneSettles != null) {
                    pl.addLegalSettlement(loneSettles[pn], false);
                }
                if (legalSeaEdges == null) continue;
                pl.setRestrictedLegalShips(legalSeaEdges[pn]);
            }
        }
    }

    protected void handleCHANGEFACE(SOCChangeFace mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
        player.setFaceId(mes.getFaceId());
    }

    protected void handleREJECTCONNECTION(SOCRejectConnection mes) {
        this.rejected = true;
        System.err.println("Rejected by server: " + mes.getText());
        this.disconnect();
    }

    protected void handleLONGESTROAD(SOCLongestRoad mes) {
        SOCDisplaylessPlayerClient.handleGAMEELEMENT(this.games.get(mes.getGame()), SOCGameElements.GEType.LONGEST_ROAD_PLAYER, mes.getPlayerNumber());
    }

    protected void handleLARGESTARMY(SOCLargestArmy mes) {
        SOCDisplaylessPlayerClient.handleGAMEELEMENT(this.games.get(mes.getGame()), SOCGameElements.GEType.LARGEST_ARMY_PLAYER, mes.getPlayerNumber());
    }

    protected void handleSETSEATLOCK(SOCSetSeatLock mes) {
        SOCGame ga = this.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCGame.SeatLockState[] sls = mes.getLockStates();
        if (sls == null) {
            ga.setSeatLock(mes.getPlayerNumber(), mes.getLockState());
        } else {
            ga.setSeatLocks(sls);
        }
    }

    protected void handleRESETBOARDAUTH(SOCResetBoardAuth mes) {
        String gname = mes.getGame();
        SOCGame ga = this.games.get(gname);
        if (ga == null) {
            return;
        }
        SOCGame greset = ga.resetAsCopy();
        greset.isPractice = ga.isPractice;
        this.games.put(gname, greset);
        ga.destroyGame();
    }

    protected void handleGAMEOPTIONINFO(SOCGameOptionInfo optInfo) {
        SOCGameOption opt = optInfo.getOptionInfo();
        if (opt.key.equals("-") && opt.optType == 0) {
            this.allOptsReceived = true;
        } else {
            if (this.allOptsReceived) {
                this.allOptsReceived = false;
            }
            this.knownOpts.addKnownOption(opt);
        }
    }

    public static void handleSETLASTACTION(SOCSetLastAction mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        GameAction.ActionType at = GameAction.ActionType.valueOf(mes.getActionTypeValue());
        if (at == null) {
            ga.setLastAction(null);
        } else {
            ga.setLastAction(new GameAction(at, mes.getParam1(), mes.getParam2(), mes.getParam3(), mes.getRS1(), mes.getRS2()));
        }
    }

    public static void handleUNDONOTALLOWEDREASONTEXT(SOCUndoNotAllowedReasonText mes, SOCGame ga) {
        String reason;
        if (ga == null) {
            return;
        }
        if (!mes.isNotAllowed) {
            reason = null;
        } else {
            reason = mes.reason;
            if (reason == null) {
                reason = "?";
            }
        }
        ga.setLastActionCannotUndo(reason);
    }

    public static void handlePLAYERSTATS(SOCPlayerStats mes, SOCGame ga, int clientPN) {
        if (ga == null || clientPN == -1) {
            return;
        }
        SOCPlayer pl = ga.getPlayer(clientPN);
        int[] stats = mes.getParams();
        switch (mes.getStatType()) {
            case 1: {
                int[] rollStats = new int[7];
                int rMax = 6;
                if (rMax >= stats.length) {
                    rMax = stats.length - 1;
                }
                for (int rtype = 1; rtype <= rMax; ++rtype) {
                    rollStats[rtype] = stats[rtype];
                }
                pl.setResourceRollStats(rollStats);
                break;
            }
            case 2: {
                int subArrLen = stats[1];
                int resArrLen = subArrLen / 2;
                int numTypes = (stats.length - 2) / subArrLen;
                ResourceSet[][] tradeStats = new SOCResourceSet[2][numTypes];
                int i = 2;
                int tradeType = 0;
                while (i < stats.length) {
                    tradeStats[0][tradeType] = new SOCResourceSet(stats[i], stats[i + 1], stats[i + 2], stats[i + 3], stats[i + 4], 0);
                    tradeStats[1][tradeType] = new SOCResourceSet(stats[i += resArrLen], stats[i + 1], stats[i + 2], stats[i + 3], stats[i + 4], 0);
                    i -= resArrLen;
                    i += subArrLen;
                    ++tradeType;
                }
                pl.setResourceTradeStats(tradeStats);
            }
        }
    }

    public static void handleSIMPLEREQUEST(SOCSimpleRequest mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        int pn = mes.getPlayerNumber();
        int rtype = mes.getRequestType();
        int value1 = mes.getValue1();
        int value2 = mes.getValue2();
        switch (rtype) {
            case 1001: {
                if (pn < 0) break;
                ga.placePort(ga.getPlayer(pn), value1, value2);
                break;
            }
            case 1: 
            case 1000: {
                break;
            }
            default: {
                System.err.println("DPC.handleSIMPLEREQUEST: Unknown type ignored: " + rtype + " in game " + ga.getName());
            }
        }
    }

    public static void handleSIMPLEACTION(SOCSimpleAction mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        int atype = mes.getActionType();
        switch (atype) {
            case 4: {
                SOCBoard bd = ga.getBoard();
                if (!(bd instanceof SOCBoardLarge)) break;
                ((SOCBoardLarge)bd).setSpecialEdge(mes.getValue1(), mes.getValue2());
                break;
            }
            case 1002: {
                if (!ga.hasSeaBoard) break;
                ga.removePort(null, mes.getValue1());
                break;
            }
            case 1: {
                ga.setLastAction(null);
                ga.setNumDevCards(mes.getValue1());
                break;
            }
            case 1003: {
                SOCVillage vi;
                SOCBoard bd = ga.getBoard();
                if (!(bd instanceof SOCBoardLarge) || (vi = ((SOCBoardLarge)bd).getVillageAtNode(mes.getValue1())) == null) break;
                vi.removeTradingPlayer(ga.getPlayer(mes.getPlayerNumber()));
                break;
            }
            case 3: {
                ga.setLastAction(null);
                break;
            }
            case 1001: {
                break;
            }
            default: {
                if (mes.getPlayerNumber() < 0) break;
                System.err.println("handleSIMPLEACTION: Unknown type ignored: " + atype + " in game " + ga.getName());
            }
        }
    }

    protected void handleMOVEPIECE(SOCMovePiece mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.games.get(gaName);
        if (ga == null) {
            return;
        }
        SOCShip sh = new SOCShip(ga.getPlayer(mes.getPlayerNumber()), mes.getFromCoord(), null);
        ga.moveShip(sh, mes.getToCoord());
    }

    protected void handleREMOVEPIECE(SOCRemovePiece mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.games.get(gaName);
        if (ga == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(mes.getParam1());
        int pieceType = mes.getParam2();
        int pieceCoordinate = mes.getParam3();
        switch (pieceType) {
            case 3: {
                ga.removeShip(new SOCShip(player, pieceCoordinate, null));
                break;
            }
            default: {
                System.err.println("Displayless.updateAtPieceRemoved called for un-handled type " + pieceType);
            }
        }
    }

    public static void handleUNDOPUTPIECE(SOCUndoPutPiece mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        if (mes.getPlayerNumber() < 0) {
            return;
        }
        SOCBoard board = ga.getBoard();
        int pieceCurrCoord = mes.getCoordinates();
        int movedFromCoord = mes.getMovedFromCoordinates();
        int pieceType = mes.getPieceType();
        if (movedFromCoord != 0) {
            if (pieceType == 3) {
                SOCRoutePiece ship = board.roadOrShipAtEdge(pieceCurrCoord);
                if (ship instanceof SOCShip) {
                    ga.undoMoveShip((SOCShip)ship);
                }
            } else {
                System.err.println("Displayless.handleUNDOPUTPIECE: Un-handled move pieceType " + pieceType);
            }
        } else {
            SOCPlayingPiece pp = null;
            if (pieceType == 0 || pieceType == 3) {
                pp = board.roadOrShipAtEdge(pieceCurrCoord);
            } else if (pieceType == 1 || pieceType == 2) {
                pp = board.settlementAtNode(pieceCurrCoord);
            } else {
                System.err.println("Displayless.handleUNDOPUTPIECE: Un-handled move pieceType " + pieceType);
            }
            if (pp != null) {
                ga.undoPutPiece(pp);
            }
        }
    }

    protected void handleREVEALFOGHEX(SOCRevealFogHex mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.games.get(gaName);
        if (ga == null) {
            return;
        }
        if (!ga.hasSeaBoard) {
            return;
        }
        ga.revealFogHiddenHex(mes.getParam1(), mes.getParam2(), mes.getParam3());
    }

    protected void handlePIECEVALUE(SOCPieceValue mes) {
        SOCFortress fort;
        String gaName = mes.getGame();
        SOCGame ga = this.games.get(gaName);
        if (ga == null) {
            return;
        }
        if (!ga.hasSeaBoard) {
            return;
        }
        int coord = mes.getParam2();
        int pv = mes.getParam3();
        if (ga.isGameOptionSet("_SC_CLVI")) {
            SOCVillage vi = ((SOCBoardLarge)ga.getBoard()).getVillageAtNode(coord);
            if (vi != null) {
                vi.setCloth(pv);
            }
        } else if (ga.isGameOptionSet("_SC_PIRI") && (fort = ga.getFortress(coord)) != null) {
            fort.setStrength(pv);
        }
    }

    public static void handleSETSHIPROUTECLOSED(SOCSetShipRouteClosed mes, SOCGame ga) {
        if (ga == null) {
            return;
        }
        SOCBoard board = ga.getBoard();
        if (board instanceof SOCBoardLarge) {
            ((SOCBoardLarge)board).setShipsClosed(mes.isClosed(), mes.getParams(), 1);
        }
    }

    public static final void handleSETSPECIALITEM(Map<String, SOCGame> games, SOCSetSpecialItem mes) {
        SOCGame ga = games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        String typeKey = mes.typeKey;
        int gi = mes.gameItemIndex;
        int pi = mes.playerItemIndex;
        int pn = mes.playerNumber;
        switch (mes.op) {
            case 2: 
            case 6: {
                SOCPlayer pl;
                if (gi != -1) {
                    ga.setSpecialItem(typeKey, gi, null);
                }
                if (pn == -1 || pi == -1 || (pl = ga.getPlayer(pn)) == null) break;
                pl.setSpecialItem(typeKey, pi, null);
                break;
            }
            case 1: 
            case 5: {
                SOCPlayer pl;
                if (gi == -1 && (pi == -1 || pn == -1)) {
                    return;
                }
                SOCSpecialItem item = ga.getSpecialItem(typeKey, gi, pi, pn);
                SOCPlayer sOCPlayer = pl = pn != -1 ? ga.getPlayer(pn) : null;
                if (item != null) {
                    item.setPlayer(pl);
                    item.setCoordinates(mes.coord);
                    item.setLevel(mes.level);
                    item.setStringValue(mes.sv);
                } else {
                    item = new SOCSpecialItem(pl, mes.coord, mes.level, mes.sv, null, null);
                }
                if (gi != -1) {
                    item.setGameIndex(gi);
                    ga.setSpecialItem(typeKey, gi, item);
                }
                if (pi == -1 || pl == null) break;
                pl.setSpecialItem(typeKey, pi, item);
            }
        }
    }

    public void chSend(String ch, String mes) {
        this.put(new SOCChannelTextMsg(ch, this.nickname, mes).toCmd());
    }

    public void leaveChannel(String ch) {
        this.channels.remove(ch);
        this.put(SOCLeaveChannel.toCmd(this.nickname, "-", ch));
    }

    protected void disconnect() {
        this.connected = false;
        if (this.sLocal != null) {
            this.sLocal.disconnect();
        }
        try {
            this.sock.close();
        }
        catch (Exception e) {
            this.ex = e;
        }
    }

    public void joinGame(String gaName) {
        this.put(new SOCJoinGame("-", "", "-", gaName).toCmd());
    }

    public void buyDevCard(SOCGame ga) {
        this.put(new SOCBuyDevCardRequest(ga.getName()).toCmd());
    }

    public void buildRequest(SOCGame ga, int piece) throws IllegalArgumentException {
        this.put(new SOCBuildRequest(ga.getName(), piece).toCmd());
    }

    public void cancelBuildRequest(SOCGame ga, int piece) {
        this.put(new SOCCancelBuildRequest(ga.getName(), piece).toCmd());
    }

    public void putPiece(SOCGame ga, SOCPlayingPiece pp) throws IllegalArgumentException {
        int pt = pp.getType();
        if (pt < 0) {
            throw new IllegalArgumentException("pt: " + pt);
        }
        this.put(SOCPutPiece.toCmd(ga.getName(), pp.getPlayerNumber(), pt, pp.getCoordinates()));
    }

    public void movePieceRequest(SOCGame ga, int pn, int ptype, int fromCoord, int toCoord) throws IllegalArgumentException {
        this.put(new SOCMovePiece(ga.getName(), pn, ptype, fromCoord, toCoord).toCmd());
    }

    public void undoPutOrMovePieceRequest(SOCGame ga, int ptype, int coord, int movedFromCoord) throws IllegalArgumentException {
        this.put(new SOCUndoPutPiece(ga.getName(), ga.getCurrentPlayerNumber(), ptype, coord, movedFromCoord).toCmd());
    }

    public void moveRobber(SOCGame ga, SOCPlayer pl, int coord) {
        this.put(SOCMoveRobber.toCmd(ga.getName(), pl.getPlayerNumber(), coord));
    }

    public void simpleRequest(SOCGame ga, int ourPN, int reqType, int value1, int value2) {
        this.put(SOCSimpleRequest.toCmd(ga.getName(), ourPN, reqType, value1, value2));
    }

    public void pickSpecialItem(SOCGame ga, String typeKey, int gi, int pi) {
        this.put(new SOCSetSpecialItem(ga.getName(), 3, typeKey, gi, pi, -1).toCmd());
    }

    public void playInventoryItem(SOCGame ga, int ourPN, int itype) {
        this.put(SOCInventoryItemAction.toCmd(ga.getName(), ourPN, 4, itype, 0));
    }

    public void sendText(SOCGame ga, String me) {
        if (ga == null) {
            return;
        }
        this.put(new SOCGameTextMsg(ga.getName(), this.nickname, me).toCmd());
    }

    public void leaveGame(SOCGame ga) {
        this.leaveGame(ga.getName());
    }

    public void leaveGame(String gaName) {
        this.games.remove(gaName);
        this.put(new SOCLeaveGame(this.nickname, "-", gaName).toCmd());
    }

    public void sitDown(SOCGame ga, int pn) {
        this.put(SOCSitDown.toCmd(ga.getName(), "\t", pn, false));
    }

    public void startGame(SOCGame ga) {
        this.put(SOCStartGame.toCmd(ga.getName(), 0));
    }

    public void rollDice(SOCGame ga) {
        this.put(SOCRollDice.toCmd(ga.getName()));
    }

    public void endTurn(SOCGame ga) {
        this.put(SOCEndTurn.toCmd(ga.getName()));
    }

    public void discard(SOCGame ga, SOCResourceSet rs) {
        this.put(new SOCDiscard(ga.getName(), -1, rs).toCmd());
    }

    public void choosePlayer(SOCGame ga, int ch) {
        this.put(SOCChoosePlayer.toCmd(ga.getName(), ch));
    }

    public void rejectOffer(SOCGame ga) {
        this.put(new SOCRejectOffer(ga.getName(), 0).toCmd());
    }

    public void acceptOffer(SOCGame ga, int from) {
        this.put(new SOCAcceptOffer(ga.getName(), 0, from).toCmd());
    }

    public void clearOffer(SOCGame ga) {
        this.put(SOCClearOffer.toCmd(ga.getName(), 0));
    }

    public void bankTrade(SOCGame ga, SOCResourceSet give, SOCResourceSet get) {
        this.put(new SOCBankTrade(ga.getName(), give, get, -1).toCmd());
    }

    public void offerTrade(SOCGame ga, SOCTradeOffer offer) {
        this.put(SOCMakeOffer.toCmd(ga.getName(), offer));
    }

    public void playDevCard(SOCGame ga, int dc) {
        if (!ga.isPractice && this.sVersion < 2000) {
            if (dc == 9) {
                dc = 0;
            } else if (dc == 0) {
                dc = 9;
            }
        }
        this.put(SOCPlayDevCardRequest.toCmd(ga.getName(), dc));
    }

    public void pickResources(SOCGame ga, SOCResourceSet rscs) {
        this.put(new SOCPickResources(ga.getName(), rscs).toCmd());
    }

    public void pickResourceType(SOCGame ga, int res) {
        this.put(new SOCPickResourceType(ga.getName(), res).toCmd());
    }

    public void changeFace(SOCGame ga, int id) {
        this.put(new SOCChangeFace(ga.getName(), ga.getPlayer(this.nickname).getPlayerNumber(), id).toCmd());
    }

    public void setSeatLock(SOCGame ga, int pn, SOCGame.SeatLockState sl) {
        this.put(SOCSetSeatLock.toCmd(ga.getName(), pn, sl));
    }

    public void destroy() {
        SOCLeaveAll leaveAllMes = new SOCLeaveAll();
        this.put(leaveAllMes.toCmd());
        this.disconnect();
    }

    public static void main(String[] args) {
        SOCDisplaylessPlayerClient ex1 = new SOCDisplaylessPlayerClient(new ServerConnectInfo(args[0], Integer.parseInt(args[1]), null), true);
        new Thread(ex1).start();
        Thread.yield();
    }
}

