/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class AWTClickTester
extends Canvas
implements MouseListener {
    int lastX = -1;
    int lastY = -1;
    int wid = 200;
    int ht = 150;
    Dimension sz = new Dimension(this.wid, this.ht);

    public AWTClickTester() {
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.sz;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.sz;
    }

    public void setLastClick(int x, int y) {
        this.lastX = x;
        this.lastY = y;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        g.clearRect(0, 0, this.wid, this.ht);
        if (this.lastX == -1) {
            return;
        }
        g.setColor(Color.BLUE);
        g.drawLine(this.lastX - 15, this.lastY, this.lastX + 15, this.lastY);
        g.drawLine(this.lastX, this.lastY - 15, this.lastX, this.lastY + 15);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.report("click", e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.report("press", e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.report("rele ", e);
    }

    protected void report(String etype, MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        String popclick = e.isPopupTrigger() ? " isPopupTrigger" : "";
        System.out.println(etype + " (" + x + ", " + y + ") at " + e.getWhen() + " button=0x" + Integer.toHexString(e.getButton()) + " mods=0x" + Integer.toHexString(e.getModifiersEx()) + popclick);
        this.setLastClick(x, y);
    }

    public void printButtonsMods() {
        System.out.println("BUTTON:");
        System.out.println("  1:  0x" + Integer.toHexString(1) + " mask 0x" + Integer.toHexString(1024));
        System.out.println("  2:  0x" + Integer.toHexString(2) + " mask 0x" + Integer.toHexString(2048));
        System.out.println("  3:  0x" + Integer.toHexString(3) + " mask 0x" + Integer.toHexString(4096));
        System.out.println("MODS:");
        System.out.println("  Shift: 0x" + Integer.toHexString(64));
        System.out.println("  Ctrl:  0x" + Integer.toHexString(128));
        System.out.println("  Alt:   0x" + Integer.toHexString(512));
        System.out.println("  Meta:  0x" + Integer.toHexString(256));
        System.out.println();
    }

    public static void main(String[] args) {
        Frame f = new Frame("Click tester");
        AWTClickTester ct = new AWTClickTester();
        f.add(ct);
        f.pack();
        f.setVisible(true);
        ct.printButtonsMods();
    }
}

