/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import soc.client.MainDisplay;
import soc.client.PlayerClientListener;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.SwingMainDisplay;
import soc.util.SOCStringManager;

public abstract class AskDialog
extends JDialog
implements ActionListener,
WindowListener,
KeyListener,
MouseListener,
Runnable {
    protected static final SOCStringManager strings = SOCStringManager.getClientManager();
    private static final int MSG_BORDER = 5;
    protected final MainDisplay md;
    protected SOCPlayerInterface pi;
    private PlayerClientListener.NonBlockingDialogDismissListener nbddListener;
    protected JComponent msg;
    protected final JPanel pBtns;
    protected final boolean isMsgMultiLine;
    private boolean isSizeCheckedAlready;
    protected final JButton choice1But;
    protected final JButton choice2But;
    protected final JButton choice3But;
    protected final int choiceDefault;
    protected int wantW;
    protected int wantH;
    protected int padW;
    protected int padH;
    protected boolean didReqFocus;

    public AskDialog(MainDisplay cli, SOCPlayerInterface gamePI, String titlebar, String prompt, String choice1, String choice2, boolean default1, boolean default2) throws IllegalArgumentException {
        this(cli, (Window)gamePI, titlebar, prompt, choice1, choice2, default1, default2);
        if (gamePI == null) {
            throw new IllegalArgumentException("gamePI cannot be null");
        }
        this.pi = gamePI;
    }

    protected AskDialog(MainDisplay cli, Window parent, String titlebar, String prompt, String btnText, boolean hasDefault) throws IllegalArgumentException {
        this(cli, parent, titlebar, prompt, btnText, null, null, hasDefault ? 1 : 0);
    }

    public AskDialog(MainDisplay cli, Window parent, String titlebar, String prompt, String choice1, String choice2, boolean default1, boolean default2) throws IllegalArgumentException {
        this(cli, parent, titlebar, prompt, choice1, choice2, null, default1 ? 1 : (default2 ? 2 : 0));
        if (default1 && default2) {
            throw new IllegalArgumentException("Cannot have 2 default buttons");
        }
    }

    public AskDialog(MainDisplay cli, SOCPlayerInterface gamePI, String titlebar, String prompt, String choice1, String choice2, String choice3, int defaultChoice) throws IllegalArgumentException {
        this(cli, (Window)gamePI, titlebar, prompt, choice1, choice2, choice3, defaultChoice);
        if (gamePI == null) {
            throw new IllegalArgumentException("gamePI cannot be null");
        }
        this.pi = gamePI;
    }

    public AskDialog(MainDisplay md, Window parent, String titlebar, String prompt, String choice1, String choice2, String choice3, int defaultChoice) throws IllegalArgumentException {
        super(parent, AskDialog.firstLine(titlebar));
        JButton dfltB;
        int promptMaxWid;
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        if (md == null) {
            throw new IllegalArgumentException("md cannot be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (choice1 == null) {
            throw new IllegalArgumentException("choice1 cannot be null");
        }
        if (defaultChoice < 0 || defaultChoice > 3) {
            throw new IllegalArgumentException("defaultChoice out of range: " + defaultChoice);
        }
        if (choice3 == null && defaultChoice == 3) {
            throw new IllegalArgumentException("defaultChoice cannot be 3 when choice3 null");
        }
        if (choice2 == null && defaultChoice > 1) {
            throw new IllegalArgumentException("defaultChoice must be 1 when choice2 null");
        }
        this.md = md;
        this.pi = null;
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        if (!isOSHighContrast) {
            Color[] colors = SwingMainDisplay.getForegroundBackgroundColors(true, false);
            this.setBackground(colors[2]);
            this.setForeground(colors[0]);
            this.getRootPane().setBackground(null);
            this.getContentPane().setBackground(null);
        }
        this.setFont(new Font("Dialog", 0, 12));
        boolean shouldClearButtonBGs = !isOSHighContrast && SOCPlayerClient.IS_PLATFORM_WINDOWS;
        this.choice1But = new JButton(choice1);
        if (shouldClearButtonBGs) {
            this.choice1But.setBackground(null);
        }
        if (choice2 != null) {
            this.choice2But = new JButton(choice2);
            if (shouldClearButtonBGs) {
                this.choice2But.setBackground(null);
            }
            if (choice3 != null) {
                this.choice3But = new JButton(choice3);
                if (shouldClearButtonBGs) {
                    this.choice3But.setBackground(null);
                }
            } else {
                this.choice3But = null;
            }
        } else {
            this.choice2But = null;
            this.choice3But = null;
        }
        this.choiceDefault = defaultChoice;
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        int promptMultiLine = prompt.indexOf(10);
        if (promptMultiLine == 0) {
            prompt = prompt.substring(1);
            promptMultiLine = prompt.indexOf(10);
        }
        int promptLines = 1;
        if (promptMultiLine == -1) {
            this.isMsgMultiLine = false;
            this.msg = new JLabel(prompt, 0);
            this.msg.setAlignmentX(0.5f);
            this.add(this.msg);
            promptMaxWid = this.getFontMetrics(this.msg.getFont()).stringWidth(prompt);
        } else {
            promptMaxWid = 0;
            try {
                FontMetrics fm;
                StringTokenizer st = new StringTokenizer(prompt, "\n");
                Font ourfont = this.getFont();
                FontMetrics fontMetrics = fm = ourfont != null ? this.getFontMetrics(this.getFont()) : null;
                if (fm != null) {
                    while (st.hasMoreTokens()) {
                        String promptline = st.nextToken();
                        int mwid = fm.stringWidth(promptline);
                        if (mwid <= promptMaxWid) continue;
                        promptMaxWid = mwid;
                    }
                }
                JTextArea pmsg = new JTextArea(prompt);
                pmsg.setEditable(false);
                if (ourfont != null) {
                    pmsg.setFont(ourfont);
                } else {
                    pmsg.setFont(new Font("Dialog", 0, 12));
                }
                pmsg.setLineWrap(true);
                pmsg.setWrapStyleWord(true);
                if (!isOSHighContrast) {
                    pmsg.setBackground(this.getBackground());
                    pmsg.setForeground(null);
                }
                JScrollPane pScroll = new JScrollPane(pmsg);
                pScroll.setOpaque(false);
                this.msg = pScroll;
                this.add(pScroll);
                int maxWid80pct = 4 * parent.getWidth() / 5;
                if (promptMaxWid > maxWid80pct) {
                    promptMaxWid = maxWid80pct;
                }
            }
            catch (Throwable t) {
                this.msg = new JLabel(prompt, 0);
                this.msg.setAlignmentX(0.5f);
                this.add(this.msg);
                promptMaxWid = this.getFontMetrics(this.msg.getFont()).stringWidth(prompt);
                promptMultiLine = -1;
            }
            this.isMsgMultiLine = promptMultiLine != -1;
        }
        this.msg.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.wantW = 10 + promptMaxWid;
        if (this.wantW < 280) {
            this.wantW = 280;
        }
        if (choice3 != null && this.wantW < 360) {
            this.wantW = 360;
        }
        this.wantH = 41 + promptLines * this.getFontMetrics(this.msg.getFont()).getHeight();
        this.padW = 0;
        this.padH = 0;
        if (this.isMsgMultiLine) {
            this.setSize(this.wantW + 6, this.wantH + 20);
        }
        this.setLocationRelativeTo(parent);
        this.pBtns = new JPanel();
        if (!isOSHighContrast) {
            this.pBtns.setOpaque(true);
            this.pBtns.setBackground(null);
        }
        this.pBtns.setLayout(new FlowLayout(1, 3, 0));
        int pbboarder = 8;
        this.pBtns.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.pBtns.add(this.choice1But);
        this.choice1But.addActionListener(this);
        if (this.choice2But != null) {
            this.pBtns.add(this.choice2But);
            this.choice2But.addActionListener(this);
            if (this.choice3But != null) {
                this.pBtns.add(this.choice3But);
                this.choice3But.addActionListener(this);
            }
        }
        this.add(this.pBtns);
        switch (this.choiceDefault) {
            case 1: {
                dfltB = this.choice1But;
                break;
            }
            case 2: {
                dfltB = this.choice2But;
                break;
            }
            case 3: {
                dfltB = this.choice3But;
                break;
            }
            default: {
                dfltB = null;
            }
        }
        this.getRootPane().setDefaultButton(dfltB);
        this.addWindowListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.choice1But.addKeyListener(this);
        if (this.choice2But != null) {
            this.choice2But.addKeyListener(this);
            if (this.choice3But != null) {
                this.choice3But.addKeyListener(this);
            }
        }
        if (!this.isMsgMultiLine) {
            this.validate();
            this.pack();
        }
    }

    protected void checkSizeAndFocus() {
        this.padW = this.getInsets().left + this.getInsets().right + 6;
        this.padH = this.getInsets().top + this.getInsets().bottom;
        if ((this.padW > 0 || this.padH > 0) && this.isMsgMultiLine && !this.isSizeCheckedAlready) {
            this.wantH = 12 + this.msg.getPreferredSize().height + this.pBtns.getPreferredSize().height;
            this.setSize(this.wantW + this.padW + 20, this.wantH + this.padH);
            this.validate();
            this.isSizeCheckedAlready = true;
        }
        if (this.didReqFocus) {
            return;
        }
        switch (this.choiceDefault) {
            case 1: {
                this.choice1But.requestFocus();
                break;
            }
            case 2: {
                this.choice2But.requestFocus();
                break;
            }
            case 3: {
                this.choice3But.requestFocus();
            }
        }
        this.didReqFocus = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object target = e.getSource();
            if (target == this.choice1But) {
                this.dispose();
                this.button1Chosen();
            } else if (target == this.choice2But) {
                this.dispose();
                this.button2Chosen();
            } else if (target == this.choice3But) {
                this.dispose();
                this.button3Chosen();
            }
            this.callbackDiaDismissListener(false);
        }
        catch (Throwable thr) {
            if (this.pi != null) {
                this.pi.chatPrintStackTrace(thr);
            }
            System.err.println("-- Exception in AskDialog.actionPerformed: " + thr.toString() + " --");
            thr.printStackTrace();
            while (thr.getCause() != null) {
                thr = thr.getCause();
                System.err.println(" --> Cause: " + thr + " --");
                thr.printStackTrace();
            }
            System.err.println("-- Error stack trace end --");
            System.err.println();
        }
    }

    public abstract void button1Chosen();

    public abstract void button2Chosen();

    public void button3Chosen() {
    }

    public abstract void windowCloseChosen();

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
        this.windowCloseChosen();
        this.callbackDiaDismissListener(true);
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.checkSizeAndFocus();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 10: {
                if (this.choiceDefault == 0) break;
                this.dispose();
                e.consume();
                switch (this.choiceDefault) {
                    case 1: {
                        this.button1Chosen();
                        break;
                    }
                    case 2: {
                        this.button2Chosen();
                        break;
                    }
                    case 3: {
                        this.button3Chosen();
                    }
                }
                this.callbackDiaDismissListener(false);
                break;
            }
            case 3: 
            case 27: {
                this.dispose();
                e.consume();
                this.windowCloseChosen();
                this.callbackDiaDismissListener(true);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkSizeAndFocus();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public static Window getParentWindow(Component c) throws IllegalStateException {
        String throwMsg = null;
        while (!(c instanceof Window)) {
            Component last = c;
            if ((c = c.getParent()) == null) {
                throwMsg = "Assert failed, parent should not be null; last: ";
            } else if (c == last) {
                throwMsg = "Assert failed, parent == itself: ";
            }
            if (throwMsg == null) continue;
            throw new IllegalStateException(throwMsg + last.getClass().getName() + " " + last);
        }
        return (Window)c;
    }

    public static String firstLine(String f) {
        int i = f.indexOf("\n");
        if (i == -1) {
            return f;
        }
        if (i == 0) {
            return "JSettlers";
        }
        return f.substring(0, i);
    }

    protected final void callbackDiaDismissListener(final boolean wasCanceled) {
        if (this.nbddListener != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AskDialog.this.nbddListener.dialogDismissed(AskDialog.this, wasCanceled);
                }
            });
        }
    }

    public void setNonBlockingDialogDismissListener(PlayerClientListener.NonBlockingDialogDismissListener li) {
        this.nbddListener = li;
    }

    @Override
    public void run() {
        try {
            this.setVisible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

