/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import soc.client.MainDisplay;
import soc.client.SOCPlayerInterface;
import soc.client.SnippingTextArea;
import soc.util.SOCStringManager;

class ChannelFrame
extends JFrame {
    public SnippingTextArea ta;
    public JTextField tf;
    public JList<String> lst;
    final MainDisplay md;
    String cname;
    Vector<String> history = new Vector();
    int historyCounter = 1;
    boolean down = false;
    private static final SOCStringManager strings = SOCStringManager.getClientManager();

    public ChannelFrame(String t, MainDisplay md) {
        super(strings.get("channel.channel", t));
        this.setDefaultCloseOperation(0);
        Container cp = this.getContentPane();
        Font panelFont = new Font("SansSerif", 0, 12);
        cp.setLayout(new BorderLayout(2, 2));
        cp.setFont(panelFont);
        this.ta = new SnippingTextArea(20, 40, 100);
        this.tf = new JTextField(strings.get("base.please.wait"));
        this.lst = new JList(new DefaultListModel());
        this.lst.setSelectionMode(0);
        this.lst.setSize(new Dimension(180, 200));
        this.lst.setMinimumSize(new Dimension(30, 200));
        this.md = md;
        this.cname = t;
        this.ta.setFont(panelFont);
        Color bg = this.ta.getBackground();
        Color fg = this.ta.getForeground();
        this.ta.setEditable(false);
        this.ta.setBackground(bg);
        this.ta.setForeground(fg);
        this.tf.setEditable(false);
        JSplitPane sp = new JSplitPane(1, this.ta, new JScrollPane(this.lst));
        this.add((Component)sp, "Center");
        this.add((Component)this.tf, "South");
        this.setSize(640, 480);
        this.setMinimumSize(this.getSize());
        this.setLocationByPlatform(true);
        sp.setDividerLocation(500);
        this.history.addElement("");
        this.tf.addActionListener(new InputActionListener());
        this.tf.addKeyListener(new InputKeyListener());
        this.addWindowListener(new CFWindowListener());
    }

    public void print(String s) {
        StringTokenizer st = new StringTokenizer(s, "\n", false);
        while (st.hasMoreElements()) {
            this.ta.append(st.nextToken() + "\n");
        }
    }

    public void over(String s) {
        this.tf.setEditable(false);
        this.tf.setText(s);
    }

    public void began() {
        this.tf.setEditable(true);
        this.tf.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(String s) {
        DefaultListModel lm = (DefaultListModel)this.lst.getModel();
        Object object = this.lst.getTreeLock();
        synchronized (object) {
            int i;
            for (i = lm.getSize() - 1; i >= 0 && ((String)lm.get(i)).compareTo(s) >= 0; --i) {
            }
            lm.add(i + 1, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMember(String s) {
        DefaultListModel lm = (DefaultListModel)this.lst.getModel();
        Object object = this.lst.getTreeLock();
        synchronized (object) {
            for (int i = lm.getSize() - 1; i >= 0; --i) {
                if (!((String)lm.get(i)).equals(s)) continue;
                lm.remove(i);
                break;
            }
        }
    }

    private class CFWindowListener
    extends WindowAdapter {
        private CFWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ChannelFrame.this.md.getClient().leaveChannel(ChannelFrame.this.cname);
            ChannelFrame.this.dispose();
        }

        @Override
        public void windowOpened(WindowEvent e) {
            ChannelFrame.this.tf.requestFocus();
        }
    }

    private class InputKeyListener
    extends KeyAdapter {
        private InputKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int hs = ChannelFrame.this.history.size();
            int key = e.getKeyCode();
            if (key == 38 && hs > ChannelFrame.this.historyCounter) {
                if (ChannelFrame.this.historyCounter == 1) {
                    ChannelFrame.this.history.setElementAt(ChannelFrame.this.tf.getText(), hs - 1);
                }
                ++ChannelFrame.this.historyCounter;
                ChannelFrame.this.tf.setText(ChannelFrame.this.history.elementAt(hs - ChannelFrame.this.historyCounter));
            } else if (key == 40 && ChannelFrame.this.historyCounter > 1) {
                --ChannelFrame.this.historyCounter;
                ChannelFrame.this.tf.setText(ChannelFrame.this.history.elementAt(hs - ChannelFrame.this.historyCounter));
            }
        }
    }

    private class InputActionListener
    implements ActionListener {
        private InputActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = ChannelFrame.this.tf.getText().trim();
            if (s.length() > 0) {
                if (!SOCPlayerInterface.checkTextCharactersOrPopup(s, ChannelFrame.this.md, ChannelFrame.this)) {
                    return;
                }
                ChannelFrame.this.tf.setText("");
                ChannelFrame.this.md.sendToChannel(ChannelFrame.this.cname, s);
                ChannelFrame.this.history.setElementAt(s, ChannelFrame.this.history.size() - 1);
                ChannelFrame.this.history.addElement("");
                ChannelFrame.this.historyCounter = 1;
            }
        }
    }
}

