/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Locale;
import soc.baseclient.ServerConnectInfo;
import soc.client.MainDisplay;
import soc.client.MessageHandler;
import soc.client.SOCPlayerClient;
import soc.debug.D;
import soc.game.SOCGameOptionSet;
import soc.message.SOCJoinGame;
import soc.message.SOCLeaveAll;
import soc.message.SOCMessage;
import soc.message.SOCNewGameWithOptionsRequest;
import soc.message.SOCServerPing;
import soc.message.SOCVersion;
import soc.server.SOCServer;
import soc.server.genericServer.StringConnection;
import soc.server.genericServer.StringServerSocket;
import soc.util.SOCFeatureSet;
import soc.util.Version;

class ClientNetwork {
    public static final int SOC_PORT_DEFAULT = 8880;
    public static int CONNECT_TIMEOUT_MS = 6000;
    protected static final int PING_LOCAL_SERVER_INTERVAL_MS = 2700000;
    private final SOCPlayerClient client;
    private MainDisplay mainDisplay;
    protected ServerConnectInfo serverConnectInfo;
    SOCServer localTCPServer = null;
    Socket sock;
    DataInputStream in;
    DataOutputStream out;
    Thread reader = null;
    private final SOCFeatureSet cliFeats = new SOCFeatureSet(false, false);
    Exception ex;
    Exception ex_P;
    boolean connected;
    protected String lastMessage_N;
    protected String lastMessage_P;
    protected SOCServer practiceServer;
    protected StringConnection prCli;

    public ClientNetwork(SOCPlayerClient c) {
        this.cliFeats.add("6pl");
        this.cliFeats.add("sb");
        this.cliFeats.add("sc", Version.versionNumber());
        this.ex = null;
        this.ex_P = null;
        this.connected = false;
        this.practiceServer = null;
        this.prCli = null;
        this.client = c;
        if (this.client == null) {
            throw new IllegalArgumentException("client is null");
        }
    }

    public void setMainDisplay(MainDisplay md) throws IllegalArgumentException {
        if (md == null) {
            throw new IllegalArgumentException("null");
        }
        this.mainDisplay = md;
    }

    public void dispose() {
        this.shutdownLocalServer();
        this.disconnect();
    }

    public boolean startPracticeGame(String practiceGameName, SOCGameOptionSet gameOpts) {
        if (this.practiceServer == null) {
            try {
                if (Version.versionNumber() == 0) {
                    throw new IllegalStateException("Packaging error: Cannot determine JSettlers version");
                }
                this.practiceServer = new SOCServer(SOCServer.PRACTICE_STRINGPORT, SOCServer.SOC_MAXCONN_DEFAULT, null, null);
                this.practiceServer.setPriority(5);
                this.practiceServer.start();
            }
            catch (Throwable th) {
                this.mainDisplay.showErrorDialog(this.client.strings.get("pcli.error.startingpractice") + "\n" + th, this.client.strings.get("base.cancel"));
                return false;
            }
        }
        if (this.prCli == null) {
            try {
                this.prCli = StringServerSocket.connectTo(SOCServer.PRACTICE_STRINGPORT);
                new LocalStringReaderTask(this.prCli);
                this.sendVersion(true);
                this.mainDisplay.enableOptions();
            }
            catch (ConnectException e) {
                this.ex_P = e;
                return false;
            }
        }
        if (gameOpts == null) {
            this.putPractice(SOCJoinGame.toCmd(this.client.practiceNickname, "", "\t", practiceGameName));
        } else {
            this.putPractice(SOCNewGameWithOptionsRequest.toCmd(this.client.practiceNickname, "", "\t", practiceGameName, gameOpts.getAll()));
        }
        return true;
    }

    public int getLocalServerPort() {
        if (this.localTCPServer == null) {
            return 0;
        }
        return this.localTCPServer.getPort();
    }

    public void shutdownLocalServer() {
        if (this.localTCPServer != null && this.localTCPServer.isUp()) {
            this.localTCPServer.stopServer();
            this.localTCPServer = null;
        }
    }

    public boolean initLocalServer(int tport) {
        try {
            this.localTCPServer = new SOCServer(tport, SOCServer.SOC_MAXCONN_DEFAULT, null, null);
            this.localTCPServer.setPriority(5);
            this.localTCPServer.start();
        }
        catch (Throwable th) {
            this.mainDisplay.showErrorDialog(this.client.strings.get("pcli.error.startingserv") + "\n" + th, this.client.strings.get("base.cancel"));
            return false;
        }
        return true;
    }

    public int getPort() {
        return this.connected ? this.serverConnectInfo.port : 8880;
    }

    public String getHost() {
        return this.connected ? this.serverConnectInfo.hostname : null;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized void connect(String host, int port) throws IllegalStateException {
        if (this.connected) {
            throw new IllegalStateException("Already connected to " + (this.serverConnectInfo.hostname != null ? this.serverConnectInfo.hostname : "localhost") + ":" + this.serverConnectInfo.port);
        }
        if (Version.versionNumber() == 0) {
            throw new IllegalStateException("Packaging error: Cannot determine JSettlers version");
        }
        this.ex = null;
        String hostString = host != null ? host : "localhost";
        this.serverConnectInfo = new ServerConnectInfo(hostString, port, null);
        System.out.println("Connecting to " + hostString + ":" + port);
        this.mainDisplay.setMessage(this.client.strings.get("pcli.message.connecting.serv"));
        try {
            if (this.client.gotPassword) {
                this.mainDisplay.setPassword(this.client.password);
                this.client.gotPassword = false;
            }
            InetSocketAddress srvAddr = host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port);
            this.sock = new Socket();
            this.sock.connect(srvAddr, CONNECT_TIMEOUT_MS);
            this.sock.setSoTimeout(0);
            this.in = new DataInputStream(this.sock.getInputStream());
            this.out = new DataOutputStream(this.sock.getOutputStream());
            this.connected = true;
            this.reader = new Thread(new NetReadTask(this.client, this));
            this.reader.start();
            this.sendVersion(false);
            if (host == null) {
                Thread pinger = new Thread("cli-ping-local-srv"){

                    @Override
                    public void run() {
                        String pingCmd = new SOCServerPing(0).toCmd();
                        while (ClientNetwork.this.connected) {
                            try {
                                Thread.sleep(2700000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ClientNetwork.this.putNet(pingCmd);
                        }
                    }
                };
                pinger.setDaemon(true);
                pinger.start();
            }
        }
        catch (Exception e) {
            this.ex = e;
            String msg = this.client.strings.get("pcli.error.couldnotconnect", this.ex);
            System.err.println(msg);
            this.mainDisplay.showErrorPanel(msg, this.ex_P == null);
            if (this.connected) {
                this.disconnect();
                this.connected = false;
            }
            this.serverConnectInfo = null;
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.in = null;
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.out = null;
            }
            this.sock = null;
        }
    }

    protected synchronized void disconnect() {
        this.connected = false;
        try {
            this.sock.close();
        }
        catch (Exception e) {
            this.ex = e;
        }
    }

    private void sendVersion(boolean isPractice) {
        String feats = System.getProperty("jsettlers.debug.client.features");
        if (feats == null) {
            feats = this.cliFeats.getEncodedList();
        } else if (feats.length() == 0) {
            feats = null;
        }
        String gameopt3p = System.getProperty("jsettlers.debug.client.gameopt3p");
        if (gameopt3p != null) {
            gameopt3p = "com.example.js.feat." + gameopt3p.toUpperCase(Locale.US) + ';';
            feats = feats != null ? feats + gameopt3p : ';' + gameopt3p;
        }
        String msg = SOCVersion.toCmd(Version.versionNumber(), Version.version(), Version.buildnum(), feats, this.client.cliLocale.toString());
        if (isPractice) {
            this.putPractice(msg);
        } else {
            this.putNet(msg);
        }
    }

    public boolean isRunningLocalServer() {
        return this.localTCPServer != null;
    }

    public boolean anyHostedActiveGames() {
        if (this.localTCPServer == null) {
            return false;
        }
        Collection<String> gameNames = this.localTCPServer.getGameNames();
        for (String tryGm : gameNames) {
            int gs = this.localTCPServer.getGameState(tryGm);
            if (gs >= 1000 || gs < 5) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean putNet(String s) {
        this.lastMessage_N = s;
        if (this.ex != null || !this.isConnected()) {
            return false;
        }
        if (this.client.debugTraffic || soc.disableDebug.D.ebugIsEnabled()) {
            D.ebugPrintlnINFO("OUT - " + SOCMessage.toMsg(s));
        }
        try {
            this.out.writeUTF(s);
            this.out.flush();
        }
        catch (IOException e) {
            this.ex = e;
            System.err.println("could not write to the net: " + this.ex);
            this.client.shutdownFromNetwork();
            return false;
        }
        return true;
    }

    public synchronized boolean putPractice(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("null");
        }
        this.lastMessage_P = s;
        if (this.ex_P != null || !this.prCli.isConnected()) {
            return false;
        }
        if (this.client.debugTraffic || soc.disableDebug.D.ebugIsEnabled()) {
            D.ebugPrintlnINFO("OUT L- " + SOCMessage.toMsg(s));
        }
        this.prCli.put(s);
        return true;
    }

    public void resendNet() {
        if (this.lastMessage_N != null) {
            this.putNet(this.lastMessage_N);
        }
    }

    public void resendPractice() {
        if (this.lastMessage_P != null) {
            this.putPractice(this.lastMessage_P);
        }
    }

    public boolean putLeaveAll() {
        boolean canPractice = this.ex_P == null;
        SOCLeaveAll leaveAllMes = new SOCLeaveAll();
        this.putNet(leaveAllMes.toCmd());
        if (this.prCli != null && !canPractice) {
            this.putPractice(leaveAllMes.toCmd());
        }
        this.shutdownLocalServer();
        return canPractice;
    }

    class LocalStringReaderTask
    implements Runnable {
        StringConnection locl;

        protected LocalStringReaderTask(StringConnection prConn) {
            this.locl = prConn;
            Thread thr = new Thread(this);
            thr.setDaemon(true);
            thr.start();
        }

        @Override
        public void run() {
            block4: {
                Thread.currentThread().setName("cli-stringread");
                try {
                    MessageHandler handler = ClientNetwork.this.client.getMessageHandler();
                    handler.init(ClientNetwork.this.client);
                    while (this.locl.isConnected()) {
                        String s = this.locl.readNext();
                        SOCMessage msg = SOCMessage.toMsg(s);
                        if (msg != null) {
                            handler.handle(msg, true);
                            continue;
                        }
                        if (!((ClientNetwork)ClientNetwork.this).client.debugTraffic) continue;
                        D.ebugERROR("Could not parse practice server message: " + s);
                    }
                }
                catch (IOException e) {
                    if (!this.locl.isConnected()) break block4;
                    ClientNetwork.this.ex_P = e;
                    System.out.println("could not read from practice server: " + ClientNetwork.this.ex_P);
                    ClientNetwork.this.client.shutdownFromNetwork();
                }
            }
        }
    }

    static class NetReadTask
    implements Runnable {
        final ClientNetwork net;
        final SOCPlayerClient client;

        public NetReadTask(SOCPlayerClient client, ClientNetwork net) {
            this.client = client;
            this.net = net;
        }

        @Override
        public void run() {
            block4: {
                Thread.currentThread().setName("cli-netread");
                try {
                    MessageHandler handler = this.client.getMessageHandler();
                    handler.init(this.client);
                    while (this.net.isConnected()) {
                        String s = this.net.in.readUTF();
                        SOCMessage msg = SOCMessage.toMsg(s);
                        if (msg != null) {
                            handler.handle(msg, false);
                            continue;
                        }
                        if (!this.client.debugTraffic) continue;
                        D.ebugERROR("Could not parse net message: " + s);
                    }
                }
                catch (IOException e) {
                    if (!this.net.isConnected()) break block4;
                    this.net.ex = e;
                    System.out.println("could not read from the net: " + this.net.ex);
                    this.client.shutdownFromNetwork();
                }
            }
        }
    }
}

