/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import soc.client.ColorSquareListener;
import soc.util.SOCStringManager;

public class ColorSquare
extends JComponent
implements MouseListener {
    public static final Color CLAY = new Color(204, 102, 102);
    public static final Color ORE = new Color(153, 153, 153);
    public static final Color SHEEP = new Color(51, 204, 51);
    public static final Color WHEAT = new Color(204, 204, 51);
    public static final Color WOOD = new Color(204, 153, 102);
    public static final Color GREY = new Color(204, 204, 204);
    public static final Color DESERT = new Color(255, 255, 153);
    public static final Color GOLD = new Color(255, 250, 0);
    public static final Color FOG = new Color(220, 220, 220);
    public static final Color WATER = new Color(72, 97, 162);
    public static final Color[] RESOURCE_COLORS = new Color[]{CLAY, ORE, SHEEP, WHEAT, WOOD};
    public static final int NUMBER = 0;
    public static final int YES_NO = 1;
    public static final int CHECKBOX = 2;
    public static final int BOUNDED_INC = 3;
    public static final int BOUNDED_DEC = 4;
    public static final int TEXT = 5;
    public static final int WIDTH = 16;
    public static final int HEIGHT = 16;
    public static Color WARN_LEVEL_COLOR = new Color(200, 0, 0);
    public static Color WARN_LEVEL_COLOR_BG_FROMGREY = new Color(255, 255, 0);
    int intValue;
    boolean boolValue;
    private String textValue;
    boolean valueVis;
    int kind;
    int upperBound;
    int lowerBound;
    boolean interactive;
    private Color borderColor = Color.BLACK;
    protected ColorSquareListener sqListener;
    protected boolean warn_bg_grey;
    protected String ttip_text;
    protected String ttip_text_warnLow;
    protected String ttip_text_warnHigh;
    protected String ttip_text_zero;
    protected boolean hasWarnLow;
    protected boolean hasWarnHigh;
    protected boolean isWarnLow;
    protected boolean isWarnHigh;
    protected int warnLowBound;
    protected int warnHighBound;
    protected int squareW;
    protected int squareH;
    protected Dimension squareSize;
    protected Dimension minSize;
    protected boolean sizeIsMax;
    private static final SOCStringManager strings = SOCStringManager.getClientManager();

    public ColorSquare() {
        this(0, false, GREY, 0, 0);
        this.valueVis = false;
    }

    public ColorSquare(Color c) {
        this(2, false, c, 99, 0);
    }

    public ColorSquare(Color c, int w, int h) {
        this(c);
        if (w != 16 || h != 16) {
            this.setSizesAndFont(w, h);
        }
    }

    public ColorSquare(Color c, int v) {
        this(0, false, c, 99, 0);
        this.intValue = v;
    }

    public ColorSquare(Color c, int v, int w, int h) {
        this(c, v);
        if (w != 16 || h != 16) {
            this.setSizesAndFont(w, h);
        }
    }

    public ColorSquare(Color c, String v) {
        this(5, false, c);
        this.textValue = v;
    }

    public ColorSquare(int k, boolean in, Color c) {
        this(k, in, c, 99, 0);
    }

    public ColorSquare(int k, boolean in, int w, int h, Color c) {
        this(k, in, c);
        this.setSizesAndFont(w, h);
    }

    public ColorSquare(int k, boolean in, Color c, int upper, int lower) {
        this.setSize(16, 16);
        this.setMinimumSize(this.squareSize);
        this.setPreferredSize(this.squareSize);
        this.setFont(new Font("Dialog", 0, 10));
        this.setOpaque(true);
        this.setBackground(c);
        this.setBorder(BorderFactory.createLineBorder(this.borderColor));
        this.kind = k;
        this.interactive = in;
        this.sqListener = null;
        this.ttip_text = null;
        this.ttip_text_warnLow = null;
        this.ttip_text_zero = null;
        this.hasWarnLow = false;
        this.isWarnLow = false;
        this.hasWarnHigh = false;
        this.isWarnHigh = false;
        this.warn_bg_grey = c.equals(GREY);
        switch (k) {
            case 0: {
                this.valueVis = true;
                this.intValue = 0;
                break;
            }
            case 1: {
                this.valueVis = true;
                this.boolValue = false;
                break;
            }
            case 2: 
            case 5: {
                this.valueVis = true;
                this.boolValue = false;
                break;
            }
            case 3: {
                this.valueVis = true;
                this.boolValue = false;
                this.upperBound = upper;
                this.lowerBound = lower;
                break;
            }
            case 4: {
                this.valueVis = true;
                this.boolValue = false;
                this.upperBound = upper;
                this.lowerBound = lower;
            }
        }
        if (!c.equals(GREY)) {
            if (c == CLAY) {
                this.setToolTipText(strings.get("resources.clay"));
            } else if (c == ORE) {
                this.setToolTipText(strings.get("resources.ore"));
            } else if (c == SHEEP) {
                this.setToolTipText(strings.get("resources.sheep"));
            } else if (c == WHEAT) {
                this.setToolTipText(strings.get("resources.wheat"));
            } else if (c == WOOD) {
                this.setToolTipText(strings.get("resources.wood"));
            } else if (c == GOLD) {
                this.setToolTipText(strings.get("board.hex.gold"));
            }
        }
        if (in) {
            this.addMouseListener(this);
        }
    }

    public void setInteractive(boolean inter) {
        if (inter == this.interactive) {
            return;
        }
        if (inter && !this.interactive) {
            this.addMouseListener(this);
        }
        this.interactive = inter;
    }

    protected final void setSizesAndFont(int w, int h) {
        int size;
        this.setSize(w, h);
        this.setMinimumSize(this.squareSize);
        if (this.sizeIsMax) {
            this.setMaximumSize(this.squareSize);
        }
        int n = size = w < h ? w : h;
        if (size >= 21) {
            this.setFont(this.getFont().deriveFont(10.0f * ((float)size / 16.0f)));
        }
    }

    @Override
    public void setMinimumSize(Dimension d) {
        super.setMinimumSize(d);
        this.minSize = d != null ? new Dimension(d) : null;
    }

    public void setMaximumSizeToCurrent() {
        this.sizeIsMax = true;
        super.setMaximumSize(this.squareSize);
    }

    @Override
    public void setBackground(Color c) {
        this.warn_bg_grey = c.equals(GREY);
        super.setBackground(c);
    }

    public void setColor(Color c) {
        this.setBackground(c);
    }

    public void setBorderColor(Color c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        if (this.borderColor.equals(c)) {
            return;
        }
        this.setBorder(BorderFactory.createLineBorder(c));
        this.borderColor = c;
    }

    @Override
    public void setSize(int w, int h) {
        if (this.minSize != null) {
            if (w < this.minSize.width) {
                w = this.minSize.width;
            }
            if (h < this.minSize.height) {
                h = this.minSize.height;
            }
        }
        this.squareW = w;
        this.squareH = h;
        this.squareSize = new Dimension(w, h);
        super.setSize(w, h);
        if (this.sizeIsMax) {
            this.setMaximumSize(this.squareSize);
        }
    }

    @Override
    public void setSize(Dimension d) {
        if (d != null) {
            this.setSize(d.width, d.height);
        }
    }

    @Override
    public void setToolTipText(String tip) {
        this.ttip_text = tip;
        this.ttip_text_warnLow = null;
        this.ttip_text_zero = null;
        super.setToolTipText(tip);
    }

    public void setLowWarningLevel(int warnLevel) throws IllegalArgumentException {
        if (warnLevel == 0) {
            if (this.ttip_text == null) {
                throw new IllegalArgumentException("To clear, call clearLowWarningLevel instead");
            }
            throw new IllegalArgumentException("To set zero text, call setToolTipZeroText instead");
        }
        if (this.hasWarnHigh && warnLevel >= this.warnHighBound) {
            throw new IllegalArgumentException("Asked for low warning (" + warnLevel + ") higher than existing high warning (" + this.warnHighBound + ")");
        }
        boolean wasWarnLow = this.isWarnLow;
        this.hasWarnLow = true;
        this.warnLowBound = warnLevel;
        boolean bl = this.isWarnLow = this.intValue <= warnLevel || this.intValue == 0 && this.ttip_text_zero != null;
        if (this.isWarnLow != wasWarnLow) {
            this.repaint();
            if (this.intValue == 0 && this.ttip_text_zero != null) {
                super.setToolTipText(this.ttip_text_zero);
            } else if (this.ttip_text_warnLow != null) {
                super.setToolTipText(this.isWarnLow ? this.ttip_text_warnLow : this.ttip_text);
            }
        }
    }

    public void clearLowWarningLevel() {
        this.hasWarnLow = false;
        if (this.isWarnLow) {
            this.isWarnLow = false;
            this.repaint();
            if (this.ttip_text_warnLow != null) {
                this.ttip_text_warnLow = null;
                if (this.intValue == 0 && this.ttip_text_zero != null) {
                    super.setToolTipText(this.ttip_text_zero);
                } else {
                    super.setToolTipText(this.ttip_text);
                }
            }
        }
    }

    public void setToolTipLowWarningLevel(String warnTip, int warnLevel) throws IllegalStateException, IllegalArgumentException {
        if (this.ttip_text == null && warnTip != null) {
            throw new IllegalStateException("Must call setToolTipText first");
        }
        if (warnLevel == 0) {
            if (this.ttip_text == null) {
                throw new IllegalArgumentException("To clear, call clearLowWarningLevel instead");
            }
            throw new IllegalArgumentException("To set zero text, call setToolTipZeroText instead");
        }
        if (this.hasWarnHigh && warnLevel >= this.warnHighBound) {
            throw new IllegalArgumentException("Asked for low warning (" + warnLevel + ") higher than existing high warning (" + this.warnHighBound + ")");
        }
        boolean wasWarnLow = this.isWarnLow;
        boolean willWarnLow = this.intValue <= warnLevel;
        this.ttip_text_warnLow = warnTip;
        if (warnTip == null && this.ttip_text != null) {
            if (this.intValue == 0 && this.ttip_text_zero != null) {
                super.setToolTipText(this.ttip_text_zero);
            } else if (wasWarnLow) {
                super.setToolTipText(this.ttip_text);
            }
        } else if (warnTip != null && wasWarnLow && willWarnLow && (this.intValue != 0 || this.ttip_text_zero == null)) {
            super.setToolTipText(warnTip);
        }
        this.setLowWarningLevel(warnLevel);
    }

    public void setHighWarningLevel(int warnLevel) throws IllegalArgumentException {
        if (this.hasWarnLow && warnLevel <= this.warnLowBound) {
            throw new IllegalArgumentException("Asked for high warning (" + warnLevel + ") lower than existing low warning (" + this.warnLowBound + ")");
        }
        boolean wasWarnHigh = this.isWarnHigh;
        this.hasWarnHigh = true;
        this.warnHighBound = warnLevel;
        boolean bl = this.isWarnHigh = this.intValue >= warnLevel;
        if (this.isWarnHigh != wasWarnHigh) {
            this.repaint();
            if (this.ttip_text_warnHigh != null) {
                if (this.isWarnHigh) {
                    super.setToolTipText(this.ttip_text_warnHigh);
                } else {
                    super.setToolTipText(this.ttip_text);
                }
            }
        }
    }

    public void clearHighWarningLevel() {
        this.hasWarnHigh = false;
        if (this.isWarnHigh) {
            this.isWarnHigh = false;
            this.repaint();
            if (this.ttip_text_warnHigh != null) {
                this.ttip_text_warnHigh = null;
                super.setToolTipText(this.ttip_text);
            }
        }
    }

    public void setToolTipHighWarningLevel(String warnTip, int warnLevel) throws IllegalStateException, IllegalArgumentException {
        if (this.ttip_text == null && warnTip != null) {
            throw new IllegalStateException("Must call setToolTipText first");
        }
        if (this.hasWarnLow && warnLevel <= this.warnLowBound) {
            throw new IllegalArgumentException("Asked for high warning (" + warnLevel + ") lower than existing low warning (" + this.warnLowBound + ")");
        }
        boolean wasWarnHigh = this.isWarnHigh;
        boolean willWarnHigh = this.intValue >= warnLevel;
        this.ttip_text_warnHigh = warnTip;
        if (warnTip == null && this.ttip_text != null) {
            if (wasWarnHigh) {
                super.setToolTipText(this.ttip_text);
            }
        } else if (warnTip != null && wasWarnHigh && willWarnHigh) {
            super.setToolTipText(warnTip);
        }
        this.setHighWarningLevel(warnLevel);
    }

    public void setToolTipZeroText(String zeroTip) throws IllegalStateException {
        if (this.ttip_text == null && zeroTip != null) {
            throw new IllegalStateException("Must call setToolTipText first");
        }
        boolean isZero = this.intValue == 0;
        this.ttip_text_zero = zeroTip;
        if (zeroTip == null && this.ttip_text != null) {
            if (isZero) {
                if (this.hasWarnLow && this.isWarnLow) {
                    super.setToolTipText(this.ttip_text_warnLow);
                } else {
                    super.setToolTipText(this.ttip_text);
                }
            }
        } else if (zeroTip != null && isZero) {
            super.setToolTipText(zeroTip);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.squareSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minSize;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.minSize != null) {
            if (w < this.minSize.width) {
                w = this.minSize.width;
            }
            if (h < this.minSize.height) {
                h = this.minSize.height;
            }
        }
        this.squareW = w;
        this.squareH = h;
        if (this.squareSize != null) {
            this.squareSize.width = w;
            this.squareSize.height = h;
        }
        super.setBounds(x, y, w, h);
    }

    @Override
    public void setBounds(Rectangle r) {
        if (r != null) {
            this.setBounds(r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setPaintMode();
        if (this.warn_bg_grey && (this.isWarnLow || this.isWarnHigh)) {
            g.setColor(WARN_LEVEL_COLOR_BG_FROMGREY);
        } else {
            g.setColor(this.getBackground());
        }
        g.fillRect(0, 0, this.squareW, this.squareH);
        if (this.valueVis) {
            if (this.isWarnLow || this.isWarnHigh) {
                g.setColor(WARN_LEVEL_COLOR);
            } else {
                g.setColor(Color.BLACK);
            }
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int numH = fm.getHeight();
            switch (this.kind) {
                case 0: 
                case 3: 
                case 4: 
                case 5: {
                    String valstring = this.kind != 5 ? Integer.toString(this.intValue) : this.textValue;
                    int numW = fm.stringWidth(valstring);
                    int x = (this.squareW - numW) / 2;
                    int y = (this.squareH + (int)(0.6 * (double)numH)) / 2;
                    g.drawString(valstring, x, y);
                    break;
                }
                case 1: {
                    String value = this.boolValue ? strings.get("abbr.yes") : strings.get("abbr.no");
                    int numW = fm.stringWidth(value);
                    int x = (this.squareW - numW) / 2;
                    int y = (this.squareH + (int)(0.6 * (double)numH)) / 2;
                    g.drawString(value, x, y);
                    break;
                }
                case 2: {
                    Stroke origStroke;
                    if (!this.boolValue) break;
                    boolean wantWide = g instanceof Graphics2D && this.squareW >= 32;
                    Stroke stroke = origStroke = wantWide ? ((Graphics2D)g).getStroke() : null;
                    if (wantWide) {
                        ((Graphics2D)g).setStroke(new BasicStroke((float)this.squareW / 16.0f));
                    }
                    int checkX = this.squareW / 5;
                    int checkY = this.squareH / 4;
                    g.drawLine(checkX, 2 * checkY, 2 * checkX, 3 * checkY);
                    g.drawLine(2 * checkX, 3 * checkY, 4 * checkX, checkY);
                    if (!wantWide) break;
                    ((Graphics2D)g).setStroke(origStroke);
                }
            }
        }
    }

    public void addValue(int v) {
        this.setIntValue(this.intValue + v);
    }

    public void subtractValue(int v) {
        this.setIntValue(this.intValue - v);
    }

    public void setIntValue(int v) {
        if (v == this.intValue) {
            return;
        }
        int oldIntValue = this.intValue;
        boolean wasZero = this.intValue == 0 && this.ttip_text_zero != null;
        this.intValue = v;
        boolean isZero = this.intValue == 0 && this.ttip_text_zero != null;
        boolean wasWarnLow = this.isWarnLow;
        boolean wasWarnHigh = this.isWarnHigh;
        this.isWarnLow = isZero || this.hasWarnLow && this.intValue <= this.warnLowBound;
        this.isWarnHigh = this.hasWarnHigh && this.intValue >= this.warnHighBound;
        this.repaint();
        if (isZero) {
            super.setToolTipText(this.ttip_text_zero);
        } else if (this.ttip_text != null && (isZero != wasZero || this.isWarnLow != wasWarnLow || this.isWarnHigh != wasWarnHigh)) {
            if (this.isWarnHigh && this.ttip_text_warnHigh != null) {
                super.setToolTipText(this.ttip_text_warnHigh);
            } else if (this.isWarnLow && this.ttip_text_warnLow != null) {
                super.setToolTipText(this.ttip_text_warnLow);
            } else {
                super.setToolTipText(this.ttip_text);
            }
        }
        if (this.sqListener != null) {
            this.sqListener.squareChanged(this, oldIntValue, this.intValue);
        }
    }

    public int getIntValue() {
        return this.intValue;
    }

    public void setBoolValue(boolean v) {
        if (v == this.boolValue) {
            return;
        }
        boolean oldBoolValue = this.boolValue;
        this.boolValue = v;
        this.repaint();
        if (this.sqListener != null) {
            this.sqListener.squareChanged(this, oldBoolValue ? 1 : 0, this.boolValue ? 1 : 0);
        }
    }

    public boolean getBoolValue() {
        return this.boolValue;
    }

    public ColorSquareListener getSquareListener() {
        return this.sqListener;
    }

    public void setSquareListener(ColorSquareListener sp) {
        this.sqListener = sp;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!this.interactive) {
            return;
        }
        int oldIVal = this.intValue++;
        boolean bvalChanged = false;
        switch (this.kind) {
            case 1: 
            case 2: {
                this.boolValue = !this.boolValue;
                bvalChanged = true;
                break;
            }
            case 0: {
                break;
            }
            case 3: {
                if (this.intValue >= this.upperBound) break;
                ++this.intValue;
                break;
            }
            case 4: {
                if (this.intValue <= this.lowerBound) break;
                --this.intValue;
            }
        }
        this.repaint();
        if (this.sqListener != null) {
            if (bvalChanged) {
                this.sqListener.squareChanged(this, this.boolValue ? 0 : 1, this.boolValue ? 1 : 0);
            } else if (oldIVal != this.intValue) {
                this.sqListener.squareChanged(this, oldIVal, this.intValue);
            }
        }
    }
}

