/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.border.EmptyBorder;
import soc.client.SOCFaceButton;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.SwingMainDisplay;
import soc.util.SOCStringManager;

class FaceChooserFrame
extends JFrame
implements ActionListener,
WindowListener,
KeyListener {
    protected final SOCFaceButton fb;
    protected final SOCPlayerClient pcli;
    protected final SOCPlayerInterface pi;
    protected int pNumber;
    protected int faceWidthPx;
    protected FaceChooserList fcl;
    protected JButton changeFaceBut;
    protected JButton cancelBut;
    protected JLabel promptLbl;
    private boolean stillAvailable;
    private static final SOCStringManager strings = SOCStringManager.getClientManager();

    public FaceChooserFrame(SOCFaceButton fbutton, SOCPlayerClient cli, SOCPlayerInterface gamePI, int pnum, int faceID, int faceWidth) throws IllegalArgumentException {
        super(strings.get("facechooser.title", gamePI.getGame().getName(), gamePI.getClientNickname()));
        if (fbutton == null) {
            throw new IllegalArgumentException("fbutton cannot be null");
        }
        if (pnum < 0 || pnum >= 6) {
            throw new IllegalArgumentException("pnum out of range: " + pnum);
        }
        if (faceWidth <= 0) {
            throw new IllegalArgumentException("faceWidth must be positive, not " + faceWidth);
        }
        this.fb = fbutton;
        this.pcli = cli;
        this.pi = gamePI;
        this.pNumber = pnum;
        this.faceWidthPx = faceWidth;
        this.stillAvailable = true;
        int displayScale = this.pi.displayScale;
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        if (!isOSHighContrast) {
            Color[] colors = SwingMainDisplay.getForegroundBackgroundColors(true, false);
            this.setBackground(colors[2]);
            this.setForeground(colors[0]);
            this.getRootPane().setBackground(null);
            this.getContentPane().setBackground(null);
        }
        this.setFont(new Font("Dialog", 0, 12 * displayScale));
        this.setDefaultCloseOperation(2);
        this.changeFaceBut = new JButton(strings.get("base.change"));
        this.cancelBut = new JButton(strings.get("base.cancel"));
        if (SOCPlayerClient.IS_PLATFORM_WINDOWS && !isOSHighContrast) {
            this.changeFaceBut.setBackground(null);
            this.cancelBut.setBackground(null);
        }
        this.setLayout(new BorderLayout());
        int bsize = 4 * displayScale;
        this.promptLbl = new JLabel(strings.get("facechooser.prompt"), 2);
        this.promptLbl.setBorder(new EmptyBorder(bsize, bsize, bsize, bsize));
        this.add((Component)this.promptLbl, "North");
        this.fcl = new FaceChooserList(this, faceID);
        this.add((Component)this.fcl, "Center");
        try {
            Point mloc = MouseInfo.getPointerInfo().getLocation();
            this.setLocation(mloc.x + 20 * displayScale, mloc.y + 10 * displayScale);
        }
        catch (RuntimeException e) {
            this.setLocationRelativeTo(gamePI);
        }
        JPanel pBtns = new JPanel();
        pBtns.setLayout(new FlowLayout(1));
        pBtns.setBackground(null);
        pBtns.add(this.changeFaceBut);
        this.changeFaceBut.addActionListener(this);
        pBtns.add(this.cancelBut);
        this.cancelBut.addActionListener(this);
        this.add((Component)pBtns, "South");
        this.getRootPane().setDefaultButton(this.changeFaceBut);
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.changeFaceBut.addKeyListener(this);
        this.cancelBut.addKeyListener(this);
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis) {
            this.fcl.requestFocusInWindow();
        }
    }

    public void selectFace(int id, boolean alreadySelected) {
        if (!alreadySelected) {
            this.fcl.selectFace(id);
        } else if (id != this.fcl.initialFaceId) {
            this.dispose();
            this.changeButtonChosen();
        }
    }

    public Color getPlayerColor() {
        return this.pi.getPlayerColor(this.pNumber);
    }

    public boolean isStillAvailable() {
        return this.stillAvailable;
    }

    @Override
    public void dispose() {
        if (this.stillAvailable) {
            this.stillAvailable = false;
            this.fb.clearFacePopupPreviousChooser();
        }
        super.dispose();
    }

    protected void checkSizeAndFocus(boolean listSizeKnown) {
        if (listSizeKnown) {
            this.doLayout();
        }
        this.changeFaceBut.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object target = e.getSource();
            if (target == this.changeFaceBut) {
                this.dispose();
                this.changeButtonChosen();
            } else if (target == this.cancelBut) {
                this.dispose();
                this.cancelButtonChosen();
            }
        }
        catch (Throwable th) {
            this.pi.chatPrintStackTrace(th);
        }
    }

    public void changeButtonChosen() {
        this.pcli.getGameMessageSender().changeFace(this.pi.getGame(), this.fcl.currentFaceId);
    }

    public void cancelButtonChosen() {
    }

    public void moveCursor(int dr, int dc, KeyEvent e) {
        this.fcl.moveCursor(dr, dc, e);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
        this.cancelButtonChosen();
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.checkSizeAndFocus(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 10: {
                this.dispose();
                e.consume();
                this.changeButtonChosen();
                break;
            }
            case 3: 
            case 27: {
                this.dispose();
                e.consume();
                this.cancelButtonChosen();
                break;
            }
            case 38: {
                this.fcl.moveCursor(-1, 0, e);
                break;
            }
            case 40: {
                this.fcl.moveCursor(1, 0, e);
                break;
            }
            case 37: {
                this.fcl.moveCursor(0, -1, e);
                break;
            }
            case 39: {
                this.fcl.moveCursor(0, 1, e);
                break;
            }
            case 33: {
                this.fcl.moveCursor(-2, 0, e);
                break;
            }
            case 34: {
                this.fcl.moveCursor(2, 0, e);
                break;
            }
            case 36: {
                if (0 != (e.getModifiersEx() & 0x80)) {
                    this.fcl.moveCursor(-3, -2, e);
                    break;
                }
                this.fcl.moveCursor(0, -2, e);
                break;
            }
            case 35: {
                if (0 != (e.getModifiersEx() & 0x80)) {
                    this.fcl.moveCursor(3, 2, e);
                    break;
                }
                this.fcl.moveCursor(0, 2, e);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    protected static class FaceChooserList
    extends Container
    implements AdjustmentListener {
        protected static int rowFacesWidth = 7;
        protected static int faceRowsHeight = 6;
        protected final FaceChooserFrame fcf;
        private int currentRow;
        private int currentOffset;
        private int rowCount;
        private int currentFaceId;
        private int initialFaceId;
        private FaceChooserRow[] faceGrid;
        private FaceChooserRow[] visibleFaceGrid;
        private boolean needsScroll;
        private JScrollBar faceSB;
        protected int wantW;
        protected int wantH;
        protected Dimension wantSize;
        protected int padW;
        protected int padH;
        protected int scrollW;

        protected FaceChooserList(FaceChooserFrame fcf, int selectedFaceId) {
            this.fcf = fcf;
            this.initialFaceId = selectedFaceId;
            this.currentFaceId = selectedFaceId;
            this.rowCount = (int)Math.ceil(73.0f / (float)rowFacesWidth);
            if (this.rowCount < faceRowsHeight) {
                faceRowsHeight = this.rowCount;
            }
            this.currentRow = (selectedFaceId - 1) / rowFacesWidth - faceRowsHeight / 2;
            if (this.currentRow < 0) {
                this.currentRow = 0;
            } else if (this.currentRow + faceRowsHeight >= this.rowCount) {
                this.currentRow = this.rowCount - faceRowsHeight;
            }
            this.currentOffset = 1 + this.currentRow * rowFacesWidth;
            this.needsScroll = this.rowCount > faceRowsHeight;
            this.faceGrid = new FaceChooserRow[this.rowCount];
            this.visibleFaceGrid = new FaceChooserRow[faceRowsHeight];
            this.setLayout(null);
            int nextId = this.currentOffset;
            int r = this.currentRow;
            for (int visR = 0; visR < faceRowsHeight; ++visR) {
                FaceChooserRow fcr;
                this.faceGrid[r] = fcr = new FaceChooserRow(nextId);
                this.visibleFaceGrid[visR] = fcr;
                this.add(fcr);
                nextId += rowFacesWidth;
                ++r;
            }
            if (this.needsScroll) {
                this.faceSB = new JScrollBar(1, this.currentRow, faceRowsHeight, 0, this.rowCount);
                this.add(this.faceSB);
                this.faceSB.addAdjustmentListener(this);
                this.faceSB.addKeyListener(fcf);
            }
            int displayScale = fcf.pi.displayScale;
            this.wantW = rowFacesWidth * 44 * displayScale;
            this.wantH = faceRowsHeight * 44 * displayScale;
            this.scrollW = 0;
            this.padW = 10 * displayScale;
            this.padH = 30 * displayScale;
            this.wantSize = new Dimension(this.wantW + this.padW, this.wantH + this.padH);
        }

        public void selectFace(int id) {
            if (id <= 0 || id >= 74) {
                throw new IllegalArgumentException("id not within range: " + id);
            }
            int prevFaceId = this.currentFaceId;
            int r = (prevFaceId - 1) / rowFacesWidth;
            this.faceGrid[r].setFaceHilightBorder(prevFaceId, false);
            r = (id - 1) / rowFacesWidth;
            this.scrollToRow(r);
            this.faceGrid[r].setFaceHilightBorder(id, true);
            this.currentFaceId = id;
        }

        public void scrollToRow(int newRow) {
            int newCurRow;
            int numNewRows;
            if (newRow < 0 || newRow >= this.rowCount) {
                throw new IllegalArgumentException("newRow not in range (0 to " + (this.rowCount - 1) + "): " + newRow);
            }
            if (newRow >= this.currentRow && newRow < this.currentRow + faceRowsHeight) {
                return;
            }
            boolean createdRows = false;
            if (newRow < this.currentRow) {
                numNewRows = this.currentRow - newRow;
                newCurRow = newRow;
            } else {
                numNewRows = 1 + (newRow - (this.currentRow + faceRowsHeight));
                newCurRow = newRow - faceRowsHeight + 1;
            }
            int newCurOffset = newCurRow * rowFacesWidth + 1;
            if (numNewRows > faceRowsHeight) {
                numNewRows = faceRowsHeight;
            }
            if (numNewRows == faceRowsHeight || newRow < this.currentRow) {
                int r;
                if (numNewRows == faceRowsHeight) {
                    for (r = faceRowsHeight - 1; r >= 0; --r) {
                        this.visibleFaceGrid[r].setVisible(false);
                        this.visibleFaceGrid[r] = null;
                    }
                } else {
                    for (r = faceRowsHeight - numNewRows; r < faceRowsHeight; ++r) {
                        this.visibleFaceGrid[r].setVisible(false);
                        this.visibleFaceGrid[r] = null;
                    }
                    for (r = faceRowsHeight - numNewRows - 1; r >= 0; --r) {
                        this.visibleFaceGrid[r + numNewRows] = this.visibleFaceGrid[r];
                    }
                }
                int nextId = newCurOffset;
                int visR = 0;
                r = newRow;
                while (r < newRow + numNewRows) {
                    if (this.faceGrid[r] == null) {
                        this.faceGrid[r] = new FaceChooserRow(nextId);
                        this.add(this.faceGrid[r]);
                        createdRows = true;
                    }
                    this.visibleFaceGrid[visR] = this.faceGrid[r];
                    this.visibleFaceGrid[visR].setVisible(true);
                    nextId += rowFacesWidth;
                    ++r;
                    ++visR;
                }
            } else {
                int visR;
                int r;
                for (r = 0; r < numNewRows; ++r) {
                    this.visibleFaceGrid[r].setVisible(false);
                    this.visibleFaceGrid[r] = null;
                }
                for (r = 0; r < faceRowsHeight - numNewRows; ++r) {
                    this.visibleFaceGrid[r] = this.visibleFaceGrid[r + numNewRows];
                }
                int nextId = newCurOffset + visR * rowFacesWidth;
                r = newCurRow + visR;
                for (visR = faceRowsHeight - numNewRows; visR < faceRowsHeight; ++visR) {
                    if (this.faceGrid[r] == null) {
                        this.faceGrid[r] = new FaceChooserRow(nextId);
                        this.add(this.faceGrid[r]);
                        createdRows = true;
                    }
                    this.visibleFaceGrid[visR] = this.faceGrid[r];
                    this.visibleFaceGrid[visR].setVisible(true);
                    nextId += rowFacesWidth;
                    ++r;
                }
            }
            this.currentRow = newCurRow;
            this.currentOffset = newCurOffset;
            if (createdRows) {
                this.fcf.pack();
            }
            this.doLayout();
            this.repaint();
            if (this.faceSB != null) {
                this.faceSB.setValue(newCurRow);
            }
        }

        public void moveCursor(int dr, int dc, KeyEvent e) throws IllegalArgumentException {
            if (dr < -3 || dr > 3) {
                throw new IllegalArgumentException("dr outside range +-3: " + dr);
            }
            if (dc < -2 || dc > 2) {
                throw new IllegalArgumentException("dc outside range +-2: " + dc);
            }
            if (e != null) {
                e.consume();
            }
            if (dr == 0 && dc == 0) {
                return;
            }
            int abs_r = (this.currentFaceId - 1) / rowFacesWidth;
            int abs_c = (this.currentFaceId - 1) % rowFacesWidth;
            boolean moved = false;
            switch (dc) {
                case -2: {
                    if (abs_c <= 0) break;
                    moved = true;
                    abs_c = 0;
                    break;
                }
                case -1: {
                    if (this.currentFaceId <= 0) break;
                    moved = true;
                    if (abs_c > 0) {
                        --abs_c;
                        break;
                    }
                    --abs_r;
                    abs_c = rowFacesWidth - 1;
                    break;
                }
                case 1: {
                    if (this.currentFaceId >= 73) break;
                    moved = true;
                    if (abs_c < rowFacesWidth - 1) {
                        ++abs_c;
                        break;
                    }
                    ++abs_r;
                    abs_c = 0;
                    break;
                }
                case 2: {
                    if (abs_c >= rowFacesWidth - 1) break;
                    moved = true;
                    abs_c = rowFacesWidth - 1;
                }
            }
            if (dr < 0 && abs_r > 0) {
                moved = true;
                if (dr == -1) {
                    --abs_r;
                } else if (dr == -3) {
                    abs_r = 0;
                } else if ((abs_r -= faceRowsHeight) < 0) {
                    abs_r = 0;
                }
            } else if (dr > 0 && abs_r < this.rowCount - 1) {
                moved = true;
                if (dr == 1) {
                    ++abs_r;
                } else if (dr == 3) {
                    abs_r = this.rowCount - 1;
                } else if ((abs_r += faceRowsHeight) >= this.rowCount) {
                    abs_r = this.rowCount - 1;
                }
            }
            if (moved) {
                int newId = abs_r * rowFacesWidth + abs_c + 1;
                if (newId >= 74) {
                    newId = 73;
                } else if (newId < 1) {
                    newId = 1;
                }
                this.selectFace(newId);
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getSource() != this.faceSB) {
                return;
            }
            int r = e.getValue();
            this.scrollToRow(r);
            this.scrollToRow(r + faceRowsHeight - 1);
        }

        protected boolean checkInsetsPadding(Insets i) {
            int sw;
            int iw = i.left + i.right;
            int ih = i.top + i.bottom;
            if (this.needsScroll) {
                sw = this.faceSB.getWidth();
                if (sw == 0 && (sw = this.faceSB.getPreferredSize().width) == 0) {
                    sw = 12;
                }
            } else {
                sw = 0;
            }
            boolean changedWantSize = false;
            if (this.padW < iw || this.padH < ih || this.scrollW < sw) {
                this.padW = iw;
                this.padH = ih;
                this.scrollW = sw;
                this.wantSize = new Dimension(this.wantW + this.scrollW + this.padW, this.wantH + this.padH);
                this.setSize(this.wantSize);
                changedWantSize = true;
            }
            boolean tooSmall = false;
            Insets fi = this.fcf.getInsets();
            if (fi != null) {
                int fw = this.fcf.getSize().width;
                int fh = this.fcf.getSize().height;
                int fiw = fw - fi.left - fi.right;
                int fih = fh - fi.top - fi.bottom;
                int fioh = 0;
                if (this.fcf.changeFaceBut != null) {
                    fioh += this.fcf.changeFaceBut.getPreferredSize().height;
                }
                if (this.fcf.promptLbl != null) {
                    fioh += this.fcf.promptLbl.getPreferredSize().height;
                }
                boolean bl = tooSmall = fiw < this.wantSize.width || fih - fioh < this.wantSize.height;
            }
            if (changedWantSize || tooSmall) {
                this.fcf.pack();
                this.fcf.checkSizeAndFocus(true);
                return true;
            }
            return false;
        }

        @Override
        public void doLayout() {
            Insets i = this.getInsets();
            int x = i.left;
            int y = i.top;
            int width = this.getSize().width - i.left - i.right;
            int height = this.getSize().height - i.top - i.bottom;
            if (this.checkInsetsPadding(i)) {
                width = this.getSize().width - this.padW;
                height = this.getSize().height - this.padH;
            }
            if (this.needsScroll) {
                if (this.scrollW == 0) {
                    IllegalStateException e = new IllegalStateException("scrollW==0");
                    this.fcf.pi.chatPrintStackTrace(e);
                    this.scrollW = this.faceSB.getPreferredSize().width;
                    if (this.scrollW == 0) {
                        this.scrollW = 12;
                    }
                    this.wantSize = new Dimension(this.wantW + this.scrollW + this.padW, this.wantH + this.padH);
                    this.setSize(this.wantSize);
                    this.fcf.pack();
                    width = this.getSize().width - this.padW;
                    height = this.getSize().height - this.padH;
                }
                this.faceSB.setLocation(x + width - this.scrollW, y);
                this.faceSB.setSize(this.scrollW, height);
            }
            int rowHeightPx = 44 * this.fcf.pi.displayScale;
            for (int r = 0; r < faceRowsHeight; ++r) {
                this.visibleFaceGrid[r].setLocation(x, y);
                this.visibleFaceGrid[r].setSize(this.wantW, rowHeightPx);
                y += rowHeightPx;
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.wantSize;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.wantSize;
        }

        private class FaceChooserRow
        extends Container {
            private final int startFaceId;
            private SOCFaceButton[] faces;

            public FaceChooserRow(int startId) throws IllegalArgumentException {
                if (startId <= 0 || startId >= 74) {
                    throw new IllegalArgumentException("startId not within range: " + startId);
                }
                this.startFaceId = startId;
                int numFaces = rowFacesWidth;
                if (startId + numFaces >= 74) {
                    numFaces = 74 - startId;
                }
                this.faces = new SOCFaceButton[numFaces];
                GridLayout glay = new GridLayout(1, rowFacesWidth, 0, 0);
                this.setLayout(glay);
                for (int i = 0; i < numFaces; ++i) {
                    SOCFaceButton fb;
                    this.faces[i] = fb = new SOCFaceButton(FaceChooserList.this.fcf.pi, FaceChooserList.this.fcf, startId + i);
                    if (startId + i == FaceChooserList.this.currentFaceId) {
                        fb.setHilightBorder(true);
                    }
                    fb.addKeyListener(FaceChooserList.this.fcf);
                    this.add(fb);
                }
                if (numFaces < rowFacesWidth) {
                    Color bg = this.faces[0].getBackground();
                    for (int i = numFaces; i < rowFacesWidth; ++i) {
                        JLabel la = new JLabel();
                        la.setBackground(bg);
                        la.setOpaque(true);
                        this.add(la);
                    }
                }
            }

            public void setFaceHilightBorder(int faceId, boolean borderSet) {
                if ((faceId -= this.startFaceId) < 0 || faceId >= this.faces.length) {
                    return;
                }
                this.faces[faceId].setHilightBorder(borderSet);
            }

            @Override
            public void setVisible(boolean vis) {
                for (int i = this.faces.length - 1; i >= 0; --i) {
                    this.faces[i].setVisible(vis);
                }
                super.setVisible(vis);
            }
        }
    }
}

