/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.util.Map;
import soc.client.ClientNetwork;
import soc.client.PlayerClientListener;
import soc.client.SOCPlayerClient;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCTradeOffer;
import soc.message.SOCAcceptOffer;
import soc.message.SOCBankTrade;
import soc.message.SOCBuildRequest;
import soc.message.SOCBuyDevCardRequest;
import soc.message.SOCCancelBuildRequest;
import soc.message.SOCChangeFace;
import soc.message.SOCChoosePlayer;
import soc.message.SOCClearOffer;
import soc.message.SOCDebugFreePlace;
import soc.message.SOCDiscard;
import soc.message.SOCEndTurn;
import soc.message.SOCGameTextMsg;
import soc.message.SOCInventoryItemAction;
import soc.message.SOCLeaveGame;
import soc.message.SOCMakeOffer;
import soc.message.SOCMessage;
import soc.message.SOCMovePiece;
import soc.message.SOCMoveRobber;
import soc.message.SOCPickResourceType;
import soc.message.SOCPickResources;
import soc.message.SOCPlayDevCardRequest;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectOffer;
import soc.message.SOCResetBoardRequest;
import soc.message.SOCResetBoardVote;
import soc.message.SOCRollDice;
import soc.message.SOCSetSeatLock;
import soc.message.SOCSetSpecialItem;
import soc.message.SOCSimpleRequest;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCUndoPutPiece;

class GameMessageSender {
    private final SOCPlayerClient client;
    private final ClientNetwork net;
    private final Map<String, PlayerClientListener> clientListeners;

    GameMessageSender(SOCPlayerClient client, Map<String, PlayerClientListener> clientListeners) {
        this.client = client;
        if (client == null) {
            throw new IllegalArgumentException("client is null");
        }
        this.net = client.getNet();
        if (this.net == null) {
            throw new IllegalArgumentException("client network is null");
        }
        this.clientListeners = clientListeners;
    }

    public synchronized boolean put(String s, boolean isPractice) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("s null");
        }
        if (isPractice) {
            return this.net.putPractice(s);
        }
        return this.net.putNet(s);
    }

    public synchronized boolean put(SOCMessage msg, boolean isPractice) throws IllegalArgumentException {
        if (msg == null) {
            throw new IllegalArgumentException("msg null");
        }
        return this.put(msg.toCmd(), isPractice);
    }

    public void buyDevCard(SOCGame ga) {
        this.put(new SOCBuyDevCardRequest(ga.getName()).toCmd(), ga.isPractice);
    }

    public void buildRequest(SOCGame ga, int piece) throws IllegalArgumentException {
        this.put(new SOCBuildRequest(ga.getName(), piece).toCmd(), ga.isPractice);
    }

    public void cancelBuildRequest(SOCGame ga, int piece) {
        this.put(new SOCCancelBuildRequest(ga.getName(), piece).toCmd(), ga.isPractice);
    }

    public void putPiece(SOCGame ga, SOCPlayingPiece pp) throws IllegalArgumentException {
        int co = pp.getCoordinates();
        String ppm = ga.isDebugFreePlacement() ? SOCDebugFreePlace.toCmd(ga.getName(), pp.getPlayerNumber(), pp.getType(), co) : SOCPutPiece.toCmd(ga.getName(), pp.getPlayerNumber(), pp.getType(), co);
        this.put(ppm, ga.isPractice);
    }

    public void movePieceRequest(SOCGame ga, int pn, int ptype, int fromCoord, int toCoord) throws IllegalArgumentException {
        this.put(SOCMovePiece.toCmd(ga.getName(), pn, ptype, fromCoord, toCoord), ga.isPractice);
    }

    public void undoPutOrMovePieceRequest(SOCGame ga, int ptype, int coord, int movedFromCoord) throws IllegalArgumentException {
        this.put(new SOCUndoPutPiece(ga.getName(), ga.getCurrentPlayerNumber(), ptype, coord, movedFromCoord).toCmd(), ga.isPractice);
    }

    public void moveRobber(SOCGame ga, SOCPlayer pl, int coord) {
        this.put(SOCMoveRobber.toCmd(ga.getName(), pl.getPlayerNumber(), coord), ga.isPractice);
    }

    public void sendSimpleRequest(SOCPlayer pl, int reqtype) {
        this.sendSimpleRequest(pl, reqtype, 0, 0);
    }

    public void sendSimpleRequest(SOCPlayer pl, int reqtype, int value1, int value2) {
        SOCGame ga = pl.getGame();
        this.put(SOCSimpleRequest.toCmd(ga.getName(), pl.getPlayerNumber(), reqtype, value1, value2), ga.isPractice);
    }

    public void sendText(SOCGame ga, String txt) {
        this.put(new SOCGameTextMsg(ga.getName(), "-", txt).toCmd(), ga.isPractice);
    }

    public void leaveGame(SOCGame ga) {
        this.clientListeners.remove(ga.getName());
        this.client.games.remove(ga.getName());
        this.put(SOCLeaveGame.toCmd("-", "-", ga.getName()), ga.isPractice);
    }

    public void sitDown(SOCGame ga, int pn) {
        this.put(SOCSitDown.toCmd(ga.getName(), "\t", pn, false), ga.isPractice);
    }

    public void startGame(SOCGame ga) {
        this.put(SOCStartGame.toCmd(ga.getName(), 0), ga.isPractice);
    }

    public void rollDice(SOCGame ga) {
        this.put(SOCRollDice.toCmd(ga.getName()), ga.isPractice);
    }

    public void endTurn(SOCGame ga) {
        this.put(SOCEndTurn.toCmd(ga.getName()), ga.isPractice);
    }

    public void discard(SOCGame ga, SOCResourceSet rs) {
        this.put(new SOCDiscard(ga.getName(), -1, rs), ga.isPractice);
    }

    public void pickResources(SOCGame ga, SOCResourceSet rs) {
        this.put(new SOCPickResources(ga.getName(), rs).toCmd(), ga.isPractice);
    }

    public void choosePlayer(SOCGame ga, int ch) {
        this.put(SOCChoosePlayer.toCmd(ga.getName(), ch), ga.isPractice);
    }

    public void chooseRobber(SOCGame ga) {
        this.choosePlayer(ga, -2);
    }

    public void choosePirate(SOCGame ga) {
        this.choosePlayer(ga, -3);
    }

    public void rejectOffer(SOCGame ga) {
        this.put(new SOCRejectOffer(ga.getName(), 0), ga.isPractice);
    }

    public void acceptOffer(SOCGame ga, int offeringPN) {
        this.put(new SOCAcceptOffer(ga.getName(), 0, offeringPN), ga.isPractice);
    }

    public void clearOffer(SOCGame ga) {
        this.put(SOCClearOffer.toCmd(ga.getName(), 0), ga.isPractice);
    }

    public void bankTrade(SOCGame ga, SOCResourceSet give, SOCResourceSet get) {
        this.put(new SOCBankTrade(ga.getName(), give, get, -1).toCmd(), ga.isPractice);
    }

    public void offerTrade(SOCGame ga, SOCTradeOffer offer) {
        this.put(SOCMakeOffer.toCmd(ga.getName(), offer), ga.isPractice);
    }

    public void playDevCard(SOCGame ga, int dc) {
        if (!ga.isPractice && this.client.sVersion < 2000) {
            if (dc == 9) {
                dc = 0;
            } else if (dc == 0) {
                dc = 9;
            }
        }
        this.put(SOCPlayDevCardRequest.toCmd(ga.getName(), dc), ga.isPractice);
    }

    public void playInventoryItem(SOCGame ga, int itype) {
        this.put(SOCInventoryItemAction.toCmd(ga.getName(), ga.getCurrentPlayerNumber(), 4, itype, 0), ga.isPractice);
    }

    public void pickSpecialItem(SOCGame ga, String typeKey, int gi, int pi) {
        this.put(new SOCSetSpecialItem(ga.getName(), 3, typeKey, gi, pi, -1).toCmd(), ga.isPractice);
    }

    public void pickResourceType(SOCGame ga, int res) {
        this.put(new SOCPickResourceType(ga.getName(), res).toCmd(), ga.isPractice);
    }

    public void changeFace(SOCGame ga, int id) {
        this.client.lastFaceChange = id;
        this.put(new SOCChangeFace(ga.getName(), 0, id).toCmd(), ga.isPractice);
    }

    public void setSeatLock(SOCGame ga, int pn, SOCGame.SeatLockState sl) {
        this.put(SOCSetSeatLock.toCmd(ga.getName(), pn, sl), ga.isPractice);
    }

    public void resetBoardRequest(SOCGame ga) {
        this.put(SOCResetBoardRequest.toCmd(1073, ga.getName()), ga.isPractice);
    }

    public void resetBoardVote(SOCGame ga, boolean voteYes) {
        this.put(SOCResetBoardVote.toCmd(ga.getName(), 0, voteYes), ga.isPractice);
    }

    public void considerMove(SOCGame ga, SOCPlayer robotPlayer, SOCPlayingPiece piece) {
        String msg = robotPlayer.getName() + ":consider-move ";
        switch (piece.getType()) {
            case 1: {
                msg = msg + "settlement";
                break;
            }
            case 0: {
                msg = msg + "road";
                break;
            }
            case 3: {
                msg = msg + "ship";
                break;
            }
            case 2: {
                msg = msg + "city";
            }
        }
        msg = msg + " " + piece.getCoordinates();
        this.sendText(ga, msg);
    }

    public void considerTarget(SOCGame ga, SOCPlayer robotPlayer, SOCPlayingPiece piece) {
        String msg = robotPlayer.getName() + ":consider-target ";
        switch (piece.getType()) {
            case 1: {
                msg = msg + "settlement";
                break;
            }
            case 0: {
                msg = msg + "road";
                break;
            }
            case 3: {
                msg = msg + "ship";
                break;
            }
            case 2: {
                msg = msg + "city";
            }
        }
        msg = msg + " " + piece.getCoordinates();
        this.sendText(ga, msg);
    }
}

