/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import soc.baseclient.SOCDisplaylessPlayerClient;
import soc.client.GameMessageSender;
import soc.client.MainDisplay;
import soc.client.PlayerClientListener;
import soc.client.SOCPlayerClient;
import soc.client.ServerGametypeInfo;
import soc.disableDebug.D;
import soc.game.SOCBoardLarge;
import soc.game.SOCFortress;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCScenario;
import soc.game.SOCSettlement;
import soc.game.SOCTradeOffer;
import soc.game.SOCVillage;
import soc.message.SOCAcceptOffer;
import soc.message.SOCBCastTextMsg;
import soc.message.SOCBankTrade;
import soc.message.SOCBoardLayout;
import soc.message.SOCBoardLayout2;
import soc.message.SOCCancelBuildRequest;
import soc.message.SOCChangeFace;
import soc.message.SOCChannelMembers;
import soc.message.SOCChannelTextMsg;
import soc.message.SOCChannels;
import soc.message.SOCChoosePlayer;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCClearTradeMsg;
import soc.message.SOCDebugFreePlace;
import soc.message.SOCDeclinePlayerRequest;
import soc.message.SOCDeleteChannel;
import soc.message.SOCDeleteGame;
import soc.message.SOCDevCardAction;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiceResultResources;
import soc.message.SOCDiscard;
import soc.message.SOCDiscardRequest;
import soc.message.SOCFirstPlayer;
import soc.message.SOCGameElements;
import soc.message.SOCGameMembers;
import soc.message.SOCGameOptionGetDefaults;
import soc.message.SOCGameOptionGetInfos;
import soc.message.SOCGameOptionInfo;
import soc.message.SOCGameServerText;
import soc.message.SOCGameState;
import soc.message.SOCGameStats;
import soc.message.SOCGameTextMsg;
import soc.message.SOCGames;
import soc.message.SOCGamesWithOptions;
import soc.message.SOCInventoryItemAction;
import soc.message.SOCJoinChannel;
import soc.message.SOCJoinChannelAuth;
import soc.message.SOCJoinGame;
import soc.message.SOCJoinGameAuth;
import soc.message.SOCLargestArmy;
import soc.message.SOCLastSettlement;
import soc.message.SOCLeaveChannel;
import soc.message.SOCLeaveGame;
import soc.message.SOCLocalizedStrings;
import soc.message.SOCLongestRoad;
import soc.message.SOCMakeOffer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;
import soc.message.SOCMovePiece;
import soc.message.SOCMoveRobber;
import soc.message.SOCNewChannel;
import soc.message.SOCNewGame;
import soc.message.SOCNewGameWithOptions;
import soc.message.SOCPickResources;
import soc.message.SOCPieceValue;
import soc.message.SOCPlayerElement;
import soc.message.SOCPlayerElements;
import soc.message.SOCPlayerStats;
import soc.message.SOCPotentialSettlements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectConnection;
import soc.message.SOCRejectOffer;
import soc.message.SOCRemovePiece;
import soc.message.SOCResetBoardAuth;
import soc.message.SOCResetBoardReject;
import soc.message.SOCResetBoardVote;
import soc.message.SOCResetBoardVoteRequest;
import soc.message.SOCResourceCount;
import soc.message.SOCRevealFogHex;
import soc.message.SOCRobberyResult;
import soc.message.SOCRollDicePrompt;
import soc.message.SOCSVPTextMessage;
import soc.message.SOCScenarioInfo;
import soc.message.SOCServerPing;
import soc.message.SOCSetLastAction;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetSeatLock;
import soc.message.SOCSetShipRouteClosed;
import soc.message.SOCSetSpecialItem;
import soc.message.SOCSetTurn;
import soc.message.SOCSimpleAction;
import soc.message.SOCSimpleRequest;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCStatusMessage;
import soc.message.SOCTurn;
import soc.message.SOCUndoNotAllowedReasonText;
import soc.message.SOCUndoPutPiece;
import soc.message.SOCVersion;
import soc.util.SOCFeatureSet;
import soc.util.SOCGameList;
import soc.util.Version;

public class MessageHandler {
    private SOCPlayerClient client;
    private GameMessageSender gms;

    public void init(SOCPlayerClient cli) throws IllegalArgumentException {
        if (cli == null) {
            throw new IllegalArgumentException("client is null");
        }
        this.client = cli;
        this.gms = cli.getGameMessageSender();
        if (this.gms == null) {
            throw new IllegalArgumentException("client GameMessageSender is null");
        }
    }

    public SOCPlayerClient getClient() {
        return this.client;
    }

    public void handle(SOCMessage mes, boolean isPractice) {
        if (mes == null) {
            return;
        }
        if (this.client.debugTraffic || D.ebugIsEnabled()) {
            soc.debug.D.ebugPrintlnINFO(mes.toString());
        }
        try {
            SOCGame ga;
            if (mes instanceof SOCMessageForGame) {
                String gaName = ((SOCMessageForGame)((Object)mes)).getGame();
                ga = gaName != null ? this.client.games.get(gaName) : null;
            } else {
                Object gaName = null;
                ga = null;
            }
            switch (mes.getType()) {
                case 9999: {
                    this.handleSERVERPING((SOCServerPing)mes, isPractice);
                    break;
                }
                case 9998: {
                    this.handleVERSION(isPractice, (SOCVersion)mes);
                    break;
                }
                case 1069: {
                    this.handleSTATUSMESSAGE((SOCStatusMessage)mes, isPractice);
                    break;
                }
                case 1020: {
                    this.handleJOINCHANNELAUTH((SOCJoinChannelAuth)mes);
                    break;
                }
                case 1004: {
                    this.handleJOINCHANNEL((SOCJoinChannel)mes);
                    break;
                }
                case 1002: {
                    this.handleCHANNELMEMBERS((SOCChannelMembers)mes);
                    break;
                }
                case 1001: {
                    this.handleNEWCHANNEL((SOCNewChannel)mes);
                    break;
                }
                case 1003: {
                    this.handleCHANNELS((SOCChannels)mes, isPractice);
                    break;
                }
                case 1005: {
                    this.handleCHANNELTEXTMSG((SOCChannelTextMsg)mes);
                    break;
                }
                case 1006: {
                    this.handleLEAVECHANNEL((SOCLeaveChannel)mes);
                    break;
                }
                case 1007: {
                    this.handleDELETECHANNEL((SOCDeleteChannel)mes);
                    break;
                }
                case 1019: {
                    this.handleGAMES((SOCGames)mes, isPractice);
                    break;
                }
                case 1021: {
                    this.handleJOINGAMEAUTH((SOCJoinGameAuth)mes, isPractice);
                    break;
                }
                case 1013: {
                    this.handleJOINGAME((SOCJoinGame)mes);
                    break;
                }
                case 1011: {
                    this.handleLEAVEGAME((SOCLeaveGame)mes);
                    break;
                }
                case 1016: {
                    this.handleNEWGAME((SOCNewGame)mes, isPractice);
                    break;
                }
                case 1015: {
                    this.handleDELETEGAME((SOCDeleteGame)mes, isPractice);
                    break;
                }
                case 1017: {
                    this.handleGAMEMEMBERS((SOCGameMembers)mes);
                    break;
                }
                case 1061: {
                    this.handleGAMESTATS((SOCGameStats)mes);
                    break;
                }
                case 1010: {
                    this.handleGAMETEXTMSG((SOCGameTextMsg)mes);
                    break;
                }
                case 1062: {
                    this.handleBCASTTEXTMSG((SOCBCastTextMsg)mes);
                    break;
                }
                case 1012: {
                    this.handleSITDOWN((SOCSitDown)mes);
                    break;
                }
                case 1014: {
                    this.handleBOARDLAYOUT((SOCBoardLayout)mes);
                    break;
                }
                case 1084: {
                    this.handleBOARDLAYOUT2((SOCBoardLayout2)mes);
                    break;
                }
                case 1018: {
                    this.handleSTARTGAME((SOCStartGame)mes);
                    break;
                }
                case 1025: {
                    this.handleGAMESTATE((SOCGameState)mes);
                    break;
                }
                case 1055: {
                    this.handleGAMEELEMENT(ga, SOCGameElements.GEType.CURRENT_PLAYER, ((SOCSetTurn)mes).getPlayerNumber());
                    break;
                }
                case 1054: {
                    this.handleGAMEELEMENT(ga, SOCGameElements.GEType.FIRST_PLAYER, ((SOCFirstPlayer)mes).getPlayerNumber());
                    break;
                }
                case 1026: {
                    this.handleTURN((SOCTurn)mes);
                    break;
                }
                case 1024: {
                    this.handlePLAYERELEMENT((SOCPlayerElement)mes);
                    break;
                }
                case 1086: {
                    this.handlePLAYERELEMENTS((SOCPlayerElements)mes);
                    break;
                }
                case 1096: {
                    this.handleGAMEELEMENTS((SOCGameElements)mes);
                    break;
                }
                case 1063: {
                    this.handleRESOURCECOUNT((SOCResourceCount)mes);
                    break;
                }
                case 1060: {
                    SOCDisplaylessPlayerClient.handleLASTSETTLEMENT((SOCLastSettlement)mes, this.client.games.get(((SOCLastSettlement)mes).getGame()));
                    break;
                }
                case 1028: {
                    this.handleDICERESULT((SOCDiceResult)mes);
                    break;
                }
                case 1009: {
                    this.handlePUTPIECE((SOCPutPiece)mes);
                    break;
                }
                case 1044: {
                    this.handleCANCELBUILDREQUEST((SOCCancelBuildRequest)mes);
                    break;
                }
                case 1034: {
                    this.handleMOVEROBBER((SOCMoveRobber)mes);
                    break;
                }
                case 1029: {
                    this.handleDISCARDREQUEST((SOCDiscardRequest)mes);
                    break;
                }
                case 1036: {
                    this.handleCHOOSEPLAYERREQUEST((SOCChoosePlayerRequest)mes);
                    break;
                }
                case 1035: {
                    this.handleCHOOSEPLAYER((SOCChoosePlayer)mes);
                    break;
                }
                case 1033: {
                    this.handleDISCARD((SOCDiscard)mes);
                    break;
                }
                case 1040: {
                    this.handleBANKTRADE((SOCBankTrade)mes, isPractice);
                    break;
                }
                case 1041: {
                    this.handleMAKEOFFER((SOCMakeOffer)mes);
                    break;
                }
                case 1038: {
                    this.handleCLEAROFFER((SOCClearOffer)mes);
                    break;
                }
                case 1037: {
                    this.handleREJECTOFFER((SOCRejectOffer)mes);
                    break;
                }
                case 1039: {
                    this.handleACCEPTOFFER((SOCAcceptOffer)mes);
                    break;
                }
                case 1042: {
                    this.handleCLEARTRADEMSG((SOCClearTradeMsg)mes);
                    break;
                }
                case 1047: {
                    this.handleGAMEELEMENT(ga, SOCGameElements.GEType.DEV_CARD_COUNT, ((SOCDevCardCount)mes).getNumDevCards());
                    break;
                }
                case 1046: {
                    this.handleDEVCARDACTION(isPractice, (SOCDevCardAction)mes);
                    break;
                }
                case 1048: {
                    this.handleSETPLAYEDDEVCARD((SOCSetPlayedDevCard)mes);
                    break;
                }
                case 1057: {
                    this.handlePOTENTIALSETTLEMENTS((SOCPotentialSettlements)mes);
                    break;
                }
                case 1058: {
                    this.handleCHANGEFACE((SOCChangeFace)mes);
                    break;
                }
                case 1059: {
                    this.handleREJECTCONNECTION((SOCRejectConnection)mes);
                    break;
                }
                case 1066: {
                    this.handleGAMEELEMENT(ga, SOCGameElements.GEType.LONGEST_ROAD_PLAYER, ((SOCLongestRoad)mes).getPlayerNumber());
                    break;
                }
                case 1067: {
                    this.handleGAMEELEMENT(ga, SOCGameElements.GEType.LARGEST_ARMY_PLAYER, ((SOCLargestArmy)mes).getPlayerNumber());
                    break;
                }
                case 1068: {
                    this.handleSETSEATLOCK((SOCSetSeatLock)mes);
                    break;
                }
                case 1072: {
                    this.handleROLLDICEPROMPT((SOCRollDicePrompt)mes);
                    break;
                }
                case 1074: {
                    this.handleRESETBOARDAUTH((SOCResetBoardAuth)mes);
                    break;
                }
                case 1075: {
                    this.handleRESETBOARDVOTEREQUEST((SOCResetBoardVoteRequest)mes);
                    break;
                }
                case 1076: {
                    this.handleRESETBOARDVOTE((SOCResetBoardVote)mes);
                    break;
                }
                case 1077: {
                    this.handleRESETBOARDREJECT((SOCResetBoardReject)mes);
                    break;
                }
                case 1080: {
                    this.handleGAMEOPTIONGETDEFAULTS((SOCGameOptionGetDefaults)mes, isPractice);
                    break;
                }
                case 1082: {
                    this.handleGAMEOPTIONINFO((SOCGameOptionInfo)mes, isPractice);
                    break;
                }
                case 1079: {
                    this.handleNEWGAMEWITHOPTIONS((SOCNewGameWithOptions)mes, isPractice);
                    break;
                }
                case 1083: {
                    this.handleGAMESWITHOPTIONS((SOCGamesWithOptions)mes, isPractice);
                    break;
                }
                case 1085: {
                    this.handlePLAYERSTATS((SOCPlayerStats)mes);
                    break;
                }
                case 1087: {
                    this.handleDEBUGFREEPLACE((SOCDebugFreePlace)mes);
                    break;
                }
                case 1089: {
                    this.handleSIMPLEREQUEST((SOCSimpleRequest)mes);
                    break;
                }
                case 1090: {
                    this.handleSIMPLEACTION((SOCSimpleAction)mes);
                    break;
                }
                case 1091: {
                    this.handleGAMESERVERTEXT((SOCGameServerText)mes);
                    break;
                }
                case 1092: {
                    this.handleDICERESULTRESOURCES((SOCDiceResultResources)mes);
                    break;
                }
                case 1093: {
                    this.handleMOVEPIECE((SOCMovePiece)mes);
                    break;
                }
                case 1094: {
                    this.handleREMOVEPIECE((SOCRemovePiece)mes);
                    break;
                }
                case 10001: {
                    this.handleREVEALFOGHEX((SOCRevealFogHex)mes);
                    break;
                }
                case 1095: {
                    this.handlePIECEVALUE((SOCPieceValue)mes);
                    break;
                }
                case 1097: {
                    this.handleSVPTEXTMSG((SOCSVPTextMessage)mes);
                    break;
                }
                case 1098: {
                    this.handleINVENTORYITEMACTION((SOCInventoryItemAction)mes);
                    break;
                }
                case 1099: {
                    this.handleSETSPECIALITEM(this.client.games, (SOCSetSpecialItem)mes);
                    break;
                }
                case 1100: {
                    this.handleLOCALIZEDSTRINGS((SOCLocalizedStrings)mes, isPractice);
                    break;
                }
                case 1101: {
                    this.handleSCENARIOINFO((SOCScenarioInfo)mes, isPractice);
                    break;
                }
                case 1102: {
                    this.handleROBBERYRESULT((SOCRobberyResult)mes, this.client.games.get(((SOCMessageForGame)((Object)mes)).getGame()));
                    break;
                }
                case 1052: {
                    this.handlePICKRESOURCES((SOCPickResources)mes, this.client.games.get(((SOCMessageForGame)((Object)mes)).getGame()));
                    break;
                }
                case 1104: {
                    this.handleDECLINEPLAYERREQUEST((SOCDeclinePlayerRequest)mes);
                    break;
                }
                case 1105: {
                    this.handleUNDOPUTPIECE((SOCUndoPutPiece)mes);
                    break;
                }
                case 1106: {
                    SOCDisplaylessPlayerClient.handleSETLASTACTION((SOCSetLastAction)mes, this.client.games.get(((SOCSetLastAction)mes).getGame()));
                    break;
                }
                case 1107: {
                    SOCDisplaylessPlayerClient.handleUNDONOTALLOWEDREASONTEXT((SOCUndoNotAllowedReasonText)mes, this.client.games.get(((SOCUndoNotAllowedReasonText)mes).getGame()));
                    break;
                }
                case 10002: {
                    SOCDisplaylessPlayerClient.handleSETSHIPROUTECLOSED((SOCSetShipRouteClosed)mes, this.client.games.get(((SOCSetShipRouteClosed)mes).getGame()));
                }
            }
        }
        catch (Throwable th) {
            System.out.println("SOCPlayerClient treat ERROR - " + th.getMessage());
            th.printStackTrace();
            System.out.println("  For message: " + mes);
        }
    }

    private void handleVERSION(boolean isPractice, SOCVersion mes) {
        SOCGameOptionSet opts3p;
        int cliVersion;
        D.ebugPrintlnINFO("handleVERSION: " + mes);
        int vers = mes.getVersionNumber();
        if (!isPractice) {
            this.client.sVersion = vers;
            this.client.sFeatures = vers >= 1119 ? new SOCFeatureSet(mes.feats) : new SOCFeatureSet(true, true);
            this.client.getMainDisplay().showVersion(vers, mes.getVersionString(), mes.getBuild(), this.client.sFeatures);
        }
        boolean sameVersion = this.client.sVersion == (cliVersion = Version.versionNumber());
        boolean withTokenI18n = !(this.client.cliLocale == null || !isPractice && this.client.sVersion < 2000 || "en".equals(this.client.cliLocale.getLanguage()) && "US".equals(this.client.cliLocale.getCountry()));
        SOCGameOptionSet sOCGameOptionSet = opts3p = this.client.sVersion >= cliVersion && !isPractice ? this.client.tcpServGameOpts.knownOpts.optionsWithFlag(16, 0) : null;
        if (!isPractice && this.client.sVersion > cliVersion || (isPractice || sameVersion) && (withTokenI18n || opts3p != null)) {
            SOCGameOptionGetInfos ogiMsg;
            if (opts3p != null) {
                ArrayList<String> olist = new ArrayList<String>(opts3p.keySet());
                if (!sameVersion) {
                    olist.add("?CHANGES");
                }
                ogiMsg = new SOCGameOptionGetInfos(olist, withTokenI18n, false);
            } else {
                ogiMsg = new SOCGameOptionGetInfos(null, withTokenI18n, withTokenI18n && sameVersion);
            }
            if (!isPractice) {
                this.client.getMainDisplay().optionsRequested();
            }
            this.gms.put(ogiMsg.toCmd(), isPractice);
        } else if (this.client.sVersion < cliVersion && !isPractice) {
            if (this.client.sVersion >= 1107) {
                List<SOCGameOption> tooNewOpts;
                SOCGameOptionSet knownOpts = this.client.tcpServGameOpts.knownOpts;
                if (knownOpts == null) {
                    this.client.tcpServGameOpts.knownOpts = knownOpts = SOCGameOptionSet.getAllKnownOptions();
                }
                if ((tooNewOpts = knownOpts.optionsNewerThanVersion(this.client.sVersion, false, false)) != null && this.client.sVersion < 2000) {
                    Iterator<SOCGameOption> opi = tooNewOpts.iterator();
                    while (opi.hasNext()) {
                        SOCGameOption op = opi.next();
                        if (op.key.length() <= 3 && !op.key.contains("_")) continue;
                        knownOpts.remove(op.key);
                        opi.remove();
                    }
                    if (tooNewOpts.isEmpty()) {
                        tooNewOpts = null;
                    }
                }
                if (tooNewOpts != null) {
                    this.client.getMainDisplay().optionsRequested();
                    this.gms.put(new SOCGameOptionGetInfos(tooNewOpts, withTokenI18n).toCmd(), isPractice);
                } else if (withTokenI18n) {
                    this.gms.put(new SOCGameOptionGetInfos(null, true, false).toCmd(), false);
                }
            } else {
                this.client.tcpServGameOpts.noMoreOptions(true);
                this.client.tcpServGameOpts.knownOpts = null;
            }
        } else {
            ServerGametypeInfo opts;
            ServerGametypeInfo serverGametypeInfo = opts = isPractice ? this.client.practiceServGameOpts : this.client.tcpServGameOpts;
            if (opts.knownOpts == null) {
                opts.knownOpts = SOCGameOptionSet.getAllKnownOptions();
            }
            opts.noMoreOptions(isPractice);
            if (!withTokenI18n && !isPractice) {
                opts.allScenStringsReceived = true;
                opts.allScenInfoReceived = true;
            }
        }
    }

    protected void handleSTATUSMESSAGE(SOCStatusMessage mes, boolean isPractice) {
        boolean srvDebugMode;
        int sv = mes.getStatusValue();
        String statusText = mes.getStatus();
        if (sv == 20) {
            sv = 0;
            int i = statusText.indexOf(44);
            if (i > 0) {
                this.client.nickname = statusText.substring(0, i);
                statusText = statusText.substring(i + 1);
                this.client.getMainDisplay().setNickname(this.client.nickname);
            }
        }
        if (isPractice || this.client.sVersion >= 2000) {
            boolean svIsOKDebug;
            srvDebugMode = svIsOKDebug = sv == 21;
            if (svIsOKDebug) {
                sv = 0;
            }
        } else {
            srvDebugMode = statusText.toLowerCase().contains("debug");
        }
        this.client.getMainDisplay().showStatus(statusText, sv == 0, srvDebugMode);
        if (!isPractice && this.client.isNGOFWaitingForAuthStatus) {
            this.client.isNGOFWaitingForAuthStatus = false;
            if (sv == 0) {
                this.client.gotPassword = true;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageHandler.this.client.getMainDisplay().gameWithOptionsBeginSetup(false, true);
                    }
                });
            }
        }
        switch (sv) {
            case 3: {
                this.client.getMainDisplay().focusPassword();
                break;
            }
            case 10: {
                String errMsg;
                StringTokenizer st = new StringTokenizer(statusText, ",");
                try {
                    String gameName = null;
                    ArrayList<String> optNames = new ArrayList<String>();
                    errMsg = st.nextToken();
                    gameName = st.nextToken();
                    while (st.hasMoreTokens()) {
                        optNames.add(st.nextToken());
                    }
                    StringBuffer opts = new StringBuffer();
                    SOCGameOptionSet knowns = isPractice ? this.client.practiceServGameOpts.knownOpts : this.client.tcpServGameOpts.knownOpts;
                    for (String oname : optNames) {
                        opts.append('\n');
                        SOCGameOption oinfo = null;
                        if (knowns != null) {
                            oinfo = knowns.get(oname);
                        }
                        if (oinfo != null) {
                            oname = oinfo.getDesc();
                        }
                        opts.append(this.client.strings.get("options.error.valuesproblem.which", oname));
                    }
                    errMsg = this.client.strings.get("options.error.valuesproblem", gameName, errMsg, opts.toString());
                }
                catch (Throwable t) {
                    errMsg = statusText;
                }
                this.client.getMainDisplay().showErrorDialog(errMsg, this.client.strings.get("base.cancel"));
                break;
            }
            case 22: {
                String errMsg;
                StringTokenizer st = new StringTokenizer(statusText, ",");
                try {
                    errMsg = st.nextToken();
                    String gameName = st.nextToken();
                    String featsList = st.hasMoreTokens() ? st.nextToken() : "?";
                    String msgKey = this.client.doesGameExist(gameName, true) ? "pcli.gamelist.client_feats.cannot_join" : "pcli.gamelist.client_feats.cannot_create";
                    errMsg = this.client.strings.get(msgKey, gameName, featsList);
                }
                catch (Throwable t) {
                    errMsg = statusText;
                }
                this.client.getMainDisplay().showErrorDialog(errMsg, this.client.strings.get("base.cancel"));
                break;
            }
            case 23: {
                this.handleBCASTTEXTMSG(statusText);
                this.client.getNet().ex = new RuntimeException(statusText);
                this.client.shutdownFromNetwork();
            }
        }
    }

    protected void handleJOINCHANNELAUTH(SOCJoinChannelAuth mes) {
        this.client.gotPassword = true;
        this.client.getMainDisplay().channelJoined(mes.getChannel());
    }

    protected void handleJOINCHANNEL(SOCJoinChannel mes) {
        this.client.getMainDisplay().channelJoined(mes.getChannel(), mes.getNickname());
    }

    protected void handleCHANNELMEMBERS(SOCChannelMembers mes) {
        this.client.getMainDisplay().channelMemberList(mes.getChannel(), mes.getMembers());
    }

    protected void handleNEWCHANNEL(SOCNewChannel mes) {
        this.client.getMainDisplay().channelCreated(mes.getChannel());
    }

    protected void handleCHANNELS(final SOCChannels mes, final boolean isPractice) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainDisplay mdisp = MessageHandler.this.client.getMainDisplay();
                mdisp.channelList(mes.getChannels(), isPractice);
                mdisp.repaintGameAndChannelLists();
            }
        });
    }

    protected void handleBCASTTEXTMSG(SOCBCastTextMsg mes) {
        this.handleBCASTTEXTMSG(mes.getText());
    }

    protected void handleBCASTTEXTMSG(final String txt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageHandler.this.client.getMainDisplay().chatMessageBroadcast(txt);
                for (PlayerClientListener pcl : MessageHandler.this.client.getClientListeners().values()) {
                    pcl.messageBroadcast(txt);
                }
            }
        });
    }

    protected void handleCHANNELTEXTMSG(SOCChannelTextMsg mes) {
        this.client.getMainDisplay().chatMessageReceived(mes.getChannel(), mes.getNickname(), mes.getText());
    }

    protected void handleLEAVECHANNEL(SOCLeaveChannel mes) {
        this.client.getMainDisplay().channelLeft(mes.getChannel(), mes.getNickname());
    }

    protected void handleDELETECHANNEL(SOCDeleteChannel mes) {
        final String chName = mes.getChannel();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageHandler.this.client.getMainDisplay().channelDeleted(chName);
            }
        });
    }

    protected void handleGAMES(final SOCGames mes, boolean isPractice) {
        List<String> gameNames = mes.getGames();
        if (!isPractice) {
            if (this.client.serverGames == null) {
                this.client.serverGames = new SOCGameList(this.client.tcpServGameOpts.knownOpts);
            }
            this.client.serverGames.addGames(gameNames, Version.versionNumber());
            this.client.tcpServGameOpts.noMoreOptions(false);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String gn : mes.getGames()) {
                    MessageHandler.this.client.addToGameList(gn, null, false);
                }
                MessageHandler.this.client.getMainDisplay().repaintGameAndChannelLists();
            }
        });
    }

    protected void handleJOINGAMEAUTH(SOCJoinGameAuth mes, boolean isPractice) throws IllegalStateException {
        SOCGame ga;
        SOCGameOptionSet gameOpts;
        if (!isPractice) {
            this.client.gotPassword = true;
        }
        SOCGameOptionSet knownOpts = (isPractice ? this.client.practiceServGameOpts : this.client.tcpServGameOpts).knownOpts;
        String gaName = mes.getGame();
        if (isPractice) {
            gameOpts = this.client.getNet().practiceServer.getGameOptions(gaName);
            if (gameOpts != null) {
                gameOpts = new SOCGameOptionSet(gameOpts, false);
            }
        } else {
            gameOpts = this.client.serverGames != null ? this.client.serverGames.parseGameOptions(gaName) : null;
        }
        int bh = mes.getBoardHeight();
        int bw = mes.getBoardWidth();
        if (bh != 0 || bw != 0) {
            SOCGameOption opt = knownOpts.getKnownOption("_BHW", true);
            if (opt == null) {
                throw new IllegalStateException("Internal error: Game opt _BHW not known");
            }
            opt.setIntValue(bh << 8 | bw);
            if (gameOpts == null) {
                gameOpts = new SOCGameOptionSet();
            }
            gameOpts.put(opt);
        }
        if ((ga = new SOCGame(gaName, gameOpts, knownOpts)) != null) {
            ga.isPractice = isPractice;
            ga.serverVersion = isPractice ? Version.versionNumber() : this.client.sVersion;
            PlayerClientListener clientListener = this.client.getMainDisplay().gameJoined(ga, mes.getLayoutVS(), this.client.getGameReqLocalPrefs().get(gaName));
            this.client.getClientListeners().put(gaName, clientListener);
            this.client.games.put(gaName, ga);
        }
    }

    protected void handleJOINGAME(SOCJoinGame mes) {
        String gn = mes.getGame();
        String name = mes.getNickname();
        if (name == null) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(gn);
        pcl.playerJoined(name);
    }

    protected void handleLEAVEGAME(SOCLeaveGame mes) {
        String gn = mes.getGame();
        SOCGame ga = this.client.games.get(gn);
        if (ga == null) {
            return;
        }
        String name = mes.getNickname();
        SOCPlayer player = ga.getPlayer(name);
        PlayerClientListener pcl = this.client.getClientListener(gn);
        pcl.playerLeft(name, player);
        if (player != null) {
            ga.removePlayer(name, false);
        }
    }

    protected void handleNEWGAME(SOCNewGame mes, boolean isPractice) {
        this.client.addToGameList(mes.getGame(), null, !isPractice);
    }

    protected void handleDELETEGAME(SOCDeleteGame mes, final boolean isPractice) {
        final String gaName = mes.getGame();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlayerClientListener pcl;
                MainDisplay mdisp = MessageHandler.this.client.getMainDisplay();
                if (!mdisp.deleteFromGameList(gaName, isPractice, false)) {
                    mdisp.deleteFromGameList(gaName, isPractice, true);
                }
                if ((pcl = MessageHandler.this.client.getClientListener(gaName)) != null) {
                    pcl.gameDisconnected(true, null);
                }
            }
        });
    }

    protected void handleGAMEMEMBERS(SOCGameMembers mes) {
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        pcl.membersListed(mes.getMembers());
    }

    protected void handleGAMESTATS(SOCGameStats mes) {
        String gaName = mes.getGame();
        int stype = mes.getStatType();
        SOCGame ga = this.client.games.get(gaName);
        if (ga != null) {
            SOCDisplaylessPlayerClient.handleGAMESTATS(mes, ga);
        }
        switch (stype) {
            case 1: {
                if (ga == null) break;
                this.client.updateGameEndStats(gaName, mes.getScores());
                break;
            }
            case 2: {
                long[] stats = mes.getScores();
                long timeCreated = stats[0];
                long timeFinished = stats[2];
                long timeNow = System.currentTimeMillis() / 1000L;
                if (timeCreated > timeNow) {
                    return;
                }
                int durationFinishedSeconds = timeFinished > timeCreated ? (int)(timeFinished - timeCreated) : 0;
                this.client.getMainDisplay().gameTimingStatsReceived(gaName, timeCreated, stats[1] == 1L, durationFinishedSeconds);
                break;
            }
        }
    }

    protected void handleGAMETEXTMSG(SOCGameTextMsg mes) {
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        String fromNickname = mes.getNickname();
        if (fromNickname.equals("Server")) {
            fromNickname = null;
        }
        pcl.messageReceived(fromNickname, mes.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSITDOWN(SOCSitDown mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int pn = mes.getPlayerNumber();
        String plName = mes.getNickname();
        SOCPlayer player = null;
        ga.takeMonitor();
        try {
            ga.addPlayer(plName, pn);
            player = ga.getPlayer(pn);
            player.setRobotFlag(mes.isRobot(), false);
        }
        catch (Exception e) {
            System.out.println("Exception caught - " + e);
            e.printStackTrace();
            return;
        }
        finally {
            ga.releaseMonitor();
        }
        boolean playerIsClient = this.client.getNickname(ga.isPractice).equals(plName);
        if (playerIsClient && (ga.isPractice || this.client.sVersion >= 2300)) {
            player.getInventory().clear();
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        pcl.playerSitdown(pn, plName);
        if (playerIsClient && !ga.isBoardReset()) {
            player.setFaceId(this.client.lastFaceChange);
            this.gms.changeFace(ga, this.client.lastFaceChange);
        }
    }

    protected void handleBOARDLAYOUT(SOCBoardLayout mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handleBOARDLAYOUT(mes, ga);
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        if (pcl != null) {
            pcl.boardLayoutUpdated();
        }
    }

    private void handleSERVERPING(SOCServerPing mes, boolean isPractice) {
        int timeval = mes.getSleepTime();
        if (timeval != -1) {
            this.gms.put(mes.toCmd(), isPractice);
        } else {
            this.client.getNet().ex = new RuntimeException(this.client.strings.get("pcli.error.kicked.samename"));
            this.client.shutdownFromNetwork();
        }
    }

    protected void handleBOARDLAYOUT2(SOCBoardLayout2 mes) {
        PlayerClientListener pcl;
        String gaName = mes.getGame();
        if (SOCDisplaylessPlayerClient.handleBOARDLAYOUT2(mes, this.client.games.get(gaName)) && (pcl = this.client.getClientListener(gaName)) != null) {
            pcl.boardLayoutUpdated();
        }
    }

    protected void handleSTARTGAME(SOCStartGame mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        this.handleGAMESTATE(ga, mes.getGameState(), false, false);
    }

    protected void handleGAMESTATE(SOCGameState mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        this.handleGAMESTATE(ga, mes.getState(), false, false);
    }

    protected void handleGAMESTATE(SOCGame ga, int newState, boolean isForTurn, boolean isForDecline) {
        PlayerClientListener pcl;
        boolean gameStarting;
        if (newState == 0) {
            return;
        }
        int gaState = ga.getGameState();
        boolean bl = gameStarting = gaState == 0 && newState != 0;
        if (newState != gaState || !isForDecline) {
            ga.setGameState(newState);
        }
        if (!gameStarting && !isForTurn && gaState < 15 && newState == 15 && ga.getRoundCount() == 0) {
            ga.updateAtTurn();
        }
        if ((pcl = this.client.getClientListener(ga.getName())) == null) {
            return;
        }
        if (gameStarting) {
            pcl.gameStarted();
        }
        pcl.gameStateChanged(newState, false);
    }

    protected void handleTURN(SOCTurn mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        this.handleGAMESTATE(ga, mes.getGameState(), true, false);
        int pnum = mes.getPlayerNumber();
        ga.setCurrentPlayerNumber(pnum);
        ga.updateAtTurn();
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        pcl.playerTurnSet(pnum);
    }

    protected void handlePLAYERELEMENTS(SOCPlayerElements mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        int pn = mes.getPlayerNumber();
        SOCPlayer pl = pn != -1 ? ga.getPlayer(pn) : null;
        int action = mes.getAction();
        int[] etypes = mes.getElementTypes();
        int[] amounts = mes.getAmounts();
        for (int i = 0; i < etypes.length; ++i) {
            this.handlePLAYERELEMENT(pcl, ga, pl, pn, action, SOCPlayerElement.PEType.valueOf(etypes[i]), amounts[i], false);
        }
        if (action == 100 && etypes.length == 5 && etypes[0] == 1 && pl != null && ga.getGameState() == 15) {
            pl.getResources().setAmount(0, 6);
        }
    }

    protected void handlePLAYERELEMENT(SOCPlayerElement mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int pn = mes.getPlayerNumber();
        int action = mes.getAction();
        int amount = mes.getAmount();
        SOCPlayerElement.PEType etype = SOCPlayerElement.PEType.valueOf(mes.getElementType());
        this.handlePLAYERELEMENT(this.client.getClientListener(mes.getGame()), ga, null, pn, action, etype, amount, mes.isNews());
    }

    private void handlePLAYERELEMENT(PlayerClientListener pcl, SOCGame ga, SOCPlayer pl, int pn, int action, SOCPlayerElement.PEType etype, int amount, boolean isNews) {
        if (ga == null || etype == null) {
            return;
        }
        if (pl == null && pn != -1) {
            pl = ga.getPlayer(pn);
        }
        PlayerClientListener.UpdateType utype = null;
        switch (etype) {
            case ROADS: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 0, amount);
                utype = PlayerClientListener.UpdateType.Road;
                break;
            }
            case SETTLEMENTS: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 1, amount);
                utype = PlayerClientListener.UpdateType.Settlement;
                break;
            }
            case CITIES: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 2, amount);
                utype = PlayerClientListener.UpdateType.City;
                break;
            }
            case SHIPS: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 3, amount);
                utype = PlayerClientListener.UpdateType.Ship;
                break;
            }
            case NUMKNIGHTS: {
                SOCPlayer oldLargestArmyPlayer = ga.getPlayerWithLargestArmy();
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numKnights(ga, pl, action, amount);
                utype = PlayerClientListener.UpdateType.Knight;
                pcl.largestArmyRefresh(oldLargestArmyPlayer, ga.getPlayerWithLargestArmy());
                break;
            }
            case CLAY: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 1, amount);
                utype = PlayerClientListener.UpdateType.Clay;
                break;
            }
            case ORE: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 2, amount);
                utype = PlayerClientListener.UpdateType.Ore;
                break;
            }
            case SHEEP: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 3, amount);
                utype = PlayerClientListener.UpdateType.Sheep;
                break;
            }
            case WHEAT: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 4, amount);
                utype = PlayerClientListener.UpdateType.Wheat;
                break;
            }
            case WOOD: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 5, amount);
                utype = PlayerClientListener.UpdateType.Wood;
                break;
            }
            case UNKNOWN_RESOURCE: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(pl, action, 6, amount);
                utype = PlayerClientListener.UpdateType.Unknown;
                break;
            }
            case ASK_SPECIAL_BUILD: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, pl, pn, action, etype, amount, null);
                pcl.requestedSpecialBuild(pl);
                break;
            }
            case RESOURCE_COUNT: {
                boolean isClientPlayer;
                if (amount == pl.getResources().getTotal() || (isClientPlayer = pl.getName().equals(this.client.getNickname(ga.isPractice)))) break;
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, pl, pn, action, etype, amount, null);
                pcl.playerResourcesUpdated(pl);
                break;
            }
            case NUM_UNDOS_REMAINING: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, pl, pn, action, etype, amount, null);
                utype = PlayerClientListener.UpdateType.UndosRemaining;
                break;
            }
            case NUM_PICK_GOLD_HEX_RESOURCES: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, pl, pn, action, etype, amount, null);
                pcl.requestedGoldResourceCountUpdated(pl, amount);
                break;
            }
            case SCENARIO_SVP: {
                pl.setSpecialVP(amount);
                utype = PlayerClientListener.UpdateType.SpecialVictoryPoints;
                break;
            }
            case SCENARIO_CLOTH_COUNT: {
                if (pn != -1) {
                    pl.setCloth(amount);
                } else {
                    ((SOCBoardLarge)ga.getBoard()).setCloth(amount);
                }
                utype = PlayerClientListener.UpdateType.Cloth;
                break;
            }
            case SCENARIO_WARSHIP_COUNT: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, pl, pn, action, etype, amount, null);
                utype = PlayerClientListener.UpdateType.Warship;
                isNews = action == 101;
                break;
            }
            default: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, pl, pn, action, etype, amount, null);
            }
        }
        if (pcl != null && utype != null) {
            if (!isNews) {
                pcl.playerElementUpdated(pl, utype, false, false);
            } else if (action == 101) {
                pcl.playerElementUpdated(pl, utype, true, false);
            } else {
                pcl.playerElementUpdated(pl, utype, false, true);
            }
        }
    }

    protected void handleGAMEELEMENTS(SOCGameElements mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int[] etypes = mes.getElementTypes();
        int[] values = mes.getValues();
        for (int i = 0; i < etypes.length; ++i) {
            this.handleGAMEELEMENT(ga, SOCGameElements.GEType.valueOf(etypes[i]), values[i]);
        }
    }

    protected void handleGAMEELEMENT(SOCGame ga, SOCGameElements.GEType etype, int value) {
        if (ga == null || etype == null) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(ga.getName());
        if (pcl != null) {
            switch (etype) {
                case LARGEST_ARMY_PLAYER: {
                    SOCPlayer oldLargestArmyPlayer = ga.getPlayerWithLargestArmy();
                    SOCDisplaylessPlayerClient.handleGAMEELEMENT(ga, etype, value);
                    SOCPlayer newLargestArmyPlayer = ga.getPlayerWithLargestArmy();
                    pcl.largestArmyRefresh(oldLargestArmyPlayer, newLargestArmyPlayer);
                    return;
                }
                case LONGEST_ROAD_PLAYER: {
                    SOCPlayer oldLongestRoadPlayer = ga.getPlayerWithLongestRoad();
                    SOCDisplaylessPlayerClient.handleGAMEELEMENT(ga, etype, value);
                    SOCPlayer newLongestRoadPlayer = ga.getPlayerWithLongestRoad();
                    pcl.longestRoadRefresh(oldLongestRoadPlayer, newLongestRoadPlayer);
                    return;
                }
            }
        }
        SOCDisplaylessPlayerClient.handleGAMEELEMENT(ga, etype, value);
        if (pcl == null) {
            return;
        }
        switch (etype) {
            case DEV_CARD_COUNT: {
                pcl.devCardDeckUpdated();
                break;
            }
            case CURRENT_PLAYER: {
                pcl.playerTurnSet(value);
            }
        }
    }

    protected void handleRESOURCECOUNT(SOCResourceCount mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        this.handlePLAYERELEMENT(this.client.getClientListener(mes.getGame()), ga, null, mes.getPlayerNumber(), 100, SOCPlayerElement.PEType.RESOURCE_COUNT, mes.getCount(), false);
    }

    protected void handleDICERESULT(SOCDiceResult mes) {
        String gameName = mes.getGame();
        SOCGame ga = this.client.games.get(gameName);
        if (ga == null) {
            return;
        }
        int cpn = ga.getCurrentPlayerNumber();
        SOCPlayer p = null;
        if (cpn >= 0) {
            p = ga.getPlayer(cpn);
        }
        int roll = mes.getResult();
        SOCPlayer player = p;
        ga.setCurrentDice(roll);
        PlayerClientListener listener = this.client.getClientListener(gameName);
        listener.diceRolled(player, roll);
    }

    protected void handlePUTPIECE(SOCPutPiece mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
        int coord = mes.getCoordinates();
        int ptype = mes.getPieceType();
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        pcl.playerPiecePlaced(player, coord, ptype);
    }

    protected void handleCANCELBUILDREQUEST(SOCCancelBuildRequest mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int ptype = mes.getPieceType();
        SOCPlayer pl = ga.getPlayer(ga.getCurrentPlayerNumber());
        if (ptype >= 1) {
            int sta = ga.getGameState();
            if (sta != 6 && sta != 11 && sta != 13) {
                return;
            }
            if (ptype == 1) {
                SOCSettlement pp = new SOCSettlement(pl, pl.getLastSettlementCoord(), null);
                ga.undoPutInitSettlement(pp);
            }
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        pcl.buildRequestCanceled(pl);
    }

    protected void handleDISCARD(SOCDiscard mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        SOCPlayer pl = SOCDisplaylessPlayerClient.handleDISCARD(mes, ga);
        if (pl == null) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        if (pcl == null) {
            return;
        }
        pcl.playerDiscarded(pl, mes.getResources());
    }

    protected void handleMOVEROBBER(SOCMoveRobber mes) {
        boolean isPirate;
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        ga.setPlacingRobberForKnightCard(false);
        ga.setLastAction(null);
        int newHex = mes.getCoordinates();
        boolean bl = isPirate = newHex <= 0;
        if (!isPirate) {
            ga.getBoard().setRobberHex(newHex, true);
        } else {
            newHex = -newHex;
            ((SOCBoardLarge)ga.getBoard()).setPirateHex(newHex, true);
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        pcl.robberMoved(newHex, isPirate);
    }

    protected void handleDISCARDREQUEST(SOCDiscardRequest mes) {
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        pcl.requestedDiscard(mes.getNumberOfDiscards());
    }

    protected void handleCHOOSEPLAYERREQUEST(SOCChoosePlayerRequest mes) {
        SOCGame game = this.client.games.get(mes.getGame());
        int maxPl = game.maxPlayers;
        boolean[] ch = mes.getChoices();
        ArrayList<SOCPlayer> choices = new ArrayList<SOCPlayer>();
        for (int i = 0; i < maxPl; ++i) {
            if (!ch[i]) continue;
            SOCPlayer p = game.getPlayer(i);
            choices.add(p);
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        pcl.requestedChoosePlayer(choices, mes.canChooseNone());
    }

    protected void handleCHOOSEPLAYER(SOCChoosePlayer mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        int victimPlayerNumber = mes.getChoice();
        SOCPlayer player = ga.getPlayer(victimPlayerNumber);
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        pcl.requestedChooseRobResourceType(player);
    }

    protected void handleROBBERYRESULT(SOCRobberyResult mes, SOCGame ga) {
        SOCDisplaylessPlayerClient.handleROBBERYRESULT(mes, ga);
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl != null) {
            pcl.reportRobberyResult(mes.perpPN, mes.victimPN, mes.resType, mes.resSet, mes.peType, mes.isGainLose, mes.amount, mes.victimAmount, mes.extraValue);
        }
    }

    protected void handleBANKTRADE(SOCBankTrade mes, boolean isPractice) {
        PlayerClientListener pcl;
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        if (isPractice || this.client.sVersion >= 2500) {
            SOCDisplaylessPlayerClient.handleBANKTRADE(mes, ga);
        }
        if ((pcl = this.client.getClientListener(gaName)) == null) {
            return;
        }
        pcl.playerBankTrade(ga.getPlayer(mes.getPlayerNumber()), mes.getGiveSet(), mes.getGetSet());
    }

    protected void handleMAKEOFFER(SOCMakeOffer mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        SOCTradeOffer offer = mes.getOffer();
        int fromPN = offer.getFrom();
        SOCPlayer from = ga.getPlayer(fromPN);
        from.setCurrentOffer(offer);
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        pcl.requestedTrade(from, fromPN);
    }

    protected void handleCLEAROFFER(SOCClearOffer mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int pn = mes.getPlayerNumber();
        SOCPlayer player = null;
        if (pn != -1) {
            player = ga.getPlayer(pn);
            player.setCurrentOffer(null);
        } else {
            for (int i = 0; i < ga.maxPlayers; ++i) {
                ga.getPlayer(i).setCurrentOffer(null);
            }
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        pcl.requestedTradeClear(player, false);
    }

    protected void handleREJECTOFFER(SOCRejectOffer mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        int pn = mes.getPlayerNumber();
        SOCPlayer player = pn >= 0 ? ga.getPlayer(pn) : null;
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        int rc = mes.getReasonCode();
        switch (rc) {
            case 0: {
                pcl.requestedTradeRejection(player);
                break;
            }
            case 2: {
                pcl.playerTradeDisallowed(-1, false, true);
                break;
            }
            case 3: {
                pcl.playerTradeDisallowed(pn, true, false);
                break;
            }
            default: {
                pcl.playerTradeDisallowed(pn, false, false);
            }
        }
    }

    protected void handleACCEPTOFFER(SOCAcceptOffer mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handleACCEPTOFFER(mes, ga);
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        if (pcl == null) {
            return;
        }
        pcl.playerTradeAccepted(ga.getPlayer(mes.getOfferingNumber()), ga.getPlayer(mes.getAcceptingNumber()), mes.getResToOfferingPlayer(), mes.getResToAcceptingPlayer());
    }

    protected void handleCLEARTRADEMSG(SOCClearTradeMsg mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        int pn = mes.getPlayerNumber();
        SOCPlayer player = null;
        if (pn != -1) {
            player = ga.getPlayer(pn);
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        pcl.requestedTradeReset(player);
    }

    protected void handleDEVCARDACTION(boolean isPractice, SOCDevCardAction mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        int pn = mes.getPlayerNumber();
        SOCPlayer player = ga.getPlayer(pn);
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        boolean isClientPlayer = pcl != null && pn >= 0 && pn == pcl.getClientPlayerNumber();
        int act = mes.getAction();
        if (isClientPlayer && act == 3 && ga.getGameState() == 1000) {
            return;
        }
        List<Integer> ctypes = mes.getCardTypes();
        if (ctypes != null) {
            for (int ctype : ctypes) {
                this.handleDEVCARDACTION(ga, player, isClientPlayer, act, ctype);
            }
        } else {
            int ctype = mes.getCardType();
            if (!isPractice && this.client.sVersion < 2000) {
                if (ctype == 0) {
                    ctype = 9;
                } else if (ctype == 9) {
                    ctype = 0;
                }
            }
            this.handleDEVCARDACTION(ga, player, isClientPlayer, act, ctype);
        }
        if (pcl != null) {
            pcl.playerDevCardsUpdated(player, act == 3);
        }
    }

    protected void handleDEVCARDACTION(SOCGame ga, SOCPlayer player, boolean isClientPlayer, int act, int ctype) {
        switch (act) {
            case 0: {
                player.getInventory().addDevCard(1, 1, ctype);
                break;
            }
            case 1: {
                player.getInventory().removeDevCard(0, ctype);
                player.updateDevCardsPlayed(ctype, false);
                if (ctype != 9 || ga.isGameOptionSet("_SC_PIRI")) break;
                ga.setPlacingRobberForKnightCard(true);
                break;
            }
            case 3: {
                player.getInventory().addDevCard(1, 0, ctype);
                break;
            }
            case 2: {
                player.getInventory().addDevCard(1, 1, ctype);
                break;
            }
            case 6: {
                player.getInventory().removeDevCard(0, ctype);
                break;
            }
            case 5: {
                player.getInventory().removeDevCard(1, ctype);
            }
        }
    }

    protected void handleSETPLAYEDDEVCARD(SOCSetPlayedDevCard mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(ga, null, mes.getPlayerNumber(), 100, SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, mes.hasPlayedDevCard() ? 1 : 0, null);
    }

    public void handlePICKRESOURCES(SOCPickResources mes, SOCGame ga) {
        if (!SOCDisplaylessPlayerClient.handlePICKRESOURCES(mes, ga)) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(ga.getName());
        if (pcl != null) {
            pcl.playerPickedResources(ga.getPlayer(mes.getPlayerNumber()), mes.getResources(), mes.getReasonCode());
        }
    }

    protected void handlePOTENTIALSETTLEMENTS(SOCPotentialSettlements mes) throws IllegalStateException {
        String gaName = mes.getGame();
        SOCDisplaylessPlayerClient.handlePOTENTIALSETTLEMENTS(mes, this.client.games.get(gaName));
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        if (pcl != null) {
            pcl.boardPotentialsUpdated();
        }
    }

    protected void handleCHANGEFACE(SOCChangeFace mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        player.setFaceId(mes.getFaceId());
        pcl.playerFaceChanged(player, mes.getFaceId());
    }

    protected void handleREJECTCONNECTION(SOCRejectConnection mes) {
        this.client.getNet().disconnect();
        String txt = mes.getText();
        if (this.client.sVersion > 0) {
            StringBuilder sb = new StringBuilder(this.client.strings.get("pcli.error.server.disconnected_by_version", Version.version(this.client.sVersion)));
            sb.append('\n').append(txt);
            txt = sb.toString();
        }
        this.client.getMainDisplay().showErrorPanel(txt, this.client.getNet().ex_P == null);
    }

    protected void handleSETSEATLOCK(SOCSetSeatLock mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        SOCGame.SeatLockState[] sls = mes.getLockStates();
        if (sls == null) {
            ga.setSeatLock(mes.getPlayerNumber(), mes.getLockState());
        } else {
            ga.setSeatLocks(sls);
        }
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        pcl.seatLockUpdated();
    }

    protected void handleROLLDICEPROMPT(SOCRollDicePrompt mes) {
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        pcl.requestedDiceRoll(mes.getPlayerNumber());
    }

    protected void handleRESETBOARDAUTH(SOCResetBoardAuth mes) {
        String gname = mes.getGame();
        SOCGame ga = this.client.games.get(gname);
        if (ga == null) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        SOCGame greset = ga.resetAsCopy();
        greset.isPractice = ga.isPractice;
        this.client.games.put(gname, greset);
        pcl.boardReset(greset, mes.getRejoinPlayerNumber(), mes.getRequestingPlayerNumber());
        ga.destroyGame();
    }

    protected void handleRESETBOARDVOTEREQUEST(SOCResetBoardVoteRequest mes) {
        String gname = mes.getGame();
        SOCGame ga = this.client.games.get(gname);
        if (ga == null) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(mes.getRequestingPlayer());
        pcl.boardResetVoteRequested(player);
    }

    protected void handleRESETBOARDVOTE(SOCResetBoardVote mes) {
        String gname = mes.getGame();
        SOCGame ga = this.client.games.get(gname);
        if (ga == null) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
        pcl.boardResetVoteCast(player, mes.getPlayerVote());
    }

    protected void handleRESETBOARDREJECT(SOCResetBoardReject mes) {
        String gname = mes.getGame();
        SOCGame ga = this.client.games.get(gname);
        if (ga == null) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        pcl.boardResetVoteRejected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGAMEOPTIONGETDEFAULTS(SOCGameOptionGetDefaults mes, boolean isPractice) {
        List<String> unknowns;
        ServerGametypeInfo servOpts = isPractice ? this.client.practiceServGameOpts : this.client.tcpServGameOpts;
        ServerGametypeInfo serverGametypeInfo = servOpts;
        synchronized (serverGametypeInfo) {
            unknowns = servOpts.receiveDefaults(SOCGameOption.parseOptionsToMap(mes.getOpts(), servOpts.knownOpts), isPractice ? Version.versionNumber() : this.client.sVersion);
        }
        if (unknowns != null) {
            if (!isPractice) {
                this.client.getMainDisplay().optionsRequested();
            }
            this.gms.put(new SOCGameOptionGetInfos(unknowns, this.client.wantsI18nStrings(isPractice), false).toCmd(), isPractice);
        } else {
            servOpts.newGameWaitingForOpts = false;
            this.client.getMainDisplay().optionsReceived(servOpts, isPractice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleGAMEOPTIONINFO(SOCGameOptionInfo mes, boolean isPractice) {
        boolean hasAllNow;
        ServerGametypeInfo opts = isPractice ? this.client.practiceServGameOpts : this.client.tcpServGameOpts;
        ServerGametypeInfo serverGametypeInfo = opts;
        synchronized (serverGametypeInfo) {
            hasAllNow = opts.receiveInfo(mes);
        }
        boolean isDash = mes.getOptionNameKey().equals("-");
        this.client.getMainDisplay().optionsReceived(opts, isPractice, isDash, hasAllNow);
    }

    private void handleNEWGAMEWITHOPTIONS(SOCNewGameWithOptions mes, boolean isPractice) {
        boolean canJoin;
        String gname = mes.getGame();
        String opts = mes.getOptionsString();
        boolean bl = canJoin = mes.getMinVersion() <= Version.versionNumber();
        if (gname.charAt(0) == '?') {
            gname = gname.substring(1);
            canJoin = false;
        }
        this.client.getMainDisplay().addToGameList(!canJoin, gname, opts, !isPractice);
    }

    private void handleGAMESWITHOPTIONS(SOCGamesWithOptions mes, boolean isPractice) {
        final SOCGameList msgGames = mes.getGameList((isPractice ? this.client.practiceServGameOpts : this.client.tcpServGameOpts).knownOpts);
        if (msgGames == null) {
            return;
        }
        if (!isPractice) {
            if (this.client.serverGames == null) {
                this.client.serverGames = msgGames;
            } else {
                this.client.serverGames.addGames(msgGames, Version.versionNumber());
            }
            this.client.tcpServGameOpts.noMoreOptions(false);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainDisplay mdisp = MessageHandler.this.client.getMainDisplay();
                for (String gaName : msgGames.getGameNames()) {
                    mdisp.addToGameList(msgGames.isUnjoinableGame(gaName), gaName, msgGames.getGameOptionsString(gaName), false);
                }
                mdisp.repaintGameAndChannelLists();
            }
        });
    }

    private void handleLOCALIZEDSTRINGS(SOCLocalizedStrings mes, boolean isPractice) {
        SOCGameOptionSet knownOpts = (isPractice ? this.client.practiceServGameOpts : this.client.tcpServGameOpts).knownOpts;
        List<String> strs = mes.getParams();
        String type = strs.get(0);
        if (type.equals("O")) {
            int L = strs.size();
            for (int i = 1; i < L; i += 2) {
                String desc;
                SOCGameOption opt = knownOpts.getKnownOption(strs.get(i), false);
                if (opt == null || (desc = strs.get(i + 1)) == null || desc.length() <= 0) continue;
                opt.setDesc(desc);
            }
        } else if (type.equals("S")) {
            this.client.localizeGameScenarios(strs, true, mes.isFlagSet(4), isPractice);
        } else {
            System.err.println("L4916: Unknown localized string type " + type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSCENARIOINFO(SOCScenarioInfo mes, boolean isPractice) {
        ServerGametypeInfo opts = isPractice ? this.client.practiceServGameOpts : this.client.tcpServGameOpts;
        if (mes.noMoreScens) {
            ServerGametypeInfo serverGametypeInfo = opts;
            synchronized (serverGametypeInfo) {
                opts.allScenStringsReceived = true;
                opts.allScenInfoReceived = true;
            }
        }
        String scKey = mes.getScenarioKey();
        if (mes.isKeyUnknown) {
            SOCScenario.removeUnknownScenario(scKey);
        } else {
            SOCScenario.addKnownScenario(mes.getScenario());
        }
        ServerGametypeInfo serverGametypeInfo = opts;
        synchronized (serverGametypeInfo) {
            opts.scenKeys.add(scKey);
        }
    }

    private void handlePLAYERSTATS(SOCPlayerStats mes) {
        String gaName = mes.getGame();
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        if (pcl == null) {
            return;
        }
        int clientPN = pcl.getClientPlayerNumber();
        if (clientPN == -1) {
            return;
        }
        SOCDisplaylessPlayerClient.handlePLAYERSTATS(mes, pcl.getGame(), clientPN);
        int stype = mes.getStatType();
        switch (stype) {
            case 1: 
            case 2: {
                pcl.playerStats(stype, mes.getParams(), true, true);
                break;
            }
            default: {
                System.err.println("handlePLAYERSTATS: unrecognized player stat type " + stype);
            }
        }
    }

    private final void handleDEBUGFREEPLACE(SOCDebugFreePlace mes) {
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        pcl.debugFreePlaceModeToggled(mes.getCoordinates() == 1);
    }

    private final void handleSIMPLEREQUEST(SOCSimpleRequest mes) {
        String gaName = mes.getGame();
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        if (pcl == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handleSIMPLEREQUEST(mes, this.client.games.get(gaName));
        pcl.simpleRequest(mes.getPlayerNumber(), mes.getRequestType(), mes.getValue1(), mes.getValue2());
    }

    private final void handleSIMPLEACTION(SOCSimpleAction mes) {
        String gaName = mes.getGame();
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        if (pcl == null) {
            return;
        }
        int atype = mes.getActionType();
        switch (atype) {
            case 1001: {
                pcl.scen_SC_PIRI_pirateFortressAttackResult(false, mes.getValue1(), mes.getValue2());
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 1002: {
                SOCDisplaylessPlayerClient.handleSIMPLEACTION(mes, this.client.games.get(gaName));
                pcl.simpleAction(mes.getPlayerNumber(), atype, mes.getValue1(), mes.getValue2());
                break;
            }
            case 1003: {
                SOCDisplaylessPlayerClient.handleSIMPLEACTION(mes, this.client.games.get(gaName));
                break;
            }
            default: {
                int mesPN = mes.getPlayerNumber();
                if (mesPN < 0 || mesPN != pcl.getClientPlayerNumber()) break;
                System.err.println("handleSIMPLEACTION: Unknown type ignored: " + atype + " in game " + gaName);
            }
        }
    }

    protected void handleGAMESERVERTEXT(SOCGameServerText mes) {
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        pcl.messageReceived(null, mes.getText());
    }

    protected void handleDICERESULTRESOURCES(SOCDiceResultResources mes) {
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handleDICERESULTRESOURCES(mes, ga, null, true);
        pcl.diceRolledResources(mes.playerNum, mes.playerRsrc);
        int n = mes.playerNum.size();
        for (int i = 0; i < n; ++i) {
            this.handlePLAYERELEMENT(this.client.getClientListener(mes.getGame()), ga, null, mes.playerNum.get(i), 100, SOCPlayerElement.PEType.RESOURCE_COUNT, mes.playerResTotal.get(i), false);
        }
    }

    private final void handleMOVEPIECE(SOCMovePiece mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
        pcl.playerPieceMoved(player, mes.getFromCoord(), mes.getToCoord(), mes.getPieceType());
    }

    private final void handleREMOVEPIECE(SOCRemovePiece mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        SOCPlayer player = ga.getPlayer(mes.getParam1());
        pcl.playerPieceRemoved(player, mes.getParam3(), mes.getParam2());
    }

    private void handleUNDOPUTPIECE(SOCUndoPutPiece mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        SOCDisplaylessPlayerClient.handleUNDOPUTPIECE(mes, ga);
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        if (pcl == null) {
            return;
        }
        int pn = mes.getPlayerNumber();
        int pieceType = mes.getPieceType();
        int fromCoord = mes.getMovedFromCoordinates();
        if (pn >= 0) {
            pcl.playerPiecePlacementUndone(ga.getPlayer(pn), mes.getCoordinates(), fromCoord, pieceType);
        } else {
            pcl.playerPiecePlacementUndoDeclined(pieceType, fromCoord != 0);
        }
    }

    protected void handleREVEALFOGHEX(SOCRevealFogHex mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        if (!ga.hasSeaBoard) {
            return;
        }
        ga.revealFogHiddenHex(mes.getParam1(), mes.getParam2(), mes.getParam3());
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        if (pcl == null) {
            return;
        }
        pcl.boardUpdated();
    }

    protected void handlePIECEVALUE(SOCPieceValue mes) {
        PlayerClientListener pcl;
        SOCFortress fort;
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        if (!ga.hasSeaBoard) {
            return;
        }
        int coord = mes.getParam2();
        int pv = mes.getParam3();
        SOCPlayingPiece updatePiece = null;
        if (ga.isGameOptionSet("_SC_CLVI")) {
            SOCVillage vi = ((SOCBoardLarge)ga.getBoard()).getVillageAtNode(coord);
            if (vi != null) {
                vi.setCloth(pv);
                updatePiece = vi;
            }
        } else if (ga.isGameOptionSet("_SC_PIRI") && (fort = ga.getFortress(coord)) != null) {
            fort.setStrength(pv);
            updatePiece = fort;
        }
        if (updatePiece != null && (pcl = this.client.getClientListener(gaName)) != null) {
            pcl.pieceValueUpdated(updatePiece);
        }
    }

    protected void handleSVPTEXTMSG(SOCSVPTextMessage mes) {
        String gaName = mes.getGame();
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        SOCPlayer pl = ga.getPlayer(mes.pn);
        if (pl == null) {
            return;
        }
        pl.addSpecialVPInfo(mes.svp, mes.desc);
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        if (pcl == null) {
            return;
        }
        pcl.playerSVPAwarded(pl, mes.svp, mes.desc);
    }

    private void handleINVENTORYITEMACTION(SOCInventoryItemAction mes) {
        boolean isReject = SOCDisplaylessPlayerClient.handleINVENTORYITEMACTION(this.client.games, mes);
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        if (isReject) {
            pcl.invItemPlayRejected(mes.itemType, mes.reasonCode);
        } else {
            SOCGame ga = this.client.games.get(mes.getGame());
            if (ga != null) {
                SOCPlayer pl = ga.getPlayer(mes.playerNumber);
                pcl.playerDevCardsUpdated(pl, mes.action == 2);
                if (mes.action == 6) {
                    pcl.playerCanCancelInvItemPlay(pl, mes.canCancelPlay);
                }
            }
        }
    }

    private void handleSETSPECIALITEM(Map<String, SOCGame> games, SOCSetSpecialItem mes) {
        SOCDisplaylessPlayerClient.handleSETSPECIALITEM(games, mes);
        PlayerClientListener pcl = this.client.getClientListener(mes.getGame());
        if (pcl == null) {
            return;
        }
        SOCGame ga = this.client.games.get(mes.getGame());
        if (ga == null) {
            return;
        }
        String typeKey = mes.typeKey;
        int gi = mes.gameItemIndex;
        int pi = mes.playerItemIndex;
        int pn = mes.playerNumber;
        SOCPlayer pl = pn != -1 && pi != -1 ? ga.getPlayer(pn) : null;
        switch (mes.op) {
            case 1: 
            case 2: {
                pcl.playerSetSpecialItem(typeKey, ga, pl, gi, pi, mes.op == 1);
                break;
            }
            case 3: 
            case 4: {
                pcl.playerPickSpecialItem(typeKey, ga, pl, gi, pi, mes.op == 3, mes.coord, mes.level, mes.sv);
                break;
            }
            case 5: 
            case 6: {
                pcl.playerSetSpecialItem(typeKey, ga, pl, gi, pi, mes.op == 5);
                pcl.playerPickSpecialItem(typeKey, ga, pl, gi, pi, true, mes.coord, mes.level, mes.sv);
            }
        }
    }

    private void handleDECLINEPLAYERREQUEST(SOCDeclinePlayerRequest mes) {
        String gaName = mes.getGame();
        PlayerClientListener pcl = this.client.getClientListener(gaName);
        if (pcl == null) {
            return;
        }
        SOCGame ga = this.client.games.get(gaName);
        if (ga == null) {
            return;
        }
        pcl.playerRequestDeclined(mes.reasonCode, mes.detailValue1, mes.detailValue2, mes.reasonText);
        int currState = mes.gameState;
        if (currState != 0) {
            this.handleGAMESTATE(ga, currState, false, true);
        }
    }
}

