/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import soc.client.SpeechBalloon;
import soc.client.SwingMainDisplay;

class MessagePanel
extends SpeechBalloon {
    private static final long serialVersionUID = 2000L;
    private static final int PANEL_MARGIN_HORIZ = 8;
    private static final int PANEL_INNER_WIDTH = 169;
    private final JLabel msg;
    private final JLabel msg2;
    private int oneLineHeight;
    private int msgHeight;
    private int msgLines;
    private final int displayScale;

    public MessagePanel(Color bgColor, int displayScale) {
        super(bgColor, displayScale, null);
        this.displayScale = displayScale;
        Color[] colors = SwingMainDisplay.getForegroundBackgroundColors(true, false);
        if (colors != null) {
            this.setForeground(colors[0]);
            this.setBackground(colors[2]);
        }
        Font msgFont = new Font("SansSerif", 0, 18 * displayScale);
        this.msg = new JLabel(" ", 0);
        this.msg.setFont(msgFont);
        this.msg.setForeground(null);
        this.msg2 = new JLabel(" ", 0);
        this.msg2.setVisible(false);
        this.msg2.setFont(msgFont);
        this.msg2.setForeground(null);
        this.msgLines = 1;
        this.add(this.msg);
        this.add(this.msg2);
        Dimension initSize = new Dimension(50, msgFont.getSize() * 2);
        this.setSize(initSize);
        this.setMinimumSize(initSize);
    }

    public void setText(String message) {
        int newMsgLines;
        int newlineIndex;
        String newText;
        if (message != null) {
            newText = message;
            newlineIndex = message.indexOf(10);
            newMsgLines = newlineIndex >= 0 ? 2 : 1;
        } else {
            newText = " ";
            newlineIndex = -1;
            newMsgLines = 1;
        }
        if (newMsgLines == 1) {
            this.msg.setText(newText);
            this.msg2.setText(" ");
        } else {
            this.msg.setText(newText.substring(0, newlineIndex));
            this.msg2.setText(newText.substring(newlineIndex + 1));
        }
        if (this.msgLines != newMsgLines) {
            this.msgLines = newMsgLines;
            this.msgHeight = 0;
            this.msg2.setVisible(newMsgLines != 1);
            this.validate();
        }
    }

    private void calcLabelMinHeight() {
        if (this.oneLineHeight == 0) {
            this.oneLineHeight = this.getFontMetrics(this.msg.getFont()).getHeight();
        }
        if (this.msgHeight == 0) {
            this.msgHeight = this.oneLineHeight + 4 * this.displayScale;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        this.calcLabelMinHeight();
        return new Dimension(190 * this.displayScale, 3 * this.msgHeight + 21 * this.displayScale);
    }

    @Override
    public void doLayout() {
        Dimension dim = this.getSize();
        int inset = 10 * this.displayScale;
        this.calcLabelMinHeight();
        int h = dim.height - 17 * this.displayScale;
        if (this.msgHeight * this.msgLines > h) {
            this.msgHeight = h / this.msgLines;
        }
        int msgY = (h - this.msgHeight) / 2 + 12 * this.displayScale;
        if (this.msgLines != 1) {
            msgY -= this.oneLineHeight / 2;
        }
        if (msgY < 0) {
            msgY = 0;
        }
        int msgW = dim.width - 2 * inset - 5 * this.displayScale / 2;
        this.msg.setBounds(inset, msgY, msgW, this.msgHeight);
        if (this.msgLines != 1) {
            this.msg2.setBounds(inset, msgY += this.oneLineHeight, msgW, this.msgHeight);
        }
    }
}

