/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import soc.client.AskDialog;
import soc.client.MainDisplay;
import soc.client.NotifyDialog;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.SwingMainDisplay;
import soc.client.UserPreferences;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCScenario;
import soc.game.SOCVersionedItem;
import soc.message.SOCMessage;
import soc.util.DataUtils;
import soc.util.SOCGameList;
import soc.util.SOCStringManager;
import soc.util.Version;

class NewGameOptionsFrame
extends JDialog
implements ActionListener,
DocumentListener,
KeyListener,
ItemListener,
MouseListener {
    public static final int INTFIELD_POPUP_MAXRANGE = 21;
    private final SOCPlayerInterface pi;
    private final MainDisplay mainDisplay;
    private final boolean forPractice;
    private final int gameVersion;
    private final HashMap<String, Object> localPrefs;
    private final boolean forNewGame;
    private final String existingGameName;
    private long gameCreationTimeSeconds;
    private boolean gameIsStarted;
    private int gameDurationFinishedSeconds;
    private final boolean readOnly;
    private final SOCGameOptionSet opts;
    private final SOCGameOptionSet knownOpts;
    private Map<Component, SOCGameOption> controlsOpts;
    private Map<String, Component> optsControls;
    private Map<String, JCheckBox> boolOptCheckboxes;
    private Map<String, SOCScenario> allSc;
    private JComboBox<?> scenDropdown;
    private JButton scenInfo;
    private JButton create;
    private JButton cancel;
    private JTextField gameName;
    private JLabel gameInfo;
    private TimerTask gameInfoUpdateTimer;
    private JTextField msgText;
    private static final Color HEADER_LABEL_BG = new Color(220, 255, 220);
    private static final Color HEADER_LABEL_FG = Color.BLACK;
    private static final SOCStringManager strings = SOCStringManager.getClientManager();

    public NewGameOptionsFrame(SOCPlayerInterface pi, MainDisplay md, String gaName, SOCGameOptionSet opts, boolean forPractice, boolean readOnly) throws IllegalArgumentException {
        super((Frame)pi, readOnly ? strings.get("game.options.title", gaName) : (forPractice ? strings.get("game.options.title.newpractice") : strings.get("game.options.title.new")));
        this.pi = pi;
        this.mainDisplay = md;
        SOCPlayerClient cli = md.getClient();
        this.forNewGame = gaName == null;
        this.existingGameName = gaName;
        this.opts = opts;
        this.knownOpts = (forPractice ? cli.practiceServGameOpts : cli.tcpServGameOpts).knownOpts;
        this.localPrefs = new HashMap();
        this.forPractice = forPractice;
        this.readOnly = readOnly;
        int n = this.gameVersion = forPractice ? Version.versionNumber() : cli.sVersion;
        if (opts != null && opts == this.knownOpts) {
            throw new IllegalArgumentException("opts == knownOpts");
        }
        this.controlsOpts = new HashMap<Component, SOCGameOption>();
        if (!readOnly) {
            this.optsControls = new HashMap<String, Component>();
            this.boolOptCheckboxes = new HashMap<String, JCheckBox>();
        }
        if (gaName == null && forPractice) {
            gaName = cli.numPracticeGames == 0 ? cli.DEFAULT_PRACTICE_GAMENAME : cli.DEFAULT_PRACTICE_GAMENAME + " " + (1 + cli.numPracticeGames);
        }
        if (!SwingMainDisplay.isOSColorHighContrast()) {
            this.setBackground(SwingMainDisplay.JSETTLERS_BG_GREEN);
            this.setForeground(Color.black);
            this.getRootPane().setBackground(null);
            this.getContentPane().setBackground(null);
        }
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(2);
        this.addKeyListener(this);
        this.initInterfaceElements(gaName);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NewGameOptionsFrame.this.clickCancel(false);
            }
        });
        md.clearWaitingStatus(true);
    }

    public static NewGameOptionsFrame createAndShow(SOCPlayerInterface pi, MainDisplay md, String gaName, SOCGameOptionSet opts, boolean forPractice, boolean readOnly) throws IllegalArgumentException {
        NewGameOptionsFrame ngof = new NewGameOptionsFrame(pi, md, gaName, opts, forPractice, readOnly);
        ngof.pack();
        ngof.setVisible(true);
        return ngof;
    }

    private void initInterfaceElements(String gaName) {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        int displayScale = this.mainDisplay.getDisplayScaleFactor();
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        boolean shouldClearButtonBGs = !isOSHighContrast && SOCPlayerClient.IS_PLATFORM_WINDOWS;
        JPanel bp = new JPanel(gbl);
        int n = 4 * displayScale;
        bp.setBorder(new EmptyBorder(n, n, n, n));
        if (!isOSHighContrast) {
            bp.setForeground(this.getForeground());
            bp.setBackground(SwingMainDisplay.JSETTLERS_BG_GREEN);
        }
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        if (!this.readOnly && this.opts != null) {
            this.msgText = new JTextField(strings.get("game.options.prompt"));
            this.msgText.setEditable(false);
            if (!isOSHighContrast) {
                this.msgText.setForeground(SwingMainDisplay.MISC_LABEL_FG_OFF_WHITE);
                this.msgText.setBackground(this.getBackground());
            }
            this.add((Component)this.msgText, "North");
        }
        JLabel L = new JLabel(strings.get("game.options.name"), 2);
        if (!isOSHighContrast) {
            L.setBackground(HEADER_LABEL_BG);
            L.setForeground(HEADER_LABEL_FG);
            L.setOpaque(true);
        }
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.ipadx = 2 * displayScale;
        gbl.setConstraints(L, gbc);
        gbc.ipadx = 0;
        bp.add(L);
        this.gameName = new JTextField(20);
        if (gaName != null) {
            this.gameName.setText(gaName);
        }
        if (this.readOnly) {
            this.gameName.setEditable(false);
        } else {
            this.gameName.addKeyListener(this);
            Document tfDoc = this.gameName.getDocument();
            tfDoc.putProperty("owner", this.gameName);
            tfDoc.addDocumentListener(this);
        }
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbl.setConstraints(this.gameName, gbc);
        bp.add(this.gameName);
        if (!this.forNewGame) {
            boolean hasGameInfoAlready;
            SOCPlayerClient pcli = this.mainDisplay.getClient();
            boolean bl = hasGameInfoAlready = this.pi != null;
            if (hasGameInfoAlready || pcli.sVersion >= 2700) {
                int px2;
                gbc.ipadx = px2 = 2 * displayScale;
                L = new JLabel(strings.get("pcli.main.game.info") + ":", 2);
                gbc.gridwidth = 2;
                gbc.weightx = 0.0;
                gbl.setConstraints(L, gbc);
                bp.add(L);
                Insets prevIns = gbc.insets;
                this.gameInfo = new JLabel();
                if (hasGameInfoAlready) {
                    this.updateGameInfo();
                } else if (!pcli.gotPassword && !this.mainDisplay.readValidNicknameAndPassword()) {
                    this.gameInfo.setText(strings.get("game.options.must_enter_nickname_to_check"));
                }
                gbc.gridwidth = 0;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(px2, px2, px2, px2);
                gbl.setConstraints(this.gameInfo, gbc);
                bp.add(this.gameInfo);
                gbc.ipadx = 0;
                gbc.insets = prevIns;
                JSeparator spacer = new JSeparator();
                if (!SwingMainDisplay.isOSColorHighContrast()) {
                    spacer.setBackground(HEADER_LABEL_BG);
                }
                gbl.setConstraints(spacer, gbc);
                bp.add(spacer);
                if (hasGameInfoAlready) {
                    this.initGameInfoUpdateTimer(true);
                }
            }
        }
        this.initInterface_Options(bp, gbl, gbc);
        JPanel btnPan = new JPanel();
        if (!isOSHighContrast) {
            btnPan.setBackground(null);
            btnPan.setForeground(null);
        }
        btnPan.setBorder(new EmptyBorder(4 * displayScale, 2 * displayScale, 0, 2 * displayScale));
        if (this.readOnly) {
            this.cancel = new JButton(strings.get("base.ok"));
            this.cancel.setEnabled(true);
        } else {
            this.cancel = new JButton(strings.get("base.cancel"));
            this.cancel.addKeyListener(this);
        }
        this.cancel.addActionListener(this);
        if (shouldClearButtonBGs) {
            this.cancel.setBackground(null);
        }
        btnPan.add(this.cancel);
        if (!this.readOnly) {
            this.create = new JButton(strings.get("game.options.oknew"));
            if (shouldClearButtonBGs) {
                this.create.setBackground(null);
            }
            this.create.addActionListener(this);
            this.create.addKeyListener(this);
            this.create.setEnabled(!this.readOnly);
            if (gaName == null || gaName.length() == 0) {
                this.create.setEnabled(false);
            }
            btnPan.add(this.create);
        }
        this.getRootPane().setDefaultButton(this.readOnly ? this.cancel : this.create);
        this.add((Component)btnPan, "South");
        JRootPane rp = this.getRootPane();
        InputMap im = rp.getInputMap(2);
        ActionMap am = rp.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        am.put("cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                NewGameOptionsFrame.this.clickCancel(false);
            }
        });
        bp.validate();
        this.add((Component)bp, "Center");
        if (this.readOnly && gaName != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final PopupMenu menu = new PopupMenu();
                    MenuItem mi = new MenuItem(strings.get("menu.copy"));
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            try {
                                String selData = NewGameOptionsFrame.this.gameName.getSelectedText();
                                if (selData == null || selData.isEmpty()) {
                                    selData = NewGameOptionsFrame.this.gameName.getText();
                                }
                                StringSelection data = new StringSelection(selData);
                                Clipboard cb = NewGameOptionsFrame.this.gameName.getToolkit().getSystemClipboard();
                                if (cb != null) {
                                    cb.setContents(data, data);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    menu.add(mi);
                    NewGameOptionsFrame.this.gameName.add(menu);
                    NewGameOptionsFrame.this.gameName.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            this.mouseClicked(e);
                        }

                        @Override
                        public void mousePressed(MouseEvent e) {
                            this.mouseClicked(e);
                        }

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (!e.isPopupTrigger()) {
                                return;
                            }
                            e.consume();
                            menu.show(NewGameOptionsFrame.this.gameName, e.getX(), e.getY());
                        }
                    });
                }
            });
        }
    }

    private void initGameInfoUpdateTimer(boolean initialDelayMinute) {
        if (this.gameInfoUpdateTimer != null) {
            return;
        }
        this.gameInfoUpdateTimer = new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewGameOptionsFrame.this.updateGameInfo();
                    }
                });
            }
        };
        this.mainDisplay.getEventTimer().scheduleAtFixedRate(this.gameInfoUpdateTimer, initialDelayMinute ? 60100L : 0L, 60100L);
    }

    private void initInterface_Options(JPanel bp, GridBagLayout gbl, GridBagConstraints gbc) {
        SOCGameOption optSC;
        boolean hideUnderscoreOpts;
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        boolean bl = hideUnderscoreOpts = !this.readOnly;
        if (this.opts == null) {
            JLabel L = new JLabel(strings.get(this.knownOpts != null ? "game.options.none" : "game.options.not"));
            if (!isOSHighContrast) {
                L.setForeground(SwingMainDisplay.MISC_LABEL_FG_OFF_WHITE);
            }
            gbc.gridwidth = 0;
            gbl.setConstraints(L, gbc);
            bp.add(L);
            this.initInterface_UserPrefs(bp, gbl, gbc);
            return;
        }
        if (!this.readOnly) {
            for (Object opt : this.opts) {
                ((SOCGameOption)opt).userChanged = false;
            }
        }
        if (this.opts.containsKey("SC")) {
            this.allSc = SOCScenario.getAllKnownScenarios();
        }
        gbc.anchor = 17;
        HashMap<String, String> sameGroupOpts = new HashMap<String, String>();
        for (SOCGameOption opt : this.opts) {
            SOCGameOption op2;
            String kf2;
            String okey = opt.key;
            int kL = okey.length();
            if (kL <= 2 || opt.optType == 0 && !this.readOnly || opt.hasFlag(4) || (kf2 = SOCGameOption.getGroupParentKey(okey)) == null || (op2 = this.opts.get(kf2)) == null || op2.optType == 0 && !this.readOnly) continue;
            sameGroupOpts.put(okey, kf2);
        }
        SOCGameOption[] optArr = new TreeSet<SOCGameOption>(this.opts.values()).toArray(new SOCGameOption[0]);
        TreeMap<String, SOCGameOption> optGroup = new TreeMap<String, SOCGameOption>();
        for (int i = 0; i < optArr.length; ++i) {
            SOCGameOption op = optArr[i];
            if (op.optType == 0 && !this.readOnly) {
                this.opts.remove(op.key);
                continue;
            }
            if (op.hasFlag(4)) {
                if (this.readOnly) continue;
                this.opts.remove(op.key);
                continue;
            }
            if (op.hasFlag(2)) {
                if (this.readOnly) continue;
                this.opts.remove(op.key);
                continue;
            }
            if (op.key.charAt(0) == '_' && (hideUnderscoreOpts || this.allSc != null && this.allSc.containsKey(op.key.substring(1))) || sameGroupOpts.containsKey(op.key)) continue;
            boolean sharesGroup = sameGroupOpts.containsValue(op.key);
            this.initInterface_OptLine(op, bp, gbl, gbc);
            if (!sharesGroup) continue;
            optGroup.clear();
            for (String kf3 : sameGroupOpts.keySet()) {
                SOCGameOption groupHeadOpt;
                String kf2 = (String)sameGroupOpts.get(kf3);
                if (kf2 == null || !kf2.equals(op.key) || (groupHeadOpt = this.opts.get(kf3)) == null) continue;
                optGroup.put(kf3, groupHeadOpt);
            }
            for (SOCGameOption op3 : optGroup.values()) {
                this.initInterface_OptLine(op3, bp, gbl, gbc);
            }
        }
        this.initInterface_UserPrefs(bp, gbl, gbc);
        if (!this.readOnly && (optSC = this.opts.get("SC")) != null && !optSC.getStringValue().isEmpty()) {
            this.fireUserChangedOptListeners(optSC, this.scenDropdown, true, false);
        }
    }

    private void initInterface_OptLine(SOCGameOption op, JPanel bp, GridBagLayout gbl, GridBagConstraints gbc) {
        if (op.key.equals("SC")) {
            if (this.allSc == null || this.allSc.isEmpty()) {
                return;
            }
            int i = 0;
            int sel = 0;
            JComboBox<Object> jcb = new JComboBox<Object>();
            jcb.addItem(strings.get("base.none.parens"));
            Collection<SOCScenario> scens = this.allSc.values();
            if (!this.readOnly) {
                ArrayList<SOCScenario> sl = new ArrayList<SOCScenario>(scens);
                Collections.sort(sl, new Comparator<SOCScenario>(){

                    @Override
                    public int compare(SOCScenario a, SOCScenario b) {
                        int rankB;
                        int rankA = a.getSortRank();
                        if (rankA < (rankB = b.getSortRank())) {
                            return -1;
                        }
                        if (rankA > rankB) {
                            return 1;
                        }
                        return a.getDesc().compareTo(b.getDesc());
                    }
                });
                scens = sl;
            }
            String currScen = op.getStringValue();
            for (SOCScenario sc : scens) {
                ++i;
                jcb.addItem(sc);
                if (!sc.key.equals(currScen)) continue;
                sel = i;
            }
            if (sel != 0) {
                jcb.setSelectedIndex(sel);
                op.setBoolValue(true);
            }
            this.scenDropdown = jcb;
            this.initInterface_Opt1(op, jcb, true, true, false, bp, gbl, gbc);
            jcb.addActionListener(this);
            if (!this.readOnly || this.opts.containsKey("SC")) {
                JLabel blank = new JLabel();
                gbc.gridwidth = 1;
                gbc.weightx = 0.0;
                gbl.setConstraints(blank, gbc);
                bp.add(blank);
                this.scenInfo = new JButton(strings.get("game.options.scenario.info_btn"));
                if (SOCPlayerClient.IS_PLATFORM_WINDOWS && !SwingMainDisplay.isOSColorHighContrast()) {
                    this.scenInfo.setBackground(null);
                }
                this.scenInfo.addActionListener(this);
                this.scenInfo.addKeyListener(this);
                this.scenInfo.setEnabled(sel != 0);
                gbc.gridwidth = 0;
                int oldAnchor = gbc.anchor;
                int oldFill = gbc.fill;
                gbc.fill = 0;
                gbc.anchor = 13;
                gbl.setConstraints(this.scenInfo, gbc);
                bp.add(this.scenInfo);
                gbc.fill = oldFill;
                gbc.anchor = oldAnchor;
            }
            return;
        }
        switch (op.optType) {
            case 0: 
            case 1: {
                JCheckBox cb = new JCheckBox();
                this.initInterface_Opt1(op, cb, true, false, false, bp, gbl, gbc);
                cb.addItemListener(this);
                break;
            }
            case 2: 
            case 3: {
                boolean hasCheckbox = op.optType == 3;
                this.initInterface_Opt1(op, this.initOption_int(op), hasCheckbox, true, true, bp, gbl, gbc);
                break;
            }
            case 4: 
            case 5: {
                boolean hasCheckbox = op.optType == 5;
                this.initInterface_Opt1(op, this.initOption_enum(op), hasCheckbox, true, true, bp, gbl, gbc);
                break;
            }
            case 6: 
            case 7: {
                JTextField txtc;
                int txtwid = op.maxIntValue;
                if (txtwid > 20) {
                    txtwid = 20;
                }
                boolean doHide = op.optType == 7;
                JTextField jTextField = txtc = doHide ? new JPasswordField(txtwid) : new JTextField(op.getStringValue(), txtwid);
                if (!this.readOnly) {
                    txtc.addKeyListener(this);
                    Document tfDoc = txtc.getDocument();
                    tfDoc.putProperty("owner", txtc);
                    tfDoc.addDocumentListener(this);
                }
                this.initInterface_Opt1(op, txtc, false, false, false, bp, gbl, gbc);
            }
        }
    }

    private void initInterface_Opt1(SOCGameOption op, Component oc, boolean hasCB, boolean allowPH, boolean ocHasListener, JPanel bp, GridBagLayout gbl, GridBagConstraints gbc) {
        JLabel L;
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        if (hasCB) {
            JCheckBox cb = oc instanceof JCheckBox ? (JCheckBox)oc : new JCheckBox();
            this.controlsOpts.put(cb, op);
            cb.setSelected(op.optType != 0 ? op.getBoolValue() : true);
            cb.setEnabled(!this.readOnly);
            if (!isOSHighContrast) {
                cb.setBackground(null);
                cb.setForeground(null);
            }
            gbl.setConstraints(cb, gbc);
            bp.add(cb);
            if (!this.readOnly) {
                this.boolOptCheckboxes.put(op.key, cb);
                cb.addItemListener(this);
            }
        } else {
            L = new JLabel();
            gbl.setConstraints(L, gbc);
            bp.add(L);
        }
        String opDesc = op.getDesc();
        int placeholderIdx = allowPH ? opDesc.indexOf(35) : -1;
        JPanel optp = new JPanel();
        if (!isOSHighContrast) {
            optp.setBackground(null);
            optp.setForeground(null);
        }
        try {
            FlowLayout fl = (FlowLayout)optp.getLayout();
            fl.setAlignment(0);
            fl.setVgap(0);
            fl.setHgap(0);
        }
        catch (Throwable fl) {
            // empty catch block
        }
        if (placeholderIdx > 0) {
            L = new JLabel(opDesc.substring(0, placeholderIdx));
            if (!isOSHighContrast) {
                L.setForeground(SwingMainDisplay.MISC_LABEL_FG_OFF_WHITE);
            }
            optp.add(L);
            if (hasCB && !this.readOnly) {
                this.controlsOpts.put(L, op);
                L.addMouseListener(this);
            }
        }
        if (!(oc instanceof JCheckBox)) {
            this.controlsOpts.put(oc, op);
            oc.setEnabled(!this.readOnly);
            optp.add(oc);
            if (hasCB && !this.readOnly && !ocHasListener) {
                if (oc instanceof JTextField) {
                    ((JTextField)oc).addKeyListener(this);
                    Document tfDoc = ((JTextField)oc).getDocument();
                    tfDoc.putProperty("owner", oc);
                    tfDoc.addDocumentListener(this);
                } else if (oc instanceof JComboBox) {
                    ((JComboBox)oc).addItemListener(this);
                }
            }
        }
        if (!this.readOnly) {
            this.optsControls.put(op.key, oc);
        }
        if (placeholderIdx + 1 < opDesc.length()) {
            L = new JLabel(opDesc.substring(placeholderIdx + 1));
            if (!isOSHighContrast) {
                L.setForeground(SwingMainDisplay.MISC_LABEL_FG_OFF_WHITE);
            }
            optp.add(L);
            if (hasCB && !this.readOnly) {
                this.controlsOpts.put(L, op);
                L.addMouseListener(this);
            }
        }
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbl.setConstraints(optp, gbc);
        bp.add(optp);
    }

    private Component initOption_int(SOCGameOption op) {
        JComponent c;
        int optrange = op.maxIntValue - op.minIntValue;
        if (optrange > 21 || optrange < 0) {
            int aminv;
            int amaxv = Math.abs(op.maxIntValue);
            int magn = amaxv > (aminv = Math.abs(op.minIntValue)) ? amaxv : aminv;
            int twidth = 1 + (int)Math.ceil(Math.log10(magn));
            if (twidth < 3) {
                twidth = 3;
            }
            c = new IntTextField(op.getIntValue(), twidth);
            c.addKeyListener(this);
            Document tfDoc = ((IntTextField)c).getDocument();
            tfDoc.putProperty("owner", c);
            tfDoc.addDocumentListener(this);
        } else {
            JComboBox<String> combo = new JComboBox<String>();
            for (int i = op.minIntValue; i <= op.maxIntValue; ++i) {
                combo.addItem(Integer.toString(i));
            }
            int defaultIdx = op.getIntValue() - op.minIntValue;
            if (defaultIdx > 0) {
                combo.setSelectedIndex(defaultIdx);
            }
            combo.addItemListener(this);
            c = combo;
        }
        return c;
    }

    private JComboBox<String> initOption_enum(SOCGameOption op) {
        JComboBox<String> ch = new JComboBox<String>();
        String[] chs = op.enumVals;
        for (int i = 0; i < chs.length; ++i) {
            ch.addItem(chs[i]);
        }
        int defaultIdx = op.getIntValue() - 1;
        if (defaultIdx > 0) {
            ch.setSelectedIndex(defaultIdx);
        }
        ch.addItemListener(this);
        return ch;
    }

    private void initInterface_UserPrefs(JPanel bp, GridBagLayout gbl, GridBagConstraints gbc) {
        int ival;
        boolean withPerGamePrefs = this.forNewGame || this.pi != null;
        JSeparator spacer = new JSeparator();
        if (!SwingMainDisplay.isOSColorHighContrast()) {
            spacer.setBackground(HEADER_LABEL_BG);
        }
        gbl.setConstraints(spacer, gbc);
        bp.add(spacer);
        boolean bval = 1 == UserPreferences.getPref("hexGraphicsSet", 0);
        this.localPrefs.put("hexGraphicsSet", bval);
        this.initInterface_Pref1(bp, gbl, gbc, "hexGraphicsSet", strings.get("game.options.hex.classic.all"), true, false, bval, 0, null);
        this.initInterface_Pref1(bp, gbl, gbc, null, strings.get("game.options.sound.all"), true, false, UserPreferences.getPref("soundOn", true), 0, new PrefCheckboxListener(){

            @Override
            public void stateChanged(boolean check) {
                UserPreferences.putPref("soundOn", check);
            }
        });
        if (withPerGamePrefs) {
            bval = this.pi != null ? this.pi.isSoundMuted() : false;
            this.localPrefs.put("soundMute", bval);
            this.initInterface_Pref1(bp, gbl, gbc, null, strings.get("game.options.sound.mute_this"), true, false, bval, 0, new PrefCheckboxListener(){

                @Override
                public void stateChanged(boolean check) {
                    if (NewGameOptionsFrame.this.pi != null) {
                        NewGameOptionsFrame.this.pi.setSoundMuted(check);
                    } else {
                        NewGameOptionsFrame.this.localPrefs.put("soundMute", check);
                    }
                }
            });
            ival = this.pi != null ? this.pi.getBotTradeRejectSec() : UserPreferences.getPref("botTradeRejectSec", -8);
            this.localPrefs.put("botTradeRejectSec", ival);
            boolean bl = bval = ival > 0;
            if (!bval) {
                ival = -ival;
            }
            this.initInterface_Pref1(bp, gbl, gbc, "botTradeRejectSec", strings.get("game.options.bot.auto_reject"), true, true, bval, ival, null);
        }
        bval = 0 < UserPreferences.getPref("faceIcon", 1);
        this.localPrefs.put("faceIcon", bval);
        this.initInterface_Pref1(bp, gbl, gbc, "faceIcon", strings.get("game.options.ui.remember_face_icon"), true, false, bval, 0, null);
        ival = UserPreferences.getPref("uiScaleForce", 0);
        this.localPrefs.put("uiScaleForce", ival);
        boolean bl = bval = ival > 0;
        if (!bval) {
            ival = ival < 0 ? -ival : 1;
        }
        this.initInterface_Pref1(bp, gbl, gbc, "uiScaleForce", strings.get("game.options.ui.scale.force"), true, true, bval, ival, null);
    }

    private void initInterface_Pref1(JPanel bp, GridBagLayout gbl, GridBagConstraints gbc, final String key, String desc, boolean hasBool, final boolean hasInt, boolean initBoolVal, int initIntVal, final PrefCheckboxListener pcl) throws IllegalArgumentException {
        JLabel L;
        JPanel prefp;
        int placeholderIdx;
        MouseAdapter ml;
        JCheckBox cb;
        IntTextField itf;
        if (key == null && pcl == null) {
            throw new IllegalArgumentException("null key & pcl");
        }
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        IntTextField intTextField = itf = hasInt ? new IntTextField(initIntVal, 3) : null;
        if (hasBool) {
            cb = new JCheckBox();
            cb.setSelected(initBoolVal);
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbl.setConstraints(cb, gbc);
            if (!isOSHighContrast) {
                cb.setBackground(null);
                cb.setForeground(null);
            }
            bp.add(cb);
            ml = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    boolean makeChecked = !cb.isSelected();
                    cb.setSelected(makeChecked);
                    if (pcl != null) {
                        pcl.stateChanged(makeChecked);
                    }
                    if (key != null) {
                        if (hasInt) {
                            int iv = 0;
                            try {
                                iv = Integer.parseInt(itf.getText().trim());
                                if (!makeChecked) {
                                    iv = -iv;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            NewGameOptionsFrame.this.localPrefs.put(key, iv);
                        } else {
                            NewGameOptionsFrame.this.localPrefs.put(key, makeChecked ? Boolean.TRUE : Boolean.FALSE);
                        }
                    }
                    e.consume();
                }
            };
        } else {
            cb = null;
            ml = null;
        }
        if (hasInt) {
            placeholderIdx = desc.indexOf(35);
            if (placeholderIdx == -1) {
                throw new IllegalArgumentException("missing '#'");
            }
            prefp = new JPanel();
            if (!isOSHighContrast) {
                prefp.setBackground(null);
                prefp.setForeground(null);
            }
            try {
                FlowLayout fl = (FlowLayout)prefp.getLayout();
                fl.setAlignment(0);
                fl.setVgap(0);
                fl.setHgap(0);
            }
            catch (Exception fl) {}
        } else {
            placeholderIdx = -1;
            prefp = null;
        }
        if (placeholderIdx > 0) {
            L = new JLabel(desc.substring(0, placeholderIdx));
            if (!isOSHighContrast) {
                L.setForeground(SwingMainDisplay.MISC_LABEL_FG_OFF_WHITE);
            }
            prefp.add(L);
            L.addMouseListener(ml);
        }
        if (hasInt) {
            prefp.add(itf);
            itf.addKeyListener(this);
            if (cb != null || key != null) {
                Document tfDoc = itf.getDocument();
                tfDoc.putProperty("owner", itf);
                tfDoc.addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.textChanged();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.textChanged();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.textChanged();
                    }

                    public void textChanged() {
                        boolean notEmpty;
                        String newText = itf.getText().trim();
                        boolean bl = notEmpty = newText.length() > 0;
                        if (cb != null && notEmpty != cb.isSelected()) {
                            cb.setSelected(notEmpty);
                            if (pcl != null) {
                                pcl.stateChanged(notEmpty);
                            }
                        }
                        if (key != null) {
                            int iv = 0;
                            try {
                                iv = Integer.parseInt(newText);
                                if (cb != null && !cb.isSelected()) {
                                    iv = -iv;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            NewGameOptionsFrame.this.localPrefs.put(key, iv);
                        }
                    }
                });
            }
        }
        if (placeholderIdx + 1 < desc.length()) {
            L = new JLabel(desc.substring(placeholderIdx + 1));
            if (!isOSHighContrast) {
                L.setForeground(SwingMainDisplay.MISC_LABEL_FG_OFF_WHITE);
            }
            if (prefp != null) {
                prefp.add(L);
            } else {
                gbc.gridwidth = 0;
                gbc.weightx = 1.0;
                gbl.setConstraints(L, gbc);
                bp.add(L);
            }
            L.addMouseListener(ml);
        }
        if (prefp != null) {
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbl.setConstraints(prefp, gbc);
            bp.add(prefp);
        }
        if (cb != null && pcl != null) {
            cb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    pcl.stateChanged(ie.getStateChange() == 1);
                }
            });
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewGameOptionsFrame.this.toFront();
                    NewGameOptionsFrame.this.gameName.requestFocus();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            Object src = ae.getSource();
            if (src == this.create) {
                this.clickCreate(true);
            } else if (src == this.cancel) {
                this.clickCancel(true);
            } else if (src == this.scenInfo) {
                this.clickScenarioInfo();
            } else if (src == this.scenDropdown) {
                if (this.opts == null) {
                    return;
                }
                SOCGameOption optSC = this.opts.get("SC");
                if (optSC == null) {
                    return;
                }
                Object scObj = this.scenDropdown.getSelectedItem();
                boolean wantsSet = scObj instanceof SOCScenario;
                optSC.setBoolValue(wantsSet);
                if (wantsSet) {
                    optSC.setStringValue(((SOCScenario)scObj).key);
                } else {
                    optSC.setStringValue("");
                }
                if (this.scenInfo != null) {
                    this.scenInfo.setEnabled(wantsSet);
                }
                boolean choiceSetCB = false;
                JCheckBox cb = this.boolOptCheckboxes.get("SC");
                if (cb != null && wantsSet != cb.isSelected()) {
                    cb.setSelected(wantsSet);
                    choiceSetCB = true;
                }
                this.fireUserChangedOptListeners(optSC, this.scenDropdown, wantsSet, choiceSetCB);
            }
        }
        catch (Throwable thr) {
            System.err.println("-- Error caught in AWT event thread: " + thr + " --");
            thr.printStackTrace();
            while (thr.getCause() != null) {
                thr = thr.getCause();
                System.err.println(" --> Cause: " + thr + " --");
                thr.printStackTrace();
            }
            System.err.println("-- Error stack trace end --");
            System.err.println();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clickCreate(boolean checkOptionsMinVers) {
        SOCGameOptionSet optsForAskStartgame;
        String gmName = this.gameName.getText().trim();
        int L = gmName.length();
        if (L == 0) {
            return;
        }
        String errMsg = null;
        if (L > 30) {
            errMsg = strings.get("netmsg.status.common.name_too_long", 30);
        } else if (-1 != gmName.indexOf(124)) {
            errMsg = strings.get("netmsg.status.client.newgame_name_rejected_char", Character.valueOf('|'));
        } else if (-1 != gmName.indexOf(44)) {
            errMsg = strings.get("netmsg.status.client.newgame_name_rejected_char", Character.valueOf(','));
        } else if (gmName.charAt(0) == '?' || !SOCMessage.isSingleLineAndSafe(gmName)) {
            errMsg = strings.get("netmsg.status.common.newgame_name_rejected");
        } else if (SOCGameList.REGEX_ALL_DIGITS_OR_PUNCT.matcher(gmName).matches()) {
            errMsg = strings.get("netmsg.status.common.newgame_name_rejected_digits_or_punct");
        }
        if (errMsg != null) {
            this.msgText.setText(errMsg);
            this.gameName.requestFocusInWindow();
            return;
        }
        SOCPlayerClient cl = this.mainDisplay.getClient();
        if (cl.doesGameExist(gmName, this.forPractice)) {
            NotifyDialog.createAndShow(this.mainDisplay, this, strings.get("netmsg.status.common.newgame_already_exists"), null, true);
            return;
        }
        if (this.mainDisplay.readValidNicknameAndPassword()) {
            if (!this.readOptsValuesFromControls(checkOptionsMinVers)) return;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.persistLocalPrefs();
            if (this.opts != null) {
                optsForAskStartgame = new SOCGameOptionSet(this.opts, true);
                Map<String, String> optProblems = optsForAskStartgame.adjustOptionsToKnown(this.knownOpts, false, null);
                if (optProblems != null) {
                    StringBuilder errSB = new StringBuilder("Option problems: ");
                    DataUtils.mapIntoStringBuilder(optProblems, errSB, null, "; ");
                    this.msgText.setText(errSB.toString());
                    this.gameName.requestFocusInWindow();
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            } else {
                optsForAskStartgame = null;
            }
        } else {
            NotifyDialog.createAndShow(this.mainDisplay, this, strings.get("game.options.nickerror"), null, true);
            return;
        }
        this.mainDisplay.askStartGameWithOptions(gmName, this.forPractice, optsForAskStartgame, this.localPrefs);
        this.dispose();
    }

    private void clickCancel(boolean savePrefsIfCurrent) {
        SOCGameOption optSC;
        if (savePrefsIfCurrent && this.readOnly && this.pi != null) {
            this.persistLocalPrefs();
        }
        if (!this.readOnly && this.opts != null && (optSC = this.opts.get("SC")) != null && !optSC.getBoolValue()) {
            optSC.setStringValue("");
        }
        this.dispose();
    }

    private void clickScenarioInfo() {
        SOCGameOption vp;
        if (this.scenDropdown == null) {
            return;
        }
        Object scObj = this.scenDropdown.getSelectedItem();
        if (scObj == null || !(scObj instanceof SOCScenario)) {
            return;
        }
        SOCScenario scen = (SOCScenario)scObj;
        int vpWinner = 10;
        boolean vpKnown = false;
        if (this.opts != null && (vp = this.opts.get("VP")).getBoolValue()) {
            vpWinner = vp.getIntValue();
            vpKnown = true;
        }
        if (this.forNewGame && !vpKnown && scen.scOpts.contains("VP=")) {
            SOCGameOption scOptVP;
            Map<String, SOCGameOption> scenOpts = SOCGameOption.parseOptionsToMap(scen.scOpts, this.knownOpts);
            SOCGameOption sOCGameOption = scOptVP = scenOpts != null ? scenOpts.get("VP") : null;
            if (scOptVP != null) {
                vpWinner = scOptVP.getIntValue();
            }
        }
        NewGameOptionsFrame.showScenarioInfoDialog(scen, null, this.knownOpts, vpWinner, this.mainDisplay, this);
    }

    @Override
    public void dispose() {
        this.mainDisplay.dialogClosed(this);
        if (this.gameInfoUpdateTimer != null) {
            try {
                this.gameInfoUpdateTimer.cancel();
                this.gameInfoUpdateTimer = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.dispose();
    }

    private void persistLocalPrefs() {
        boolean wantsSet;
        int setIdx;
        int iv;
        String k = "botTradeRejectSec";
        Object v = this.localPrefs.get(k);
        if (v != null && v instanceof Integer) {
            iv = (Integer)v;
            if (this.pi != null) {
                this.pi.setBotTradeRejectSec(iv);
            }
            if (iv != 0) {
                UserPreferences.putPref(k, iv);
            }
        }
        if ((v = this.localPrefs.get(k = "uiScaleForce")) != null && v instanceof Integer) {
            iv = (Integer)v;
            if (iv > 3) {
                iv = 3;
            }
            UserPreferences.putPref(k, iv);
        }
        int n = setIdx = Boolean.TRUE.equals(v = this.localPrefs.get(k = "hexGraphicsSet")) ? 1 : 0;
        if (setIdx != UserPreferences.getPref("hexGraphicsSet", 0)) {
            UserPreferences.putPref("hexGraphicsSet", setIdx);
            this.mainDisplay.getClient().reloadBoardGraphics();
        }
        if ((wantsSet = ((Boolean)this.localPrefs.get(k = "faceIcon")).booleanValue()) != 0 < (setIdx = UserPreferences.getPref("faceIcon", 0))) {
            boolean newAndNoActives;
            SOCPlayerClient cli = this.mainDisplay.getClient();
            boolean bl = newAndNoActives = this.forNewGame && !this.mainDisplay.hasAnyActiveGame(false);
            if (newAndNoActives && wantsSet && cli.lastFaceChange == 1 && setIdx != 0) {
                if (setIdx < 0) {
                    setIdx = -setIdx;
                }
                cli.lastFaceChange = setIdx;
            }
            if (newAndNoActives && !wantsSet) {
                cli.lastFaceChange = 1;
                UserPreferences.putPref("faceIcon", -setIdx);
            } else {
                UserPreferences.putPref("faceIcon", wantsSet ? cli.lastFaceChange : -cli.lastFaceChange);
            }
        }
    }

    private boolean readOptsValuesFromControls(boolean checkOptionsMinVers) {
        String txt;
        SOCGameOption op;
        if (this.readOnly) {
            return false;
        }
        boolean allOK = true;
        for (Component ctrl : this.controlsOpts.keySet()) {
            if (ctrl instanceof JLabel) continue;
            op = this.controlsOpts.get(ctrl);
            if (op.key.equals("SC")) {
                if (op.getBoolValue()) continue;
                op.setStringValue("");
                continue;
            }
            if (ctrl instanceof JCheckBox) {
                op.setBoolValue(((JCheckBox)ctrl).isSelected());
                continue;
            }
            if (ctrl instanceof JTextField) {
                txt = ((JTextField)ctrl).getText().trim();
                if (op.optType != 6 && op.optType != 7) continue;
                try {
                    op.setStringValue(txt);
                }
                catch (IllegalArgumentException ex) {
                    allOK = false;
                    this.msgText.setText(strings.get("game.options.singleline"));
                    ctrl.requestFocusInWindow();
                }
                continue;
            }
            if (!(ctrl instanceof JComboBox)) continue;
            int chIdx = ((JComboBox)ctrl).getSelectedIndex();
            if (chIdx != -1) {
                op.setIntValue(chIdx + op.minIntValue);
                continue;
            }
            allOK = false;
        }
        for (Component ctrl : this.controlsOpts.keySet()) {
            if (!(ctrl instanceof JTextField)) continue;
            op = this.controlsOpts.get(ctrl);
            if (op.optType == 3 ? !op.getBoolValue() : op.optType != 2) continue;
            txt = ((JTextField)ctrl).getText().trim();
            try {
                int iv = txt.length() > 0 ? Integer.parseInt(txt) : 0;
                op.setIntValue(iv);
                if (iv == op.getIntValue()) continue;
                allOK = false;
                this.msgText.setText(strings.get("game.options.outofrange", op.minIntValue, op.maxIntValue));
                ctrl.requestFocusInWindow();
            }
            catch (NumberFormatException ex) {
                allOK = false;
                this.msgText.setText(strings.get("game.options.onlydigits"));
                ctrl.requestFocusInWindow();
            }
        }
        if (allOK && checkOptionsMinVers && !this.forPractice) {
            HashMap<String, Integer> optsMins = new HashMap<String, Integer>();
            int optsVers = SOCVersionedItem.itemsMinimumVersion(this.opts.getAll(), false, optsMins);
            if (optsVers > -1 && optsVers > Version.versionNumberMaximumNoWarn()) {
                allOK = false;
                new VersionConfirmDialog(this, optsVers, optsMins).setVisible(true);
            }
        }
        return allOK;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        try {
            switch (e.getKeyCode()) {
                case 10: {
                    e.consume();
                    if (this.readOnly) {
                        this.clickCancel(true);
                        break;
                    }
                    this.clickCreate(true);
                    break;
                }
                case 3: 
                case 27: {
                    e.consume();
                    this.clickCancel(false);
                }
            }
        }
        catch (Throwable thr) {
            System.err.println("-- Error caught in AWT event thread: " + thr + " --");
            thr.printStackTrace();
            while (thr.getCause() != null) {
                thr = thr.getCause();
                System.err.println(" --> Cause: " + thr + " --");
                thr.printStackTrace();
            }
            System.err.println("-- Error stack trace end --");
            System.err.println();
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    public void textChanged(DocumentEvent e) {
        boolean notEmpty;
        if (this.readOnly) {
            return;
        }
        Object srcObj = e.getDocument().getProperty("owner");
        if (srcObj == null || !(srcObj instanceof JTextField)) {
            return;
        }
        String newText = ((JTextField)srcObj).getText().trim();
        boolean bl = notEmpty = newText.length() > 0;
        if (srcObj == this.gameName) {
            if (notEmpty != this.create.isEnabled()) {
                this.create.setEnabled(notEmpty);
            }
        } else {
            SOCGameOption.ChangeListener cl;
            boolean otypeIsInt;
            SOCGameOption opt = this.controlsOpts.get(srcObj);
            if (opt == null) {
                return;
            }
            String oldText = opt.getStringValue();
            boolean validChange = false;
            int oldIntValue = 0;
            if (opt.optType == 6 || opt.optType == 7) {
                otypeIsInt = false;
                try {
                    opt.setStringValue(newText);
                    validChange = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                otypeIsInt = true;
                try {
                    int iv = Integer.parseInt(newText);
                    oldIntValue = opt.getIntValue();
                    opt.setIntValue(iv);
                    if (iv == opt.getIntValue()) {
                        validChange = true;
                    }
                }
                catch (NumberFormatException iv) {
                    // empty catch block
                }
            }
            if (validChange && !opt.userChanged) {
                opt.userChanged = true;
            }
            boolean cbSet = false;
            JCheckBox cb = this.boolOptCheckboxes.get(opt.key);
            if (cb != null && notEmpty != cb.isSelected()) {
                cb.setSelected(notEmpty);
                opt.setBoolValue(notEmpty);
                cbSet = true;
            }
            if ((cl = opt.getChangeListener()) == null) {
                return;
            }
            if (cbSet) {
                Boolean newValue = notEmpty ? Boolean.TRUE : Boolean.FALSE;
                Boolean oldValue = notEmpty ? Boolean.FALSE : Boolean.TRUE;
                this.fireOptionChangeListener(cl, opt, oldValue, newValue);
            }
            if (validChange) {
                if (otypeIsInt) {
                    this.fireOptionChangeListener(cl, opt, oldIntValue, opt.getIntValue());
                } else {
                    this.fireOptionChangeListener(cl, opt, oldText, newText);
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object ctrl = e.getSource();
        SOCGameOption opt = this.controlsOpts.get(ctrl);
        if (opt == null) {
            return;
        }
        boolean wasCBEvent = false;
        boolean choiceSetCB = false;
        JCheckBox cb = this.boolOptCheckboxes.get(opt.key);
        if (cb != null && cb != ctrl) {
            boolean wantsSet = true;
            if (wantsSet != cb.isSelected()) {
                cb.setSelected(wantsSet);
                choiceSetCB = true;
            }
        } else if (ctrl instanceof JCheckBox) {
            wasCBEvent = true;
            choiceSetCB = e.getStateChange() == 1;
        }
        this.fireUserChangedOptListeners(opt, ctrl, choiceSetCB, wasCBEvent);
    }

    private final void fireUserChangedOptListeners(SOCGameOption opt, Object ctrl, boolean newBoolValue, boolean changeBoolValue) {
        Boolean boolOldValue;
        Boolean boolNewValue;
        boolean fireBooleanListener;
        SOCGameOption.ChangeListener cl;
        if (!opt.userChanged) {
            opt.userChanged = true;
        }
        if ((cl = opt.getChangeListener()) == null) {
            return;
        }
        if (newBoolValue || changeBoolValue) {
            fireBooleanListener = true;
            boolNewValue = newBoolValue ? Boolean.TRUE : Boolean.FALSE;
            boolOldValue = newBoolValue ? Boolean.FALSE : Boolean.TRUE;
            opt.setBoolValue(newBoolValue);
        } else {
            fireBooleanListener = false;
            boolNewValue = null;
            boolOldValue = null;
        }
        if (ctrl instanceof JComboBox) {
            int chIdx = ((JComboBox)ctrl).getSelectedIndex();
            if (chIdx != -1) {
                int nv = chIdx + opt.minIntValue;
                Integer newValue = nv;
                Integer oldValue = opt.getIntValue();
                opt.setIntValue(nv);
                if (fireBooleanListener) {
                    this.fireOptionChangeListener(cl, opt, boolOldValue, boolNewValue);
                }
                this.fireOptionChangeListener(cl, opt, oldValue, newValue);
            }
        } else if (fireBooleanListener) {
            this.fireOptionChangeListener(cl, opt, boolOldValue, boolNewValue);
        }
    }

    private void fireOptionChangeListener(SOCGameOption.ChangeListener cl, SOCGameOption opt, Object oldValue, Object newValue) {
        if (oldValue.equals(newValue)) {
            return;
        }
        try {
            cl.valueChanged(opt, oldValue, newValue, this.opts, this.knownOpts);
        }
        catch (Throwable thr) {
            System.err.println("-- Error caught in ChangeListener: " + thr.toString() + " --");
            thr.printStackTrace();
            while (thr.getCause() != null) {
                thr = thr.getCause();
                System.err.println(" --> Cause: " + thr + " --");
                thr.printStackTrace();
            }
            System.err.println("-- Error stack trace end --");
            System.err.println();
        }
        List<SOCGameOption> refresh = SOCGameOption.getAndClearRefreshList();
        if (refresh == null) {
            return;
        }
        if (this.optsControls == null) {
            return;
        }
        block9: for (int i = refresh.size() - 1; i >= 0; --i) {
            SOCGameOption op = refresh.get(i);
            Component opComp = this.optsControls.get(op.key);
            switch (op.optType) {
                case 1: {
                    JCheckBox cb = (JCheckBox)opComp;
                    cb.removeItemListener(this);
                    cb.setSelected(op.getBoolValue());
                    cb.addItemListener(this);
                    continue block9;
                }
                case 2: 
                case 3: {
                    JCheckBox cb;
                    boolean hasCheckbox;
                    JComboBox combo;
                    JTextField tf;
                    if (opComp instanceof JTextField) {
                        tf = (JTextField)opComp;
                        Document doc = tf.getDocument();
                        doc.removeDocumentListener(this);
                        tf.setText(Integer.toString(op.getIntValue()));
                        doc.addDocumentListener(this);
                    } else {
                        combo = (JComboBox)opComp;
                        combo.removeItemListener(this);
                        combo.setSelectedIndex(op.getIntValue() - op.minIntValue);
                        combo.addItemListener(this);
                    }
                    boolean bl = hasCheckbox = op.optType == 3;
                    if (!hasCheckbox || (cb = this.boolOptCheckboxes.get(op.key)) == null) continue block9;
                    cb.removeItemListener(this);
                    cb.setSelected(op.getBoolValue());
                    cb.addItemListener(this);
                    continue block9;
                }
                case 4: 
                case 5: {
                    JCheckBox cb;
                    boolean hasCheckbox;
                    JComboBox combo = (JComboBox)opComp;
                    combo.removeItemListener(this);
                    combo.setSelectedIndex(op.getIntValue() - op.minIntValue);
                    combo.addItemListener(this);
                    boolean bl = hasCheckbox = op.optType == 5;
                    if (!hasCheckbox || (cb = this.boolOptCheckboxes.get(op.key)) == null) continue block9;
                    cb.removeItemListener(this);
                    cb.setSelected(op.getBoolValue());
                    cb.addItemListener(this);
                    continue block9;
                }
                case 6: 
                case 7: {
                    JTextField tf = (JTextField)opComp;
                    Document doc = tf.getDocument();
                    doc.removeDocumentListener(this);
                    tf.setText(op.getStringValue());
                    doc.addDocumentListener(this);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        SOCGameOption.ChangeListener cl;
        SOCGameOption opt = this.controlsOpts.get(e.getSource());
        if (opt == null) {
            return;
        }
        JCheckBox cb = this.boolOptCheckboxes.get(opt.key);
        if (cb == null) {
            return;
        }
        boolean becameChecked = !cb.isSelected();
        cb.setSelected(becameChecked);
        opt.setBoolValue(becameChecked);
        if (!opt.userChanged) {
            opt.userChanged = true;
        }
        if ((cl = opt.getChangeListener()) == null) {
            return;
        }
        Boolean newValue = becameChecked ? Boolean.TRUE : Boolean.FALSE;
        Boolean oldValue = becameChecked ? Boolean.FALSE : Boolean.TRUE;
        this.fireOptionChangeListener(cl, opt, oldValue, newValue);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public static void showScenarioInfoDialog(SOCGame ga, SOCGameOptionSet knownOpts, MainDisplay md, Window parent) {
        String scKey = ga.getGameOptionStringValue("SC");
        if (scKey == null) {
            return;
        }
        SOCScenario sc = SOCScenario.getScenario(scKey);
        if (sc == null) {
            return;
        }
        NewGameOptionsFrame.showScenarioInfoDialog(sc, ga.getGameOptions(), knownOpts, ga.vp_winner, md, parent);
    }

    public static void showScenarioInfoDialog(SOCScenario sc, SOCGameOptionSet gameOpts, SOCGameOptionSet knownOpts, int vpWinner, MainDisplay md, Window parent) {
        if (sc == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(strings.get("game.options.scenario.label"));
        sb.append(' ');
        sb.append(sc.getDesc());
        sb.append('\n');
        String scLongDesc = sc.getLongDesc();
        if (scLongDesc != null) {
            sb.append('\n');
            sb.append(scLongDesc);
            sb.append('\n');
        }
        String scenOptName = "_" + sc.key;
        String optDescScenPrefix = strings.get("game.options.scenario.optprefix");
        if (gameOpts == null && sc.scOpts != null) {
            gameOpts = SOCGameOption.parseOptionsToSet(sc.scOpts, knownOpts);
        }
        if (gameOpts != null) {
            for (SOCGameOption sgo : gameOpts) {
                if (sgo.key.equals(scenOptName) || !sgo.key.startsWith("_SC_")) continue;
                String optDesc = sgo.getDesc();
                if (optDesc.startsWith(optDescScenPrefix)) {
                    optDesc = optDesc.substring(optDescScenPrefix.length()).trim();
                }
                sb.append("\n\u2022 ");
                sb.append(optDesc);
            }
        }
        if (vpWinner != 10) {
            sb.append("\n\u2022 ");
            sb.append(strings.get("game.options.scenario.vp"));
            sb.append(' ');
            sb.append(vpWinner);
        }
        String scenStr = sb.toString();
        NotifyDialog.createAndShow(md, parent, scenStr, null, true);
    }

    public String getExistingGameName() {
        return this.existingGameName;
    }

    public void gameTimingStatsReceived(long creationTimeSeconds, boolean isStarted, int durationFinishedSeconds) {
        this.gameCreationTimeSeconds = creationTimeSeconds;
        this.gameIsStarted = isStarted;
        this.gameDurationFinishedSeconds = durationFinishedSeconds;
        if (isStarted && durationFinishedSeconds == 0) {
            this.initGameInfoUpdateTimer(false);
        } else {
            this.updateGameInfo();
        }
    }

    public void updateGameInfo() {
        String txt;
        int gaState;
        if (this.gameInfo == null || this.pi == null && this.gameCreationTimeSeconds == 0L) {
            return;
        }
        SOCGame ga = this.gameCreationTimeSeconds == 0L ? this.pi.getGame() : null;
        int n = gaState = ga != null ? ga.getGameState() : 0;
        if (gaState < 5 && !this.gameIsStarted) {
            txt = strings.get("game.options.not_started_yet");
        } else {
            boolean isGameOver;
            boolean serverSendsTiming;
            boolean bl = serverSendsTiming = this.gameVersion >= 2700;
            boolean bl2 = ga != null ? gaState >= 1000 : (isGameOver = this.gameDurationFinishedSeconds != 0);
            if (isGameOver) {
                int durSeconds = ga != null ? ga.getDurationSeconds() : this.gameDurationFinishedSeconds;
                int durMinutes = (durSeconds + 30) / 60;
                txt = serverSendsTiming ? strings.get("game.options.finished_minutes", durMinutes) : strings.get("game.options.finished");
            } else {
                int durSeconds = ga != null ? ga.getDurationSeconds() : (int)(System.currentTimeMillis() / 1000L - this.gameCreationTimeSeconds);
                int durMinutes = (durSeconds + 30) / 60;
                txt = strings.get(serverSendsTiming ? "game.options.in_progress_created_minutes" : "game.options.in_progress_joined_minutes", durMinutes);
            }
        }
        this.gameInfo.setText(txt);
    }

    private StringBuilder buildOptionVersionList(Map<String, Integer> optsMins, int versIgnoreMax) {
        StringBuilder sb = new StringBuilder();
        if (optsMins != null) {
            ArrayList<String> okeys = new ArrayList<String>(optsMins.keySet());
            Collections.sort(okeys);
            for (String okey : okeys) {
                int vers = optsMins.get(okey);
                if (versIgnoreMax > -1 && vers <= versIgnoreMax) continue;
                sb.append(Version.version(vers)).append(": ");
                sb.append(this.knownOpts.get(okey).getDesc());
                sb.append('\n');
            }
        }
        return sb;
    }

    private class VersionConfirmDialog
    extends AskDialog {
        public VersionConfirmDialog(NewGameOptionsFrame ngof, int minVers, Map<String, Integer> optsMins) {
            super(NewGameOptionsFrame.this.mainDisplay, (Window)ngof, strings.get("game.options.verconfirm.title"), strings.get("game.options.verconfirm.prompt", Version.version(minVers), NewGameOptionsFrame.this.buildOptionVersionList(optsMins, Version.versionNumberMaximumNoWarn())), strings.get("game.options.verconfirm.create"), strings.get("game.options.verconfirm.change"), true, false);
        }

        @Override
        public void button1Chosen() {
            NewGameOptionsFrame.this.clickCreate(false);
        }

        @Override
        public void button2Chosen() {
            this.dispose();
        }

        @Override
        public void windowCloseChosen() {
            this.button2Chosen();
        }
    }

    private static interface PrefCheckboxListener {
        public void stateChanged(boolean var1);
    }

    public class IntTextField
    extends JTextField
    implements KeyListener {
        IntTextField(int initVal, int width) {
            super(Integer.toString(initVal), width);
            this.addKeyListener(this);
        }

        public int getIntValue() {
            String txt = this.getText().trim();
            if (txt.length() == 0) {
                return 0;
            }
            try {
                return Integer.parseInt(txt);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            switch (e.getKeyCode()) {
                case 10: {
                    e.consume();
                    if (NewGameOptionsFrame.this.readOnly) {
                        NewGameOptionsFrame.this.clickCancel(true);
                        break;
                    }
                    NewGameOptionsFrame.this.clickCreate(true);
                    break;
                }
                case 3: 
                case 27: {
                    e.consume();
                    NewGameOptionsFrame.this.clickCancel(false);
                    break;
                }
                default: {
                    char c = e.getKeyChar();
                    switch (c) {
                        case '\b': 
                        case '\u007f': 
                        case '\uffff': {
                            return;
                        }
                    }
                    if (Character.isDigit(c)) break;
                    e.consume();
                }
            }
        }
    }
}

