/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.util.List;
import java.util.Map;
import soc.game.ResourceSet;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.message.SOCPlayerElement;

public interface PlayerClientListener {
    public SOCGame getGame();

    public int getClientPlayerNumber();

    public boolean isClientCurrentPlayer();

    public void diceRolled(SOCPlayer var1, int var2);

    public void diceRolledResources(List<Integer> var1, List<SOCResourceSet> var2);

    public void playerJoined(String var1);

    public void playerLeft(String var1, SOCPlayer var2);

    public void playerSitdown(int var1, String var2);

    public void playerTurnSet(int var1);

    public void playerPiecePlaced(SOCPlayer var1, int var2, int var3);

    public void playerPieceMoved(SOCPlayer var1, int var2, int var3, int var4);

    public void playerPieceRemoved(SOCPlayer var1, int var2, int var3);

    public void playerPiecePlacementUndone(SOCPlayer var1, int var2, int var3, int var4);

    public void playerPiecePlacementUndoDeclined(int var1, boolean var2);

    public void playerSVPAwarded(SOCPlayer var1, int var2, String var3);

    public void playerDevCardsUpdated(SOCPlayer var1, boolean var2);

    public void playerCanCancelInvItemPlay(SOCPlayer var1, boolean var2);

    public void playerFaceChanged(SOCPlayer var1, int var2);

    public void playerElementUpdated(SOCPlayer var1, UpdateType var2, boolean var3, boolean var4);

    public void playerResourcesUpdated(SOCPlayer var1);

    public void playerPickedResources(SOCPlayer var1, SOCResourceSet var2, int var3);

    public List<String> playerStats(int var1, int[] var2, boolean var3, boolean var4);

    public void requestedDiscard(int var1);

    public void promptPickResources(int var1);

    public void requestedGoldResourceCountUpdated(SOCPlayer var1, int var2);

    public void playerDiscarded(SOCPlayer var1, ResourceSet var2);

    public void requestedChoosePlayer(List<SOCPlayer> var1, boolean var2);

    public void requestedChooseRobResourceType(SOCPlayer var1);

    public void reportRobberyResult(int var1, int var2, int var3, SOCResourceSet var4, SOCPlayerElement.PEType var5, boolean var6, int var7, int var8, int var9);

    public void playerBankTrade(SOCPlayer var1, SOCResourceSet var2, SOCResourceSet var3);

    public void requestedTrade(SOCPlayer var1, int var2);

    public void requestedTradeClear(SOCPlayer var1, boolean var2);

    public void requestedTradeRejection(SOCPlayer var1);

    public void playerTradeAccepted(SOCPlayer var1, SOCPlayer var2, SOCResourceSet var3, SOCResourceSet var4);

    public void playerTradeDisallowed(int var1, boolean var2, boolean var3);

    public void requestedTradeReset(SOCPlayer var1);

    public void clearTradeOffer(SOCPlayer var1, boolean var2);

    public void requestedSpecialBuild(SOCPlayer var1);

    public void requestedDiceRoll(int var1);

    public void largestArmyRefresh(SOCPlayer var1, SOCPlayer var2);

    public void longestRoadRefresh(SOCPlayer var1, SOCPlayer var2);

    public void membersListed(List<String> var1);

    public void boardLayoutUpdated();

    public void boardUpdated();

    public void pieceValueUpdated(SOCPlayingPiece var1);

    public void boardPotentialsUpdated();

    public void boardReset(SOCGame var1, int var2, int var3);

    public void boardResetVoteRequested(SOCPlayer var1);

    public void boardResetVoteCast(SOCPlayer var1, boolean var2);

    public void boardResetVoteRejected();

    public void robberMoved(int var1, boolean var2);

    public void devCardDeckUpdated();

    public void seatLockUpdated();

    public boolean isNonBlockingDialogVisible();

    public void gameStarted();

    public void gameStateChanged(int var1, boolean var2);

    public void gameEnded(Map<SOCPlayer, Integer> var1);

    public void gameDisconnected(boolean var1, String var2);

    public void messageBroadcast(String var1);

    public void printText(String var1);

    public void printText(String var1, boolean var2);

    public void messageReceived(String var1, String var2);

    public void simpleRequest(int var1, int var2, int var3, int var4);

    public void simpleAction(int var1, int var2, int var3, int var4);

    public void playerRequestDeclined(int var1, int var2, int var3, String var4);

    public void buildRequestCanceled(SOCPlayer var1);

    public void invItemPlayRejected(int var1, int var2);

    public void playerPickSpecialItem(String var1, SOCGame var2, SOCPlayer var3, int var4, int var5, boolean var6, int var7, int var8, String var9);

    public void playerSetSpecialItem(String var1, SOCGame var2, SOCPlayer var3, int var4, int var5, boolean var6);

    public void scen_SC_PIRI_pirateFortressAttackResult(boolean var1, int var2, int var3);

    public void debugFreePlaceModeToggled(boolean var1);

    public static interface NonBlockingDialogDismissListener {
        public void dialogDismissed(Object var1, boolean var2);
    }

    public static enum UpdateType {
        Clay,
        Ore,
        Sheep,
        Wheat,
        Wood,
        Unknown,
        Resources,
        ResourceTotalAndDetails,
        Road,
        Settlement,
        City,
        Ship,
        Knight,
        Warship,
        Cloth,
        WonderLevel,
        VictoryPoints,
        SpecialVictoryPoints,
        DevCards,
        LongestRoad,
        LargestArmy,
        UndosRemaining;

    }
}

