/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.nand.util.i18n.mgr.StringManager;
import soc.client.SwingMainDisplay;
import soc.disableDebug.D;
import soc.message.SOCAuthRequest;
import soc.message.SOCChannels;
import soc.message.SOCCreateAccount;
import soc.message.SOCMessage;
import soc.message.SOCRejectConnection;
import soc.message.SOCStatusMessage;
import soc.message.SOCVersion;
import soc.util.SOCFeatureSet;
import soc.util.SOCStringManager;
import soc.util.Version;

public class SOCAccountClient
extends JPanel
implements Runnable,
ActionListener,
KeyListener {
    public static final int SRV_VERSION_MIN = 1119;
    private static final String MAIN_PANEL = "main";
    private static final String MESSAGE_PANEL = "message";
    private static final String CONN_PANEL = "conn";
    private JLabel promptLabel;
    private JLabel nickLabel;
    private JTextField nick;
    private JPasswordField pass;
    private JPasswordField pass2;
    private JTextField email;
    private JTextField status;
    private JButton submit;
    private JLabel messageLabel;
    private boolean submitLock;
    private JPanel connPanel;
    private JTextField conn_user;
    private JTextField conn_pass;
    private JTextField conn_status;
    private JButton conn_connect;
    private JButton conn_cancel;
    private boolean conn_sentAuth;
    private CardLayout cardLayout;
    private final int displayScale;
    protected String host;
    protected int port;
    protected Socket sock;
    protected DataInputStream in;
    protected DataOutputStream out;
    protected Thread reader = null;
    protected Exception ex = null;
    protected boolean connected = false;
    protected int sVersion;
    protected SOCFeatureSet sFeatures;
    protected String nickname = null;
    protected String password = null;
    protected String password2 = null;
    protected String emailAddress = null;
    final Locale cliLocale;
    private boolean debugTraffic;
    private final SOCStringManager strings;

    public SOCAccountClient(int displayScaleFactor) {
        this(null, 8880, displayScaleFactor);
    }

    public SOCAccountClient(String h, int p, int displayScaleFactor) throws IllegalArgumentException {
        if (displayScaleFactor < 1) {
            throw new IllegalArgumentException("displayScaleFactor");
        }
        this.host = h;
        this.port = p;
        this.displayScale = displayScaleFactor;
        String jsLocale = System.getProperty("jsettlers.locale");
        Locale lo = null;
        if (jsLocale != null) {
            try {
                lo = StringManager.parseLocale(jsLocale.trim());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Could not parse locale " + jsLocale);
            }
        }
        this.cliLocale = lo != null ? lo : Locale.getDefault();
        this.strings = SOCStringManager.getClientManager(this.cliLocale);
        if (null != System.getProperty("jsettlers.debug.traffic")) {
            this.debugTraffic = true;
        }
    }

    protected void initVisualElements() {
        this.nick = new JTextField(20);
        this.pass = new JPasswordField(10);
        this.pass2 = new JPasswordField(10);
        this.email = new JTextField(50);
        this.status = new JTextField(50);
        this.status.setEditable(false);
        this.submit = new JButton(this.strings.get("account.okcreate"));
        this.submitLock = false;
        this.submit.addActionListener(this);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel mainPane = new JPanel(gbl);
        c.fill = 1;
        this.promptLabel = new JLabel(this.strings.get("account.create.prompt.enter_your_info"), 0);
        c.gridwidth = 0;
        gbl.setConstraints(this.promptLabel, c);
        mainPane.add(this.promptLabel);
        JLabel l = new JLabel(" ");
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        this.nickLabel = new JLabel(this.strings.get("account.create.nickname.your"));
        this.nickLabel.setToolTipText(this.strings.get("account.create.nickname.your.tip"));
        c.gridwidth = 1;
        gbl.setConstraints(this.nickLabel, c);
        mainPane.add(this.nickLabel);
        c.gridwidth = 0;
        gbl.setConstraints(this.nick, c);
        mainPane.add(this.nick);
        l = new JLabel();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new JLabel(this.strings.get("account.create.password"));
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.pass, c);
        mainPane.add(this.pass);
        l = new JLabel();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new JLabel(this.strings.get("account.create.password.again"));
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.pass2, c);
        mainPane.add(this.pass2);
        l = new JLabel();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new JLabel(this.strings.get("account.create.email"));
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.email, c);
        mainPane.add(this.email);
        l = new JLabel();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new JLabel();
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        int oldAnchor = c.anchor;
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 21;
        c.ipadx = 20 * this.displayScale;
        gbl.setConstraints(this.submit, c);
        mainPane.add(this.submit);
        c.fill = 1;
        c.anchor = oldAnchor;
        c.ipadx = 0;
        l = new JLabel();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.status, c);
        mainPane.add(this.status);
        this.messageLabel = new JLabel("", 0);
        JPanel messagePane = new JPanel(new BorderLayout());
        messagePane.add((Component)this.messageLabel, "Center");
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.add((Component)messagePane, MESSAGE_PANEL);
        this.add((Component)mainPane, MAIN_PANEL);
    }

    private void initInterface_conn() {
        JPanel pconn = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        pconn.setLayout(gbl);
        gbc.fill = 1;
        JLabel L = new JLabel(this.strings.get("account.common.must_auth"), 0);
        gbc.gridwidth = 4;
        gbc.ipady = 12 * this.displayScale;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        L = new JLabel();
        gbc.gridwidth = 0;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        gbc.ipady = 0;
        gbc.ipady = 2 * this.displayScale;
        L = new JLabel(this.strings.get("pcli.cpp.server"));
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        L = new JLabel(this.host);
        gbc.gridwidth = 0;
        gbc.ipadx = 4 * this.displayScale;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        gbc.ipadx = 0;
        L = new JLabel(this.strings.get("pcli.cpp.port"));
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        L = new JLabel(Integer.toString(this.port));
        gbc.gridwidth = 0;
        gbc.ipadx = 4 * this.displayScale;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        gbc.ipadx = 0;
        L = new JLabel(this.strings.get("pcli.cpp.nickname"));
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        this.conn_user = new JTextField(20);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.conn_user, gbc);
        this.conn_user.addKeyListener(this);
        pconn.add(this.conn_user);
        L = new JLabel(this.strings.get("pcli.cpp.password"));
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        this.conn_pass = new JPasswordField(20);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.conn_pass, gbc);
        this.conn_pass.addKeyListener(this);
        pconn.add(this.conn_pass);
        gbc.ipady = 0;
        JPanel btnsRow = new JPanel();
        int bsize = 4 * this.displayScale;
        btnsRow.setBorder(BorderFactory.createEmptyBorder(bsize, bsize, bsize, bsize));
        this.conn_connect = new JButton(this.strings.get("pcli.cpp.connect"));
        this.conn_connect.addActionListener(this);
        this.conn_connect.addKeyListener(this);
        btnsRow.add(this.conn_connect);
        this.conn_cancel = new JButton(this.strings.get("base.cancel"));
        this.conn_cancel.addActionListener(this);
        this.conn_cancel.addKeyListener(this);
        btnsRow.add(this.conn_cancel);
        gbc.gridwidth = 0;
        gbc.anchor = 10;
        gbl.setConstraints(btnsRow, gbc);
        pconn.add(btnsRow);
        this.conn_status = new JTextField(50);
        this.conn_status.setEditable(false);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.conn_status, gbc);
        pconn.add(this.conn_status);
        this.connPanel = pconn;
        this.add((Component)pconn, CONN_PANEL);
        this.cardLayout.show(this, CONN_PANEL);
        this.validate();
        this.conn_user.requestFocus();
    }

    private void updateLabelsIfNotOpenReg() {
        if (this.sFeatures.isActive("oreg")) {
            return;
        }
        this.promptLabel.setText(this.strings.get("account.create.prompt.enter_its_info"));
        this.nickLabel.setText(this.strings.get("account.create.nickname.its"));
        this.nickLabel.setToolTipText(this.strings.get("account.create.nickname.its.tip"));
    }

    public synchronized void connect() {
        String hostString = (this.host != null ? this.host : "localhost") + ":" + this.port;
        if (this.connected) {
            throw new IllegalStateException("Already connected to " + hostString);
        }
        if (Version.versionNumber() == 0) {
            this.messageLabel.setText("Packaging error: Cannot determine JSettlers version");
            throw new IllegalStateException("Packaging error: Cannot determine JSettlers version");
        }
        System.out.println("Connecting to " + hostString);
        this.messageLabel.setText(this.strings.get("pcli.message.connecting.serv"));
        try {
            this.sock = new Socket(this.host, this.port);
            this.in = new DataInputStream(this.sock.getInputStream());
            this.out = new DataOutputStream(this.sock.getOutputStream());
            this.connected = true;
            this.reader = new Thread(this);
            this.reader.start();
            this.put(SOCVersion.toCmd(Version.versionNumber(), Version.version(), Version.buildnum(), null, this.cliLocale.toString()));
        }
        catch (Exception e) {
            this.ex = e;
            String msg = this.strings.get("pcli.error.couldnotconnect", this.ex);
            System.err.println(msg);
            this.messageLabel.setText(msg);
        }
    }

    private void clickConnConnect() {
        String user = this.conn_user.getText().trim();
        String pw = this.conn_pass.getText();
        if (user.length() == 0) {
            this.conn_status.setText(this.strings.get("account.must_enter_nick"));
            this.conn_user.requestFocus();
            return;
        }
        if (pw.length() == 0) {
            this.conn_status.setText(this.strings.get("account.must_enter_pw"));
            this.conn_pass.requestFocus();
            return;
        }
        if (pw.length() > 256) {
            this.conn_status.setText(this.strings.get("account.common.password_too_long"));
            this.conn_pass.requestFocus();
            return;
        }
        this.conn_sentAuth = true;
        this.put(new SOCAuthRequest("UA", user, pw, 1, this.host).toCmd());
    }

    private void clickConnCancel() {
        if (this.connPanel != null && this.connPanel.isVisible()) {
            this.connPanel.setVisible(false);
        }
        this.disconnect();
        this.messageLabel.setText(this.strings.get("account.connect.canceled"));
        this.cardLayout.show(this, MESSAGE_PANEL);
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.submit) {
            this.nickname = this.nick.getText().trim();
            if (!SOCMessage.isSingleLineAndSafe(this.nickname)) {
                this.status.setText(this.strings.get("netmsg.status.common.newgame_name_rejected"));
                this.nick.requestFocusInWindow();
                return;
            }
            this.getPasswordFields();
            this.emailAddress = this.email.getText().trim();
            if (this.nickname.length() == 0) {
                this.status.setText(this.strings.get("account.must_enter_nick"));
                this.nick.requestFocus();
            } else if (this.password.length() == 0) {
                this.status.setText(this.strings.get("account.must_enter_pw"));
                this.pass.requestFocus();
            } else if (this.password.length() > 256) {
                this.status.setText(this.strings.get("account.common.password_too_long"));
                this.pass.requestFocus();
            } else if (!this.password.equals(this.password2)) {
                this.pass.requestFocus();
                this.status.setText(this.strings.get("account.create.msg.passwords_dont_match"));
            } else if (!this.submitLock) {
                this.submitLock = true;
                this.status.setText(this.strings.get("account.create.msg.creating"));
                this.put(SOCCreateAccount.toCmd(this.nickname, this.password, this.host, this.emailAddress));
            }
        } else if (target == this.conn_connect) {
            this.clickConnConnect();
        } else if (target == this.conn_cancel) {
            this.clickConnCancel();
        }
    }

    private void getPasswordFields() {
        this.password = this.pass.getText().trim();
        this.password2 = this.pass2.getText().trim();
    }

    @Override
    public void run() {
        block4: {
            try {
                while (this.connected) {
                    String s = this.in.readUTF();
                    SOCMessage msg = SOCMessage.toMsg(s);
                    if (msg != null) {
                        this.treat(msg);
                        continue;
                    }
                    if (!this.debugTraffic) continue;
                    soc.debug.D.ebugERROR("Could not parse net message: " + s);
                }
            }
            catch (IOException e) {
                if (!this.connected) break block4;
                this.ex = e;
                System.out.println("could not read from the net: " + this.ex);
                this.destroy();
            }
        }
    }

    public synchronized boolean put(String s) {
        if (this.debugTraffic || D.ebugIsEnabled()) {
            soc.debug.D.ebugPrintlnINFO("OUT - " + s);
        }
        if (this.ex != null || !this.connected) {
            return false;
        }
        try {
            this.out.writeUTF(s);
        }
        catch (IOException e) {
            this.ex = e;
            System.err.println("could not write to the net: " + this.ex);
            this.destroy();
            return false;
        }
        return true;
    }

    public void treat(SOCMessage mes) {
        if (this.debugTraffic || D.ebugIsEnabled()) {
            soc.debug.D.ebugPrintlnINFO("IN - " + mes.toString());
        }
        try {
            switch (mes.getType()) {
                case 9998: {
                    this.handleVERSION((SOCVersion)mes);
                    break;
                }
                case 1003: {
                    this.handleCHANNELS((SOCChannels)mes);
                    break;
                }
                case 1069: {
                    this.handleSTATUSMESSAGE((SOCStatusMessage)mes);
                    break;
                }
                case 1059: {
                    this.handleREJECTCONNECTION((SOCRejectConnection)mes);
                }
            }
        }
        catch (Exception e) {
            System.out.println("SOCAccountClient treat ERROR - " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void handleVERSION(SOCVersion mes) {
        this.sVersion = mes.getVersionNumber();
        if (this.sVersion < 1119) {
            this.disconnect();
            this.messageLabel.setText(this.strings.get("account.server_version_minimum", Version.version(this.sVersion), Version.version(1119)));
            this.cardLayout.show(this, MESSAGE_PANEL);
            this.validate();
            return;
        }
        SOCFeatureSet sOCFeatureSet = this.sFeatures = this.sVersion >= 1119 ? new SOCFeatureSet(mes.feats) : new SOCFeatureSet(true, true);
        if (!this.sFeatures.isActive("accts")) {
            this.disconnect();
            this.messageLabel.setText(this.strings.get("account.common.no_accts"));
            this.cardLayout.show(this, MESSAGE_PANEL);
            this.validate();
            return;
        }
        if (!this.sFeatures.isActive("oreg")) {
            this.initInterface_conn();
            this.updateLabelsIfNotOpenReg();
        }
    }

    protected void handleCHANNELS(SOCChannels mes) {
        if (this.connPanel != null && this.connPanel.isVisible()) {
            return;
        }
        this.cardLayout.show(this, MAIN_PANEL);
        this.validate();
        this.nick.requestFocus();
    }

    protected void handleREJECTCONNECTION(SOCRejectConnection mes) {
        this.disconnect();
        this.messageLabel.setText(mes.getText());
        this.cardLayout.show(this, MESSAGE_PANEL);
        this.validate();
    }

    protected void handleSTATUSMESSAGE(SOCStatusMessage mes) {
        int sv = mes.getStatusValue();
        String statusText = mes.getStatus();
        if (sv == 20) {
            sv = 0;
            int i = statusText.indexOf(44);
            if (i > 0) {
                this.nickname = statusText.substring(0, i);
                statusText = statusText.substring(i + 1);
            }
        }
        if (this.connPanel != null && this.connPanel.isVisible()) {
            if (sv != 0 || !this.conn_sentAuth) {
                this.conn_status.setText(statusText);
                return;
            }
            this.connPanel.setVisible(false);
            this.cardLayout.show(this, MAIN_PANEL);
            this.validate();
            this.nick.requestFocus();
        }
        this.status.setText(statusText);
        if (sv == 7 || sv == 18) {
            this.pass.setText("");
            this.pass2.setText("");
            if (sv == 18) {
                this.put(new SOCAuthRequest("UA", this.nickname, this.password, 1, this.host).toCmd());
            }
        }
        this.submitLock = false;
    }

    protected synchronized void disconnect() {
        this.connected = false;
        try {
            this.sock.close();
        }
        catch (Exception e) {
            this.ex = e;
        }
    }

    private WindowAdapter createWindowAdapter() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                SOCAccountClient.this.nick.requestFocus();
            }
        };
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 10: {
                e.consume();
                this.clickConnConnect();
                break;
            }
            case 3: 
            case 27: {
                e.consume();
                this.clickConnCancel();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public String getAppletInfo() {
        return "SOCAccountClient 0.1 by Robert S. Thomas.";
    }

    public void destroy() {
        String detail = this.ex == null ? this.strings.get("account.msg.refresh") : this.ex.toString();
        String err = this.strings.get("account.msg.applet_destroyed", detail);
        this.disconnect();
        this.messageLabel.setText(err);
        this.cardLayout.show(this, MESSAGE_PANEL);
        this.validate();
    }

    public static void usage() {
        System.err.println("usage: java -cp JSettlers.jar soc.client.SOCAccountClient <host> [<port>]");
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame frame = new JFrame("SOCAccountClient");
        int displayScale = SwingMainDisplay.checkDisplayScaleFactor(frame);
        SwingMainDisplay.scaleUIManagerFonts(displayScale);
        int bsize = 8 * displayScale;
        frame.getRootPane().setBorder(BorderFactory.createEmptyBorder(bsize, bsize, bsize, bsize));
        SOCAccountClient client = new SOCAccountClient(displayScale);
        if (args.length < 1 || args.length > 2) {
            SOCAccountClient.usage();
            System.exit(1);
        }
        try {
            client.host = args[0];
            client.port = args.length > 1 ? Integer.parseInt(args[1]) : 8880;
        }
        catch (NumberFormatException x) {
            SOCAccountClient.usage();
            System.err.println("Invalid port: " + args[1]);
            System.exit(1);
        }
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(client.createWindowAdapter());
        client.initVisualElements();
        frame.add((Component)client, "Center");
        frame.pack();
        frame.setVisible(true);
        client.connect();
    }
}

