/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import soc.client.AskDialog;
import soc.client.ColorSquare;
import soc.client.GameMessageSender;
import soc.client.NotifyDialog;
import soc.client.SOCHandPanel;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.UserPreferences;
import soc.game.GameAction;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCCity;
import soc.game.SOCFortress;
import soc.game.SOCGame;
import soc.game.SOCInventoryItem;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCRoad;
import soc.game.SOCRoutePiece;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.game.SOCVillage;
import soc.util.SOCStringManager;

class SOCBoardPanel
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final SOCStringManager strings = SOCStringManager.getClientManager();
    private static String IMAGEDIR = "/resources/hexes";
    private static String[] HEX_GRAPHICS_SET_SUBDIRS = new String[]{"pastel", "classic"};
    private static float SCALE_FACTOR_MIN = 1.08f;
    private static final int BOARDWIDTH_VISUAL_MIN = 18;
    private static final int BOARDHEIGHT_VISUAL_MIN = 17;
    private static final int deltaY = 46;
    private static final int deltaX = 54;
    private static final int halfdeltaX = 27;
    private static final int halfdeltaY = 23;
    private static final int[] DELTAX_FACING = new int[]{0, 27, 54, 27, -27, -54, -27};
    private static final int[] DELTAY_FACING = new int[]{0, -46, 0, 46, 46, 0, -46};
    private static final int[] hexX_st = new int[]{81, 135, 189, 243, 54, 108, 162, 216, 270, 27, 81, 135, 189, 243, 297, 0, 54, 108, 162, 216, 270, 324, 27, 81, 135, 189, 243, 297, 54, 108, 162, 216, 270, 81, 135, 189, 243};
    private static final int[] hexY_st = new int[]{0, 0, 0, 0, 46, 46, 46, 46, 46, 92, 92, 92, 92, 92, 92, 138, 138, 138, 138, 138, 138, 138, 184, 184, 184, 184, 184, 184, 230, 230, 230, 230, 230, 276, 276, 276, 276};
    private static int[] hexX_6pl;
    private static int[] hexY_6pl;
    private static final int HEXX_OFF_6PL = 54;
    private static final int HEXY_OFF_6PL = 46;
    private static final int HEXY_OFF_6PL_FIND = 7;
    private static final int HEXY_OFF_SLOPE_HEIGHT = 16;
    private static final int HEX_PORT_CIRCLE_DIA = 38;
    private static final int MOST_RECENT_PLACEMENT_STROKE_WIDTH_OUTER = 5;
    private static final int MOST_RECENT_PLACEMENT_STROKE_WIDTH_INNER = 3;
    private static final int[] vertRoadX;
    private static final int[] vertRoadY;
    private static final int[] upRoadX;
    private static final int[] upRoadY;
    private static final int[] downRoadX;
    private static final int[] downRoadY;
    private static final int[] settlementX;
    private static final int[] settlementY;
    private static final int[] cityX;
    private static final int[] cityY;
    private static final int[] shipX;
    private static final int[] shipY;
    private static final int[] warshipX;
    private static final int[] warshipY;
    private static final int[] fortressX;
    private static final int[] fortressY;
    private static final int[] diamondX;
    private static final int[] diamondY;
    private static final int[] robberX;
    private static final int[] robberY;
    private static final int[][] portArrowsX;
    private static final int[][] portArrowsY;
    private static final int[] arrowXL;
    private static int[] arrowXR;
    private static final int[] arrowY;
    private static final int ARROW_SZ = 37;
    private static final Color ARROW_COLOR;
    private static final Color ARROW_COLOR_PLACING;
    private static final Color[] HEX_BORDER_COLORS;
    private static final Color[] ROTAT_HEX_BORDER_COLORS;
    private static final Color[] HEX_GRAPHICS_SET_BORDER_WATER_COLORS;
    private static final Color[] HEX_GRAPHICS_SET_SC_PIRI_PATH_COLORS;
    private static final int RESCALE_RETRY_DELAY_MS = 3000;
    private static final int RESCALE_MAX_RETRY_MS = 7000;
    private static final int NONE = 0;
    private static final int PLACE_ROAD = 1;
    private static final int PLACE_SETTLEMENT = 2;
    private static final int PLACE_CITY = 3;
    private static final int PLACE_ROBBER = 4;
    private static final int PLACE_INIT_SETTLEMENT = 5;
    private static final int PLACE_INIT_ROAD = 6;
    public static final int CONSIDER_LM_SETTLEMENT = 7;
    public static final int CONSIDER_LM_ROAD = 8;
    public static final int CONSIDER_LM_SHIP = 13;
    public static final int CONSIDER_LM_CITY = 9;
    public static final int CONSIDER_LT_SETTLEMENT = 10;
    public static final int CONSIDER_LT_ROAD = 11;
    public static final int CONSIDER_LT_SHIP = 14;
    public static final int CONSIDER_LT_CITY = 12;
    private static final int PLACE_SHIP = 15;
    private static final int PLACE_FREE_ROAD_OR_SHIP = 16;
    private static final int MOVE_SHIP = 17;
    private static final int PLACE_PIRATE = 18;
    private static final int SC_FTRI_PLACE_PORT = 19;
    private static final int TURN_STARTING = 97;
    private static final int GAME_FORMING = 98;
    private static final int GAME_OVER = 99;
    public static final int HOVER_OFFSET_X_FOR_INIT_PLACE = 9;
    public static final int HOVER_OFFSET_X_FOR_ROBBER = 15;
    protected static int BUILD_REQUEST_MAX_DELAY_SEC;
    protected static int POPUP_MENU_IGNORE_MS;
    private static final int SUPERTEXT_INSET = 3;
    private static final int SUPERTEXT_PADDING_HORIZ = 8;
    private static final int HEXWIDTH = 55;
    private static final int HEXHEIGHT = 64;
    private static final int HALF_HEXHEIGHT = 32;
    private static final int PANELPAD_CBOARD4_WIDTH = 28;
    private static final int PANELPAD_CBOARD4_HEIGHT = 2;
    private static final int PANELPAD_LBOARD_RT = 32;
    private static final int PANELPAD_LBOARD_BTM = 13;
    public static final int PANELX = 379;
    public static final int PANELY = 340;
    private static final int DICE_NUMBER_CIRCLE_DIAMETER = 20;
    private static final int DICE_NUMBER_FONTPOINTS = 13;
    private static final Color[] DICE_NUMBER_CIRCLE_COLORS;
    private Dimension minSize;
    private boolean hasCalledSetSize;
    protected boolean is6player;
    protected final boolean isLargeBoard;
    protected boolean isRotated;
    protected boolean isScaledOrRotated;
    private int scaledPanelW;
    private int scaledPanelH;
    private int scaledBoardW;
    protected int panelMinBW;
    protected int panelMinBH;
    protected int panelShiftBX;
    protected int panelShiftBY;
    protected int panelMarginX;
    protected int panelMarginY;
    private int unscaledBoardW;
    private boolean isHexesAlwaysScaled;
    protected boolean isScaled;
    protected long scaledAt;
    protected boolean scaledMissedImage;
    private long drawnEmptyAt;
    private boolean debugShowCoordsTooltip = false;
    boolean[] debugShowPotentials;
    private Font diceNumberCircleFont;
    private FontMetrics diceNumberCircleFM;
    private int[] hexIDtoNum;
    private boolean[] inactiveHexNums;
    private Set<Integer> portHexCoords;
    private int[] hexX;
    private int[] hexY;
    private static BufferedImage[] hexes;
    private static boolean hexesMustAlwaysScale;
    private static int hexesGraphicsSetIndex;
    private static BufferedImage[] rotatHexes;
    private static boolean rotatHexesMustAlwaysScale;
    private BufferedImage[] scaledHexes;
    private BufferedImage[] scaledPorts;
    private int scaledHexesGraphicsSetIndex;
    private boolean[] scaledHexFail;
    private boolean[] scaledPortFail;
    private static final int DICE_SZ = 24;
    private int[] scaledVertRoadX;
    private int[] scaledVertRoadY;
    private int[] scaledUpRoadX;
    private int[] scaledUpRoadY;
    private int[] scaledDownRoadX;
    private int[] scaledDownRoadY;
    private int[] scaledSettlementX;
    private int[] scaledSettlementY;
    private int[] scaledCityX;
    private int[] scaledCityY;
    private int[] scaledShipX;
    private int[] scaledShipY;
    private int[] scaledFortressX;
    private int[] scaledFortressY;
    private int[] scaledDiamondX;
    private int[] scaledDiamondY;
    private int[] scaledWarshipX;
    private int[] scaledWarshipY;
    private int[] scaledRobberX;
    private int[] scaledRobberY;
    private int[][] scaledPortArrowsX;
    private int[][] scaledPortArrowsY;
    private int[] scaledArrowXL;
    private int[] scaledArrowXR;
    private int[] scaledArrowY;
    private Font arrowDiceFont;
    private int arrowDiceHeight;
    private static final int[] hexCornersX;
    private static final int[] hexCornersY;
    private int[] scaledHexCornersX;
    private int[] scaledHexCornersY;
    private int ptrOldX;
    private int ptrOldY;
    private BoardToolTip hoverTip;
    private BoardPopupMenu popupMenu;
    private long popupMenuSystime;
    protected BoardPanelSendBuildTask buildReqTimerTask;
    private String superText1;
    private String superText2;
    private int superText1_w;
    private int superText_h;
    private int superText_des;
    private int superText2_w;
    private int superTextBox_x;
    private int superTextBox_y;
    private int superTextBox_w;
    private int superTextBox_h;
    private String superTextTop;
    private int superTextTop_w;
    private int superTextTop_h;
    private int superTextTopBox_x;
    private int superTextTopBox_w;
    private int superTextTopBox_h;
    private SOCPlayingPiece latestPiecePlacement;
    private int hilight;
    private boolean hilightIsShip;
    private int moveShip_fromEdge;
    private int moveShip_toEdge;
    private boolean moveShip_isWarship;
    private int[] edgeMap;
    private int[] nodeMap;
    private int[] hexMap;
    private SOCGame game;
    private SOCBoard board;
    private SOCPlayer player;
    private int playerNumber;
    private SOCPlayer otherPlayer;
    private VolatileImage buffer;
    private VolatileImage emptyBoardBuffer;
    private int mode;
    private int hintShownCount_RightClickToBuild;
    private int initSettlementNode;
    private final SOCPlayerInterface playerInterface;
    protected Color[] robberGhostFill;
    protected Color[] robberGhostOutline;
    private static final int[] ROW_START_HEXNUM;

    public SOCBoardPanel(SOCPlayerInterface pi, int[] layoutVS) {
        BufferedImage[] h;
        this.setOpaque(true);
        this.game = pi.getGame();
        this.playerInterface = pi;
        this.player = null;
        this.playerNumber = -1;
        this.board = this.game.getBoard();
        this.isScaled = false;
        this.scaledMissedImage = false;
        int bef = this.board.getBoardEncodingFormat();
        if (bef == 3) {
            this.is6player = false;
            this.isLargeBoard = true;
            this.isScaledOrRotated = false;
            this.isRotated = false;
        } else {
            this.is6player = bef == 2 || this.game.maxPlayers > 4;
            this.isLargeBoard = false;
            this.isRotated = this.isScaledOrRotated = this.is6player;
        }
        if (this.isRotated) {
            this.scaledPanelW = 432;
            this.panelMinBW = this.scaledPanelH = 402;
            this.panelMinBH = this.scaledPanelW;
        } else {
            if (this.isLargeBoard) {
                int bh = this.board.getBoardHeight();
                int bw = this.board.getBoardWidth();
                if (bh < 17) {
                    bh = 17;
                }
                if (bw < 18) {
                    bw = 18;
                }
                this.scaledPanelW = 27 * bw + 32;
                this.scaledPanelH = 23 * bh + 13 + 16;
                if (layoutVS != null) {
                    int shiftBY = layoutVS[0] * 23 / 2;
                    int shiftBX = layoutVS[1] * 27 / 2;
                    if (shiftBX != 0) {
                        this.panelMarginX = this.panelShiftBX = shiftBX;
                        if (shiftBX > 0) {
                            this.scaledPanelW += shiftBX;
                        }
                    }
                    if (shiftBY != 0) {
                        this.panelMarginY = this.panelShiftBY = shiftBY;
                        if (shiftBY > 0) {
                            this.scaledPanelH += shiftBY;
                        }
                    }
                    if (layoutVS.length >= 4) {
                        int trimBY = layoutVS[2] * 23 / 2;
                        int trimBX = layoutVS[3] * 27 / 2;
                        if (trimBX > 0) {
                            this.scaledPanelW -= trimBX;
                        }
                        if (trimBY > 0) {
                            this.scaledPanelH -= trimBY;
                        }
                    }
                }
            } else {
                this.scaledPanelW = 379;
                this.scaledPanelH = 340;
                this.panelMarginX = this.panelShiftBX = -13;
            }
            this.panelMinBW = this.scaledPanelW;
            this.panelMinBH = this.scaledPanelH;
        }
        this.minSize = new Dimension(this.scaledPanelW, this.scaledPanelH);
        this.unscaledBoardW = this.scaledPanelW;
        this.scaledBoardW = this.scaledPanelW;
        this.hasCalledSetSize = false;
        this.debugShowPotentials = new boolean[10];
        this.ptrOldX = 0;
        this.ptrOldY = 0;
        this.hilight = 0;
        this.moveShip_fromEdge = 0;
        this.hilightIsShip = false;
        if (this.isLargeBoard) {
            this.edgeMap = null;
            this.nodeMap = null;
            this.hexMap = null;
            this.hexIDtoNum = null;
            this.hexX = null;
            this.hexY = null;
            this.inactiveHexNums = null;
        } else {
            this.initCoordMappings();
        }
        this.mode = 0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.robberGhostFill = new Color[1 + this.board.max_robber_hextype];
        this.robberGhostOutline = new Color[1 + this.board.max_robber_hextype];
        this.hoverTip = new BoardToolTip(this);
        this.popupMenu = new BoardPopupMenu(this);
        this.add(this.popupMenu);
        this.popupMenuSystime = System.currentTimeMillis();
        this.superText1 = null;
        this.superText2 = null;
        SOCBoardPanel.loadImages(this, this.isRotated);
        if (this.isRotated) {
            h = rotatHexes;
            this.isHexesAlwaysScaled = rotatHexesMustAlwaysScale;
        } else {
            h = hexes;
            this.isHexesAlwaysScaled = hexesMustAlwaysScale;
        }
        this.scaledHexes = new BufferedImage[h.length];
        this.scaledPorts = new BufferedImage[6];
        for (int i = h.length - 1; i >= 0; --i) {
            this.scaledHexes[i] = h[i];
        }
        this.scaledHexesGraphicsSetIndex = hexesGraphicsSetIndex;
        this.scaledHexFail = new boolean[h.length];
        this.scaledPortFail = new boolean[this.scaledPorts.length];
        this.rescaleCoordinateArrays();
    }

    private void initCoordMappings() {
        this.edgeMap = new int[345];
        Arrays.fill(this.edgeMap, 0);
        if (this.is6player) {
            this.initEdgeMapAux(3, 0, 9, 3, 23);
            this.initEdgeMapAux(2, 3, 10, 6, 21);
            this.initEdgeMapAux(1, 6, 11, 9, 19);
            this.initEdgeMapAux(0, 9, 12, 12, 17);
            this.initEdgeMapAux(1, 12, 11, 15, 49);
            this.initEdgeMapAux(2, 15, 10, 18, 81);
            this.initEdgeMapAux(3, 18, 9, 21, 113);
        } else {
            this.initEdgeMapAux(4, 3, 10, 6, 55);
            this.initEdgeMapAux(3, 6, 11, 9, 53);
            this.initEdgeMapAux(2, 9, 12, 12, 51);
            this.initEdgeMapAux(3, 12, 11, 15, 83);
            this.initEdgeMapAux(4, 15, 10, 18, 115);
        }
        this.nodeMap = new int[345];
        Arrays.fill(this.nodeMap, 0);
        if (this.is6player) {
            this.initNodeMapAux(3, 0, 9, 4, 23);
            this.initNodeMapAux(2, 3, 10, 7, 21);
            this.initNodeMapAux(1, 6, 11, 10, 19);
            this.initNodeMapAux(0, 9, 12, 13, 17);
            this.initNodeMapAux(1, 12, 11, 16, 49);
            this.initNodeMapAux(2, 15, 10, 19, 81);
            this.initNodeMapAux(3, 18, 9, 22, 113);
        } else {
            this.initNodeMapAux(4, 3, 10, 7, 55);
            this.initNodeMapAux(3, 6, 11, 10, 53);
            this.initNodeMapAux(2, 9, 12, 13, 51);
            this.initNodeMapAux(3, 12, 11, 16, 83);
            this.initNodeMapAux(4, 15, 10, 19, 115);
        }
        this.hexMap = new int[345];
        Arrays.fill(this.hexMap, 0);
        if (this.is6player) {
            this.initHexMapAux(3, 1, 8, 2, 23);
            this.initHexMapAux(2, 4, 9, 5, 21);
            this.initHexMapAux(1, 7, 10, 8, 19);
            this.initHexMapAux(0, 10, 11, 11, 17);
            this.initHexMapAux(1, 13, 10, 14, 49);
            this.initHexMapAux(2, 16, 9, 17, 81);
            this.initHexMapAux(3, 19, 8, 20, 113);
        } else {
            this.initHexMapAux(4, 4, 9, 5, 55);
            this.initHexMapAux(3, 7, 10, 8, 53);
            this.initHexMapAux(2, 10, 11, 11, 51);
            this.initHexMapAux(3, 13, 10, 14, 83);
            this.initHexMapAux(4, 16, 9, 17, 115);
        }
        this.hexIDtoNum = new int[222];
        Arrays.fill(this.hexIDtoNum, 0);
        this.initHexIDtoNumAux(23, 125, 0);
        this.initHexIDtoNumAux(21, 157, 4);
        this.initHexIDtoNumAux(19, 189, 9);
        this.initHexIDtoNumAux(17, 221, 15);
        this.initHexIDtoNumAux(49, 219, 22);
        this.initHexIDtoNumAux(81, 217, 28);
        this.initHexIDtoNumAux(113, 215, 33);
        if (this.is6player) {
            int i;
            if (hexX_6pl == null) {
                int L = hexX_st.length;
                hexX_6pl = new int[L];
                hexY_6pl = new int[L];
                for (i = 0; i < L; ++i) {
                    SOCBoardPanel.hexX_6pl[i] = hexX_st[i] + 54;
                }
                for (i = 0; i < L; ++i) {
                    SOCBoardPanel.hexY_6pl[i] = hexY_st[i] + 46;
                }
            }
            this.hexX = hexX_6pl;
            this.hexY = hexY_6pl;
            this.inactiveHexNums = new boolean[hexX_6pl.length];
            int[] inacIdx = new int[]{3, 8, 14, 21, 27, 32, 36};
            for (i = 0; i < inacIdx.length; ++i) {
                this.inactiveHexNums[inacIdx[i]] = true;
            }
        } else {
            this.hexX = hexX_st;
            this.hexY = hexY_st;
            this.inactiveHexNums = null;
        }
    }

    private final void initEdgeMapAux(int x1, int y1, int x2, int y2, int startHex) {
        int hexVerticalXmod2 = x1 % 2;
        int facing = 0;
        int count = 0;
        int edgeNum = 0;
        for (int y = y1; y <= y2; ++y) {
            int hexNum = startHex;
            switch (count) {
                case 0: {
                    facing = 6;
                    edgeNum = hexNum - 16;
                    break;
                }
                case 1: {
                    facing = 5;
                    edgeNum = hexNum - 17;
                    break;
                }
                case 2: {
                    facing = 5;
                    edgeNum = hexNum - 17;
                    break;
                }
                case 3: {
                    facing = 4;
                    edgeNum = hexNum - 1;
                    break;
                }
                default: {
                    System.out.println("initEdgeMap error");
                    return;
                }
            }
            if (edgeNum == 0) {
                edgeNum = -1;
            }
            boolean inMiddleRowsOfHex = y > y1 && y < y2;
            block15: for (int x = x1; x <= x2; ++x) {
                if (inMiddleRowsOfHex && x % 2 != hexVerticalXmod2) {
                    edgeNum = 0;
                }
                this.edgeMap[x + y * 15] = edgeNum;
                switch (facing) {
                    case 1: {
                        facing = 6;
                        edgeNum = (hexNum += 34) - 16;
                        continue block15;
                    }
                    case 2: {
                        facing = 5;
                        edgeNum = (hexNum += 34) - 17;
                        continue block15;
                    }
                    case 3: {
                        facing = 4;
                        edgeNum = (hexNum += 34) - 1;
                        continue block15;
                    }
                    case 4: {
                        facing = 3;
                        edgeNum = hexNum + 16;
                        continue block15;
                    }
                    case 5: {
                        facing = 2;
                        edgeNum = hexNum + 17;
                        continue block15;
                    }
                    case 6: {
                        facing = 1;
                        edgeNum = hexNum + 1;
                        continue block15;
                    }
                    default: {
                        System.out.println("initEdgeMap error");
                        return;
                    }
                }
            }
            ++count;
        }
    }

    private final void initHexMapAux(int x1, int y1, int x2, int y2, int startHex) {
        int count = 0;
        for (int y = y1; y <= y2; ++y) {
            int hexNum = startHex;
            for (int x = x1; x <= x2; ++x) {
                this.hexMap[x + y * 15] = hexNum;
                if (count % 2 != 0) {
                    hexNum += 34;
                }
                ++count;
            }
        }
    }

    private final void initNodeMapAux(int x1, int y1, int x2, int y2, int startHex) {
        int rowState = 0;
        int row = 0;
        int nodeNum = 0;
        int y = y1;
        while (y <= y2) {
            int hexNum = startHex;
            switch (row) {
                case 0: {
                    rowState = 0;
                    nodeNum = 0;
                    break;
                }
                case 1: {
                    rowState = 10;
                    nodeNum = hexNum - 16;
                    break;
                }
                case 2: {
                    rowState = 20;
                    nodeNum = 0;
                    break;
                }
                case 3: {
                    rowState = 30;
                    nodeNum = hexNum - 1;
                    break;
                }
                case 4: {
                    rowState = 40;
                    nodeNum = 0;
                    break;
                }
                default: {
                    System.out.println("initNodeMap error");
                    return;
                }
            }
            block21: for (int x = x1; x <= x2; ++x) {
                this.nodeMap[x + y * 15] = nodeNum;
                switch (rowState) {
                    case 1: {
                        rowState = 0;
                        hexNum += 34;
                        nodeNum = 0;
                        continue block21;
                    }
                    case 0: {
                        rowState = 1;
                        nodeNum = hexNum + 1;
                        continue block21;
                    }
                    case 12: {
                        rowState = 11;
                        hexNum += 34;
                        nodeNum = 0;
                        continue block21;
                    }
                    case 11: {
                        rowState = 12;
                        nodeNum = hexNum + 18;
                        continue block21;
                    }
                    case 10: {
                        rowState = 11;
                        nodeNum = 0;
                        continue block21;
                    }
                    case 20: {
                        nodeNum = 0;
                        continue block21;
                    }
                    case 30: {
                        rowState = 31;
                        nodeNum = 0;
                        continue block21;
                    }
                    case 32: {
                        rowState = 31;
                        hexNum += 34;
                        nodeNum = 0;
                        continue block21;
                    }
                    case 31: {
                        rowState = 32;
                        nodeNum = hexNum + 33;
                        continue block21;
                    }
                    case 41: {
                        rowState = 40;
                        hexNum += 34;
                        nodeNum = 0;
                        continue block21;
                    }
                    case 40: {
                        rowState = 41;
                        nodeNum = hexNum + 16;
                        continue block21;
                    }
                    default: {
                        System.out.println("initNodeMap error");
                        return;
                    }
                }
            }
            ++y;
            ++row;
        }
    }

    private final void initHexIDtoNumAux(int begin, int end, int num) {
        for (int i = begin; i <= end; i += 34) {
            this.hexIDtoNum[i] = num++;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.scaledPanelW, this.scaledPanelH);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minSize;
    }

    public Dimension getExtraSizeFromBoard(boolean doScale) {
        if (!this.isLargeBoard) {
            if (this.isRotated) {
                int retW = 92;
                int retH = 23;
                if (doScale) {
                    retW = this.scaleToActual(retW);
                    retH = this.scaleToActual(retH);
                }
                return new Dimension(retW, retH);
            }
            return new Dimension(0, 0);
        }
        int bh = this.board.getBoardHeight();
        int bw = this.board.getBoardWidth();
        if (bh < 17) {
            bh = 17;
        }
        if (bw < 18) {
            bw = 18;
        }
        int w = (bw -= 13) * 27;
        int h = (bh -= 14) * 23;
        if (this.panelShiftBX > 0) {
            w += this.panelShiftBX;
        }
        if (this.panelShiftBY > 0) {
            h += this.panelShiftBY;
        }
        int retW = w - 28 + 32;
        int retH = h - 2 + 13;
        if (doScale) {
            retW = this.scaleToActual(retW);
            retH = this.scaleToActual(retH);
        }
        return new Dimension(retW, retH);
    }

    @Override
    public void setSize(int newW, int newH) throws IllegalArgumentException {
        this.setSize(newW, newH, false);
    }

    public void setSize(int newW, int newH, boolean noException) throws IllegalArgumentException {
        if (newW == this.scaledPanelW && newH == this.scaledPanelH && this.hasCalledSetSize) {
            return;
        }
        if (noException) {
            if (newW != 0 && newW < this.minSize.width) {
                newW = this.minSize.width;
            }
            if (newH != 0 && newH < this.minSize.height) {
                newH = this.minSize.height;
            }
        }
        this.rescaleBoard(newW, newH);
        super.setSize(newW, newH);
        if (newW > 0 && newH > 0) {
            this.hasCalledSetSize = true;
        }
        this.repaint();
    }

    @Override
    public void setSize(Dimension sz) throws IllegalArgumentException {
        this.setSize(sz.width, sz.height);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) throws IllegalArgumentException {
        if (w != this.scaledPanelW || h != this.scaledPanelH) {
            this.rescaleBoard(w, h);
        }
        super.setBounds(x, y, w, h);
    }

    public void setLatestPiecePlacement(SOCPlayingPiece piece) {
        this.latestPiecePlacement = piece;
    }

    public void pieceValueUpdated(SOCPlayingPiece piece) {
        if (piece instanceof SOCFortress) {
            final SOCFortress fort = (SOCFortress)piece;
            int strength = fort.getStrength();
            if (0 == strength) {
                if (0 == ((SOCBoardLarge)this.board).getPirateHex()) {
                    this.flushBoardLayoutAndRepaint();
                }
                return;
            }
            final int pn = piece.getPlayerNumber();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Graphics bgr;
                    boolean xlat = SOCBoardPanel.this.panelMarginX != 0 || SOCBoardPanel.this.panelMarginY != 0;
                    VolatileImage ibuf = SOCBoardPanel.this.buffer;
                    if (ibuf != null) {
                        SOCBoardPanel.this.drawFortress(((Image)ibuf).getGraphics(), fort, pn, false, xlat);
                    }
                    if ((bgr = SOCBoardPanel.this.getGraphics()) != null) {
                        SOCBoardPanel.this.drawFortress(bgr, fort, pn, false, xlat);
                    } else {
                        SOCBoardPanel.this.repaint();
                    }
                }
            });
        } else if (piece instanceof SOCVillage) {
            if (((SOCVillage)piece).getCloth() == 0) {
                this.flushBoardLayoutAndRepaint();
            }
        } else {
            this.flushBoardLayoutAndRepaint();
        }
    }

    public void flushBoardLayoutAndRepaint() {
        if (this.emptyBoardBuffer != null) {
            this.emptyBoardBuffer.flush();
            this.emptyBoardBuffer = null;
        }
        if (this.isScaled || this.isHexesAlwaysScaled) {
            this.scaledAt = System.currentTimeMillis();
            this.scaledMissedImage = false;
        }
        if (this.scaledHexes != null && this.scaledHexesGraphicsSetIndex != hexesGraphicsSetIndex) {
            try {
                this.rescaleBoard(this.scaledPanelW, this.scaledPanelH);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.repaint();
    }

    public void flushBoardLayoutAndRepaintIfDebugShowPotentials() {
        boolean foundAny = false;
        for (int i = this.debugShowPotentials.length - 1; i >= 0; --i) {
            if (!this.debugShowPotentials[i]) continue;
            foundAny = true;
            break;
        }
        if (!foundAny) {
            return;
        }
        this.flushBoardLayoutAndRepaint();
    }

    private void rescaleBoard(int newW, int newH) throws IllegalArgumentException {
        Color[] BC;
        BufferedImage[] staticHex;
        int hexesWidth;
        if (newW == 0 || newH == 0) {
            return;
        }
        if (newW < this.minSize.width || newH < this.minSize.height) {
            throw new IllegalArgumentException("Below minimum size");
        }
        this.scaledPanelW = newW;
        this.scaledPanelH = newH;
        this.scaledBoardW = newW;
        this.isScaled = true;
        this.scaledHexesGraphicsSetIndex = hexesGraphicsSetIndex;
        if (this.scaleToActual(this.minSize.height) > newH) {
            float ratio = (float)newH / (float)this.minSize.height;
            this.scaledBoardW = (int)(ratio * (float)this.minSize.width);
        }
        if (this.scaledPanelW != this.minSize.width || this.scaledPanelH != this.minSize.height) {
            boolean bl = this.isScaled = (float)this.scaledPanelW / (float)this.minSize.width >= SCALE_FACTOR_MIN && (float)this.scaledPanelH / (float)this.minSize.height >= SCALE_FACTOR_MIN;
            if (!this.isScaled) {
                this.scaledBoardW = this.minSize.width;
            }
        }
        this.scaledAt = System.currentTimeMillis();
        boolean bl = this.isScaledOrRotated = this.isScaled || this.isRotated;
        if (this.isRotated) {
            hexesWidth = 23 * (this.board.getBoardHeight() + 2) + 32 + 16;
            this.panelMarginX = this.scaleToActual(this.panelMinBH - hexesWidth) / 2;
            int hexesHeight = 27 * (this.board.getBoardWidth() - 1);
            int scaledBoardH = this.scaleToActual(hexesHeight);
            this.panelMarginY = (this.scaledPanelH - scaledBoardH) / 2;
        } else {
            hexesWidth = 27 * this.board.getBoardWidth();
            this.panelMarginX = this.scaleToActual(this.panelMinBW - hexesWidth) / 2;
            this.panelMarginY = (this.scaledPanelH - this.scaleToActual(this.panelMinBH)) / 2;
        }
        if (this.panelMarginX < 6) {
            this.panelMarginX = 0;
        }
        if (this.scaledBoardW < this.scaledPanelW) {
            this.panelMarginX += (this.scaledPanelW - this.scaledBoardW) / 2;
        }
        if (this.panelMarginY < 5) {
            this.panelMarginY = 0;
        }
        this.panelMarginX += this.scaleToActual(this.panelShiftBX);
        this.panelMarginY += this.scaleToActual(this.panelShiftBY);
        if (this.buffer != null) {
            this.buffer.flush();
            this.buffer = null;
        }
        if (this.emptyBoardBuffer != null) {
            this.emptyBoardBuffer.flush();
            this.emptyBoardBuffer = null;
        }
        this.diceNumberCircleFont = null;
        this.diceNumberCircleFM = null;
        this.rescaleCoordinateArrays();
        if (this.isRotated) {
            staticHex = rotatHexes;
            BC = ROTAT_HEX_BORDER_COLORS;
        } else {
            staticHex = hexes;
            BC = HEX_BORDER_COLORS;
        }
        Color waterBC = HEX_GRAPHICS_SET_BORDER_WATER_COLORS[hexesGraphicsSetIndex];
        if (!this.isScaled && !this.isHexesAlwaysScaled) {
            for (int i = this.scaledHexes.length - 1; i >= 0; --i) {
                this.scaledHexes[i] = i < BC.length ? this.renderBorderedHex(staticHex[i], i != 0 ? BC[i] : waterBC) : staticHex[i];
            }
        } else {
            int i;
            int w = this.scaleToActual(this.isRotated ? 64 : 55);
            int h = this.scaleToActual(this.isRotated ? 55 : 64);
            for (i = this.scaledHexes.length - 1; i >= 0; --i) {
                if (staticHex[i] != null) {
                    BufferedImage hi = this.getScaledImageUp(staticHex[i], w, h);
                    if (i < BC.length) {
                        hi = this.renderBorderedHex(hi, i != 0 ? BC[i] : waterBC);
                    }
                    this.scaledHexes[i] = hi;
                    this.scaledHexFail[i] = false;
                    continue;
                }
                this.scaledHexes[i] = null;
                this.scaledHexFail[i] = true;
            }
            for (i = this.scaledPorts.length - 1; i >= 0; --i) {
                this.scaledPortFail[i] = false;
            }
        }
        this.renderPortImages();
        if (this.superText1 != null && this.superTextBox_w > 0) {
            this.superTextBox_x = (newW - this.superTextBox_w) / 2;
            this.superTextBox_y = (newH - this.superTextBox_h) / 2;
        }
    }

    private BufferedImage renderBorderedHex(BufferedImage hex, Color borderColor) {
        if (borderColor == null) {
            return hex;
        }
        int w = hex.getWidth(null);
        int h = hex.getHeight(null);
        BufferedImage bHex = new BufferedImage(w, h, 2);
        Graphics2D g = bHex.createGraphics();
        g.drawImage(hex, 0, 0, w, h, null);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke((float)this.scaleToActual(13) / 10.0f));
        g.setColor(borderColor);
        if (this.isRotated) {
            g.translate(this.scaleToActual(1), 0);
        }
        g.drawPolyline(this.scaledHexCornersX, this.scaledHexCornersY, 7);
        g.dispose();
        return bHex;
    }

    private void renderPortImages() {
        int arrow_offx;
        int yc;
        int xc;
        BufferedImage water = this.scaledHexes[0];
        int w = ((Image)water).getWidth(null);
        int h = ((Image)water).getHeight(null);
        int diac = 38;
        int diab = diac + 2;
        if (this.isRotated) {
            xc = 64;
            yc = 55;
            arrow_offx = this.scaleToActual(9);
        } else {
            xc = 55;
            yc = 64;
            arrow_offx = 0;
        }
        xc = (xc - diac) / 2;
        yc = (yc - diac) / 2;
        if (this.isScaled) {
            diab = this.scaleToActual(diab);
            xc = this.scaleToActual(xc);
            yc = this.scaleToActual(yc);
            diac = this.scaleToActual(diac);
            if (diab % 2 != 0) {
                ++diab;
                ++diac;
            }
            if (diac % 2 != 0) {
                --diac;
            }
        }
        int xb = xc - (diab - diac) / 2;
        int yb = yc - (diab - diac) / 2;
        BufferedImage portBase = new BufferedImage(w, h, 2);
        Graphics2D g = portBase.createGraphics();
        g.drawImage(water, 0, 0, w, h, null);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillOval(xb, yb, diab, diab);
        g.setComposite(AlphaComposite.getInstance(1));
        g.fillOval(xc, yc, diac, diac);
        g.setComposite(AlphaComposite.getInstance(3));
        g.dispose();
        for (int i = 0; i < 6; ++i) {
            BufferedImage bufi = new BufferedImage(w, h, 2);
            Graphics2D g2 = bufi.createGraphics();
            g2.drawImage(portBase, 0, 0, w, h, null);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setColor(Color.WHITE);
            g2.translate(arrow_offx, 0);
            g2.fillPolygon(this.scaledPortArrowsX[i], this.scaledPortArrowsY[i], 3);
            int i2 = i + 1;
            if (i2 == 6) {
                i2 = 0;
            }
            g2.fillPolygon(this.scaledPortArrowsX[i2], this.scaledPortArrowsY[i2], 3);
            g2.translate(-arrow_offx, 0);
            g2.dispose();
            this.scaledPorts[i] = bufi;
        }
    }

    private void rescaleCoordinateArrays() {
        if (!this.isScaled) {
            if (!this.isRotated) {
                this.scaledVertRoadX = vertRoadX;
                this.scaledVertRoadY = vertRoadY;
                this.scaledUpRoadX = upRoadX;
                this.scaledUpRoadY = upRoadY;
                this.scaledDownRoadX = downRoadX;
                this.scaledDownRoadY = downRoadY;
                this.scaledHexCornersX = hexCornersX;
                this.scaledHexCornersY = hexCornersY;
                this.scaledPortArrowsX = portArrowsX;
                this.scaledPortArrowsY = portArrowsY;
            } else {
                this.scaledVertRoadX = this.rotateScaleCopyYToActualX(vertRoadY, 55, false);
                this.scaledVertRoadY = vertRoadX;
                this.scaledUpRoadX = this.rotateScaleCopyYToActualX(upRoadY, 55, false);
                this.scaledUpRoadY = upRoadX;
                this.scaledDownRoadX = this.rotateScaleCopyYToActualX(downRoadY, 55, false);
                this.scaledDownRoadY = downRoadX;
                this.scaledHexCornersX = hexCornersY;
                this.scaledHexCornersY = hexCornersX;
                this.scaledPortArrowsX = new int[portArrowsX.length][];
                for (int i = 0; i < portArrowsX.length; ++i) {
                    this.scaledPortArrowsX[i] = this.rotateScaleCopyYToActualX(portArrowsY[i], 55, false);
                }
                this.scaledPortArrowsY = portArrowsX;
            }
            this.scaledSettlementX = settlementX;
            this.scaledSettlementY = settlementY;
            this.scaledCityX = cityX;
            this.scaledCityY = cityY;
            this.scaledShipX = shipX;
            this.scaledShipY = shipY;
            this.scaledFortressX = fortressX;
            this.scaledFortressY = fortressY;
            this.scaledDiamondX = diamondX;
            this.scaledDiamondY = diamondY;
            this.scaledWarshipX = warshipX;
            this.scaledWarshipY = warshipY;
            this.scaledRobberX = robberX;
            this.scaledRobberY = robberY;
            this.scaledArrowXL = arrowXL;
            this.scaledArrowY = arrowY;
            if (arrowXR == null) {
                int[] axr = new int[arrowXL.length];
                for (int i = 0; i < arrowXL.length; ++i) {
                    axr[i] = 36 - arrowXL[i];
                }
                arrowXR = axr;
            }
            this.scaledArrowXR = arrowXR;
        } else {
            int L;
            int i;
            this.scaledPortArrowsX = new int[portArrowsX.length][];
            this.scaledPortArrowsY = new int[portArrowsY.length][];
            if (!this.isRotated) {
                this.scaledVertRoadX = this.scaleCopyToActual(vertRoadX);
                this.scaledVertRoadY = this.scaleCopyToActual(vertRoadY);
                this.scaledUpRoadX = this.scaleCopyToActual(upRoadX);
                this.scaledUpRoadY = this.scaleCopyToActual(upRoadY);
                this.scaledDownRoadX = this.scaleCopyToActual(downRoadX);
                this.scaledDownRoadY = this.scaleCopyToActual(downRoadY);
                this.scaledHexCornersX = this.scaleCopyToActual(hexCornersX);
                this.scaledHexCornersY = this.scaleCopyToActual(hexCornersY);
                for (i = 0; i < portArrowsX.length; ++i) {
                    this.scaledPortArrowsX[i] = this.scaleCopyToActual(portArrowsX[i]);
                    this.scaledPortArrowsY[i] = this.scaleCopyToActual(portArrowsY[i]);
                }
            } else {
                this.scaledVertRoadX = this.rotateScaleCopyYToActualX(vertRoadY, 55, true);
                this.scaledVertRoadY = this.scaleCopyToActual(vertRoadX);
                this.scaledUpRoadX = this.rotateScaleCopyYToActualX(upRoadY, 55, true);
                this.scaledUpRoadY = this.scaleCopyToActual(upRoadX);
                this.scaledDownRoadX = this.rotateScaleCopyYToActualX(downRoadY, 55, true);
                this.scaledDownRoadY = this.scaleCopyToActual(downRoadX);
                this.scaledHexCornersX = this.scaleCopyToActual(hexCornersY);
                this.scaledHexCornersY = this.scaleCopyToActual(hexCornersX);
                for (i = 0; i < portArrowsX.length; ++i) {
                    this.scaledPortArrowsX[i] = this.rotateScaleCopyYToActualX(portArrowsY[i], 55, true);
                    this.scaledPortArrowsY[i] = this.scaleCopyToActual(portArrowsX[i]);
                }
            }
            this.scaledSettlementX = this.scaleCopyToActual(settlementX);
            this.scaledSettlementY = this.scaleCopyToActual(settlementY);
            this.scaledCityX = this.scaleCopyToActual(cityX);
            this.scaledCityY = this.scaleCopyToActual(cityY);
            this.scaledShipX = this.scaleCopyToActual(shipX);
            this.scaledShipY = this.scaleCopyToActual(shipY);
            this.scaledFortressX = this.scaleCopyToActual(fortressX);
            this.scaledFortressY = this.scaleCopyToActual(fortressY);
            this.scaledDiamondX = this.scaleCopyToActual(diamondX);
            this.scaledDiamondY = this.scaleCopyToActual(diamondY);
            this.scaledWarshipX = this.scaleCopyToActual(warshipX);
            this.scaledWarshipY = this.scaleCopyToActual(warshipY);
            this.scaledRobberX = this.scaleCopyToActual(robberX);
            this.scaledRobberY = this.scaleCopyToActual(robberY);
            this.scaledArrowXL = this.scaleCopyToActual(arrowXL);
            this.scaledArrowY = this.scaleCopyToActual(arrowY);
            int p = Math.abs(this.scaledArrowXL[0] - this.scaledArrowXL[1]);
            if (p != Math.abs(this.scaledArrowY[0] - this.scaledArrowY[1])) {
                this.scaledArrowY[0] = this.scaledArrowY[1] + p;
            }
            if ((p = Math.abs(this.scaledArrowXL[L = this.scaledArrowXL.length - 1] - this.scaledArrowXL[L - 1])) != Math.abs(this.scaledArrowY[L] - this.scaledArrowY[L - 1])) {
                this.scaledArrowY[L] = this.scaledArrowY[L - 1] - p;
            }
            this.scaledArrowXR = new int[this.scaledArrowXL.length];
            int xmax = this.scaledArrowXL[4];
            for (int i2 = 0; i2 < this.scaledArrowXR.length; ++i2) {
                this.scaledArrowXR[i2] = xmax - this.scaledArrowXL[i2];
            }
        }
    }

    public int[] scaleCopyToActual(int[] orig) {
        int[] xs = new int[orig.length];
        for (int i = orig.length - 1; i >= 0; --i) {
            xs[i] = (int)((long)orig[i] * (long)this.scaledBoardW / (long)this.unscaledBoardW);
        }
        return xs;
    }

    public int[] rotateScaleCopyYToActualX(int[] yorig, int width, boolean rescale) {
        int i;
        int[] xr = new int[yorig.length];
        for (i = yorig.length - 1; i >= 0; --i) {
            xr[i] = width - yorig[i];
        }
        if (rescale) {
            for (i = yorig.length - 1; i >= 0; --i) {
                xr[i] = (int)((long)xr[i] * (long)this.scaledBoardW / (long)this.unscaledBoardW);
            }
        }
        return xr;
    }

    public final BufferedImage getScaledImageUp(Image src, int w, int h) {
        BufferedImage bufi = this.playerInterface.getGraphicsConfiguration().createCompatibleImage(w, h, 2);
        Graphics2D g = bufi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(src, 0, 0, w, h, null);
        g.dispose();
        return bufi;
    }

    void setDebugShowCoordsFlag(boolean setOn) {
        if (setOn == this.debugShowCoordsTooltip) {
            return;
        }
        this.debugShowCoordsTooltip = setOn;
    }

    void setDebugShowPotentialsFlag(int pieceType, boolean setPotential, boolean setOn) {
        if (pieceType == -1) {
            Arrays.fill(this.debugShowPotentials, setOn);
        } else {
            if (setPotential && pieceType < 4) {
                pieceType += 4;
            }
            if (setOn == this.debugShowPotentials[pieceType]) {
                return;
            }
            this.debugShowPotentials[pieceType] = setOn;
        }
        this.scaledMissedImage = true;
        this.repaint();
        if (setOn && (pieceType == 2 || pieceType == -1)) {
            int[] vs;
            int[] nArray = vs = this.board instanceof SOCBoardLarge ? ((SOCBoardLarge)this.board).getAddedLayoutPart("VS") : null;
            if (vs == null) {
                vs = new int[]{0, 0};
            }
            System.err.println("debugShowPotentials: Board size (height, width) = 0x" + Integer.toHexString(this.board.getBoardWidth()) + ",0x" + Integer.toHexString(this.board.getBoardHeight()) + ", VS (down, right) = " + vs[0] + "," + vs[1]);
            System.err.println("  Panel size (width, height): unscaled = (" + this.panelMinBW + "," + this.panelMinBH + ')' + (this.isRotated ? ", rotated" : "") + ", current = (" + this.scaledBoardW + " of " + this.scaledPanelW + "," + this.scaledPanelH + "), margin (left, top) = (" + this.panelMarginX + "," + this.panelMarginY + "), unscaled shift (right, down) = (" + this.panelShiftBX + "," + this.panelShiftBY + ')');
            int w = this.playerInterface.getWidth();
            int h = this.playerInterface.getHeight();
            Insets ins = this.playerInterface.getInsets();
            System.err.println("  PI window size (width, height) = " + w + "," + h + ", inner = " + (w - ins.left - ins.right) + "," + (h - ins.top - ins.bottom) + ", insets (left, right, top, bottom) = " + ins.left + "," + ins.right + "," + ins.top + "," + ins.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        VolatileImage ibuf = this.buffer;
        try {
            GraphicsConfiguration gconf = this.getGraphicsConfiguration();
            if (gconf == null) {
                this.repaint();
                return;
            }
            do {
                int ibufValidStatus;
                int n = ibufValidStatus = ibuf == null ? -1 : ibuf.validate(gconf);
                if (ibuf != null && ibufValidStatus != 2) continue;
                ibuf = gconf.createCompatibleVolatileImage(this.scaledPanelW, this.scaledPanelH, 1);
            } while (ibuf.contentsLost());
            this.buffer = ibuf;
            for (int tries = 1; tries <= 3; ++tries) {
                Graphics2D graf2D = ibuf.createGraphics();
                try {
                    this.drawBoard(graf2D);
                    break;
                }
                catch (ConcurrentModificationException cme) {
                    if (tries != 3) continue;
                    this.repaint();
                    continue;
                }
                finally {
                    graf2D.dispose();
                }
            }
            if (this.hoverTip.isVisible()) {
                this.hoverTip.paint(ibuf.getGraphics());
            }
            g.drawImage(ibuf, 0, 0, this);
        }
        catch (Throwable th) {
            this.playerInterface.chatPrintStackTrace(th);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private final void drawHex(Graphics g, int hexNum) {
        int portFacing;
        int hexType = this.board.getHexLayout()[hexNum];
        if (hexType < 7) {
            portFacing = -1;
        } else if (hexType < 16) {
            portFacing = hexType - 6;
            hexType = 0;
        } else {
            portFacing = hexType >> 4;
            hexType &= 0xF;
        }
        this.drawHex(g, this.hexX[hexNum], this.hexY[hexNum], hexType, portFacing, hexNum);
    }

    private final void drawHex(Graphics g, int x, int y, int hexType, int portFacing, int hexNum) {
        int h;
        int w;
        int htypeIdx;
        if (hexType < 0) {
            this.playerInterface.chatPrintDebug("* bad hex type " + hexType + " at x,y(" + x + "," + y + ")");
            return;
        }
        if (this.diceNumberCircleFont == null) {
            int fsize = 13;
            if (this.isScaled) {
                fsize = this.scaleToActual(fsize);
            }
            this.diceNumberCircleFont = new Font("Dialog", 1, fsize);
        }
        if (this.diceNumberCircleFM == null && this.diceNumberCircleFont != null) {
            this.diceNumberCircleFM = this.getFontMetrics(this.diceNumberCircleFont);
        }
        if (this.isScaledOrRotated) {
            if (this.isRotated) {
                int y1 = x;
                x = this.panelMinBH - y - 64;
                y = y1;
            }
            if (this.isScaled) {
                x = this.scaleToActual(x);
                y = this.scaleToActual(y);
            }
        }
        boolean recenterPrevMiss = false;
        int xm = 0;
        int ym = 0;
        boolean missedDraw = false;
        BufferedImage[] hexis = this.isRotated ? rotatHexes : hexes;
        int n = htypeIdx = portFacing == -1 || hexType != 0 ? hexType : hexis.length - 1;
        if (this.isScaled && this.scaledHexes[htypeIdx] == hexis[htypeIdx]) {
            recenterPrevMiss = true;
            w = hexis[htypeIdx].getWidth(null);
            h = hexis[htypeIdx].getHeight(null);
            xm = (this.scaleToActual(w) - w) / 2;
            ym = (this.scaleToActual(h) - h) / 2;
            x += xm;
            y += ym;
        }
        if (!g.drawImage(this.scaledHexes[htypeIdx], x, y, this)) {
            g.translate(x, y);
            g.setColor(this.hexColor(hexType));
            g.fillPolygon(this.scaledHexCornersX, this.scaledHexCornersY, 6);
            g.setColor(Color.BLACK);
            g.drawPolyline(this.scaledHexCornersX, this.scaledHexCornersY, 7);
            g.translate(-x, -y);
            missedDraw = true;
            if ((this.isScaled || this.isHexesAlwaysScaled) && 7000L < this.drawnEmptyAt - this.scaledAt) {
                if (this.scaledHexFail[htypeIdx]) {
                    this.scaledHexes[htypeIdx] = hexis[htypeIdx];
                } else {
                    this.scaledHexFail[htypeIdx] = true;
                    w = this.scaleToActual(this.isRotated ? 64 : 55);
                    h = this.scaleToActual(this.isRotated ? 55 : 64);
                    this.scaledHexes[htypeIdx] = this.getScaledImageUp(hexis[htypeIdx], w, h);
                }
            }
        }
        if (recenterPrevMiss) {
            x -= xm;
            y -= ym;
            recenterPrevMiss = false;
        }
        if (portFacing != -1) {
            int ptypeIdx = portFacing - 1;
            if (this.isScaled && this.scaledPorts[ptypeIdx] == hexes[htypeIdx]) {
                recenterPrevMiss = true;
                w = hexes[htypeIdx].getWidth(null);
                h = hexes[htypeIdx].getHeight(null);
                xm = (this.scaleToActual(w) - w) / 2;
                ym = (this.scaleToActual(h) - h) / 2;
                x += xm;
                y += ym;
            }
            if (!g.drawImage(this.scaledPorts[ptypeIdx], x, y, this)) {
                g.drawImage(hexes[htypeIdx], x, y, null);
                missedDraw = true;
                if ((this.isScaled || this.isHexesAlwaysScaled) && 7000L < this.drawnEmptyAt - this.scaledAt) {
                    if (this.scaledPortFail[ptypeIdx]) {
                        this.scaledPorts[ptypeIdx] = hexes[htypeIdx];
                    } else {
                        this.scaledPortFail[ptypeIdx] = true;
                        this.scaledPorts[ptypeIdx] = hexes[htypeIdx];
                    }
                }
            }
        }
        if (hexNum == -1) {
            if (missedDraw) {
                this.scaledMissedImage = true;
            }
            return;
        }
        int hnl = this.board.getNumberOnHexFromNumber(hexNum);
        if (hnl > 0) {
            if (this.diceNumberCircleFM != null && this.diceNumberCircleFont != null) {
                int dy;
                int dx;
                if (this.isRotated) {
                    dx = 22;
                    dy = 17;
                } else {
                    dx = 17;
                    dy = 22;
                }
                if (!this.isScaled) {
                    x += dx;
                    y += dy;
                } else {
                    x += this.scaleToActual(dx);
                    y += this.scaleToActual(dy);
                }
                int dia = 20;
                if (this.isScaled) {
                    dia = this.scaleToActual(dia);
                }
                int colorIdx = hnl < 7 ? hnl - 2 : 12 - hnl;
                Color cc = DICE_NUMBER_CIRCLE_COLORS[colorIdx];
                g.setColor(cc);
                g.fillOval(x, y, ++dia, dia);
                g.setColor(cc.darker().darker());
                g.drawOval(x, y, dia, dia);
                String numstr = Integer.toString(hnl);
                g.setFont(this.diceNumberCircleFont);
                g.setColor(Color.BLACK);
                g.drawString(numstr, x += (dia - (this.diceNumberCircleFM.stringWidth(numstr) - this.scaleToActual(1))) / 2, y += (dia + this.diceNumberCircleFM.getAscent() - this.diceNumberCircleFM.getDescent()) / 2);
            } else {
                missedDraw = true;
            }
        }
        if (missedDraw) {
            this.scaledMissedImage = true;
        }
    }

    private final void drawRobber(Graphics g, int hexID, boolean fullNotGhost, boolean fillNotOutline) {
        Color rOutline;
        Color rFill;
        int hy;
        int hx;
        if (this.isLargeBoard) {
            hx = 27 * (hexID & 0xFF);
            hy = 23 * (hexID >> 8) + 32;
        } else {
            int hexNum = this.hexIDtoNum[hexID];
            hx = this.hexX[hexNum] + 27;
            hy = this.hexY[hexNum] + 32;
        }
        if (this.isRotated) {
            int hy1 = hx;
            hx = this.panelMinBH - hy;
            hy = hy1;
        }
        if (this.isScaled) {
            hx = this.scaleToActual(hx);
            hy = this.scaleToActual(hy);
        }
        if (fullNotGhost && fillNotOutline) {
            rFill = Color.lightGray;
            rOutline = Color.black;
        } else {
            int hexType = this.board.getHexTypeFromCoord(hexID);
            if (hexType >= this.robberGhostFill.length || hexType < 0) {
                rFill = Color.lightGray;
                rOutline = Color.black;
            } else if (this.robberGhostFill[hexType] != null) {
                rFill = this.robberGhostFill[hexType];
                rOutline = this.robberGhostOutline[hexType];
                if (!fillNotOutline) {
                    int dnum = this.board.getNumberOnHexFromCoord(hexID);
                    if (hexType == 6 || dnum <= 3 || dnum >= 11) {
                        rFill = Color.BLACK;
                    }
                }
            } else {
                rOutline = this.hexColor(hexType);
                if (rOutline == ColorSquare.WATER) {
                    rOutline = Color.lightGray;
                }
                rFill = SOCPlayerInterface.makeGhostColor(rOutline);
                rOutline = rOutline.darker();
                this.robberGhostFill[hexType] = rFill;
                this.robberGhostOutline[hexType] = rOutline;
            }
        }
        g.translate(hx, hy);
        if (fillNotOutline) {
            g.setColor(rFill);
            g.fillPolygon(this.scaledRobberX, this.scaledRobberY, 13);
        } else {
            rOutline = rFill;
        }
        g.setColor(rOutline);
        g.drawPolygon(this.scaledRobberX, this.scaledRobberY, 14);
        g.translate(-hx, -hy);
    }

    private final void drawRoadOrShip(Graphics g, int edgeNum, int pn, HilightStyle hilightStyle, boolean isRoadNotShip, boolean isWarship) {
        int hy;
        int hx;
        int[] roadY;
        int[] roadX;
        if (edgeNum == -1) {
            edgeNum = 0;
        }
        if (!this.isLargeBoard) {
            int hexNum;
            int dy = 0;
            if (((edgeNum & 0xF) + (edgeNum >> 4)) % 2 == 0) {
                hexNum = this.hexIDtoNum[edgeNum + 17];
                roadX = this.scaledVertRoadX;
                roadY = this.scaledVertRoadY;
            } else if ((edgeNum >> 4) % 2 == 0) {
                if (edgeNum >= 129 && 0 == (edgeNum - 129) % 34) {
                    hexNum = this.hexIDtoNum[edgeNum - 16 + 2];
                    dy = 92;
                } else {
                    hexNum = this.hexIDtoNum[edgeNum + 16];
                }
                roadX = this.scaledUpRoadX;
                roadY = this.scaledUpRoadY;
            } else {
                if (edgeNum >= 24 && 0 == (edgeNum - 24) % 34) {
                    hexNum = this.hexIDtoNum[edgeNum + 32 - 1];
                    dy = -92;
                } else {
                    hexNum = this.hexIDtoNum[edgeNum + 1];
                }
                roadX = this.scaledDownRoadX;
                roadY = this.scaledDownRoadY;
            }
            hx = this.hexX[hexNum];
            hy = this.hexY[hexNum] + dy;
        } else {
            int r = edgeNum >> 8;
            int c = edgeNum & 0xFF;
            if (isWarship) {
                roadX = this.scaledWarshipX;
                roadY = this.scaledWarshipY;
            } else if (!isRoadNotShip) {
                roadX = this.scaledShipX;
                roadY = this.scaledShipY;
            } else {
                roadX = null;
                roadY = null;
            }
            if (pn <= -2 || r % 2 == 1) {
                hx = 27 * c;
                hy = 23 * r;
                if (isRoadNotShip) {
                    roadX = this.scaledVertRoadX;
                    roadY = this.scaledVertRoadY;
                }
            } else if (c % 2 != r / 2 % 2) {
                hx = 27 * c;
                hy = 23 * (r + 1);
                if (isRoadNotShip) {
                    roadX = this.scaledUpRoadX;
                    roadY = this.scaledUpRoadY;
                } else {
                    hx += 13;
                    hy -= 23;
                }
            } else {
                hx = 27 * c;
                hy = 23 * (r - 1);
                if (isRoadNotShip) {
                    roadX = this.scaledDownRoadX;
                    roadY = this.scaledDownRoadY;
                } else {
                    hx += 13;
                    hy += 23;
                }
            }
        }
        if (this.isRotated) {
            int hy1 = hx;
            hx = this.panelMinBH - hy - 54;
            hy = hy1;
        }
        if (this.isScaled) {
            hx = this.scaleToActual(hx);
            hy = this.scaleToActual(hy);
        }
        g.translate(hx, hy);
        if (hilightStyle == HilightStyle.MOST_RECENT_PLACEMENT) {
            if (g instanceof Graphics2D) {
                this.drawPieceMostRecentPlacement((Graphics2D)g, roadX, roadY);
            } else {
                hilightStyle = HilightStyle.HOVER;
            }
        }
        if (pn != -3) {
            if (pn == -1) {
                g.setColor(Color.WHITE);
            } else if (pn == -2) {
                if (hilightStyle == HilightStyle.HOVER) {
                    g.setColor(Color.LIGHT_GRAY);
                } else {
                    g.setColor(Color.BLACK);
                }
            } else if (hilightStyle == HilightStyle.HOVER) {
                g.setColor(this.playerInterface.getPlayerColor(pn, true));
            } else {
                g.setColor(this.playerInterface.getPlayerColor(pn));
            }
            g.fillPolygon(roadX, roadY, roadX.length);
        }
        if (pn != -1 || hilightStyle == null) {
            if (hilightStyle == HilightStyle.MOST_RECENT_PLACEMENT) {
                g.setColor(Color.white);
            } else if (pn == -2) {
                if (this.portHexCoords != null && this.portHexCoords.contains(edgeNum)) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.darkGray);
                }
            } else if (pn == -3) {
                g.setColor(Color.lightGray);
            } else if (hilightStyle == HilightStyle.HOVER) {
                g.setColor(this.playerInterface.getPlayerColor(pn, false));
            } else {
                g.setColor(Color.black);
            }
        }
        g.drawPolygon(roadX, roadY, roadX.length);
        g.translate(-hx, -hy);
    }

    private final void drawSettlement(Graphics g, int nodeNum, int pn, HilightStyle hilightStyle, boolean outlineOnly) {
        this.drawSettlementOrCity(g, nodeNum, pn, hilightStyle, outlineOnly, false);
    }

    private final void drawCity(Graphics g, int nodeNum, int pn, HilightStyle hilightStyle) {
        this.drawSettlementOrCity(g, nodeNum, pn, hilightStyle, false, true);
    }

    private final void drawSettlementOrCity(Graphics g, int nodeNum, int pn, HilightStyle hilightStyle, boolean outlineOnly, boolean isCity) {
        int[] nodexy = this.nodeToXY(nodeNum);
        int hx = nodexy[0];
        int hy = nodexy[1];
        g.translate(hx, hy);
        if (isCity) {
            if (hilightStyle == HilightStyle.MOST_RECENT_PLACEMENT) {
                if (g instanceof Graphics2D) {
                    this.drawPieceMostRecentPlacement((Graphics2D)g, this.scaledCityX, this.scaledCityY);
                } else {
                    hilightStyle = HilightStyle.HOVER;
                }
            } else if (hilightStyle != null) {
                g.setColor(this.playerInterface.getPlayerColor(pn, true));
                g.drawPolygon(this.scaledCityX, this.scaledCityY, 8);
                g.translate(1, 1);
                g.drawPolygon(this.scaledCityX, this.scaledCityY, 8);
                g.translate(-(hx + 1), -(hy + 1));
                return;
            }
            g.setColor(this.playerInterface.getPlayerColor(pn));
            g.fillPolygon(this.scaledCityX, this.scaledCityY, 8);
            g.setColor(hilightStyle != null ? Color.white : Color.black);
            g.drawPolygon(this.scaledCityX, this.scaledCityY, 8);
        } else {
            boolean isHilightMostRecent;
            boolean bl = isHilightMostRecent = hilightStyle == HilightStyle.MOST_RECENT_PLACEMENT;
            if (isHilightMostRecent) {
                if (g instanceof Graphics2D) {
                    this.drawPieceMostRecentPlacement((Graphics2D)g, this.scaledSettlementX, this.scaledSettlementY);
                } else {
                    hilightStyle = HilightStyle.HOVER;
                }
            }
            if (!outlineOnly) {
                if (hilightStyle == HilightStyle.HOVER) {
                    g.setColor(this.playerInterface.getPlayerColor(pn, true));
                } else {
                    g.setColor(this.playerInterface.getPlayerColor(pn));
                }
                g.fillPolygon(this.scaledSettlementX, this.scaledSettlementY, 6);
            }
            if (isHilightMostRecent) {
                g.setColor(Color.white);
            } else if (hilightStyle != null || outlineOnly) {
                g.setColor(this.playerInterface.getPlayerColor(pn, false));
            } else {
                g.setColor(Color.black);
            }
            g.drawPolygon(this.scaledSettlementX, this.scaledSettlementY, 7);
        }
        g.translate(-hx, -hy);
    }

    private void drawPieceMostRecentPlacement(Graphics2D g, int[] polyX, int[] polyY) {
        Stroke prevStroke = g.getStroke();
        g.setStroke(new BasicStroke(5 * this.scaledBoardW / this.panelMinBW, 0, 1));
        g.setColor(Color.DARK_GRAY);
        g.drawPolygon(polyX, polyY, polyX.length);
        g.setStroke(new BasicStroke(3 * this.scaledBoardW / this.panelMinBW, 0, 1));
        g.setColor(Color.BLACK);
        g.drawPolygon(polyX, polyY, polyX.length);
        g.setStroke(prevStroke);
    }

    private void drawSeaEdgeLines(Graphics g, Color co, Collection<Integer> lse) {
        Stroke prevStroke;
        if (lse == null || lse.isEmpty()) {
            return;
        }
        if (co == null && this.playerNumber == 0 && hexesGraphicsSetIndex == 0) {
            co = HEX_GRAPHICS_SET_SC_PIRI_PATH_COLORS[hexesGraphicsSetIndex];
        }
        if (g instanceof Graphics2D) {
            prevStroke = ((Graphics2D)g).getStroke();
            int hexPartWidth = this.scaleToActual(27);
            float[] dash = new float[]{(float)hexPartWidth * 0.15f, (float)hexPartWidth * 0.12f};
            ((Graphics2D)g).setStroke(new BasicStroke(3 * this.scaledBoardW / this.panelMinBW, 0, 2, 1.5f, dash, (float)hexPartWidth * 0.1f));
            if (co == null) {
                co = this.playerInterface.getPlayerColor(this.playerNumber);
            }
        } else {
            prevStroke = null;
            if (co == null) {
                co = this.playerInterface.getPlayerColor(this.playerNumber, true);
            }
        }
        g.setColor(co);
        for (Integer edge : lse) {
            this.drawSeaEdgeLine(g, edge);
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(prevStroke);
        }
    }

    private final void drawSeaEdgeLine(Graphics g, int edge) {
        int[] enodes = this.board.getAdjacentNodesToEdge_arr(edge);
        int[][] nodexy = new int[][]{this.nodeToXY(enodes[0]), this.nodeToXY(enodes[1])};
        int dx = (nodexy[1][0] - nodexy[0][0]) / 5;
        int dy = (nodexy[1][1] - nodexy[0][1]) / 5;
        g.drawLine(nodexy[0][0] + dx, nodexy[0][1] + dy, nodexy[1][0] - dx, nodexy[1][1] - dy);
    }

    private final void drawFortress(Graphics g, SOCFortress fo, int pn, boolean isHilight, boolean doTranslate) {
        int strength = fo.getStrength();
        if (strength == 0) {
            return;
        }
        if (doTranslate) {
            g.translate(this.panelMarginX, this.panelMarginY);
        }
        g.setColor(isHilight ? this.playerInterface.getPlayerColor(pn, true) : this.playerInterface.getPlayerColor(pn));
        int[] nodexy = this.nodeToXY(fo.getCoordinates());
        g.translate(nodexy[0], nodexy[1]);
        g.fillPolygon(this.scaledFortressX, this.scaledFortressY, this.scaledFortressY.length);
        if (isHilight) {
            g.setColor(this.playerInterface.getPlayerColor(pn, false));
        } else {
            g.setColor(Color.black);
        }
        g.drawPolygon(this.scaledFortressX, this.scaledFortressY, this.scaledFortressY.length);
        String numstr = Integer.toString(strength);
        int x = -this.diceNumberCircleFM.stringWidth(numstr) / 2;
        int y = (this.diceNumberCircleFM.getAscent() - this.diceNumberCircleFM.getDescent()) * 2 / 3;
        g.setFont(this.diceNumberCircleFont);
        g.drawString(numstr, x, y);
        g.translate(-nodexy[0], -nodexy[1]);
        if (doTranslate) {
            g.translate(-this.panelMarginX, -this.panelMarginY);
        }
    }

    private void drawVillage(Graphics g, SOCVillage v) {
        Color vc = v.getCloth() > 0 ? Color.YELLOW : Color.LIGHT_GRAY;
        int[] nodexy = this.nodeToXY(v.getCoordinates());
        this.drawMarker(g, nodexy[0], nodexy[1], vc, v.diceNum);
    }

    private final void drawMarker(Graphics g, int x, int y, Color color, int val) {
        g.translate(x, y);
        g.setColor(color);
        g.fillPolygon(this.scaledDiamondX, this.scaledDiamondY, 4);
        g.setColor(Color.black);
        g.drawPolygon(this.scaledDiamondX, this.scaledDiamondY, 5);
        if (val >= 0) {
            String numstr = Integer.toString(val);
            int sx = -this.diceNumberCircleFM.stringWidth(numstr) / 2;
            int sy = (this.diceNumberCircleFM.getAscent() - this.diceNumberCircleFM.getDescent()) / 2;
            g.setFont(this.diceNumberCircleFont);
            g.drawString(numstr, sx, sy);
        }
        g.translate(-x, -y);
    }

    private final void drawArrow(Graphics g, int pnum, int diceResult) {
        boolean arrowLeft;
        int aY;
        if (pnum < 0) {
            return;
        }
        if (this.game.maxPlayers > 4) {
            switch (pnum) {
                case 2: {
                    pnum = 4;
                    break;
                }
                case 3: {
                    pnum = 2;
                    break;
                }
                case 4: {
                    pnum = 3;
                }
            }
        }
        switch (pnum) {
            case 0: {
                aY = this.scaleToActual(5);
                arrowLeft = true;
                break;
            }
            case 1: {
                aY = this.scaleToActual(5);
                arrowLeft = false;
                break;
            }
            case 2: {
                aY = this.scaledPanelH - this.scaleToActual(42);
                arrowLeft = false;
                break;
            }
            default: {
                aY = this.scaledPanelH - this.scaleToActual(42);
                arrowLeft = true;
                break;
            }
            case 4: {
                aY = this.scaledPanelH / 2 - this.scaleToActual(12);
                arrowLeft = false;
                break;
            }
            case 5: {
                aY = this.scaledPanelH / 2 - this.scaleToActual(12);
                arrowLeft = true;
            }
        }
        int aX = arrowLeft ? this.scaleToActual(3) : this.scaledPanelW - this.scaleToActual(40);
        int diceX = arrowLeft ? this.scaleToActual(12) : this.scaledPanelW - this.scaleToActual(39);
        int diceY = aY + this.scaleToActual(6);
        int gameState = this.game.getGameState();
        int[] scArrowX = arrowLeft ? this.scaledArrowXL : this.scaledArrowXR;
        g.translate(aX, aY);
        if (!this.game.isSpecialBuilding() && gameState != 1000) {
            g.setColor(ARROW_COLOR);
        } else {
            g.setColor(ARROW_COLOR_PLACING);
        }
        g.fillPolygon(scArrowX, this.scaledArrowY, scArrowX.length);
        g.setColor(Color.BLACK);
        g.drawPolygon(scArrowX, this.scaledArrowY, scArrowX.length);
        g.translate(-aX, -aY);
        if (diceResult >= 2 && gameState != 15 && gameState != 100) {
            int boxSize = this.isScaled ? this.scaleToActual(24) : 24;
            int fontSize = 4 * boxSize / 5;
            boolean needHeight = false;
            if (this.arrowDiceFont == null || this.arrowDiceFont.getSize() != fontSize) {
                this.arrowDiceFont = new Font("Dialog", 1, fontSize);
                needHeight = true;
            }
            Font prevFont = g.getFont();
            g.setFont(this.arrowDiceFont);
            if (needHeight) {
                if (g instanceof Graphics2D) {
                    TextLayout tl = new TextLayout("1234567890", this.arrowDiceFont, ((Graphics2D)g).getFontRenderContext());
                    this.arrowDiceHeight = (int)tl.getBounds().getHeight();
                } else {
                    this.arrowDiceHeight = g.getFontMetrics().getAscent();
                }
            }
            FontMetrics fm = g.getFontMetrics();
            String dstr = Integer.toString(diceResult);
            int diceW = fm.stringWidth(dstr);
            g.drawString(dstr, diceX + (boxSize - diceW) / 2, (diceY += boxSize) - (boxSize - this.arrowDiceHeight) / 2);
            g.setFont(prevFont);
        }
    }

    private final void drawPortsRing(Graphics g) {
        int hy;
        int hx;
        int hnum;
        for (int r = 0; r <= 6; ++r) {
            hnum = ROW_START_HEXNUM[r];
            hx = this.hexX[hnum] - 54;
            hy = this.hexY[hnum];
            this.drawHex(g, hx, hy, 0, -1, -1);
            if (--hnum < 0) {
                hnum = this.hexX.length - 1;
            }
            hx = this.hexX[hnum];
            hy = this.hexY[hnum];
            this.drawHex(g, hx, hy, 0, -1, -1);
        }
        hx = this.hexX[0] - 27;
        hy = this.hexY[0] - 46;
        int hy2 = this.hexY[33] + 46;
        int c = 0;
        int nodeCoord = 7;
        while (c < 4) {
            int ptype = this.board.getPortTypeFromNodeCoord(nodeCoord);
            if (ptype == -1) {
                this.drawHex(g, hx, hy, 0, -1, -1);
            }
            if ((ptype = this.board.getPortTypeFromNodeCoord(nodeCoord >> 4 | (nodeCoord & 0xF) << 4)) == -1) {
                this.drawHex(g, hx, hy2, 0, -1, -1);
            }
            ++c;
            nodeCoord += 34;
            hx += 54;
        }
        int[] portsLayout = this.board.getPortsLayout();
        if (portsLayout == null) {
            return;
        }
        int[] portsFacing = this.board.getPortsFacing();
        int[] portsEdges = this.board.getPortsEdges();
        for (int i = this.board.getPortsCount() - 1; i >= 0; --i) {
            int landFacing = portsFacing[i];
            int landHexCoord = this.board.getAdjacentHexToEdge(portsEdges[i], landFacing);
            hnum = this.board.getHexNumFromCoord(landHexCoord);
            hx = this.hexX[hnum] - DELTAX_FACING[landFacing];
            hy = this.hexY[hnum] - DELTAY_FACING[landFacing];
            this.drawHex(g, hx, hy, portsLayout[i], landFacing, -1);
        }
    }

    private final void drawPorts_LargeBoard(Graphics g) {
        int[] portsLayout = this.board.getPortsLayout();
        if (portsLayout == null) {
            return;
        }
        if (this.portHexCoords == null) {
            this.portHexCoords = new HashSet<Integer>();
        } else {
            this.portHexCoords.clear();
        }
        int[] portsFacing = this.board.getPortsFacing();
        int[] portsEdges = this.board.getPortsEdges();
        for (int i = this.board.getPortsCount() - 1; i >= 0; --i) {
            int seaHex;
            int edge = portsEdges[i];
            if (edge < 0) continue;
            int landFacing = portsFacing[i];
            int landHexCoord = this.board.getAdjacentHexToEdge(edge, landFacing);
            int px = 27 * ((landHexCoord & 0xFF) - 1);
            int py = 23 * (landHexCoord >> 8);
            this.drawHex(g, px -= DELTAX_FACING[landFacing], py -= DELTAY_FACING[landFacing], portsLayout[i], landFacing, -1);
            int seaFacing = 3 + landFacing;
            if (seaFacing > 6) {
                seaFacing -= 6;
            }
            if ((seaHex = this.board.getAdjacentHexToEdge(edge, seaFacing)) <= 0) continue;
            this.portHexCoords.add(seaHex);
        }
    }

    private void drawBoard(Graphics g) {
        int pn;
        boolean xlat;
        GraphicsConfiguration gconf = this.playerInterface.getGraphicsConfiguration();
        VolatileImage ebb = this.emptyBoardBuffer;
        do {
            int ebbValidStatus;
            int n = ebbValidStatus = ebb == null ? -1 : ebb.validate(gconf);
            if (!this.scaledMissedImage && ebb != null && ebbValidStatus == 0) continue;
            if (ebb == null || ebbValidStatus == 2) {
                this.emptyBoardBuffer = ebb = gconf.createCompatibleVolatileImage(this.scaledPanelW, this.scaledPanelH, 1);
            }
            this.drawnEmptyAt = System.currentTimeMillis();
            this.scaledMissedImage = false;
            Graphics2D ebbG = ebb.createGraphics();
            this.drawBoardEmpty(ebbG);
            ebbG.dispose();
            if (!this.scaledMissedImage || this.scaledAt == 0L || 7000L >= this.drawnEmptyAt - this.scaledAt) continue;
            this.scaledMissedImage = false;
        } while (ebb.contentsLost());
        g.setPaintMode();
        g.drawImage(ebb, 0, 0, this);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        boolean bl = xlat = this.panelMarginX != 0 || this.panelMarginY != 0;
        if (xlat) {
            g.translate(this.panelMarginX, this.panelMarginY);
        }
        int gameState = this.game.getGameState();
        SOCPlayingPiece lpp = this.latestPiecePlacement;
        if (lpp != null) {
            pn = lpp.getPlayerNumber();
            int co = lpp.getCoordinates();
            switch (lpp.getType()) {
                case 0: {
                    this.drawRoadOrShip(g, co, pn, HilightStyle.MOST_RECENT_PLACEMENT, true, false);
                    break;
                }
                case 3: {
                    if (this.game.isGameOptionSet("_SC_PIRI")) break;
                    this.drawRoadOrShip(g, co, pn, HilightStyle.MOST_RECENT_PLACEMENT, false, false);
                    break;
                }
                case 1: {
                    this.drawSettlement(g, co, pn, HilightStyle.MOST_RECENT_PLACEMENT, false);
                    break;
                }
                case 2: {
                    this.drawCity(g, co, pn, HilightStyle.MOST_RECENT_PLACEMENT);
                    break;
                }
            }
        }
        if (this.board.getRobberHex() != -1) {
            this.drawRobber(g, this.board.getRobberHex(), gameState != 33, true);
        }
        if (this.board.getPreviousRobberHex() != -1) {
            this.drawRobber(g, this.board.getPreviousRobberHex(), gameState != 33, false);
        }
        if (this.isLargeBoard) {
            int hex = ((SOCBoardLarge)this.board).getPirateHex();
            if (hex > 0) {
                this.drawRoadOrShip(g, hex, -2, gameState == 34 ? HilightStyle.HOVER : null, false, false);
            }
            if ((hex = ((SOCBoardLarge)this.board).getPreviousPirateHex()) > 0) {
                this.drawRoadOrShip(g, hex, -3, gameState == 34 ? HilightStyle.HOVER : null, false, false);
            }
        }
        if (!this.game.isGameOptionSet("_SC_PIRI")) {
            for (SOCRoutePiece rs : this.board.getRoadsAndShips()) {
                if (rs == lpp) continue;
                this.drawRoadOrShip(g, rs.getCoordinates(), rs.getPlayerNumber(), null, !(rs instanceof SOCShip), false);
            }
        } else {
            for (pn = 0; pn < this.game.maxPlayers; ++pn) {
                SOCPlayer pl = this.game.getPlayer(pn);
                int numWarships = pl.getNumWarships();
                for (SOCRoutePiece rs : pl.getRoadsAndShips()) {
                    boolean isShip = rs instanceof SOCShip;
                    if (!isShip && rs == lpp) continue;
                    boolean isWarship = isShip && numWarships > 0;
                    this.drawRoadOrShip(g, rs.getCoordinates(), pn, rs == lpp ? HilightStyle.MOST_RECENT_PLACEMENT : null, !isShip, isWarship);
                    if (!isWarship) continue;
                    --numWarships;
                }
                SOCFortress fo = pl.getFortress();
                if (fo == null) continue;
                this.drawFortress(g, fo, pn, false, false);
            }
        }
        for (SOCSettlement s : this.board.getSettlements()) {
            if (s == lpp) continue;
            this.drawSettlement(g, s.getCoordinates(), s.getPlayerNumber(), null, false);
        }
        for (SOCCity c : this.board.getCities()) {
            if (c == lpp) continue;
            this.drawCity(g, c.getCoordinates(), c.getPlayerNumber(), null);
        }
        if (xlat) {
            g.translate(-this.panelMarginX, -this.panelMarginY);
        }
        if (gameState != 0) {
            SOCPlayer wp;
            int cpn = this.game.getCurrentPlayerNumber();
            if (cpn < 0 && gameState >= 1000 && (wp = this.game.getPlayerWithWin()) != null) {
                cpn = wp.getPlayerNumber();
            }
            this.drawArrow(g, cpn, this.game.getCurrentDice());
        }
        if (this.player != null) {
            if (xlat) {
                g.translate(this.panelMarginX, this.panelMarginY);
            }
            switch (this.mode) {
                case 17: {
                    if (this.moveShip_fromEdge != 0) {
                        this.drawRoadOrShip(g, this.moveShip_fromEdge, -1, null, false, this.moveShip_isWarship);
                    }
                }
                case 1: 
                case 6: 
                case 16: {
                    if (this.hilight == 0) break;
                    this.drawRoadOrShip(g, this.hilight, this.playerNumber, HilightStyle.HOVER, !this.hilightIsShip, this.moveShip_isWarship && this.moveShip_fromEdge != 0);
                    break;
                }
                case 2: 
                case 5: {
                    if (this.hilight <= 0) break;
                    this.drawSettlement(g, this.hilight, this.playerNumber, HilightStyle.HOVER, false);
                    break;
                }
                case 3: {
                    if (this.hilight <= 0) break;
                    this.drawCity(g, this.hilight, this.playerNumber, HilightStyle.HOVER);
                    break;
                }
                case 15: {
                    if (this.hilight <= 0) break;
                    this.drawRoadOrShip(g, this.hilight, this.playerNumber, HilightStyle.HOVER, false, false);
                    break;
                }
                case 7: 
                case 10: {
                    if (this.hilight <= 0) break;
                    this.drawSettlement(g, this.hilight, this.otherPlayer.getPlayerNumber(), HilightStyle.HOVER, false);
                    break;
                }
                case 8: 
                case 11: {
                    if (this.hilight == 0) break;
                    this.drawRoadOrShip(g, this.hilight, this.otherPlayer.getPlayerNumber(), null, true, false);
                    break;
                }
                case 13: 
                case 14: {
                    if (this.hilight == 0) break;
                    this.drawRoadOrShip(g, this.hilight, this.otherPlayer.getPlayerNumber(), null, false, false);
                    break;
                }
                case 9: 
                case 12: {
                    if (this.hilight <= 0) break;
                    this.drawCity(g, this.hilight, this.otherPlayer.getPlayerNumber(), HilightStyle.HOVER);
                    break;
                }
                case 4: {
                    if (this.hilight <= 0) break;
                    this.drawRobber(g, this.hilight, true, true);
                    break;
                }
                case 18: {
                    if (this.hilight <= 0) break;
                    this.drawRoadOrShip(g, this.hilight, -2, null, false, false);
                    break;
                }
                case 19: {
                    this.drawBoard_SC_FTRI_placePort(g);
                }
            }
            if (xlat) {
                g.translate(-this.panelMarginX, -this.panelMarginY);
            }
        }
        if (this.superText1 != null) {
            this.drawSuperText(g);
        }
        if (this.superTextTop != null) {
            this.drawSuperTextTop(g);
        }
    }

    private final void drawBoard_SC_FTRI_placePort(Graphics g) {
        Stroke prevStroke;
        SOCInventoryItem portItem;
        this.drawSeaEdgeLines(g, Color.WHITE, this.player.getPortMovePotentialLocations(true));
        if (this.hilight == 0) {
            return;
        }
        int edge = this.hilight;
        if (edge == -1) {
            edge = 0;
        }
        if ((portItem = this.game.getPlacingItem()) != null) {
            Composite prevComposite;
            int landFacing = ((SOCBoardLarge)this.board).getPortFacingFromEdge(edge);
            int landHexCoord = this.board.getAdjacentHexToEdge(edge, landFacing);
            int px = 27 * ((landHexCoord & 0xFF) - 1);
            int py = 23 * (landHexCoord >> 8);
            px -= DELTAX_FACING[landFacing];
            py -= DELTAY_FACING[landFacing];
            if (g instanceof Graphics2D) {
                prevComposite = ((Graphics2D)g).getComposite();
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.6f));
            } else {
                prevComposite = null;
            }
            this.drawHex(g, px, py, -portItem.itype, landFacing, -1);
            if (prevComposite != null) {
                ((Graphics2D)g).setComposite(prevComposite);
            }
        }
        if (g instanceof Graphics2D) {
            prevStroke = ((Graphics2D)g).getStroke();
            ((Graphics2D)g).setStroke(new BasicStroke(2.5f));
        } else {
            prevStroke = null;
        }
        g.setColor(Color.WHITE);
        this.drawSeaEdgeLine(g, edge);
        if (prevStroke != null) {
            ((Graphics2D)g).setStroke(prevStroke);
        }
    }

    private void drawBoardEmpty(Graphics g) {
        boolean xlat;
        int SC_6;
        HashSet<Integer> landHexShow;
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.debugShowPotentials[8] && this.isLargeBoard) {
            landHexShow = ((SOCBoardLarge)this.board).getLandHexCoordsSet();
            SC_6 = this.scaleToActual(6);
        } else {
            landHexShow = null;
            SC_6 = 0;
        }
        g.setPaintMode();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.scaledPanelW, this.scaledPanelH);
        if (this.scaledPorts[0] == null) {
            this.renderPortImages();
        }
        boolean bl = xlat = this.panelMarginX != 0 || this.panelMarginY != 0;
        if (xlat) {
            g.translate(this.panelMarginX, this.panelMarginY);
        }
        if (!this.isLargeBoard) {
            boolean isRowOffset;
            int hyMax;
            int hyMin;
            int nTopRows;
            int hxMax;
            int hxMin;
            if (this.isRotated) {
                hxMin = this.panelMarginY <= 0 ? 0 : 54 * (int)Math.floor((float)(-this.scaleFromActual(this.panelMarginY)) / 54.0f);
                hxMax = this.scaleFromActual(this.getHeight());
                nTopRows = this.scaledBoardW == this.scaledPanelW ? 1 : 1 + this.scaleFromActual(this.scaledPanelW + 16 - this.scaledBoardW) / 46;
                hyMin = -46 * nTopRows;
                hyMax = this.panelMinBH + (this.panelMarginX <= 0 ? 0 : this.scaleFromActual(this.panelMarginX));
                isRowOffset = 1 == nTopRows % 2;
            } else {
                hxMin = this.panelMarginX <= 0 ? 0 : 54 * (int)Math.floor((float)(-this.scaleFromActual(this.panelMarginX)) / 54.0f);
                hxMax = this.scaledBoardW == this.scaledPanelW ? this.panelMinBW : this.scaleFromActual(this.scaledPanelW - this.panelMarginX);
                nTopRows = this.panelMarginY <= 0 ? 1 : 1 + (int)Math.ceil((float)this.panelMarginY / 46.0f);
                hyMin = -46 * nTopRows;
                hyMax = this.scaleFromActual(this.scaledPanelH);
                isRowOffset = 0 == nTopRows % 2;
            }
            for (int hy = hyMin; hy < hyMax; hy += 46) {
                int hx = hxMin;
                if (isRowOffset) {
                    hx -= 27;
                }
                while (hx < hxMax) {
                    if (hx < 0 || hx >= this.panelMinBW || hy >= this.panelMinBH || 0 == this.findHex(hx, hy)) {
                        this.drawHex(g, hx, hy, 0, -1, -1);
                    }
                    hx += 54;
                }
                isRowOffset = !isRowOffset;
            }
            if (this.is6player) {
                this.drawPortsRing(g);
            }
            for (int i = 0; i < this.hexX.length; ++i) {
                if (this.inactiveHexNums != null && this.inactiveHexNums[i]) continue;
                this.drawHex(g, i);
            }
        } else {
            HashMap<Integer, SOCVillage> villages;
            HashSet<Integer> lse;
            int[] ls;
            int unscaledPanelW = this.scaleFromActual(this.scaledPanelW);
            int bMarginX = this.scaleFromActual(this.panelMarginX);
            int bMarginYAndHex = this.scaleFromActual(this.panelMarginY) + 64;
            int marginXNumHex = (bMarginX + 54 - 1) / 54;
            int y = -23;
            int xOffsetFlag = 0;
            while (-y <= bMarginYAndHex) {
                for (int x = -(54 * marginXNumHex) - 27 * xOffsetFlag; x < unscaledPanelW; x += 54) {
                    this.drawHex(g, x, y, 0, -1, -1);
                }
                y -= 46;
                xOffsetFlag = 1 - xOffsetFlag;
            }
            int bw = this.board.getBoardWidth();
            int bh = this.board.getBoardHeight();
            int r = 1;
            for (int y2 = 23; r < bh || y2 < this.scaledPanelH + 16; r += 2, y2 += 46) {
                int x;
                int c;
                int rshift = r << 8;
                if (r / 2 % 2 == 1) {
                    c = 1;
                    x = 0;
                } else {
                    c = 2;
                    x = 27;
                }
                if (this.panelMarginX != 0 || x != 0) {
                    for (int xleft = x; xleft > -(this.panelMarginX + 54); xleft -= 54) {
                        this.drawHex(g, xleft, y2, 0, -1, -1);
                    }
                }
                while (c < bw) {
                    int hexCoord = rshift | c;
                    int hexType = r < bh ? this.board.getHexTypeFromCoord(hexCoord) : 0;
                    this.drawHex(g, x, y2, hexType, -1, hexCoord);
                    if (landHexShow != null && landHexShow.contains(hexCoord)) {
                        g.setColor(Color.RED);
                        g.drawRoundRect(this.scaleToActual(x + 13), this.scaleToActual(y2 + 19 + 1), this.scaleToActual(27), this.scaleToActual(24), SC_6, SC_6);
                    }
                    c += 2;
                    x += 54;
                }
                int xmax = unscaledPanelW - 1;
                if (this.panelMarginX < 0) {
                    xmax -= this.panelMarginX;
                }
                while (x < xmax) {
                    int hexCoord = rshift | c;
                    this.drawHex(g, x, y2, 0, -1, hexCoord);
                    c += 2;
                    x += 54;
                }
            }
            this.drawPorts_LargeBoard(g);
            int[] ppath = ((SOCBoardLarge)this.board).getAddedLayoutPart("PP");
            if (ppath != null && 0 != ((SOCBoardLarge)this.board).getPirateHex()) {
                this.drawBoardEmpty_drawPiratePath(g, ppath);
            }
            if ((ls = ((SOCBoardLarge)this.board).getAddedLayoutPart("LS")) != null) {
                for (int pn = 0; pn < ls.length; ++pn) {
                    if (ls[pn] == 0) continue;
                    this.drawSettlement(g, ls[pn], pn, null, true);
                }
            }
            HashSet<Integer> hashSet = lse = this.player != null ? this.player.getRestrictedLegalShips() : null;
            if (lse != null) {
                this.drawSeaEdgeLines(g, null, lse);
            }
            if (((SOCBoardLarge)this.board).hasSpecialEdges()) {
                this.drawBoardEmpty_specialEdges(g);
            }
            if ((villages = ((SOCBoardLarge)this.board).getVillages()) != null) {
                Iterator<SOCVillage> villIter = villages.values().iterator();
                while (villIter.hasNext()) {
                    this.drawVillage(g, villIter.next());
                }
            }
            if (this.game.isGameOptionSet("_SC_WOND")) {
                this.drawBoardEmpty_specialNodes(g, "N1", new Color(180, 90, 40));
                this.drawBoardEmpty_specialNodes(g, "N2", new Color(120, 40, 120));
                this.drawBoardEmpty_specialNodes(g, "N3", Color.RED);
            }
            this.drawBoardEmpty_drawDebugShowPotentials(g);
        }
        if (xlat) {
            g.translate(-this.panelMarginX, -this.panelMarginY);
        }
        if (this.scaledMissedImage) {
            this.scaledAt = System.currentTimeMillis();
            this.repaint();
            new DelayedRepaint(this).start();
        }
    }

    private final void drawBoardEmpty_drawPiratePath(Graphics g, int[] ppath) {
        Stroke prevStroke;
        int hc = ppath[ppath.length - 1];
        int r = hc >> 8;
        int c = hc & 0xFF;
        int yprev = this.scaleToActual(r * 23 + 32);
        int xprev = this.scaleToActual(c * 27);
        if (g instanceof Graphics2D) {
            prevStroke = ((Graphics2D)g).getStroke();
            int hexPartWidth = this.scaleToActual(27);
            float[] dash = new float[]{(float)hexPartWidth * 0.2f, (float)hexPartWidth * 0.3f};
            ((Graphics2D)g).setStroke(new BasicStroke(2.5f, 0, 0, 2.5f, dash, 0.8f));
        } else {
            prevStroke = null;
        }
        g.setColor(HEX_GRAPHICS_SET_SC_PIRI_PATH_COLORS[hexesGraphicsSetIndex]);
        for (int i = 0; i < ppath.length; ++i) {
            hc = ppath[i];
            r = hc >> 8;
            c = hc & 0xFF;
            int y = this.scaleToActual(r * 23 + 32);
            int x = this.scaleToActual(c * 27);
            g.drawLine(xprev, yprev, x, y);
            xprev = x;
            yprev = y;
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(prevStroke);
        }
    }

    private final void drawBoardEmpty_specialEdges(Graphics g) {
        Iterator<Map.Entry<Integer, Integer>> seIter = ((SOCBoardLarge)this.board).getSpecialEdges();
        while (seIter.hasNext()) {
            Color mc;
            Map.Entry<Integer, Integer> entry = seIter.next();
            switch (entry.getValue()) {
                case 1: {
                    mc = Color.YELLOW;
                    break;
                }
                case 2: {
                    mc = Color.GREEN;
                    break;
                }
                default: {
                    mc = Color.LIGHT_GRAY;
                }
            }
            int edge = entry.getKey();
            int x = edge & 0xFF;
            int y = edge >> 8;
            boolean edgeNotVertical = y % 2 == 0;
            x *= 27;
            y = y * 23 + 32;
            if (edgeNotVertical) {
                x += 13;
            }
            x = this.scaleToActual(x);
            y = this.scaleToActual(y);
            this.drawMarker(g, x, y, mc, -1);
        }
    }

    private final void drawBoardEmpty_specialNodes(Graphics g, String partKey, Color color) {
        int[] nodes = ((SOCBoardLarge)this.board).getAddedLayoutPart(partKey);
        if (nodes == null) {
            return;
        }
        for (int node : nodes) {
            int[] nodexy = this.nodeToXY(node);
            this.drawMarker(g, nodexy[0], nodexy[1], color, -1);
        }
    }

    private void drawBoardEmpty_drawDebugShowPotentials(Graphics g) throws IllegalStateException {
        int x;
        int rshift;
        if (!this.isLargeBoard) {
            throw new IllegalStateException("not supported yet");
        }
        SOCPlayer pl = this.player != null ? this.player : this.game.getPlayer(0);
        int bw = this.board.getBoardWidth();
        if (this.debugShowPotentials[2]) {
            int bh = this.board.getBoardHeight();
            int w = this.scaleToActual(27 * bw);
            int h = this.scaleToActual(23 * bh + 16);
            int y = this.scaleToActual(23);
            g.setColor(Color.YELLOW);
            g.drawRect(0, y, w, h);
            g.drawRect(1, y + 1, w - 2, h - 2);
        }
        int SC_3 = this.scaleToActual(3);
        int SC_10 = this.scaleToActual(10);
        int SC_12 = this.scaleToActual(12);
        int SC_14 = this.scaleToActual(14);
        int SC_18 = this.scaleToActual(18);
        int r = 0;
        int y = 31;
        while (r <= this.board.getBoardHeight()) {
            rshift = r << 8;
            int c = 0;
            x = 0;
            while (c <= bw) {
                int nodeCoord = rshift | c;
                if (this.debugShowPotentials[1] && pl.isLegalSettlement(nodeCoord)) {
                    g.setColor(Color.YELLOW);
                    g.drawRect(this.scaleToActual(x - 6), this.scaleToActual(y - 6), SC_12, SC_12);
                }
                if (this.debugShowPotentials[5] && pl.isPotentialSettlement(nodeCoord)) {
                    g.setColor(Color.GREEN);
                    g.drawRect(this.scaleToActual(x - 7), this.scaleToActual(y - 7), SC_14, SC_14);
                }
                if (this.debugShowPotentials[6] && pl.isPotentialCity(nodeCoord)) {
                    g.setColor(Color.GREEN);
                    g.drawRect(this.scaleToActual(x - 9), this.scaleToActual(y - 9), SC_18, SC_18);
                }
                if (this.debugShowPotentials[9] && this.board.isNodeOnLand(nodeCoord)) {
                    g.setColor(Color.RED);
                    g.drawRoundRect(this.scaleToActual(x - 5), this.scaleToActual(y - 5), SC_10, SC_10, SC_3, SC_3);
                }
                ++c;
                x += 27;
            }
            ++r;
            y += 23;
        }
        r = 0;
        y = 31;
        while (r <= this.board.getBoardHeight()) {
            rshift = r << 8;
            boolean edgeIsVert = r % 2 == 1;
            x = edgeIsVert ? 0 : 13;
            int c = 0;
            while (c <= bw) {
                int edgeCoord = rshift | c;
                if (this.debugShowPotentials[3] && pl.isLegalShip(edgeCoord)) {
                    g.setColor(Color.YELLOW);
                    g.drawLine(this.scaleToActual(x - 4), this.scaleToActual(y), this.scaleToActual(x), this.scaleToActual(y - 4));
                    g.drawLine(this.scaleToActual(x), this.scaleToActual(y - 4), this.scaleToActual(x + 4), this.scaleToActual(y));
                    g.drawLine(this.scaleToActual(x + 4), this.scaleToActual(y), this.scaleToActual(x), this.scaleToActual(y + 4));
                    g.drawLine(this.scaleToActual(x), this.scaleToActual(y + 4), this.scaleToActual(x - 4), this.scaleToActual(y));
                }
                if (this.debugShowPotentials[7] && pl.isPotentialShip(edgeCoord)) {
                    g.setColor(Color.GREEN);
                    g.drawLine(this.scaleToActual(x - 6), this.scaleToActual(y), this.scaleToActual(x), this.scaleToActual(y - 6));
                    g.drawLine(this.scaleToActual(x), this.scaleToActual(y - 6), this.scaleToActual(x + 6), this.scaleToActual(y));
                    g.drawLine(this.scaleToActual(x + 6), this.scaleToActual(y), this.scaleToActual(x), this.scaleToActual(y + 6));
                    g.drawLine(this.scaleToActual(x), this.scaleToActual(y + 6), this.scaleToActual(x - 6), this.scaleToActual(y));
                }
                if (this.debugShowPotentials[0] && pl.isLegalRoad(edgeCoord)) {
                    this.drawBoardEmpty_drawDebugShowPotentialRoad(g, x, y, r, c, edgeIsVert, Color.YELLOW, 4);
                }
                if (this.debugShowPotentials[4] && pl.isPotentialRoad(edgeCoord)) {
                    this.drawBoardEmpty_drawDebugShowPotentialRoad(g, x, y, r, c, edgeIsVert, Color.GREEN, 6);
                }
                ++c;
                x += 27;
            }
            ++r;
            y += 23;
        }
    }

    private final void drawBoardEmpty_drawDebugShowPotentialRoad(Graphics g, int x, int y, int r, int c, boolean isVert, Color co, int offset) {
        g.setColor(co);
        if (isVert) {
            g.drawLine(this.scaleToActual(x - offset), this.scaleToActual(y - 10), this.scaleToActual(x - offset), this.scaleToActual(y + 10));
            g.drawLine(this.scaleToActual(x + offset), this.scaleToActual(y - 10), this.scaleToActual(x + offset), this.scaleToActual(y + 10));
            return;
        }
        int off2 = offset / 2;
        if (c % 2 != r / 2 % 2) {
            g.drawLine(this.scaleToActual(x - 10 - off2), this.scaleToActual(y + 6 - offset), this.scaleToActual(x + 10 - off2), this.scaleToActual(y - 6 - offset));
            g.drawLine(this.scaleToActual(x - 10 + off2), this.scaleToActual(y + 6 + offset), this.scaleToActual(x + 10 + off2), this.scaleToActual(y - 6 + offset));
        } else {
            g.drawLine(this.scaleToActual(x + 10 + off2), this.scaleToActual(y + 6 - offset), this.scaleToActual(x - 10 + off2), this.scaleToActual(y - 6 - offset));
            g.drawLine(this.scaleToActual(x + 10 - off2), this.scaleToActual(y + 6 + offset), this.scaleToActual(x - 10 - off2), this.scaleToActual(y - 6 + offset));
        }
    }

    private void drawSuperText(Graphics g) {
        Font bpf = new Font("Dialog", 0, 10 * this.playerInterface.displayScale);
        if (this.superText1_w == 0 || this.superText2 != null && this.superText2_w == 0) {
            FontMetrics fm = g.getFontMetrics(bpf);
            if (fm == null) {
                this.repaint();
                return;
            }
            if (this.superText1_w == 0) {
                if (this.superText1 == null) {
                    return;
                }
                this.superText1_w = fm.stringWidth(this.superText1);
                this.superText_h = fm.getHeight();
                this.superText_des = fm.getDescent();
            }
            if (this.superText2 != null && this.superText2_w == 0) {
                this.superText2_w = fm.stringWidth(this.superText2);
            }
            this.superTextBox_w = this.superText2_w > this.superText1_w ? this.superText2_w : this.superText1_w;
            this.superTextBox_h = this.superText2 != null ? 2 * this.superText_h : this.superText_h;
            this.superTextBox_w += 22;
            this.superTextBox_h += 3 + 2 * fm.getDescent();
            this.superTextBox_x = (this.scaledPanelW - this.superTextBox_w) / 2;
            this.superTextBox_y = (this.scaledPanelH - this.superTextBox_h) / 2;
        }
        g.setColor(Color.black);
        g.fillRoundRect(this.superTextBox_x, this.superTextBox_y, this.superTextBox_w, this.superTextBox_h, 3, 3);
        g.setColor(Color.white);
        g.fillRoundRect(this.superTextBox_x + 3, this.superTextBox_y + 3, this.superTextBox_w - 6, this.superTextBox_h - 6, 3, 3);
        g.setColor(Color.black);
        int tx = (this.scaledPanelW - this.superText1_w) / 2;
        int ty = this.superTextBox_y + 3 + this.superText_h - this.superText_des;
        if (this.superText1 == null) {
            return;
        }
        Font prev = g.getFont();
        g.setFont(bpf);
        g.drawString(this.superText1, tx, ty);
        if (this.superText2 != null) {
            g.drawString(this.superText2, tx -= (this.superText2_w - this.superText1_w) / 2, ty += this.superText_h);
        }
        g.setFont(prev);
    }

    private void drawSuperTextTop(Graphics g) {
        Font bpf = new Font("Dialog", 0, 10 * this.playerInterface.displayScale);
        if (this.superTextTop_w == 0) {
            FontMetrics fm = g.getFontMetrics(bpf);
            if (fm == null) {
                this.repaint();
                return;
            }
            if (this.superTextTop_w == 0) {
                if (this.superTextTop == null) {
                    return;
                }
                this.superTextTop_w = fm.stringWidth(this.superTextTop);
                this.superTextTop_h = fm.getHeight() - fm.getDescent();
            }
            this.superTextTopBox_w = this.superTextTop_w;
            this.superTextTopBox_h = this.superTextTop_h;
            this.superTextTopBox_w += 22;
            this.superTextTopBox_h += 3 + 2 * fm.getDescent();
        }
        this.superTextTopBox_x = (this.scaledPanelW - this.superTextTopBox_w) / 2;
        g.setColor(Color.black);
        g.fillRoundRect(this.superTextTopBox_x, 3, this.superTextTopBox_w, this.superTextTopBox_h, 3, 3);
        g.setColor(Color.white);
        g.fillRoundRect(this.superTextTopBox_x + 3, 6, this.superTextTopBox_w - 6, this.superTextTopBox_h - 6, 3, 3);
        g.setColor(Color.black);
        int tx = (this.scaledPanelW - this.superTextTop_w) / 2;
        int ty = 6 + this.superTextTop_h;
        g.setFont(bpf);
        if (this.superTextTop == null) {
            return;
        }
        g.drawString(this.superTextTop, tx, ty);
    }

    private final int[] nodeToXY(int nodeNum) {
        int hy;
        int hx;
        if (!this.isLargeBoard) {
            int hexNum;
            if ((nodeNum >> 4) % 2 == 0) {
                if (nodeNum >= 129 && 0 == (nodeNum - 129) % 34) {
                    hexNum = this.hexIDtoNum[nodeNum - 32 + 2 + 16];
                    hx = this.hexX[hexNum];
                    hy = this.hexY[hexNum] + 17 + 92;
                } else {
                    hexNum = this.hexIDtoNum[nodeNum + 16];
                    hx = this.hexX[hexNum];
                    hy = this.hexY[hexNum] + 17;
                }
            } else if (nodeNum >= 112 && 0 == (nodeNum - 112) % 34) {
                hexNum = this.hexIDtoNum[nodeNum - 32 + 2 - 1];
                hx = this.hexX[hexNum] + 27;
                hy = this.hexY[hexNum] + 2 + 92;
            } else if ((nodeNum & 0xF) > 0) {
                hexNum = this.hexIDtoNum[nodeNum - 1];
                hx = this.hexX[hexNum] + 27;
                hy = this.hexY[hexNum] + 2;
            } else {
                hexNum = this.hexIDtoNum[nodeNum + 34 - 1];
                hx = this.hexX[hexNum] - 27;
                hy = this.hexY[hexNum] + 2;
            }
        } else {
            int r = nodeNum >> 8;
            int c = nodeNum & 0xFF;
            hx = 27 * c;
            hy = 23 * (r + 1);
            int s = r / 2;
            if (s % 2 != c % 2) {
                hy += 16;
            }
        }
        if (this.isRotated) {
            int hy1 = hx;
            hx = this.panelMinBH - hy;
            hy = hy1;
        }
        if (this.isScaled) {
            hx = this.scaleToActual(hx);
            hy = this.scaleToActual(hy);
        }
        int[] xy = new int[]{hx, hy};
        return xy;
    }

    public void scaleToActual(int[] xa) {
        if (!this.isScaled) {
            return;
        }
        for (int i = xa.length - 1; i >= 0; --i) {
            xa[i] = (int)((long)xa[i] * (long)this.scaledBoardW / (long)this.unscaledBoardW);
        }
    }

    public final int scaleToActual(int x) {
        if (!this.isScaled) {
            return x;
        }
        return (int)((long)x * (long)this.scaledBoardW / (long)this.unscaledBoardW);
    }

    public final int scaleFromActual(int x) {
        if (!this.isScaled) {
            return x;
        }
        return (int)((long)x * (long)this.unscaledBoardW / (long)this.scaledBoardW);
    }

    public final int[] rotateScaleXYFromActual(int x, int y) {
        int yb;
        int xb;
        if (this.isScaled) {
            xb = this.scaleFromActual(x - this.panelMarginX);
            yb = this.scaleFromActual(y - this.panelMarginY);
        } else {
            xb = x - this.panelMarginX;
            yb = y - this.panelMarginY;
        }
        if (this.isRotated) {
            int xb1 = yb;
            yb = this.panelMinBW - xb - 16;
            xb = xb1;
        }
        return new int[]{xb, yb};
    }

    public boolean isScaled() {
        return this.isScaled;
    }

    public boolean isRotated() {
        return this.isRotated;
    }

    public void updateMode() {
        String topText;
        int cpn;
        block37: {
            block35: {
                int no7roundsleft;
                block38: {
                    block36: {
                        cpn = this.game.getCurrentPlayerNumber();
                        topText = null;
                        if (this.player == null) break block35;
                        if (!this.game.isDebugFreePlacement()) break block36;
                        topText = "DEBUG: Free Placement Mode";
                        if (this.game.getGameState() == 42) {
                            if (this.game.isGameOptionSet("_SC_FTRI")) {
                                this.mode = 19;
                                this.repaint();
                            } else {
                                this.mode = 0;
                            }
                        } else {
                            switch (this.player.getPieces().size()) {
                                case 1: 
                                case 3: {
                                    this.mode = 6;
                                    break;
                                }
                                case 0: 
                                case 2: {
                                    this.mode = 5;
                                    break;
                                }
                                default: {
                                    this.mode = 0;
                                    break;
                                }
                            }
                        }
                        break block37;
                    }
                    if (cpn != this.playerNumber) break block38;
                    switch (this.game.getGameState()) {
                        case 5: 
                        case 10: 
                        case 12: {
                            this.mode = 5;
                            break;
                        }
                        case 6: 
                        case 11: 
                        case 13: {
                            this.mode = 6;
                            break;
                        }
                        case 30: {
                            this.mode = 1;
                            break;
                        }
                        case 40: 
                        case 41: {
                            if (this.isLargeBoard) {
                                this.mode = 16;
                                break;
                            }
                            this.mode = 1;
                            break;
                        }
                        case 31: {
                            this.mode = 2;
                            break;
                        }
                        case 32: {
                            this.mode = 3;
                            break;
                        }
                        case 35: {
                            this.mode = 15;
                            break;
                        }
                        case 33: {
                            this.mode = 4;
                            break;
                        }
                        case 34: {
                            this.mode = 18;
                            break;
                        }
                        case 42: {
                            if (this.game.isGameOptionSet("_SC_FTRI")) {
                                this.mode = 19;
                                this.repaint();
                                break;
                            }
                            this.mode = 0;
                            break;
                        }
                        case 0: 
                        case 1: {
                            this.mode = 98;
                            break;
                        }
                        case 1000: {
                            this.mode = 99;
                            break;
                        }
                        case 15: {
                            this.mode = 97;
                            if (this.game.isGameOptionSet("N7")) {
                                int no7roundsleft2 = this.game.getGameOptionIntValue("N7") - this.game.getRoundCount();
                                if (no7roundsleft2 == 0) {
                                    topText = strings.get("board.msg.n7.last.round");
                                } else if (no7roundsleft2 > 0 && this.playerInterface.isClientCurrentPlayer() && this.playerInterface.getClientHand().isClientAndCurrentlyCanRoll()) {
                                    topText = strings.get("board.msg.n7.rounds.left", 1 + no7roundsleft2);
                                }
                            }
                            if (topText == null && !this.game.hasBuiltCity() && this.playerInterface.getClientHand().isClientAndCurrentlyCanRoll() && this.game.isGameOptionSet("N7C")) {
                                topText = strings.get("board.msg.n7c.until_city");
                                break;
                            }
                            break block37;
                        }
                        case 100: {
                            this.mode = 0;
                            topText = strings.get("board.msg.special.building", this.player.getName());
                            break;
                        }
                        default: {
                            this.mode = 0;
                            break;
                        }
                    }
                    break block37;
                }
                this.mode = 0;
                if (this.game.isSpecialBuilding()) {
                    topText = strings.get("board.msg.special.building", this.game.getPlayer(cpn).getName());
                } else if (this.game.isGameOptionSet("N7") && (no7roundsleft = this.game.getGameOptionIntValue("N7") - this.game.getRoundCount()) == 0) {
                    topText = strings.get("board.msg.n7.last.round");
                }
                break block37;
            }
            this.mode = 0;
        }
        this.moveShip_fromEdge = 0;
        if (this.latestPiecePlacement != null && cpn != this.latestPiecePlacement.getPlayerNumber()) {
            this.latestPiecePlacement = null;
        }
        this.setSuperimposedTopText(topText);
        this.updateHoverTipToMode();
    }

    protected void updateHoverTipToMode() {
        if (this.mode == 0 || this.mode == 97 || this.mode == 99) {
            this.hoverTip.setOffsetX(0);
        } else if (this.mode == 4 || this.mode == 18) {
            this.hoverTip.setOffsetX(15);
        } else if (this.mode == 5 || this.mode == 6) {
            this.hoverTip.setHoverText_modeChangedOrMouseMoved = true;
            this.hoverTip.setHoverText(null, 0);
            this.hoverTip.setOffsetX(9);
        } else {
            this.hoverTip.setHoverText_modeChangedOrMouseMoved = true;
            this.hoverTip.setHoverText(null, 0);
        }
    }

    protected void clearModeAndHilight(int ptype) {
        int expectedPtype;
        switch (this.mode) {
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 16: {
                expectedPtype = 0;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                expectedPtype = 1;
                break;
            }
            case 3: 
            case 9: 
            case 12: {
                expectedPtype = 2;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                expectedPtype = 3;
                break;
            }
            case 4: 
            case 18: {
                expectedPtype = -1;
                break;
            }
            default: {
                expectedPtype = ptype;
            }
        }
        if (ptype == expectedPtype || (this.mode == 6 || this.mode == 16) && ptype == 3) {
            this.mode = 0;
            this.hilight = 0;
            this.hilightIsShip = false;
            this.moveShip_fromEdge = 0;
            this.repaint();
        }
        this.updateHoverTipToMode();
    }

    public void updateAtWarshipsChanged(boolean isGain) {
        SOCRoutePiece newLatest = null;
        if (isGain) {
            SOCPlayer pl = this.game.getPlayer(this.game.getCurrentPlayerNumber());
            int numWarships = pl.getNumWarships();
            for (SOCRoutePiece rs : pl.getRoadsAndShips()) {
                if (!(rs instanceof SOCShip)) continue;
                if (numWarships == 1) {
                    newLatest = rs;
                }
                if (--numWarships > 0) continue;
                break;
            }
        }
        this.latestPiecePlacement = newLatest;
        this.repaint();
    }

    public void setPlayer() {
        this.setPlayer(null);
    }

    void setPlayer(SOCPlayer pl) {
        if (pl == null) {
            pl = this.playerInterface.getClientPlayer();
        }
        if (pl == this.player) {
            return;
        }
        this.player = pl;
        this.playerNumber = this.player.getPlayerNumber();
        HashSet<Integer> lse = this.player.getRestrictedLegalShips();
        if (lse != null) {
            this.flushBoardLayoutAndRepaint();
        } else {
            boolean any = false;
            for (int i = 0; i < this.debugShowPotentials.length; ++i) {
                if (!this.debugShowPotentials[i]) continue;
                any = true;
                break;
            }
            if (any) {
                this.scaledMissedImage = true;
            }
        }
        this.updateMode();
    }

    int getPlayerNumber() {
        return this.playerNumber;
    }

    public void setOtherPlayer(SOCPlayer op) {
        if (op != null) {
            this.otherPlayer = op;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseReleased(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            if (e.isPopupTrigger()) {
                this.popupMenuSystime = e.getWhen();
                e.consume();
                this.doBoardMenuPopup(e.getX(), e.getY());
                return;
            }
        }
        catch (Throwable th) {
            this.playerInterface.chatPrintStackTrace(th);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        boolean wantsRepaint = false;
        if (this.hoverTip.isVisible()) {
            this.hoverTip.hideHoverAndPieces();
            wantsRepaint = true;
        }
        if (this.mode != 0 && this.mode != 97) {
            this.hilight = 0;
            this.hilightIsShip = false;
            wantsRepaint = true;
        }
        if (wantsRepaint) {
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        try {
            int x = e.getX();
            int y = e.getY();
            int[] xyb = this.rotateScaleXYFromActual(x, y);
            int xb = xyb[0];
            int yb = xyb[1];
            switch (this.mode) {
                case 6: {
                    int edgeNum = 0;
                    if (this.ptrOldX == x && this.ptrOldY == y) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    boolean isShip = false;
                    edgeNum = this.findEdge(xb, yb, true);
                    if (edgeNum < 0 && this.isLargeBoard) {
                        edgeNum = -edgeNum;
                        if (this.player != null && this.game.canPlaceShip(this.player, edgeNum)) {
                            isShip = true;
                        }
                    } else {
                        boolean bl = isShip = this.player != null && !this.player.isPotentialRoad(edgeNum);
                    }
                    if (this.player == null || !this.player.isPotentialRoad(edgeNum) && !this.game.canPlaceShip(this.player, edgeNum) || !this.game.isDebugFreePlacement() && !this.board.isEdgeAdjacentToNode(this.initSettlementNode, edgeNum != -1 ? edgeNum : 0)) {
                        edgeNum = 0;
                    }
                    if (this.hilight != edgeNum || this.hilightIsShip != isShip) {
                        this.hilight = edgeNum;
                        this.hilightIsShip = isShip;
                        if (this.debugShowCoordsTooltip) {
                            String blank = edgeNum != 0 ? "" : null;
                            this.hoverTip.setHoverText(blank, edgeNum, x, y);
                            break;
                        }
                        this.repaint();
                    }
                    break;
                }
                case 1: 
                case 16: 
                case 17: {
                    boolean isShip;
                    boolean canPlaceShip;
                    int edgeNum = 0;
                    if (this.ptrOldX == x && this.ptrOldY == y) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    edgeNum = this.findEdge(xb, yb, true);
                    boolean hasShips = this.player != null && this.player.getNumPieces(3) > 0;
                    boolean bl = canPlaceShip = hasShips && this.game.canPlaceShip(this.player, Math.abs(edgeNum));
                    if (this.mode == 16 && canPlaceShip && edgeNum > 0 && this.player.getNumPieces(0) == 0) {
                        edgeNum = -edgeNum;
                    }
                    if (edgeNum < 0 && this.isLargeBoard) {
                        edgeNum = -edgeNum;
                        isShip = canPlaceShip || this.mode == 16 && hasShips && this.player.isPotentialShip(edgeNum);
                    } else {
                        isShip = false;
                    }
                    if (edgeNum != 0 && this.player != null) {
                        if (this.mode == 17) {
                            isShip = true;
                            if (!this.player.isPotentialShipMoveTo(edgeNum, this.moveShip_fromEdge)) {
                                edgeNum = 0;
                            } else {
                                SOCBoardLarge bL = (SOCBoardLarge)this.board;
                                int ph = bL.getPirateHex();
                                if (ph != 0 && bL.isEdgeAdjacentToHex(edgeNum, ph)) {
                                    edgeNum = 0;
                                }
                            }
                        } else if (this.player.isPotentialRoad(edgeNum) && this.player.getNumPieces(0) > 0 || this.mode == 16 && canPlaceShip) {
                            if (!isShip) {
                                isShip = this.player != null && canPlaceShip && !this.player.isPotentialRoad(edgeNum);
                            }
                        } else {
                            edgeNum = 0;
                        }
                    }
                    if (this.hilight != edgeNum || this.hilightIsShip != isShip) {
                        this.hilight = edgeNum;
                        this.hilightIsShip = isShip;
                        if (this.debugShowCoordsTooltip) {
                            String blank = edgeNum != 0 ? "" : null;
                            this.hoverTip.setHoverText(blank, edgeNum, x, y);
                            break;
                        }
                        this.repaint();
                    }
                    break;
                }
                case 2: 
                case 5: {
                    int nodeNum = 0;
                    if (this.ptrOldX == x && this.ptrOldY == y) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    nodeNum = this.findNode(xb, yb);
                    if (this.player == null || !this.player.canPlaceSettlement(nodeNum)) {
                        nodeNum = 0;
                    }
                    if (this.hilight != nodeNum) {
                        this.hilight = nodeNum;
                        this.hilightIsShip = false;
                        if (this.mode == 5 && !this.debugShowCoordsTooltip) {
                            this.hoverTip.handleHover(x, y, xb, yb);
                            break;
                        }
                        if (this.debugShowCoordsTooltip) {
                            this.hoverTip.setHoverText(nodeNum != 0 ? "" : null, nodeNum, x, y);
                            break;
                        }
                        this.repaint();
                        break;
                    }
                    if (this.mode != 5) break;
                    if (this.debugShowCoordsTooltip && nodeNum != 0) {
                        this.hoverTip.setHoverText("", nodeNum, x, y);
                        break;
                    }
                    this.hoverTip.handleHover(x, y, xb, yb);
                    break;
                }
                case 3: {
                    int nodeNum = 0;
                    if (this.ptrOldX == x && this.ptrOldY == y) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    nodeNum = this.findNode(xb, yb);
                    if (this.player == null || !this.player.isPotentialCity(nodeNum)) {
                        nodeNum = 0;
                    }
                    if (this.hilight == nodeNum) break;
                    this.hilight = nodeNum;
                    this.hilightIsShip = false;
                    if (this.debugShowCoordsTooltip) {
                        String blank = nodeNum != 0 ? "" : null;
                        this.hoverTip.setHoverText(blank, nodeNum, x, y);
                        break;
                    }
                    this.repaint();
                    break;
                }
                case 15: {
                    int edgeNum = 0;
                    if (this.ptrOldX == x && this.ptrOldY == y) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    edgeNum = this.findEdge(xb, yb, false);
                    if (!(edgeNum == 0 || this.player != null && this.player.getNumPieces(3) >= 1 && this.game.canPlaceShip(this.player, edgeNum))) {
                        edgeNum = 0;
                    }
                    if (this.hilight == edgeNum) break;
                    this.hilight = edgeNum;
                    this.hilightIsShip = true;
                    if (this.debugShowCoordsTooltip) {
                        String blank = edgeNum != 0 ? "" : null;
                        this.hoverTip.setHoverText(blank, edgeNum, x, y);
                        break;
                    }
                    this.repaint();
                    break;
                }
                case 4: 
                case 18: {
                    boolean canMove;
                    int hexNum = 0;
                    if (this.ptrOldX == x && this.ptrOldY == y) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    hexNum = this.findHex(xb, yb);
                    boolean bl = canMove = this.mode == 4 ? this.game.canMoveRobber(this.playerNumber, hexNum) : this.game.canMovePirate(this.playerNumber, hexNum);
                    if (!canMove && hexNum != 0) {
                        if (this.board instanceof SOCBoardLarge && ((SOCBoardLarge)this.board).isHexInLandAreas(hexNum, ((SOCBoardLarge)this.board).getRobberExcludedLandAreas())) {
                            this.hoverTip.setHoverText(strings.get("board.robber.not.here"), hexNum);
                        } else {
                            this.hoverTip.setHoverText(null, 0);
                        }
                        hexNum = 0;
                    }
                    if (this.hilight != hexNum) {
                        this.hilight = hexNum;
                        this.hilightIsShip = false;
                        this.hoverTip.handleHover(x, y, xb, yb);
                        this.repaint();
                        break;
                    }
                    this.hoverTip.positionToMouse(x, y);
                    break;
                }
                case 19: {
                    boolean changed;
                    int edgeNum = 0;
                    if (this.ptrOldX == x && this.ptrOldY == y && this.hilight != 0) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    edgeNum = this.findEdge(xb, yb, false);
                    if (edgeNum > 0 && !this.game.canPlacePort(this.player, edgeNum)) {
                        edgeNum = 0;
                    }
                    boolean bl = changed = this.hilight != edgeNum;
                    if (changed) {
                        this.hilight = edgeNum;
                    }
                    if (this.debugShowCoordsTooltip) {
                        String blank = edgeNum != 0 ? "" : null;
                        this.hoverTip.setHoverText(blank, edgeNum, x, y);
                        break;
                    }
                    if (changed) {
                        this.repaint();
                    }
                    break;
                }
                case 7: 
                case 10: {
                    int nodeNum = 0;
                    if (this.ptrOldX == x && this.ptrOldY == y) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    nodeNum = this.findNode(xb, yb);
                    if (this.hilight == nodeNum) break;
                    this.hilight = nodeNum;
                    this.hilightIsShip = false;
                    this.repaint();
                    break;
                }
                case 8: 
                case 11: {
                    int edgeNum = 0;
                    if (this.ptrOldX == x && this.ptrOldY == y) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    edgeNum = this.findEdge(xb, yb, false);
                    if (!this.otherPlayer.isPotentialRoad(edgeNum)) {
                        edgeNum = 0;
                    }
                    if (this.hilight == edgeNum) break;
                    this.hilight = edgeNum;
                    this.hilightIsShip = false;
                    this.repaint();
                    break;
                }
                case 13: 
                case 14: {
                    int edgeNum = 0;
                    if (this.ptrOldX == x && this.ptrOldY == y) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    edgeNum = this.findEdge(xb, yb, false);
                    if (!this.otherPlayer.isPotentialShip(edgeNum)) {
                        edgeNum = 0;
                    }
                    if (this.hilight == edgeNum) break;
                    this.hilight = edgeNum;
                    this.hilightIsShip = true;
                    this.repaint();
                    break;
                }
                case 9: 
                case 12: {
                    int nodeNum = 0;
                    if (this.ptrOldX == x && this.ptrOldY == y) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    nodeNum = this.findNode(xb, yb);
                    if (!this.otherPlayer.isPotentialCity(nodeNum)) {
                        nodeNum = 0;
                    }
                    if (this.hilight == nodeNum) break;
                    this.hilight = nodeNum;
                    this.hilightIsShip = false;
                    this.repaint();
                    break;
                }
                case 0: 
                case 97: 
                case 99: {
                    if (this.ptrOldX == x && this.ptrOldY == y) break;
                    this.ptrOldX = x;
                    this.ptrOldY = y;
                    this.hoverTip.handleHover(x, y, xb, yb);
                    break;
                }
            }
        }
        catch (Throwable th) {
            this.playerInterface.chatPrintStackTrace(th);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        try {
            boolean tempChangedMode;
            block53: {
                block52: {
                    int x = evt.getX();
                    int y = evt.getY();
                    if (evt.isPopupTrigger()) {
                        this.popupMenuSystime = evt.getWhen();
                        evt.consume();
                        this.doBoardMenuPopup(x, y);
                        return;
                    }
                    if (evt.getWhen() < this.popupMenuSystime + (long)POPUP_MENU_IGNORE_MS) {
                        return;
                    }
                    tempChangedMode = false;
                    if (this.mode == 0 && this.hoverTip.isVisible()) {
                        if (this.game.isDebugFreePlacement()) {
                            if (this.hoverTip.hoverSettlementID != 0) {
                                this.hilight = this.hoverTip.hoverSettlementID;
                                this.hilightIsShip = false;
                                this.mode = 2;
                                tempChangedMode = true;
                            } else if (this.hoverTip.hoverCityID != 0) {
                                this.hilight = this.hoverTip.hoverCityID;
                                this.hilightIsShip = false;
                                this.mode = 3;
                                tempChangedMode = true;
                            } else if (this.hoverTip.hoverRoadID != 0) {
                                this.hilight = this.hoverTip.hoverRoadID;
                                this.hilightIsShip = false;
                                this.mode = 1;
                                tempChangedMode = true;
                            } else if (this.hoverTip.hoverShipID != 0) {
                                this.hilight = this.hoverTip.hoverShipID;
                                this.hilightIsShip = true;
                                this.mode = 15;
                                tempChangedMode = true;
                            }
                        } else if ((evt.getButton() & 1) != 0 && this.player != null && this.game.getCurrentPlayerNumber() == this.playerNumber && this.player.getPublicVP() == 2 && this.hintShownCount_RightClickToBuild < 2 && evt.getWhen() - this.popupMenuSystime > 5000L) {
                            ++this.hintShownCount_RightClickToBuild;
                            String prompt = SOCPlayerClient.IS_PLATFORM_MAC_OSX ? "board.popup.hint_build_click.osx" : "board.popup.hint_build_click";
                            NotifyDialog.createAndShow(this.playerInterface.getMainDisplay(), this.playerInterface, "\n" + strings.get(prompt), null, true);
                        }
                    }
                    if (this.hilight == 0 || this.player == null || x != this.ptrOldX || y != this.ptrOldY) break block52;
                    GameMessageSender messageSender = this.playerInterface.getClient().getGameMessageSender();
                    switch (this.mode) {
                        case 0: {
                            break;
                        }
                        case 97: {
                            break;
                        }
                        case 1: 
                        case 6: 
                        case 16: {
                            if (this.hilight == -1) {
                                this.hilight = 0;
                            }
                            if (this.player.isPotentialRoad(this.hilight) && !this.hilightIsShip) {
                                messageSender.putPiece(this.game, new SOCRoad(this.player, this.hilight, this.board));
                                this.clearModeAndHilight(0);
                                if (!tempChangedMode) break;
                                this.hoverTip.hideHoverAndPieces();
                                break;
                            }
                            if (!this.game.canPlaceShip(this.player, this.hilight)) break;
                            if (this.game.isGameOptionSet("_SC_FTRI") && ((SOCBoardLarge)this.board).canRemovePort(this.hilight)) {
                                EventQueue.invokeLater(new ConfirmPlaceShipDialog(this.hilight, false, -1));
                            } else {
                                messageSender.putPiece(this.game, new SOCShip(this.player, this.hilight, this.board));
                                this.clearModeAndHilight(3);
                            }
                            if (!tempChangedMode) break;
                            this.hoverTip.hideHoverAndPieces();
                            break;
                        }
                        case 17: {
                            this.moveShip_toEdge = this.hilight;
                            this.tryMoveShipToEdge();
                            break;
                        }
                        case 5: {
                            if (this.playerNumber == this.playerInterface.getClientPlayerNumber()) {
                                this.initSettlementNode = this.hilight;
                            }
                        }
                        case 2: {
                            if (!this.player.canPlaceSettlement(this.hilight)) break;
                            messageSender.putPiece(this.game, new SOCSettlement(this.player, this.hilight, this.board));
                            this.clearModeAndHilight(1);
                            if (!tempChangedMode) break;
                            this.hoverTip.hideHoverAndPieces();
                            break;
                        }
                        case 3: {
                            if (!this.player.isPotentialCity(this.hilight)) break;
                            messageSender.putPiece(this.game, new SOCCity(this.player, this.hilight, this.board));
                            this.clearModeAndHilight(2);
                            if (!tempChangedMode) break;
                            this.hoverTip.hideHoverAndPieces();
                            break;
                        }
                        case 15: {
                            if (!this.game.canPlaceShip(this.player, this.hilight)) break;
                            if (this.game.isGameOptionSet("_SC_FTRI") && ((SOCBoardLarge)this.board).canRemovePort(this.hilight)) {
                                EventQueue.invokeLater(new ConfirmPlaceShipDialog(this.hilight, false, -1));
                            } else {
                                messageSender.putPiece(this.game, new SOCShip(this.player, this.hilight, this.board));
                                this.clearModeAndHilight(3);
                            }
                            if (!tempChangedMode) break;
                            this.hoverTip.hideHoverAndPieces();
                            break;
                        }
                        case 4: {
                            if (this.hilight == this.board.getRobberHex()) break;
                            boolean cliAdjacent = false;
                            if (0 != this.board.getNumberOnHexFromCoord(this.hilight)) {
                                for (SOCPlayer pl : this.game.getPlayersOnHex(this.hilight, null)) {
                                    if (pl.getPlayerNumber() != this.playerNumber) continue;
                                    cliAdjacent = true;
                                    break;
                                }
                            }
                            if (cliAdjacent) {
                                EventQueue.invokeLater(new MoveRobberConfirmDialog(this.player, this.hilight));
                                break;
                            }
                            messageSender.moveRobber(this.game, this.player, this.hilight);
                            this.clearModeAndHilight(-1);
                            break;
                        }
                        case 18: {
                            if (this.hilight == ((SOCBoardLarge)this.board).getPirateHex()) break;
                            boolean cliAdjacent = false;
                            for (SOCPlayer pl : this.game.getPlayersShipsOnHex(this.hilight)) {
                                if (pl.getPlayerNumber() != this.playerNumber) continue;
                                cliAdjacent = true;
                                break;
                            }
                            if (cliAdjacent) {
                                EventQueue.invokeLater(new MoveRobberConfirmDialog(this.player, -this.hilight));
                                break;
                            }
                            messageSender.moveRobber(this.game, this.player, -this.hilight);
                            this.clearModeAndHilight(-1);
                            break;
                        }
                        case 19: {
                            if (this.hilight == 0) break;
                            int edge = this.hilight;
                            if (edge == -1) {
                                edge = 0;
                            }
                            if (this.game.canPlacePort(this.player, edge)) {
                                messageSender.sendSimpleRequest(this.player, 1001, this.hilight, 0);
                                this.hilight = 0;
                                break;
                            }
                            break block53;
                        }
                        case 7: {
                            if (!this.otherPlayer.canPlaceSettlement(this.hilight)) break;
                            messageSender.considerMove(this.game, this.otherPlayer, new SOCSettlement(this.otherPlayer, this.hilight, this.board));
                            this.clearModeAndHilight(1);
                            break;
                        }
                        case 8: {
                            if (!this.otherPlayer.isPotentialRoad(this.hilight)) break;
                            messageSender.considerMove(this.game, this.otherPlayer, new SOCRoad(this.otherPlayer, this.hilight, this.board));
                            this.clearModeAndHilight(0);
                            break;
                        }
                        case 13: {
                            if (!this.otherPlayer.isPotentialShip(this.hilight)) break;
                            messageSender.considerMove(this.game, this.otherPlayer, new SOCShip(this.otherPlayer, this.hilight, this.board));
                            this.clearModeAndHilight(3);
                            break;
                        }
                        case 9: {
                            if (!this.otherPlayer.isPotentialCity(this.hilight)) break;
                            messageSender.considerMove(this.game, this.otherPlayer, new SOCCity(this.otherPlayer, this.hilight, this.board));
                            this.clearModeAndHilight(2);
                            break;
                        }
                        case 10: {
                            if (!this.otherPlayer.canPlaceSettlement(this.hilight)) break;
                            messageSender.considerTarget(this.game, this.otherPlayer, new SOCSettlement(this.otherPlayer, this.hilight, this.board));
                            this.clearModeAndHilight(1);
                            break;
                        }
                        case 11: {
                            if (!this.otherPlayer.isPotentialRoad(this.hilight)) break;
                            messageSender.considerTarget(this.game, this.otherPlayer, new SOCRoad(this.otherPlayer, this.hilight, this.board));
                            this.clearModeAndHilight(0);
                            break;
                        }
                        case 14: {
                            if (!this.otherPlayer.isPotentialShip(this.hilight)) break;
                            messageSender.considerTarget(this.game, this.otherPlayer, new SOCShip(this.otherPlayer, this.hilight, this.board));
                            this.clearModeAndHilight(3);
                            break;
                        }
                        case 12: {
                            if (!this.otherPlayer.isPotentialCity(this.hilight)) break;
                            messageSender.considerTarget(this.game, this.otherPlayer, new SOCCity(this.otherPlayer, this.hilight, this.board));
                            this.clearModeAndHilight(2);
                        }
                    }
                    break block53;
                }
                if (this.player != null && (this.game.getCurrentPlayerNumber() == this.playerNumber || this.game.isDebugFreePlacement())) {
                    this.updateMode();
                    this.ptrOldX = 0;
                    this.ptrOldY = 0;
                    this.mouseMoved(evt);
                }
            }
            evt.consume();
            if (tempChangedMode) {
                this.mode = 0;
            }
        }
        catch (Throwable th) {
            this.playerInterface.chatPrintStackTrace(th);
        }
    }

    protected void doBoardMenuPopup(int x, int y) {
        switch (this.mode) {
            case 1: {
                this.popupMenu.showCancelBuild(0, x, y, this.hilight);
                break;
            }
            case 2: {
                this.popupMenu.showCancelBuild(1, x, y, this.hilight);
                break;
            }
            case 3: {
                this.popupMenu.showCancelBuild(2, x, y, this.hilight);
                break;
            }
            case 15: 
            case 17: {
                this.popupMenu.showCancelBuild(3, x, y, this.hilight);
                break;
            }
            case 6: 
            case 16: {
                int hilightRoad = !this.game.hasSeaBoard || this.player.isLegalRoad(this.hilight) ? this.hilight : 0;
                int hilightShip = this.game.hasSeaBoard && this.player.isLegalShip(this.hilight) ? this.hilight : 0;
                this.popupMenu.showBuild(x, y, hilightRoad, 0, 0, hilightShip);
                break;
            }
            case 5: {
                this.popupMenu.showBuild(x, y, 0, this.hilight, 0, 0);
                break;
            }
            default: {
                int hilightShip;
                int hilightRoad;
                if (this.hoverTip.hoverPiece != null && this.hoverTip.hoverPiece instanceof SOCFortress) {
                    this.popupMenu.showAtPirateFortress(x, y, (SOCFortress)this.hoverTip.hoverPiece);
                    return;
                }
                if (this.game.hasSeaBoard && (this.hoverTip.hoverRoadID != 0 || this.hoverTip.hoverShipID != 0)) {
                    int edge = this.hoverTip.hoverRoadID;
                    if (edge == 0) {
                        edge = this.hoverTip.hoverShipID;
                    }
                    int n = hilightRoad = this.player.isLegalRoad(edge) ? edge : 0;
                    hilightShip = this.hoverTip.hoverIsShipMovable ? -this.hoverTip.hoverShipID : (this.player.isLegalShip(edge) ? edge : 0);
                } else {
                    hilightRoad = this.hoverTip.hoverRoadID;
                    hilightShip = 0;
                }
                this.popupMenu.showBuild(x, y, hilightRoad, this.hoverTip.hoverSettlementID, this.hoverTip.hoverCityID, hilightShip);
            }
        }
    }

    public boolean popupExpectingBuildRequest() {
        if (this.buildReqTimerTask == null) {
            return false;
        }
        return !this.buildReqTimerTask.wasItSentAlready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popupSetBuildRequest(int coord, int ptype) {
        Timer piTimer;
        if (coord == -1) {
            coord = 0;
        }
        Timer timer = piTimer = this.playerInterface.getEventTimer();
        synchronized (timer) {
            if (this.buildReqTimerTask != null) {
                this.buildReqTimerTask.doNotSend();
                this.buildReqTimerTask.cancel();
            }
            this.buildReqTimerTask = new BoardPanelSendBuildTask(coord, ptype);
            piTimer.schedule((TimerTask)this.buildReqTimerTask, 1000 * BUILD_REQUEST_MAX_DELAY_SEC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popupClearBuildRequest() {
        Timer piTimer;
        Timer timer = piTimer = this.playerInterface.getEventTimer();
        synchronized (timer) {
            if (this.buildReqTimerTask == null) {
                return;
            }
            this.buildReqTimerTask.doNotSend();
            this.buildReqTimerTask.cancel();
            this.buildReqTimerTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popupFireBuildingRequest() {
        Timer piTimer;
        Timer timer = piTimer = this.playerInterface.getEventTimer();
        synchronized (timer) {
            if (this.buildReqTimerTask == null) {
                return;
            }
            this.buildReqTimerTask.sendOnceFromClientIfCurrentPlayer();
            this.buildReqTimerTask.cancel();
            this.buildReqTimerTask = null;
        }
        this.hoverTip.hideHoverAndPieces();
    }

    private final void tryMoveShipToEdge() {
        boolean clearMode = true;
        if (this.moveShip_fromEdge != 0) {
            if (this.game.canMoveShip(this.playerNumber, this.moveShip_fromEdge, this.moveShip_toEdge) != null) {
                if (this.game.isGameOptionSet("_SC_FTRI") && ((SOCBoardLarge)this.board).canRemovePort(this.moveShip_toEdge)) {
                    EventQueue.invokeLater(new ConfirmPlaceShipDialog(this.moveShip_toEdge, false, this.moveShip_fromEdge));
                    clearMode = false;
                } else {
                    this.playerInterface.getClient().getGameMessageSender().movePieceRequest(this.game, this.playerNumber, 3, this.moveShip_fromEdge, this.moveShip_toEdge);
                }
            }
            if (clearMode) {
                this.moveShip_fromEdge = 0;
            }
        }
        if (clearMode) {
            this.clearModeAndHilight(3);
        }
    }

    public void setSuperimposedText(String text1, String text2) throws IllegalArgumentException {
        if (this.superText1 == text1 && this.superText2 == text2) {
            return;
        }
        if (this.superText1 == null && this.superText2 != null) {
            throw new IllegalArgumentException("text2 not null, text1 null");
        }
        this.superText1 = text1;
        this.superText2 = text2;
        this.superText1_w = 0;
        this.superText2_w = 0;
        this.superTextBox_w = 0;
        this.repaint();
    }

    public void setSuperimposedTopText(String text) {
        this.superTextTop = text;
        this.superTextTop_w = 0;
        this.superTextTopBox_w = 0;
        this.repaint();
    }

    private final int findEdge(int x, int y, boolean checkCoastal) {
        int secX;
        int secY;
        if (this.isLargeBoard) {
            int hexRight;
            int hexLeft;
            int edgeX;
            int secY2 = (y - 33) / 15;
            if (secY2 % 3 == 1) {
                x += 12;
            }
            secY2 = (y - 22) / 23;
            int secX2 = x / 27;
            if (secX2 < 0 || secY2 < 0 || secX2 > this.board.getBoardWidth() || secY2 > this.board.getBoardHeight()) {
                return 0;
            }
            int edge = secY2 << 8 | secX2;
            if (!checkCoastal || !((SOCBoardLarge)this.board).isEdgeCoastline(edge)) {
                return edge;
            }
            if (secY2 % 2 == 1) {
                edgeX = 13;
                hexLeft = this.board.getAdjacentHexToEdge(edge, 5);
                hexRight = this.board.getAdjacentHexToEdge(edge, 2);
            } else {
                int yrel = (y - 22) % 23;
                if (secX2 % 2 == secY2 / 2 % 2) {
                    edgeX = yrel * 27 / 23;
                    hexLeft = this.board.getAdjacentHexToEdge(edge, 4);
                    hexRight = this.board.getAdjacentHexToEdge(edge, 1);
                } else {
                    edgeX = (23 - yrel) * 27 / 23;
                    hexLeft = this.board.getAdjacentHexToEdge(edge, 6);
                    hexRight = this.board.getAdjacentHexToEdge(edge, 3);
                }
            }
            int hex = x % 27 <= edgeX ? hexLeft : hexRight;
            if (this.board.isHexOnLand(hex)) {
                return edge;
            }
            return -edge;
        }
        if (this.is6player) {
            secY = (y - 7) / 15;
            if (secY % 3 != 0) {
                x += 8;
            }
            secX = (x - 54) / 27;
        } else {
            secY = y / 15;
            if (secY % 3 != 0) {
                x += 8;
            }
            secX = x / 27;
        }
        int sector = secX + secY * 15;
        if (sector >= 0 && sector < this.edgeMap.length) {
            return this.edgeMap[sector];
        }
        return 0;
    }

    private final int findNode(int x, int y) {
        int secY;
        int secX;
        if (this.isLargeBoard) {
            int secX2 = (x + 13) / 27;
            int secY2 = (y - 20) / 23;
            if (secX2 < 0 || secY2 < 0 || secX2 > this.board.getBoardWidth() || secY2 > this.board.getBoardHeight()) {
                return 0;
            }
            return secY2 << 8 | secX2;
        }
        if (this.is6player) {
            secX = (x + 13 - 54) / 27;
            secY = (y + 7 - 7) / 15;
        } else {
            secX = (x + 13) / 27;
            secY = (y + 7) / 15;
        }
        int sector = secX + secY * 15;
        if (sector >= 0 && sector < this.nodeMap.length) {
            return this.nodeMap[sector];
        }
        return 0;
    }

    private final int findHex(int x, int y) {
        int secY;
        int secX;
        if (this.isLargeBoard) {
            int secY2 = (y - 20) / 23;
            int secX2 = (x + 13) / 27;
            int hex = secY2 << 8 | secX2;
            if (-1 != ((SOCBoardLarge)this.board).getHexTypeFromCoord(hex)) {
                return hex;
            }
            return 0;
        }
        if (this.is6player) {
            secX = (x - 54) / 27;
            secY = (y - 7) / 15;
        } else {
            secX = x / 27;
            secY = y / 15;
        }
        int sector = secX + secY * 15;
        if (sector >= 0 && sector < this.hexMap.length) {
            return this.hexMap[sector];
        }
        return 0;
    }

    public void setMode(int m) {
        if (m >= 7 && m <= 12 && this.otherPlayer == null) {
            return;
        }
        this.mode = m;
        this.updateHoverTipToMode();
    }

    public void setModeMoveShip(int edge) {
        if (this.mode != 0) {
            throw new IllegalStateException();
        }
        this.mode = 17;
        this.moveShip_fromEdge = edge;
        this.moveShip_toEdge = 0;
        this.hilight = 0;
        this.repaint();
    }

    static synchronized void reloadBoardGraphics(Component c) {
        boolean hadAnyRotated;
        boolean bl = hadAnyRotated = rotatHexes != null;
        if (hexes == null) {
            return;
        }
        hexes = null;
        rotatHexes = null;
        SOCBoardPanel.loadImages(c, hadAnyRotated);
    }

    private static synchronized void loadImages(Component c, boolean wantsRotated) {
        if (!(hexes == null || rotatHexes == null && wantsRotated)) {
            return;
        }
        Class<?> clazz = c.getClass();
        int setIdx = UserPreferences.getPref("hexGraphicsSet", 0);
        if (setIdx < 0 || setIdx >= HEX_GRAPHICS_SET_SUBDIRS.length) {
            setIdx = 0;
        }
        String hexSetDirBase = IMAGEDIR + "/" + HEX_GRAPHICS_SET_SUBDIRS[setIdx];
        if (hexes == null) {
            hexesGraphicsSetIndex = setIdx;
            hexes = new BufferedImage[10];
            try {
                SOCBoardPanel.loadHexesAndImages(hexes, hexSetDirBase, clazz, false);
            }
            catch (IOException e) {
                System.out.println("Error loading board images");
            }
            hexesMustAlwaysScale = SOCBoardPanel.checkNonstandardHexesSize(hexes, false);
        }
        if (wantsRotated && rotatHexes == null) {
            rotatHexes = new BufferedImage[8];
            try {
                SOCBoardPanel.loadHexesAndImages(rotatHexes, hexSetDirBase + "/rotat", clazz, true);
            }
            catch (IOException e) {
                System.out.println("Error loading rotated board images");
            }
            rotatHexesMustAlwaysScale = SOCBoardPanel.checkNonstandardHexesSize(rotatHexes, true);
        }
    }

    private static final void loadHexesAndImages(BufferedImage[] newHexes, String imageDir, Class<?> clazz, boolean wantsRotated) throws IOException {
        int numHexImage;
        newHexes[0] = ImageIO.read(clazz.getResource(imageDir + "/waterHex.gif"));
        newHexes[1] = ImageIO.read(clazz.getResource(imageDir + "/clayHex.gif"));
        newHexes[2] = ImageIO.read(clazz.getResource(imageDir + "/oreHex.gif"));
        newHexes[3] = ImageIO.read(clazz.getResource(imageDir + "/sheepHex.gif"));
        newHexes[4] = ImageIO.read(clazz.getResource(imageDir + "/wheatHex.gif"));
        newHexes[5] = ImageIO.read(clazz.getResource(imageDir + "/woodHex.gif"));
        newHexes[6] = ImageIO.read(clazz.getResource(imageDir + "/desertHex.gif"));
        if (wantsRotated) {
            numHexImage = 8;
        } else {
            numHexImage = 10;
            newHexes[7] = ImageIO.read(clazz.getResource(imageDir + "/goldHex.gif"));
            newHexes[8] = ImageIO.read(clazz.getResource(imageDir + "/fogHex.gif"));
        }
        newHexes[numHexImage - 1] = ImageIO.read(clazz.getResource(imageDir + "/miscPort.gif"));
    }

    private static boolean checkNonstandardHexesSize(Image[] loaded, boolean isRotated) {
        int wantW = isRotated ? 64 : 55;
        int wantH = isRotated ? 55 : 64;
        for (Image hexi : loaded) {
            if (hexi.getWidth(null) == wantW && hexi.getHeight(null) == wantH) continue;
            return true;
        }
        return false;
    }

    public final Color hexColor(int hexType) {
        Color hexColor;
        switch (hexType) {
            case 6: {
                hexColor = ColorSquare.DESERT;
                break;
            }
            case 1: {
                hexColor = ColorSquare.CLAY;
                break;
            }
            case 2: {
                hexColor = ColorSquare.ORE;
                break;
            }
            case 3: {
                hexColor = ColorSquare.SHEEP;
                break;
            }
            case 4: {
                hexColor = ColorSquare.WHEAT;
                break;
            }
            case 5: {
                hexColor = ColorSquare.WOOD;
                break;
            }
            case 7: {
                if (this.isLargeBoard) {
                    hexColor = ColorSquare.GOLD;
                    break;
                }
                hexColor = ColorSquare.WATER;
                break;
            }
            case 8: {
                if (this.isLargeBoard) {
                    hexColor = ColorSquare.FOG;
                    break;
                }
                hexColor = ColorSquare.WATER;
                break;
            }
            default: {
                hexColor = ColorSquare.WATER;
            }
        }
        return hexColor;
    }

    static {
        vertRoadX = new int[]{-2, 3, 3, -2, -2};
        vertRoadY = new int[]{17, 17, 47, 47, 17};
        upRoadX = new int[]{-1, 26, 29, 2, -1};
        upRoadY = new int[]{15, -2, 2, 19, 15};
        downRoadX = new int[]{-1, 2, 29, 26, -1};
        downRoadY = new int[]{49, 45, 62, 66, 49};
        settlementX = new int[]{-7, 0, 7, 7, -7, -7, 7};
        settlementY = new int[]{-7, -14, -7, 5, 5, -7, -7};
        cityX = new int[]{-10, -4, 2, 2, 10, 10, -10, -10, 0, 0, 10, 5, -10};
        cityY = new int[]{-8, -14, -8, -4, -4, 6, 6, -8, -8, -4, -4, -8, -8};
        shipX = new int[]{-2, 3, 6, 6, 4, 13, 11, -11, -11, -1, -1, 0, 0, -2};
        shipY = new int[]{22, 24, 28, 33, 36, 36, 43, 43, 36, 36, 34, 32, 27, 22};
        warshipX = new int[]{-7, -2, 1, 1, -1, 4, 4, 5, 5, 3, 8, 11, 11, 9, 13, 11, -11, -11, -6, -6, -5, -5, -7};
        warshipY = new int[]{22, 24, 28, 33, 36, 36, 34, 32, 27, 22, 24, 28, 33, 36, 36, 43, 43, 36, 36, 34, 32, 27, 22};
        fortressX = new int[]{-14, -14, -7, -7, -5, -5, -1, -1, 1, 1, 5, 5, 7, 7, 14, 14, 7, 7, -7, -7};
        fortressY = new int[]{11, -11, -11, -7, -7, -9, -9, -7, -7, -9, -9, -7, -7, -11, -11, 11, 11, 9, 9, 11};
        diamondX = new int[]{0, 14, 0, -14, 0};
        diamondY = new int[]{-10, 0, 10, 0, -10};
        robberX = new int[]{-2, -4, -4, -2, 2, 4, 4, 2, 4, 4, -4, -4, -2, 2};
        robberY = new int[]{-2, -4, -6, -8, -8, -6, -4, -2, 0, 8, 8, 0, -2, -2};
        portArrowsX = new int[][]{{27, 31, 23}, {51, 49, 45}, {51, 45, 49}, {27, 23, 31}, {3, 5, 9}, {3, 9, 5}};
        portArrowsY = new int[][]{{4, 8, 8}, {18, 24, 16}, {45, 47, 39}, {59, 55, 55}, {45, 39, 47}, {18, 16, 24}};
        arrowXL = new int[]{0, 17, 18, 18, 36, 36, 18, 18, 17, 0};
        arrowXR = null;
        arrowY = new int[]{17, 0, 0, 6, 6, 30, 30, 36, 36, 19};
        ARROW_COLOR = new Color(224, 255, 224);
        ARROW_COLOR_PLACING = new Color(255, 255, 60);
        HEX_BORDER_COLORS = new Color[]{null, new Color(78, 16, 0), new Color(58, 59, 57), new Color(20, 113, 0), new Color(142, 109, 0), new Color(9, 54, 13), new Color(203, 180, 73), null, new Color(188, 188, 188)};
        ROTAT_HEX_BORDER_COLORS = new Color[]{null, new Color(120, 36, 0), HEX_BORDER_COLORS[2], HEX_BORDER_COLORS[3], HEX_BORDER_COLORS[4], new Color(9, 54, 11), HEX_BORDER_COLORS[6]};
        HEX_GRAPHICS_SET_BORDER_WATER_COLORS = new Color[]{new Color(80, 138, 181), new Color(38, 60, 113)};
        HEX_GRAPHICS_SET_SC_PIRI_PATH_COLORS = new Color[]{ColorSquare.WATER.darker(), ColorSquare.WATER.brighter()};
        BUILD_REQUEST_MAX_DELAY_SEC = 5;
        POPUP_MENU_IGNORE_MS = 150;
        DICE_NUMBER_CIRCLE_COLORS = new Color[]{Color.YELLOW, new Color(255, 189, 0), new Color(255, 125, 0), new Color(255, 84, 0), Color.RED};
        hexCornersX = new int[]{27, 54, 54, 27, 0, 0, 27};
        hexCornersY = new int[]{0, 16, 46, 62, 46, 16, 0};
        ROW_START_HEXNUM = new int[]{0, 4, 9, 15, 22, 28, 33};
    }

    private static enum HilightStyle {
        HOVER,
        MOST_RECENT_PLACEMENT;

    }

    private class ConfirmPlaceShipDialog
    extends AskDialog
    implements Runnable {
        private static final long serialVersionUID = 2000L;
        private final int edge;
        private final boolean sendBuildReqFirst;
        private final int isMove_fromEdge;

        private ConfirmPlaceShipDialog(int edge, boolean sendBuildReqFirst, int isMove_fromEdge) {
            super(SOCBoardPanel.this.playerInterface.getMainDisplay(), SOCBoardPanel.this.playerInterface, strings.get("dialog.base.place.ship.title"), strings.get(SOCBoardPanel.this.player.getPortMovePotentialLocations(false) != null ? "game.invitem.sc_ftri.pickup.ask.immed" : "game.invitem.sc_ftri.pickup.ask.later"), strings.get("dialog.base.place.ship"), strings.get("dialog.base.place.dont"), null, 1);
            this.edge = edge;
            this.sendBuildReqFirst = sendBuildReqFirst;
            this.isMove_fromEdge = isMove_fromEdge;
        }

        @Override
        public void button1Chosen() {
            if (this.sendBuildReqFirst) {
                int currentHover = ((SOCBoardPanel)SOCBoardPanel.this).hoverTip.hoverShipID;
                ((SOCBoardPanel)SOCBoardPanel.this).hoverTip.hoverShipID = this.edge;
                SOCBoardPanel.this.popupMenu.tryBuild(3);
                ((SOCBoardPanel)SOCBoardPanel.this).hoverTip.hoverShipID = currentHover;
            } else {
                GameMessageSender gms = this.md.getGameMessageSender();
                if (this.isMove_fromEdge == -1) {
                    gms.putPiece(SOCBoardPanel.this.game, new SOCShip(SOCBoardPanel.this.player, this.edge, SOCBoardPanel.this.board));
                } else {
                    gms.movePieceRequest(SOCBoardPanel.this.game, SOCBoardPanel.this.playerNumber, 3, this.isMove_fromEdge, this.edge);
                }
                SOCBoardPanel.this.clearModeAndHilight(3);
            }
        }

        @Override
        public void button2Chosen() {
            if (!this.sendBuildReqFirst) {
                SOCBoardPanel.this.hilight = 0;
                SOCBoardPanel.this.repaint();
            }
        }

        @Override
        public void windowCloseChosen() {
            this.button2Chosen();
        }
    }

    private class ConfirmAttackPirateFortressDialog
    extends AskDialog
    implements Runnable {
        private static final long serialVersionUID = 2000L;

        protected ConfirmAttackPirateFortressDialog() {
            super(SOCBoardPanel.this.playerInterface.getMainDisplay(), SOCBoardPanel.this.playerInterface, strings.get("game.sc_piri.attfort.and.endturn"), strings.get("game.sc_piri.attfort.confirm.endturn"), strings.get("game.sc_piri.attfort.confirm"), strings.get("base.cancel"), null, 2);
        }

        @Override
        public void button1Chosen() {
            SOCBoardPanel.this.popupMenu.tryAttackPirateFortress();
        }

        @Override
        public void button2Chosen() {
        }

        @Override
        public void windowCloseChosen() {
            this.button2Chosen();
        }
    }

    private class MoveRobberConfirmDialog
    extends AskDialog
    implements Runnable {
        private static final long serialVersionUID = 2000L;
        private final SOCPlayer pl;
        private final int robHex;

        private MoveRobberConfirmDialog(SOCPlayer player, int newRobHex) {
            super(SOCBoardPanel.this.playerInterface.getMainDisplay(), SOCBoardPanel.this.playerInterface, strings.get(newRobHex > 0 ? "dialog.moverobber.to.hex" : "dialog.moverobber.to.hex.pirate"), strings.get(newRobHex > 0 ? "dialog.moverobber.are.you.sure" : "dialog.moverobber.are.you.sure.pirate"), strings.get(newRobHex > 0 ? "dialog.base.move.robber" : "dialog.base.move.pirate"), strings.get("dialog.moverobber.dont"), null, 2);
            this.pl = player;
            this.robHex = newRobHex;
        }

        @Override
        public void button1Chosen() {
            this.md.getGameMessageSender().moveRobber(SOCBoardPanel.this.game, this.pl, this.robHex);
            SOCBoardPanel.this.clearModeAndHilight(-1);
        }

        @Override
        public void button2Chosen() {
        }

        @Override
        public void windowCloseChosen() {
        }
    }

    protected class BoardPanelSendBuildTask
    extends TimerTask {
        protected int buildLoc;
        protected int pieceType;
        protected boolean wasSentAlready;

        protected BoardPanelSendBuildTask(int coord, int ptype) {
            this.buildLoc = coord;
            this.pieceType = ptype;
            this.wasSentAlready = false;
        }

        public int getBuildLoc() {
            return this.buildLoc;
        }

        public int getPieceType() {
            return this.pieceType;
        }

        @Override
        public void run() {
            if (Thread.currentThread().getName().startsWith("Thread-")) {
                try {
                    Thread.currentThread().setName("timertask-boardpanel");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.sendOnceFromClientIfCurrentPlayer();
        }

        public synchronized void doNotSend() {
            this.wasSentAlready = true;
        }

        public synchronized boolean wasItSentAlready() {
            return this.wasSentAlready;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendOnceFromClientIfCurrentPlayer() {
            BoardPanelSendBuildTask boardPanelSendBuildTask = this;
            synchronized (boardPanelSendBuildTask) {
                if (this.wasItSentAlready()) {
                    return;
                }
                this.doNotSend();
            }
            if (!SOCBoardPanel.this.playerInterface.isClientCurrentPlayer()) {
                return;
            }
            GameMessageSender messageSender = SOCBoardPanel.this.playerInterface.getClient().getGameMessageSender();
            switch (this.pieceType) {
                case 0: {
                    if (!SOCBoardPanel.this.player.isPotentialRoad(this.buildLoc)) break;
                    messageSender.putPiece(SOCBoardPanel.this.game, new SOCRoad(SOCBoardPanel.this.player, this.buildLoc, SOCBoardPanel.this.board));
                    break;
                }
                case 1: {
                    if (!SOCBoardPanel.this.player.canPlaceSettlement(this.buildLoc)) break;
                    messageSender.putPiece(SOCBoardPanel.this.game, new SOCSettlement(SOCBoardPanel.this.player, this.buildLoc, SOCBoardPanel.this.board));
                    break;
                }
                case 2: {
                    if (!SOCBoardPanel.this.player.isPotentialCity(this.buildLoc)) break;
                    messageSender.putPiece(SOCBoardPanel.this.game, new SOCCity(SOCBoardPanel.this.player, this.buildLoc, SOCBoardPanel.this.board));
                    break;
                }
                case 3: {
                    if (!SOCBoardPanel.this.game.canPlaceShip(SOCBoardPanel.this.player, this.buildLoc)) break;
                    messageSender.putPiece(SOCBoardPanel.this.game, new SOCShip(SOCBoardPanel.this.player, this.buildLoc, SOCBoardPanel.this.board));
                }
            }
            SOCBoardPanel.this.clearModeAndHilight(this.pieceType);
        }
    }

    static class ResourceTradeAllMenu
    extends SOCHandPanel.ResourceTradePopupMenu {
        private final SOCBoardPanel bpanel;
        private final SOCHandPanel.ResourceTradeTypeMenu[] tradeFromTypes;

        public ResourceTradeAllMenu(SOCBoardPanel bp, SOCHandPanel hp) throws IllegalStateException {
            super(hp, strings.get("board.trade.trade.port"));
            this.bpanel = bp;
            SOCPlayerInterface pi = hp.getPlayerInterface();
            if (!pi.isClientCurrentPlayer()) {
                throw new IllegalStateException("Not current player");
            }
            this.tradeFromTypes = new SOCHandPanel.ResourceTradeTypeMenu[5];
            for (int i = 0; i < 5; ++i) {
                this.tradeFromTypes[i] = new SOCHandPanel.ResourceTradeTypeMenu(hp, i + 1, true);
                this.add(this.tradeFromTypes[i]);
            }
        }

        @Override
        public void show(int x, int y) {
            this.setEnabledIfCanTrade(false);
            super.show(this.bpanel, x, y);
        }

        @Override
        public void setEnabledIfCanTrade(boolean itemsOnly) {
            int gs = this.hpan.getGame().getGameState();
            for (int i = 0; i < 5; ++i) {
                int numNeeded = this.tradeFromTypes[i].getResourceCost();
                this.tradeFromTypes[i].setEnabledIfCanTrade(itemsOnly);
                this.tradeFromTypes[i].setEnabledIfCanTrade(gs == 20 && numNeeded <= this.hpan.getPlayer().getResources().getAmount(i + 1));
            }
        }

        @Override
        public void destroy() {
            for (int i = 0; i < 5; ++i) {
                if (this.tradeFromTypes[i] == null) continue;
                SOCHandPanel.ResourceTradeTypeMenu mi = this.tradeFromTypes[i];
                this.tradeFromTypes[i] = null;
                mi.destroy();
            }
            this.removeAll();
            this.hpan = null;
        }
    }

    private class BoardPopupMenu
    extends PopupMenu
    implements ActionListener {
        final SOCBoardPanel bp;
        final MenuItem buildRoadItem;
        final MenuItem buildSettleItem;
        final MenuItem upgradeCityItem;
        final MenuItem buildShipItem;
        final MenuItem cancelBuildItem;
        SOCHandPanel.ResourceTradePopupMenu portTradeSubmenu;
        private boolean menuPlayerIsCurrent;
        private boolean wantsCancel;
        private boolean wantsUndo;
        private int cancelBuildType;
        private int hoverRoadID;
        private int hoverSettlementID;
        private int hoverCityID;
        private int hoverShipID;
        private boolean isShipMovable;
        protected boolean isInitialPlacement;

        public BoardPopupMenu(SOCBoardPanel bpanel) {
            super("JSettlers");
            this.bp = bpanel;
            this.buildRoadItem = new MenuItem(strings.get("board.build.road"));
            this.buildSettleItem = new MenuItem(strings.get("board.build.stlmt"));
            this.upgradeCityItem = new MenuItem(strings.get("board.build.upgrade.city"));
            this.buildShipItem = ((SOCBoardPanel)SOCBoardPanel.this).game.hasSeaBoard ? new MenuItem(strings.get("board.build.ship")) : null;
            this.cancelBuildItem = new MenuItem(strings.get("board.cancel.build"));
            this.portTradeSubmenu = null;
            this.add(this.buildRoadItem);
            this.add(this.buildSettleItem);
            this.add(this.upgradeCityItem);
            if (this.buildShipItem != null) {
                this.add(this.buildShipItem);
            }
            this.addSeparator();
            this.add(this.cancelBuildItem);
            this.buildRoadItem.addActionListener(this);
            this.buildSettleItem.addActionListener(this);
            this.upgradeCityItem.addActionListener(this);
            if (this.buildShipItem != null) {
                this.buildShipItem.addActionListener(this);
            }
            this.cancelBuildItem.addActionListener(this);
        }

        public void showCancelBuild(int buildType, int x, int y, int hilightAt) {
            boolean enableCancel;
            this.menuPlayerIsCurrent = SOCBoardPanel.this.player != null && SOCBoardPanel.this.playerInterface.isClientCurrentPlayer();
            this.wantsCancel = true;
            this.cancelBuildType = buildType;
            this.wantsUndo = false;
            this.hoverRoadID = 0;
            if (this.hoverSettlementID == -1) {
                this.buildSettleItem.setLabel(strings.get("board.build.stlmt"));
            }
            this.hoverSettlementID = 0;
            this.hoverCityID = 0;
            this.hoverShipID = 0;
            this.buildRoadItem.setEnabled(false);
            this.buildSettleItem.setEnabled(false);
            this.upgradeCityItem.setEnabled(false);
            if (this.buildShipItem != null) {
                if (SOCBoardPanel.this.mode == 17) {
                    boolean enable = hilightAt != 0 && hilightAt != SOCBoardPanel.this.moveShip_fromEdge;
                    this.buildShipItem.setEnabled(enable);
                    this.buildShipItem.setLabel(strings.get("board.build.move.ship"));
                    if (enable) {
                        SOCBoardPanel.this.moveShip_toEdge = hilightAt;
                    }
                } else {
                    this.buildShipItem.setEnabled(false);
                    this.buildShipItem.setLabel(strings.get("board.build.ship"));
                }
            }
            boolean bl = enableCancel = this.menuPlayerIsCurrent && SOCBoardPanel.this.game.canCancelBuildPiece(buildType);
            if (enableCancel && !((SOCBoardPanel)SOCBoardPanel.this).game.isPractice) {
                int gameState = SOCBoardPanel.this.game.getGameState();
                int sVersion = ((SOCBoardPanel)SOCBoardPanel.this).playerInterface.client.sVersion;
                if (gameState == 40 && sVersion < 2500 || gameState == 41 && sVersion < 1117) {
                    enableCancel = false;
                }
            }
            this.cancelBuildItem.setEnabled(enableCancel);
            this.isInitialPlacement = SOCBoardPanel.this.game.isInitialPlacement();
            switch (buildType) {
                case 0: {
                    this.cancelBuildItem.setLabel(strings.get("board.cancel.road"));
                    this.buildRoadItem.setEnabled(this.menuPlayerIsCurrent);
                    this.hoverRoadID = hilightAt;
                    break;
                }
                case 1: {
                    this.cancelBuildItem.setLabel(strings.get("board.cancel.stlmt"));
                    this.buildSettleItem.setEnabled(this.menuPlayerIsCurrent);
                    this.hoverSettlementID = hilightAt;
                    break;
                }
                case 2: {
                    this.cancelBuildItem.setLabel(strings.get("board.cancel.city.upgrade"));
                    this.upgradeCityItem.setEnabled(this.menuPlayerIsCurrent);
                    this.hoverCityID = hilightAt;
                    break;
                }
                case 3: {
                    if (SOCBoardPanel.this.mode == 17) {
                        this.cancelBuildItem.setLabel(strings.get("board.cancel.ship.move"));
                        this.cancelBuildItem.setEnabled(true);
                    } else {
                        this.cancelBuildItem.setLabel(strings.get("board.cancel.ship"));
                    }
                    this.hoverShipID = hilightAt;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("bad buildtype: " + buildType);
                }
            }
            super.show(this.bp, x, y);
        }

        public void showBuild(int x, int y, int hR, int hSe, int hC, int hSh) {
            this.wantsCancel = false;
            this.wantsUndo = false;
            this.isInitialPlacement = false;
            this.isShipMovable = false;
            this.cancelBuildItem.setEnabled(false);
            this.cancelBuildItem.setLabel(strings.get("board.cancel.build"));
            if (this.portTradeSubmenu != null) {
                this.remove(this.portTradeSubmenu);
                this.portTradeSubmenu.destroy();
                this.portTradeSubmenu = null;
            }
            if (this.hoverSettlementID == -1) {
                this.buildSettleItem.setLabel(strings.get("board.build.stlmt"));
            }
            boolean didEnableDisable = true;
            boolean bl = this.menuPlayerIsCurrent = SOCBoardPanel.this.player != null && SOCBoardPanel.this.playerInterface.isClientCurrentPlayer();
            if (this.menuPlayerIsCurrent) {
                GameAction lastAct;
                int gs = SOCBoardPanel.this.game.getGameState();
                if (SOCBoardPanel.this.game.isDebugFreePlacement() && SOCBoardPanel.this.game.isInitialPlacement()) {
                    switch (SOCBoardPanel.this.player.getPieces().size()) {
                        case 0: 
                        case 2: {
                            gs = 5;
                            break;
                        }
                        case 1: 
                        case 3: {
                            gs = 6;
                            break;
                        }
                        default: {
                            gs = 20;
                        }
                    }
                }
                boolean currentCanCancelConvertToWarship = gs == 15 || gs == 20 ? (lastAct = SOCBoardPanel.this.game.getLastAction()) != null && lastAct.actType == GameAction.ActionType.SHIP_CONVERT_TO_WARSHIP && ((SOCBoardPanel)SOCBoardPanel.this).playerInterface.client.getServerVersion(SOCBoardPanel.this.game) >= 2700 : false;
                switch (gs) {
                    case 5: 
                    case 10: 
                    case 12: {
                        this.isInitialPlacement = true;
                        this.buildRoadItem.setEnabled(false);
                        this.buildSettleItem.setEnabled(hSe != 0);
                        this.upgradeCityItem.setEnabled(false);
                        if (this.buildShipItem == null) break;
                        this.buildShipItem.setEnabled(false);
                        break;
                    }
                    case 6: 
                    case 11: 
                    case 13: {
                        this.isInitialPlacement = true;
                        this.buildRoadItem.setEnabled(hR != 0);
                        this.buildSettleItem.setEnabled(false);
                        this.upgradeCityItem.setEnabled(false);
                        if (this.buildShipItem != null) {
                            this.buildShipItem.setEnabled(hSh != 0);
                        }
                        if (SOCBoardPanel.this.game.isDebugFreePlacement()) break;
                        this.cancelBuildItem.setLabel(strings.get("board.cancel.stlmt"));
                        this.cancelBuildItem.setEnabled(true);
                        this.cancelBuildType = 1;
                        break;
                    }
                    case 40: 
                    case 41: {
                        if (((SOCBoardPanel)SOCBoardPanel.this).game.isPractice || gs == 40 && ((SOCBoardPanel)SOCBoardPanel.this).playerInterface.client.sVersion >= 2500 || gs == 41 && ((SOCBoardPanel)SOCBoardPanel.this).playerInterface.client.sVersion >= 1117) {
                            this.cancelBuildItem.setEnabled(true);
                            this.cancelBuildItem.setLabel(strings.get("board.build.skip.road.ship"));
                        }
                        this.buildRoadItem.setEnabled(hR != 0);
                        this.buildSettleItem.setEnabled(false);
                        this.upgradeCityItem.setEnabled(false);
                        if (this.buildShipItem == null) break;
                        this.buildShipItem.setEnabled(hSh != 0);
                        break;
                    }
                    default: {
                        didEnableDisable = false;
                        if (gs < 20) {
                            this.menuPlayerIsCurrent = false;
                        } else if (gs == 20 || gs == 100) {
                            SOCPlayingPiece latest = this.bp.latestPiecePlacement;
                            GameAction act = SOCBoardPanel.this.game.getLastAction();
                            if (latest != null && act != null) {
                                if (act.actType == GameAction.ActionType.MOVE_PIECE && latest instanceof SOCShip && SOCBoardPanel.this.game.canUndoMoveShip(SOCBoardPanel.this.playerNumber, (SOCShip)latest)) {
                                    int[] xyb = SOCBoardPanel.this.rotateScaleXYFromActual(x, y);
                                    int edgeCoord = SOCBoardPanel.this.findEdge(xyb[0], xyb[1], false);
                                    if (SOCBoardPanel.this.board.isEdgeSameOrAdjacent(edgeCoord, latest.getCoordinates())) {
                                        this.wantsUndo = true;
                                        this.cancelBuildItem.setEnabled(true);
                                        this.cancelBuildItem.setLabel(strings.get("board.undo.move.ship"));
                                        this.cancelBuildType = 3;
                                    }
                                } else if (act.actType == GameAction.ActionType.BUILD_PIECE && SOCBoardPanel.this.game.canUndoPutPiece(SOCBoardPanel.this.playerNumber, latest)) {
                                    int[] xyb;
                                    int coord = 0;
                                    boolean isSameCoord = false;
                                    if (latest instanceof SOCRoutePiece) {
                                        xyb = SOCBoardPanel.this.rotateScaleXYFromActual(x, y);
                                        coord = SOCBoardPanel.this.findEdge(xyb[0], xyb[1], false);
                                        isSameCoord = SOCBoardPanel.this.board.isEdgeSameOrAdjacent(coord, latest.getCoordinates());
                                    } else if (latest instanceof SOCSettlement || latest instanceof SOCCity) {
                                        xyb = SOCBoardPanel.this.rotateScaleXYFromActual(x, y);
                                        coord = SOCBoardPanel.this.findNode(xyb[0], xyb[1]);
                                        isSameCoord = SOCBoardPanel.this.board.isNodeSameOrAdjacent(coord, latest.getCoordinates());
                                    }
                                    if (isSameCoord) {
                                        String key;
                                        this.wantsUndo = true;
                                        this.cancelBuildItem.setEnabled(true);
                                        this.cancelBuildType = latest.getType();
                                        switch (this.cancelBuildType) {
                                            case 0: {
                                                key = "board.undo.build.road";
                                                break;
                                            }
                                            case 1: {
                                                key = "board.undo.build.stlmt";
                                                break;
                                            }
                                            case 3: {
                                                key = "board.undo.build.ship";
                                                break;
                                            }
                                            default: {
                                                key = "board.undo.build.city.upgrade";
                                            }
                                        }
                                        this.cancelBuildItem.setLabel(strings.get(key));
                                    }
                                }
                            }
                            if (!this.wantsUndo && !currentCanCancelConvertToWarship && act != null && act.cannotUndoReason != null) {
                                this.wantsUndo = true;
                                this.cancelBuildItem.setEnabled(true);
                                this.cancelBuildType = 0;
                                this.cancelBuildItem.setLabel(strings.get("board.undo.cannot"));
                            }
                        }
                        if (this.wantsUndo || !currentCanCancelConvertToWarship) break;
                        this.wantsCancel = true;
                        this.cancelBuildItem.setEnabled(true);
                        this.cancelBuildType = -2;
                        this.cancelBuildItem.setLabel("Cancel convert Ship to Warship");
                    }
                }
            }
            if (!this.menuPlayerIsCurrent) {
                this.buildRoadItem.setEnabled(false);
                this.buildSettleItem.setEnabled(false);
                this.upgradeCityItem.setEnabled(false);
                if (this.buildShipItem != null) {
                    this.buildShipItem.setEnabled(false);
                    this.buildShipItem.setLabel(strings.get("board.build.ship"));
                }
                this.hoverRoadID = 0;
                if (this.hoverSettlementID == -1) {
                    this.buildSettleItem.setLabel(strings.get("board.build.stlmt"));
                }
                this.hoverSettlementID = 0;
                this.hoverCityID = 0;
                this.hoverShipID = 0;
            } else {
                boolean debugPP;
                int cpn = SOCBoardPanel.this.game.getCurrentPlayerNumber();
                if (!(this.isInitialPlacement || !(debugPP = SOCBoardPanel.this.game.isDebugFreePlacement()) && didEnableDisable)) {
                    this.buildRoadItem.setEnabled(SOCBoardPanel.this.player.isPotentialRoad(hR) && (debugPP ? SOCBoardPanel.this.player.getNumPieces(0) > 0 : SOCBoardPanel.this.game.couldBuildRoad(cpn)));
                    this.buildSettleItem.setEnabled(SOCBoardPanel.this.player.canPlaceSettlement(hSe) && (debugPP ? SOCBoardPanel.this.player.getNumPieces(1) > 0 : SOCBoardPanel.this.game.couldBuildSettlement(cpn)));
                    this.upgradeCityItem.setEnabled(SOCBoardPanel.this.player.isPotentialCity(hC) && (debugPP ? SOCBoardPanel.this.player.getNumPieces(2) > 0 : SOCBoardPanel.this.game.couldBuildCity(cpn)));
                    if (this.buildShipItem != null) {
                        boolean bl2 = this.isShipMovable = hSh < 0;
                        if (this.isShipMovable) {
                            hSh = -hSh;
                            this.buildShipItem.setLabel(strings.get("board.build.move.ship"));
                            this.buildShipItem.setEnabled(true);
                        } else {
                            this.buildShipItem.setLabel(strings.get("board.build.ship"));
                            this.buildShipItem.setEnabled(SOCBoardPanel.this.game.canPlaceShip(SOCBoardPanel.this.player, hSh) && (debugPP ? SOCBoardPanel.this.player.getNumPieces(3) > 0 : SOCBoardPanel.this.game.couldBuildShip(cpn)));
                        }
                    }
                }
                this.hoverRoadID = hR;
                this.hoverSettlementID = hSe;
                this.hoverCityID = hC;
                this.hoverShipID = hSh;
                int portType = -1;
                int portId = 0;
                if (hSe != 0) {
                    portId = hSe;
                } else if (hC != 0) {
                    portId = hC;
                } else if (((SOCBoardPanel)this.bp).hoverTip.hoverIsPort) {
                    portId = this.bp.hoverTip.hoverID;
                }
                if (portId != 0) {
                    portType = SOCBoardPanel.this.board.getPortTypeFromNodeCoord(portId);
                }
                if (portType != -1) {
                    this.portTradeSubmenu = portType == 0 ? new ResourceTradeAllMenu(this.bp, SOCBoardPanel.this.playerInterface.getPlayerHandPanel(cpn)) : new SOCHandPanel.ResourceTradeTypeMenu(SOCBoardPanel.this.playerInterface.getPlayerHandPanel(cpn), portType, false);
                    this.add(this.portTradeSubmenu);
                    this.portTradeSubmenu.setEnabledIfCanTrade(true);
                }
            }
            super.show(this.bp, x, y);
        }

        public void showAtPirateFortress(int x, int y, SOCFortress ft) {
            boolean settleItemWasFortress = this.hoverSettlementID == -1;
            this.menuPlayerIsCurrent = SOCBoardPanel.this.player != null && SOCBoardPanel.this.playerInterface.isClientCurrentPlayer();
            this.wantsCancel = false;
            this.cancelBuildType = 0;
            this.wantsUndo = false;
            this.hoverRoadID = 0;
            this.hoverSettlementID = ft != null ? -1 : 0;
            this.hoverCityID = 0;
            this.hoverShipID = 0;
            this.buildRoadItem.setEnabled(false);
            if (this.hoverSettlementID == -1) {
                this.buildSettleItem.setLabel(strings.get("board.build.sc_piri.attack.fortress"));
                this.buildSettleItem.setEnabled(this.menuPlayerIsCurrent && ft.getPlayerNumber() == SOCBoardPanel.this.playerNumber && SOCBoardPanel.this.game.canAttackPirateFortress() != null);
            } else if (settleItemWasFortress) {
                this.buildSettleItem.setLabel(strings.get("board.build.stlmt"));
                this.buildSettleItem.setEnabled(false);
            }
            this.upgradeCityItem.setEnabled(false);
            this.buildShipItem.setEnabled(false);
            this.cancelBuildItem.setEnabled(false);
            this.isInitialPlacement = false;
            super.show(this.bp, x, y);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SOCBoardPanel.this.playerInterface.isClientCurrentPlayer()) {
                return;
            }
            Object target = e.getSource();
            if (!this.menuPlayerIsCurrent && target != this.cancelBuildItem) {
                return;
            }
            if (target == this.buildRoadItem) {
                this.tryBuild(0);
            } else if (target == this.buildSettleItem) {
                if (this.hoverSettlementID != -1) {
                    this.tryBuild(1);
                } else {
                    this.confirmAttackPirateFortress();
                }
            } else if (target == this.upgradeCityItem) {
                this.tryBuild(2);
            } else if (target == this.buildShipItem && target != null) {
                if (SOCBoardPanel.this.mode == 17) {
                    SOCBoardPanel.this.tryMoveShipToEdge();
                } else if (this.isShipMovable) {
                    this.tryMoveShipFromHere();
                } else if (SOCBoardPanel.this.game.isGameOptionSet("_SC_FTRI") && ((SOCBoardLarge)SOCBoardPanel.this.board).canRemovePort(this.hoverShipID)) {
                    EventQueue.invokeLater(new ConfirmPlaceShipDialog(this.hoverShipID, true, -1));
                } else {
                    this.tryBuild(3);
                }
            } else if (target == this.cancelBuildItem) {
                if (this.wantsUndo && this.menuPlayerIsCurrent) {
                    this.tryUndo();
                } else {
                    this.tryCancel();
                }
            }
        }

        void tryBuild(int ptype) {
            String btarget;
            boolean canBuild;
            int buildLoc;
            boolean debugPP = SOCBoardPanel.this.game.isDebugFreePlacement();
            int cpn = debugPP ? SOCBoardPanel.this.playerNumber : SOCBoardPanel.this.playerInterface.getClientPlayerNumber();
            int gstate = SOCBoardPanel.this.game.getGameState();
            boolean sendNow = this.isInitialPlacement || this.wantsCancel || debugPP || gstate == 40 || gstate == 41 || (gstate == 20 || gstate == 100) && (((SOCBoardPanel)SOCBoardPanel.this).game.isPractice || ((SOCBoardPanel)SOCBoardPanel.this).playerInterface.client.sVersion >= 2000);
            GameMessageSender messageSender = sendNow ? SOCBoardPanel.this.playerInterface.getClient().getGameMessageSender() : null;
            switch (ptype) {
                case 0: {
                    buildLoc = this.hoverRoadID;
                    if (buildLoc == -1) {
                        buildLoc = 0;
                    }
                    canBuild = SOCBoardPanel.this.player.isPotentialRoad(buildLoc);
                    if (!sendNow) {
                        boolean bl = canBuild = canBuild && SOCBoardPanel.this.game.couldBuildRoad(cpn);
                    }
                    if (canBuild && sendNow) {
                        messageSender.putPiece(SOCBoardPanel.this.game, new SOCRoad(SOCBoardPanel.this.player, buildLoc, SOCBoardPanel.this.board));
                    }
                    btarget = "road";
                    break;
                }
                case 1: {
                    buildLoc = this.hoverSettlementID;
                    canBuild = SOCBoardPanel.this.player.canPlaceSettlement(buildLoc);
                    if (!sendNow) {
                        boolean bl = canBuild = canBuild && SOCBoardPanel.this.game.couldBuildSettlement(cpn);
                    }
                    if (canBuild && sendNow) {
                        messageSender.putPiece(SOCBoardPanel.this.game, new SOCSettlement(SOCBoardPanel.this.player, buildLoc, SOCBoardPanel.this.board));
                        if (this.isInitialPlacement) {
                            SOCBoardPanel.this.initSettlementNode = buildLoc;
                        }
                    }
                    btarget = "stlmt";
                    break;
                }
                case 2: {
                    buildLoc = this.hoverCityID;
                    canBuild = SOCBoardPanel.this.player.isPotentialCity(buildLoc);
                    if (!sendNow) {
                        boolean bl = canBuild = canBuild && SOCBoardPanel.this.game.couldBuildCity(cpn);
                    }
                    if (canBuild && sendNow) {
                        messageSender.putPiece(SOCBoardPanel.this.game, new SOCCity(SOCBoardPanel.this.player, buildLoc, SOCBoardPanel.this.board));
                    }
                    btarget = "city";
                    break;
                }
                case 3: {
                    buildLoc = this.hoverShipID;
                    canBuild = SOCBoardPanel.this.game.canPlaceShip(SOCBoardPanel.this.player, buildLoc);
                    if (!sendNow) {
                        boolean bl = canBuild = canBuild && SOCBoardPanel.this.game.couldBuildShip(cpn);
                    }
                    if (canBuild && sendNow) {
                        messageSender.putPiece(SOCBoardPanel.this.game, new SOCShip(SOCBoardPanel.this.player, buildLoc, SOCBoardPanel.this.board));
                    }
                    btarget = "ship";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad build type: " + ptype);
                }
            }
            if (!canBuild) {
                SOCBoardPanel.this.playerInterface.printKeyed("board.msg.cannot.build.there");
                return;
            }
            if (sendNow) {
                SOCBoardPanel.this.clearModeAndHilight(ptype);
                return;
            }
            SOCBoardPanel.this.popupSetBuildRequest(buildLoc, ptype);
            SOCBoardPanel.this.playerInterface.getBuildingPanel().clickBuildingButton(SOCBoardPanel.this.game, btarget, true);
        }

        public void confirmAttackPirateFortress() {
            SOCBoardPanel.this.hoverTip.setHoverText_modeChangedOrMouseMoved = true;
            SOCBoardPanel.this.hoverTip.setHoverText(null, 0);
            EventQueue.invokeLater(new ConfirmAttackPirateFortressDialog());
        }

        public void tryAttackPirateFortress() {
            if (SOCBoardPanel.this.game.canAttackPirateFortress() != null) {
                SOCBoardPanel.this.playerInterface.getClient().getGameMessageSender().sendSimpleRequest(SOCBoardPanel.this.player, 1000);
            } else {
                SOCBoardPanel.this.playerInterface.getClientListener().scen_SC_PIRI_pirateFortressAttackResult(true, 0, 0);
            }
        }

        void tryCancel() {
            if (SOCBoardPanel.this.mode == 17) {
                SOCBoardPanel.this.clearModeAndHilight(3);
                SOCBoardPanel.this.playerInterface.printKeyed("board.msg.canceled.move.ship");
                return;
            }
            String btarget = null;
            switch (this.cancelBuildType) {
                case 0: {
                    btarget = "road";
                    break;
                }
                case 1: {
                    btarget = "stlmt";
                    break;
                }
                case 2: {
                    btarget = "city";
                    break;
                }
                case 3: {
                    btarget = "ship";
                    break;
                }
                case -2: {
                    SOCBoardPanel.this.playerInterface.getClient().getGameMessageSender().cancelBuildRequest(SOCBoardPanel.this.game, -2);
                    return;
                }
            }
            SOCBoardPanel.this.playerInterface.getBuildingPanel().clickBuildingButton(SOCBoardPanel.this.game, btarget, false);
        }

        void tryUndo() {
            GameAction act = SOCBoardPanel.this.game.getLastAction();
            if (act == null) {
                return;
            }
            if (act.cannotUndoReason != null) {
                StringBuilder reasonText = new StringBuilder("\n");
                if (act.cannotUndoReason.equals("?")) {
                    reasonText.append(strings.get("board.popup.cannot_undo"));
                } else {
                    reasonText.append(strings.get("board.popup.cannot_undo.reason", act.cannotUndoReason));
                }
                NotifyDialog.createAndShow(SOCBoardPanel.this.playerInterface.getMainDisplay(), SOCBoardPanel.this.playerInterface, reasonText.toString(), null, true);
                return;
            }
            if (this.bp.latestPiecePlacement == null) {
                return;
            }
            SOCBoardPanel.this.playerInterface.getClient().getGameMessageSender().undoPutOrMovePieceRequest(SOCBoardPanel.this.game, SOCBoardPanel.this.latestPiecePlacement.getType(), SOCBoardPanel.this.latestPiecePlacement.getCoordinates(), act.actType == GameAction.ActionType.MOVE_PIECE ? act.param2 : 0);
        }

        private void tryMoveShipFromHere() {
            SOCBoardPanel.this.playerInterface.printKeyed("board.msg.click.ship.new.loc");
            SOCBoardPanel.this.moveShip_fromEdge = this.hoverShipID;
            SOCBoardPanel.this.moveShip_toEdge = 0;
            SOCBoardPanel.this.moveShip_isWarship = SOCBoardPanel.this.hoverTip.hoverIsWarship;
            SOCBoardPanel.this.mode = 17;
            SOCBoardPanel.this.hilight = 0;
            SOCBoardPanel.this.hoverTip.hideHoverAndPieces();
        }
    }

    protected class BoardToolTip {
        private final SOCBoardPanel bpanel;
        private String hoverText;
        private int hoverMode;
        private int hoverID;
        private SOCPlayingPiece hoverPiece;
        int hoverRoadID;
        int hoverSettlementID;
        int hoverCityID;
        int hoverShipID;
        boolean hoverIsPort;
        private boolean hoverIsShipMovable;
        private boolean hoverIsWarship;
        private int mouseX;
        private int mouseY;
        private boolean setHoverText_modeChangedOrMouseMoved;
        private int boxX;
        private int boxY;
        private int offsetX;
        private int boxW;
        private int boxH;
        private final int TEXT_INSET = 3;
        private final int PADDING_HORIZ = 8;

        BoardToolTip(SOCBoardPanel ourBoardPanel) {
            this.bpanel = ourBoardPanel;
            this.hoverText = null;
            this.hoverMode = 0;
            this.hoverID = 0;
            this.hoverPiece = null;
            this.hoverRoadID = 0;
            this.hoverSettlementID = 0;
            this.hoverCityID = 0;
            this.hoverShipID = 0;
            this.hoverIsPort = false;
            this.hoverIsShipMovable = false;
            this.mouseX = 0;
            this.mouseY = 0;
            this.offsetX = 0;
            this.boxW = 0;
        }

        public String getHoverText() {
            return this.hoverText;
        }

        public boolean isVisible() {
            return this.hoverText != null || this.hoverRoadID != 0 || this.hoverSettlementID != 0 || this.hoverCityID != 0 || this.hoverShipID != 0;
        }

        public void positionToMouse(int x, int y) {
            this.mouseX = x;
            this.mouseY = y;
            this.boxX = this.mouseX + this.offsetX;
            this.boxY = this.mouseY;
            if (this.offsetX < 5) {
                this.boxY += 12;
            }
            if (SOCBoardPanel.this.panelMinBW < this.boxX + this.boxW) {
                this.boxX = this.mouseX - this.boxW - this.offsetX;
                if (this.boxX < 0) {
                    this.boxX = SOCBoardPanel.this.panelMinBW - this.boxW;
                }
            }
            this.bpanel.repaint();
            this.setHoverText_modeChangedOrMouseMoved = false;
        }

        public void setOffsetX(int ofsX) {
            this.offsetX = ofsX;
        }

        public void setHoverText(String t, int coord) {
            if (t != null && coord >= 0 && SOCBoardPanel.this.debugShowCoordsTooltip) {
                t = t.length() > 0 ? t + " - 0x" + Integer.toHexString(coord) : "0x" + Integer.toHexString(coord);
            }
            if ((t == this.hoverText || t != null && t.equals(this.hoverText)) && !this.setHoverText_modeChangedOrMouseMoved) {
                return;
            }
            this.hoverText = t;
            if (t == null) {
                this.bpanel.repaint();
                this.setHoverText_modeChangedOrMouseMoved = false;
                return;
            }
            this.boxW = 0;
            this.positionToMouse(this.mouseX, this.mouseY);
        }

        public void setHoverText(String t, int coord, int x, int y) {
            this.positionToMouse(x, y);
            this.setHoverText(t, coord);
        }

        public void hideHoverAndPieces() {
            this.hoverRoadID = 0;
            this.hoverSettlementID = 0;
            this.hoverCityID = 0;
            this.hoverShipID = 0;
            this.hoverIsPort = false;
            this.hoverIsShipMovable = false;
            this.hoverIsWarship = false;
            this.hoverText = null;
            this.setHoverText_modeChangedOrMouseMoved = false;
            this.bpanel.repaint();
        }

        public void paint(Graphics g) {
            String ht;
            if (SOCBoardPanel.this.playerNumber != -1) {
                boolean xlat;
                boolean bl = xlat = SOCBoardPanel.this.panelMarginX != 0 || SOCBoardPanel.this.panelMarginY != 0;
                if (xlat) {
                    g.translate(SOCBoardPanel.this.panelMarginX, SOCBoardPanel.this.panelMarginY);
                }
                if (this.hoverRoadID != 0) {
                    if (!this.hoverIsShipMovable) {
                        SOCBoardPanel.this.drawRoadOrShip(g, this.hoverRoadID, SOCBoardPanel.this.playerNumber, HilightStyle.HOVER, true, false);
                    } else {
                        SOCBoardPanel.this.drawRoadOrShip(g, this.hoverRoadID, -1, HilightStyle.HOVER, true, false);
                    }
                }
                if (this.hoverShipID != 0) {
                    SOCBoardPanel.this.drawRoadOrShip(g, this.hoverShipID, SOCBoardPanel.this.playerNumber, HilightStyle.HOVER, false, this.hoverIsWarship);
                }
                if (this.hoverSettlementID != 0) {
                    SOCBoardPanel.this.drawSettlement(g, this.hoverSettlementID, SOCBoardPanel.this.playerNumber, HilightStyle.HOVER, false);
                }
                if (this.hoverCityID != 0) {
                    SOCBoardPanel.this.drawCity(g, this.hoverCityID, SOCBoardPanel.this.playerNumber, HilightStyle.HOVER);
                }
                if (xlat) {
                    g.translate(-SOCBoardPanel.this.panelMarginX, -SOCBoardPanel.this.panelMarginY);
                }
            }
            if ((ht = this.hoverText) == null) {
                return;
            }
            if (this.boxW == 0) {
                int bpheight;
                Font bpf = this.bpanel.getFont();
                if (bpf == null) {
                    return;
                }
                FontMetrics fm = g.getFontMetrics(bpf);
                if (fm == null) {
                    return;
                }
                this.boxW = fm.stringWidth(ht.replace(' ', '-')) + 8;
                this.boxH = fm.getHeight();
                int bpwidth = this.bpanel.getWidth();
                if (this.boxX + this.boxW > bpwidth) {
                    this.boxX = bpwidth - this.boxW - 2;
                }
                if (this.boxY + this.boxH > (bpheight = this.bpanel.getHeight())) {
                    this.boxY = bpheight - this.boxH - 2;
                }
            }
            g.setColor(Color.WHITE);
            g.fillRect(this.boxX, this.boxY, this.boxW, this.boxH - 1);
            g.setColor(Color.BLACK);
            g.drawRect(this.boxX, this.boxY, this.boxW, this.boxH - 1);
            g.setFont(this.bpanel.getFont());
            g.drawString(ht, this.boxX + 3, this.boxY + this.boxH - 3);
        }

        private void handleHover(int x, int y, int xb, int yb) {
            if (x != this.mouseX || y != this.mouseY) {
                this.mouseX = x;
                this.mouseY = y;
                this.setHoverText_modeChangedOrMouseMoved = true;
            }
            boolean modeAllowsHoverPieces = SOCBoardPanel.this.mode != 5 && SOCBoardPanel.this.mode != 6 && SOCBoardPanel.this.mode != 4 && SOCBoardPanel.this.mode != 18 && SOCBoardPanel.this.mode != 97 && SOCBoardPanel.this.mode != 99;
            boolean debugPP = SOCBoardPanel.this.game.isDebugFreePlacement();
            boolean playerIsCurrent = SOCBoardPanel.this.player != null && (debugPP || SOCBoardPanel.this.playerInterface.isClientCurrentPlayer());
            boolean hoverTextSet = false;
            int nodePortCoord = -1;
            int nodePortType = -1;
            if (!modeAllowsHoverPieces) {
                this.hoverRoadID = 0;
                this.hoverSettlementID = 0;
                this.hoverCityID = 0;
                this.hoverShipID = 0;
            }
            try {
                int id = SOCBoardPanel.this.findNode(xb, yb);
                if (id > 0) {
                    if (this.hoverMode == 2 && this.hoverID == id) {
                        this.positionToMouse(x, y);
                        return;
                    }
                    SOCPlayingPiece p = SOCBoardPanel.this.board.settlementAtNode(id);
                    if (p == null) {
                        p = SOCBoardPanel.this.game.getFortress(id);
                    }
                    if (p != null) {
                        this.hoverMode = 2;
                        this.hoverPiece = p;
                        this.hoverID = id;
                        StringBuffer sb = new StringBuffer();
                        String pieceExtraDesc = null;
                        String portDesc = this.portDescAtNode(id);
                        if (portDesc != null) {
                            sb.append(portDesc);
                            if (p.getType() == 2) {
                                sb.append(".city");
                            } else {
                                sb.append(".stlmt");
                            }
                            this.hoverIsPort = true;
                        } else if (p.getType() == 2) {
                            sb.append("board.city");
                        } else {
                            sb.append("board.stlmt");
                        }
                        String plName = p.getPlayer().getName();
                        if (plName == null) {
                            plName = strings.get("board.unowned");
                        }
                        if (p instanceof SOCFortress) {
                            sb.setLength(0);
                            sb.append("board.sc_piri.piratefortress");
                            if (SOCBoardPanel.this.player != null && SOCBoardPanel.this.player == p.getPlayer()) {
                                pieceExtraDesc = SOCBoardPanel.this.game.canAttackPirateFortress(SOCBoardPanel.this.player, true) != null ? (SOCPlayerClient.IS_PLATFORM_MAC_OSX ? "board.sc_piri.pf_extra.attack.osx" : "board.sc_piri.pf_extra.attack") : "board.sc_piri.pf_extra.build";
                                pieceExtraDesc = strings.get(pieceExtraDesc);
                            }
                        }
                        if (pieceExtraDesc == null) {
                            pieceExtraDesc = "";
                        }
                        String htext = strings.get(sb.toString(), plName, SOCBoardPanel.this.board.getPortTypeFromNodeCoord(id), pieceExtraDesc);
                        if (p == SOCBoardPanel.this.latestPiecePlacement) {
                            htext = htext + " " + strings.get("board.most_recent_placement");
                        }
                        this.setHoverText(htext, id);
                        hoverTextSet = true;
                        this.hoverCityID = modeAllowsHoverPieces && playerIsCurrent && p.getPlayer() == SOCBoardPanel.this.player && p.getType() == 1 && SOCBoardPanel.this.player.isPotentialCity(id) && SOCBoardPanel.this.player.getNumPieces(2) > 0 && (debugPP || SOCBoardPanel.this.player.getResources().contains(SOCCity.COST)) ? id : 0;
                        this.hoverSettlementID = 0;
                    } else {
                        SOCVillage vi;
                        this.hoverSettlementID = 0;
                        if (SOCBoardPanel.this.game.isGameOptionSet("_SC_CLVI") && (vi = ((SOCBoardLarge)SOCBoardPanel.this.board).getVillageAtNode(id)) != null) {
                            this.hoverMode = 4;
                            this.hoverID = id;
                            this.hoverIsPort = false;
                            hoverTextSet = true;
                            this.hoverCityID = 0;
                            this.setHoverText(strings.get("board.sc_clvi.village", vi.diceNum, vi.getCloth()), id);
                        }
                        if (playerIsCurrent && !hoverTextSet) {
                            this.hoverCityID = 0;
                            if (modeAllowsHoverPieces && SOCBoardPanel.this.player.getNumPieces(1) > 0 && (debugPP || SOCBoardPanel.this.player.getResources().contains(SOCSettlement.COST))) {
                                if (SOCBoardPanel.this.player.canPlaceSettlement(id)) {
                                    this.hoverSettlementID = id;
                                } else if (SOCBoardPanel.this.player.isPotentialSettlement(id)) {
                                    this.setHoverText(strings.get("board.settle.not.here"), id);
                                    this.hoverMode = 4;
                                    this.hoverID = id;
                                    this.hoverIsPort = false;
                                    hoverTextSet = true;
                                }
                            }
                        }
                        if (playerIsCurrent && ((SOCBoardPanel)SOCBoardPanel.this).game.hasSeaBoard && !hoverTextSet) {
                            String htext = null;
                            int[] ls = ((SOCBoardLarge)SOCBoardPanel.this.board).getAddedLayoutPart("LS");
                            if (ls != null) {
                                for (int i = ls.length - 1; i >= 0; --i) {
                                    if (id != ls[i]) continue;
                                    if (SOCBoardPanel.this.game.isInitialPlacement()) {
                                        htext = "board.sc_piri.lone.stlmt.after";
                                        break;
                                    }
                                    htext = "board.sc_piri.lone.stlmt";
                                    break;
                                }
                            }
                            if (htext == null && SOCBoardPanel.this.game.isInitialPlacement() && SOCBoardPanel.this.player.isLegalSettlement(id) && !SOCBoardPanel.this.player.isPotentialSettlement(id)) {
                                htext = "board.initial.not.here";
                            }
                            if (htext != null) {
                                this.setHoverText(strings.get(htext), id);
                                this.hoverMode = 4;
                                this.hoverID = id;
                                this.hoverIsPort = false;
                                hoverTextSet = true;
                            }
                        }
                        if (!hoverTextSet && (nodePortType = SOCBoardPanel.this.board.getPortTypeFromNodeCoord(id)) != -1) {
                            nodePortCoord = id;
                        }
                        if (!hoverTextSet && ((SOCBoardPanel)SOCBoardPanel.this).game.hasSeaBoard && SOCBoardPanel.this.game.isGameOptionSet("_SC_WOND")) {
                            int i = 1;
                            int[] nlist = ((SOCBoardLarge)SOCBoardPanel.this.board).getAddedLayoutPart("N1");
                            while (nlist != null && !hoverTextSet) {
                                for (int j = 0; j < nlist.length; ++j) {
                                    if (nlist[j] != id) continue;
                                    String nlDesc = null;
                                    try {
                                        nlDesc = strings.get("board.nodelist._SC_WOND.N" + i);
                                    }
                                    catch (MissingResourceException htext) {
                                        // empty catch block
                                    }
                                    if (nlDesc == null) {
                                        try {
                                            nlDesc = strings.get("board.nodelist.no_desc", i);
                                        }
                                        catch (MissingResourceException htext) {
                                            // empty catch block
                                        }
                                    }
                                    if (nlDesc == null) continue;
                                    this.setHoverText(nlDesc, id);
                                    this.hoverMode = 4;
                                    this.hoverID = id;
                                    this.hoverIsPort = false;
                                    hoverTextSet = true;
                                    break;
                                }
                                nlist = ((SOCBoardLarge)SOCBoardPanel.this.board).getAddedLayoutPart("N" + ++i);
                            }
                        }
                    }
                } else {
                    this.hoverSettlementID = 0;
                    this.hoverCityID = 0;
                }
                if ((id = SOCBoardPanel.this.findEdge(xb, yb, false)) != 0) {
                    if (this.hoverID == id && (this.hoverMode == 1 || this.hoverMode == 15)) {
                        this.positionToMouse(x, y);
                        return;
                    }
                    this.hoverRoadID = 0;
                    this.hoverShipID = 0;
                    this.hoverIsShipMovable = false;
                    this.hoverIsWarship = false;
                    SOCRoutePiece rs = SOCBoardPanel.this.board.roadOrShipAtEdge(id);
                    if (rs != null) {
                        if (!hoverTextSet) {
                            String htext;
                            boolean isRoad = rs.isRoadNotShip();
                            this.hoverMode = isRoad ? 1 : 15;
                            this.hoverPiece = rs;
                            this.hoverID = id;
                            String plName = rs.getPlayer().getName();
                            if (plName == null) {
                                plName = strings.get("board.unowned");
                            }
                            if (isRoad) {
                                htext = strings.get("board.road", plName);
                            } else {
                                this.hoverIsWarship = rs instanceof SOCShip && SOCBoardPanel.this.game.isShipWarship((SOCShip)rs);
                                htext = this.hoverIsWarship ? strings.get("board.warship", plName) : strings.get("board.ship", plName);
                            }
                            if (rs == SOCBoardPanel.this.latestPiecePlacement) {
                                htext = htext + ' ' + strings.get("board.most_recent_placement");
                            }
                            this.setHoverText(htext, id);
                            if (modeAllowsHoverPieces && playerIsCurrent && !isRoad && rs.getPlayer() == SOCBoardPanel.this.player && SOCBoardPanel.this.game.canMoveShip(SOCBoardPanel.this.playerNumber, this.hoverID) != null) {
                                this.hoverIsShipMovable = true;
                                this.hoverShipID = id;
                            }
                        }
                        return;
                    }
                    if (playerIsCurrent && modeAllowsHoverPieces) {
                        boolean canPlaceShip = SOCBoardPanel.this.game.canPlaceShip(SOCBoardPanel.this.player, id);
                        boolean isShip = false;
                        if (SOCBoardPanel.this.isLargeBoard) {
                            if (SOCBoardPanel.this.player.isPotentialRoad(id) && ((SOCBoardLarge)SOCBoardPanel.this.board).isEdgeCoastline(id)) {
                                id = SOCBoardPanel.this.findEdge(xb, yb, true);
                                if (id < 0) {
                                    id = -id;
                                    isShip = canPlaceShip;
                                }
                            } else {
                                isShip = canPlaceShip;
                            }
                        }
                        if (!isShip && SOCBoardPanel.this.player.isPotentialRoad(id) && SOCBoardPanel.this.player.getNumPieces(0) > 0 && (debugPP || SOCBoardPanel.this.player.getResources().contains(SOCRoad.COST))) {
                            this.hoverRoadID = id;
                        } else if (canPlaceShip && SOCBoardPanel.this.player.getNumPieces(3) > 0 && (debugPP || SOCBoardPanel.this.player.getResources().contains(SOCShip.COST))) {
                            this.hoverShipID = id;
                        }
                    }
                    if (!hoverTextSet && SOCBoardPanel.this.isLargeBoard && this.hoverRoadID == 0 && this.hoverShipID == 0) {
                        String hoverTextKey;
                        switch (((SOCBoardLarge)SOCBoardPanel.this.board).getSpecialEdgeType(id)) {
                            case 1: {
                                hoverTextKey = "board.edge.devcard";
                                break;
                            }
                            case 2: {
                                hoverTextKey = "board.edge.svp";
                                break;
                            }
                            default: {
                                hoverTextKey = null;
                            }
                        }
                        if (hoverTextKey != null) {
                            this.setHoverText(strings.get(hoverTextKey), id);
                            hoverTextSet = true;
                        }
                    }
                }
                if (hoverTextSet) {
                    return;
                }
                if (nodePortCoord != -1) {
                    if (this.hoverMode == 5 && this.hoverID == nodePortCoord && this.hoverIsPort) {
                        this.positionToMouse(x, y);
                    } else {
                        SOCBoardLarge bl;
                        int portEdge;
                        String portText = strings.get(this.portDescAtNode(nodePortCoord), nodePortType);
                        if (SOCBoardPanel.this.isLargeBoard && SOCBoardPanel.this.game.isGameOptionSet("_SC_FTRI") && (portEdge = (bl = (SOCBoardLarge)SOCBoardPanel.this.board).getPortEdgeFromNode(nodePortCoord)) != -9 && bl.canRemovePort(portEdge)) {
                            portText = strings.get("board.edge.ship_receive_this", portText);
                        }
                        this.setHoverText(portText, nodePortCoord);
                        this.hoverMode = 5;
                        this.hoverID = nodePortCoord;
                        this.hoverIsPort = true;
                    }
                    return;
                }
                id = SOCBoardPanel.this.findHex(xb, yb);
                if (id > 0 && (!SOCBoardPanel.this.debugShowCoordsTooltip || this.hoverRoadID == 0 && this.hoverShipID == 0)) {
                    if ((this.hoverMode == 4 || this.hoverMode == 18) && this.hoverID == id) {
                        this.positionToMouse(x, y);
                        return;
                    }
                    this.hoverMode = SOCBoardPanel.this.game.getGameState() == 34 ? 18 : 4;
                    this.hoverPiece = null;
                    this.hoverID = id;
                    int htype = SOCBoardPanel.this.board.getHexTypeFromCoord(id);
                    int dicenum = SOCBoardPanel.this.board.getNumberOnHexFromCoord(id);
                    StringBuffer key = new StringBuffer("game.hex.hoverformat");
                    String hname = "";
                    String addinfo = "";
                    int hid = htype;
                    boolean showDice = false;
                    switch (htype) {
                        case 6: {
                            hname = "board.hex.desert";
                            break;
                        }
                        case 1: {
                            hname = "resources.clay";
                            break;
                        }
                        case 2: {
                            hname = "resources.ore";
                            break;
                        }
                        case 3: {
                            hname = "resources.sheep";
                            break;
                        }
                        case 4: {
                            hname = "resources.wheat";
                            break;
                        }
                        case 5: {
                            hname = "resources.wood";
                            break;
                        }
                        case 0: {
                            hname = "board.hex.water";
                            break;
                        }
                        case 7: {
                            if (SOCBoardPanel.this.isLargeBoard) {
                                hname = "board.hex.gold";
                                break;
                            }
                            hid = 0;
                            hname = SOCBoard.getPortDescForType(hid, false);
                            break;
                        }
                        case 8: {
                            if (SOCBoardPanel.this.isLargeBoard) {
                                if (SOCBoardPanel.this.game.isInitialPlacement() && SOCBoardPanel.this.player != null && SOCBoardPanel.this.player.hasPotentialSettlementsInitialInFog()) {
                                    hname = "board.hex.fog.s";
                                    break;
                                }
                                hname = "board.hex.fog.r";
                                break;
                            }
                            hid = 1;
                            hname = SOCBoard.getPortDescForType(hid, false);
                            break;
                        }
                        default: {
                            String portDesc = null;
                            if (htype >= 7 && htype <= 12) {
                                hid = htype - 7;
                                portDesc = SOCBoard.getPortDescForType(hid, false);
                            }
                            if (portDesc != null) {
                                hname = portDesc;
                                break;
                            }
                            hid = htype;
                            hname = "board.hex.generic";
                        }
                    }
                    if (SOCBoardPanel.this.board.getRobberHex() == id) {
                        showDice = dicenum > 0;
                        addinfo = "game.hex.addinfo.robber";
                    } else if (SOCBoardPanel.this.board.getPreviousRobberHex() == id) {
                        showDice = dicenum > 0;
                        addinfo = "game.hex.addinfo.past.robber";
                    } else if (SOCBoardPanel.this.isLargeBoard) {
                        SOCBoardLarge bl = (SOCBoardLarge)SOCBoardPanel.this.board;
                        if (bl.getPirateHex() == id) {
                            showDice = dicenum > 0;
                            addinfo = "game.hex.addinfo.pirate";
                        } else if (bl.getPreviousPirateHex() == id) {
                            showDice = dicenum > 0;
                            addinfo = "game.hex.addinfo.past.pirate";
                        } else if (bl.isHexInLandAreas(id, bl.getPlayerExcludedLandAreas())) {
                            addinfo = "game.hex.addinfo.cantsettle";
                        }
                    }
                    hname = strings.get(hname, hid);
                    if (showDice) {
                        key.append(".dice");
                    }
                    if (addinfo.length() != 0) {
                        key.append(".addi");
                        addinfo = strings.get(addinfo);
                    }
                    this.setHoverText(strings.get(key.toString(), hname, dicenum, addinfo), id);
                    return;
                }
            }
            catch (ConcurrentModificationException e) {
                this.handleHover(x, y, xb, yb);
                return;
            }
            if (this.hoverSettlementID != 0 && SOCBoardPanel.this.debugShowCoordsTooltip) {
                this.setHoverText("", this.hoverSettlementID);
                return;
            }
            if (this.hoverRoadID != 0 || this.hoverShipID != 0) {
                if (SOCBoardPanel.this.debugShowCoordsTooltip) {
                    this.setHoverText("", this.hoverRoadID != 0 ? this.hoverRoadID : this.hoverShipID);
                } else {
                    this.setHoverText(null, 0);
                }
                this.bpanel.repaint();
                return;
            }
            if (this.hoverMode != 0) {
                this.setHoverText_modeChangedOrMouseMoved = true;
                this.hoverMode = 0;
            }
            this.setHoverText(null, 0);
        }

        public String portDescAtNode(int id) {
            return SOCBoard.getPortDescForType(SOCBoardPanel.this.board.getPortTypeFromNodeCoord(id), false);
        }
    }

    protected static class DelayedRepaint
    extends Thread {
        private static boolean alreadyActive = false;
        private SOCBoardPanel bp;

        public DelayedRepaint(SOCBoardPanel bp) {
            this.setDaemon(true);
            this.bp = bp;
        }

        @Override
        public void run() {
            if (alreadyActive) {
                return;
            }
            alreadyActive = true;
            try {
                this.setName("delayedRepaint");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                alreadyActive = false;
                this.bp.repaint();
            }
        }
    }
}

