/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import soc.client.AskDialog;
import soc.client.ColorSquare;
import soc.client.GameMessageSender;
import soc.client.NewGameOptionsFrame;
import soc.client.NotifyDialog;
import soc.client.SOCHandPanel;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.SOCSpecialItemDialog;
import soc.client.SwingMainDisplay;
import soc.client.stats.GameStatisticsFrame;
import soc.game.GameAction;
import soc.game.SOCBoardLarge;
import soc.game.SOCCity;
import soc.game.SOCDevCard;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.util.SOCStringManager;

class SOCBuildingPanel
extends JPanel
implements ActionListener,
WindowListener {
    private static final SOCStringManager strings = SOCStringManager.getClientManager();
    static final String ROAD = "road";
    static final String STLMT = "stlmt";
    static final String CITY = "city";
    static final String CARD = "card";
    static final String SHIP = "ship";
    static final String SBP = "sbp";
    JLabel title;
    JButton roadBut;
    JButton settlementBut;
    JButton cityBut;
    JButton cardBut;
    JButton gameOptsBut;
    JButton statsBut;
    GameStatisticsFrame statsFrame;
    JLabel roadT;
    ArrowheadPanel roadC;
    final ColorSquare[] roadSq;
    JLabel settlementT;
    ArrowheadPanel settlementC;
    final ColorSquare[] settlementSq;
    JLabel cityT;
    ArrowheadPanel cityC;
    final ColorSquare[] citySq;
    JLabel cardT;
    ArrowheadPanel cardC;
    JLabel cardCountLab;
    private JLabel vpToWinLab;
    final ColorSquare[] cardSq;
    ColorSquare cardCount;
    private ColorSquare vpToWin;
    private ColorSquare cloth;
    private JLabel clothLab;
    private JButton wondersBut;
    private JLabel shipT;
    private ArrowheadPanel shipC;
    private final ColorSquare[] shipSq;
    private JButton shipBut;
    private JPanel sbPanel;
    private JButton sbBut;
    private JLabel sbLab;
    private boolean sbIsHilight;
    private boolean sbNeedsMorePlayers;
    private int pieceButtonsState;
    private boolean cardButIsCancelConvertToWarship;
    private NewGameOptionsFrame ngof;
    SOCPlayerInterface pi;
    public static final int MINHEIGHT = 80;
    SOCPlayer player;
    private static final int[] makeCostSquares_resMap = new int[]{5, 1, 4, 3, 2};

    public SOCBuildingPanel(final SOCPlayerInterface pi) {
        this.setLayout(null);
        this.player = null;
        this.pi = pi;
        Font panelFont = new Font("Dialog", 0, 10 * pi.displayScale);
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        if (!isOSHighContrast) {
            Color[] colors = SwingMainDisplay.getForegroundBackgroundColors(true, false);
            this.setBackground(colors[2]);
            this.setForeground(colors[0]);
        }
        this.setFont(panelFont);
        int costsH = 10 * pi.displayScale - 1;
        int costsW = 7 * pi.displayScale - 1;
        String costsTooltip = strings.get("build.cost_to_build");
        SOCBuildingPanel arrowColorsFrom = isOSHighContrast ? null : this;
        this.roadT = new JLabel(strings.get("build.road"));
        this.roadT.setToolTipText(strings.get("build.road.vp"));
        this.add(this.roadT);
        this.roadC = new ArrowheadPanel(costsW, costsH, costsTooltip, arrowColorsFrom);
        this.add(this.roadC);
        this.roadSq = this.makeCostSquares(SOCRoad.COST);
        this.roadBut = new JButton("---");
        this.roadBut.setEnabled(false);
        this.add(this.roadBut);
        this.roadBut.setActionCommand(ROAD);
        this.roadBut.addActionListener(this);
        this.settlementT = new JLabel(strings.get("build.settlement"));
        this.settlementT.setToolTipText(strings.get("build.1.vp"));
        this.add(this.settlementT);
        this.settlementC = new ArrowheadPanel(costsW, costsH, costsTooltip, arrowColorsFrom);
        this.add(this.settlementC);
        this.settlementSq = this.makeCostSquares(SOCSettlement.COST);
        this.settlementBut = new JButton("---");
        this.settlementBut.setEnabled(false);
        this.add(this.settlementBut);
        this.settlementBut.setActionCommand(STLMT);
        this.settlementBut.addActionListener(this);
        this.cityT = new JLabel(strings.get("build.city"));
        this.cityT.setToolTipText(strings.get("build.city.vp"));
        this.add(this.cityT);
        this.cityC = new ArrowheadPanel(costsW, costsH, costsTooltip, arrowColorsFrom);
        this.add(this.cityC);
        this.citySq = this.makeCostSquares(SOCCity.COST);
        this.cityBut = new JButton("---");
        this.cityBut.setEnabled(false);
        this.add(this.cityBut);
        this.cityBut.setActionCommand(CITY);
        this.cityBut.addActionListener(this);
        this.gameOptsBut = new JButton(strings.get("build.game.options"));
        this.add(this.gameOptsBut);
        this.gameOptsBut.addActionListener(this);
        this.statsBut = new JButton(strings.get("build.game.stats"));
        this.add(this.statsBut);
        this.statsBut.addActionListener(this);
        final int sqHeight = 16 * pi.displayScale;
        this.cardT = new JLabel(strings.get("buy.dev.card"));
        this.cardT.setToolTipText("? VP  (largest army = 2 VP) ");
        this.add(this.cardT);
        this.cardC = new ArrowheadPanel(costsW, costsH, costsTooltip, arrowColorsFrom);
        this.add(this.cardC);
        this.cardSq = this.makeCostSquares(SOCDevCard.COST);
        this.cardBut = new JButton("---");
        this.cardBut.setEnabled(false);
        this.add(this.cardBut);
        this.cardBut.setActionCommand(CARD);
        this.cardBut.addActionListener(this);
        this.cardCountLab = new JLabel(strings.get("build.available"), 2);
        this.add(this.cardCountLab);
        this.cardCount = new ColorSquare(ColorSquare.GREY, 0, sqHeight, sqHeight);
        this.cardCount.setToolTipText(strings.get("buy.dev.cards.available"));
        this.cardCount.setToolTipLowWarningLevel(strings.get("buy.dev.cards.low"), 3);
        this.cardCount.setToolTipZeroText(strings.get("buy.dev.cards.none.common"));
        this.add(this.cardCount);
        SOCGame ga = pi.getGame();
        if (ga.hasSeaBoard) {
            this.shipT = new JLabel(strings.get("build.ship"), 2);
            this.shipT.setToolTipText(strings.get("build.ship.vp"));
            this.add(this.shipT);
            this.shipC = new ArrowheadPanel(costsW, costsH, costsTooltip, arrowColorsFrom);
            this.add(this.shipC);
            this.shipSq = this.makeCostSquares(SOCShip.COST);
            this.shipBut = new JButton("---");
            this.shipBut.setEnabled(false);
            this.add(this.shipBut);
            this.shipBut.setActionCommand(SHIP);
            this.shipBut.addActionListener(this);
            if (ga.isGameOptionSet("_SC_CLVI")) {
                String TTIP_CLOTH_TEXT = strings.get("build.sc_clvi.cloth.tip");
                this.clothLab = new JLabel(strings.get("build.sc_clvi.cloth"));
                this.clothLab.setToolTipText(TTIP_CLOTH_TEXT);
                this.add(this.clothLab);
                this.cloth = new ColorSquare(ColorSquare.GREY, 0, sqHeight, sqHeight);
                this.add(this.cloth);
                this.cloth.setToolTipText(TTIP_CLOTH_TEXT);
            } else if (ga.isGameOptionSet("_SC_WOND")) {
                this.wondersBut = new JButton(strings.get("build.specitem._SC_WOND"));
                this.wondersBut.setToolTipText(strings.get("build.specitem._SC_WOND.tip"));
                this.add(this.wondersBut);
                this.wondersBut.addActionListener(this);
            }
        } else {
            this.shipSq = null;
        }
        if (ga.hasSeaBoard || ga.vp_winner != 10) {
            String TTIP_VP_TEXT = strings.get("build.vp.to.win.tip");
            this.vpToWin = new ColorSquare(ColorSquare.GREY, ga.vp_winner, sqHeight, sqHeight);
            this.vpToWin.setToolTipText(TTIP_VP_TEXT);
            this.add(this.vpToWin);
            this.vpToWinLab = new JLabel(strings.get("build.vp.to.win"), 4);
            this.vpToWinLab.setToolTipText(TTIP_VP_TEXT);
            this.add(this.vpToWinLab);
        } else {
            this.vpToWinLab = null;
            this.vpToWin = null;
        }
        if (ga.maxPlayers > 4) {
            this.sbIsHilight = false;
            this.sbPanel = new JPanel(null){

                @Override
                public void doLayout() {
                    Dimension dim = this.getSize();
                    FontMetrics fm = this.getFontMetrics(this.getFont());
                    if (dim.height == 0 || SOCBuildingPanel.this.sbBut == null || fm == null) {
                        this.invalidate();
                        return;
                    }
                    int lineH = ((SOCBuildingPanel)SOCBuildingPanel.this).sbBut.getMinimumSize().height;
                    if (lineH == 0) {
                        lineH = ((SOCBuildingPanel)SOCBuildingPanel.this).sbBut.getPreferredSize().height;
                    }
                    if (lineH == 0) {
                        lineH = sqHeight;
                    }
                    int btnW = ((SOCBuildingPanel)SOCBuildingPanel.this).sbBut.getPreferredSize().width;
                    int btnTxtW = 8 * pi.displayScale + SOCBuildingPanel.this.sbBut.getFontMetrics(SOCBuildingPanel.this.sbBut.getFont()).stringWidth(SOCBuildingPanel.this.sbBut.getText());
                    if (btnTxtW > btnW) {
                        btnW = btnTxtW;
                    }
                    if (btnW > dim.width) {
                        btnW = dim.width;
                    }
                    if (SOCBuildingPanel.this.sbLab == null) {
                        int x = (dim.width - btnW) / 2;
                        int y = (dim.height - lineH) / 2 - 1;
                        if (y < 0) {
                            y = 0;
                            lineH = dim.height;
                        }
                        SOCBuildingPanel.this.sbBut.setLocation(x, y);
                        SOCBuildingPanel.this.sbBut.setSize(btnW, lineH);
                    } else {
                        int y = dim.height / 2 - 1;
                        SOCBuildingPanel.this.sbLab.setLocation(0, 0);
                        SOCBuildingPanel.this.sbLab.setSize(dim.width, y);
                        SOCBuildingPanel.this.sbBut.setLocation((dim.width - btnW) / 2, y);
                        SOCBuildingPanel.this.sbBut.setSize(btnW, y);
                    }
                }
            };
            this.sbPanel.setBackground(ColorSquare.GREY);
            if (ga.hasSeaBoard) {
                this.sbBut = new JButton(strings.get("build.special.build"));
            } else {
                this.sbLab = new JLabel(strings.get("build.special.build.phase"), 0);
                this.sbLab.setFont(panelFont);
                this.sbBut = new JButton(strings.get("build.buybuild"));
            }
            if (SOCPlayerClient.IS_PLATFORM_WINDOWS && !isOSHighContrast) {
                this.sbBut.setBackground(null);
            }
            this.sbBut.setFont(panelFont);
            this.sbBut.setEnabled(false);
            this.sbBut.setActionCommand(SBP);
            this.sbBut.addActionListener(this);
            if (this.sbLab != null) {
                this.sbPanel.add(this.sbLab);
            }
            this.sbPanel.add(this.sbBut);
            this.add(this.sbPanel);
            String TTIP_SBP_TEXT = strings.get("build.special.build.tip");
            this.sbPanel.setToolTipText(TTIP_SBP_TEXT);
            if (this.sbLab != null) {
                this.sbLab.setToolTipText(TTIP_SBP_TEXT);
            }
            this.sbNeedsMorePlayers = ga.isGameOptionSet("PLP") && ga.getPlayerCount() < 5;
        }
        int pix2 = 2 * pi.displayScale;
        Insets minMargin = new Insets(pix2, pix2, pix2, pix2);
        boolean shouldClearButtonBGs = SOCPlayerClient.IS_PLATFORM_WINDOWS && !isOSHighContrast;
        for (Component co : this.getComponents()) {
            if (!(co instanceof JLabel) && !(co instanceof JButton)) continue;
            co.setFont(panelFont);
            if (co instanceof JLabel) {
                ((JLabel)co).setVerticalAlignment(1);
                continue;
            }
            ((JButton)co).setMargin(minMargin);
            if (!shouldClearButtonBGs) continue;
            co.setBackground(null);
        }
    }

    @Override
    public void doLayout() {
        int buttonMargin;
        int margin;
        Dimension dim = this.getSize();
        int maxPlayers = this.pi.getGame().maxPlayers;
        boolean hasLargeBoard = this.pi.getGame().hasSeaBoard;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int pix1 = this.pi.displayScale;
        int lineH = 16 * this.pi.displayScale;
        int rowSpaceH = 4 * this.pi.displayScale;
        int sqWidth = 16 * this.pi.displayScale;
        int curY = margin = 2 * this.pi.displayScale;
        int costW = this.roadC.getWidth() + pix1;
        int costDY = (lineH - this.roadC.getHeight()) / 2;
        int butW = 62 * this.pi.displayScale;
        int roadTW = fm.stringWidth(this.roadT.getText());
        int settlementTW = fm.stringWidth(this.settlementT.getText());
        int cityTW = fm.stringWidth(this.cityT.getText());
        int cardTW = fm.stringWidth(this.cardT.getText());
        int n = buttonMargin = settlementTW > cityTW ? settlementTW : cityTW;
        if (roadTW > buttonMargin) {
            buttonMargin = roadTW;
        }
        if (cardTW > buttonMargin) {
            buttonMargin = cardTW;
        }
        this.roadT.setSize(roadTW, lineH);
        this.roadT.setLocation(margin, curY);
        this.roadBut.setSize(butW, lineH);
        this.roadBut.setLocation(buttonMargin += 2 * margin, curY);
        int curX = buttonMargin + butW + pix1;
        this.roadC.setLocation(curX, curY + costDY);
        curX += costW + margin;
        curX = this.layoutCostSquares(this.roadSq, curX, curY);
        if (this.shipBut != null) {
            int shipTW = fm.stringWidth(this.shipT.getText());
            this.shipT.setSize(shipTW, lineH);
            this.shipT.setLocation(curX += 2 * (sqWidth + margin), curY);
            this.shipBut.setSize(butW, lineH);
            this.shipBut.setLocation(curX += shipTW + margin, curY);
            this.shipC.setLocation(curX += butW + pix1, curY + costDY);
            this.layoutCostSquares(this.shipSq, curX += costW + margin, curY);
        }
        this.settlementT.setSize(settlementTW, lineH);
        this.settlementT.setLocation(margin, curY += rowSpaceH + lineH);
        this.settlementBut.setSize(butW, lineH);
        this.settlementBut.setLocation(buttonMargin, curY);
        curX = buttonMargin + butW + pix1;
        this.settlementC.setLocation(curX, curY + costDY);
        curX += costW + margin;
        curX = this.layoutCostSquares(this.settlementSq, curX, curY);
        if (maxPlayers > 4) {
            curX += sqWidth + margin + 1;
            if (hasLargeBoard) {
                this.sbPanel.setSize(dim.width - curX - 2 * (butW + margin), rowSpaceH + lineH);
                this.sbPanel.setLocation(curX, curY - rowSpaceH / 2);
            } else {
                this.sbPanel.setSize(dim.width - curX - margin, rowSpaceH + 2 * lineH);
                this.sbPanel.setLocation(curX, curY);
            }
        }
        this.cityT.setSize(cityTW, lineH);
        this.cityT.setLocation(margin, curY += rowSpaceH + lineH);
        this.cityBut.setSize(butW, lineH);
        this.cityBut.setLocation(buttonMargin, curY);
        curX = buttonMargin + butW + pix1;
        this.cityC.setLocation(curX, curY + costDY);
        curX += costW + margin;
        curX = this.layoutCostSquares(this.citySq, curX, curY);
        if (this.cloth != null) {
            int clothTW = fm.stringWidth(this.clothLab.getText());
            this.clothLab.setSize(clothTW + 2 * margin - 1, lineH);
            this.clothLab.setLocation(curX += 3 * (sqWidth + margin), curY);
            this.cloth.setLocation(curX += clothTW + 2 * margin, curY);
        }
        if (this.wondersBut != null) {
            this.wondersBut.setSize(dim.width - (curX += 3 * (sqWidth + margin)) - 2 * butW - 2 * margin, lineH);
            this.wondersBut.setLocation(curX, curY);
        }
        this.cardT.setSize(cardTW, lineH);
        this.cardT.setLocation(margin, curY += rowSpaceH + lineH);
        this.cardBut.setSize(butW, lineH);
        this.cardBut.setLocation(buttonMargin, curY);
        curX = buttonMargin + butW + pix1;
        this.cardC.setLocation(curX, curY + costDY);
        curX += costW + margin;
        curX = this.layoutCostSquares(this.cardSq, curX, curY);
        this.cardCount.setLocation(curX += 2 * (sqWidth + margin), curY);
        int cardCLabW = fm.stringWidth(this.cardCountLab.getText());
        this.cardCountLab.setLocation(curX += sqWidth + margin + 1, curY);
        this.cardCountLab.setSize(cardCLabW + margin, lineH);
        int rightButW = 2 * butW;
        curX = this.settlementSq[3].getX() + this.settlementSq[3].getWidth() + margin;
        if (dim.width - rightButW - margin < curX) {
            rightButW = dim.width - curX - margin;
        } else {
            curX = dim.width - rightButW - margin;
        }
        if (maxPlayers <= 4 && !hasLargeBoard) {
            curY -= lineH + 5 * this.pi.displayScale;
        }
        this.gameOptsBut.setSize(rightButW, lineH);
        if (maxPlayers <= 4 && !hasLargeBoard) {
            this.gameOptsBut.setLocation(curX, pix1 + (rowSpaceH + lineH));
        } else {
            this.gameOptsBut.setLocation(curX, curY);
        }
        this.statsBut.setSize(rightButW, lineH);
        if (hasLargeBoard) {
            this.statsBut.setLocation(curX, pix1 + 2 * (rowSpaceH + lineH));
        } else {
            this.statsBut.setLocation(curX, pix1);
        }
        if (this.vpToWin != null) {
            int vpLabW = fm.stringWidth(this.vpToWinLab.getText());
            if (hasLargeBoard) {
                curY = rowSpaceH + lineH;
                curX = dim.width - sqWidth - margin;
                this.vpToWin.setLocation(curX, curY);
                this.vpToWinLab.setLocation(curX -= vpLabW + 2 * margin, curY);
                this.vpToWinLab.setSize(vpLabW + margin, lineH);
            } else {
                if (maxPlayers <= 4) {
                    curY = pix1 + 2 * (rowSpaceH + lineH);
                    curX = dim.width - sqWidth - margin;
                    this.vpToWin.setLocation(curX, curY);
                    this.vpToWinLab.setLocation(curX -= vpLabW + 2 * margin, curY);
                } else {
                    curY = pix1;
                    curX = buttonMargin + butW + margin + (costW + margin) + 4 * (sqWidth + margin);
                    int statsButX = this.statsBut.getX();
                    if (curX + sqWidth + vpLabW + 2 * margin > statsButX) {
                        curX -= 2 * (sqWidth + margin);
                    }
                    this.vpToWinLab.setLocation(curX, curY);
                    int xmax = statsButX - sqWidth - margin;
                    if ((curX += vpLabW + 2 * margin) > xmax) {
                        vpLabW = xmax - this.vpToWinLab.getX() - margin;
                        curX = xmax;
                    }
                    this.vpToWin.setLocation(curX, curY);
                }
                this.vpToWinLab.setSize(vpLabW + margin, lineH);
            }
        }
    }

    private ColorSquare[] makeCostSquares(SOCResourceSet cost) {
        String costToBuild = strings.get("build.cost_to_build");
        int n = cost.getResourceTypeCount();
        ColorSquare[] sq = new ColorSquare[n];
        int sqHeight = 16 * this.pi.displayScale;
        int i = 0;
        for (int mapIdx = 0; i < n && mapIdx < 5; ++mapIdx) {
            int res = makeCostSquares_resMap[mapIdx];
            int itemCost = cost.getAmount(res);
            if (itemCost == 0) continue;
            ColorSquare s = new ColorSquare(ColorSquare.RESOURCE_COLORS[res - 1], itemCost, sqHeight, sqHeight);
            s.setToolTipText(costToBuild + ": " + s.getToolTipText());
            sq[i] = s;
            this.add(s);
            ++i;
        }
        return sq;
    }

    private int layoutCostSquares(ColorSquare[] sq, int curX, int curY) {
        int sqWidth = 16 * this.pi.displayScale;
        int step = sqWidth + 2 * this.pi.displayScale;
        int i = 0;
        while (i < sq.length) {
            sq[i].setSize(sqWidth, sqWidth);
            sq[i].setLocation(curX, curY);
            ++i;
            curX += step;
        }
        return curX;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String target = e.getActionCommand();
            SOCGame game = this.pi.getGame();
            if (e.getSource() == this.gameOptsBut) {
                if (this.ngof != null && this.ngof.isVisible()) {
                    this.ngof.setVisible(true);
                } else {
                    this.ngof = NewGameOptionsFrame.createAndShow(this.pi, this.pi.getMainDisplay(), game.getName(), game.getGameOptions(), false, true);
                    this.ngof.addWindowListener(this);
                }
                return;
            }
            if (e.getSource() == this.statsBut) {
                if (this.statsFrame != null) {
                    this.statsFrame.dispose();
                }
                GameStatisticsFrame f = new GameStatisticsFrame(this.pi, this.pi.displayScale);
                f.register(this.pi.getGameStats());
                f.setLocation(this.getLocationOnScreen());
                f.setVisible(true);
                this.statsFrame = f;
                return;
            }
            if (e.getSource() == this.wondersBut) {
                this.clickWondersButton();
                return;
            }
            if (this.player != null) {
                this.clickBuildingButton(game, target, false);
            }
        }
        catch (Throwable th) {
            this.pi.chatPrintStackTrace(th);
        }
    }

    public void gameWindowClosed() {
        if (this.statsFrame != null && this.statsFrame.isVisible()) {
            this.statsFrame.dispose();
        }
    }

    public void clickBuildingButton(SOCGame game, String target, boolean doNotClearPopup) {
        boolean canAskSBP;
        SOCPlayerClient client = this.pi.getClient();
        if (!doNotClearPopup) {
            this.pi.getBoardPanel().popupClearBuildRequest();
        }
        boolean isCurrent = this.pi.isClientCurrentPlayer();
        int gstate = game.getGameState();
        boolean bl = canAskSBP = game.canAskSpecialBuild(this.player.getPlayerNumber(), false) && !this.sbIsHilight;
        boolean stateBuyOK = isCurrent ? gstate == 20 || gstate == 100 : canAskSBP;
        GameMessageSender messageSender = client.getGameMessageSender();
        int sendBuildRequest = -9;
        if (target == ROAD) {
            if (this.pieceButtonsState == 0) {
                if (stateBuyOK) {
                    sendBuildRequest = 0;
                } else if (canAskSBP) {
                    sendBuildRequest = -1;
                }
            } else if (this.pieceButtonsState == 41) {
                EventQueue.invokeLater(new ConfirmCancelFreeRoadDialog(this.pi, true, false));
            } else if (this.pieceButtonsState == 30 || this.pieceButtonsState == 40) {
                messageSender.cancelBuildRequest(game, 0);
            }
        } else if (target == STLMT) {
            if (this.pieceButtonsState == 0) {
                if (stateBuyOK) {
                    sendBuildRequest = 1;
                } else if (canAskSBP) {
                    sendBuildRequest = -1;
                }
            } else if (this.pieceButtonsState == 31) {
                messageSender.cancelBuildRequest(game, 1);
            }
        } else if (target == CITY) {
            if (this.pieceButtonsState == 0) {
                if (stateBuyOK) {
                    sendBuildRequest = 2;
                } else if (canAskSBP) {
                    sendBuildRequest = -1;
                }
            } else if (this.pieceButtonsState == 32) {
                messageSender.cancelBuildRequest(game, 2);
            }
        } else if (target == CARD) {
            if (this.cardButIsCancelConvertToWarship || gstate == 33 || gstate == 34) {
                messageSender.cancelBuildRequest(game, -2);
            } else if (this.pieceButtonsState == 0 && (stateBuyOK || canAskSBP)) {
                messageSender.buyDevCard(game);
                this.pi.getClientHand().disableBankUndoButton();
            }
        } else if (target == SHIP) {
            if (this.pieceButtonsState == 0) {
                if (stateBuyOK) {
                    sendBuildRequest = 3;
                } else if (canAskSBP) {
                    sendBuildRequest = -1;
                }
            } else if (this.pieceButtonsState == 41) {
                EventQueue.invokeLater(new ConfirmCancelFreeRoadDialog(this.pi, false, false));
            } else if (this.pieceButtonsState == 35 || this.pieceButtonsState == 40) {
                messageSender.cancelBuildRequest(game, 3);
            }
        } else if (target == SBP) {
            if (canAskSBP) {
                sendBuildRequest = -1;
            } else if (this.sbNeedsMorePlayers && this.sbBut.isEnabled()) {
                NotifyDialog.createAndShow(this.pi.getMainDisplay(), this.pi, strings.get("action.build.cannot.special.PLP.common"), null, true);
            }
        }
        if (sendBuildRequest != -9) {
            SOCHandPanel chp = this.pi.getClientHand();
            if (isCurrent && sendBuildRequest == -1) {
                chp.setRollPrompt(null, true);
            }
            messageSender.buildRequest(game, sendBuildRequest);
            chp.disableBankUndoButton();
        }
    }

    public void clickWondersButton() throws IllegalStateException {
        if (this.wondersBut == null) {
            throw new IllegalStateException("game not SC_WOND");
        }
        SOCSpecialItemDialog dia = new SOCSpecialItemDialog(this.pi, "_SC_WOND");
        dia.setNonBlockingDialogDismissListener(this.pi);
        this.pi.nbdForEvent = dia;
        dia.pack();
        dia.setVisible(true);
    }

    public void updateButtonStatus() {
        SOCGame game = this.pi.getGame();
        this.pieceButtonsState = 0;
        if (this.player != null) {
            GameAction lastAct;
            int pnum = this.player.getPlayerNumber();
            boolean isDebugFreePlacement = game.isDebugFreePlacement();
            boolean isCurrent = !isDebugFreePlacement && game.getCurrentPlayerNumber() == pnum;
            int gstate = game.getGameState();
            boolean currentCanBuy = !isDebugFreePlacement && game.canBuyOrAskSpecialBuild(pnum);
            SOCPlayerClient pcli = this.pi.getClient();
            boolean currentCanCancelConvertToWarship = isCurrent && (gstate == 15 || gstate == 20) ? (lastAct = game.getLastAction()) != null && lastAct.actType == GameAction.ActionType.SHIP_CONVERT_TO_WARSHIP && pcli.getServerVersion(game) >= 2700 : false;
            if (isCurrent && gstate == 40 && (game.isPractice || pcli.sVersion >= 2500)) {
                this.roadBut.setEnabled(true);
                this.roadBut.setText(strings.get("base.cancel"));
                this.pieceButtonsState = 40;
            } else if (isCurrent && (gstate == 30 || gstate == 41 && (game.isPractice || pcli.sVersion >= 1117))) {
                this.roadBut.setEnabled(true);
                this.roadBut.setText(strings.get("base.cancel"));
                this.pieceButtonsState = gstate == 41 ? gstate : 30;
            } else if (game.couldBuildRoad(pnum)) {
                this.roadBut.setEnabled(currentCanBuy);
                this.roadBut.setText(strings.get("build.buy"));
            } else {
                this.roadBut.setEnabled(false);
                this.roadBut.setText("---");
            }
            if (isCurrent && (gstate == 31 || gstate == 6 || gstate == 11 || gstate == 13)) {
                this.settlementBut.setEnabled(true);
                this.settlementBut.setText(strings.get("base.cancel"));
                this.pieceButtonsState = 31;
            } else if (game.couldBuildSettlement(pnum)) {
                this.settlementBut.setEnabled(currentCanBuy);
                this.settlementBut.setText(strings.get("build.buy"));
            } else {
                this.settlementBut.setEnabled(false);
                this.settlementBut.setText("---");
            }
            if (isCurrent && gstate == 32) {
                this.cityBut.setEnabled(true);
                this.cityBut.setText(strings.get("base.cancel"));
                this.pieceButtonsState = 32;
            } else if (game.couldBuildCity(pnum)) {
                this.cityBut.setEnabled(currentCanBuy);
                this.cityBut.setText(strings.get("build.buy"));
            } else {
                this.cityBut.setEnabled(false);
                this.cityBut.setText("---");
            }
            this.cardBut.setToolTipText(null);
            this.cardButIsCancelConvertToWarship = false;
            if (game.couldBuyDevCard(pnum)) {
                this.cardBut.setEnabled(currentCanBuy);
                this.cardBut.setText(strings.get("build.buy"));
            } else if (isCurrent && (gstate == 33 || gstate == 34) && game.canCancelPlayCurrentDevCard() && pcli.getServerVersion(game) >= 2700) {
                this.cardBut.setEnabled(true);
                this.cardBut.setText(strings.get("base.cancel"));
            } else if (currentCanCancelConvertToWarship) {
                this.cardBut.setEnabled(true);
                this.cardBut.setText(strings.get("base.cancel"));
                this.cardBut.setToolTipText("Cancel conversion of ship to warship");
                this.cardButIsCancelConvertToWarship = true;
            } else {
                this.cardBut.setEnabled(false);
                this.cardBut.setText("---");
            }
            if (this.shipBut != null) {
                if (isCurrent && (gstate == 35 || gstate == 41 || gstate == 40 && (game.isPractice || pcli.sVersion >= 2500))) {
                    this.shipBut.setEnabled(true);
                    this.shipBut.setText(strings.get("base.cancel"));
                    this.pieceButtonsState = gstate;
                } else if (game.couldBuildShip(pnum)) {
                    this.shipBut.setEnabled(currentCanBuy);
                    this.shipBut.setText(strings.get("build.buy"));
                } else {
                    this.shipBut.setEnabled(false);
                    this.shipBut.setText("---");
                }
            }
            if (this.sbBut != null && this.player != null) {
                boolean askedSB = this.player.hasAskedSpecialBuild();
                if (askedSB != this.sbIsHilight) {
                    Color want = askedSB ? ColorSquare.WARN_LEVEL_COLOR_BG_FROMGREY : ColorSquare.GREY;
                    this.sbPanel.setBackground(want);
                    if (this.sbLab != null) {
                        this.sbLab.setBackground(want);
                    }
                    this.sbIsHilight = askedSB;
                }
                boolean enable = this.sbNeedsMorePlayers ? !isCurrent && gstate >= 15 : game.canAskSpecialBuild(pnum, false) && !askedSB;
                this.sbBut.setEnabled(enable);
            }
        }
    }

    public void updateDevCardCount() {
        int newCount = this.pi.getGame().getNumDevCards();
        this.cardCount.setIntValue(newCount);
    }

    public void updateClothCount() {
        if (this.cloth == null) {
            return;
        }
        this.cloth.setIntValue(((SOCBoardLarge)this.pi.getGame().getBoard()).getCloth());
    }

    public void updatePlayerCount() {
        boolean newStatus;
        SOCGame game = this.pi.getGame();
        if (game.maxPlayers < 6 || !game.isGameOptionSet("PLP")) {
            return;
        }
        boolean bl = newStatus = game.getPlayerCount() < 5;
        if (newStatus == this.sbNeedsMorePlayers) {
            return;
        }
        this.sbNeedsMorePlayers = newStatus;
        this.updateButtonStatus();
    }

    public void setPlayer() throws IllegalStateException {
        SOCGame game = this.pi.getGame();
        SOCPlayer cliPl = this.pi.getClientPlayer();
        if (cliPl == this.player) {
            return;
        }
        if (this.player != null && !game.isBoardReset()) {
            throw new IllegalStateException("Player data is already set");
        }
        this.player = cliPl;
        if (cliPl == null) {
            throw new IllegalStateException("null PI.clientPlayer");
        }
        if (this.statsFrame != null && this.statsFrame.isVisible()) {
            this.statsFrame.statsUpdated(null, null);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (e.getWindow() == this.ngof) {
            this.ngof = null;
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public static class ConfirmCancelFreeRoadDialog
    extends AskDialog {
        private static final long serialVersionUID = 2700L;
        private final boolean isRoadNotShip;
        private final boolean isEndingTurn;

        public ConfirmCancelFreeRoadDialog(SOCPlayerInterface pi, boolean isRoadNotShip, boolean isEndingTurn) {
            super(pi.getMainDisplay(), pi, strings.get("dialog.cancel_free_road.title"), pi.getGame().hasSeaBoard ? strings.get("dialog.cancel_free_road.confirm_sea") : strings.get("dialog.cancel_free_road.confirm"), strings.get("base.place"), strings.get("base.skip"), true, false);
            this.isRoadNotShip = isRoadNotShip;
            this.isEndingTurn = isEndingTurn;
        }

        @Override
        public void button1Chosen() {
        }

        @Override
        public void button2Chosen() {
            GameMessageSender messageSender = this.pi.getClient().getGameMessageSender();
            SOCGame game = this.pi.getGame();
            if (this.isEndingTurn) {
                messageSender.endTurn(game);
            } else {
                messageSender.cancelBuildRequest(game, this.isRoadNotShip ? 0 : 3);
            }
        }

        @Override
        public void windowCloseChosen() {
        }
    }

    private static class ArrowheadPanel
    extends JComponent {
        public ArrowheadPanel(int width, int height, String tooltipText, Component colorsFrom) {
            this.setOpaque(true);
            if (colorsFrom != null) {
                this.setBackground(colorsFrom.getBackground());
                this.setForeground(colorsFrom.getForeground());
            } else {
                Color[] sysColors = SwingMainDisplay.getForegroundBackgroundColors(false, true);
                this.setForeground(sysColors[0]);
                this.setBackground(sysColors[2]);
            }
            if (tooltipText != null) {
                this.setToolTipText(tooltipText);
            }
            Dimension initSize = new Dimension(width, height);
            this.setSize(initSize);
            this.setMinimumSize(initSize);
            this.setPreferredSize(initSize);
        }

        @Override
        public void paintComponent(Graphics g) {
            Insets ins = this.getInsets();
            int x = ins.left;
            int y = ins.top;
            int w = this.getWidth() - x - ins.right;
            int h = this.getHeight() - y - ins.bottom;
            g.setColor(this.getBackground());
            g.fillRect(x, y, w, h);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            int[] xp = new int[]{x, x + w, x + w};
            int[] yp = new int[]{h / 2 + y, y, y + h};
            g.setColor(this.getForeground());
            g.fillPolygon(xp, yp, 3);
        }
    }
}

