/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import soc.client.SOCDialog;
import soc.client.SOCHandPanel;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.SwingMainDisplay;
import soc.game.SOCGame;
import soc.game.SOCPlayer;

class SOCChoosePlayerDialog
extends SOCDialog
implements ActionListener,
Runnable {
    private static final int MAX_ON_SAME_LINE = 3;
    final JButton[] buttons;
    final int[] players;
    JLabel[] player_res_lbl;
    final int number;

    public SOCChoosePlayerDialog(SOCPlayerInterface pi, int num, int[] p, boolean allowChooseNone) {
        super(pi, strings.get("dialog.robchoose.choose.player"), strings.get("dialog.robchoose.please.choose"), false, false);
        this.number = allowChooseNone ? num + 1 : num;
        this.players = p;
        JPanel btnsPane = this.getMiddlePanel();
        Font panelFont = this.getFont();
        boolean sameLineLayout = this.number <= 3;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.ipady = 3;
        gbc.insets = new Insets(2, 4, 2, 4);
        gbc.fill = 2;
        gbc.gridwidth = 0;
        btnsPane.setLayout(gbl);
        this.buttons = new JButton[this.number];
        this.player_res_lbl = new JLabel[this.number];
        SOCGame ga = pi.getGame();
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        boolean shouldClearButtonBGs = !isOSHighContrast && SOCPlayerClient.IS_PLATFORM_WINDOWS;
        for (int i = 0; i < num; ++i) {
            SOCPlayer pl = ga.getPlayer(this.players[i]);
            this.buttons[i] = new JButton(pl.getName());
            this.buttons[i].addActionListener(this);
            if (shouldClearButtonBGs) {
                this.buttons[i].setBackground(null);
            }
            int rescount = pl.getResources().getTotal();
            int vpcount = pl.getPublicVP();
            JLabel pLabel = new JLabel(strings.get("dialog.robchoose.n.res.n.vp", rescount, vpcount), 0);
            SOCHandPanel ph = pi.getPlayerHandPanel(this.players[i]);
            pLabel.setBackground(ph.getBackground());
            pLabel.setForeground(ph.getForeground());
            pLabel.setOpaque(true);
            pLabel.setFont(panelFont);
            pLabel.setToolTipText(strings.get("dialog.robchoose.player.has.n.rsrcs", rescount));
            this.player_res_lbl[i] = pLabel;
        }
        if (allowChooseNone) {
            JButton bNone = new JButton(strings.get("base.none"));
            if (shouldClearButtonBGs) {
                bNone.setBackground(null);
            }
            this.buttons[num] = bNone;
            bNone.setToolTipText(strings.get("dialog.robchoose.choose.steal.no.player"));
            bNone.addActionListener(this);
            this.players[num] = -1;
            JLabel lNone = new JLabel(strings.get("dialog.robchoose.decline"), 0);
            if (!isOSHighContrast) {
                lNone.setForeground(null);
            }
            lNone.setFont(panelFont);
            this.player_res_lbl[num] = lNone;
        }
        int n = this.buttons.length;
        if (sameLineLayout) {
            int i;
            gbc.weightx = 1.0 / (double)n;
            gbc.gridwidth = 1;
            for (i = 0; i < n; ++i) {
                if (i == n - 1) {
                    gbc.gridwidth = 0;
                }
                gbl.setConstraints(this.buttons[i], gbc);
                btnsPane.add(this.buttons[i]);
            }
            gbc.gridwidth = 1;
            gbc.ipadx = 32;
            for (i = 0; i < n; ++i) {
                if (i == n - 1) {
                    gbc.gridwidth = 0;
                }
                gbl.setConstraints(this.player_res_lbl[i], gbc);
                btnsPane.add(this.player_res_lbl[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                gbc.gridwidth = 1;
                gbc.ipadx = 0;
                gbl.setConstraints(this.buttons[i], gbc);
                btnsPane.add(this.buttons[i]);
                gbc.gridwidth = 0;
                gbc.ipadx = 32;
                gbl.setConstraints(this.player_res_lbl[i], gbc);
                btnsPane.add(this.player_res_lbl[i]);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object target = e.getSource();
            for (int i = 0; i < this.number; ++i) {
                if (target != this.buttons[i]) continue;
                this.playerInterface.getClient().getGameMessageSender().choosePlayer(this.playerInterface.getGame(), this.players[i]);
                this.dispose();
                break;
            }
        }
        catch (Throwable th) {
            this.playerInterface.chatPrintStackTrace(th);
        }
    }
}

