/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import soc.client.ClientNetwork;
import soc.client.MainDisplay;
import soc.client.SOCPlayerClient;
import soc.client.SwingMainDisplay;
import soc.util.SOCStringManager;
import soc.util.Version;

class SOCConnectOrPracticePanel
extends JPanel
implements ActionListener,
KeyListener {
    private final MainDisplay md;
    private final ClientNetwork clientNetwork;
    private JLabel topText;
    private JButton prac;
    private JButton connserv;
    private JPanel panel_conn;
    private JTextField conn_servhost;
    private JTextField conn_servport;
    private JTextField conn_user;
    private JPasswordField conn_pass;
    private JButton conn_connect;
    private JButton conn_cancel;
    private JButton runserv;
    private JPanel panel_run;
    private JTextField run_servport;
    private JButton run_startserv;
    private JButton run_cancel;
    private final boolean canLaunchServer;
    private static final Color HEADER_LABEL_BG = new Color(220, 255, 220);
    private static final Color HEADER_LABEL_FG = new Color(50, 80, 50);
    private static final SOCStringManager strings = SOCStringManager.getClientManager();

    public SOCConnectOrPracticePanel(MainDisplay md) {
        super(new BorderLayout());
        this.md = md;
        SOCPlayerClient cli = md.getClient();
        this.clientNetwork = cli.getNet();
        this.canLaunchServer = SOCConnectOrPracticePanel.checkCanLaunchServer();
        Color[] colors = SwingMainDisplay.getForegroundBackgroundColors(false, false);
        if (colors != null) {
            this.setBackground(colors[2]);
            this.setForeground(colors[0]);
        }
        this.addKeyListener(this);
        this.initInterfaceElements(colors != null ? colors[1] : null);
    }

    public static boolean checkCanLaunchServer() {
        int port = 8880;
        for (int i = 0; i <= 100; ++i) {
            ServerSocket ss = null;
            try {
                ss = new ServerSocket(i + port);
                ss.setReuseAddress(true);
                ss.setSoTimeout(11);
                ss.accept();
                ss.close();
                continue;
            }
            catch (SocketTimeoutException ste) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            catch (IOException ste) {
                continue;
            }
            catch (SecurityException se2) {
                return false;
            }
        }
        return false;
    }

    private void initInterfaceElements(Color miscLabelFGColor) {
        JPanel bpContainer = new JPanel();
        bpContainer.setLayout(new BoxLayout(bpContainer, 0));
        bpContainer.setBackground(null);
        bpContainer.setForeground(null);
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        boolean shouldClearButtonBGs = !isOSHighContrast && SOCPlayerClient.IS_PLATFORM_WINDOWS;
        BoxedJPanel bp = new BoxedJPanel();
        bp.setLayout(new BoxLayout(bp, 1));
        if (!isOSHighContrast) {
            bp.setBackground(null);
            bp.setForeground(null);
        }
        bp.setAlignmentX(0.5f);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        BoxedJPanel modeButtonsContainer = new BoxedJPanel(gbl);
        if (!isOSHighContrast) {
            modeButtonsContainer.setBackground(null);
            modeButtonsContainer.setForeground(null);
        }
        gbc.fill = 1;
        gbc.gridwidth = 0;
        this.topText = new JLabel(strings.get("pcli.cpp.welcomeheading"), 0);
        gbl.setConstraints(this.topText, gbc);
        modeButtonsContainer.add(this.topText);
        this.connserv = new JButton(strings.get("pcli.cpp.connecttoaserv"));
        if (shouldClearButtonBGs) {
            this.connserv.setBackground(null);
        }
        gbl.setConstraints(this.connserv, gbc);
        modeButtonsContainer.add(this.connserv);
        this.connserv.addActionListener(this);
        this.prac = new JButton(strings.get("pcli.main.practice"));
        if (shouldClearButtonBGs) {
            this.prac.setBackground(null);
        }
        gbl.setConstraints(this.prac, gbc);
        modeButtonsContainer.add(this.prac);
        this.prac.addActionListener(this);
        this.runserv = new JButton(strings.get("pcli.cpp.startserv"));
        if (shouldClearButtonBGs) {
            this.runserv.setBackground(null);
        }
        gbl.setConstraints(this.runserv, gbc);
        if (!this.canLaunchServer) {
            this.runserv.setEnabled(false);
        }
        modeButtonsContainer.add(this.runserv);
        bp.add(modeButtonsContainer);
        this.panel_conn = this.initInterface_conn();
        this.panel_conn.setVisible(false);
        bp.add(this.panel_conn);
        if (this.canLaunchServer) {
            this.runserv.addActionListener(this);
            this.panel_run = this.initInterface_run();
            this.panel_run.setVisible(false);
            bp.add(this.panel_run);
        } else {
            this.panel_run = null;
        }
        bpContainer.add(Box.createHorizontalGlue());
        bpContainer.add(bp);
        bpContainer.add(Box.createHorizontalGlue());
        this.add((Component)bpContainer, "Center");
        JLabel verl = new JLabel(strings.get("pcli.cpp.jsettlers.versionbuild", Version.version(), Version.buildnum()), 0);
        if (miscLabelFGColor != null) {
            verl.setForeground(miscLabelFGColor);
        }
        this.add((Component)verl, "South");
    }

    private JPanel initInterface_conn() {
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        boolean shouldClearButtonBGs = !isOSHighContrast && SOCPlayerClient.IS_PLATFORM_WINDOWS;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        BoxedJPanel pconn = new BoxedJPanel(gbl);
        if (!isOSHighContrast) {
            pconn.setBackground(null);
            pconn.setForeground(null);
        }
        gbc.fill = 2;
        JLabel L = new JLabel(strings.get("pcli.cpp.connecttoserv"), 0);
        if (!isOSHighContrast) {
            L.setBackground(HEADER_LABEL_BG);
            L.setForeground(HEADER_LABEL_FG);
            L.setOpaque(true);
        }
        gbc.gridwidth = 0;
        gbc.ipady = 8;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        gbc.ipady = 0;
        L = new JLabel(strings.get("pcli.cpp.server"));
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        this.conn_servhost = new JTextField(20);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.conn_servhost, gbc);
        this.conn_servhost.addKeyListener(this);
        pconn.add(this.conn_servhost);
        L = new JLabel(strings.get("pcli.cpp.port"));
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        this.conn_servport = new JTextField(20);
        String svp = Integer.toString(this.clientNetwork.getPort());
        this.conn_servport.setText(svp);
        this.conn_servport.setSelectionStart(0);
        this.conn_servport.setSelectionEnd(svp.length());
        gbc.gridwidth = 0;
        gbl.setConstraints(this.conn_servport, gbc);
        this.conn_servport.addKeyListener(this);
        pconn.add(this.conn_servport);
        L = new JLabel(strings.get("pcli.cpp.nickname"));
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        this.conn_user = new JTextField(20);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.conn_user, gbc);
        this.conn_user.addKeyListener(this);
        pconn.add(this.conn_user);
        L = new JLabel(strings.get("pcli.cpp.password"));
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        this.conn_pass = new JPasswordField(20);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.conn_pass, gbc);
        this.conn_pass.addKeyListener(this);
        pconn.add(this.conn_pass);
        L = new JLabel("");
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        pconn.add(L);
        this.conn_connect = new JButton(strings.get("pcli.cpp.connect"));
        if (shouldClearButtonBGs) {
            this.conn_connect.setBackground(null);
        }
        this.conn_connect.addActionListener(this);
        this.conn_connect.addKeyListener(this);
        gbc.weightx = 0.5;
        gbl.setConstraints(this.conn_connect, gbc);
        pconn.add(this.conn_connect);
        this.conn_cancel = new JButton(strings.get("base.cancel"));
        if (shouldClearButtonBGs) {
            this.conn_cancel.setBackground(null);
        }
        this.conn_cancel.addActionListener(this);
        this.conn_cancel.addKeyListener(this);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.conn_cancel, gbc);
        pconn.add(this.conn_cancel);
        return pconn;
    }

    private JPanel initInterface_run() {
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        boolean shouldClearButtonBGs = !isOSHighContrast && SOCPlayerClient.IS_PLATFORM_WINDOWS;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        BoxedJPanel prun = new BoxedJPanel(gbl);
        if (!isOSHighContrast) {
            prun.setBackground(null);
            prun.setForeground(null);
        }
        gbc.fill = 2;
        JLabel L = new JLabel(strings.get("pcli.cpp.startserv"), 0);
        if (!isOSHighContrast) {
            L.setBackground(HEADER_LABEL_BG);
            L.setForeground(HEADER_LABEL_FG);
            L.setOpaque(true);
        }
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.ipadx = 4;
        gbc.ipady = 4;
        gbl.setConstraints(L, gbc);
        prun.add(L);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        L = new JLabel(" ");
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbl.setConstraints(L, gbc);
        prun.add(L);
        L = new JLabel();
        gbc.gridwidth = 0;
        gbl.setConstraints(L, gbc);
        prun.add(L);
        L = new JLabel(strings.get("pcli.cpp.port"));
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        prun.add(L);
        this.run_servport = new JTextField(10);
        String svp = Integer.toString(this.clientNetwork.getPort());
        this.run_servport.setText(svp);
        this.run_servport.setSelectionStart(0);
        this.run_servport.setSelectionEnd(svp.length());
        gbc.gridwidth = 2;
        gbl.setConstraints(this.run_servport, gbc);
        this.run_servport.addKeyListener(this);
        prun.add(this.run_servport);
        L = new JLabel(" ");
        gbc.gridwidth = 0;
        gbl.setConstraints(L, gbc);
        prun.add(L);
        L = new JLabel(" ");
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        prun.add(L);
        this.run_startserv = new JButton(" " + strings.get("pcli.cpp.start") + " ");
        if (shouldClearButtonBGs) {
            this.run_startserv.setBackground(null);
        }
        this.run_startserv.addActionListener(this);
        this.run_startserv.addKeyListener(this);
        gbc.weightx = 0.5;
        gbl.setConstraints(this.run_startserv, gbc);
        prun.add(this.run_startserv);
        this.run_cancel = new JButton(strings.get("base.cancel"));
        if (shouldClearButtonBGs) {
            this.run_cancel.setBackground(null);
        }
        this.run_cancel.addActionListener(this);
        this.run_cancel.addKeyListener(this);
        gbl.setConstraints(this.run_cancel, gbc);
        prun.add(this.run_cancel);
        return prun;
    }

    public void startedLocalServer() {
        this.connserv.setEnabled(false);
        this.conn_connect.setEnabled(false);
        this.run_startserv.setEnabled(false);
        this.run_cancel.setEnabled(false);
    }

    public void lostServerConnection(String errText) {
        this.clickConnCancel();
        this.clickRunCancel();
        this.setTopText(errText);
        this.setCursor(Cursor.getPredefinedCursor(0));
        for (JButton b : new JButton[]{this.connserv, this.conn_connect, this.conn_cancel, this.runserv, this.run_startserv, this.run_cancel}) {
            b.setEnabled(true);
        }
    }

    public void setTopText(String newText) {
        this.topText.setText(newText);
        this.validate();
    }

    public void setServerHostPort(String chost, int cport) {
        if (chost != null && !this.conn_servhost.getText().equals(chost)) {
            this.conn_servhost.setText(chost);
        }
        String pstr = String.valueOf(cport);
        if (!this.conn_servport.getText().equals(pstr)) {
            this.conn_servport.setText(pstr);
        }
    }

    private final int parsePortNumberOrDefault(JTextField tf) {
        int srport;
        try {
            String ptext = tf.getText().trim();
            srport = ptext.length() > 0 ? Integer.parseInt(ptext) : this.clientNetwork.getPort();
            if (srport <= 0 || srport > 65535) {
                srport = 0;
            }
        }
        catch (NumberFormatException e) {
            srport = 0;
        }
        return srport;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            Object src = ae.getSource();
            if (src == this.prac) {
                this.md.clickPracticeButton();
                return;
            }
            if (src == this.connserv) {
                this.panel_conn.setVisible(true);
                if (this.panel_run != null && this.panel_run.isVisible()) {
                    this.panel_run.setVisible(false);
                    this.runserv.setVisible(true);
                }
                this.connserv.setVisible(false);
                this.conn_servhost.requestFocus();
                this.validate();
                return;
            }
            if (src == this.conn_connect) {
                this.clickConnConnect();
                return;
            }
            if (src == this.conn_cancel) {
                this.clickConnCancel();
                return;
            }
            if (src == this.runserv) {
                this.panel_run.setVisible(true);
                if (this.panel_conn != null && this.panel_conn.isVisible()) {
                    this.panel_conn.setVisible(false);
                    this.connserv.setVisible(true);
                }
                this.runserv.setVisible(false);
                this.run_servport.requestFocus();
                String svpText = this.run_servport.getText();
                if (svpText != null && svpText.trim().length() > 0) {
                    this.run_servport.setSelectionStart(0);
                    this.run_servport.setSelectionEnd(svpText.length());
                }
                this.validate();
                return;
            }
            if (src == this.run_startserv) {
                this.clickRunStartserv();
                return;
            }
            if (src == this.run_cancel) {
                this.clickRunCancel();
                return;
            }
        }
        catch (Throwable thr) {
            System.err.println("-- Error caught in AWT event thread: " + thr + " --");
            thr.printStackTrace();
            while (thr.getCause() != null) {
                thr = thr.getCause();
                System.err.println(" --> Cause: " + thr + " --");
                thr.printStackTrace();
            }
            System.err.println("-- Error stack trace end --");
            System.err.println();
        }
    }

    private void clickConnConnect() {
        int cport;
        String cserv = this.conn_servhost.getText().trim();
        if (cserv.length() == 0) {
            cserv = null;
        }
        if ((cport = this.parsePortNumberOrDefault(this.conn_servport)) == 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.md.getClient().connect(cserv, cport, this.conn_user.getText(), this.conn_pass.getText());
    }

    private void clickConnCancel() {
        this.panel_conn.setVisible(false);
        this.connserv.setVisible(true);
        this.validate();
    }

    private void clickRunStartserv() {
        int srport = this.parsePortNumberOrDefault(this.run_servport);
        if (srport > 0) {
            this.md.startLocalTCPServer(srport);
        }
    }

    private void clickRunCancel() {
        this.panel_run.setVisible(false);
        this.runserv.setVisible(true);
        this.validate();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        try {
            boolean panelConnShowing = this.panel_conn != null && this.panel_conn.isVisible();
            boolean panelRunShowing = this.panel_run != null && this.panel_run.isVisible();
            switch (e.getKeyCode()) {
                case 10: {
                    if (panelConnShowing) {
                        this.clickConnConnect();
                        break;
                    }
                    if (!panelRunShowing) break;
                    this.clickRunStartserv();
                    break;
                }
                case 3: 
                case 27: {
                    if (panelConnShowing) {
                        this.clickConnCancel();
                        break;
                    }
                    if (!panelRunShowing) break;
                    this.clickRunCancel();
                }
            }
        }
        catch (Throwable thr) {
            System.err.println("-- Error caught in AWT event thread: " + thr + " --");
            thr.printStackTrace();
            while (thr.getCause() != null) {
                thr = thr.getCause();
                System.err.println(" --> Cause: " + thr + " --");
                thr.printStackTrace();
            }
            System.err.println("-- Error stack trace end --");
            System.err.println();
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    static final class BoxedJPanel
    extends JPanel {
        public BoxedJPanel() {
        }

        public BoxedJPanel(LayoutManager m) {
            super(m);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

