/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.SwingMainDisplay;
import soc.util.SOCStringManager;

public abstract class SOCDialog
extends JDialog
implements Runnable,
WindowListener {
    protected static final SOCStringManager strings = SOCStringManager.getClientManager();
    protected final SOCPlayerInterface playerInterface;
    private JComponent northComponent;
    private final JPanel middlePanel;
    private JPanel southPanel;

    protected SOCDialog(SOCPlayerInterface piParent, String titleText, String promptText, boolean canCloseAndESC, boolean middleFillsCenter) {
        super(piParent, titleText, true);
        Font panelFont;
        this.setDefaultCloseOperation(0);
        if (canCloseAndESC) {
            this.addWindowListener(this);
            JRootPane rp = this.getRootPane();
            InputMap im = rp.getInputMap(2);
            ActionMap am = rp.getActionMap();
            im.put(KeyStroke.getKeyStroke(27, 0), "cancel");
            am.put("cancel", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SOCDialog.this.windowCloseChosen();
                }
            });
        }
        this.playerInterface = piParent;
        if (piParent != null) {
            this.setLocationRelativeTo(piParent);
        }
        if ((panelFont = this.getFont()).getSize() < 12) {
            panelFont = panelFont.deriveFont(12.0f);
            this.setFont(panelFont);
        }
        JRootPane rpane = this.getRootPane();
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        if (!isOSHighContrast) {
            Color[] colors = SwingMainDisplay.getForegroundBackgroundColors(true, false);
            rpane.setBackground(colors[2]);
            rpane.setForeground(colors[0]);
        }
        rpane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        Container cpane = this.getContentPane();
        if (!(cpane instanceof JPanel)) {
            cpane = new JPanel();
            this.setContentPane(cpane);
        }
        if (!isOSHighContrast) {
            cpane.setBackground(null);
            cpane.setForeground(null);
        }
        cpane.setFont(panelFont);
        if (promptText != null) {
            this.northComponent = new JLabel(promptText, 0);
            if (!isOSHighContrast) {
                this.northComponent.setForeground(null);
            }
            this.northComponent.setFont(panelFont);
            this.northComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
            this.add((Component)this.northComponent, "North");
        }
        if (middleFillsCenter) {
            this.middlePanel = this.makeJPanel(panelFont);
            this.add((Component)this.middlePanel, "Center");
        } else {
            JPanel wrapperContainer = new JPanel();
            wrapperContainer.setLayout(new BoxLayout(wrapperContainer, 0));
            if (!isOSHighContrast) {
                wrapperContainer.setBackground(null);
                wrapperContainer.setForeground(null);
            }
            this.middlePanel = new JPanel(){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            if (!isOSHighContrast) {
                this.middlePanel.setBackground(null);
                this.middlePanel.setForeground(null);
            }
            this.middlePanel.setFont(panelFont);
            this.middlePanel.setAlignmentX(0.5f);
            wrapperContainer.add(Box.createHorizontalGlue());
            wrapperContainer.add(this.middlePanel);
            wrapperContainer.add(Box.createHorizontalGlue());
            this.add((Component)wrapperContainer, "Center");
        }
    }

    protected JPanel getMiddlePanel() {
        return this.middlePanel;
    }

    protected JPanel getSouthPanel() {
        if (this.southPanel == null) {
            this.southPanel = this.makeJPanel(new FlowLayout(1, 4, 0), this.getFont());
            this.southPanel.setBorder(BorderFactory.createEmptyBorder(16, 0, 0, 0));
            this.southPanel.setAlignmentX(0.5f);
            this.add((Component)this.southPanel, "South");
        }
        return this.southPanel;
    }

    protected final JPanel makeJPanel(Font panelFont) {
        return this.makeJPanel(null, panelFont);
    }

    protected final JPanel makeJPanel(LayoutManager lm, Font panelFont) {
        JPanel p;
        JPanel jPanel = p = lm == null ? new JPanel() : new JPanel(lm);
        if (!SwingMainDisplay.isOSColorHighContrast()) {
            p.setBackground(null);
            p.setForeground(null);
        }
        if (panelFont != null) {
            p.setFont(panelFont);
        }
        return p;
    }

    public static final void styleButtonsAndLabels(Container c) {
        Font panelFont = c.getFont();
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        boolean shouldClearButtonBGs = !isOSHighContrast && SOCPlayerClient.IS_PLATFORM_WINDOWS;
        for (Component co : c.getComponents()) {
            if (!(co instanceof JLabel) && !(co instanceof JButton)) continue;
            if (co instanceof JLabel) {
                co.setFont(panelFont);
                if (isOSHighContrast) continue;
                co.setForeground(null);
                co.setBackground(null);
                continue;
            }
            if (!shouldClearButtonBGs) continue;
            co.setBackground(null);
        }
    }

    public void windowCloseChosen() {
    }

    @Override
    public void run() {
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
        this.windowCloseChosen();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }
}

