/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import soc.client.ColorSquare;
import soc.client.GameMessageSender;
import soc.client.SOCDialog;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.SwingMainDisplay;
import soc.game.SOCResourceSet;

class SOCDiscardOrGainResDialog
extends SOCDialog
implements ActionListener,
MouseListener,
Runnable {
    private final boolean isDiscard;
    private final JButton clearBut;
    private final JButton okBut;
    private final JButton cancelBut;
    private final ColorSquare[] keep;
    private final ColorSquare[] pick;
    private final int numPickNeeded;
    private int numChosen;

    public SOCDiscardOrGainResDialog(SOCPlayerInterface pi, int numPickNeeded, boolean isDiscard, boolean withCancel) {
        super(pi, strings.get(isDiscard ? "dialog.discard.title" : "dialog.discard.title.gain", pi.getClientNickname()), strings.get(isDiscard ? "dialog.discard.please.discard.n" : "dialog.discard.please.pick.n", numPickNeeded), withCancel, false);
        boolean shouldClearButtonBGs;
        this.isDiscard = isDiscard;
        this.numPickNeeded = numPickNeeded;
        this.numChosen = 0;
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
        this.clearBut = withCancel ? null : new JButton(strings.get("base.clear"));
        this.cancelBut = withCancel ? new JButton(strings.get("base.cancel")) : null;
        this.okBut = new JButton(strings.get(isDiscard ? "dialog.discard.discard" : "dialog.discard.pick"));
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        boolean bl = shouldClearButtonBGs = !isOSHighContrast && SOCPlayerClient.IS_PLATFORM_WINDOWS;
        if (shouldClearButtonBGs) {
            if (withCancel) {
                this.cancelBut.setBackground(null);
            } else {
                this.clearBut.setBackground(null);
            }
            this.okBut.setBackground(null);
        }
        JPanel resPanel = this.getMiddlePanel();
        resPanel.setLayout(new BoxLayout(resPanel, 1));
        JLabel youHave = new JLabel(strings.get("dialog.discard.you.have"), 2);
        youHave.setAlignmentX(0.0f);
        youHave.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        resPanel.add(youHave);
        this.keep = new ColorSquare[5];
        this.pick = new ColorSquare[5];
        int sqSize = 20 * pi.displayScale;
        JPanel keepPanel = new JPanel(new GridLayout(1, 0, sqSize, 0));
        JPanel pickPanel = new JPanel(new GridLayout(1, 0, sqSize, 0));
        if (!isOSHighContrast) {
            keepPanel.setBackground(null);
            pickPanel.setBackground(null);
        }
        keepPanel.setAlignmentX(0.0f);
        pickPanel.setAlignmentX(0.0f);
        for (int i = 0; i < 5; ++i) {
            Color sqColor = ColorSquare.RESOURCE_COLORS[i];
            this.keep[i] = new ColorSquare(4, false, sqSize, sqSize, sqColor);
            this.pick[i] = new ColorSquare(3, false, sqSize, sqSize, sqColor);
            keepPanel.add(this.keep[i]);
            pickPanel.add(this.pick[i]);
            this.keep[i].addMouseListener(this);
            this.pick[i].addMouseListener(this);
        }
        resPanel.add(keepPanel);
        JLabel pickThese = new JLabel(strings.get(numPickNeeded == 1 ? (isDiscard ? "dialog.discard.this" : "dialog.discard.gain.this") : (isDiscard ? "dialog.discard.this.plural" : "dialog.discard.gain.this.plural")), 2);
        pickThese.setAlignmentX(0.0f);
        pickThese.setBorder(BorderFactory.createEmptyBorder(20, 0, 4, 0));
        resPanel.add(pickThese);
        resPanel.add(pickPanel);
        SOCResourceSet resources = this.playerInterface.getClientPlayer().getResources();
        this.keep[0].setIntValue(resources.getAmount(1));
        this.keep[1].setIntValue(resources.getAmount(2));
        this.keep[2].setIntValue(resources.getAmount(3));
        this.keep[3].setIntValue(resources.getAmount(4));
        this.keep[4].setIntValue(resources.getAmount(5));
        SOCDiscardOrGainResDialog.styleButtonsAndLabels(resPanel);
        JPanel btnsPanel = this.getSouthPanel();
        JButton b = withCancel ? this.cancelBut : this.clearBut;
        btnsPanel.add(b);
        b.addActionListener(this);
        b.setEnabled(withCancel);
        btnsPanel.add(this.okBut);
        this.okBut.addActionListener(this);
        if (numPickNeeded > 0) {
            this.okBut.setEnabled(false);
        }
        SOCDiscardOrGainResDialog.styleButtonsAndLabels(btnsPanel);
        this.getRootPane().setDefaultButton(this.okBut);
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            this.okBut.requestFocus();
            this.playerInterface.playSound(this.isDiscard ? SOCPlayerInterface.SOUND_RSRC_LOST : SOCPlayerInterface.SOUND_RSRC_GAINED_FREE);
        }
        super.setVisible(vis);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object target = e.getSource();
            if (target == this.okBut) {
                SOCResourceSet rsrcs = new SOCResourceSet(this.pick[0].getIntValue(), this.pick[1].getIntValue(), this.pick[2].getIntValue(), this.pick[3].getIntValue(), this.pick[4].getIntValue(), 0);
                if (rsrcs.getTotal() == this.numPickNeeded) {
                    GameMessageSender messageSender = this.playerInterface.getClient().getGameMessageSender();
                    if (this.isDiscard) {
                        messageSender.discard(this.playerInterface.getGame(), rsrcs);
                    } else {
                        messageSender.pickResources(this.playerInterface.getGame(), rsrcs);
                    }
                    this.dispose();
                }
            } else if (this.clearBut != null && target == this.clearBut) {
                for (int i = this.pick.length - 1; i >= 0; --i) {
                    if (this.isDiscard) {
                        this.keep[i].addValue(this.pick[i].getIntValue());
                    }
                    this.pick[i].setIntValue(0);
                }
                this.numChosen = 0;
                this.clearBut.setEnabled(false);
                this.okBut.setEnabled(this.numPickNeeded == this.numChosen);
            } else if (this.cancelBut != null && target == this.cancelBut) {
                this.clickedCancel();
            }
        }
        catch (Throwable th) {
            this.playerInterface.chatPrintStackTrace(th);
        }
    }

    public void clickedCancel() {
        if (this.cancelBut == null) {
            return;
        }
        this.playerInterface.getClient().getGameMessageSender().cancelBuildRequest(this.playerInterface.getGame(), -2);
        this.dispose();
    }

    @Override
    public void windowCloseChosen() {
        this.clickedCancel();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            Object target = e.getSource();
            boolean wantsRepaint = false;
            for (int i = 0; i < 5; ++i) {
                if (target == this.keep[i] && this.pick[i].getIntValue() > 0) {
                    if (this.isDiscard) {
                        this.keep[i].addValue(1);
                    }
                    this.pick[i].subtractValue(1);
                    --this.numChosen;
                    if (this.numChosen == this.numPickNeeded - 1) {
                        this.okBut.setEnabled(false);
                        wantsRepaint = true;
                        break;
                    }
                    if (this.numChosen != this.numPickNeeded) break;
                    this.okBut.setEnabled(true);
                    wantsRepaint = true;
                    break;
                }
                if (target != this.pick[i] || this.keep[i].getIntValue() <= 0 && this.isDiscard) continue;
                int currPickI = this.pick[i].getIntValue();
                if (currPickI >= this.numPickNeeded) {
                    return;
                }
                if (this.numPickNeeded == 1 && this.numChosen == 1) {
                    if (currPickI == 1) {
                        return;
                    }
                    for (int j = 0; j < 5; ++j) {
                        int n = this.pick[j].getIntValue();
                        if (n == 0) continue;
                        if (this.isDiscard) {
                            this.keep[j].addValue(n);
                        }
                        this.pick[j].subtractValue(n);
                    }
                    this.numChosen = 0;
                }
                if (this.isDiscard) {
                    this.keep[i].subtractValue(1);
                }
                this.pick[i].addValue(1);
                ++this.numChosen;
                if (this.numChosen == this.numPickNeeded) {
                    this.okBut.setEnabled(true);
                    wantsRepaint = true;
                    break;
                }
                if (this.numChosen != this.numPickNeeded + 1) break;
                this.okBut.setEnabled(false);
                wantsRepaint = true;
                break;
            }
            if (this.clearBut != null) {
                this.clearBut.setEnabled(this.numChosen > 0);
            }
            if (wantsRepaint) {
                this.okBut.repaint();
            }
        }
        catch (Throwable th) {
            this.playerInterface.chatPrintStackTrace(th);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

