/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import soc.client.FaceChooserFrame;
import soc.client.SOCPlayerInterface;
import soc.game.SOCGame;

class SOCFaceButton
extends Canvas {
    public static final int DEFAULT_FACE = 1;
    private static final String IMAGEDIR = "/resources/images";
    public static final int NUM_FACES = 74;
    public static final int NUM_ROBOT_FACES = 2;
    public static final int FACE_WIDTH_PX = 40;
    public static final int FACE_BORDER_WIDTH_PX = 2;
    public static final int FACE_WIDTH_BORDERED_PX = 44;
    private static Image[] images;
    private static Image[] robotImages;
    private static MediaTracker tracker;
    private int currentImageNum = 1;
    private int panelx;
    private int panely;
    private final int pNumber;
    private final SOCGame game;
    private final SOCPlayerInterface pi;
    private FaceChooserFrame faceChooser;
    private boolean hilightBorderShown;
    private boolean hilightBorderWasShown;
    private Color hilightBorderColor;
    private FaceButtonPopupMenu popupMenu;
    private long popupMenuSystime;
    protected static int POPUP_MENU_IGNORE_MS;
    private Image buffer;
    protected Dimension ourSize;

    private static synchronized void loadImages(Component c) {
        if (images == null) {
            int i;
            tracker = new MediaTracker(c);
            Toolkit tk = c.getToolkit();
            Class<?> clazz = c.getClass();
            images = new Image[74];
            robotImages = new Image[2];
            SOCFaceButton.robotImages[0] = tk.getImage(clazz.getResource("/resources/images/robot.gif"));
            tracker.addImage(robotImages[0], 0);
            for (i = 1; i < 74; ++i) {
                SOCFaceButton.images[i] = tk.getImage(clazz.getResource("/resources/images/face" + i + ".gif"));
                tracker.addImage(images[i], 0);
            }
            for (i = 1; i < 2; ++i) {
                URL imgSrc = clazz.getResource("/resources/images/robot" + i + ".gif");
                if (imgSrc == null) continue;
                SOCFaceButton.robotImages[i] = tk.getImage(imgSrc);
                tracker.addImage(robotImages[i], i);
            }
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (tracker.isErrorID(0)) {
                System.out.println("Error loading Face images");
            }
        }
    }

    public SOCFaceButton(SOCPlayerInterface pi, int pn) throws IllegalArgumentException {
        this(pi, pn, pi.getPlayerColor(pn), 40 * pi.displayScale);
    }

    public SOCFaceButton(SOCPlayerInterface pi, FaceChooserFrame fcf, int faceId) {
        this(pi, -1, fcf.getPlayerColor(), 44 * pi.displayScale);
        this.setFace(faceId);
        this.faceChooser = fcf;
    }

    private SOCFaceButton(SOCPlayerInterface pi, int pn, Color bgColor, int width) throws IllegalArgumentException {
        this.pi = pi;
        if (pn == -1) {
            this.game = null;
        } else {
            this.game = pi.getGame();
            if (this.game == null) {
                throw new IllegalArgumentException("null pi.getGgame");
            }
            if (pn < 0 && pn <= this.game.maxPlayers) {
                throw new IllegalArgumentException("Player number out of range: " + pn);
            }
        }
        this.pNumber = pn;
        this.faceChooser = null;
        this.hilightBorderShown = false;
        this.hilightBorderColor = null;
        this.setBackground(bgColor);
        this.panelx = width;
        this.panely = width;
        this.ourSize = new Dimension(this.panelx, this.panely);
        SOCFaceButton.loadImages(this);
        this.addMouseListener(new MyMouseAdapter());
        this.setSize(this.ourSize);
        this.setMinimumSize(this.ourSize);
        this.setPreferredSize(this.ourSize);
    }

    public int getFace() {
        return this.currentImageNum;
    }

    public void setFace(int id) {
        if (id >= 74) {
            id = 1;
        } else if (id <= -2) {
            id = 0;
        }
        this.currentImageNum = id;
        this.repaint();
    }

    public void setDefaultFace() {
        this.setFace(1);
    }

    public void addFacePopupMenu() throws IllegalStateException {
        if (this.popupMenu == null) {
            if (this.game == null || this.pNumber != this.pi.getClientPlayerNumber()) {
                throw new IllegalStateException("Player must be client");
            }
            this.popupMenu = new FaceButtonPopupMenu(this);
            this.add(this.popupMenu);
        }
    }

    public void removeFacePopupMenu() {
        if (this.popupMenu != null) {
            this.remove(this.popupMenu);
            this.popupMenu = null;
        }
    }

    public void clearFacePopupPreviousChooser() {
        if (this.popupMenu != null) {
            this.popupMenu.clearPreviousChooser();
        }
    }

    public void setHilightBorder(boolean wantBorder) throws IllegalStateException {
        if (this.faceChooser == null) {
            throw new IllegalStateException("Border only usable in FaceChooser bordered mode");
        }
        if (this.hilightBorderShown == wantBorder) {
            return;
        }
        this.hilightBorderWasShown = this.hilightBorderShown;
        this.hilightBorderShown = wantBorder;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.ourSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.ourSize;
    }

    @Override
    public Dimension getSize() {
        return this.ourSize;
    }

    @Override
    public void paint(Graphics g) {
        if (this.buffer == null) {
            this.buffer = this.createImage(this.panelx, this.panely);
        }
        this.drawFace(this.buffer.getGraphics());
        this.buffer.flush();
        g.drawImage(this.buffer, 0, 0, this);
        if (this.hilightBorderShown) {
            this.paintBorder(g, true);
        } else if (this.hilightBorderWasShown) {
            this.paintBorder(g, false);
            this.hilightBorderWasShown = false;
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private void drawFace(Graphics g) {
        Image fimage;
        int displayScale = this.pi.displayScale;
        if (this.currentImageNum > 0) {
            int findex = this.currentImageNum;
            if (findex >= 74 || null == images[findex]) {
                this.currentImageNum = findex = 1;
            }
            fimage = images[findex];
        } else {
            int findex = -this.currentImageNum;
            if (findex >= 2 || null == robotImages[findex] || 0 != (tracker.statusID(findex, false) & 6)) {
                findex = 0;
                this.currentImageNum = -findex;
            }
            fimage = robotImages[findex];
        }
        int offs = this.panelx == 44 * displayScale ? 2 * displayScale : 0;
        if (displayScale == 1) {
            g.drawImage(fimage, offs, offs, this.getBackground(), this);
        } else {
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            int w = this.panelx;
            int h = this.panely;
            if (offs != 0) {
                w -= 2 * offs;
                h -= 2 * offs;
            }
            g.drawImage(fimage, offs, offs, w, h, this.getBackground(), this);
        }
    }

    private void paintBorder(Graphics g, boolean showNotClear) {
        Color drawColor;
        if (showNotClear) {
            if (this.hilightBorderColor == null) {
                this.hilightBorderColor = SOCPlayerInterface.makeGhostColor(this.getBackground());
            }
            drawColor = this.hilightBorderColor;
        } else {
            drawColor = this.getBackground();
        }
        int pix1 = this.pi.displayScale;
        int pix3 = 3 * pix1;
        g.setColor(drawColor);
        g.drawRect(0, pix1, this.panelx - pix1, this.panely - pix3);
        g.drawRect(pix1, 0, this.panelx - pix3, this.panely - pix1);
    }

    static {
        POPUP_MENU_IGNORE_MS = 150;
    }

    protected static class FaceButtonPopupMenu
    extends PopupMenu
    implements ActionListener {
        SOCFaceButton fb;
        MenuItem changeFaceItem;
        FaceChooserFrame fsf;

        public FaceButtonPopupMenu(SOCFaceButton fbutton) {
            super("JSettlers");
            this.fb = fbutton;
            this.changeFaceItem = new MenuItem("Change face...");
            this.add(this.changeFaceItem);
            this.changeFaceItem.addActionListener(this);
        }

        public void show(int x, int y) {
            super.show(this.fb, x, y);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() != this.changeFaceItem) {
                    return;
                }
                this.showFaceChooserFrame();
            }
            catch (Throwable th) {
                this.fb.pi.chatPrintStackTrace(th);
            }
        }

        private void showFaceChooserFrame() {
            if (this.fsf == null || !this.fsf.isStillAvailable()) {
                this.fsf = new FaceChooserFrame(this.fb, this.fb.pi.getClient(), this.fb.pi, this.fb.pNumber, this.fb.getFace(), this.fb.getSize().width);
                this.fsf.pack();
            }
            this.fsf.setVisible(true);
        }

        public void clearPreviousChooser() {
            FaceChooserFrame prevFSF = this.fsf;
            if (prevFSF != null) {
                prevFSF.dispose();
                this.fsf = null;
            }
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            this.mouseReleased(evt);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            try {
                int x = evt.getX();
                if (evt.isPopupTrigger()) {
                    SOCFaceButton.this.popupMenuSystime = evt.getWhen();
                    evt.consume();
                    if (SOCFaceButton.this.popupMenu != null) {
                        SOCFaceButton.this.popupMenu.show(x, evt.getY());
                    }
                    return;
                }
                if (evt.getWhen() < SOCFaceButton.this.popupMenuSystime + (long)POPUP_MENU_IGNORE_MS) {
                    return;
                }
                if (SOCFaceButton.this.faceChooser != null) {
                    SOCFaceButton.this.faceChooser.selectFace(SOCFaceButton.this.currentImageNum, SOCFaceButton.this.hilightBorderShown);
                    evt.consume();
                    return;
                }
                if (SOCFaceButton.this.game == null) {
                    return;
                }
                if (SOCFaceButton.this.game.isDebugFreePlacement()) {
                    SOCFaceButton.this.pi.setDebugFreePlacementPlayer(SOCFaceButton.this.pNumber);
                    evt.consume();
                    return;
                }
                if (SOCFaceButton.this.popupMenu != null) {
                    if (evt.getClickCount() >= 2) {
                        evt.consume();
                        SOCFaceButton.this.popupMenu.showFaceChooserFrame();
                        return;
                    }
                    if (x < SOCFaceButton.this.getWidth() / 2) {
                        SOCFaceButton.this.currentImageNum--;
                        if (SOCFaceButton.this.currentImageNum <= 0) {
                            SOCFaceButton.this.currentImageNum = 73;
                        }
                    } else {
                        SOCFaceButton.this.currentImageNum++;
                        if (SOCFaceButton.this.currentImageNum == 74) {
                            SOCFaceButton.this.currentImageNum = 1;
                        }
                    }
                    evt.consume();
                    SOCFaceButton.this.pi.getClient().getGameMessageSender().changeFace(SOCFaceButton.this.game, SOCFaceButton.this.currentImageNum);
                    SOCFaceButton.this.repaint();
                }
            }
            catch (Throwable th) {
                SOCFaceButton.this.pi.chatPrintStackTrace(th);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            try {
                if (evt.isPopupTrigger()) {
                    SOCFaceButton.this.popupMenuSystime = evt.getWhen();
                    evt.consume();
                    if (SOCFaceButton.this.popupMenu != null) {
                        SOCFaceButton.this.popupMenu.show(evt.getX(), evt.getY());
                    }
                    return;
                }
            }
            catch (Throwable th) {
                SOCFaceButton.this.pi.chatPrintStackTrace(th);
            }
        }
    }
}

