/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import soc.client.ColorSquare;
import soc.client.GameMessageSender;
import soc.client.MessagePanel;
import soc.client.NotifyDialog;
import soc.client.PlayerClientListener;
import soc.client.SOCBuildingPanel;
import soc.client.SOCFaceButton;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.SOCQuitConfirmDialog;
import soc.client.SquaresPanel;
import soc.client.SwingMainDisplay;
import soc.client.TradePanel;
import soc.game.SOCDevCard;
import soc.game.SOCGame;
import soc.game.SOCInventory;
import soc.game.SOCInventoryItem;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.game.SOCSpecialItem;
import soc.game.SOCTradeOffer;
import soc.util.SOCStringManager;

class SOCHandPanel
extends JPanel
implements ActionListener,
MouseListener {
    public static final int WIDTH_MIN = 218;
    public static final int NUMRESOURCES = -3;
    public static final int NUMDEVCARDS = -4;
    public static final int VICTORYPOINTS = -6;
    public static final int LONGESTROAD = -7;
    public static final int LARGESTARMY = -8;
    public static final int SPECIALVICTORYPOINTS = 9;
    public static final int AUTOROLL_TIME = 5;
    protected static final int[] zero = new int[]{0, 0, 0, 0, 0};
    private static final SOCStringManager strings = SOCStringManager.getClientManager();
    protected static final String SITLOCKED = strings.get("hpan.sit.locked.norobot");
    protected static final String SIT = strings.get("hpan.sit.here");
    protected static final String START = strings.get("hpan.start.game");
    protected static final String ROBOT = strings.get("hpan.sit.robot");
    protected static final String TAKEOVER = strings.get("hpan.sit.takeover");
    private static final String SEAT_LOCKED = "* " + strings.get("hpan.seat.locked") + " *";
    protected static final String LOCKSEAT = strings.get("hpan.sit.lock");
    protected static final String UNLOCKSEAT = strings.get("hpan.sit.unlock");
    private static final String LOCKSEATTIP = strings.get("hpan.sit.lock.tip");
    private static final String UNLOCKSEATTIP = strings.get("hpan.sit.unlock.tip");
    protected static final String ROLL = strings.get("hpan.roll");
    protected static final String QUIT = strings.get("hpan.quit");
    protected static final String DONE = strings.get("hpan.done");
    protected static final String DONE_RESTART = strings.get("base.restart");
    protected static final String CLEAR = strings.get("hpan.trade.clear");
    protected static final String SEND = strings.get("hpan.trade.offer");
    protected static final String BANK = strings.get("hpan.trade.bankport");
    private static final String BANK_UNDO = strings.get("hpan.trade.undo");
    private static final String CARD = " " + strings.get("hpan.devcards.play") + " ";
    private static final String CANCEL = strings.get("base.cancel");
    protected static final String GIVE = strings.get("hpan.trade.igive");
    protected static final String GET = strings.get("hpan.trade.iget");
    private static final String DEVCARD_NEW = strings.get("hpan.devcards.prefix.new");
    private static final String RESOURCES = strings.get("hpan.rsrc") + " ";
    private static final String RESOURCES_TOTAL = strings.get("hpan.rsrc.total") + " ";
    protected static final String AUTOROLL_COUNTDOWN = strings.get("hpan.roll.auto_countdown");
    protected static final String ROLL_OR_PLAY_CARD = strings.get("hpan.roll.rollorplaycard");
    private static final String OFFERBUTTIP_ENA = strings.get("hpan.trade.offer.tip.send");
    private static final String OFFERBUTTIP_DIS = strings.get("hpan.trade.offer.tip.first");
    private static final String ROBOTLOCKBUT_U = strings.get("hpan.sit.unlocked");
    private static final String ROBOTLOCKBUT_L = strings.get("hpan.sit.locked");
    private static final String ROBOTLOCKBUT_M = strings.get("hpan.sit.marked");
    private static final String ROBOTLOCKBUTTIP_L = strings.get("hpan.sit.locked.tip");
    private static final String ROBOTLOCKBUTTIP_U = strings.get("hpan.sit.unlocked.tip");
    private static final String ROBOTLOCKBUTTIP_M = strings.get("hpan.sit.marked.tip");
    private static final String ROBOTLOCKBUTTIP_L_OLD = strings.get("hpan.sit.locked.tip.nomark");
    private static final String ROBOTLOCKBUTTIP_U_OLD = strings.get("hpan.sit.unlocked.tip.nomark");
    private static final String TRADEMSG_DISCARD = strings.get("hpan.discarding");
    private static final String TRADEMSG_PICKING = strings.get("hpan.picking.rsrcs");
    protected static final Color COLOR_FOREGROUND = Color.BLACK;
    private static boolean didSwingTooltipDefaults;
    private boolean didHotkeyBindings;
    protected Color pnameActiveBG;
    private ColorSquare blankStandIn;
    protected JButton sitBut;
    protected JButton robotBut;
    protected JButton startBut;
    protected JButton takeOverBut;
    protected JButton sittingRobotLockBut;
    protected boolean sitButIsLock;
    protected SOCFaceButton faceImg;
    protected JLabel pname;
    protected JLabel vpLab;
    protected ColorSquare vpSq;
    private JLabel svpLab;
    private ColorSquare svpSq;
    protected JLabel larmyLab;
    protected JLabel lroadLab;
    protected ColorSquare claySq;
    protected ColorSquare oreSq;
    protected ColorSquare sheepSq;
    protected ColorSquare wheatSq;
    protected ColorSquare woodSq;
    protected ColorSquare resourceSqDivLine;
    protected JLabel clayLab;
    protected JLabel oreLab;
    protected JLabel sheepLab;
    protected JLabel wheatLab;
    protected JLabel woodLab;
    protected int[] resourceTradeCost;
    protected ResourceTradeTypeMenu[] resourceTradeMenu;
    protected ColorSquare settlementSq;
    protected ColorSquare citySq;
    protected ColorSquare roadSq;
    protected ColorSquare shipSq;
    protected JLabel settlementLab;
    protected JLabel cityLab;
    protected JLabel roadLab;
    protected JLabel shipLab;
    protected ColorSquare resourceSq;
    protected JLabel resourceLab;
    protected ColorSquare developmentSq;
    protected JLabel developmentLab;
    protected ColorSquare knightsSq;
    protected JLabel knightsLab;
    protected JList<String> inventory;
    private ArrayList<SOCInventoryItem> inventoryItems;
    private JScrollPane inventoryScroll;
    protected JButton playCardBut;
    private boolean canCancelInvItemPlay;
    protected SquaresPanel sqPanel;
    protected ColorSquare clothSq;
    protected JLabel clothLab;
    private JLabel wonderLab;
    private ColorSquare undosSq;
    private JLabel undosLab;
    protected boolean playerTradingDisabled;
    protected JLabel giveLab;
    protected JLabel getLab;
    protected JButton offerBut;
    protected JButton clearOfferBut;
    protected JButton bankBut;
    private SOCResourceSet bankGive;
    private SOCResourceSet bankGet;
    protected JButton bankUndoBut;
    protected ColorSquare[] playerSend;
    private boolean[] playerSendForPrevTrade;
    protected JLabel rollPromptCountdownLab;
    protected boolean rollPromptInUse;
    protected TimerTask autoRollTimerTask;
    protected JButton rollBut;
    protected JButton doneBut;
    protected boolean doneButIsRestart;
    protected JButton quitBut;
    protected final SOCPlayerInterface playerInterface;
    protected final SOCPlayerClient client;
    private final GameMessageSender messageSender;
    protected final SOCGame game;
    private boolean hasStartedNormalGameplay;
    protected final SOCPlayer player;
    private final int playerNumber;
    protected boolean playerIsClient;
    protected boolean playerIsCurrent;
    protected boolean inPlay;
    private JLabel miscInfoArea;
    protected int[] playerSendMap;
    private final TradePanel offerPanel;
    private final TradePanel counterOfferPanel;
    private final MessagePanel messagePanel;
    private boolean offerHidesControls;
    private boolean offerCounterHidesFace;
    private boolean offerHidingControls;
    private boolean offerCounterHidingFace;
    protected boolean messageIsReset;
    private boolean messageIsDiscardOrPick;
    protected boolean offerIsHiddenByMessage;
    protected final boolean interactive;
    private int doLayout_resourceLabelsWidth;
    private JLabel createColorSqRetLbl;
    private ColorSquare createColorSqRetSq;

    public SOCHandPanel(SOCPlayerInterface pi, SOCPlayer pl) {
        this(pi, pl, true);
    }

    public SOCHandPanel(final SOCPlayerInterface pi, SOCPlayer pl, boolean isInteractive) {
        super(null);
        this.playerInterface = pi;
        this.client = pi.getClient();
        this.messageSender = this.client.getGameMessageSender();
        this.game = pi.getGame();
        this.player = pl;
        this.playerNumber = this.player.getPlayerNumber();
        this.playerIsCurrent = false;
        this.playerIsClient = false;
        this.interactive = isInteractive;
        String FONT_SKIP_FLAG = DONE;
        int displayScale = pi.displayScale;
        int sqSize = 16 * displayScale;
        Color pcolor = this.playerInterface.getPlayerColor(this.playerNumber);
        boolean isOSColorHighContrast = SwingMainDisplay.isOSColorHighContrast();
        if (!isOSColorHighContrast) {
            this.setBackground(pcolor);
            this.setForeground(COLOR_FOREGROUND);
            this.setOpaque(true);
        }
        this.setFont(new Font("SansSerif", 0, 10 * displayScale));
        this.blankStandIn = new ColorSquare(isOSColorHighContrast ? ColorSquare.GREY : pcolor, strings.get("hpan.one.moment"));
        this.blankStandIn.setVisible(false);
        this.faceImg = new SOCFaceButton(this.playerInterface, this.playerNumber);
        if (isOSColorHighContrast) {
            this.faceImg.setBackground(pcolor);
        }
        this.add(this.faceImg);
        this.pname = new JLabel();
        this.pname.setFont(new Font("SansSerif", 0, 13 * displayScale));
        this.pname.setVerticalAlignment(1);
        this.pname.putClientProperty(FONT_SKIP_FLAG, Boolean.TRUE);
        this.pname.addMouseListener(this);
        this.pname.setBackground(null);
        this.pname.setOpaque(true);
        this.add(this.pname);
        this.pnameActiveBG = null;
        this.startBut = new JButton(START);
        this.startBut.addActionListener(this);
        this.add(this.startBut);
        this.vpLab = new JLabel(strings.get("hpan.points") + " ");
        this.add(this.vpLab);
        this.vpSq = new ColorSquare(ColorSquare.GREY, 0, sqSize, sqSize);
        this.vpSq.setToolTipText(strings.get("hpan.points.total.opponent"));
        String vp_close_to_win = strings.get("hpan.points.closetowin");
        if (this.game.vp_winner <= 12) {
            this.vpSq.setToolTipHighWarningLevel(vp_close_to_win, this.game.vp_winner - 2);
        } else {
            this.vpSq.setToolTipHighWarningLevel(vp_close_to_win, this.game.vp_winner - 3);
        }
        this.add(this.vpSq);
        if (this.game.hasSeaBoard) {
            String svp_tt = strings.get("hpan.svp.tt");
            this.svpLab = new JLabel(strings.get("hpan.svp") + " ");
            this.svpLab.setVisible(false);
            this.svpLab.setToolTipText(svp_tt);
            this.add(this.svpLab);
            this.svpLab.addMouseListener(this);
            this.svpSq = new ColorSquare(ColorSquare.GREY, 0, sqSize, sqSize);
            this.svpSq.setVisible(false);
            this.svpSq.setToolTipText(svp_tt);
            this.add(this.svpSq);
            this.svpSq.addMouseListener(this);
        } else {
            this.svpLab = null;
            this.svpSq = null;
        }
        Font DIALOG_PLAIN_10 = new Font("Dialog", 0, 10 * displayScale);
        this.larmyLab = new JLabel("", 0);
        this.larmyLab.setFont(DIALOG_PLAIN_10);
        this.add(this.larmyLab);
        this.lroadLab = new JLabel("", 4);
        this.lroadLab.setFont(DIALOG_PLAIN_10);
        this.add(this.lroadLab);
        this.createAndAddResourceColorSquare(ColorSquare.CLAY, "resources.clay");
        this.clayLab = this.createColorSqRetLbl;
        this.claySq = this.createColorSqRetSq;
        this.createAndAddResourceColorSquare(ColorSquare.ORE, "resources.ore");
        this.oreLab = this.createColorSqRetLbl;
        this.oreSq = this.createColorSqRetSq;
        this.createAndAddResourceColorSquare(ColorSquare.SHEEP, "resources.sheep");
        this.sheepLab = this.createColorSqRetLbl;
        this.sheepSq = this.createColorSqRetSq;
        this.createAndAddResourceColorSquare(ColorSquare.WHEAT, "resources.wheat");
        this.wheatLab = this.createColorSqRetLbl;
        this.wheatSq = this.createColorSqRetSq;
        this.createAndAddResourceColorSquare(ColorSquare.WOOD, "resources.wood");
        this.woodLab = this.createColorSqRetLbl;
        this.woodSq = this.createColorSqRetSq;
        this.createColorSqRetLbl = null;
        this.createColorSqRetSq = null;
        this.resourceSqDivLine = new ColorSquare(Color.BLACK);
        this.resourceSqDivLine.setMinimumSize(new Dimension(20 * displayScale, displayScale));
        this.add(this.resourceSqDivLine);
        this.inventoryItems = new ArrayList();
        this.inventory = new JList(new DefaultListModel());
        this.inventory.setVisibleRowCount(-1);
        this.inventory.setSelectionMode(0);
        this.inventory.setFont(this.getFont());
        this.inventory.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                e.consume();
                SOCHandPanel.this.clickPlayCardButton();
            }
        });
        this.inventoryScroll = new JScrollPane(this.inventory);
        this.add(this.inventoryScroll);
        this.init_removeInventoryHotkeyCtrlA();
        String pieces_available_to_place = strings.get("hpan.pieces.available");
        this.roadSq = new ColorSquare(ColorSquare.GREY, 0, sqSize, sqSize);
        this.add(this.roadSq);
        this.roadSq.setToolTipText(pieces_available_to_place);
        this.roadSq.setToolTipLowWarningLevel(strings.get("hpan.roads.almostout"), 2);
        this.roadSq.setToolTipZeroText(strings.get("hpan.roads.out"));
        this.roadLab = new JLabel(strings.get("hpan.roads"));
        this.roadLab.setFont(DIALOG_PLAIN_10);
        this.add(this.roadLab);
        this.settlementSq = new ColorSquare(ColorSquare.GREY, 0, sqSize, sqSize);
        this.add(this.settlementSq);
        this.settlementSq.setToolTipText(pieces_available_to_place);
        this.settlementSq.setToolTipLowWarningLevel(strings.get("hpan.stlmts.almostout"), 1);
        this.settlementSq.setToolTipZeroText(strings.get("hpan.stlmts.out"));
        this.settlementLab = new JLabel(strings.get("hpan.stlmts"));
        this.settlementLab.setFont(DIALOG_PLAIN_10);
        this.add(this.settlementLab);
        this.citySq = new ColorSquare(ColorSquare.GREY, 0, sqSize, sqSize);
        this.add(this.citySq);
        this.citySq.setToolTipText(pieces_available_to_place);
        this.citySq.setToolTipLowWarningLevel(strings.get("hpan.cities.almostout"), 1);
        this.citySq.setToolTipZeroText(strings.get("hpan.cities.out"));
        this.cityLab = new JLabel(strings.get("hpan.cities"));
        this.cityLab.setFont(DIALOG_PLAIN_10);
        this.add(this.cityLab);
        if (this.game.hasSeaBoard) {
            this.shipSq = new ColorSquare(ColorSquare.GREY, 0, sqSize, sqSize);
            this.add(this.shipSq);
            this.shipSq.setToolTipText(pieces_available_to_place);
            this.shipSq.setToolTipLowWarningLevel(strings.get("hpan.ships.almostout"), 2);
            this.shipSq.setToolTipZeroText(strings.get("hpan.ships.out"));
            this.shipLab = new JLabel(strings.get("hpan.ships"));
            this.shipLab.setFont(DIALOG_PLAIN_10);
            this.add(this.shipLab);
        }
        if (this.game.isGameOptionSet("UBL")) {
            this.undosSq = new ColorSquare(ColorSquare.GREY, 0, sqSize, sqSize);
            this.add(this.undosSq);
            int nStart = this.game.getGameOptionIntValue("UBL");
            this.undosSq.setLowWarningLevel(nStart <= 6 ? 1 : (nStart < 15 ? 2 : (nStart < 30 ? nStart / 5 : 5)));
            String ttip = strings.get("hpan.undos.tt");
            this.undosSq.setToolTipText(ttip);
            this.undosLab = new JLabel(strings.get("hpan.undos"));
            this.undosLab.setFont(DIALOG_PLAIN_10);
            this.add(this.undosLab);
            this.undosLab.setToolTipText(ttip);
        }
        if (this.game.isGameOptionSet("_SC_CLVI")) {
            this.clothLab = new JLabel(strings.get("hpan.cloth"));
            this.clothLab.setFont(DIALOG_PLAIN_10);
            this.add(this.clothLab);
            this.clothSq = new ColorSquare(ColorSquare.GREY, 0, sqSize, sqSize);
            this.add(this.clothSq);
            this.clothSq.setToolTipText(strings.get("hpan.cloth.amounttraded"));
        } else if (this.game.isGameOptionSet("_SC_WOND")) {
            this.wonderLab = new JLabel("");
            this.wonderLab.setFont(DIALOG_PLAIN_10);
            this.add(this.wonderLab);
            this.wonderLab.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    pi.buildingPanel.clickWondersButton();
                }
            });
        }
        this.knightsLab = new JLabel(strings.get("hpan.soldiers"));
        this.knightsLab.setFont(DIALOG_PLAIN_10);
        this.add(this.knightsLab);
        this.knightsSq = new ColorSquare(ColorSquare.GREY, 0, sqSize, sqSize);
        this.add(this.knightsSq);
        this.knightsSq.setToolTipText(strings.get("hpan.soldiers.sizearmy"));
        this.resourceLab = new JLabel(RESOURCES);
        this.add(this.resourceLab);
        this.resourceSq = new ColorSquare(ColorSquare.GREY, 0, sqSize, sqSize);
        this.add(this.resourceSq);
        this.resourceSq.setToolTipText(strings.get("hpan.amounthand"));
        this.resourceSq.setToolTipHighWarningLevel(strings.get("hpan.rsrc.roll7discard"), 8);
        this.developmentLab = new JLabel(strings.get("hpan.devcards") + " ");
        this.add(this.developmentLab);
        this.developmentSq = new ColorSquare(ColorSquare.GREY, 0, sqSize, sqSize);
        this.add(this.developmentSq);
        this.developmentSq.setToolTipText(strings.get("hpan.amounthand"));
        this.sittingRobotLockBut = new JButton(ROBOTLOCKBUT_U);
        this.sittingRobotLockBut.addActionListener(this);
        this.sittingRobotLockBut.setEnabled(this.interactive);
        this.add(this.sittingRobotLockBut);
        this.takeOverBut = new JButton(TAKEOVER);
        this.takeOverBut.addActionListener(this);
        this.takeOverBut.setEnabled(this.interactive);
        this.add(this.takeOverBut);
        this.sitBut = new JButton(SIT);
        this.sitBut.addActionListener(this);
        this.sitBut.setEnabled(this.interactive);
        this.add(this.sitBut);
        this.sitButIsLock = false;
        this.robotBut = new JButton(ROBOT);
        this.robotBut.addActionListener(this);
        this.robotBut.setEnabled(this.interactive);
        this.add(this.robotBut);
        this.playCardBut = new JButton(CARD);
        this.playCardBut.addActionListener(this);
        this.playCardBut.setEnabled(this.interactive);
        this.add(this.playCardBut);
        this.playerTradingDisabled = this.game.isGameOptionSet("NT");
        this.giveLab = new JLabel(GIVE);
        this.add(this.giveLab);
        if (this.interactive) {
            this.giveLab.setToolTipText(strings.get("hpan.trade.igive.tip"));
        }
        this.getLab = new JLabel(GET);
        this.add(this.getLab);
        if (this.interactive) {
            this.getLab.setToolTipText(strings.get("hpan.trade.iget.tip"));
        }
        this.sqPanel = new SquaresPanel(this.interactive, this, displayScale);
        this.add(this.sqPanel);
        this.sqPanel.setVisible(false);
        if (this.playerTradingDisabled) {
            this.offerBut = null;
        } else {
            this.offerBut = new JButton(SEND);
            this.offerBut.addActionListener(this);
            this.offerBut.setEnabled(this.interactive);
            this.add(this.offerBut);
            if (this.interactive) {
                this.offerBut.setToolTipText(OFFERBUTTIP_ENA);
            }
        }
        this.clearOfferBut = new JButton(CLEAR);
        this.clearOfferBut.addActionListener(this);
        this.clearOfferBut.setEnabled(this.interactive);
        this.add(this.clearOfferBut);
        this.bankBut = new JButton(BANK);
        this.bankBut.addActionListener(this);
        this.bankBut.setEnabled(this.interactive);
        this.add(this.bankBut);
        if (this.interactive) {
            this.bankBut.setToolTipText(strings.get("hpan.trade.bankport.tip"));
        }
        this.bankUndoBut = new JButton(BANK_UNDO);
        this.bankUndoBut.addActionListener(this);
        this.bankUndoBut.setEnabled(false);
        this.add(this.bankUndoBut);
        if (this.interactive) {
            this.bankUndoBut.setToolTipText(strings.get("hpan.trade.undo.tip"));
        }
        if (!this.playerTradingDisabled) {
            this.playerSend = new ColorSquare[this.game.maxPlayers - 1];
            this.playerSendMap = new int[this.game.maxPlayers - 1];
            this.playerSendForPrevTrade = new boolean[this.game.maxPlayers - 1];
            int cnt = 0;
            for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                if (pn == this.playerNumber) continue;
                Color color = this.playerInterface.getPlayerColor(pn);
                this.playerSendMap[cnt] = pn;
                this.playerSendForPrevTrade[cnt] = true;
                this.playerSend[cnt] = new ColorSquare(2, true, sqSize, sqSize, color);
                this.playerSend[cnt].setColor(this.playerInterface.getPlayerColor(pn));
                this.playerSend[cnt].setBoolValue(true);
                this.add(this.playerSend[cnt]);
                ++cnt;
            }
        }
        this.rollPromptCountdownLab = new JLabel(" ");
        this.add(this.rollPromptCountdownLab);
        this.rollPromptInUse = false;
        this.autoRollTimerTask = null;
        this.rollBut = new JButton(ROLL);
        this.rollBut.addActionListener(this);
        this.rollBut.setEnabled(this.interactive);
        this.add(this.rollBut);
        this.doneBut = new JButton(DONE);
        this.doneBut.addActionListener(this);
        this.doneBut.setEnabled(this.interactive);
        this.doneButIsRestart = false;
        this.add(this.doneBut);
        this.quitBut = new JButton(QUIT);
        this.quitBut.addActionListener(this);
        this.quitBut.setEnabled(this.interactive);
        this.add(this.quitBut);
        this.messagePanel = new MessagePanel(isOSColorHighContrast ? null : pcolor, displayScale);
        this.messagePanel.setVisible(false);
        this.add(this.messagePanel);
        if (this.playerTradingDisabled) {
            this.offerPanel = null;
            this.counterOfferPanel = null;
        } else {
            Color[] colors = SwingMainDisplay.getForegroundBackgroundColors(true, false);
            Color tradeInteriorColor = colors != null ? colors[2] : null;
            this.offerPanel = new TradePanel(new String[]{strings.get("trade.accept"), strings.get("trade.reject"), strings.get("trade.counter")}, new String[]{strings.get("trade.gives.you"), strings.get("trade.they.get"), strings.get("trade.opponent.gives"), strings.get("trade.you.give")}, false, true, this, tradeInteriorColor, new TradePanel.TPListener(){

                @Override
                public void button1Clicked() {
                    SOCHandPanel.this.clickOfferAcceptButton();
                }

                @Override
                public void button2Clicked() {
                    SOCHandPanel.this.clickOfferRejectButton();
                }

                @Override
                public void button3Clicked() {
                    SOCHandPanel.this.clickOfferCounterButton();
                }
            }, displayScale);
            this.offerPanel.setVisible(false);
            this.add(this.offerPanel);
            this.counterOfferPanel = new TradePanel(new String[]{strings.get("base.send"), strings.get("base.clear"), strings.get("base.cancel")}, new String[]{strings.get("trade.they.get"), strings.get("trade.gives.you"), strings.get("trade.give.to.opponent"), strings.get("trade.opponent.gives")}, true, false, this, tradeInteriorColor, new TradePanel.TPListener(){

                @Override
                public void button1Clicked() {
                    SOCHandPanel.this.clickCounterOfferSendButton();
                }

                @Override
                public void button2Clicked() {
                    SOCHandPanel.this.clickCounterOfferClearButton();
                }

                @Override
                public void button3Clicked() {
                    SOCHandPanel.this.clickCounterOfferCancelButton();
                }
            }, displayScale);
            this.counterOfferPanel.setVisible(false);
            this.add(this.counterOfferPanel);
            this.offerPanel.setOfferCounterPartner(false, this.counterOfferPanel);
            this.counterOfferPanel.setOfferCounterPartner(true, this.offerPanel);
        }
        this.messageIsReset = false;
        if (!didSwingTooltipDefaults) {
            UIManager.put("ToolTip.foreground", COLOR_FOREGROUND);
            UIManager.put("ToolTip.background", Color.WHITE);
            UIManager.put("ToolTip.font", DIALOG_PLAIN_10);
            didSwingTooltipDefaults = true;
        }
        int msize = 2 * displayScale;
        Insets minMargin = new Insets(msize, msize, msize, msize);
        Font panelFont = this.getFont();
        Font buttonFont = displayScale > 1 && SOCPlayerClient.IS_PLATFORM_MAC_OSX ? panelFont.deriveFont(0.9f * panelFont.getSize2D()) : panelFont;
        boolean shouldClearButtonBGs = SOCPlayerClient.IS_PLATFORM_WINDOWS && !SwingMainDisplay.isOSColorHighContrast();
        for (Component co : this.getComponents()) {
            if (!(co instanceof JLabel) && !(co instanceof JButton)) continue;
            if (co.getFont() != DIALOG_PLAIN_10 && null == ((JComponent)co).getClientProperty(FONT_SKIP_FLAG)) {
                co.setFont(co instanceof JButton ? buttonFont : panelFont);
            }
            if (co instanceof JLabel) {
                co.setForeground(null);
                co.setBackground(null);
                continue;
            }
            ((JButton)co).setMargin(minMargin);
            if (!shouldClearButtonBGs) continue;
            co.setBackground(null);
        }
        this.removePlayer();
    }

    private final void createAndAddResourceColorSquare(Color rc, String rtxtkey) {
        String rtxt = strings.get(rtxtkey);
        this.createColorSqRetLbl = new JLabel(rtxt + ":");
        this.add(this.createColorSqRetLbl);
        int sqSize = 16 * this.playerInterface.displayScale;
        this.createColorSqRetSq = new ColorSquare(rc, 0, sqSize, sqSize);
        this.add(this.createColorSqRetSq);
        this.createColorSqRetSq.setToolTipText(strings.get("hpan.trade.rightclick", rtxt.toLowerCase()));
    }

    public SOCPlayerInterface getPlayerInterface() {
        return this.playerInterface;
    }

    public SOCPlayer getPlayer() {
        return this.player;
    }

    public SOCPlayerClient getClient() {
        return this.client;
    }

    public SOCGame getGame() {
        return this.game;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String target = e.getActionCommand();
            if (target == LOCKSEAT) {
                this.messageSender.setSeatLock(this.game, this.playerNumber, SOCGame.SeatLockState.LOCKED);
            } else if (target == UNLOCKSEAT) {
                this.messageSender.setSeatLock(this.game, this.playerNumber, SOCGame.SeatLockState.UNLOCKED);
            } else if (target == TAKEOVER) {
                this.messageSender.sitDown(this.game, this.playerNumber);
            } else if (target == SIT) {
                this.messageSender.sitDown(this.game, this.playerNumber);
            } else if (target == START && this.startBut.isVisible()) {
                this.messageSender.startGame(this.game);
            } else if (target != ROBOT) {
                if (target == ROLL) {
                    if (this.autoRollTimerTask != null) {
                        this.autoRollTimerTask.cancel();
                        this.autoRollTimerTask = null;
                    }
                    this.clickRollButton();
                } else if (target == QUIT) {
                    SOCQuitConfirmDialog.createAndShow(this.playerInterface.getMainDisplay(), this.playerInterface);
                } else if (target == DONE) {
                    this.clickDoneButton();
                } else if (target == DONE_RESTART) {
                    this.playerInterface.resetBoardRequest(this.game.isPractice && !this.game.isInitialPlacement());
                } else if (target == CLEAR) {
                    this.clearOffer(true);
                    if (this.game.getGameState() == 20) {
                        this.messageSender.clearOffer(this.game);
                    }
                } else if (target == BANK) {
                    int gstate = this.game.getGameState();
                    if (gstate == 20) {
                        int[] give = new int[5];
                        int[] get = new int[5];
                        this.sqPanel.getValues(give, get);
                        this.createSendBankTradeRequest(give, get, true);
                    } else if (gstate == 1000) {
                        String msg = this.game.gameOverMessageToPlayer(this.player);
                        this.playerInterface.print(msg, true);
                    }
                } else if (target == BANK_UNDO) {
                    if (this.bankGive != null && this.bankGet != null) {
                        this.messageSender.bankTrade(this.game, this.bankGet, this.bankGive);
                        this.bankGive = null;
                        this.bankGet = null;
                        this.bankUndoBut.setEnabled(false);
                    }
                } else if (target == ROBOTLOCKBUT_L) {
                    this.clickRobotSeatLockButton(SOCGame.SeatLockState.LOCKED);
                } else if (target == ROBOTLOCKBUT_U) {
                    this.clickRobotSeatLockButton(SOCGame.SeatLockState.UNLOCKED);
                } else if (target == ROBOTLOCKBUT_M) {
                    this.clickRobotSeatLockButton(SOCGame.SeatLockState.CLEAR_ON_RESET);
                } else if (target == SEND) {
                    if (this.playerTradingDisabled) {
                        return;
                    }
                    if (this.game.getGameState() == 20) {
                        int[] give = new int[5];
                        int[] get = new int[5];
                        int giveSum = 0;
                        int getSum = 0;
                        this.sqPanel.getValues(give, get);
                        for (int i = 0; i < 5; ++i) {
                            giveSum += give[i];
                            getSum += get[i];
                        }
                        SOCResourceSet giveSet = new SOCResourceSet(give);
                        SOCResourceSet getSet = new SOCResourceSet(get);
                        if (!this.player.getResources().contains(giveSet)) {
                            this.playerInterface.print("*** " + strings.get("hpan.trade.msg.donthave"));
                        } else if (giveSum == 0 || getSum == 0) {
                            this.playerInterface.print("*** " + strings.get("hpan.trade.msg.eachplayer"));
                        } else {
                            boolean[] to = new boolean[this.game.maxPlayers];
                            boolean toAny = false;
                            if (this.game.getCurrentPlayerNumber() == this.playerNumber) {
                                for (int i = 0; i < this.game.maxPlayers - 1; ++i) {
                                    if (this.playerSend[i].getBoolValue() && !this.game.isSeatVacant(this.playerSendMap[i])) {
                                        to[this.playerSendMap[i]] = true;
                                        toAny = true;
                                        this.playerSendForPrevTrade[i] = true;
                                        continue;
                                    }
                                    this.playerSendForPrevTrade[i] = false;
                                }
                            } else {
                                to[this.game.getCurrentPlayerNumber()] = true;
                                toAny = true;
                            }
                            if (!toAny) {
                                this.playerInterface.print("*** " + strings.get("hpan.trade.msg.chooseoppo"));
                            } else {
                                SOCTradeOffer tradeOffer = new SOCTradeOffer(this.game.getName(), this.playerNumber, to, giveSet, getSet);
                                this.messageSender.offerTrade(this.game, tradeOffer);
                                this.disableBankUndoButton();
                            }
                        }
                    } else {
                        this.getPlayerInterface().print(strings.get("hpan.trade.msg.notnow"), true);
                    }
                } else if (e.getSource() == this.inventory || e.getSource() == this.playCardBut) {
                    this.clickPlayCardButton();
                }
            }
        }
        catch (Throwable th) {
            this.playerInterface.chatPrintStackTrace(th);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.pname) {
            if (this.game.isDebugFreePlacement()) {
                this.playerInterface.setDebugFreePlacementPlayer(this.playerNumber);
                e.consume();
            }
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(strings.get("hpan.svp.total", this.player.getSpecialVP()));
        ArrayList<SOCPlayer.SpecialVPInfo> svpis = this.player.getSpecialVPInfo();
        if (svpis != null && svpis.size() > 0) {
            sb.append("\n");
            for (SOCPlayer.SpecialVPInfo svpi : svpis) {
                sb.append("\n");
                sb.append(svpi.svp + ": " + svpi.desc);
            }
        }
        NotifyDialog.createAndShow(this.playerInterface.getMainDisplay(), this.playerInterface, sb.toString(), null, true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void createSendBankTradeRequest(int[] give, int[] get, boolean isFromTradePanel) {
        boolean isOldServer;
        boolean bl = isOldServer = this.client.getServerVersion(this.game) < 2000;
        if (isFromTradePanel && (isOldServer || this.player.getCurrentOffer() != null)) {
            this.messageSender.clearOffer(this.game);
        }
        SOCResourceSet giveSet = new SOCResourceSet(give);
        SOCResourceSet getSet = new SOCResourceSet(get);
        if (giveSet.isEmpty() || getSet.isEmpty()) {
            this.playerInterface.getClientListener().playerTradeDisallowed(this.playerNumber, false, false);
            return;
        }
        this.messageSender.bankTrade(this.game, giveSet, getSet);
        this.bankGive = giveSet;
        this.bankGet = getSet;
        if (isOldServer) {
            this.bankUndoBut.setEnabled(true);
        }
        this.playerInterface.bankTradeWasFromTradePanel = isFromTradePanel;
    }

    public void disableBankUndoButton() {
        if (this.bankGive == null) {
            return;
        }
        this.bankGive = null;
        this.bankGet = null;
        this.bankUndoBut.setEnabled(false);
    }

    public void enableBankUndoButton() {
        if (this.bankGive == null) {
            return;
        }
        this.bankUndoBut.setEnabled(true);
    }

    private final void clickRobotSeatLockButton(SOCGame.SeatLockState current) {
        SOCGame.SeatLockState slNext;
        switch (current) {
            case UNLOCKED: {
                slNext = SOCGame.SeatLockState.LOCKED;
                break;
            }
            case CLEAR_ON_RESET: {
                slNext = SOCGame.SeatLockState.UNLOCKED;
                break;
            }
            default: {
                slNext = this.game.isPractice || this.client.sVersion >= 2000 ? SOCGame.SeatLockState.CLEAR_ON_RESET : SOCGame.SeatLockState.UNLOCKED;
            }
        }
        this.messageSender.setSeatLock(this.game, this.playerNumber, slNext);
    }

    public void clickPlayCardButton() {
        int gstate = this.game.getGameState();
        if (gstate == 42) {
            this.messageSender.cancelBuildRequest(this.game, -3);
            return;
        }
        if (gstate == 33 || gstate == 34) {
            this.messageSender.cancelBuildRequest(this.game, -2);
            return;
        }
        if (this.game.isDebugFreePlacement()) {
            return;
        }
        SOCInventoryItem itemObj = null;
        this.setRollPrompt(null, false);
        DefaultListModel invModel = (DefaultListModel)this.inventory.getModel();
        int itemNum = this.inventory.getSelectedIndex();
        String itemText = this.inventory.getSelectedValue();
        if (itemText == null || itemText.length() == 0) {
            if (invModel.size() == 1) {
                itemText = (String)invModel.get(0);
                itemNum = 0;
                if (itemText.length() == 0) {
                    return;
                }
                itemObj = this.inventoryItems.get(0);
            } else {
                itemNum = -1;
                String itemNumText = null;
                for (int i = invModel.size() - 1; i >= 0; --i) {
                    SOCInventoryItem item;
                    itemText = (String)invModel.get(i);
                    if (itemText == null || itemText.length() <= 0 || !(item = this.inventoryItems.get(i)).isPlayable()) continue;
                    if (itemObj == null) {
                        itemNum = i;
                        itemNumText = itemText;
                        itemObj = item;
                        continue;
                    }
                    if (itemObj.itype == item.itype) continue;
                    itemNum = -1;
                    break;
                }
                if (itemNum == -1 || itemObj == null) {
                    this.playerInterface.printKeyed("hpan.devcards.clickfirst");
                    return;
                }
                itemText = itemNumText;
            }
        } else if (itemNum < this.inventoryItems.size()) {
            itemObj = this.inventoryItems.get(itemNum);
        }
        if (!this.playerIsCurrent || itemObj == null) {
            return;
        }
        if (itemObj.isVPItem()) {
            this.playerInterface.print("*** " + strings.get("hpan.devcards.vp.secretlyplayed"));
            itemNum = this.inventory.getSelectedIndex();
            if (itemNum >= 0) {
                this.inventory.clearSelection();
            }
            return;
        }
        if (itemObj.isNew()) {
            this.playerInterface.print("*** " + strings.get("hpan.devcards.wait"));
            return;
        }
        if (!(itemObj instanceof SOCDevCard)) {
            this.clickPlayInventorySpecialItem(itemObj);
            return;
        }
        if (this.player.hasPlayedDevCard()) {
            this.playerInterface.print("*** " + strings.get("hpan.devcards.oneperturn"));
            this.playCardBut.setEnabled(false);
            return;
        }
        int cardTypeToPlay = -1;
        switch (itemObj.itype) {
            case 9: {
                if (this.game.canPlayKnight(this.playerNumber)) {
                    cardTypeToPlay = 9;
                    break;
                }
                if (!this.game.isGameOptionSet("_SC_PIRI")) break;
                this.playerInterface.printKeyed("hpan.devcards.warship.cannotnow");
                break;
            }
            case 1: {
                if (this.game.canPlayRoadBuilding(this.playerNumber)) {
                    cardTypeToPlay = 1;
                    break;
                }
                if (this.player.getNumPieces(0) != 0) break;
                if (this.game.hasSeaBoard && this.player.getNumPieces(3) == 0) {
                    this.playerInterface.printKeyed("hpan.devcards.roads_ships.none");
                    break;
                }
                this.playerInterface.printKeyed("hpan.devcards.roads.none");
                break;
            }
            case 2: {
                if (!this.game.canPlayDiscovery(this.playerNumber)) break;
                cardTypeToPlay = 2;
                break;
            }
            case 3: {
                if (!this.game.canPlayMonopoly(this.playerNumber)) break;
                cardTypeToPlay = 3;
                break;
            }
            default: {
                this.playerInterface.printKeyed("hpan.devcards.interror.ctype", itemObj.itype, itemText);
            }
        }
        if (cardTypeToPlay != -1) {
            this.messageSender.playDevCard(this.game, cardTypeToPlay);
            this.disableBankUndoButton();
        }
    }

    private final void clickPlayInventorySpecialItem(SOCInventoryItem item) {
        if (item.isPlayable()) {
            this.messageSender.playInventoryItem(this.game, item.itype);
        }
    }

    public final void clickRollButton() {
        if (this.rollPromptInUse) {
            this.setRollPrompt(null, false);
        }
        this.messageSender.rollDice(this.game);
        this.rollBut.setEnabled(false);
    }

    private void clickDoneButton() {
        if (this.game.getGameState() == 41) {
            EventQueue.invokeLater(new SOCBuildingPanel.ConfirmCancelFreeRoadDialog(this.playerInterface, true, true));
        } else {
            this.messageSender.endTurn(this.game);
        }
    }

    void clickOfferAcceptButton() {
        if (!this.offerPanel.canPlayerGiveTradeResources()) {
            this.playerInterface.print("*** " + strings.get("trade.msg.cant.offer.dont_have"));
            return;
        }
        this.offerPanel.setVisible(false);
        this.counterOfferPanel.setVisible(false);
        this.checkTradePanelLayoutSize();
        this.client.getGameMessageSender().acceptOffer(this.game, this.playerNumber);
        this.disableBankUndoButton();
    }

    void clickOfferRejectButton() {
        this.offerPanel.setVisible(false);
        this.counterOfferPanel.setVisible(false);
        this.checkTradePanelLayoutSize();
        this.rejectOfferAtClient();
    }

    void clickOfferCounterButton() {
        this.counterOfferPanel.setVisible(true);
        this.offerPanel.setButtonRowVisible(false, true);
        this.checkTradePanelLayoutSize();
    }

    private void clickCounterOfferSendButton() {
        SOCPlayer cliPlayer = this.playerInterface.getClientPlayer();
        if (this.game.getGameState() != 20) {
            return;
        }
        SOCResourceSet[] giveget = this.counterOfferPanel.getTradeResources();
        SOCResourceSet giveSet = giveget[0];
        SOCResourceSet getSet = giveget[1];
        if (!cliPlayer.getResources().contains(giveSet)) {
            this.playerInterface.print("*** " + strings.get("trade.msg.cant.offer.dont_have"));
        } else if (giveSet.getKnownTotal() == 0 || getSet.getKnownTotal() == 0) {
            this.playerInterface.print("*** " + strings.get("trade.msg.must.contain"));
        } else {
            boolean[] to = new boolean[this.game.maxPlayers];
            to[this.playerNumber] = true;
            this.client.getGameMessageSender().offerTrade(this.game, new SOCTradeOffer(this.game.getName(), cliPlayer.getPlayerNumber(), to, giveSet, getSet));
        }
    }

    private void clickCounterOfferClearButton() {
        this.counterOfferPanel.setTradeResources(null, null);
    }

    private void clickCounterOfferCancelButton() {
        this.counterOfferPanel.setVisible(false);
        this.offerPanel.setButtonRowVisible(true, false);
        this.checkTradePanelLayoutSize();
    }

    private void checkTradePanelLayoutSize() {
        if (this.offerPanel == null) {
            return;
        }
        boolean isCounterVis = this.counterOfferPanel.isVisible();
        if (this.offerPanel.isVisible() || isCounterVis || !this.faceImg.isVisible()) {
            this.offerCounterOfferVisibleChanged(isCounterVis);
        }
    }

    public void addSittingRobotLockBut() {
        String tipText;
        String lbl;
        switch (this.game.getSeatLock(this.playerNumber)) {
            case LOCKED: {
                lbl = ROBOTLOCKBUT_L;
                if (this.game.isPractice || this.client.sVersion >= 2000) {
                    tipText = ROBOTLOCKBUTTIP_L;
                    break;
                }
                tipText = ROBOTLOCKBUTTIP_L_OLD;
                break;
            }
            case CLEAR_ON_RESET: {
                lbl = ROBOTLOCKBUT_M;
                tipText = ROBOTLOCKBUTTIP_M;
                break;
            }
            default: {
                lbl = ROBOTLOCKBUT_U;
                tipText = this.game.isPractice || this.client.sVersion >= 2000 ? ROBOTLOCKBUTTIP_U : ROBOTLOCKBUTTIP_U_OLD;
            }
        }
        this.sittingRobotLockBut.setText(lbl);
        this.sittingRobotLockBut.setVisible(true);
        this.sittingRobotLockBut.setToolTipText(tipText);
    }

    public void addTakeOverBut() {
        this.takeOverBut.setVisible(true);
    }

    public void addSitButton(boolean clientHasSatAlready) {
        if (!clientHasSatAlready) {
            if (this.game.getGameState() >= 10) {
                this.sitBut.setVisible(false);
                return;
            }
            if (this.sitButIsLock) {
                this.sitBut.setText(SIT);
                this.sitButIsLock = false;
            }
        } else if (clientHasSatAlready && !this.sitButIsLock) {
            this.renameSitButLock();
        }
        this.sitBut.setVisible(true);
    }

    public void addRobotButton() {
        this.robotBut.setVisible(true);
    }

    public void changeFace(int id) {
        this.faceImg.setFace(id);
    }

    public void removePlayer() {
        int i;
        if (this.blankStandIn != null) {
            this.blankStandIn.setVisible(true);
        }
        this.setVisible(false);
        this.vpLab.setVisible(false);
        this.vpSq.setVisible(false);
        if (this.svpSq != null) {
            this.svpLab.setVisible(false);
            this.svpSq.setVisible(false);
        }
        this.faceImg.setVisible(false);
        this.pname.setVisible(false);
        this.pname.setText("");
        this.roadSq.setVisible(false);
        this.roadLab.setVisible(false);
        this.settlementLab.setVisible(false);
        this.settlementSq.setVisible(false);
        this.cityLab.setVisible(false);
        this.citySq.setVisible(false);
        if (this.shipSq != null) {
            this.shipSq.setVisible(false);
            this.shipLab.setVisible(false);
        }
        this.knightsSq.setVisible(false);
        this.knightsLab.setVisible(false);
        if (this.undosSq != null) {
            this.undosLab.setVisible(false);
            this.undosSq.setVisible(false);
        }
        if (this.clothSq != null) {
            this.clothLab.setVisible(false);
            this.clothSq.setVisible(false);
        } else if (this.wonderLab != null) {
            this.wonderLab.setVisible(false);
        }
        if (this.offerPanel != null) {
            this.offerPanel.setVisible(false);
            this.counterOfferPanel.setVisible(false);
        }
        this.larmyLab.setVisible(false);
        this.lroadLab.setVisible(false);
        this.resourceLab.setVisible(false);
        this.resourceSq.setVisible(false);
        this.resourceSqDivLine.setVisible(false);
        this.offerHidingControls = false;
        this.offerCounterHidingFace = false;
        if (this.playerIsClient) {
            if (this.playerInterface.getClientHand() == this) {
                this.playerInterface.setClientHand(null);
                if (!this.playerTradingDisabled) {
                    for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                        if (pn == this.playerNumber) continue;
                        SOCHandPanel hpan = this.playerInterface.getPlayerHandPanel(pn);
                        hpan.offerPanel.setPlayer(null, 0);
                        hpan.counterOfferPanel.setPlayer(null, 0);
                    }
                }
            }
            this.playerIsClient = false;
            this.faceImg.clearFacePopupPreviousChooser();
        } else if (this.game.getGameState() == 0) {
            boolean clientAlreadySitting = this.playerInterface.getClientHand() != null;
            this.addSitButton(clientAlreadySitting);
        }
        this.claySq.setVisible(false);
        this.clayLab.setVisible(false);
        this.oreSq.setVisible(false);
        this.oreLab.setVisible(false);
        this.sheepSq.setVisible(false);
        this.sheepLab.setVisible(false);
        this.wheatSq.setVisible(false);
        this.wheatLab.setVisible(false);
        this.woodSq.setVisible(false);
        this.woodLab.setVisible(false);
        this.resourceTradeCost = null;
        if (this.resourceTradeMenu != null) {
            for (i = 0; i < this.resourceTradeMenu.length; ++i) {
                if (this.resourceTradeMenu[i] == null) continue;
                this.resourceTradeMenu[i].destroy();
                this.resourceTradeMenu[i] = null;
            }
            this.resourceTradeMenu = null;
        }
        this.inventoryScroll.setVisible(false);
        this.playCardBut.setVisible(false);
        this.giveLab.setVisible(false);
        this.getLab.setVisible(false);
        this.sqPanel.setVisible(false);
        this.clearOfferBut.setVisible(false);
        this.bankBut.setVisible(false);
        this.bankUndoBut.setVisible(false);
        if (!this.playerTradingDisabled) {
            this.offerBut.setVisible(false);
            for (i = 0; i < this.game.maxPlayers - 1; ++i) {
                this.playerSend[i].setVisible(false);
            }
        }
        this.rollBut.setVisible(false);
        this.doneBut.setVisible(false);
        this.quitBut.setVisible(false);
        this.setRollPrompt(null, true);
        this.developmentLab.setVisible(false);
        this.developmentSq.setVisible(false);
        this.faceImg.removeFacePopupMenu();
        this.removeTakeOverBut();
        this.removeSittingRobotLockBut();
        this.inPlay = false;
        this.validate();
        if (this.blankStandIn != null) {
            this.blankStandIn.setVisible(false);
        }
        this.setVisible(true);
        this.repaint();
    }

    private void init_removeInventoryHotkeyCtrlA() {
        SOCPlayerInterface.removeHotkeysInputMap_one(this.inventory.getInputMap(0), 65);
        SOCPlayerInterface.removeHotkeysInputMap_one(this.inventory.getInputMap(1), 65);
    }

    private void addHotkeysInputMap() {
        if (this.didHotkeyBindings) {
            return;
        }
        ActionMap am = this.getActionMap();
        am.put("hotkey_roll", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!SOCHandPanel.this.rollBut.isEnabled()) {
                    return;
                }
                if (SOCHandPanel.this.autoRollTimerTask != null) {
                    SOCHandPanel.this.autoRollTimerTask.cancel();
                    SOCHandPanel.this.autoRollTimerTask = null;
                }
                SOCHandPanel.this.clickRollButton();
            }
        });
        am.put("hotkey_done", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SOCHandPanel.this.doneBut.isEnabled()) {
                    SOCHandPanel.this.clickDoneButton();
                }
            }
        });
        InputMap im = this.getInputMap(2);
        SOCPlayerInterface.addHotkeysInputMap_one(im, 82, "hotkey_roll", this.rollBut);
        SOCPlayerInterface.addHotkeysInputMap_one(im, 68, "hotkey_done", this.doneBut);
        this.didHotkeyBindings = true;
    }

    public void destroy() {
        this.removePlayer();
        this.removeAll();
    }

    public void gameDisconnected() {
        JButton[] inPlayButtons;
        this.removeSitBut();
        this.removeTakeOverBut();
        for (JButton b : inPlayButtons = new JButton[]{this.playCardBut, this.offerBut, this.bankBut, this.bankUndoBut, this.rollBut, this.doneBut, this.sittingRobotLockBut}) {
            if (b == null || !b.isVisible() || !b.isEnabled()) continue;
            b.setEnabled(false);
        }
    }

    public void addPlayer(String name) {
        boolean showResourceDetails;
        if (this.blankStandIn != null) {
            this.blankStandIn.setVisible(true);
        }
        this.setVisible(false);
        int gameState = this.game.getGameState();
        if (!this.game.isBoardReset()) {
            this.faceImg.setDefaultFace();
        } else {
            this.changeFace(this.player.getFaceId());
        }
        this.faceImg.setVisible(true);
        this.pname.setText(name);
        this.pname.setVisible(true);
        this.larmyLab.setVisible(true);
        this.lroadLab.setVisible(true);
        this.roadSq.setVisible(true);
        this.roadLab.setVisible(true);
        this.settlementSq.setVisible(true);
        this.settlementLab.setVisible(true);
        this.citySq.setVisible(true);
        this.cityLab.setVisible(true);
        if (this.shipSq != null) {
            this.shipSq.setVisible(true);
            this.shipLab.setVisible(true);
        }
        this.knightsLab.setVisible(true);
        this.knightsSq.setVisible(true);
        if (this.undosSq != null) {
            boolean isNormalPlay = gameState >= 15;
            this.undosLab.setVisible(isNormalPlay);
            this.undosSq.setVisible(isNormalPlay);
        }
        if (this.clothSq != null) {
            this.clothLab.setVisible(true);
            this.clothSq.setVisible(true);
        } else if (this.wonderLab != null) {
            this.wonderLab.setText("");
            this.wonderLab.setVisible(true);
            this.updateValue(PlayerClientListener.UpdateType.WonderLevel);
        }
        this.resourceLab.setVisible(true);
        this.resourceSq.setVisible(true);
        if (this.svpSq != null) {
            int newSVP = this.player.getSpecialVP();
            this.svpSq.setIntValue(newSVP);
            boolean vis = newSVP != 0;
            this.svpSq.setVisible(vis);
            this.svpLab.setVisible(vis);
        }
        boolean bl = this.playerIsCurrent = this.game.getCurrentPlayerNumber() == this.playerNumber;
        if (this.player.getName().equals(this.playerInterface.getClientNickname())) {
            int i;
            this.playerIsClient = true;
            this.playerInterface.setClientHand(this);
            this.knightsSq.setToolTipText(strings.get("hpan.soldiers.sizeyourarmy"));
            this.vpSq.setToolTipText(strings.get("hpan.points.total.yours"));
            if (gameState == 0) {
                this.startBut.setVisible(true);
            } else {
                this.vpLab.setVisible(true);
                this.vpSq.setVisible(true);
            }
            this.faceImg.addFacePopupMenu();
            showResourceDetails = true;
            this.resourceTradeCost = new int[6];
            if (this.resourceTradeMenu != null) {
                for (i = 0; i < this.resourceTradeMenu.length; ++i) {
                    if (this.resourceTradeMenu[i] == null) continue;
                    this.resourceTradeMenu[i].destroy();
                    this.resourceTradeMenu[i] = null;
                }
            } else {
                this.resourceTradeMenu = new ResourceTradeTypeMenu[6];
            }
            this.updateResourceTradeCosts(true);
            this.canCancelInvItemPlay = false;
            this.inventory.setEnabled(true);
            this.inventoryScroll.setVisible(true);
            this.playCardBut.setVisible(true);
            this.giveLab.setVisible(true);
            this.getLab.setVisible(true);
            this.sqPanel.setVisible(true);
            this.clearOfferBut.setVisible(true);
            this.bankBut.setVisible(true);
            if (this.game.isPractice || this.client.sVersion >= 1113) {
                this.bankUndoBut.setVisible(true);
            }
            if (!this.playerTradingDisabled) {
                this.offerBut.setVisible(true);
                for (i = 0; i < this.game.maxPlayers - 1; ++i) {
                    this.playerSend[i].setBoolValue(true);
                    this.playerSend[i].setEnabled(true);
                    this.playerSend[i].setVisible(true);
                }
            }
            this.rollBut.setVisible(true);
            boolean bl2 = this.doneButIsRestart = gameState <= 13 || gameState == 1000;
            if (this.doneButIsRestart) {
                this.doneBut.setText(DONE_RESTART);
            } else {
                this.doneBut.setText(DONE);
            }
            this.doneBut.setVisible(true);
            this.quitBut.setVisible(true);
            boolean gameForming = gameState == 0;
            for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                SOCHandPanel hpan = this.playerInterface.getPlayerHandPanel(pn);
                hpan.removeTakeOverBut();
                if (gameForming && pn != this.playerNumber && this.game.isSeatVacant(pn)) {
                    hpan.renameSitButLock();
                } else {
                    hpan.removeSitBut();
                }
                if (this.playerTradingDisabled || pn == this.playerNumber) continue;
                hpan.offerPanel.setPlayer(this.player, 1);
                hpan.counterOfferPanel.setPlayer(this.player, 1);
            }
            this.updateButtonsAtAdd();
            this.addHotkeysInputMap();
        } else {
            boolean clientIsASeatedPlayer;
            boolean isRobot = this.player.isRobot();
            this.knightsSq.setToolTipText(strings.get("hpan.soldiers.sizeoppoarmy"));
            boolean bl3 = clientIsASeatedPlayer = this.game.getPlayer(this.playerInterface.getClientNickname()) != null;
            if (isRobot && !clientIsASeatedPlayer && this.game.getSeatLock(this.playerNumber) != SOCGame.SeatLockState.LOCKED) {
                this.addTakeOverBut();
            }
            if (isRobot && clientIsASeatedPlayer) {
                this.addSittingRobotLockBut();
            } else {
                this.removeSittingRobotLockBut();
            }
            this.vpLab.setVisible(true);
            this.vpSq.setVisible(true);
            showResourceDetails = this.playerInterface.isGameFullyObservable;
            if (this.counterOfferPanel != null) {
                this.counterOfferPanel.setLine1Text(strings.get("trade.counter.to.x", this.player.getName()));
            }
            this.developmentLab.setVisible(true);
            this.developmentSq.setVisible(true);
            if (this.playerInterface.isGameObservableVP) {
                this.inventory.setEnabled(false);
                this.inventoryScroll.setVisible(true);
            }
            this.removeSitBut();
            this.removeRobotBut();
        }
        if (showResourceDetails) {
            this.claySq.setVisible(true);
            this.clayLab.setVisible(true);
            this.oreSq.setVisible(true);
            this.oreLab.setVisible(true);
            this.sheepSq.setVisible(true);
            this.sheepLab.setVisible(true);
            this.wheatSq.setVisible(true);
            this.wheatLab.setVisible(true);
            this.woodSq.setVisible(true);
            this.woodLab.setVisible(true);
            this.resourceSqDivLine.setVisible(true);
            this.resourceSq.setBorderColor(ColorSquare.ORE);
            this.resourceLab.setText(RESOURCES_TOTAL);
        } else {
            this.resourceSq.setBorderColor(Color.BLACK);
            this.resourceLab.setText(RESOURCES);
        }
        if (this.wonderLab != null) {
            this.wonderLab.setHorizontalAlignment(4);
        }
        this.inPlay = true;
        this.invalidate();
        this.doLayout();
        if (this.blankStandIn != null) {
            this.blankStandIn.setVisible(false);
        }
        this.setVisible(true);
        this.repaint();
    }

    protected void autoRollSetupTimer() {
        Timer piTimer = this.playerInterface.getEventTimer();
        if (this.autoRollTimerTask != null) {
            this.autoRollTimerTask.cancel();
        }
        if (!this.game.canRollDice(this.playerNumber)) {
            return;
        }
        this.autoRollTimerTask = new HandPanelAutoRollTask();
        piTimer.scheduleAtFixedRate(this.autoRollTimerTask, 0L, 1000L);
    }

    private void updateAtNormalGameplay() {
        if (this.hasStartedNormalGameplay) {
            return;
        }
        if (this.undosSq != null) {
            if (this.undosSq.getIntValue() == 0) {
                this.updateValue(PlayerClientListener.UpdateType.UndosRemaining);
            }
            boolean shouldShow = this.playerIsClient || this.roadSq.isVisible();
            this.undosSq.setVisible(shouldShow);
            this.undosLab.setVisible(shouldShow);
        }
        this.hasStartedNormalGameplay = true;
    }

    public void updateAtTurn() {
        boolean showAsCurrent;
        boolean bl = this.playerIsCurrent = this.game.getCurrentPlayerNumber() == this.playerNumber;
        if (this.playerIsCurrent) {
            if (this.pnameActiveBG == null) {
                this.pnameCalcColors();
            }
            if (this.playerIsClient) {
                this.updateRollDoneBankButtons();
            }
        }
        if (!this.game.isDebugFreePlacement()) {
            showAsCurrent = this.playerIsCurrent;
        } else {
            boolean bl2 = showAsCurrent = this.playerNumber == this.playerInterface.getBoardPanel().getPlayerNumber();
            if (this.pnameActiveBG == null) {
                this.pnameCalcColors();
            }
        }
        if (showAsCurrent) {
            this.pname.setBackground(this.pnameActiveBG);
        } else {
            this.pname.setBackground(null);
        }
        this.updateTakeOverButton();
        int gs = this.game.getGameState();
        if (this.playerIsClient) {
            boolean normalTurnStarting = gs == 15 || gs == 20;
            this.clearOffer(normalTurnStarting);
            if (!this.playerIsCurrent) {
                this.rollBut.setEnabled(false);
                this.doneBut.setEnabled(false);
            }
            if (this.doneButIsRestart) {
                if (normalTurnStarting) {
                    this.doneBut.setText(DONE);
                    this.doneButIsRestart = false;
                } else {
                    this.doneBut.setEnabled(true);
                }
            }
            normalTurnStarting = normalTurnStarting && this.playerIsCurrent;
            this.playCardBut.setEnabled(normalTurnStarting && !((DefaultListModel)this.inventory.getModel()).isEmpty());
        }
        this.bankGive = null;
        this.bankGet = null;
        if (this.bankUndoBut.isEnabled()) {
            this.bankUndoBut.setEnabled(false);
        }
        if (gs >= 15 && !this.hasStartedNormalGameplay) {
            this.updateAtNormalGameplay();
        }
    }

    void updateAtOurGameState() {
        if (!this.playerIsClient) {
            return;
        }
        this.updateRollDoneBankButtons();
    }

    private void updateButtonsAtAdd() {
        if (this.playerIsCurrent) {
            this.updateRollDoneBankButtons();
        } else {
            this.rollBut.setEnabled(false);
            this.doneBut.setEnabled(false);
            this.playCardBut.setEnabled(false);
            this.bankBut.setEnabled(false);
        }
        this.bankUndoBut.setEnabled(false);
        this.clearOfferBut.setEnabled(false);
        if (!this.playerTradingDisabled) {
            this.offerBut.setEnabled(false);
            this.offerBut.setToolTipText(OFFERBUTTIP_DIS);
        }
    }

    protected void pnameCalcColors() {
        if (this.pnameActiveBG != null) {
            return;
        }
        this.pnameActiveBG = SOCPlayerInterface.makeGhostColor(this.getBackground());
    }

    public void sqPanelZerosChange(boolean notAllZero) {
        int gs = this.game.getGameState();
        this.clearOfferBut.setEnabled(notAllZero);
        if (this.playerTradingDisabled) {
            return;
        }
        boolean enaOfferBut = notAllZero && (gs == 15 || gs == 20);
        this.offerBut.setEnabled(enaOfferBut);
        this.offerBut.setToolTipText(enaOfferBut ? OFFERBUTTIP_ENA : OFFERBUTTIP_DIS);
    }

    public void offerCounterOfferVisibleChanged(boolean counterVisible) {
        this.invalidate();
        if (this.offerCounterHidesFace || this.offerHidingControls || this.offerCounterHidingFace) {
            this.hideTradeMsgShowOthers(false);
        }
        this.validate();
        this.repaint();
    }

    public void autoRollOrPromptPlayer() {
        this.updateAtTurn();
        if (this.player.hasUnplayedDevCards() && !this.player.hasPlayedDevCard()) {
            this.setRollPrompt(ROLL_OR_PLAY_CARD, false);
        } else {
            this.autoRollSetupTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDevCards(boolean addedPlayable) {
        if (!this.playerIsClient && !this.playerInterface.isGameObservableVP) {
            this.updateValue(PlayerClientListener.UpdateType.DevCards);
            if (this.game.getGameState() == 1000) {
                StringBuffer sb = new StringBuffer();
                for (SOCInventoryItem item : this.player.getInventory().getByState(3)) {
                    if (!item.isVPItem()) continue;
                    sb.append(sb.length() != 0 ? "<br>" : "<html><B>" + strings.get("game.end.player.vpcards") + "</B><br>");
                    sb.append(item.getItemName(this.game, false, strings));
                }
                if (sb.length() > 0) {
                    this.showMiscInfo(sb.toString());
                }
            }
            return;
        }
        SOCInventory items = this.player.getInventory();
        boolean hasOldCards = false;
        DefaultListModel invModel = (DefaultListModel)this.inventory.getModel();
        Object object = this.inventory.getTreeLock();
        synchronized (object) {
            invModel.clear();
            this.inventoryItems.clear();
            if (addedPlayable && this.playerIsClient && !this.inventory.isEnabled()) {
                this.inventory.setEnabled(true);
            }
            for (int cState = 1; cState <= 3; ++cState) {
                boolean isNew = cState == 1;
                for (SOCInventoryItem item : items.getByState(cState)) {
                    String itemText;
                    if (isNew) {
                        itemText = DEVCARD_NEW + item.getItemName(this.game, false, strings);
                    } else {
                        itemText = item.getItemName(this.game, false, strings);
                        hasOldCards = true;
                    }
                    invModel.addElement(itemText);
                    this.inventoryItems.add(item);
                }
            }
        }
        this.playCardBut.setEnabled(hasOldCards && this.playerIsClient && this.playerIsCurrent);
    }

    public void removeSittingRobotLockBut() {
        this.sittingRobotLockBut.setVisible(false);
    }

    public void removeTakeOverBut() {
        this.takeOverBut.setVisible(false);
    }

    public void removeSitBut() {
        if (this.sitBut.isVisible()) {
            this.sitBut.setVisible(false);
        }
        if (this.sitButIsLock) {
            this.sitBut.setText(SIT);
            this.sitButIsLock = false;
            if (this.player == null || this.player.getName() == null) {
                this.pname.setVisible(false);
            }
        }
    }

    public void removeSitLockoutBut() {
        if (this.sitButIsLock) {
            this.removeSitBut();
        }
    }

    public void renameSitButLock() {
        String ttipText;
        String buttonText;
        if (this.game.getGameState() != 0) {
            return;
        }
        if (this.game.getSeatLock(this.playerNumber) == SOCGame.SeatLockState.LOCKED) {
            buttonText = UNLOCKSEAT;
            ttipText = UNLOCKSEATTIP;
            this.pname.setText(SITLOCKED);
            this.pname.setVisible(true);
        } else {
            buttonText = LOCKSEAT;
            ttipText = LOCKSEATTIP;
        }
        this.sitBut.setText(buttonText);
        this.sitBut.setToolTipText(ttipText);
        this.sitButIsLock = true;
        this.invalidate();
        this.doLayout();
        this.sitBut.repaint();
    }

    public void removeRobotBut() {
        this.robotBut.setVisible(false);
    }

    public void removeStartBut() {
        boolean seatTaken = !this.game.isSeatVacant(this.playerNumber);
        this.vpLab.setVisible(seatTaken);
        this.vpSq.setVisible(seatTaken);
        this.startBut.setVisible(false);
        if (!this.playerTradingDisabled) {
            for (int i = 0; i < this.game.maxPlayers - 1; ++i) {
                String sendPName;
                int pn = this.playerSendMap[i];
                boolean seatTaken2 = !this.game.isSeatVacant(pn);
                this.playerSend[i].setBoolValue(seatTaken2);
                this.playerSend[i].setEnabled(seatTaken2);
                if (!seatTaken2 || (sendPName = this.game.getPlayer(pn).getName()) == null) continue;
                this.playerSend[i].setToolTipText(sendPName);
            }
        }
    }

    public void updateCurrentOffer(boolean isNewOffer, boolean resourcesOnly) {
        if (this.playerTradingDisabled) {
            return;
        }
        if (this.inPlay) {
            if (resourcesOnly) {
                this.offerPanel.updateOfferButtons();
                if (this.counterOfferPanel.isVisible()) {
                    this.counterOfferPanel.updateOfferButtons();
                }
                return;
            }
            SOCTradeOffer currentOffer = this.player.getCurrentOffer();
            if (currentOffer != null) {
                if (!this.messageIsReset && !this.messageIsDiscardOrPick) {
                    if (!this.playerIsClient) {
                        this.messagePanel.setVisible(false);
                        this.offerPanel.setTradeOffer(currentOffer);
                        this.offerPanel.setVisible(true);
                        if (this.offerHidesControls) {
                            this.hideTradeMsgShowOthers(false);
                        }
                        this.checkTradePanelLayoutSize();
                        this.offerPanel.repaint();
                        if (isNewOffer && this.offerPanel.isOfferToPlayer()) {
                            this.playerInterface.playSound(SOCPlayerInterface.SOUND_OFFERED_TRADE);
                        }
                    }
                } else {
                    this.offerIsHiddenByMessage = true;
                }
            } else {
                this.clearOffer(false);
            }
        }
    }

    boolean isShowingOfferToClientPlayer() {
        return this.inPlay && !this.playerIsClient && this.offerPanel.isOfferToPlayer();
    }

    public void rejectOfferShowNonClient() {
        if (this.playerIsClient) {
            return;
        }
        if (this.player.isRobot() && !this.game.hasTradeOffers()) {
            return;
        }
        if (this.offerHidesControls) {
            this.hideTradeMsgShowOthers(false);
        }
        this.offerPanel.setVisible(false);
        this.counterOfferPanel.setVisible(false);
        this.messagePanel.setText(strings.get("base.no.thanks.sentenc"));
        this.messagePanel.setVisible(true);
        this.repaint();
    }

    public void rejectOfferAtClient() {
        this.messageSender.rejectOffer(this.game);
        this.messagePanel.setText(null);
        this.messagePanel.setVisible(false);
        this.offerPanel.setVisible(false);
        this.counterOfferPanel.setVisible(false);
        if (this.offerHidesControls) {
            this.hideTradeMsgShowOthers(true);
        }
        this.repaint();
    }

    public void hideMessage() {
        if (this.messagePanel.isVisible() && !this.messageIsReset && !this.messageIsDiscardOrPick) {
            this.messagePanel.setText(null);
            this.messagePanel.setVisible(false);
            if (this.offerHidesControls) {
                this.hideTradeMsgShowOthers(true);
            }
            this.repaint();
        }
    }

    private void hideTradeMsgShowOthers(boolean hideTradeMsg) {
        boolean counterIsShowing;
        boolean faceHidden;
        if (!this.offerHidesControls && this.resourceSq.isVisible() && this.faceImg.isVisible()) {
            return;
        }
        if (this.offerHidingControls == hideTradeMsg) {
            this.knightsLab.setVisible(hideTradeMsg);
            this.knightsSq.setVisible(hideTradeMsg);
            if (this.undosSq != null) {
                boolean show = hideTradeMsg && this.game.getGameState() >= 15;
                this.undosLab.setVisible(show);
                this.undosSq.setVisible(show);
            }
            if (this.clothSq != null) {
                this.clothLab.setVisible(hideTradeMsg);
                this.clothSq.setVisible(hideTradeMsg);
            } else if (this.wonderLab != null) {
                this.wonderLab.setVisible(hideTradeMsg);
            }
            this.resourceLab.setVisible(hideTradeMsg);
            this.resourceSq.setVisible(hideTradeMsg);
            this.developmentLab.setVisible(hideTradeMsg);
            this.developmentSq.setVisible(hideTradeMsg);
            this.roadSq.setVisible(hideTradeMsg);
            this.roadLab.setVisible(hideTradeMsg);
            this.settlementSq.setVisible(hideTradeMsg);
            this.settlementLab.setVisible(hideTradeMsg);
            this.citySq.setVisible(hideTradeMsg);
            this.cityLab.setVisible(hideTradeMsg);
            if (this.shipSq != null) {
                this.shipSq.setVisible(hideTradeMsg);
                this.shipLab.setVisible(hideTradeMsg);
            }
            if (this.playerInterface.isGameObservableVP) {
                this.inventoryScroll.setVisible(hideTradeMsg);
                if (this.playerInterface.isGameFullyObservable) {
                    for (JComponent resComp : new JComponent[]{this.claySq, this.clayLab, this.oreSq, this.oreLab, this.sheepSq, this.sheepLab, this.wheatSq, this.wheatLab, this.woodSq, this.woodLab, this.resourceSqDivLine}) {
                        resComp.setVisible(hideTradeMsg);
                    }
                }
            }
            if (this.inPlay && this.player.isRobot()) {
                boolean clientAlreadySat;
                boolean bl = clientAlreadySat = null != this.playerInterface.getClientHand();
                if (clientAlreadySat) {
                    this.sittingRobotLockBut.setVisible(hideTradeMsg);
                } else if (this.game.getSeatLock(this.playerNumber) != SOCGame.SeatLockState.LOCKED) {
                    this.takeOverBut.setVisible(hideTradeMsg);
                }
            }
            this.offerHidingControls = !hideTradeMsg;
        }
        boolean bl = faceHidden = !this.faceImg.isVisible();
        if (faceHidden && !this.offerCounterHidingFace) {
            this.offerCounterHidingFace = true;
        } else if (!faceHidden && !this.offerCounterHidesFace) {
            return;
        }
        boolean bl2 = counterIsShowing = this.counterOfferPanel != null && this.counterOfferPanel.isVisible();
        if (this.offerCounterHidingFace != counterIsShowing) {
            this.faceImg.setVisible(!counterIsShowing);
            this.pname.setVisible(!counterIsShowing);
            this.vpLab.setVisible(!counterIsShowing);
            this.vpSq.setVisible(!counterIsShowing);
            this.larmyLab.setVisible(!counterIsShowing);
            this.lroadLab.setVisible(!counterIsShowing);
            if (this.svpSq != null) {
                boolean vis = !counterIsShowing && this.player.getSpecialVP() > 0;
                this.svpLab.setVisible(vis);
                this.svpSq.setVisible(vis);
                if (this.wonderLab != null) {
                    this.wonderLab.setVisible(vis);
                }
            }
            this.offerCounterHidingFace = counterIsShowing;
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void clearOffer(boolean updateSendCheckboxes) {
        this.messagePanel.setText(null);
        this.messagePanel.setVisible(false);
        if (!this.messageIsReset && !this.playerTradingDisabled) {
            this.offerPanel.setVisible(false);
            this.offerPanel.setTradeOffer(null);
            this.counterOfferPanel.setVisible(false);
            this.counterOfferPanel.setTradeResources(null, null);
        }
        if (this.playerIsClient) {
            this.sqPanel.setValues(zero, zero);
            if (updateSendCheckboxes && !this.playerTradingDisabled) {
                int pcurr = this.game.getCurrentPlayerNumber();
                boolean pIsCurr = pcurr == this.playerNumber;
                for (int i = 0; i < this.game.maxPlayers - 1; ++i) {
                    boolean wantSend;
                    boolean canSend;
                    if (pIsCurr) {
                        canSend = !this.game.isSeatVacant(this.playerSendMap[i]);
                        wantSend = canSend && this.playerSendForPrevTrade[i];
                    } else {
                        wantSend = canSend = pcurr == this.playerSendMap[i];
                    }
                    this.playerSend[i].setBoolValue(wantSend);
                    this.playerSend[i].setEnabled(canSend);
                }
            }
            this.clearOfferBut.setEnabled(false);
            if (!this.playerTradingDisabled) {
                this.offerBut.setEnabled(false);
                this.offerBut.setToolTipText(OFFERBUTTIP_DIS);
            }
        } else if (this.offerHidesControls) {
            this.hideTradeMsgShowOthers(true);
        }
        this.validate();
        this.repaint();
    }

    private void showMessage(String message) {
        if (this.playerIsClient) {
            return;
        }
        if (message != null) {
            this.offerIsHiddenByMessage = this.offerPanel != null && this.offerPanel.isVisible();
            this.messagePanel.setText(message);
            if (this.offerHidesControls) {
                this.hideTradeMsgShowOthers(false);
            }
            if (this.offerPanel != null) {
                this.offerPanel.setVisible(false);
                this.counterOfferPanel.setVisible(false);
            }
            this.messagePanel.setVisible(true);
            this.repaint();
        } else {
            this.messagePanel.setVisible(false);
            this.messageIsDiscardOrPick = false;
            this.messageIsReset = false;
            if (!this.offerIsHiddenByMessage || !this.inPlay) {
                this.hideMessage();
            } else {
                this.updateCurrentOffer(false, false);
            }
        }
    }

    public void resetBoardSetMessage(String message) throws IllegalStateException {
        if (!this.inPlay) {
            return;
        }
        if (this.messageIsDiscardOrPick) {
            throw new IllegalStateException("Cannot call resetmessage when discard msg");
        }
        this.showMessage(message);
        this.messageIsReset = message != null;
    }

    public boolean setDiscardOrPickMsg(boolean isDiscard) {
        if (!this.inPlay) {
            return false;
        }
        if (this.messageIsReset) {
            return false;
        }
        this.showMessage(isDiscard ? TRADEMSG_DISCARD : TRADEMSG_PICKING);
        this.messageIsDiscardOrPick = true;
        return true;
    }

    public void clearDiscardOrPickMsg() {
        if (!this.messageIsDiscardOrPick) {
            return;
        }
        this.showMessage(null);
        this.messageIsDiscardOrPick = false;
    }

    private void showMiscInfo(String info) throws IllegalStateException {
        if (this.playerIsClient) {
            throw new IllegalStateException("playerIsClient");
        }
        if (this.miscInfoArea == null) {
            JLabel la;
            this.miscInfoArea = la = new JLabel(info != null ? info : "");
            la.setFont(this.vpLab.getFont());
            la.setVerticalAlignment(1);
            la.setForeground(null);
            la.setBackground(null);
            this.add(la);
        }
        if (info == null || info.isEmpty()) {
            this.miscInfoArea.setText("");
            this.miscInfoArea.setVisible(false);
        } else {
            this.miscInfoArea.setText(info);
            this.invalidate();
        }
    }

    public void updateTakeOverButton() {
        if (this.game.getSeatLock(this.playerNumber) != SOCGame.SeatLockState.LOCKED && (this.game.getCurrentPlayerNumber() != this.playerNumber || this.game.getGameState() == 0 || this.game.getGameState() == 990)) {
            this.takeOverBut.setText(TAKEOVER);
        } else {
            this.takeOverBut.setText(SEAT_LOCKED);
        }
    }

    private void updateRollDoneBankButtons() {
        int gs = this.game.getGameState();
        this.rollBut.setEnabled(gs == 15);
        this.doneBut.setEnabled(gs <= 13 || this.doneButIsRestart || this.game.canEndTurn(this.playerNumber));
        this.bankBut.setEnabled(gs == 20);
        if (this.game.hasSeaBoard && gs == 42) {
            SOCInventoryItem placing = this.game.getPlacingItem();
            if (placing != null) {
                this.canCancelInvItemPlay = placing.canCancelPlay;
            }
            this.inventory.setEnabled(false);
            this.playCardBut.setText(CANCEL);
            this.playCardBut.setEnabled(this.canCancelInvItemPlay);
        } else if (this.game.isDebugFreePlacement() && this.inventory.isEnabled()) {
            this.inventory.setEnabled(false);
            this.playCardBut.setEnabled(false);
        } else if (gs == 33 || gs == 34) {
            boolean canCancel = this.client.getServerVersion(this.game) >= 2700 && this.game.canCancelPlayCurrentDevCard();
            this.playCardBut.setEnabled(canCancel);
            if (canCancel) {
                this.playCardBut.setText(CANCEL);
            }
        } else {
            if (!this.inventory.isEnabled()) {
                this.inventory.setEnabled(true);
            }
            if (this.playCardBut.getText().equals(CANCEL)) {
                this.playCardBut.setText(CARD);
                this.playCardBut.setEnabled(!this.inventoryItems.isEmpty());
            } else if (!(this.playCardBut.isEnabled() || this.inventoryItems.isEmpty() || this.player.hasPlayedDevCard())) {
                this.playCardBut.setEnabled(true);
            }
        }
    }

    public void updateSeatLockButton() {
        String tipText;
        String lbl;
        SOCGame.SeatLockState sl = this.game.getSeatLock(this.playerNumber);
        switch (sl) {
            case LOCKED: {
                lbl = ROBOTLOCKBUT_L;
                if (this.game.isPractice || this.client.sVersion >= 2000) {
                    tipText = ROBOTLOCKBUTTIP_L;
                    break;
                }
                tipText = ROBOTLOCKBUTTIP_L_OLD;
                break;
            }
            case CLEAR_ON_RESET: {
                lbl = ROBOTLOCKBUT_M;
                tipText = ROBOTLOCKBUTTIP_M;
                break;
            }
            default: {
                lbl = ROBOTLOCKBUT_U;
                tipText = this.game.isPractice || this.client.sVersion >= 2000 ? ROBOTLOCKBUTTIP_U : ROBOTLOCKBUTTIP_U_OLD;
            }
        }
        this.sittingRobotLockBut.setText(lbl);
        this.sittingRobotLockBut.setToolTipText(tipText);
        if (this.sitButIsLock) {
            String ttipText;
            String buttonText;
            boolean noPlayer;
            boolean bl = noPlayer = this.player == null || this.player.getName() == null;
            if (sl == SOCGame.SeatLockState.LOCKED) {
                buttonText = UNLOCKSEAT;
                ttipText = UNLOCKSEATTIP;
                if (noPlayer) {
                    this.pname.setText(SITLOCKED);
                    this.pname.setVisible(true);
                }
            } else {
                buttonText = LOCKSEAT;
                ttipText = LOCKSEATTIP;
                if (noPlayer) {
                    this.pname.setText(" ");
                    this.pname.setVisible(false);
                }
            }
            this.sitBut.setText(buttonText);
            this.sitBut.setToolTipText(ttipText);
            this.validate();
            this.repaint();
        }
    }

    protected void setLArmy(boolean haveIt) {
        this.larmyLab.setText(haveIt ? strings.get("hpan.L.army") : "");
        this.larmyLab.setToolTipText(haveIt ? strings.get("hpan.L.army.tip") : null);
    }

    protected void setLRoad(boolean haveIt) {
        this.lroadLab.setText(haveIt ? (this.game.hasSeaBoard ? strings.get("hpan.L.route") : strings.get("hpan.L.road")) : "");
        this.lroadLab.setToolTipText(haveIt ? (this.game.hasSeaBoard ? strings.get("hpan.L.route.tip") : strings.get("hpan.L.road.tip")) : null);
    }

    void setCanCancelInvItemPlay(boolean canCancel) {
        this.canCancelInvItemPlay = canCancel;
        if (this.playerIsClient && this.playCardBut.getText().equals(CANCEL)) {
            this.playCardBut.setEnabled(canCancel);
        }
    }

    public void updateValue(PlayerClientListener.UpdateType utype) {
        boolean updateTotalResCount = false;
        switch (utype) {
            case VictoryPoints: {
                int newVP = this.player.getTotalVP();
                this.vpSq.setIntValue(newVP);
                if (this.game.getGameState() != 1000) break;
                if (this.game.getPlayerWithWin() == this.player) {
                    this.vpSq.setToolTipText(strings.get("hpan.winner.label.ttwithvp", newVP));
                    this.pname.setText(strings.get("hpan.winner.label", this.player.getName()));
                }
                if (this.interactive) {
                    this.bankBut.setEnabled(false);
                    this.bankUndoBut.setEnabled(false);
                    this.playCardBut.setEnabled(false);
                }
                this.doneBut.setText(DONE_RESTART);
                this.doneBut.setEnabled(true);
                this.doneButIsRestart = true;
                break;
            }
            case SpecialVictoryPoints: {
                if (this.svpSq == null) break;
                int newSVP = this.player.getSpecialVP();
                this.svpSq.setIntValue(newSVP);
                boolean vis = newSVP != 0 && !this.offerCounterHidingFace;
                this.svpSq.setVisible(vis);
                this.svpLab.setVisible(vis);
                break;
            }
            case LongestRoad: {
                this.setLRoad(this.player.hasLongestRoad());
                break;
            }
            case LargestArmy: {
                this.setLArmy(this.player.hasLargestArmy());
                break;
            }
            case Clay: {
                this.claySq.setIntValue(this.player.getResources().getAmount(1));
                updateTotalResCount = true;
                break;
            }
            case Ore: {
                this.oreSq.setIntValue(this.player.getResources().getAmount(2));
                updateTotalResCount = true;
                break;
            }
            case Sheep: {
                this.sheepSq.setIntValue(this.player.getResources().getAmount(3));
                updateTotalResCount = true;
                break;
            }
            case Wheat: {
                this.wheatSq.setIntValue(this.player.getResources().getAmount(4));
                updateTotalResCount = true;
                break;
            }
            case Wood: {
                this.woodSq.setIntValue(this.player.getResources().getAmount(5));
                updateTotalResCount = true;
                break;
            }
            case ResourceTotalAndDetails: {
                if (this.playerIsClient || this.playerInterface.isGameFullyObservable) {
                    SOCResourceSet rsrc = this.player.getResources();
                    this.claySq.setIntValue(rsrc.getAmount(1));
                    this.oreSq.setIntValue(rsrc.getAmount(2));
                    this.sheepSq.setIntValue(rsrc.getAmount(3));
                    this.wheatSq.setIntValue(rsrc.getAmount(4));
                    this.woodSq.setIntValue(rsrc.getAmount(5));
                }
            }
            case Resources: {
                updateTotalResCount = true;
                break;
            }
            case Road: {
                this.roadSq.setIntValue(this.player.getNumPieces(0));
                break;
            }
            case Settlement: {
                this.settlementSq.setIntValue(this.player.getNumPieces(1));
                if (!this.playerIsClient) break;
                this.updateResourceTradeCosts(false);
                break;
            }
            case City: {
                this.citySq.setIntValue(this.player.getNumPieces(2));
                break;
            }
            case Ship: {
                if (this.shipSq == null) break;
                this.shipSq.setIntValue(this.player.getNumPieces(3));
                break;
            }
            case DevCards: {
                this.developmentSq.setIntValue(this.player.getInventory().getTotal());
                break;
            }
            case Knight: {
                this.knightsSq.setIntValue(this.player.getNumKnights());
                break;
            }
            case UndosRemaining: {
                if (this.undosSq == null) break;
                this.undosSq.setIntValue(this.player.getUndosRemaining());
                break;
            }
            case Cloth: {
                if (this.clothSq == null) break;
                this.clothSq.setIntValue(this.player.getCloth());
                break;
            }
            case WonderLevel: {
                int pLevel;
                if (this.wonderLab == null) break;
                SOCSpecialItem pWond = this.player.getSpecialItem("_SC_WOND", 0);
                int n = pLevel = pWond != null ? pWond.getLevel() : 0;
                if (pLevel == 0) {
                    this.wonderLab.setText("");
                    this.wonderLab.setToolTipText(null);
                    break;
                }
                String ofWonder = null;
                try {
                    String sv = pWond.getStringValue();
                    if (sv != null) {
                        ofWonder = strings.get("game.specitem.sc_wond.of_" + sv);
                    }
                }
                catch (MissingResourceException e) {
                    try {
                        ofWonder = strings.get("game.specitem.sc_wond.of_fallback");
                    }
                    catch (MissingResourceException e2) {
                        ofWonder = "of a Wonder";
                    }
                }
                this.wonderLab.setText(strings.get("hpan.wonderlevel", pLevel));
                this.wonderLab.setToolTipText(strings.get("hpan.wonderlevel.tip", pLevel, 4, ofWonder));
                break;
            }
        }
        if (updateTotalResCount) {
            int gs;
            this.resourceSq.setIntValue(this.player.getResources().getTotal());
            if (this.messageIsDiscardOrPick && (gs = this.game.getGameState()) != 56) {
                this.clearDiscardOrPickMsg();
            }
        }
    }

    public void updatePickGoldHexResources() {
        if (this.messageIsDiscardOrPick && 0 == this.player.getNeedToPickGoldHexResources()) {
            this.clearDiscardOrPickMsg();
        }
    }

    public void updateResourcesVP() {
        this.updateValue(PlayerClientListener.UpdateType.ResourceTotalAndDetails);
        if (this.playerIsClient) {
            this.updateResourceTradeCosts(false);
        }
        this.updateValue(PlayerClientListener.UpdateType.VictoryPoints);
    }

    public void updateResourceTradeCosts(boolean doInit) {
        boolean has3Port = this.player.getPortFlag(0);
        for (int i = 1; i <= 5; ++i) {
            ColorSquare resSq;
            int oldCost = this.resourceTradeCost[i];
            int newCost = this.player.getPortFlag(i) ? 2 : (has3Port ? 3 : 4);
            if (!doInit && newCost == oldCost) continue;
            this.resourceTradeCost[i] = newCost;
            if (!doInit) {
                this.resourceTradeMenu[i].updateCost(newCost);
                continue;
            }
            switch (i) {
                case 1: {
                    resSq = this.claySq;
                    break;
                }
                case 2: {
                    resSq = this.oreSq;
                    break;
                }
                case 3: {
                    resSq = this.sheepSq;
                    break;
                }
                case 4: {
                    resSq = this.wheatSq;
                    break;
                }
                case 5: {
                    resSq = this.woodSq;
                    break;
                }
                default: {
                    resSq = null;
                }
            }
            this.resourceTradeMenu[i] = new ResourceTradeTypeMenu(this, i, resSq, newCost);
        }
    }

    public boolean isClientPlayer() {
        return this.playerIsClient;
    }

    public boolean isClientAndCurrentPlayer() {
        return this.playerIsClient && this.playerIsCurrent;
    }

    public boolean isClientAndCurrentlyCanRoll() {
        return this.playerIsClient && this.playerIsCurrent && this.rollBut != null && this.rollBut.isEnabled();
    }

    protected void setRollPrompt(String prompt, boolean cancelTimer) {
        boolean wasUse = this.rollPromptInUse;
        boolean bl = this.rollPromptInUse = prompt != null;
        if (this.rollPromptInUse) {
            this.rollPromptCountdownLab.setText(prompt);
            this.rollPromptCountdownLab.repaint();
        } else if (wasUse) {
            this.rollPromptCountdownLab.setText(" ");
            this.rollPromptCountdownLab.repaint();
        }
        if (cancelTimer && this.autoRollTimerTask != null) {
            this.autoRollTimerTask.cancel();
            this.autoRollTimerTask = null;
        }
    }

    public ColorSquare getBlankStandIn() {
        return this.blankStandIn;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.blankStandIn != null) {
            this.blankStandIn.setBounds(x, y, width, height);
        }
    }

    @Override
    public void doLayout() {
        Dimension dim = this.getSize();
        int displayScale = this.playerInterface.displayScale;
        int inset = 3 * displayScale;
        int space = 2 * displayScale;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int lineH = 16 * displayScale;
        this.faceImg.setLocation(inset, inset);
        if (!this.inPlay) {
            int wUnlock;
            int wLock;
            int sitW = fm == null ? 70 * displayScale : (this.sitButIsLock ? 24 * displayScale + ((wLock = fm.stringWidth(LOCKSEAT)) > (wUnlock = fm.stringWidth(UNLOCKSEAT)) ? wLock : wUnlock) : 24 * displayScale + fm.stringWidth(this.sitBut.getText()));
            this.sitBut.setBounds((dim.width - sitW) / 2, (dim.height - 55 * displayScale) / 2, sitW, 40 * displayScale);
            this.pname.setHorizontalAlignment(0);
            this.pname.setBounds(inset, inset, dim.width - 2 * inset, lineH);
        } else {
            int labelspc;
            int faceW = 40 * displayScale;
            int pnameW = dim.width - (inset + faceW + inset + inset);
            int sqSize = 16 * displayScale;
            this.pname.setHorizontalAlignment(2);
            this.pname.setBounds(inset + faceW + inset, inset, pnameW, lineH);
            int vpW = fm.stringWidth(this.vpLab.getText().replace(' ', '_'));
            int y = inset + lineH + 2 * space;
            this.vpLab.setBounds(inset + faceW + inset, y, vpW, lineH);
            this.vpSq.setLocation(inset + faceW + inset + vpW + space, y);
            int topStuffW = inset + faceW + inset + vpW + space + sqSize + space;
            int topFaceAreaHeight = y + lineH;
            this.larmyLab.setBounds(topStuffW, y, (dim.width - (topStuffW + inset + space)) / 2, lineH);
            this.lroadLab.setBounds(topStuffW + (dim.width - (topStuffW + inset + space)) / 2 + space, y, (dim.width - (topStuffW + inset + space)) / 2, lineH);
            if (this.svpSq != null) {
                topFaceAreaHeight += lineH + displayScale;
                this.svpLab.setBounds(inset + faceW + inset, y += lineH + displayScale, vpW, lineH);
                this.svpSq.setLocation(inset + faceW + inset + vpW + space, y);
                if (this.wonderLab != null) {
                    int x = this.svpSq.getX() + sqSize + space;
                    this.wonderLab.setBounds(x, y, dim.width - x - space, lineH);
                }
            }
            if (topFaceAreaHeight < inset + faceW + inset) {
                topFaceAreaHeight = inset + faceW + inset;
            }
            int resourceInventoryTop = 0;
            if (this.playerIsClient) {
                JLabel[] labs;
                int gt;
                Dimension sqpDim = this.sqPanel.getSize();
                labelspc = fm.stringWidth("_") / 3;
                int gv = fm.stringWidth(GIVE);
                int giveW = (gv > (gt = fm.stringWidth(GET)) ? gv : gt) + labelspc + 2 * displayScale;
                int resCardsH = 6 * (lineH + space);
                int tradeH = sqpDim.height + space + 2 * (lineH + space);
                int sectionSpace = (dim.height - (topFaceAreaHeight + resCardsH + tradeH + inset)) / 5;
                int tradeY = topFaceAreaHeight + sectionSpace;
                int devCardsY = tradeY + tradeH + 2 * sectionSpace;
                this.startBut.setBounds(inset + faceW + inset, inset + lineH + space, dim.width - (inset + faceW + inset + inset), lineH);
                this.giveLab.setBounds(inset, tradeY, giveW, lineH);
                this.getLab.setBounds(inset, tradeY + 20 * displayScale, giveW, lineH);
                this.sqPanel.setLocation(inset + giveW + space, tradeY);
                int tbW = (giveW + sqpDim.width) / 2;
                int tbX = inset;
                int tbY = tradeY + sqpDim.height + space;
                if (this.offerBut != null) {
                    if (this.game.maxPlayers == 4) {
                        this.offerBut.setBounds(tbX, tbY, tbW, lineH);
                    } else {
                        this.offerBut.setBounds(tbX, tbY, 2 * tbW + space - 5 * (1 + sqSize), lineH);
                    }
                }
                this.clearOfferBut.setBounds(tbX, tbY + lineH + space, tbW, lineH);
                this.bankBut.setBounds(tbX + tbW + space, tbY + lineH + space, tbW, lineH);
                this.bankUndoBut.setBounds(tbX + tbW + space, tbY + 2 * (lineH + space), tbW, lineH);
                if (!this.playerTradingDisabled) {
                    if (this.game.maxPlayers == 4) {
                        this.playerSend[0].setLocation(tbX + tbW + space, tbY);
                        this.playerSend[1].setLocation(tbX + tbW + space + (tbW - sqSize) / 2, tbY);
                        this.playerSend[2].setLocation(tbX + tbW + space + tbW - sqSize, tbY);
                    } else {
                        int px = tbX + 2 * (space + tbW) - sqSize - 1;
                        int pi = 4;
                        while (pi >= 0) {
                            this.playerSend[pi].setLocation(px, tbY);
                            --pi;
                            px -= sqSize + 1;
                        }
                    }
                }
                int wmax = 0;
                for (JLabel L : labs = new JLabel[]{this.clothLab, this.knightsLab, this.roadLab, this.settlementLab, this.cityLab, this.shipLab}) {
                    int w;
                    if (L == null || (w = fm.stringWidth(L.getText())) <= wmax) continue;
                    wmax = w;
                }
                int wHalf = (dim.width - sqSize - 8 * displayScale) / 2;
                if ((wmax += 2) > wHalf) {
                    wmax = wHalf;
                }
                int knightsW = wmax;
                int x = dim.width - inset - sqSize;
                if (this.clothSq != null) {
                    this.clothLab.setBounds(x - knightsW - space, tradeY - (lineH + space), knightsW, lineH);
                    this.clothSq.setLocation(x, tradeY - (lineH + space));
                }
                this.knightsLab.setBounds(x - knightsW - space, tradeY, knightsW, lineH);
                this.knightsSq.setLocation(x, tradeY);
                this.roadLab.setBounds(x - knightsW - space, tradeY + lineH + space, knightsW, lineH);
                this.roadSq.setLocation(x, tradeY + lineH + space);
                this.settlementLab.setBounds(x - knightsW - space, tradeY + 2 * (lineH + space), knightsW, lineH);
                this.settlementSq.setLocation(x, tradeY + 2 * (lineH + space));
                this.cityLab.setBounds(x - knightsW - space, tradeY + 3 * (lineH + space), knightsW, lineH);
                this.citySq.setLocation(x, tradeY + 3 * (lineH + space));
                if (this.shipSq != null) {
                    this.shipLab.setBounds(x - knightsW - space, tradeY + 4 * (lineH + space), knightsW, lineH);
                    this.shipSq.setLocation(x, tradeY + 4 * (lineH + space));
                }
                resourceInventoryTop = devCardsY;
                int bbW = 50 * displayScale;
                tbY = dim.height - lineH - inset;
                this.rollPromptCountdownLab.setBounds(dim.width - (bbW + space + bbW + inset), tbY - lineH, dim.width - 2 * inset, lineH);
                this.quitBut.setBounds(inset, tbY, bbW, lineH);
                this.rollBut.setBounds(dim.width - (bbW + space + bbW + inset), tbY, bbW, lineH);
                this.doneBut.setBounds(dim.width - inset - bbW, tbY, bbW, lineH);
                this.offerHidesControls = false;
                this.offerCounterHidesFace = false;
            } else {
                int wHalf;
                JLabel[] labs;
                JLabel[] labs2;
                int numBottomLines;
                int counterOfferHeight;
                boolean wasHidesControls = this.offerHidesControls;
                boolean hasTakeoverBut = false;
                boolean hasSittingRobotLockBut = false;
                if (this.player.isRobot()) {
                    int lowerY = dim.height - (4 * (lineH + space) + inset);
                    int yb = lowerY - 5 * displayScale;
                    if (this.game.hasSeaBoard) {
                        yb -= lineH + space;
                    }
                    int pix9 = 9 * displayScale;
                    if (this.playerInterface.getClientPlayer() == null) {
                        this.takeOverBut.setBounds(pix9, yb, dim.width - 2 * pix9, lineH + space);
                        hasTakeoverBut = true;
                    } else if (this.sittingRobotLockBut.isVisible()) {
                        this.sittingRobotLockBut.setBounds(pix9, yb, dim.width - 2 * pix9, lineH + space);
                        hasSittingRobotLockBut = true;
                    }
                }
                boolean isCounterOfferMode = this.counterOfferPanel != null && this.counterOfferPanel.isVisible();
                Dimension offerPrefSize = this.offerPanel != null ? this.offerPanel.getPreferredSize() : null;
                int offerMinHeight = offerPrefSize != null ? offerPrefSize.height : 16;
                int n = counterOfferHeight = this.counterOfferPanel != null ? this.counterOfferPanel.getPreferredHeight(false) : 16;
                if (isCounterOfferMode) {
                    offerMinHeight += counterOfferHeight + space;
                }
                int n2 = numBottomLines = hasTakeoverBut || hasSittingRobotLockBut ? 5 : 4;
                if (this.game.hasSeaBoard) {
                    ++numBottomLines;
                }
                int resInventoryHeight = this.playerInterface.isGameObservableVP ? 6 * (lineH + space) : 0;
                int availHeightNoHide = dim.height - topFaceAreaHeight - resInventoryHeight - numBottomLines * (lineH + space);
                int miy = 0;
                int mih = 0;
                if (availHeightNoHide < offerMinHeight && !this.playerTradingDisabled) {
                    int[] prefSz = this.offerPanel.getCompactPreferredSize();
                    offerPrefSize.width = prefSz[0];
                    offerPrefSize.height = prefSz[1];
                    offerMinHeight = prefSz[1];
                    if (isCounterOfferMode) {
                        prefSz = this.counterOfferPanel.getCompactPreferredSize();
                        counterOfferHeight = prefSz[1];
                        offerMinHeight += counterOfferHeight + space;
                    }
                }
                boolean bl = this.offerHidesControls = this.offerHidingControls || availHeightNoHide < offerMinHeight && !this.playerTradingDisabled;
                if (this.offerHidesControls && !this.playerTradingDisabled) {
                    int ph;
                    int py;
                    this.offerCounterHidesFace = dim.height - offerMinHeight < topFaceAreaHeight;
                    int offerW = Math.min(dim.width - 2 * inset, offerPrefSize.width);
                    if (this.offerCounterHidingFace) {
                        py = inset;
                        ph = Math.min(dim.height - 2 * inset, offerPrefSize.height);
                        this.offerPanel.setBounds(inset, py, offerW, ph);
                        this.counterOfferPanel.setBounds(inset, py + ph + space, offerW, counterOfferHeight);
                    } else {
                        py = topFaceAreaHeight;
                        ph = Math.min(dim.height - (py + space), offerPrefSize.height);
                        this.messagePanel.setBounds(inset, py, offerW, ph);
                        this.offerPanel.setBounds(inset, py, offerW, ph);
                        this.counterOfferPanel.setBounds(inset, py + ph + space, offerW, counterOfferHeight);
                        if (resInventoryHeight > 0) {
                            resourceInventoryTop = topFaceAreaHeight + space;
                        }
                    }
                    if (this.miscInfoArea != null) {
                        if (this.messagePanel != null && this.messagePanel.isVisible()) {
                            this.miscInfoArea.setVisible(false);
                        } else {
                            miy = py;
                            mih = ph + counterOfferHeight;
                        }
                    }
                } else {
                    int py = topFaceAreaHeight;
                    if (resInventoryHeight > 0) {
                        resourceInventoryTop = dim.height - resInventoryHeight - numBottomLines * (lineH + space);
                    }
                    if (this.offerPanel != null) {
                        this.messagePanel.setBounds(inset, py, offerPrefSize.width, offerPrefSize.height);
                        this.offerPanel.setBounds(inset, py, offerPrefSize.width, offerPrefSize.height);
                        if (isCounterOfferMode) {
                            this.counterOfferPanel.setBounds(inset, py += offerPrefSize.height + space, offerPrefSize.width, counterOfferHeight);
                        }
                    } else {
                        Dimension msgPrefSize = this.messagePanel.getPreferredSize();
                        if (msgPrefSize.width > dim.width - inset) {
                            msgPrefSize.width = dim.width - inset;
                        }
                        if (msgPrefSize.height > availHeightNoHide) {
                            msgPrefSize.height = availHeightNoHide;
                        }
                        this.messagePanel.setBounds(inset, py, msgPrefSize.width, msgPrefSize.height);
                    }
                    if (this.miscInfoArea != null) {
                        if (this.messagePanel != null && this.messagePanel.isVisible()) {
                            this.miscInfoArea.setVisible(false);
                        } else {
                            miy = py + space;
                            mih = availHeightNoHide - inset - space;
                        }
                    }
                    this.offerCounterHidesFace = false;
                }
                if (mih != 0) {
                    if (mih < lineH) {
                        mih = lineH;
                    }
                    this.miscInfoArea.setBounds(inset, miy, dim.width - 2 * inset, mih);
                    this.miscInfoArea.setVisible(true);
                }
                if (this.offerPanel != null) {
                    this.offerPanel.validate();
                    if (isCounterOfferMode) {
                        this.counterOfferPanel.validate();
                    }
                }
                this.messagePanel.validate();
                int wmax = 0;
                for (JLabel L : labs2 = new JLabel[]{this.shipLab, this.roadLab, this.settlementLab, this.cityLab, this.undosLab}) {
                    int w;
                    if (L == null || (w = fm.stringWidth(L.getText())) <= wmax) continue;
                    wmax = w;
                }
                int wHalf2 = (dim.width - sqSize - 8 * displayScale) / 2;
                if ((wmax += 10 * displayScale) > wHalf2) {
                    wmax = wHalf2;
                }
                int stlmtsW = wmax;
                int wmax2 = 0;
                for (JLabel L : labs = new JLabel[]{this.clothLab, this.knightsLab}) {
                    int w;
                    if (L == null || (w = fm.stringWidth(L.getText())) <= wmax2) continue;
                    wmax2 = w;
                }
                int w = fm.stringWidth(this.resourceLab.getText());
                if (w > wmax2) {
                    wmax2 = w;
                }
                if ((w = fm.stringWidth(this.developmentLab.getText())) > wmax2) {
                    wmax2 = w;
                }
                if ((wmax2 += 2) > (wHalf = (dim.width - sqSize - 8 * displayScale) / 2)) {
                    wmax2 = wHalf;
                }
                int dcardsW = wmax2;
                int lowerY = dim.height - (4 * (lineH + space) + inset);
                this.resourceLab.setBounds(inset, lowerY + 2 * (lineH + space), dcardsW, lineH);
                this.resourceSq.setLocation(inset + dcardsW + space, lowerY + 2 * (lineH + space));
                this.developmentLab.setBounds(inset, lowerY + 3 * (lineH + space), dcardsW, lineH);
                this.developmentSq.setLocation(inset + dcardsW + space, lowerY + 3 * (lineH + space));
                this.knightsLab.setBounds(inset, lowerY + (lineH + space), dcardsW, lineH);
                this.knightsSq.setLocation(inset + dcardsW + space, lowerY + (lineH + space));
                if (this.clothSq != null) {
                    this.clothLab.setBounds(inset, lowerY, dcardsW, lineH);
                    this.clothSq.setLocation(inset + dcardsW + space, lowerY);
                }
                int x = dim.width - inset - sqSize;
                y = lowerY;
                if (this.shipSq == null) {
                    y += lineH + space;
                }
                if (this.undosSq != null) {
                    this.undosLab.setBounds(x - stlmtsW - space, y -= lineH + space, stlmtsW, lineH);
                    this.undosSq.setLocation(x, y);
                    y += lineH + space;
                    JButton btn = null;
                    if (hasTakeoverBut) {
                        btn = this.takeOverBut;
                    } else if (hasSittingRobotLockBut) {
                        btn = this.sittingRobotLockBut;
                    }
                    if (btn != null) {
                        btn.setBounds(inset, btn.getY(), x - stlmtsW - 3 * space - inset, btn.getHeight());
                    }
                }
                this.roadLab.setBounds(x - stlmtsW - space, y, stlmtsW, lineH);
                this.roadSq.setLocation(x, y);
                this.settlementLab.setBounds(x - stlmtsW - space, y += lineH + space, stlmtsW, lineH);
                this.settlementSq.setLocation(x, y);
                this.cityLab.setBounds(x - stlmtsW - space, y += lineH + space, stlmtsW, lineH);
                this.citySq.setLocation(x, y);
                if (this.shipSq != null) {
                    this.shipLab.setBounds(x - stlmtsW - space, y += lineH + space, stlmtsW, lineH);
                    this.shipSq.setLocation(x, y);
                }
                if ((wasHidesControls != this.offerHidesControls || this.offerCounterHidingFace != this.offerCounterHidesFace) && (this.messagePanel.isVisible() || this.offerPanel != null && this.offerPanel.isVisible())) {
                    this.hideTradeMsgShowOthers(false);
                }
            }
            if (resourceInventoryTop != 0) {
                int btnX;
                int tbY;
                int sheepW = this.doLayout_resourceLabelsWidth;
                if (sheepW == 0) {
                    labelspc = fm.stringWidth("_") / 3;
                    int wmax = 0;
                    JLabel[] rLabs = new JLabel[]{this.clayLab, this.oreLab, this.sheepLab, this.wheatLab, this.woodLab};
                    for (int i = 0; i < rLabs.length; ++i) {
                        int w;
                        String txt;
                        JLabel rl = rLabs[i];
                        if (rl == null || (txt = rl.getText()) == null || (w = fm.stringWidth(rl.getText())) <= wmax) continue;
                        wmax = w;
                    }
                    if (wmax == 0) {
                        wmax = fm.stringWidth("Sheep:");
                    }
                    this.doLayout_resourceLabelsWidth = sheepW = wmax + labelspc;
                }
                if (this.playerIsClient || this.playerInterface.isGameFullyObservable) {
                    tbY = resourceInventoryTop;
                    this.clayLab.setBounds(inset, tbY, sheepW, lineH);
                    this.claySq.setLocation(inset + sheepW + space, tbY);
                    this.oreLab.setBounds(inset, tbY += lineH + space, sheepW, lineH);
                    this.oreSq.setLocation(inset + sheepW + space, tbY);
                    this.sheepLab.setBounds(inset, tbY += lineH + space, sheepW, lineH);
                    this.sheepSq.setLocation(inset + sheepW + space, tbY);
                    this.wheatLab.setBounds(inset, tbY += lineH + space, sheepW, lineH);
                    this.wheatSq.setLocation(inset + sheepW + space, tbY);
                    this.woodLab.setBounds(inset, tbY += lineH + space, sheepW, lineH);
                    this.woodSq.setLocation(inset + sheepW + space, tbY);
                    this.resourceSqDivLine.setBounds(inset + space, (tbY += lineH + space) - displayScale, sheepW + sqSize, displayScale);
                    this.resourceLab.setBounds(inset, ++tbY, sheepW, lineH);
                    this.resourceSq.setLocation(inset + sheepW + space, tbY);
                }
                int clW = dim.width - (inset + sheepW + space + sqSize + 4 * space + inset);
                int clX = inset + sheepW + space + sqSize + 4 * space;
                int pcW = 10 * displayScale + fm.stringWidth(CARD.replace(' ', '_'));
                tbY = resourceInventoryTop + (lineH + space) / 2;
                this.inventoryScroll.setBounds(clX, tbY, clW, 4 * (lineH + space) - 2 * displayScale);
                y = tbY + 4 * (lineH + space);
                if (this.undosSq != null) {
                    int txtW = fm.stringWidth(this.undosLab.getText());
                    int sqX = clX + txtW + space;
                    if (sqX + sqSize + space > (btnX = clW - pcW + clX)) {
                        sqX = btnX - (sqSize + space);
                    }
                    this.undosLab.setBounds(sqX - txtW - space, y, txtW + 2 * displayScale, lineH);
                    this.undosSq.setLocation(sqX, y);
                } else {
                    btnX = (clW - pcW) / 2 + clX;
                }
                this.playCardBut.setBounds(btnX, y, pcW, lineH);
            }
        }
    }

    static class ResourceTradeTypeMenu
    extends ResourceTradePopupMenu
    implements MouseListener,
    ActionListener {
        private ColorSquare resSq;
        private int resTypeFrom;
        private int costFrom;
        boolean isForThree1;
        private ResourceTradeMenuItem[] tradeForItems;

        public ResourceTradeTypeMenu(SOCHandPanel hp, int typeFrom, ColorSquare sq, int numFrom) {
            super(hp, strings.get("board.trade.bank.port.trade"));
            this.init(typeFrom, hp.game, sq, numFrom, false);
        }

        public ResourceTradeTypeMenu(SOCHandPanel hp, int typeFrom, boolean forThree1) throws IllegalStateException {
            super(hp, strings.get("board.trade.trade.port"));
            if (!hp.getPlayerInterface().isClientCurrentPlayer()) {
                throw new IllegalStateException("Not current player");
            }
            this.init(typeFrom, hp.game, null, hp.resourceTradeCost[typeFrom], forThree1);
        }

        private void init(int typeFrom, SOCGame ga, ColorSquare sq, int numFrom, boolean forThree1) {
            this.resSq = sq;
            this.resTypeFrom = typeFrom;
            this.costFrom = numFrom;
            this.isForThree1 = forThree1;
            if (forThree1) {
                this.setLabel(strings.getSpecial(ga, "board.trade.trade.x.rsrcs", this.costFrom, typeFrom));
            }
            if (this.resSq != null) {
                this.resSq.add(this);
                this.resSq.addMouseListener(this);
            }
            this.tradeForItems = new ResourceTradeMenuItem[5];
            for (int i = 0; i < 5; ++i) {
                this.tradeForItems[i] = new ResourceTradeMenuItem(ga, numFrom, typeFrom, i + 1, forThree1);
                this.add(this.tradeForItems[i]);
                this.tradeForItems[i].addActionListener(this);
            }
        }

        @Override
        public void show(int x, int y) {
            this.setEnabledIfCanTrade(true);
            super.show(this.resSq, x, y);
        }

        @Override
        public void setEnabledIfCanTrade(boolean itemsOnly) {
            boolean canTrade;
            SOCPlayer p = this.hpan.player;
            boolean bl = canTrade = this.hpan.getGame().getGameState() == 20 && this.hpan.getGame().getCurrentPlayerNumber() == this.hpan.playerNumber && this.costFrom <= p.getResources().getAmount(this.resTypeFrom);
            if (itemsOnly) {
                for (int i = 0; i < 5; ++i) {
                    this.tradeForItems[i].setEnabled(canTrade);
                }
            } else {
                this.setEnabled(canTrade);
            }
        }

        public void updateCost(int newCost) {
            if (this.costFrom == newCost) {
                return;
            }
            this.costFrom = newCost;
            for (int i = 0; i < 5; ++i) {
                this.tradeForItems[i].setCost(newCost);
            }
        }

        public int getResourceType() {
            return this.resTypeFrom;
        }

        public int getResourceCost() {
            return this.costFrom;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Object src = e.getSource();
                ResourceTradeMenuItem mi = null;
                for (int i = 0; i < 5; ++i) {
                    if (src != this.tradeForItems[i]) continue;
                    mi = this.tradeForItems[i];
                    break;
                }
                if (mi == null) {
                    return;
                }
                mi.createBankTradeRequest(this.hpan);
            }
            catch (Throwable th) {
                this.hpan.getPlayerInterface().chatPrintStackTrace(th);
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            this.mouseClicked(evt);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            try {
                if (this.resSq == evt.getSource() && evt.isPopupTrigger()) {
                    evt.consume();
                    this.show(evt.getX(), evt.getY());
                }
            }
            catch (Throwable th) {
                this.hpan.getPlayerInterface().chatPrintStackTrace(th);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.mouseClicked(evt);
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void destroy() {
            for (int i = 0; i < 5; ++i) {
                if (this.tradeForItems[i] == null) continue;
                ResourceTradeMenuItem mi = this.tradeForItems[i];
                this.tradeForItems[i] = null;
                mi.removeActionListener(this);
            }
            this.hpan = null;
            if (this.resSq != null) {
                this.resSq.remove(this);
                this.resSq.removeMouseListener(this);
                this.resSq = null;
            }
            this.removeAll();
        }
    }

    static abstract class ResourceTradePopupMenu
    extends PopupMenu {
        protected SOCHandPanel hpan;

        protected ResourceTradePopupMenu(SOCHandPanel hp, String title) {
            super(title);
            this.hpan = hp;
        }

        public abstract void show(int var1, int var2);

        public abstract void setEnabledIfCanTrade(boolean var1);

        public abstract void destroy();
    }

    protected static class ResourceTradeMenuItem
    extends MenuItem {
        private static final Integer INT_1 = 1;
        private final SOCGame game;
        private int tradeFrom;
        private int tradeTo;
        private int tradeNum;
        private boolean shortTxt;

        public ResourceTradeMenuItem(SOCGame game, int numFrom, int typeFrom, int typeTo, boolean shortText) {
            super(shortText ? strings.getSpecial(game, "board.trade.for.1.rsrc", INT_1, typeTo) : strings.getSpecial(game, "board.trade.trade.x.rsrcs.for.1.rsrc", numFrom, typeFrom, INT_1, typeTo));
            this.game = game;
            this.tradeNum = numFrom;
            this.tradeFrom = typeFrom;
            this.tradeTo = typeTo;
            this.shortTxt = shortText;
            if (this.tradeFrom == this.tradeTo) {
                this.setEnabled(false);
            }
        }

        public void setCost(int numFrom) {
            if (this.tradeNum == numFrom) {
                return;
            }
            this.tradeNum = numFrom;
            if (this.shortTxt) {
                this.setLabel(strings.getSpecial(this.game, "board.trade.for.1.rsrc", INT_1, this.tradeTo));
            } else {
                this.setLabel(strings.getSpecial(this.game, "board.trade.trade.x.rsrcs.for.1.rsrc", numFrom, this.tradeFrom, INT_1, this.tradeTo));
            }
        }

        @Override
        public void setEnabled(boolean enable) {
            if (this.tradeFrom == this.tradeTo) {
                enable = false;
            }
            super.setEnabled(enable);
        }

        public int getTradeFrom() {
            return this.tradeFrom;
        }

        public int getTradeTo() {
            return this.tradeTo;
        }

        public void createBankTradeRequest(SOCHandPanel hp) {
            if (this.game.getGameState() != 20) {
                hp.getPlayerInterface().print("* " + strings.get("hpan.trade.msg.notnow") + "\n");
                return;
            }
            int[] give = new int[5];
            int[] get = new int[5];
            give[this.tradeFrom - 1] = this.tradeNum;
            get[this.tradeTo - 1] = 1;
            hp.createSendBankTradeRequest(give, get, false);
        }
    }

    protected class HandPanelAutoRollTask
    extends TimerTask {
        int timeRemain = 5;

        protected HandPanelAutoRollTask() {
        }

        @Override
        public void run() {
            if (Thread.currentThread().getName().startsWith("Thread-")) {
                try {
                    Thread.currentThread().setName("timertask-autoroll");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                if (this.timeRemain > 0) {
                    SOCHandPanel.this.setRollPrompt(MessageFormat.format(AUTOROLL_COUNTDOWN, this.timeRemain), false);
                } else {
                    SOCHandPanel.this.clickRollButton();
                    this.cancel();
                }
            }
            catch (Throwable thr) {
                SOCHandPanel.this.playerInterface.chatPrintStackTrace(thr);
            }
            finally {
                --this.timeRemain;
            }
        }
    }
}

