/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import soc.client.ColorSquare;
import soc.client.ColorSquareLarger;
import soc.client.SOCDialog;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.SwingMainDisplay;

class SOCMonopolyDialog
extends SOCDialog
implements ActionListener {
    final JButton[] rsrcBut;
    final JButton cancelBut;

    public SOCMonopolyDialog(SOCPlayerInterface pi, boolean withCancel) {
        super(pi, strings.get("spec.dcards.monopoly"), strings.get("dialog.mono.please.pick.resource"), withCancel, false);
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 20, 20, 20));
        JPanel btnsPane = this.getMiddlePanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        btnsPane.setLayout(gbl);
        this.rsrcBut = new JButton[5];
        String[] rsrcStr = new String[]{"resources.clay", "resources.ore", "resources.sheep", "resources.wheat", "resources.wood"};
        boolean shouldClearButtonBGs = SOCPlayerClient.IS_PLATFORM_WINDOWS && !SwingMainDisplay.isOSColorHighContrast();
        for (int i = 0; i < 5; ++i) {
            ColorSquareLarger sq = new ColorSquareLarger(ColorSquare.RESOURCE_COLORS[i]);
            JButton b = new JButton(strings.get(rsrcStr[i]));
            if (shouldClearButtonBGs) {
                b.setBackground(null);
            }
            b.addActionListener(this);
            this.rsrcBut[i] = b;
            gbc.anchor = 10;
            gbc.fill = 0;
            gbc.gridwidth = 1;
            gbl.setConstraints(sq, gbc);
            btnsPane.add(sq);
            gbc.anchor = 21;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbl.setConstraints(b, gbc);
            btnsPane.add(b);
        }
        if (withCancel) {
            JPanel pane = this.getSouthPanel();
            this.cancelBut = new JButton(strings.get("base.cancel"));
            this.cancelBut.addActionListener(this);
            pane.add(this.cancelBut);
            SOCMonopolyDialog.styleButtonsAndLabels(pane);
        } else {
            this.cancelBut = null;
        }
        this.pack();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.rsrcBut[0].requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object target = e.getSource();
            if (target == this.cancelBut) {
                this.clickedCancel();
                return;
            }
            for (int i = 0; i < 5; ++i) {
                if (target != this.rsrcBut[i]) continue;
                this.playerInterface.getClient().getGameMessageSender().pickResourceType(this.playerInterface.getGame(), i + 1);
                this.dispose();
                break;
            }
        }
        catch (Throwable th) {
            this.playerInterface.chatPrintStackTrace(th);
        }
    }

    public void clickedCancel() {
        if (this.cancelBut == null) {
            return;
        }
        this.playerInterface.getClient().getGameMessageSender().cancelBuildRequest(this.playerInterface.getGame(), -2);
        this.dispose();
    }

    @Override
    public void windowCloseChosen() {
        this.clickedCancel();
    }
}

