/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.UIManager;
import net.nand.util.i18n.mgr.StringManager;
import soc.client.ClientNetwork;
import soc.client.GameMessageSender;
import soc.client.MainDisplay;
import soc.client.MessageHandler;
import soc.client.PlayerClientListener;
import soc.client.SOCBoardPanel;
import soc.client.ServerGametypeInfo;
import soc.client.SwingMainDisplay;
import soc.client.UserPreferences;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCPlayer;
import soc.game.SOCScenario;
import soc.message.SOCLeaveChannel;
import soc.message.SOCLocalizedStrings;
import soc.message.SOCScenarioInfo;
import soc.server.SOCServer;
import soc.util.SOCFeatureSet;
import soc.util.SOCGameList;
import soc.util.SOCStringManager;
import soc.util.Version;

public class SOCPlayerClient {
    public static final String PROP_JSETTLERS_DEBUG_CLEAR__PREFS = "jsettlers.debug.clear_prefs";
    public static final String PROP_JSETTLERS_DEBUG_CLIENT_FEATURES = "jsettlers.debug.client.features";
    public static final String PREF_PI__WIDTH = "PI_width";
    public static final String PREF_PI__HEIGHT = "PI_height";
    public static final String PREF_SOUND_ON = "soundOn";
    public static final String PREF_BOT_TRADE_REJECT_SEC = "botTradeRejectSec";
    public static final String PREF_HEX_GRAPHICS_SET = "hexGraphicsSet";
    public static final String PREF_UI_SCALE_FORCE = "uiScaleForce";
    public static final String PREF_FACE_ICON = "faceIcon";
    final SOCStringManager strings;
    protected static String GAMENAME_PREFIX_CANNOT_JOIN = "(cannot join) ";
    public static final boolean IS_PLATFORM_MAC_OSX;
    static final boolean IS_PLATFORM_WINDOWS;
    final Locale cliLocale;
    private ClientNetwork net;
    private final MessageHandler messageHandler;
    private final GameMessageSender gameMessageSender;
    private MainDisplay mainDisplay;
    protected int sVersion;
    protected SOCFeatureSet sFeatures;
    protected ServerGametypeInfo tcpServGameOpts = new ServerGametypeInfo(false);
    protected ServerGametypeInfo practiceServGameOpts = new ServerGametypeInfo(true);
    public final String DEFAULT_PRACTICE_GAMENAME;
    protected String practiceNickname = null;
    protected String nickname = null;
    protected String password = null;
    protected boolean gotPassword;
    protected boolean isNGOFWaitingForAuthStatus;
    boolean debugTraffic;
    protected int lastFaceChange;
    protected final Hashtable<String, SOCGame> games = new Hashtable();
    protected SOCGameList serverGames = null;
    protected Map<String, String> gamesUnjoinableOverride = new HashMap<String, String>();
    private final Map<String, PlayerClientListener> clientListeners = new HashMap<String, PlayerClientListener>();
    private final HashMap<String, Map<String, Object>> gameReqLocalPrefs = new HashMap();
    protected Vector<String> ignoreList = new Vector();
    protected int numPracticeGames = 0;

    public SOCPlayerClient() {
        this(new MessageHandler());
    }

    protected SOCPlayerClient(MessageHandler mh) throws IllegalArgumentException {
        String gameopt3pName;
        if (mh == null) {
            throw new IllegalArgumentException("mh");
        }
        this.gotPassword = false;
        int id = UserPreferences.getPref(PREF_FACE_ICON, 1);
        if (id <= 0) {
            id = 1;
        }
        this.lastFaceChange = id;
        if (null != System.getProperty("jsettlers.debug.traffic")) {
            this.debugTraffic = true;
        }
        String jsLocale = System.getProperty("jsettlers.locale");
        Locale lo = null;
        if (jsLocale != null) {
            try {
                lo = StringManager.parseLocale(jsLocale.trim());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Could not parse locale " + jsLocale);
            }
        }
        this.cliLocale = lo != null ? lo : Locale.getDefault();
        this.strings = SOCStringManager.getClientManager(this.cliLocale);
        this.DEFAULT_PRACTICE_GAMENAME = this.strings.get("default.name.practice.game");
        GAMENAME_PREFIX_CANNOT_JOIN = this.strings.get("pcli.gamelist.cannot_join.parens") + ' ';
        String debug_clearPrefs = System.getProperty(PROP_JSETTLERS_DEBUG_CLEAR__PREFS);
        if (debug_clearPrefs != null) {
            UserPreferences.clear(debug_clearPrefs);
        }
        if ((gameopt3pName = System.getProperty("jsettlers.debug.client.gameopt3p")) != null) {
            gameopt3pName = gameopt3pName.toUpperCase(Locale.US);
            SOCGameOption gameopt3p = new SOCGameOption(gameopt3pName, 2000, Version.versionNumber(), false, 17, "Client test 3p option " + gameopt3pName);
            this.tcpServGameOpts.knownOpts.put(gameopt3p);
            this.practiceServGameOpts.knownOpts.put(gameopt3p);
            SOCServer.startupKnownOpts.put(gameopt3p);
        }
        this.net = new ClientNetwork(this);
        this.gameMessageSender = new GameMessageSender(this, this.clientListeners);
        this.messageHandler = mh;
    }

    public void setMainDisplay(MainDisplay md) throws IllegalArgumentException {
        if (md == null) {
            throw new IllegalArgumentException("null");
        }
        this.mainDisplay = md;
        this.net.setMainDisplay(md);
    }

    public void connect(final String chost, final int cport, String cuser, String cpass) {
        this.mainDisplay.connect(chost, cport, cpass, cuser);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SOCPlayerClient.this.net.connect(chost, cport);
            }
        });
    }

    public String getNickname(boolean forPractice) {
        return forPractice ? this.practiceNickname : this.nickname;
    }

    MainDisplay getMainDisplay() {
        return this.mainDisplay;
    }

    ClientNetwork getNet() {
        return this.net;
    }

    PlayerClientListener getClientListener(String gameName) {
        return this.clientListeners.get(gameName);
    }

    Map<String, PlayerClientListener> getClientListeners() {
        return this.clientListeners;
    }

    void reloadBoardGraphics() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SOCBoardPanel.reloadBoardGraphics(SOCPlayerClient.this.mainDisplay.getGUIContainer());
                    for (PlayerClientListener pcl : SOCPlayerClient.this.clientListeners.values()) {
                        pcl.boardUpdated();
                    }
                }
                catch (Throwable th) {
                    System.err.println("-- Error caught in reloadBoardGraphics: " + th + " --");
                    th.printStackTrace();
                    System.err.println("-- Error stack trace end --");
                    System.err.println();
                }
            }
        });
    }

    HashMap<String, Map<String, Object>> getGameReqLocalPrefs() {
        return this.gameReqLocalPrefs;
    }

    public GameMessageSender getGameMessageSender() {
        return this.gameMessageSender;
    }

    final MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    final boolean wantsI18nStrings(boolean isPractice) {
        return !(!isPractice && this.sVersion < 2000 || this.cliLocale == null || "en".equals(this.cliLocale.getLanguage()) && "US".equals(this.cliLocale.getCountry()));
    }

    protected void checkGameoptsForUnknownScenario(SOCGameOptionSet opts) {
        if (opts == null || this.tcpServGameOpts.allScenInfoReceived || !opts.containsKey("SC")) {
            return;
        }
        String scKey = opts.get("SC").getStringValue();
        if (scKey.length() == 0 || this.tcpServGameOpts.scenKeys.contains(scKey)) {
            return;
        }
        if (this.sVersion != Version.versionNumber()) {
            this.net.putNet(new SOCScenarioInfo(scKey, false).toCmd());
        } else {
            this.net.putNet(new SOCLocalizedStrings("S", 0, scKey).toCmd());
            this.tcpServGameOpts.scenKeys.add(scKey);
        }
    }

    protected void localizeGameScenarios(List<String> scStrs, boolean skipFirst, boolean sentAll, boolean isPractice) {
        int i;
        ServerGametypeInfo opts = isPractice ? this.practiceServGameOpts : this.tcpServGameOpts;
        int L = scStrs.size();
        int n = i = skipFirst ? 1 : 0;
        while (i < L) {
            String scKey = scStrs.get(i);
            opts.scenKeys.add(scKey);
            String nm = scStrs.get(++i);
            ++i;
            if (nm.equals("\u0016K")) continue;
            String desc = scStrs.get(i);
            ++i;
            SOCScenario sc = SOCScenario.getScenario(scKey);
            if (sc == null || nm.length() <= 0) continue;
            if (desc != null && desc.length() == 0) {
                desc = null;
            }
            sc.setDesc(nm, desc);
        }
        if (sentAll) {
            opts.allScenStringsReceived = true;
        }
    }

    public boolean doesGameExist(String gameName, boolean checkPractice) {
        boolean gameExists;
        boolean bl = checkPractice ? this.net.practiceServer != null && this.net.practiceServer.getGame(gameName) != null : (gameExists = false);
        if (!gameExists && this.serverGames != null) {
            gameExists = gameExists || this.serverGames.isGame(gameName);
        }
        return gameExists;
    }

    public void addToGameList(String gameName, String gameOptsStr, boolean addToSrvList) {
        boolean hasUnjoinMarker;
        boolean bl = hasUnjoinMarker = gameName.charAt(0) == '?';
        if (hasUnjoinMarker) {
            gameName = gameName.substring(1);
        }
        this.mainDisplay.addToGameList(hasUnjoinMarker, gameName, gameOptsStr, addToSrvList);
    }

    public void updateGameEndStats(String game, long[] scores) {
        SOCGame ga = this.games.get(game);
        if (ga == null) {
            return;
        }
        if (ga.getGameState() != 1000) {
            System.err.println("L4044: pcli.updateGameEndStats called at state " + ga.getGameState());
            return;
        }
        PlayerClientListener pcl = this.clientListeners.get(game);
        if (pcl == null) {
            return;
        }
        HashMap<SOCPlayer, Integer> scoresMap = new HashMap<SOCPlayer, Integer>();
        for (int i = 0; i < scores.length; ++i) {
            scoresMap.put(ga.getPlayer(i), (int)scores[i]);
        }
        pcl.gameEnded(scoresMap);
    }

    public void leaveChannel(String ch) {
        this.mainDisplay.channelLeft(ch);
        this.net.putNet(SOCLeaveChannel.toCmd("-", "-", ch));
    }

    protected boolean onIgnoreList(String name) {
        boolean result = false;
        for (String s : this.ignoreList) {
            if (!s.equals(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void addToIgnoreList(String name) {
        if (!this.onIgnoreList(name = name.trim())) {
            this.ignoreList.addElement(name);
        }
    }

    protected void removeFromIgnoreList(String name) {
        name = name.trim();
        this.ignoreList.removeElement(name);
    }

    public boolean startPracticeGame() {
        return this.startPracticeGame(null, null, true);
    }

    public boolean startPracticeGame(String practiceGameName, SOCGameOptionSet gameOpts, boolean mainPanelIsActive) {
        ++this.numPracticeGames;
        if (practiceGameName == null) {
            practiceGameName = this.DEFAULT_PRACTICE_GAMENAME + " " + this.numPracticeGames;
        }
        this.mainDisplay.practiceGameStarting();
        return this.net.startPracticeGame(practiceGameName, gameOpts);
    }

    void putGameReqLocalPrefs(String gaName, Map<String, Object> localPrefs) {
        this.gameReqLocalPrefs.put(gaName, localPrefs);
    }

    public int getServerVersion(SOCGame game) {
        if (game.isPractice) {
            return Version.versionNumber();
        }
        return this.sVersion;
    }

    public void shutdownFromNetwork() {
        boolean canPractice = this.net.putLeaveAll();
        String err = canPractice ? this.strings.get("pcli.error.networktrouble") : this.strings.get("pcli.error.clientshutdown");
        err = err + " " + (this.net.ex == null ? this.strings.get("pcli.error.loadpageagain") : this.net.ex.toString());
        this.mainDisplay.channelsClosed(err);
        for (Map.Entry<String, PlayerClientListener> e : this.clientListeners.entrySet()) {
            String gaName = e.getKey();
            SOCGame game = this.games.get(gaName);
            boolean isPractice = canPractice && game != null && game.isPractice;
            if (isPractice) continue;
            e.getValue().gameDisconnected(false, err);
            if (this.mainDisplay.deleteFromGameList(gaName, false, false)) continue;
            this.mainDisplay.deleteFromGameList(gaName, false, true);
        }
        this.net.dispose();
        this.mainDisplay.showErrorPanel(err, canPractice);
    }

    public static void usage() {
        System.err.println("usage: java [-D ...=...] -jar JSettlers.jar [<host> <port>]");
    }

    public static void main(String[] args) {
        int port;
        String host;
        Version.printVersionText(System.out, "Java Settlers Client ");
        if (args.length != 0) {
            if (args.length != 2) {
                SOCPlayerClient.usage();
                System.exit(1);
            }
            String h = null;
            int p = -1;
            try {
                h = args[0];
                p = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException x) {
                SOCPlayerClient.usage();
                System.err.println("Invalid port: " + args[1]);
                System.exit(1);
            }
            host = h;
            port = p;
        } else {
            host = null;
            port = -1;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception h) {
            // empty catch block
        }
        final SOCPlayerClient client = new SOCPlayerClient();
        JFrame frame = new JFrame(client.strings.get("pcli.main.title", Version.version()));
        int displayScale = SwingMainDisplay.checkDisplayScaleFactor(frame);
        SwingMainDisplay.scaleUIManagerFonts(displayScale);
        Color[] colors = SwingMainDisplay.getForegroundBackgroundColors(false, false);
        if (colors != null) {
            frame.setBackground(colors[2]);
            frame.setForeground(colors[0]);
        }
        SwingMainDisplay mainDisplay = new SwingMainDisplay(args.length == 0, client, displayScale);
        client.setMainDisplay(mainDisplay);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(mainDisplay.createWindowAdapter());
        mainDisplay.initVisualElements();
        frame.add((Component)mainDisplay, "Center");
        frame.setLocationByPlatform(true);
        frame.setSize(650 * displayScale, 400 * displayScale);
        frame.setVisible(true);
        if (Version.versionNumber() == 0) {
            client.mainDisplay.showErrorPanel("Packaging error: Cannot determine JSettlers version", false);
            return;
        }
        if (host != null && port != -1) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    client.connect(host, port, "", "");
                }
            });
        }
    }

    static {
        String osName = System.getProperty("os.name");
        IS_PLATFORM_WINDOWS = osName != null && osName.toLowerCase().indexOf("windows") != -1;
        boolean bl = IS_PLATFORM_MAC_OSX = osName != null && osName.toLowerCase().startsWith("mac os x");
        if (IS_PLATFORM_MAC_OSX) {
            System.setProperty("apple.awt.application.name", "JSettlers");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "JSettlers");
        } else if (!IS_PLATFORM_WINDOWS) {
            String currVal = null;
            try {
                currVal = System.getProperty("awt.useSystemAAFontSettings");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (currVal == null) {
                try {
                    System.setProperty("awt.useSystemAAFontSettings", "lcd");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }
}

