/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.TextComponent;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sound.sampled.Clip;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import soc.client.AskDialog;
import soc.client.ColorSquare;
import soc.client.MainDisplay;
import soc.client.NewGameOptionsFrame;
import soc.client.NotifyDialog;
import soc.client.PlayerClientListener;
import soc.client.SOCBoardPanel;
import soc.client.SOCBuildingPanel;
import soc.client.SOCChoosePlayerDialog;
import soc.client.SOCDiscardOrGainResDialog;
import soc.client.SOCHandPanel;
import soc.client.SOCMonopolyDialog;
import soc.client.SOCPlayerClient;
import soc.client.SOCQuitConfirmDialog;
import soc.client.SnippingTextArea;
import soc.client.Sounds;
import soc.client.SwingMainDisplay;
import soc.client.UserPreferences;
import soc.client.stats.SOCGameStatistics;
import soc.debug.D;
import soc.game.ResourceSet;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCFortress;
import soc.game.SOCGame;
import soc.game.SOCGameEvent;
import soc.game.SOCGameEventListener;
import soc.game.SOCInventoryItem;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerEvent;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.game.SOCSpecialItem;
import soc.game.SOCTradeOffer;
import soc.game.SOCVillage;
import soc.message.SOCPlayerElement;
import soc.util.SOCStringManager;

public class SOCPlayerInterface
extends JFrame
implements ActionListener,
MouseListener,
SOCGameEventListener,
PlayerClientListener.NonBlockingDialogDismissListener {
    public static final String PREF_SOUND_MUTE = "soundMute";
    private static final int WIDTH_MIN_4PL = 830;
    private static final int HEIGHT_MIN_4PL = 650;
    private static final SOCStringManager strings = SOCStringManager.getClientManager();
    private int width_base;
    private int height_base;
    private int widthOrig;
    private int heightOrig;
    final int displayScale;
    protected SOCBoardPanel boardPanel;
    private final boolean is6player;
    protected final boolean isGameFullyObservable;
    protected final boolean isGameObservableVP;
    private boolean layoutNotReadyYet = true;
    private boolean wasResized;
    private boolean hasCalledBegan;
    private boolean didGameScenarioPopupCheck;
    private JTextField textInput;
    private final List<String> textInputHistory;
    private int textInputHistoryBrowsePos;
    protected boolean textInputIsInitial;
    protected boolean textInputHasSent;
    protected int textInputGreyCountdown;
    protected static int textInputGreyCountFrom = 20;
    public static final String TEXTINPUT_INITIAL_PROMPT_MSG = strings.get("interface.type.here.chat");
    protected SOCPITextfieldListener textInputListener;
    protected SnippingTextArea textDisplay;
    protected SnippingTextArea chatDisplay;
    private volatile long textDisplaysLargerWhen;
    private volatile boolean textDisplaysLargerTemp;
    private volatile boolean textDisplaysLargerTemp_needsLayout;
    private volatile boolean textInputHasMouse;
    private volatile boolean textDisplayHasMouse;
    private volatile boolean chatDisplayHasMouse;
    private volatile boolean sbFixNeeded;
    private volatile boolean sbFixLHasMouse;
    private volatile boolean sbFixRHasMouse;
    private volatile boolean sbFixBHasMouse;
    protected SOCBuildingPanel buildingPanel;
    protected SOCHandPanel[] hands;
    protected SOCHandPanel clientHand;
    private int clientHandPlayerNum;
    boolean bankTradeWasFromTradePanel;
    protected Color[] playerColors;
    protected Color[] playerColorsGhost;
    private final Color highContrastBorderColor;
    private final ColorSquare[] highContrastBorders;
    protected final MainDisplay mainDisplay;
    protected final SOCPlayerClient client;
    protected SOCGame game;
    private boolean knowsGameState;
    protected boolean gameIsStarting;
    protected boolean clientPlayerIsSitting;
    protected boolean gameHasErrorOrDeletion;
    private final int[] layoutVS;
    protected SOCHandPanel boardResetRequester;
    protected ResetBoardVoteDialog boardResetVoteDia;
    private boolean showingPlayerDiscardOrPick;
    private Object showingPlayerDiscardOrPick_lock;
    private SOCPIDiscardOrPickMsgTask showingPlayerDiscardOrPick_task;
    private volatile Timer frameResizeDoneTimer;
    protected int ncols;
    protected int npix;
    private Dimension prevSize;
    private boolean soundMuted;
    private int botTradeRejectSec = UserPreferences.getPref("botTradeRejectSec", -8);
    protected SOCDiscardOrGainResDialog discardOrGainDialog;
    protected SOCChoosePlayerDialog choosePlayerDialog;
    protected SOCMonopolyDialog monopolyDialog;
    private SOCGameStatistics gameStats;
    private static Clip SOUND_BEGIN_TURN;
    private static Clip SOUND_PUT_PIECE;
    static Clip SOUND_RSRC_LOST;
    static Clip SOUND_RSRC_GAINED_FREE;
    static Clip SOUND_OFFERED_TRADE;
    private final ClientBridge clientListener;
    private static final ExecutorService soundQueueThreader;
    volatile Dialog nbdForEvent;

    static void addHotkeysInputMap_one(InputMap im, int vkChar, String eventStr, JButton btn) {
        im.put(KeyStroke.getKeyStroke(vkChar, 128), eventStr);
        if (SOCPlayerClient.IS_PLATFORM_WINDOWS) {
            if (btn != null) {
                btn.setMnemonic(vkChar);
            } else {
                im.put(KeyStroke.getKeyStroke(vkChar, 512), eventStr);
            }
        } else if (SOCPlayerClient.IS_PLATFORM_MAC_OSX) {
            im.put(KeyStroke.getKeyStroke(vkChar, 256), eventStr);
        }
    }

    static void removeHotkeysInputMap_one(InputMap im, int vkChar) {
        KeyStroke[] ksMods = new KeyStroke[2];
        ksMods[0] = KeyStroke.getKeyStroke(vkChar, 128);
        if (SOCPlayerClient.IS_PLATFORM_WINDOWS) {
            ksMods[1] = KeyStroke.getKeyStroke(vkChar, 512);
        } else if (SOCPlayerClient.IS_PLATFORM_MAC_OSX) {
            ksMods[1] = KeyStroke.getKeyStroke(vkChar, 256);
        }
        for (KeyStroke ks : ksMods) {
            if (ks == null) continue;
            im.put(ks, "none");
        }
    }

    public SOCPlayerInterface(String title, MainDisplay md, SOCGame ga, int[] layoutVS, Map<String, Object> localPrefs) throws IllegalArgumentException {
        super(strings.get("interface.title.game", title) + (ga.isPractice ? "" : " [" + md.getClient().getNickname(false) + "]"));
        int prefHeight;
        Object pref;
        this.setResizable(true);
        this.setLocationByPlatform(true);
        this.mainDisplay = md;
        int ds = 0;
        Object object = pref = localPrefs != null ? localPrefs.get("uiScaleForce") : null;
        if (pref != null && pref instanceof Integer) {
            ds = (Integer)pref;
        }
        this.displayScale = ds > 0 && ds <= 3 ? ds : md.getDisplayScaleFactor();
        this.client = md.getClient();
        this.game = ga;
        this.game.setGameEventListener(this);
        this.is6player = this.game.maxPlayers > 4;
        this.isGameFullyObservable = this.game.isGameOptionSet("PLAY_FO");
        this.isGameObservableVP = this.isGameFullyObservable || this.game.isGameOptionSet("PLAY_VPO");
        this.knowsGameState = this.game.getGameState() != 0;
        this.layoutVS = layoutVS;
        this.gameStats = new SOCGameStatistics(this.game);
        this.clientListener = this.createClientListenerBridge();
        this.gameIsStarting = false;
        this.clientHand = null;
        this.clientHandPlayerNum = -1;
        if (localPrefs != null) {
            this.soundMuted = Boolean.TRUE.equals(localPrefs.get(PREF_SOUND_MUTE));
            String k = "botTradeRejectSec";
            Object v = localPrefs.get(k);
            if (v != null) {
                if (v instanceof Integer) {
                    this.botTradeRejectSec = (Integer)v;
                } else {
                    throw new IllegalArgumentException("value not Integer: " + k);
                }
            }
        }
        this.showingPlayerDiscardOrPick = false;
        this.showingPlayerDiscardOrPick_lock = new Object();
        this.playerColors = new Color[this.game.maxPlayers];
        this.playerColorsGhost = new Color[this.game.maxPlayers];
        this.playerColors[0] = new Color(109, 124, 231);
        this.playerColors[1] = new Color(231, 35, 35);
        this.playerColors[2] = new Color(244, 238, 206);
        this.playerColors[3] = new Color(249, 128, 29);
        if (this.is6player) {
            this.playerColors[4] = new Color(97, 151, 113);
            this.playerColors[5] = this.playerColors[3];
            this.playerColors[3] = new Color(166, 88, 201);
        }
        for (int i = 0; i < this.game.maxPlayers; ++i) {
            this.playerColorsGhost[i] = SOCPlayerInterface.makeGhostColor(this.playerColors[i]);
        }
        if (!SwingMainDisplay.isOSColorHighContrast()) {
            this.highContrastBorderColor = null;
            this.getContentPane().setBackground(Color.BLACK);
            this.getContentPane().setForeground(Color.WHITE);
            this.highContrastBorders = null;
        } else {
            Color[] sysColors = SwingMainDisplay.getForegroundBackgroundColors(false, true);
            this.highContrastBorderColor = sysColors[0];
            this.highContrastBorders = new ColorSquare[this.game.maxPlayers];
        }
        this.setFont(new Font("SansSerif", 0, 10 * this.displayScale));
        this.setLayout(new PILayoutManager());
        this.initUIElements(true);
        this.textInputHistory = new ArrayList<String>();
        this.textInputHistory.add("");
        Dimension boardExtraSize = this.boardPanel.getExtraSizeFromBoard(false);
        int piHeight = 650;
        if ((this.is6player || this.game.hasSeaBoard) && SOCPlayerClient.IS_PLATFORM_WINDOWS) {
            piHeight += 25;
        }
        this.height_base = piHeight = (piHeight + boardExtraSize.height) * this.displayScale;
        int piWidth = 830;
        this.width_base = piWidth = (piWidth + boardExtraSize.width) * this.displayScale;
        int prefWidth = UserPreferences.getPref("PI_width", -1);
        int n = prefHeight = prefWidth != -1 ? UserPreferences.getPref("PI_height", 650) : 0;
        if (prefWidth != -1) {
            prefWidth *= this.displayScale;
            prefHeight *= this.displayScale;
            if (this.width_base != 830 * this.displayScale || this.height_base != 650 * this.displayScale) {
                piWidth = prefWidth + boardExtraSize.width * this.displayScale;
                piHeight = prefHeight + boardExtraSize.height * this.displayScale;
            } else {
                piWidth = prefWidth;
                piHeight = prefHeight;
            }
            try {
                DisplayMode mode = this.getGraphicsConfiguration().getDevice().getDisplayMode();
                int scWidth = mode.getWidth();
                int scHeight = mode.getHeight();
                if (piWidth > scWidth) {
                    if (piHeight > scHeight) {
                        float scrnRatio = scWidth / scHeight;
                        float piRatio = piWidth / piHeight;
                        if (scrnRatio < piRatio) {
                            piWidth = scWidth - 20;
                            piHeight = (int)((float)piWidth / piRatio);
                        } else {
                            piHeight = scHeight - 20;
                            piWidth = (int)((float)piHeight * piRatio);
                        }
                    } else {
                        piWidth = scWidth - 20;
                    }
                } else if (piHeight > scHeight) {
                    piHeight = scHeight - 20;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.widthOrig = piWidth;
        this.heightOrig = piHeight;
        this.wasResized = false;
        this.setSize(piWidth, piHeight);
        this.revalidate();
        this.repaint();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (SOCPlayerInterface.this.layoutNotReadyYet || e.getComponent() != SOCPlayerInterface.this || !SOCPlayerInterface.this.isVisible()) {
                    return;
                }
                Timer t = SOCPlayerInterface.this.frameResizeDoneTimer;
                if (t != null) {
                    t.restart();
                } else {
                    t = new Timer(300, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            SOCPlayerInterface.this.frameResizeDoneTimer = null;
                            SOCPlayerInterface.this.frameResizeDone();
                        }
                    });
                    t.setRepeats(false);
                    SOCPlayerInterface.this.frameResizeDoneTimer = t;
                    t.start();
                }
            }
        });
        if (SOUND_BEGIN_TURN == null) {
            soundQueueThreader.submit(new Runnable(){

                @Override
                public void run() {
                    byte[] buf = Sounds.genChime(880, 160, 0.38);
                    SOUND_BEGIN_TURN = Sounds.toClip(buf);
                    buf = new byte[Sounds.bufferLen(60)];
                    Sounds.genChime(140, 60, 0.15, buf, 0, false);
                    Sounds.genChime(160, 50, 0.15, buf, 0, true);
                    Sounds.genChime(240, 30, 0.2, buf, 0, true);
                    SOUND_PUT_PIECE = Sounds.toClip(buf);
                    buf = new byte[Sounds.bufferLen(210)];
                    int i = Sounds.genChime(330, 120, 0.9, buf, 0, false);
                    Sounds.genChime(262, 90, 0.9, buf, i, false);
                    SOUND_RSRC_LOST = Sounds.toClip(buf);
                    buf = new byte[Sounds.bufferLen(210)];
                    i = Sounds.genChime(262, 120, 0.9, buf, 0, false);
                    Sounds.genChime(330, 90, 0.9, buf, i, false);
                    SOUND_RSRC_GAINED_FREE = Sounds.toClip(buf);
                    buf = new byte[Sounds.bufferLen(240)];
                    i = Sounds.genChime(988, 120, 0.4, buf, 0, false);
                    Sounds.genChime(988, 120, 0.4, buf, i, false);
                    SOUND_OFFERED_TRADE = Sounds.toClip(buf);
                }
            });
        }
    }

    protected ClientBridge createClientListenerBridge() {
        return new ClientBridge(this);
    }

    public PlayerClientListener getClientListener() {
        return this.clientListener;
    }

    protected void initUIElements(boolean firstCall) {
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        this.textDisplaysLargerTemp = false;
        this.textDisplaysLargerTemp_needsLayout = false;
        this.textDisplaysLargerWhen = 0L;
        this.textInputHasMouse = false;
        this.textDisplayHasMouse = false;
        this.chatDisplayHasMouse = false;
        this.sbFixNeeded = false;
        this.sbFixLHasMouse = false;
        this.sbFixRHasMouse = false;
        this.sbFixBHasMouse = false;
        if (firstCall && this.is6player) {
            this.addMouseListener(this);
        }
        Font sans10Font = new Font("SansSerif", 0, 10 * this.displayScale);
        this.textDisplay = new SnippingTextArea("", 40, 80, 1, 80);
        this.textDisplay.setFont(sans10Font);
        if (!isOSHighContrast) {
            this.textDisplay.setBackground(SwingMainDisplay.DIALOG_BG_GOLDENROD);
            this.textDisplay.setForeground(Color.BLACK);
        }
        this.textDisplay.setEditable(false);
        this.add(this.textDisplay);
        if (this.is6player) {
            this.textDisplay.addMouseListener(this);
        }
        SOCPlayerInterface.textComponentAddClipboardContextMenu(this.textDisplay);
        this.chatDisplay = new SnippingTextArea("", 40, 80, 1, 100);
        this.chatDisplay.setFont(sans10Font);
        if (!isOSHighContrast) {
            this.chatDisplay.setBackground(SwingMainDisplay.DIALOG_BG_GOLDENROD);
            this.chatDisplay.setForeground(Color.BLACK);
        }
        this.chatDisplay.setEditable(false);
        if (this.is6player) {
            this.chatDisplay.addMouseListener(this);
        }
        this.add(this.chatDisplay);
        SOCPlayerInterface.textComponentAddClipboardContextMenu(this.chatDisplay);
        this.textInput = new JTextField();
        if (SOCPlayerClient.IS_PLATFORM_MAC_OSX) {
            int px = this.displayScale;
            this.textInput.setBorder(new EmptyBorder(px, px, px, px));
        }
        this.textInput.setFont(sans10Font);
        this.textInputListener = new SOCPITextfieldListener(this);
        this.textInputHasSent = false;
        this.textInputHistoryBrowsePos = 0;
        this.textInputGreyCountdown = textInputGreyCountFrom;
        this.textInput.addKeyListener(this.textInputListener);
        this.textInput.getDocument().addDocumentListener(this.textInputListener);
        this.textInput.addFocusListener(this.textInputListener);
        FontMetrics fm = this.getFontMetrics(this.textInput.getFont());
        this.textInput.setSize(379, fm.getHeight() + 4 * this.displayScale);
        if (!isOSHighContrast) {
            this.textInput.setBackground(Color.WHITE);
            this.textInput.setForeground(Color.BLACK);
        } else {
            Color[] sysColors = SwingMainDisplay.getForegroundBackgroundColors(false, true);
            this.textInput.setBackground(sysColors[2]);
            this.textInput.setForeground(sysColors[0]);
        }
        this.textInputIsInitial = false;
        this.textInput.setText(strings.get("base.please.wait"));
        this.add(this.textInput);
        this.textInput.addActionListener(this);
        if (this.is6player) {
            this.textInput.addMouseListener(this);
        }
        this.hands = new SOCHandPanel[this.game.maxPlayers];
        for (int i = 0; i < this.hands.length; ++i) {
            SOCHandPanel hp;
            this.hands[i] = hp = new SOCHandPanel(this, this.game.getPlayer(i));
            hp.setSize(180 * this.displayScale, 120 * this.displayScale);
            this.add(hp);
            ColorSquare blank = hp.getBlankStandIn();
            blank.setSize(hp.getSize());
            this.add(blank);
        }
        this.buildingPanel = new SOCBuildingPanel(this);
        this.buildingPanel.setSize(200 * this.displayScale, 80 * this.displayScale);
        this.add(this.buildingPanel);
        this.boardPanel = new SOCBoardPanel(this, this.layoutVS);
        this.boardPanel.setBackground(new Color(63, 86, 139));
        this.boardPanel.setForeground(Color.black);
        this.boardPanel.setFont(sans10Font);
        Dimension bpMinSz = this.boardPanel.getMinimumSize();
        this.boardPanel.setSize(bpMinSz.width * this.displayScale, bpMinSz.height * this.displayScale);
        this.add(this.boardPanel);
        if (this.game.isGameOptionDefined("PL")) {
            this.updatePlayerLimitDisplay(true, false, -1);
        }
        if (this.is6player && SOCPlayerClient.IS_PLATFORM_WINDOWS) {
            this.sbFixNeeded = true;
            this.hands[0].addMouseListener(this);
            this.hands[1].addMouseListener(this);
            this.boardPanel.addMouseListener(this);
        }
        if (this.highContrastBorders != null) {
            Dimension dim4x4 = new Dimension(4, 4);
            for (int i = 0; i < this.game.maxPlayers; ++i) {
                ColorSquare sq = new ColorSquare(this.highContrastBorderColor);
                sq.setBorderColor(this.highContrastBorderColor);
                sq.setMinimumSize(dim4x4);
                this.highContrastBorders[i] = sq;
                this.add(sq);
            }
        }
        if (firstCall) {
            this.addWindowListener(new PIWindowAdapter(this.mainDisplay, this));
            this.setDefaultCloseOperation(0);
        }
    }

    private void addHotkeysInputMap() throws IllegalStateException {
        final PIHotkeyActionListener acceptTrade = new PIHotkeyActionListener(1);
        ActionMap am = this.buildingPanel.getActionMap();
        am.put("hotkey_accept", acceptTrade);
        am.put("hotkey_reject", new PIHotkeyActionListener(2));
        am.put("hotkey_counteroffer", new PIHotkeyActionListener(3));
        if (this.game.maxPlayers > 4) {
            am.put("hotkey_askspecialbuild", new PIHotkeyActionListener(4));
        }
        InputMap im = this.buildingPanel.getInputMap(2);
        SOCPlayerInterface.addHotkeysInputMap_one(im, 65, "hotkey_accept", null);
        SOCPlayerInterface.addHotkeysInputMap_one(im, 74, "hotkey_reject", null);
        SOCPlayerInterface.addHotkeysInputMap_one(im, 67, "hotkey_counteroffer", null);
        if (this.game.maxPlayers > 4) {
            SOCPlayerInterface.addHotkeysInputMap_one(im, 66, "hotkey_askspecialbuild", null);
        }
        this.textInput.getActionMap().put("hotkey_selectAllOrTradeAccept", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int L;
                String txt = SOCPlayerInterface.this.textInput.getText();
                int n = L = txt != null ? txt.length() : 0;
                if (L == 0 || SOCPlayerInterface.this.textInput.getSelectionStart() == 0 && SOCPlayerInterface.this.textInput.getSelectionEnd() == L) {
                    acceptTrade.actionPerformed(e);
                } else {
                    SOCPlayerInterface.this.textInput.selectAll();
                }
            }
        });
        SOCPlayerInterface.addHotkeysInputMap_one(this.textInput.getInputMap(0), 65, "hotkey_selectAllOrTradeAccept", null);
    }

    private static void textComponentAddClipboardContextMenu(final TextComponent tfield) {
        final PopupMenu menu = new PopupMenu();
        MenuItem mi = new MenuItem(strings.get("menu.copy"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    StringSelection data = new StringSelection(tfield.getSelectedText());
                    Clipboard cb = tfield.getToolkit().getSystemClipboard();
                    if (cb != null) {
                        cb.setContents(data, data);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        menu.add(mi);
        mi = new MenuItem(strings.get("menu.select_all"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                tfield.selectAll();
                tfield.repaint();
            }
        });
        menu.add(mi);
        tfield.add(menu);
        tfield.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseClicked(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    return;
                }
                e.consume();
                menu.show(tfield, e.getX(), e.getY());
            }
        });
    }

    public SOCPlayerClient getClient() {
        return this.mainDisplay.getClient();
    }

    public MainDisplay getMainDisplay() {
        return this.mainDisplay;
    }

    public SOCGame getGame() {
        return this.game;
    }

    public SOCGameStatistics getGameStats() {
        return this.gameStats;
    }

    public boolean isSoundMuted() {
        return this.soundMuted;
    }

    public void setSoundMuted(boolean mute) {
        this.soundMuted = mute;
    }

    public int getBotTradeRejectSec() {
        return this.botTradeRejectSec;
    }

    public void setBotTradeRejectSec(int sec) {
        this.botTradeRejectSec = sec;
    }

    public Color getPlayerColor(int pn) {
        return this.getPlayerColor(pn, false);
    }

    public Color getPlayerColor(int pn, boolean isGhost) {
        if (isGhost) {
            return this.playerColorsGhost[pn];
        }
        return this.playerColors[pn];
    }

    public SOCHandPanel getPlayerHandPanel(int pn) {
        if (pn < 0) {
            return null;
        }
        return this.hands[pn];
    }

    public SOCBoardPanel getBoardPanel() {
        return this.boardPanel;
    }

    public java.util.Timer getEventTimer() {
        return this.mainDisplay.getEventTimer();
    }

    private void frameResizeDone() {
        Dimension siz = this.getSize();
        int w = siz.width;
        int h = siz.height;
        if (!this.wasResized) {
            if (w == this.widthOrig && h == this.heightOrig) {
                return;
            }
            this.wasResized = true;
        }
        Dimension boardExtraSize = this.boardPanel.getExtraSizeFromBoard(true);
        if ((w -= boardExtraSize.width) < 100 || (h -= boardExtraSize.height) < 100) {
            return;
        }
        UserPreferences.putPref("PI_width", w / this.displayScale);
        UserPreferences.putPref("PI_height", h / this.displayScale);
    }

    public void updateDevCardCount() {
        this.buildingPanel.updateDevCardCount();
    }

    public void updateLongestLargest(boolean isRoadNotArmy, SOCPlayer oldp, SOCPlayer newp) {
        PlayerClientListener.UpdateType updateType = isRoadNotArmy ? PlayerClientListener.UpdateType.LongestRoad : PlayerClientListener.UpdateType.LargestArmy;
        for (int i = 0; i < this.game.maxPlayers; ++i) {
            this.hands[i].updateValue(updateType);
            this.hands[i].updateValue(PlayerClientListener.UpdateType.VictoryPoints);
        }
        if (newp != oldp && (null != oldp || null != newp)) {
            String changedObj = isRoadNotArmy ? (this.game.hasSeaBoard ? "game.route.longest" : "game.road.longest") : "game.army.largest";
            String msg = newp != null ? (oldp != null ? strings.get(changedObj + ".taken", oldp.getName(), newp.getName()) : strings.get(changedObj + ".first", newp.getName())) : strings.get(changedObj + ".lost", oldp.getName());
            this.print(msg, true);
        }
    }

    private void updatePlayerLimitDisplay(boolean show, boolean isGameStart, int playerLeaving) {
        block8: {
            int availPl;
            boolean clientSatAlready;
            block9: {
                int maxPl;
                boolean noTextOverlay;
                int gstate = this.game.getGameState();
                clientSatAlready = this.clientHand != null;
                boolean bl = noTextOverlay = !show || isGameStart || clientSatAlready && (gstate >= 1 || this.game.isBoardReset());
                if (gstate == 0) {
                    isGameStart = true;
                }
                if ((maxPl = this.game.getGameOptionIntValue("PL")) == this.game.maxPlayers) {
                    noTextOverlay = true;
                }
                availPl = this.game.getAvailableSeatCount();
                if (playerLeaving != -1) {
                    ++availPl;
                }
                if (noTextOverlay) {
                    this.boardPanel.setSuperimposedText(null, null);
                } else {
                    this.boardPanel.setSuperimposedText(strings.get("interface.max.players", maxPl), strings.get("interface.seats.avail", availPl));
                }
                if (!isGameStart && clientSatAlready) break block8;
                if (availPl != 0) break block9;
                for (int i = 0; i < this.game.maxPlayers; ++i) {
                    this.hands[i].removeSitBut();
                }
                break block8;
            }
            if (playerLeaving == -1) break block8;
            this.hands[playerLeaving].addSitButton(clientSatAlready);
            if (availPl == 1) {
                for (int i = 0; i < this.game.maxPlayers; ++i) {
                    if (!this.game.isSeatVacant(i)) continue;
                    this.hands[i].addSitButton(clientSatAlready);
                }
            }
        }
    }

    void hideHandMessage(int pn) {
        if (pn != -1) {
            this.hands[pn].hideMessage();
        } else {
            for (int i = 0; i < this.game.maxPlayers; ++i) {
                this.hands[i].hideMessage();
            }
        }
    }

    void setDebugFreePlacementMode(boolean setOn) {
        try {
            if (!setOn) {
                this.setDebugFreePlacementPlayer(this.clientHandPlayerNum);
            }
            this.game.setDebugFreePlacement(setOn);
            if (!setOn) {
                this.boardPanel.setPlayer(null);
            }
            this.boardPanel.updateMode();
            this.buildingPanel.updateButtonStatus();
            if (this.clientHand != null) {
                this.clientHand.updateAtOurGameState();
            }
        }
        catch (IllegalStateException e) {
            this.textDisplay.append("*** Can't setDebugFreePlacement(" + setOn + ") for " + this.game.getName() + " in state " + this.game.getGameState() + "\n");
        }
    }

    void setDebugFreePlacementPlayer(int pn) {
        if (!this.game.isDebugFreePlacement()) {
            return;
        }
        int prevPn = this.boardPanel.getPlayerNumber();
        if (pn == prevPn) {
            return;
        }
        this.boardPanel.setPlayer(this.game.getPlayer(pn));
        this.getPlayerHandPanel(prevPn).updateAtTurn();
        this.getPlayerHandPanel(pn).updateAtTurn();
    }

    public SOCBuildingPanel getBuildingPanel() {
        return this.buildingPanel;
    }

    public SOCHandPanel getClientHand() {
        return this.clientHand;
    }

    public void setClientHand(SOCHandPanel h) {
        this.clientHand = h;
        this.clientHandPlayerNum = h != null ? h.getPlayer().getPlayerNumber() : -1;
    }

    public final boolean isClientCurrentPlayer() {
        if (this.clientHand == null) {
            return false;
        }
        return this.clientHand.isClientAndCurrentPlayer();
    }

    public final String getClientNickname() {
        return this.client.getNickname(this.game.isPractice);
    }

    public final SOCPlayer getClientPlayer() {
        return this.clientHandPlayerNum >= 0 ? this.game.getPlayer(this.clientHandPlayerNum) : null;
    }

    public final int getClientPlayerNumber() {
        return this.clientHandPlayerNum;
    }

    public void showDiceResult(SOCPlayer cp, int roll) {
        if (roll > 0) {
            this.print(strings.get("game.roll.rolled.number", roll));
        }
        this.boardPanel.repaint();
        if (roll >= 2 && roll <= 12 && cp != null) {
            this.gameStats.diceRolled(new SOCGameStatistics.DiceRollEvent(roll, cp));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.textInput) {
            if (this.textInputIsInitial) {
                this.textInputSetToInitialPrompt(false);
                this.textInput.setText(" ");
                return;
            }
            String s = this.textInput.getText().trim();
            String sOverflow = null;
            if (!SOCPlayerInterface.checkTextCharactersOrPopup(s, this.mainDisplay, this)) {
                return;
            }
            if (s.length() > 100) {
                int lastSpace = s.lastIndexOf(32, 100);
                if (lastSpace == -1) {
                    lastSpace = 100;
                }
                sOverflow = s.substring(lastSpace).trim();
                s = s.substring(0, lastSpace).trim();
            } else if (s.length() == 0) {
                return;
            }
            if (!this.textInputHasSent) {
                this.textInputHasSent = true;
                if (this.textInputListener != null) {
                    this.textInput.getDocument().removeDocumentListener(this.textInputListener);
                }
            }
            this.textInput.setText("");
            int S = this.textInputHistory.size();
            if (S == 1 || !this.textInputHistory.get(S - 1).equals(s)) {
                this.textInputHistory.add(s);
            }
            this.textInputHistoryBrowsePos = 0;
            if (s.startsWith("=*=")) {
                boolean doSet;
                String sLower = s.toLowerCase();
                int i = sLower.indexOf("show:");
                if (i > 0) {
                    doSet = true;
                } else {
                    i = sLower.indexOf("hide:");
                    doSet = false;
                }
                if (i > 0) {
                    int flagnum;
                    s = sLower.substring(i + 5).trim();
                    if (s.equalsIgnoreCase("all")) {
                        flagnum = -1;
                    } else {
                        try {
                            flagnum = Integer.parseInt(s);
                        }
                        catch (NumberFormatException e2) {
                            this.chatPrintDebug("Usage: =*= show: n  or =*= hide: n   where n is all or a number 0-9");
                            return;
                        }
                    }
                    this.boardPanel.setDebugShowPotentialsFlag(flagnum, false, doSet);
                    return;
                }
                if (sLower.indexOf("showcoord") == 4) {
                    this.boardPanel.setDebugShowCoordsFlag(true);
                    return;
                }
                if (sLower.indexOf("hidecoord") == 4) {
                    this.boardPanel.setDebugShowCoordsFlag(false);
                    return;
                }
            }
            if (!this.doLocalCommand(s)) {
                this.client.getGameMessageSender().sendText(this.game, s);
            }
            if (sOverflow != null) {
                this.textInput.setText(sOverflow);
                this.textInput.setSelectionStart(0);
                this.textInput.setSelectionEnd(0);
                this.textInput.setCaretPosition(sOverflow.length());
            }
        }
    }

    public static boolean checkTextCharactersOrPopup(String txt, MainDisplay md, Window parent) {
        if (txt.indexOf(124) != -1) {
            NotifyDialog.createAndShow(md, parent, strings.get("interface.chat.text.no_pipe_symbol"), null, true);
            return false;
        }
        return true;
    }

    private boolean doLocalCommand(String cmd) {
        if (cmd.charAt(0) != '\\') {
            return false;
        }
        if (cmd.startsWith("\\ignore ")) {
            String name = cmd.substring(8);
            this.client.addToIgnoreList(name);
            this.print("* Ignoring " + name);
            this.mainDisplay.printIgnoreList(this);
            return true;
        }
        if (cmd.startsWith("\\unignore ")) {
            String name = cmd.substring(10);
            this.client.removeFromIgnoreList(name);
            this.print("* Unignoring " + name);
            this.mainDisplay.printIgnoreList(this);
            return true;
        }
        if (cmd.startsWith("\\clm-set ")) {
            this.doLocalCommand_botConsiderMode(cmd.substring(9), 7, "clm-set");
            return true;
        }
        if (cmd.startsWith("\\clm-road ")) {
            this.doLocalCommand_botConsiderMode(cmd.substring(10), 8, "clm-road");
            return true;
        }
        if (cmd.startsWith("\\clm-ship ")) {
            this.doLocalCommand_botConsiderMode(cmd.substring(10), 13, "clm-ship");
            return true;
        }
        if (cmd.startsWith("\\clm-city ")) {
            this.doLocalCommand_botConsiderMode(cmd.substring(10), 9, "clm-city");
            return true;
        }
        if (cmd.startsWith("\\clt-set ")) {
            this.doLocalCommand_botConsiderMode(cmd.substring(9), 10, "clt-set");
            return true;
        }
        if (cmd.startsWith("\\clt-road ")) {
            this.doLocalCommand_botConsiderMode(cmd.substring(10), 11, "clt-road");
            return true;
        }
        if (cmd.startsWith("\\clt-ship ")) {
            this.doLocalCommand_botConsiderMode(cmd.substring(10), 14, "clt-ship");
            return true;
        }
        if (cmd.startsWith("\\clt-city ")) {
            this.doLocalCommand_botConsiderMode(cmd.substring(10), 12, "clt-city");
            return true;
        }
        return false;
    }

    private void doLocalCommand_botConsiderMode(String botPlName, int mode, String modeNameKey) {
        SOCPlayer pl = this.game.getPlayer((botPlName = botPlName.trim()).trim());
        if (pl != null) {
            String modeName;
            this.boardPanel.setOtherPlayer(pl);
            this.boardPanel.setMode(mode);
            try {
                modeName = strings.get("interface.debug.bot." + modeNameKey);
            }
            catch (MissingResourceException e) {
                modeName = modeNameKey;
            }
            this.printKeyed("interface.debug.bot.mode_prompt", modeName, botPlName);
        } else {
            this.printKeyed("interface.debug.bot.not_found", botPlName);
        }
    }

    public void leaveGame() {
        this.mainDisplay.leaveGame(this.game);
        if (this.clientHand != null) {
            this.clientHand.removePlayer();
        }
        this.client.getGameMessageSender().leaveGame(this.game);
        this.dispose();
    }

    public void resetBoardRequest(boolean confirmDialogFirst) {
        if (confirmDialogFirst) {
            EventQueue.invokeLater(new ResetBoardConfirmDialog(this.mainDisplay, this));
            return;
        }
        if (this.client.getServerVersion(this.game) < 1100) {
            this.textDisplay.append("*** " + strings.get("reset.server.support.too.old") + "\n");
            return;
        }
        if (this.game.getResetVoteActive()) {
            this.textDisplay.append("*** " + strings.get("reset.voting.already.active") + "\n");
            return;
        }
        SOCPlayer pl = this.game.getPlayer(this.clientHandPlayerNum);
        if (!pl.hasAskedBoardReset()) {
            this.client.getGameMessageSender().resetBoardRequest(this.game);
        } else {
            this.textDisplay.append("*** " + strings.get("reset.you.may.ask.once") + "\n");
        }
    }

    public void resetBoardVoted(int pn, boolean vyes) {
        String voteMsg = vyes ? strings.get("reset.go.ahead") : strings.get("base.no.thanks.sentenc");
        this.printKeyed("reset.x.has.voted", this.game.getPlayer(pn).getName(), voteMsg);
        this.game.resetVoteRegister(pn, vyes);
        try {
            this.hands[pn].resetBoardSetMessage(voteMsg);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void resetBoardRejected() {
        this.textDisplay.append("*** " + strings.get("reset.was.rejected") + "\n");
        for (int i = 0; i < this.hands.length; ++i) {
            try {
                this.hands[i].resetBoardSetMessage(null);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.boardResetRequester = null;
        if (this.boardResetVoteDia != null) {
            if (this.boardResetVoteDia.isShowing()) {
                this.boardResetVoteDia.disposeQuietly();
            }
            this.boardResetVoteDia = null;
        }
    }

    public void resetBoardAskVote(int pnRequester) {
        boolean gaOver = this.game.getGameState() >= 1000;
        try {
            this.game.resetVoteBegin(pnRequester);
        }
        catch (RuntimeException re) {
            D.ebugPrintlnINFO("resetBoardAskVote: Cannot: " + re);
            return;
        }
        this.boardResetRequester = this.hands[pnRequester];
        if (pnRequester != this.clientHandPlayerNum) {
            String pleaseMsg = gaOver ? strings.get("reset.restart.game") : strings.get("reset.board");
            this.boardResetRequester.resetBoardSetMessage(pleaseMsg);
            String requester = this.game.getPlayer(pnRequester).getName();
            this.boardResetVoteDia = new ResetBoardVoteDialog(this.mainDisplay, this, requester, gaOver);
            EventQueue.invokeLater(this.boardResetVoteDia);
        }
    }

    private void resetBoardClearDia() {
        this.boardResetVoteDia = null;
    }

    public void printTradeResources(SOCPlayer plFrom, SOCResourceSet give, SOCResourceSet get, boolean isOffer, SOCPlayer plTo) {
        String plName = plFrom.getName();
        if (isOffer) {
            if (this.client.getServerVersion(this.game) >= 2000) {
                this.printKeyedSpecial("trade.offered.rsrcs.for", plName, give, get);
            }
        } else if (plTo != null) {
            if (this.client.getServerVersion(this.game) >= 2000) {
                this.printKeyedSpecial("trade.gave.rsrcs.for.from.player", plName, give, get, plTo.getName());
            }
            if (this.clientHand != null && (this.clientHandPlayerNum == plFrom.getPlayerNumber() || this.clientHandPlayerNum == plTo.getPlayerNumber())) {
                this.gameStats.resourceTraded();
            }
        } else {
            int tradeFrom;
            String msgKey;
            int getTotal;
            int giveTotal = give.getTotal();
            if (giveTotal > (getTotal = get.getTotal())) {
                msgKey = "trade.traded.rsrcs.for.from.bankport";
                tradeFrom = giveTotal / getTotal == 4 ? 1 : 2;
            } else {
                msgKey = "trade.traded.rsrcs.for.from.bankport.undoprevious";
                tradeFrom = getTotal / giveTotal == 4 ? 1 : 2;
            }
            this.printKeyedSpecial(msgKey, plName, give, get, tradeFrom);
            if (this.clientHand != null) {
                this.clientHand.enableBankUndoButton();
                if (this.clientHandPlayerNum == plFrom.getPlayerNumber()) {
                    this.gameStats.resourceTraded();
                }
            }
        }
    }

    public void printKeyed(String key) throws MissingResourceException {
        this.textDisplay.append("* " + strings.get(key) + "\n");
    }

    public void printKeyed(String key, Object ... params) throws MissingResourceException {
        this.textDisplay.append("* " + strings.get(key, params) + "\n");
    }

    public void printKeyedSpecial(String key, Object ... params) throws MissingResourceException, IllegalArgumentException {
        this.textDisplay.append("* " + strings.getSpecial(this.game, key, params) + "\n");
    }

    public void print(String s) {
        this.print(s, false);
    }

    public void print(String s, boolean addStarPrefix) {
        if (addStarPrefix && s.charAt(0) != '*') {
            s = "* " + s;
        }
        StringTokenizer st = new StringTokenizer(s, "\n", false);
        while (st.hasMoreElements()) {
            String tk = st.nextToken().trim();
            this.textDisplay.append(tk + "\n");
        }
    }

    public void chatPrint(String s) {
        StringTokenizer st = new StringTokenizer(s, "\n", false);
        while (st.hasMoreElements()) {
            String tk = st.nextToken().trim();
            this.chatDisplay.append(tk + "\n");
        }
    }

    public void playSound(Clip c) {
        if (c != null) {
            soundQueueThreader.submit(new PIPlaySound(c));
        }
    }

    public void gameDisconnected(boolean wasDeleted, String errorMessage) {
        this.gameHasErrorOrDeletion = true;
        if (this.textInputIsInitial) {
            this.textInputSetToInitialPrompt(false);
        }
        this.textInput.setEditable(false);
        if (errorMessage != null) {
            this.textInput.setText(errorMessage);
        }
        if (wasDeleted) {
            this.textDisplay.append("*** " + strings.get("interface.error.game.has_been_deleted") + " ***\n");
        } else {
            this.textDisplay.append("* " + strings.get("interface.error.lost.conn") + "\n");
            this.textDisplay.append("*** " + strings.get("interface.error.game.stopped") + " ***\n");
        }
        this.boardPanel.repaint();
        for (int i = 0; i < this.game.maxPlayers; ++i) {
            this.hands[i].gameDisconnected();
        }
    }

    public void began(List<String> members) {
        this.textInput.setText("");
        this.textInputSetToInitialPrompt(true);
        this.hasCalledBegan = true;
        if (members == null) {
            return;
        }
        ArrayList<String> obs = null;
        for (int i = members.size() - 1; i >= 0; --i) {
            String mname = members.get(i);
            if (null != this.game.getPlayer(mname) || mname.equals(this.getClientNickname())) continue;
            if (obs == null) {
                obs = new ArrayList<String>();
            }
            obs.add(mname);
        }
        if (obs != null) {
            String obsTxt = obs.size() == 1 ? strings.get("interface.observer.enter.one", obs.get(0)) : strings.getSpecial(this.game, "interface.observer.enter.many", obs);
            this.print(obsTxt, true);
        }
    }

    public void addPlayer(String name, int pn) {
        this.hands[pn].addPlayer(name);
        boolean sitterIsClientPlayer = name.equals(this.getClientNickname());
        if (sitterIsClientPlayer) {
            if (this.game.getGameState() >= 5) {
                this.clientPlayerIsSitting = true;
            }
            for (int i = 0; i < this.game.maxPlayers; ++i) {
                if (!this.game.getPlayer(i).isRobot()) continue;
                this.hands[i].addSittingRobotLockBut();
            }
            if (this.is6player) {
                this.getContentPane().revalidate();
                this.repaint(this.hands[pn].getX(), 0, this.hands[pn].getWidth(), this.getHeight());
            }
            this.addHotkeysInputMap();
        }
        if (this.game.isGameOptionDefined("PL")) {
            this.updatePlayerLimitDisplay(true, false, -1);
        }
        if (this.game.isBoardReset()) {
            this.hands[pn].changeFace(this.hands[pn].getPlayer().getFaceId());
        }
        if (sitterIsClientPlayer) {
            this.boardPanel.setPlayer();
            this.buildingPanel.setPlayer();
        }
        if (this.is6player) {
            this.buildingPanel.updatePlayerCount();
        }
        SOCHandPanel hp = this.getPlayerHandPanel(pn);
        hp.updateValue(PlayerClientListener.UpdateType.Road);
        hp.updateValue(PlayerClientListener.UpdateType.Settlement);
        hp.updateValue(PlayerClientListener.UpdateType.City);
        if (this.game.hasSeaBoard) {
            hp.updateValue(PlayerClientListener.UpdateType.Ship);
        }
        hp.updateValue(PlayerClientListener.UpdateType.Knight);
        hp.updateValue(PlayerClientListener.UpdateType.VictoryPoints);
        hp.updateValue(PlayerClientListener.UpdateType.LongestRoad);
        hp.updateValue(PlayerClientListener.UpdateType.LargestArmy);
        if (sitterIsClientPlayer) {
            hp.updateValue(PlayerClientListener.UpdateType.ResourceTotalAndDetails);
            hp.updateDevCards(false);
        } else {
            hp.updateValue(PlayerClientListener.UpdateType.Resources);
            hp.updateValue(PlayerClientListener.UpdateType.DevCards);
        }
    }

    public void removePlayer(int pn) {
        this.hands[pn].removePlayer();
        if (this.game.isGameOptionDefined("PL")) {
            this.updatePlayerLimitDisplay(true, false, pn);
        } else {
            this.hands[pn].addSitButton(this.clientHand != null);
        }
        if (this.is6player) {
            this.buildingPanel.updatePlayerCount();
            if (this.clientHand == null) {
                this.getContentPane().revalidate();
                this.repaint();
            }
        }
    }

    public boolean isNonBlockingDialogVisible() {
        return this.nbdForEvent != null && this.nbdForEvent.isVisible();
    }

    public void startGame() {
        for (int i = 0; i < this.hands.length; ++i) {
            this.hands[i].removeStartBut();
            this.hands[i].removeSitLockoutBut();
        }
        this.updatePlayerLimitDisplay(false, true, -1);
        this.gameIsStarting = true;
    }

    public void updateAtOver(int[] finalScores) {
        int pn;
        if (this.game.getGameState() != 1000) {
            System.err.println("L1264: pi.updateAtOver called at state " + this.game.getGameState());
            return;
        }
        for (pn = 0; pn < finalScores.length; ++pn) {
            this.game.getPlayer(pn).forceFinalVP(finalScores[pn]);
        }
        if (null == this.game.getPlayerWithWin()) {
            this.game.checkForWinner();
        }
        for (pn = 0; pn < finalScores.length; ++pn) {
            this.hands[pn].updateValue(PlayerClientListener.UpdateType.VictoryPoints);
        }
        for (pn = 0; pn < finalScores.length; ++pn) {
            SOCPlayer pl = this.game.getPlayer(pn);
            List<SOCInventoryItem> vpCards = pl.getInventory().getByState(3);
            if (vpCards.isEmpty()) continue;
            this.printKeyedSpecial("game.end.player.has.vpcards", pl.getName(), vpCards);
        }
        this.setTitle(strings.get("interface.title.game.over", this.game.getName()) + (this.game.isPractice ? "" : " [" + this.getClientNickname() + "]"));
        this.boardPanel.updateMode();
        this.repaint();
    }

    public void updateAtTurn(int pnum) {
        if (pnum >= 0 && pnum < this.hands.length) {
            this.getPlayerHandPanel(pnum).updateDevCards(false);
        }
        for (int i = 0; i < this.hands.length; ++i) {
            this.getPlayerHandPanel(i).updateAtTurn();
        }
        this.boardPanel.updateMode();
        this.boardPanel.repaint();
        if (this.textInputGreyCountdown > 0) {
            --this.textInputGreyCountdown;
            if (this.textInputGreyCountdown == 0 && this.textInputIsInitial && !SwingMainDisplay.isOSColorHighContrast()) {
                this.textInput.setForeground(Color.LIGHT_GRAY);
            }
        }
        this.buildingPanel.updateButtonStatus();
        this.bankTradeWasFromTradePanel = false;
        if (this.game.getGameState() == 100 && this.client.getServerVersion(this.game) >= 2500) {
            this.printKeyed("action.sbp.turn.to.place.common", this.game.getPlayer(this.game.getCurrentPlayerNumber()).getName());
        }
        if (this.isClientCurrentPlayer()) {
            this.playSound(SOUND_BEGIN_TURN);
        }
    }

    public void updateAtRollPrompt(int pn) {
        if (this.client.getServerVersion(this.game) >= 2000 && !this.game.isInitialPlacement()) {
            this.printKeyed("game.prompt.turn_to_roll_dice", this.game.getPlayer(pn).getName());
        }
        if (this.isClientCurrentPlayer() && !this.clientListener.isNonBlockingDialogVisible()) {
            this.getClientHand().autoRollOrPromptPlayer();
        }
    }

    private void showDeclinedPlayerRequest(int reasonCode, int detailValue1, int detailValue2, String reasonText) {
        String reasonTextKey;
        if (reasonText != null) {
            this.print(reasonText, true);
            return;
        }
        switch (reasonCode) {
            case 1: {
                reasonTextKey = "reply.common.cannot.in_this_game";
                break;
            }
            case 2: {
                reasonTextKey = "base.reply.not.your.turn";
                break;
            }
            case 4: {
                reasonTextKey = "reply.common.cannot.at_that_location";
                break;
            }
            default: {
                reasonTextKey = "reply.common.cannot.right_now";
            }
        }
        this.printKeyed(reasonTextKey);
    }

    public void updateAtClientPlayerResources() {
        for (int i = 0; i < this.hands.length; ++i) {
            if (i == this.clientHandPlayerNum) continue;
            this.hands[i].updateCurrentOffer(false, true);
        }
        this.buildingPanel.updateButtonStatus();
    }

    public void updateAtSVPText(String plName, int svp, String desc) {
        String svpKey = svp == 1 ? "game.SVP.get.one" : "game.SVP.get.many";
        this.printKeyed(svpKey, plName, svp, desc);
    }

    public void clearChatTextInput() {
        this.textInput.setText("");
        this.textInputIsInitial = false;
    }

    protected void textInputSetToInitialPrompt(boolean setToInitial) {
        if (setToInitial && this.textInputHasSent) {
            return;
        }
        boolean isOSHighContrast = SwingMainDisplay.isOSColorHighContrast();
        if (setToInitial) {
            if (this.textInput.getText().trim().length() == 0) {
                this.textInput.setText(TEXTINPUT_INITIAL_PROMPT_MSG);
                this.textInput.setCaretPosition(0);
            }
            this.textInputIsInitial = true;
            this.textInputGreyCountdown = textInputGreyCountFrom;
            if (!isOSHighContrast) {
                this.textInput.setForeground(Color.DARK_GRAY);
            }
        } else {
            if (this.textInput.getText().equals(TEXTINPUT_INITIAL_PROMPT_MSG)) {
                this.textInput.setText("");
            }
            this.textInputIsInitial = false;
            if (!isOSHighContrast) {
                this.textInput.setForeground(Color.BLACK);
            }
        }
    }

    public void showDiscardOrGainDialog(int nd, boolean isDiscard) {
        boolean withCancel = !isDiscard && this.game.getGameState() == 52 && this.client.getServerVersion(this.game) >= 2700;
        this.discardOrGainDialog = new SOCDiscardOrGainResDialog(this, nd, isDiscard, withCancel);
        EventQueue.invokeLater(this.discardOrGainDialog);
    }

    public void reportDiscard(SOCPlayer player, ResourceSet discards) {
        int pn = player.getPlayerNumber();
        this.hands[pn].updateValue(PlayerClientListener.UpdateType.ResourceTotalAndDetails);
        if (this.isGameFullyObservable || discards.getAmount(6) == 0) {
            this.printKeyedSpecial(pn != this.clientHandPlayerNum ? "action.discarded.rsrcs" : "action.discarded.rsrcs.you", player.getName(), discards);
        } else {
            this.printKeyedSpecial("action.discarded.total.common", player.getName(), discards.getTotal());
        }
    }

    public void showChoosePlayerDialog(int count, int[] pnums, boolean allowChooseNone) {
        this.choosePlayerDialog = new SOCChoosePlayerDialog(this, count, pnums, allowChooseNone);
        EventQueue.invokeLater(this.choosePlayerDialog);
    }

    public void showChooseRobClothOrResourceDialog(int vpn) {
        EventQueue.invokeLater(new ChooseRobClothOrResourceDialog(vpn));
    }

    public void showMonopolyDialog() {
        this.monopolyDialog = new SOCMonopolyDialog(this, this.client.getServerVersion(this.game) >= 2700);
        EventQueue.invokeLater(this.monopolyDialog);
    }

    public void showScenarioInfoDialog() {
        NewGameOptionsFrame.showScenarioInfoDialog(this.game, (this.game.isPractice ? this.client.practiceServGameOpts : this.client.tcpServGameOpts).knownOpts, this.getMainDisplay(), this);
    }

    public void reportRobberyResult(int perpPN, int victimPN, int resType, SOCResourceSet resSet, SOCPlayerElement.PEType peType, boolean isGainLose, int amount, int victimAmount, int extraValue) {
        String viName;
        String peName = perpPN >= 0 ? this.game.getPlayer(perpPN).getName() : null;
        String string = viName = victimPN >= 0 ? this.game.getPlayer(victimPN).getName() : null;
        if (perpPN == -1 && this.game.isGameOptionSet("_SC_PIRI")) {
            if (victimPN < 0) {
                return;
            }
            if (amount > 0 || resSet != null) {
                if (victimPN == this.clientHandPlayerNum) {
                    if (resSet == null) {
                        resSet = new SOCResourceSet();
                        resSet.add(amount, resType);
                    }
                    this.printKeyedSpecial("action.rolled.sc_piri.you.lost.rsrcs.to.fleet", resSet, extraValue);
                    this.playSound(SOUND_RSRC_LOST);
                } else {
                    this.printKeyed("action.rolled.sc_piri.player.lost.rsrcs.to.fleet", viName, resSet != null ? resSet.getTotal() : amount, extraValue);
                }
            } else if (amount == 0) {
                this.printKeyed(resType == 6 ? "action.rolled.sc_piri.player.won.pick.free" : "action.rolled.sc_piri.player.tied", viName, extraValue);
            }
            this.hands[victimPN].updateValue(PlayerClientListener.UpdateType.ResourceTotalAndDetails);
        } else if (peType == null) {
            if (resType == 6 || this.clientHandPlayerNum < 0 || this.clientHandPlayerNum != perpPN && this.clientHandPlayerNum != victimPN) {
                if (this.isGameFullyObservable) {
                    this.printKeyedSpecial("robber.stole.resource.from.play_fo", peName, viName, amount != 1 ? amount : -1, resType);
                } else if (amount == 1) {
                    this.printKeyed("robber.common.stole.resource.from", peName, viName);
                } else {
                    this.printKeyed("robber.common.stole.resource.from.n", peName, viName, amount);
                }
            } else if (perpPN == this.clientHandPlayerNum) {
                this.printKeyedSpecial("robber.common.you.stole.resource.from", amount != 1 ? amount : -1, resType, viName);
            } else {
                this.printKeyedSpecial("robber.common.stole.resource.from.you", peName, amount != 1 ? amount : -1, resType);
            }
            if (perpPN >= 0) {
                this.hands[perpPN].updateValue(PlayerClientListener.UpdateType.ResourceTotalAndDetails);
            }
            if (victimPN >= 0) {
                this.hands[victimPN].updateValue(PlayerClientListener.UpdateType.ResourceTotalAndDetails);
                if (victimPN == this.clientHandPlayerNum) {
                    this.playSound(SOUND_RSRC_LOST);
                }
            }
        } else {
            PlayerClientListener.UpdateType utype = null;
            switch (peType) {
                case SCENARIO_CLOTH_COUNT: {
                    this.printKeyed("robber.common.stole.cloth.from", peName, viName);
                    utype = PlayerClientListener.UpdateType.Cloth;
                    break;
                }
            }
            if (utype != null) {
                if (perpPN >= 0) {
                    this.clientListener.playerElementUpdated(this.game.getPlayer(perpPN), utype, false, false);
                }
                if (victimPN >= 0) {
                    this.clientListener.playerElementUpdated(this.game.getPlayer(victimPN), utype, false, victimPN == this.clientHandPlayerNum);
                }
            }
        }
    }

    public void updateAtNewBoard() {
        this.boardPanel.flushBoardLayoutAndRepaint();
        if (this.game.isGameOptionSet("_SC_CLVI")) {
            this.buildingPanel.updateClothCount();
        }
    }

    public void updateAtGameState(boolean isForDecline) {
        int gs = this.game.getGameState();
        if (!this.knowsGameState) {
            this.knowsGameState = true;
            if (this.clientHand == null) {
                for (int i = 0; i < this.game.maxPlayers; ++i) {
                    if (!this.game.isSeatVacant(i)) continue;
                    if (gs < 10) {
                        this.hands[i].addSitButton(false);
                        continue;
                    }
                    this.hands[i].removeSitBut();
                }
            }
        }
        if (this.gameIsStarting && gs >= 15) {
            this.gameIsStarting = false;
            for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                this.hands[pn].updateAtTurn();
            }
        }
        this.buildingPanel.updateButtonStatus();
        this.boardPanel.updateMode();
        this.boardPanel.repaint();
        if ((gs == 30 || gs == 31 || gs == 32 || gs == 35) && this.boardPanel.popupExpectingBuildRequest()) {
            this.boardPanel.popupFireBuildingRequest();
        }
        if (gs == 42 && this.isClientCurrentPlayer() && this.game.isGameOptionSet("_SC_FTRI")) {
            this.printKeyed("game.invitem.sc_ftri.prompt");
        }
        if (gs == 50) {
            if (!this.showingPlayerDiscardOrPick) {
                this.discardOrPickTimerSet(true);
            }
        } else if (gs == 56 || gs == 14) {
            if (!this.showingPlayerDiscardOrPick) {
                this.discardOrPickTimerSet(false);
            }
        } else if (this.showingPlayerDiscardOrPick) {
            this.discardOrPickTimerClear();
        }
        if (this.clientPlayerIsSitting) {
            this.clientPlayerIsSitting = false;
        }
        if (this.clientHand == null || this.clientHandPlayerNum != this.game.getCurrentPlayerNumber()) {
            return;
        }
        switch (gs) {
            case 52: {
                this.showDiscardOrGainDialog(2, false);
                break;
            }
            case 53: {
                this.showMonopolyDialog();
                break;
            }
            case 54: {
                EventQueue.invokeLater(new ChooseMoveRobberOrPirateDialog(this.game.isPlacingRobberForKnightCard() && this.client.getServerVersion(this.game) >= 2700));
                break;
            }
            default: {
                this.clientHand.updateAtOurGameState();
            }
        }
    }

    public void updateAtPiecesChanged() {
        this.boardPanel.repaint();
    }

    public void updateAtPutPiece(int mesPn, int coord, int pieceType, boolean isMove, int moveToCoord) {
        SOCPlayer newLongestRoadPlayer;
        SOCPlayer pl = pieceType != 5 ? this.game.getPlayer(mesPn) : null;
        SOCPlayer oldLongestRoadPlayer = this.game.getPlayerWithLongestRoad();
        SOCHandPanel mesHp = pieceType != 5 ? this.getPlayerHandPanel(mesPn) : null;
        boolean[] debugShowPotentials = this.boardPanel.debugShowPotentials;
        switch (pieceType) {
            case 0: {
                SOCRoad pp = new SOCRoad(pl, coord, null);
                this.game.putPiece(pp);
                mesHp.updateValue(PlayerClientListener.UpdateType.Road);
                this.boardPanel.setLatestPiecePlacement(pp);
                if (!debugShowPotentials[4] && !debugShowPotentials[5] && !debugShowPotentials[7]) break;
                this.boardPanel.flushBoardLayoutAndRepaint();
                break;
            }
            case 1: {
                SOCSettlement pp = new SOCSettlement(pl, coord, null);
                this.game.putPiece(pp);
                mesHp.updateValue(PlayerClientListener.UpdateType.Settlement);
                mesHp.updateValue(PlayerClientListener.UpdateType.ResourceTotalAndDetails);
                this.boardPanel.setLatestPiecePlacement(pp);
                if (!debugShowPotentials[4] && !debugShowPotentials[5] && !debugShowPotentials[7] && !debugShowPotentials[6]) break;
                this.boardPanel.flushBoardLayoutAndRepaint();
                break;
            }
            case 2: {
                SOCCity pp = new SOCCity(pl, coord, null);
                this.game.putPiece(pp);
                mesHp.updateValue(PlayerClientListener.UpdateType.Settlement);
                mesHp.updateValue(PlayerClientListener.UpdateType.City);
                this.boardPanel.setLatestPiecePlacement(pp);
                if (!debugShowPotentials[4] && !debugShowPotentials[5] && !debugShowPotentials[7] && !debugShowPotentials[6]) break;
                this.boardPanel.flushBoardLayoutAndRepaint();
                break;
            }
            case 3: {
                SOCShip pp = new SOCShip(pl, coord, null);
                if (!isMove) {
                    this.game.putPiece(pp);
                    this.boardPanel.setLatestPiecePlacement(pp);
                    mesHp.updateValue(PlayerClientListener.UpdateType.Ship);
                } else {
                    this.game.moveShip(pp, moveToCoord);
                    this.boardPanel.setLatestPiecePlacement(this.game.getBoard().roadOrShipAtEdge(moveToCoord));
                    if (mesHp == this.clientHand) {
                        mesHp.disableBankUndoButton();
                    }
                }
                if (!debugShowPotentials[4] && !debugShowPotentials[5] && !debugShowPotentials[7]) break;
                this.boardPanel.flushBoardLayoutAndRepaint();
                break;
            }
            case 5: {
                SOCVillage pp = new SOCVillage(coord, this.game.getBoard());
                this.game.putPiece(pp);
                return;
            }
            case 4: {
                SOCFortress pp = new SOCFortress(pl, coord, this.game.getBoard());
                this.game.putPiece(pp);
                return;
            }
            default: {
                this.chatPrintDebug("* Unknown piece type " + pieceType + " at coord 0x" + Integer.toHexString(coord));
                return;
            }
        }
        mesHp.updateValue(PlayerClientListener.UpdateType.VictoryPoints);
        this.boardPanel.repaint();
        this.buildingPanel.updateButtonStatus();
        if (this.game.isDebugFreePlacement() && this.game.isInitialPlacement()) {
            this.boardPanel.updateMode();
        }
        if (this.hasCalledBegan && this.game.getGameState() >= 5) {
            this.playSound(SOUND_PUT_PIECE);
        }
        if ((newLongestRoadPlayer = this.game.getPlayerWithLongestRoad()) != oldLongestRoadPlayer) {
            this.updateLongestLargest(true, oldLongestRoadPlayer, newLongestRoadPlayer);
        }
    }

    public void updateAtPieceRemoved(SOCPlayer player, int pieceCoordinate, int pieceType) {
        switch (pieceType) {
            case 3: {
                this.game.removeShip(new SOCShip(player, pieceCoordinate, null));
                this.boardPanel.setLatestPiecePlacement(null);
                this.updateAtPiecesChanged();
                break;
            }
            default: {
                System.err.println("PI.updateAtPieceRemoved called for un-handled type " + pieceType);
            }
        }
    }

    public void updateAtUndoPutPiece(SOCPlayer player, int coordinate, int movedFromCoordinate, int pieceType) {
        this.boardPanel.setLatestPiecePlacement(null);
        this.updateAtPiecesChanged();
        SOCHandPanel hpan = this.getPlayerHandPanel(player.getPlayerNumber());
        if (hpan != null) {
            hpan.updateResourcesVP();
            hpan.updateValue(PlayerClientListener.UpdateType.UndosRemaining);
            if (movedFromCoordinate == 0) {
                switch (pieceType) {
                    case 0: {
                        hpan.updateValue(PlayerClientListener.UpdateType.Road);
                        break;
                    }
                    case 2: {
                        hpan.updateValue(PlayerClientListener.UpdateType.City);
                    }
                    case 1: {
                        hpan.updateValue(PlayerClientListener.UpdateType.Settlement);
                        break;
                    }
                    case 3: {
                        hpan.updateValue(PlayerClientListener.UpdateType.Ship);
                    }
                }
            }
        }
        String plName = player.getName();
        String aPieceType = "a " + SOCPlayingPiece.getTypeName(pieceType);
        if (movedFromCoordinate != 0) {
            this.print(plName + " has undone moving " + aPieceType, true);
        } else {
            this.print(plName + " has undone building " + aPieceType, true);
        }
    }

    public void updateAtWarshipsChanged(boolean isGain) {
        this.boardPanel.updateAtWarshipsChanged(isGain);
    }

    public void updateAtRobberMoved(int newHex, boolean isPirate) {
        this.boardPanel.repaint();
    }

    @Override
    public void gameEvent(SOCGame ga, SOCGameEvent evt, Object detail) {
        switch (evt) {
            case SGE_STARTPLAY_BOARD_SPECIAL_NODES_EMPTIED: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SOCPlayerInterface.this.boardPanel.flushBoardLayoutAndRepaint();
                    }
                });
                break;
            }
        }
    }

    @Override
    public void playerEvent(SOCGame ga, SOCPlayer pl, SOCPlayerEvent evt, boolean flagsChanged, Object obj) {
        SOCHandPanel mesHp = this.getPlayerHandPanel(pl.getPlayerNumber());
        if (mesHp == null) {
            return;
        }
        if (flagsChanged && pl.getSpecialVP() != 0) {
            mesHp.updateValue(PlayerClientListener.UpdateType.SpecialVictoryPoints);
            mesHp.updateValue(PlayerClientListener.UpdateType.VictoryPoints);
        }
    }

    @Override
    public void dialogDismissed(Object srcDialog, boolean wasCanceled) {
        if (this.nbdForEvent == srcDialog) {
            this.nbdForEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardOrPickTimerSet(boolean isDiscard) {
        Object object = this.showingPlayerDiscardOrPick_lock;
        synchronized (object) {
            if (this.showingPlayerDiscardOrPick_task != null) {
                this.showingPlayerDiscardOrPick_task.cancel();
            }
            this.showingPlayerDiscardOrPick_task = new SOCPIDiscardOrPickMsgTask(this, isDiscard);
            this.mainDisplay.getEventTimer().schedule((TimerTask)this.showingPlayerDiscardOrPick_task, 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardOrPickTimerClear() {
        Object object = this.showingPlayerDiscardOrPick_lock;
        synchronized (object) {
            if (this.showingPlayerDiscardOrPick_task != null) {
                this.showingPlayerDiscardOrPick_task.cancel();
                this.showingPlayerDiscardOrPick_task = null;
            }
            if (this.showingPlayerDiscardOrPick) {
                for (int i = this.hands.length - 1; i >= 0; --i) {
                    this.hands[i].clearDiscardOrPickMsg();
                }
                this.showingPlayerDiscardOrPick = false;
            }
        }
    }

    public void resetBoard(SOCGame newGame, int rejoinPlayerNumber, int requesterNumber) {
        if (this.clientHand == null) {
            return;
        }
        if (rejoinPlayerNumber != -1 && rejoinPlayerNumber != this.clientHandPlayerNum) {
            return;
        }
        if (newGame == null) {
            throw new IllegalArgumentException("newGame is null");
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int oldGameState = this.game.getOldGameState();
        this.game = newGame;
        boolean bl = this.knowsGameState = this.game.getGameState() != 0;
        if (this.gameStats != null) {
            this.gameStats.dispose();
        }
        this.gameStats = new SOCGameStatistics(this.game);
        for (int i = 0; i < this.hands.length; ++i) {
            this.hands[i].removePlayer();
            this.hands[i].setEnabled(false);
            this.hands[i].destroy();
        }
        String prevChatText = this.chatDisplay.getText();
        boolean[] boardDebugShow = (boolean[])this.boardPanel.debugShowPotentials.clone();
        this.clientHand = null;
        this.clientHandPlayerNum = -1;
        this.getContentPane().removeAll();
        this.initUIElements(false);
        this.setTitle(strings.get("interface.title.game", this.game.getName()) + (this.game.isPractice ? "" : " [" + this.getClientNickname() + "]"));
        this.boardPanel.debugShowPotentials = boardDebugShow;
        this.getContentPane().revalidate();
        this.repaint();
        this.chatDisplay.append(prevChatText);
        String requesterName = this.game.getPlayer(requesterNumber).getName();
        if (requesterName == null) {
            requesterName = strings.get("reset.player.who.left");
        }
        String resetMsg = "** " + strings.get(oldGameState != 1000 ? "reset.board.was.reset" : "reset.new.game.started", requesterName) + "\n";
        this.textDisplay.append(resetMsg);
        this.chatDisplay.append(resetMsg);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void changeFace(int pn, int id) {
        this.hands[pn].changeFace(id);
    }

    public void chatPrintDebug(String debugMsg) {
        if (!D.ebugIsEnabled()) {
            return;
        }
        this.chatPrint(debugMsg + "\n");
    }

    public void chatPrintStackTrace(Throwable th) {
        this.chatPrintStackTrace(th, false);
    }

    private void chatPrintStackTrace(Throwable th, boolean isNested) {
        if (!D.ebugIsEnabled()) {
            return;
        }
        String excepName = th.getClass().getName();
        if (!isNested) {
            this.chatDisplay.append("** Exception occurred **\n");
        }
        if (th.getMessage() != null) {
            this.chatPrint(excepName + ": " + th.getMessage());
        } else {
            this.chatPrint(excepName);
        }
        StringWriter backstack = new StringWriter();
        PrintWriter pw = new PrintWriter(backstack);
        th.printStackTrace(pw);
        pw.flush();
        this.chatPrint(backstack.getBuffer().toString());
        Throwable cause = th.getCause();
        if (cause != null && cause != th) {
            this.chatDisplay.append("** --> Nested Cause Exception: **\n");
            this.chatPrintStackTrace(cause, true);
        }
        if (!isNested) {
            this.chatDisplay.append("-- Exception ends: " + excepName + " --\n\n");
        }
    }

    public static Color makeGhostColor(Color srcColor) {
        int outB;
        int outG;
        int outR = srcColor.getRed();
        if (outR + (outG = srcColor.getGreen()) + (outB = srcColor.getBlue()) > 480) {
            outR = (outR + 140) / 2;
            outG = (outG + 140) / 2;
            outB = (outB + 140) / 2;
        } else {
            outR = (outR + 255) / 2;
            outG = (outG + 255) / 2;
            outB = (outB + 255) / 2;
        }
        return new Color(outR, outG, outB);
    }

    private void textDisplaysLargerSetResizeTimer() {
        this.getEventTimer().schedule((TimerTask)new SOCPITextDisplaysLargerTask(), 200L);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.is6player) {
            return;
        }
        Object src = e.getSource();
        if (src == this.textDisplay) {
            this.textDisplayHasMouse = true;
        } else if (src == this.chatDisplay) {
            this.chatDisplayHasMouse = true;
        } else if (src == this.textInput) {
            this.textInputHasMouse = true;
        } else if (this.textDisplaysLargerTemp) {
            if (src == this.boardPanel) {
                this.sbFixBHasMouse = true;
            } else if (src == this.hands[0]) {
                this.sbFixLHasMouse = true;
            } else if (src == this.hands[1]) {
                this.sbFixRHasMouse = true;
            }
        } else {
            return;
        }
        this.textDisplaysLargerSetResizeTimer();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.is6player) {
            return;
        }
        Object src = e.getSource();
        if (src == this.textDisplay) {
            this.textDisplayHasMouse = false;
        } else if (src == this.chatDisplay) {
            this.chatDisplayHasMouse = false;
        } else if (src == this.textInput) {
            this.textInputHasMouse = false;
        } else if (src == this) {
            this.textDisplayHasMouse = false;
            this.chatDisplayHasMouse = false;
            this.textInputHasMouse = false;
        } else {
            if (this.sbFixNeeded) {
                if (src == this.boardPanel) {
                    this.sbFixBHasMouse = false;
                } else if (src == this.hands[0]) {
                    this.sbFixLHasMouse = false;
                } else if (src == this.hands[1]) {
                    this.sbFixRHasMouse = false;
                }
                return;
            }
            return;
        }
        this.textDisplaysLargerSetResizeTimer();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.is6player) {
            return;
        }
        Object src = e.getSource();
        if (src != this.textDisplay && src != this.chatDisplay) {
            return;
        }
        long when = e.getWhen();
        if (this.textDisplaysLargerWhen == 0L || Math.abs(when - this.textDisplaysLargerWhen) < 1000L) {
            this.textInput.requestFocusInWindow();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    protected boolean isClientPlayer(SOCPlayer p) {
        if (p == null) {
            return false;
        }
        int pn = p.getPlayerNumber();
        return this.hands[pn].isClientPlayer();
    }

    static {
        soundQueueThreader = Executors.newSingleThreadExecutor();
    }

    private class PIPlaySound
    implements Runnable {
        private final Clip c;

        public PIPlaySound(Clip c) throws IllegalArgumentException {
            if (c == null) {
                throw new IllegalArgumentException("PIPlaySound");
            }
            this.c = c;
        }

        @Override
        public void run() {
            if (SOCPlayerInterface.this.soundMuted || !UserPreferences.getPref("soundOn", true)) {
                return;
            }
            try {
                this.c.setFramePosition(0);
                this.c.start();
                Thread.sleep(this.c.getMicrosecondLength() / 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class SOCPITextDisplaysLargerTask
    extends TimerTask {
        private SOCPITextDisplaysLargerTask() {
        }

        @Override
        public void run() {
            boolean wantsLarger;
            boolean leftLarger = SOCPlayerInterface.this.sbFixNeeded && (SOCPlayerInterface.this.sbFixLHasMouse || SOCPlayerInterface.this.sbFixRHasMouse || SOCPlayerInterface.this.sbFixBHasMouse);
            boolean bl = wantsLarger = SOCPlayerInterface.this.textDisplayHasMouse || SOCPlayerInterface.this.chatDisplayHasMouse || SOCPlayerInterface.this.textInputHasMouse || SOCPlayerInterface.this.sbFixNeeded && SOCPlayerInterface.this.textDisplaysLargerTemp && !leftLarger;
            if (SOCPlayerInterface.this.textDisplaysLargerTemp != wantsLarger) {
                SOCPlayerInterface.this.textDisplaysLargerTemp = wantsLarger;
                SOCPlayerInterface.this.textDisplaysLargerTemp_needsLayout = true;
                if (!wantsLarger) {
                    SOCPlayerInterface.this.textDisplaysLargerWhen = 0L;
                } else {
                    SOCPlayerInterface.this.textDisplaysLargerWhen = System.currentTimeMillis();
                }
                SOCPlayerInterface.this.getContentPane().revalidate();
                SOCPlayerInterface.this.repaint();
            }
        }
    }

    private static class SOCPIDiscardOrPickMsgTask
    extends TimerTask {
        private SOCPlayerInterface pi;
        private final boolean isDiscard;

        public SOCPIDiscardOrPickMsgTask(SOCPlayerInterface spi, boolean forDiscard) {
            this.pi = spi;
            this.isDiscard = forDiscard;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int needState = this.isDiscard ? 50 : (this.pi.game.isInitialPlacement() ? 14 : 56);
            int clientPN = this.pi.clientHandPlayerNum;
            boolean anyShowing = false;
            Object object = this.pi.showingPlayerDiscardOrPick_lock;
            synchronized (object) {
                if (this.pi.game.getGameState() != needState) {
                    return;
                }
                for (int i = this.pi.hands.length - 1; i >= 0; --i) {
                    if (i == clientPN) continue;
                    SOCHandPanel hp = this.pi.hands[i];
                    if (this.isDiscard) {
                        if (7 >= hp.getPlayer().getResources().getTotal() || !hp.setDiscardOrPickMsg(true)) continue;
                        anyShowing = true;
                        continue;
                    }
                    if (hp.getPlayer().getNeedToPickGoldHexResources() <= 0 || !hp.setDiscardOrPickMsg(false)) continue;
                    anyShowing = true;
                }
                this.pi.showingPlayerDiscardOrPick = anyShowing;
                this.pi.showingPlayerDiscardOrPick_task = null;
            }
        }
    }

    private class PIHotkeyActionListener
    extends AbstractAction {
        public static final int ACCEPT = 1;
        public static final int REJECT = 2;
        public static final int COUNTER = 3;
        public static final int ASK_SPECIAL_BUILD = 4;
        public final int forButton;
        public final boolean isForTrade;

        public PIHotkeyActionListener(int forButton) {
            this.forButton = forButton;
            this.isForTrade = forButton != 4;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isForTrade) {
                switch (this.forButton) {
                    case 4: {
                        SOCPlayerInterface.this.buildingPanel.clickBuildingButton(SOCPlayerInterface.this.game, "sbp", false);
                    }
                }
                return;
            }
            SOCHandPanel hpo = null;
            for (int pn = 0; pn < SOCPlayerInterface.this.game.maxPlayers; ++pn) {
                SOCHandPanel hp = SOCPlayerInterface.this.hands[pn];
                if (!hp.isShowingOfferToClientPlayer()) continue;
                if (hpo != null) {
                    return;
                }
                hpo = hp;
            }
            if (hpo == null) {
                return;
            }
            switch (this.forButton) {
                case 1: {
                    hpo.clickOfferAcceptButton();
                    break;
                }
                case 2: {
                    hpo.clickOfferRejectButton();
                    break;
                }
                case 3: {
                    hpo.clickOfferCounterButton();
                }
            }
        }
    }

    private static class SOCPITextfieldListener
    extends KeyAdapter
    implements DocumentListener,
    FocusListener {
        private final SOCPlayerInterface pi;

        public SOCPITextfieldListener(SOCPlayerInterface spi) throws IllegalArgumentException {
            if (spi == null) {
                throw new IllegalArgumentException("spi");
            }
            this.pi = spi;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 38: {
                    int S = this.pi.textInputHistory.size();
                    if (S <= 1) break;
                    int i = this.pi.textInputHistoryBrowsePos;
                    if (i == 0) {
                        this.pi.textInputHistory.set(0, this.pi.textInput.getText());
                        i = S - 1;
                    } else {
                        --i;
                    }
                    if (i <= 0) break;
                    this.pi.textInput.setText((String)this.pi.textInputHistory.get(i));
                    this.pi.textInputHistoryBrowsePos = i;
                    e.consume();
                    break;
                }
                case 40: {
                    int i = this.pi.textInputHistoryBrowsePos;
                    if (i <= 0) break;
                    if (++i == this.pi.textInputHistory.size()) {
                        i = 0;
                    }
                    this.pi.textInput.setText((String)this.pi.textInputHistory.get(i));
                    this.pi.textInputHistoryBrowsePos = i;
                    e.consume();
                }
            }
            if (!this.pi.textInputIsInitial) {
                return;
            }
            this.pi.textInputSetToInitialPrompt(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.promptIfEmpty();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.promptIfEmpty();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.promptIfEmpty();
        }

        private void promptIfEmpty() {
            if (this.pi.textInputIsInitial || this.pi.textInputHasSent) {
                return;
            }
            if (this.pi.textInput.getText().trim().length() == 0) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        pi.textInputSetToInitialPrompt(true);
                    }
                });
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!this.pi.textInputIsInitial) {
                return;
            }
            this.pi.textInputSetToInitialPrompt(false);
        }
    }

    private static class PIWindowAdapter
    extends WindowAdapter {
        private final MainDisplay md;
        private final SOCPlayerInterface pi;

        public PIWindowAdapter(MainDisplay md, SOCPlayerInterface spi) {
            this.md = md;
            this.pi = spi;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (this.pi.clientHandPlayerNum != -1) {
                SOCQuitConfirmDialog.createAndShow(this.md, this.pi);
            } else {
                this.pi.leaveGame();
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            if (!this.pi.textDisplaysLargerTemp) {
                return;
            }
            this.pi.textDisplayHasMouse = false;
            this.pi.chatDisplayHasMouse = false;
            this.pi.textInputHasMouse = false;
            this.pi.textDisplaysLargerTemp = false;
            this.pi.textDisplaysLargerTemp_needsLayout = true;
            this.pi.revalidate();
            this.pi.repaint();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (this.pi.buildingPanel != null) {
                this.pi.buildingPanel.gameWindowClosed();
            }
            if (UserPreferences.getPref("faceIcon", 0) > 0) {
                UserPreferences.putPref("faceIcon", this.pi.client.lastFaceChange);
            }
        }
    }

    private class PILayoutManager
    implements LayoutManager {
        private PILayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container pi) {
            return new Dimension(SOCPlayerInterface.this.widthOrig, SOCPlayerInterface.this.heightOrig);
        }

        @Override
        public Dimension minimumLayoutSize(Container pi) {
            return new Dimension(830, 650);
        }

        @Override
        public void layoutContainer(Container pane) {
            int tdh;
            int cdh;
            int spareW;
            boolean canStretchBoard;
            int bw;
            int bh;
            Dimension dim = pane.getSize();
            boolean needRepaintBorders = SOCPlayerInterface.this.prevSize != null && (dim.width != ((SOCPlayerInterface)SOCPlayerInterface.this).prevSize.width || dim.height != ((SOCPlayerInterface)SOCPlayerInterface.this).prevSize.height);
            SOCPlayerInterface.this.prevSize = dim;
            Dimension bpMinSz = SOCPlayerInterface.this.boardPanel.getMinimumSize();
            int bMinW = bpMinSz.width;
            int bMinH = bpMinSz.height;
            int buildph = SOCPlayerInterface.this.buildingPanel.getHeight();
            int tfh = SOCPlayerInterface.this.textInput.getHeight();
            int pix4 = 4 * SOCPlayerInterface.this.displayScale;
            int pix8 = 8 * SOCPlayerInterface.this.displayScale;
            int pix12 = 12 * SOCPlayerInterface.this.displayScale;
            int pix16 = 16 * SOCPlayerInterface.this.displayScale;
            int hpMinW = 218 * SOCPlayerInterface.this.displayScale;
            if (hpMinW < dim.width / 10) {
                hpMinW = dim.width / 10;
            }
            if ((bh = (int)((long)(bw = dim.width - 2 * hpMinW - pix16) * (long)bMinH / (long)bMinW)) > dim.height - buildph - pix16 - (int)(5.5f * (float)tfh)) {
                bh = dim.height - buildph - pix16 - (int)(5.5f * (float)tfh);
                bw = (int)((long)bh * (long)bMinW / (long)bMinH);
            }
            boolean bl = canStretchBoard = bw >= bMinW && bh >= bMinH;
            if (bw > bMinW && (spareW = dim.width - hpMinW * 2 - bw - pix16) > 0) {
                bw += 4 * spareW / 5;
            }
            int hw = (dim.width - bw - pix16) / 2;
            int tah = 0;
            if (canStretchBoard) {
                int spareH = dim.height - buildph - pix16 - (int)(5.5f * (float)tfh) - bh;
                if (spareH > 0) {
                    bh += 2 * spareH / 3;
                }
                tah = dim.height - bh - buildph - tfh - pix16;
                try {
                    SOCPlayerInterface.this.boardPanel.setBounds(hw + pix8, tfh + tah + pix8, bw, bh);
                }
                catch (IllegalArgumentException e) {
                    canStretchBoard = false;
                }
            }
            if (!canStretchBoard) {
                bh = bMinH;
                tah = dim.height - bh - buildph - tfh - pix16;
                try {
                    SOCPlayerInterface.this.boardPanel.setBounds(hw + pix8, tfh + tah + pix8, bw, bh);
                }
                catch (IllegalArgumentException ee) {
                    int widthAvail;
                    bw = SOCPlayerInterface.this.boardPanel.getWidth();
                    bh = SOCPlayerInterface.this.boardPanel.getHeight();
                    hw = (dim.width - bw - pix16) / 2;
                    if (hw < hpMinW && bw > bMinW && (widthAvail = dim.width - bMinW - 2 * hpMinW - pix16) > 0) {
                        int boardAvail = widthAvail / 5;
                        bw = bMinW + boardAvail;
                        hw = hpMinW + (widthAvail - boardAvail);
                        SOCPlayerInterface.this.boardPanel.setSize(bw, bh, true);
                        bw = SOCPlayerInterface.this.boardPanel.getWidth();
                        bh = SOCPlayerInterface.this.boardPanel.getHeight();
                        hw = (dim.width - bw - pix16) / 2;
                    }
                    tah = dim.height - bh - buildph - tfh - pix16;
                    SOCPlayerInterface.this.boardPanel.setLocation(hw + pix8, tfh + tah + pix8);
                }
            }
            if (SOCPlayerInterface.this.highContrastBorders != null) {
                SOCPlayerInterface.this.highContrastBorders[0].setBounds(hw + pix4, 0, pix4, dim.height);
                SOCPlayerInterface.this.highContrastBorders[1].setBounds(hw + bw + pix8, 0, pix4, dim.height);
            }
            int halfplayers = SOCPlayerInterface.this.is6player ? 3 : 2;
            int hh = (dim.height - pix12) / halfplayers;
            int kw = bw;
            SOCPlayerInterface.this.buildingPanel.setBounds(hw + pix8, tah + tfh + bh + pix12, kw, buildph);
            try {
                if (!SOCPlayerInterface.this.is6player) {
                    SOCPlayerInterface.this.hands[0].setBounds(pix4, pix4, hw, hh);
                    if (SOCPlayerInterface.this.game.maxPlayers > 1) {
                        SOCPlayerInterface.this.hands[1].setBounds(hw + bw + pix12, pix4, hw, hh);
                        SOCPlayerInterface.this.hands[2].setBounds(hw + bw + pix12, hh + pix8, hw, hh);
                        SOCPlayerInterface.this.hands[3].setBounds(pix4, hh + pix8, hw, hh);
                        if (SOCPlayerInterface.this.highContrastBorders != null) {
                            SOCPlayerInterface.this.highContrastBorders[2].setBounds(0, hh + pix4, hw + pix8, pix4);
                            SOCPlayerInterface.this.highContrastBorders[3].setBounds(hw + bw + pix8, hh + pix4, hw + pix8, pix4);
                        }
                    }
                } else {
                    if (SOCPlayerInterface.this.clientHandPlayerNum == -1 || SOCPlayerInterface.this.clientHandPlayerNum >= 1 && SOCPlayerInterface.this.clientHandPlayerNum <= 3) {
                        SOCPlayerInterface.this.hands[0].setBounds(pix4, pix4, hw, hh);
                        SOCPlayerInterface.this.hands[4].setBounds(pix4, 2 * hh + pix12, hw, hh);
                        SOCPlayerInterface.this.hands[5].setBounds(pix4, hh + pix8, hw, hh);
                        if (SOCPlayerInterface.this.highContrastBorders != null) {
                            SOCPlayerInterface.this.highContrastBorders[2].setBounds(0, hh + pix4, hw + pix8, pix4);
                            SOCPlayerInterface.this.highContrastBorders[3].setBounds(0, 2 * hh + pix8, hw + pix8, pix4);
                        }
                    }
                    if (SOCPlayerInterface.this.clientHandPlayerNum < 1 || SOCPlayerInterface.this.clientHandPlayerNum > 3) {
                        SOCPlayerInterface.this.hands[1].setBounds(hw + bw + pix12, pix4, hw, hh);
                        SOCPlayerInterface.this.hands[2].setBounds(hw + bw + pix12, hh + pix8, hw, hh);
                        SOCPlayerInterface.this.hands[3].setBounds(hw + bw + pix12, 2 * hh + pix12, hw, hh);
                        if (SOCPlayerInterface.this.highContrastBorders != null) {
                            SOCPlayerInterface.this.highContrastBorders[4].setBounds(hw + bw + pix12, hh + pix4, hw + pix8, pix4);
                            SOCPlayerInterface.this.highContrastBorders[5].setBounds(hw + bw + pix12, 2 * hh + pix8, hw + pix8, pix4);
                        }
                    }
                    if (SOCPlayerInterface.this.clientHandPlayerNum != -1) {
                        int hp_x;
                        int[] hp_idx;
                        boolean isRight;
                        boolean bl2 = isRight = SOCPlayerInterface.this.clientHandPlayerNum >= 1 && SOCPlayerInterface.this.clientHandPlayerNum <= 3;
                        if (isRight) {
                            int[] idx_right;
                            hp_idx = idx_right = new int[]{1, 2, 3};
                            hp_x = hw + bw + pix12;
                        } else {
                            int[] idx_left = new int[]{0, 5, 4};
                            hp_idx = idx_left;
                            hp_x = pix4;
                        }
                        int hp_y = pix4;
                        for (int ihp = 0; ihp < 3; ++ihp) {
                            SOCHandPanel hp = SOCPlayerInterface.this.hands[hp_idx[ihp]];
                            int hp_height = hp_idx[ihp] == SOCPlayerInterface.this.clientHandPlayerNum ? (dim.height - pix12) / 2 - 32 * SOCPlayerInterface.this.displayScale : (dim.height - pix12) / 4 + 16 * SOCPlayerInterface.this.displayScale;
                            hp.setBounds(hp_x, hp_y, hw, hp_height);
                            hp.invalidate();
                            hp.doLayout();
                            hp_y += hp_height + pix4;
                            if (SOCPlayerInterface.this.highContrastBorders == null || ihp > 1) continue;
                            SOCPlayerInterface.this.highContrastBorders[ihp + (isRight ? 4 : 2)].setBounds(hp_x - pix4, hp_y - pix4, hw + pix8, pix4);
                        }
                    }
                }
            }
            catch (NullPointerException isRight) {
                // empty catch block
            }
            if (SOCPlayerInterface.this.game.isPractice) {
                cdh = (int)(2.2f * (float)tfh);
                tdh = tah - cdh;
                if (tdh < cdh) {
                    tdh = cdh;
                    cdh = tah - cdh;
                }
            } else {
                tdh = tah / 2;
                cdh = tah - tdh;
            }
            if (SOCPlayerInterface.this.textDisplaysLargerTemp_needsLayout && SOCPlayerInterface.this.textDisplaysLargerTemp) {
                int x = hw / 2;
                int w = dim.width - 2 * (hw - x);
                int h = 5 * tfh;
                if (h < SOCPlayerInterface.this.boardPanel.getY() - tfh) {
                    h = SOCPlayerInterface.this.boardPanel.getY() - tfh;
                }
                int hf = SOCPlayerInterface.this.hands[0].getHeight();
                int h1 = SOCPlayerInterface.this.hands[1].getHeight();
                if (h1 < hf) {
                    hf = h1;
                }
                if ((hf = hf - cdh - tfh - 15 * SOCPlayerInterface.this.displayScale) > h) {
                    h = hf;
                }
                SOCPlayerInterface.this.textDisplay.setBounds(x, pix4, w, h);
                if (!SOCPlayerInterface.this.game.isPractice) {
                    cdh += 20 * SOCPlayerInterface.this.displayScale;
                }
                SOCPlayerInterface.this.chatDisplay.setBounds(x, pix4 + h, w, cdh);
                SOCPlayerInterface.this.textInput.setBounds(x, pix4 + (h += cdh), w, tfh);
                needRepaintBorders = true;
                SOCPlayerInterface.this.textInput.requestFocusInWindow();
            } else {
                int prevTextY = ((SOCPlayerInterface)SOCPlayerInterface.this).textInput.getBounds().y;
                SOCPlayerInterface.this.textDisplay.setBounds(hw + pix8, pix4, bw, tdh);
                SOCPlayerInterface.this.chatDisplay.setBounds(hw + pix8, pix4 + tdh, bw, cdh);
                SOCPlayerInterface.this.textInput.setBounds(hw + pix8, pix4 + tah, bw, tfh);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SOCPlayerInterface.this.chatDisplay.setCaretPosition(SOCPlayerInterface.this.chatDisplay.getText().length());
                        SOCPlayerInterface.this.textDisplay.setCaretPosition(SOCPlayerInterface.this.textDisplay.getText().length());
                    }
                });
                if (SOCPlayerInterface.this.textDisplaysLargerTemp_needsLayout || prevTextY != ((SOCPlayerInterface)SOCPlayerInterface.this).textInput.getBounds().y) {
                    needRepaintBorders = true;
                }
            }
            SOCPlayerInterface.this.textDisplaysLargerTemp_needsLayout = false;
            if (needRepaintBorders) {
                SOCPlayerInterface.this.repaint();
            }
            SOCPlayerInterface.this.npix = SOCPlayerInterface.this.textDisplay.getPreferredSize().width;
            SOCPlayerInterface.this.ncols = (int)((float)bw * 100.0f / (float)SOCPlayerInterface.this.npix) - 2;
            SOCPlayerInterface.this.boardPanel.doLayout();
            if (SOCPlayerInterface.this.layoutNotReadyYet) {
                SOCPlayerInterface.this.mainDisplay.clearWaitingStatus(false);
                SOCPlayerInterface.this.layoutNotReadyYet = false;
                SOCPlayerInterface.this.repaint();
            }
            if (!SOCPlayerInterface.this.didGameScenarioPopupCheck) {
                SOCPlayerInterface.this.showScenarioInfoDialog();
                SOCPlayerInterface.this.didGameScenarioPopupCheck = true;
            }
        }
    }

    protected static class ResetBoardConfirmDialog
    extends AskDialog
    implements Runnable {
        private ResetBoardConfirmDialog(MainDisplay md, SOCPlayerInterface gamePI) {
            super(md, gamePI, strings.get("reset.restart.game"), strings.get("reset.board.new"), strings.get("base.restart"), strings.get("base.cancel"), null, 2);
        }

        @Override
        public void button1Chosen() {
            this.pi.resetBoardRequest(false);
        }

        @Override
        public void button2Chosen() {
        }

        @Override
        public void windowCloseChosen() {
        }
    }

    private class ChooseRobClothOrResourceDialog
    extends AskDialog
    implements Runnable {
        private static final long serialVersionUID = 2000L;
        private final int vpn;

        protected ChooseRobClothOrResourceDialog(int vpn) {
            super(SOCPlayerInterface.this.getMainDisplay(), SOCPlayerInterface.this, strings.get("dialog.rob.sc_clvi.cloth.or.rsrc"), strings.get("dialog.rob.sc_clvi.ask.cloth.or.rsrc"), strings.get("dialog.rob.sc_clvi.cloth"), strings.get("dialog.rob.sc_clvi.rsrc"), null, 1);
            this.vpn = vpn;
        }

        @Override
        public void button1Chosen() {
            this.md.getGameMessageSender().choosePlayer(SOCPlayerInterface.this.game, -(this.vpn + 1));
        }

        @Override
        public void button2Chosen() {
            this.md.getGameMessageSender().choosePlayer(SOCPlayerInterface.this.game, this.vpn);
        }

        @Override
        public void windowCloseChosen() {
            this.button2Chosen();
        }
    }

    private class ChooseMoveRobberOrPirateDialog
    extends AskDialog
    implements Runnable {
        private static final long serialVersionUID = 2700L;
        private final boolean withCancel;

        private ChooseMoveRobberOrPirateDialog(boolean withCancel) {
            super(SOCPlayerInterface.this.getMainDisplay(), SOCPlayerInterface.this, strings.get("dialog.choosemove.robber.or.pirate"), strings.get("dialog.choosemove.ask.rob.pirate"), strings.get("dialog.base.move.robber"), strings.get("dialog.base.move.pirate"), withCancel ? strings.get("base.cancel") : null, withCancel ? 3 : 1);
            this.withCancel = withCancel;
        }

        @Override
        public void button1Chosen() {
            this.md.getGameMessageSender().chooseRobber(SOCPlayerInterface.this.game);
        }

        @Override
        public void button2Chosen() {
            this.md.getGameMessageSender().choosePirate(SOCPlayerInterface.this.game);
        }

        @Override
        public void button3Chosen() {
            this.md.getGameMessageSender().cancelBuildRequest(SOCPlayerInterface.this.game, -2);
        }

        @Override
        public void windowCloseChosen() {
            if (this.withCancel) {
                this.button3Chosen();
            } else {
                this.button1Chosen();
            }
        }
    }

    protected static class ResetBoardVoteDialog
    extends AskDialog
    implements Runnable {
        private boolean askedDisposeQuietly = false;

        protected ResetBoardVoteDialog(MainDisplay md, SOCPlayerInterface gamePI, String requester, boolean gameIsOver) {
            super(md, gamePI, strings.get("reset.board.for.game", gamePI.getGame().getName()), gameIsOver ? strings.get("reset.x.wants.start.new", requester) : strings.get("reset.x.wants.reset", requester), gameIsOver ? strings.get("base.restart") : strings.get("reset.reset"), gameIsOver ? strings.get("base.no.thanks") : strings.get("dialog.base.continue.playing"), null, gameIsOver ? 1 : 2);
        }

        @Override
        public void button1Chosen() {
            this.md.getGameMessageSender().resetBoardVote(this.pi.getGame(), true);
            this.pi.resetBoardClearDia();
        }

        @Override
        public void button2Chosen() {
            this.md.getGameMessageSender().resetBoardVote(this.pi.getGame(), false);
            this.pi.resetBoardClearDia();
        }

        @Override
        public void windowCloseChosen() {
            if (!this.askedDisposeQuietly) {
                this.button2Chosen();
            }
        }

        public void disposeQuietly() {
            this.askedDisposeQuietly = true;
            this.dispose();
        }
    }

    protected static class ClientBridge
    implements PlayerClientListener {
        final SOCPlayerInterface pi;

        public ClientBridge(SOCPlayerInterface pi) {
            this.pi = pi;
        }

        @Override
        public SOCGame getGame() {
            return this.pi.getGame();
        }

        @Override
        public int getClientPlayerNumber() {
            return this.pi.getClientPlayerNumber();
        }

        @Override
        public boolean isClientCurrentPlayer() {
            return this.pi.isClientCurrentPlayer();
        }

        @Override
        public void diceRolled(SOCPlayer player, int rollSum) {
            this.pi.showDiceResult(player, rollSum);
        }

        @Override
        public void diceRolledResources(List<Integer> pnum, List<SOCResourceSet> rsrc) {
            StringBuffer sb = new StringBuffer("* ");
            boolean noPlayersGained = true;
            boolean cliPlayerGained = false;
            int n = pnum.size();
            SOCGame ga = this.pi.game;
            for (int p = 0; p < n; ++p) {
                int pn = pnum.get(p);
                SOCHandPanel hpan = this.pi.getPlayerHandPanel(pn);
                hpan.updateValue(PlayerClientListener.UpdateType.ResourceTotalAndDetails);
                SOCPlayer pl = ga.getPlayer(pn);
                if (noPlayersGained) {
                    noPlayersGained = false;
                } else {
                    sb.append(" ");
                }
                sb.append(strings.getSpecial(ga, "game.playername.gets.resources.common", pl.getName(), rsrc.get(p)));
                if (pn != this.pi.clientHandPlayerNum) continue;
                cliPlayerGained = true;
            }
            if (sb.length() > 2) {
                this.pi.print(sb.toString());
                if (cliPlayerGained) {
                    this.pi.gameStats.resourceRollReceived();
                }
            }
        }

        @Override
        public void playerJoined(String nickname) {
            String msg = "*** " + strings.get("interface.member.joined.game", nickname);
            this.pi.print(msg);
            if (this.pi.game != null && this.pi.game.getGameState() >= 5) {
                this.pi.chatPrint(msg);
            }
        }

        @Override
        public void playerLeft(String nickname, SOCPlayer player) {
            if (player != null) {
                this.pi.removePlayer(player.getPlayerNumber());
            }
            if (this.pi.game.getGameState() >= 5) {
                this.pi.chatPrint("* " + strings.get("interface.member.left.game", nickname));
            }
        }

        @Override
        public void playerSitdown(int playerNumber, String sitterNickname) {
            this.pi.addPlayer(sitterNickname, playerNumber);
        }

        @Override
        public void playerTurnSet(int playerNumber) {
            this.pi.updateAtTurn(playerNumber);
        }

        @Override
        public void playerPiecePlaced(SOCPlayer player, int coordinate, int pieceType) {
            this.pi.updateAtPutPiece(player.getPlayerNumber(), coordinate, pieceType, false, 0);
        }

        @Override
        public void playerPieceMoved(SOCPlayer player, int sourceCoordinate, int targetCoordinate, int pieceType) {
            this.pi.updateAtPutPiece(player.getPlayerNumber(), sourceCoordinate, pieceType, true, targetCoordinate);
            if (pieceType == 3) {
                this.pi.printKeyed("game.pieces.moved.ship", player.getName());
            }
        }

        @Override
        public void playerPieceRemoved(SOCPlayer player, int pieceCoordinate, int pieceType) {
            this.pi.updateAtPieceRemoved(player, pieceCoordinate, pieceType);
        }

        @Override
        public void playerPiecePlacementUndone(SOCPlayer player, int coordinate, int movedFromCoordinate, int pieceType) {
            this.pi.updateAtUndoPutPiece(player, coordinate, movedFromCoordinate, pieceType);
        }

        @Override
        public void playerPiecePlacementUndoDeclined(int pieceType, boolean isMove) {
            NotifyDialog.createAndShow(this.pi.getMainDisplay(), this.pi, isMove ? "Cannot undo that move" : "Cannot undo that build", null, true);
        }

        @Override
        public void playerSVPAwarded(SOCPlayer player, int numSvp, String awardDescription) {
            if (this.pi.getClientHand() == null) {
                return;
            }
            this.pi.updateAtSVPText(player.getName(), numSvp, awardDescription);
        }

        @Override
        public void playerResourcesUpdated(SOCPlayer player) {
            SOCHandPanel hpan = this.pi.getPlayerHandPanel(player.getPlayerNumber());
            hpan.updateValue(PlayerClientListener.UpdateType.Resources);
        }

        @Override
        public void playerPickedResources(SOCPlayer player, SOCResourceSet resSet, int reasonCode) {
            String key;
            switch (reasonCode) {
                case 1: {
                    key = "action.picked.rsrcs";
                    break;
                }
                case 2: {
                    key = "action.card.discov.received";
                    break;
                }
                case 3: {
                    key = "action.picked.rsrcs.goldhex";
                    break;
                }
                default: {
                    return;
                }
            }
            this.pi.printKeyedSpecial(key, player.getName(), resSet);
            this.pi.getPlayerHandPanel(player.getPlayerNumber()).updateValue(PlayerClientListener.UpdateType.ResourceTotalAndDetails);
        }

        @Override
        public void playerElementUpdated(SOCPlayer player, PlayerClientListener.UpdateType utype, boolean isGoodNews, boolean isBadNews) {
            SOCHandPanel hpan = player == null ? null : this.pi.getPlayerHandPanel(player.getPlayerNumber());
            int hpanUpdateRsrcType = 0;
            switch (utype) {
                case Road: 
                case Settlement: 
                case City: 
                case Ship: 
                case Knight: 
                case UndosRemaining: {
                    hpan.updateValue(utype);
                    break;
                }
                case Clay: {
                    hpanUpdateRsrcType = 1;
                    break;
                }
                case Ore: {
                    hpanUpdateRsrcType = 2;
                    break;
                }
                case Sheep: {
                    hpanUpdateRsrcType = 3;
                    break;
                }
                case Wheat: {
                    hpanUpdateRsrcType = 4;
                    break;
                }
                case Wood: {
                    hpanUpdateRsrcType = 5;
                    break;
                }
                case Unknown: {
                    hpan.updateValue(PlayerClientListener.UpdateType.Resources);
                    break;
                }
                case ResourceTotalAndDetails: {
                    break;
                }
                case VictoryPoints: {
                    hpan.updateValue(PlayerClientListener.UpdateType.VictoryPoints);
                    break;
                }
                case SpecialVictoryPoints: {
                    hpan.updateValue(PlayerClientListener.UpdateType.SpecialVictoryPoints);
                    hpan.updateValue(PlayerClientListener.UpdateType.VictoryPoints);
                    break;
                }
                case Cloth: {
                    if (player != null) {
                        hpan.updateValue(utype);
                        hpan.updateValue(PlayerClientListener.UpdateType.VictoryPoints);
                        break;
                    }
                    this.pi.buildingPanel.updateClothCount();
                    break;
                }
                case Warship: {
                    this.pi.updateAtWarshipsChanged(isGoodNews);
                    break;
                }
                case WonderLevel: {
                    hpan.updateValue(PlayerClientListener.UpdateType.WonderLevel);
                    break;
                }
                default: {
                    System.out.println("Unhandled case in PlayerClientListener[" + (Object)((Object)utype) + "]");
                }
            }
            if (hpan == null) {
                return;
            }
            boolean isClientPlayer = hpan.isClientPlayer();
            if (hpanUpdateRsrcType != 0 || utype == PlayerClientListener.UpdateType.ResourceTotalAndDetails) {
                if (isClientPlayer || this.pi.isGameFullyObservable) {
                    hpan.updateValue(utype);
                    if (isClientPlayer) {
                        this.pi.updateAtClientPlayerResources();
                        if (isGoodNews) {
                            this.pi.playSound(SOUND_RSRC_GAINED_FREE);
                        } else if (isBadNews) {
                            this.pi.playSound(SOUND_RSRC_LOST);
                        }
                    }
                } else {
                    hpan.updateValue(utype == PlayerClientListener.UpdateType.ResourceTotalAndDetails ? utype : PlayerClientListener.UpdateType.Resources);
                }
            }
            if (isClientPlayer && this.pi.getGame().getGameState() != 0) {
                this.pi.buildingPanel.updateButtonStatus();
            }
        }

        @Override
        public void requestedSpecialBuild(SOCPlayer player) {
            if (player.hasAskedSpecialBuild()) {
                this.pi.printKeyed("game.sbp.wants.to", player.getName());
            }
            if (this.pi.isClientPlayer(player)) {
                this.pi.buildingPanel.updateButtonStatus();
            }
        }

        @Override
        public void requestedGoldResourceCountUpdated(SOCPlayer player, int countToPick) {
            int pn = player.getPlayerNumber();
            SOCHandPanel hpan = this.pi.getPlayerHandPanel(pn);
            hpan.updatePickGoldHexResources();
            if (countToPick > 0 && pn == this.pi.clientHandPlayerNum) {
                this.pi.gameStats.resourceRollReceived();
            }
        }

        @Override
        public void playerDevCardsUpdated(SOCPlayer player, boolean addedPlayable) {
            SOCHandPanel hpan = this.pi.getPlayerHandPanel(player.getPlayerNumber());
            if (this.pi.isGameObservableVP || this.pi.isClientPlayer(player)) {
                hpan.updateDevCards(addedPlayable);
                hpan.updateValue(PlayerClientListener.UpdateType.VictoryPoints);
            } else if (player != null) {
                hpan.updateDevCards(addedPlayable);
            }
        }

        @Override
        public void playerCanCancelInvItemPlay(SOCPlayer player, boolean canCancel) {
            if (this.pi.isClientPlayer(player)) {
                this.pi.getClientHand().setCanCancelInvItemPlay(canCancel);
            }
        }

        @Override
        public void playerFaceChanged(SOCPlayer player, int faceId) {
            this.pi.changeFace(player.getPlayerNumber(), faceId);
        }

        @Override
        public List<String> playerStats(int statsType, int[] stats, boolean withHeading, boolean doDisplay) {
            SOCPlayer clientPlayer = this.pi.getClientPlayer();
            if (clientPlayer == null || doDisplay && this.pi.clientPlayerIsSitting) {
                return null;
            }
            ArrayList<String> prints = new ArrayList<String>();
            switch (statsType) {
                case 1: {
                    int gp;
                    int total = 0;
                    int[] plStats = clientPlayer.getResourceRollStats();
                    for (int i = 1; i <= 5; ++i) {
                        total += plStats[i];
                    }
                    if (withHeading) {
                        prints.add("* " + strings.get("stats.rolls.your"));
                    }
                    prints.add("* " + strings.get("stats.rolls.n.total", plStats[1], plStats[2], plStats[3], plStats[4], plStats[5], total));
                    if (plStats.length <= 6 || (gp = plStats[6]) == 0) break;
                    prints.add("* " + strings.get("stats.gold_gains", gp));
                    break;
                }
                case 2: {
                    int numTypes;
                    int subArrLen;
                    SOCResourceSet[][] plStats = clientPlayer.getResourceTradeStats();
                    if (withHeading) {
                        prints.add("* " + strings.get("game.trade.stats.heading") + ' ' + strings.get("game.trade.stats.heading_give_get"));
                    }
                    String[] statLabels = new String[]{"game.port.three", "game.port.clay", "game.port.ore", "game.port.sheep", "game.port.wheat", "game.port.wood", "game.trade.stats.bank", "game.trade.stats.with_players"};
                    int n = subArrLen = stats != null ? stats[1] : 5;
                    if (stats != null) {
                        numTypes = (stats.length - 2) / subArrLen;
                        if (numTypes > statLabels.length) {
                            numTypes = statLabels.length;
                        }
                    } else {
                        numTypes = statLabels.length;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (int ttype = 0; ttype < numTypes; ++ttype) {
                        boolean none;
                        boolean bl = none = plStats[0][ttype].isEmpty() && plStats[1][ttype].isEmpty();
                        if (doDisplay) {
                            sb.append("* ");
                        }
                        sb.append(strings.get(statLabels[ttype]));
                        if (none) {
                            sb.append(": ");
                            sb.append(strings.get("base.none"));
                        } else {
                            int res;
                            sb.append(": ");
                            if (ttype >= 1 && ttype <= 5) {
                                sb.append(plStats[0][ttype].getAmount(ttype));
                            } else {
                                sb.append('(');
                                for (res = 1; res <= 5; ++res) {
                                    if (res > 1) {
                                        sb.append(", ");
                                    }
                                    sb.append(plStats[0][ttype].getAmount(res));
                                }
                                sb.append(')');
                            }
                            sb.append(" -> (");
                            for (res = 1; res <= 5; ++res) {
                                if (res > 1) {
                                    sb.append(", ");
                                }
                                sb.append(plStats[1][ttype].getAmount(res));
                            }
                            sb.append(')');
                        }
                        prints.add(sb.toString());
                        sb.delete(0, sb.length());
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
            if (doDisplay) {
                for (String s : prints) {
                    this.pi.print(s);
                }
                prints.clear();
                prints = null;
            }
            return prints;
        }

        @Override
        public void largestArmyRefresh(SOCPlayer old, SOCPlayer potentialNew) {
            this.pi.updateLongestLargest(false, old, potentialNew);
        }

        @Override
        public void longestRoadRefresh(SOCPlayer old, SOCPlayer potentialNew) {
            this.pi.updateLongestLargest(true, old, potentialNew);
        }

        @Override
        public void membersListed(final List<String> names) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pi.began(names);
                }
            });
        }

        @Override
        public void boardLayoutUpdated() {
            this.pi.updateAtNewBoard();
        }

        @Override
        public void boardUpdated() {
            this.pi.boardPanel.flushBoardLayoutAndRepaint();
        }

        @Override
        public void pieceValueUpdated(SOCPlayingPiece piece) {
            this.pi.boardPanel.pieceValueUpdated(piece);
        }

        @Override
        public void boardPotentialsUpdated() {
            this.pi.boardPanel.flushBoardLayoutAndRepaintIfDebugShowPotentials();
        }

        @Override
        public void boardReset(SOCGame newGame, int newSeatNumber, int requestingPlayerNumber) {
            this.pi.resetBoard(newGame, newSeatNumber, requestingPlayerNumber);
        }

        @Override
        public void boardResetVoteRequested(SOCPlayer requestor) {
            this.pi.resetBoardAskVote(requestor.getPlayerNumber());
        }

        @Override
        public void boardResetVoteCast(SOCPlayer voter, boolean vote) {
            this.pi.resetBoardVoted(voter.getPlayerNumber(), vote);
        }

        @Override
        public void boardResetVoteRejected() {
            this.pi.resetBoardRejected();
        }

        @Override
        public void seatLockUpdated() {
            for (int i = 0; i < this.pi.game.maxPlayers; ++i) {
                this.pi.getPlayerHandPanel(i).updateSeatLockButton();
                this.pi.getPlayerHandPanel(i).updateTakeOverButton();
            }
        }

        @Override
        public final boolean isNonBlockingDialogVisible() {
            return this.pi.isNonBlockingDialogVisible();
        }

        @Override
        public void gameStarted() {
            this.pi.startGame();
        }

        @Override
        public void gameStateChanged(int gameState, boolean isForDecline) {
            this.pi.updateAtGameState(isForDecline);
        }

        @Override
        public void gameEnded(Map<SOCPlayer, Integer> scores) {
            int[] scoresArray = new int[scores.size()];
            for (Map.Entry<SOCPlayer, Integer> e : scores.entrySet()) {
                scoresArray[e.getKey().getPlayerNumber()] = e.getValue();
            }
            this.pi.updateAtOver(scoresArray);
        }

        @Override
        public void gameDisconnected(boolean wasDeleted, String errorMessage) {
            this.pi.gameDisconnected(wasDeleted, errorMessage);
        }

        @Override
        public void messageBroadcast(String msg) {
            this.pi.chatPrint("::: " + msg + " :::");
        }

        @Override
        public void printText(String txt) {
            this.pi.print(txt, false);
        }

        @Override
        public void printText(String txt, boolean addStarPrefix) {
            this.pi.print(txt, addStarPrefix);
        }

        @Override
        public void messageReceived(String nickname, String message) {
            if (nickname == null) {
                String starMesText = "* " + message;
                this.pi.print(starMesText);
                if (message.startsWith(">>>")) {
                    this.pi.chatPrint(starMesText);
                }
            } else if (!this.pi.getClient().onIgnoreList(nickname)) {
                this.pi.chatPrint(nickname + ": " + message);
            }
        }

        @Override
        public final void simpleRequest(int pn, int reqtype, int value1, int value2) {
            switch (reqtype) {
                case 1000: {
                    this.scen_SC_PIRI_pirateFortressAttackResult(true, 0, 0);
                    break;
                }
                case 1001: {
                    if (pn == -1) {
                        if (this.pi.getGame().getGameState() == 42) {
                            this.pi.printKeyed("game.invitem.sc_ftri.need.coastal");
                            break;
                        }
                        this.pi.printKeyed("hpan.item.play.cannot");
                        break;
                    }
                    this.boardUpdated();
                    if (this.pi.clientHand != null) {
                        this.pi.clientHand.updateResourceTradeCosts(false);
                    }
                    this.pi.printKeyed("game.invitem.port.placed", this.pi.game.getPlayer(pn).getName(), strings.get(SOCBoard.getPortDescForType(value2, true)));
                    break;
                }
                case 1: {
                    this.promptPickResources(value1);
                    break;
                }
                default: {
                    System.err.println("PI.simpleRequest: Ignored unknown type " + reqtype + " in game " + this.pi.game.getName());
                }
            }
        }

        @Override
        public final void simpleAction(int pn, int acttype, int value1, int value2) {
            String plName = pn >= 0 ? this.pi.game.getPlayer(pn).getName() : null;
            switch (acttype) {
                case 1: {
                    String remainKey;
                    if (this.pi.getClient().getServerVersion(this.pi.game) >= 2500) {
                        this.pi.updateDevCardCount();
                    }
                    this.pi.printKeyed("game.devcard.bought", plName);
                    switch (value1) {
                        case 0: {
                            remainKey = "game.devcard.bought.0left";
                            break;
                        }
                        case 1: {
                            remainKey = "game.devcard.bought.1left";
                            break;
                        }
                        default: {
                            remainKey = "game.devcard.bought.xleft";
                        }
                    }
                    this.pi.printKeyed(remainKey, value1);
                    break;
                }
                case 4: {
                    this.boardUpdated();
                    break;
                }
                case 3: {
                    if (pn == this.pi.clientHandPlayerNum) {
                        this.pi.printKeyedSpecial("game.action.mono.you.monopolized", value1, value2);
                        break;
                    }
                    this.pi.printKeyedSpecial("game.action.mono.monopolized", plName, value1, value2);
                    break;
                }
                case 1002: {
                    this.boardUpdated();
                    this.pi.printKeyed("game.invitem.port.picked.up", plName, strings.get(SOCBoard.getPortDescForType(value2, true)));
                    break;
                }
                default: {
                    System.err.println("PI.simpleAction: Ignored unknown type " + acttype + " in game " + this.pi.game.getName());
                }
            }
        }

        @Override
        public void playerRequestDeclined(int reasonCode, int detailValue1, int detailValue2, String reasonText) {
            this.pi.showDeclinedPlayerRequest(reasonCode, detailValue1, detailValue2, reasonText);
        }

        @Override
        public void buildRequestCanceled(SOCPlayer player) {
            this.pi.getPlayerHandPanel(player.getPlayerNumber()).updateResourcesVP();
            if (this.pi.game.isInitialPlacement()) {
                this.pi.boardPanel.setLatestPiecePlacement(null);
            }
            this.pi.boardPanel.updateMode();
        }

        @Override
        public void invItemPlayRejected(int type, int reasonCode) {
            if (reasonCode == 4 && this.pi.getGame().isGameOptionSet("_SC_FTRI")) {
                this.pi.printKeyed("game.invitem.sc_ftri.need.coastal");
            } else {
                this.pi.printKeyed("hpan.item.play.cannot");
            }
        }

        @Override
        public void playerPickSpecialItem(String typeKey, SOCGame ga, SOCPlayer pl, int gidx, int pidx, boolean isPick, int coord, int level, String sv) {
            if (pl == null && isPick) {
                return;
            }
            if (!typeKey.equals("_SC_WOND")) {
                return;
            }
            if (isPick) {
                String iname = null;
                SOCSpecialItem itm = ga.getSpecialItem(typeKey, gidx);
                if (itm != null) {
                    iname = itm.getStringValue();
                }
                iname = iname != null ? strings.get("game.specitem.sc_wond." + iname) : "# " + gidx;
                if (level == 1) {
                    this.pi.printKeyed("game.specitem.sc_wond.started", pl.getName(), iname);
                } else {
                    this.pi.printKeyed("game.specitem.sc_wond.built", pl.getName(), level, iname);
                }
            } else {
                this.pi.printKeyed("game.specitem.sc_wond.decl");
            }
        }

        @Override
        public void playerSetSpecialItem(String typeKey, SOCGame ga, SOCPlayer pl, int gidx, int pidx, boolean isSet) {
            if (pl == null) {
                return;
            }
            if (!typeKey.equals("_SC_WOND")) {
                return;
            }
            SOCHandPanel hp = this.pi.getPlayerHandPanel(pl.getPlayerNumber());
            if (hp != null) {
                hp.updateValue(PlayerClientListener.UpdateType.WonderLevel);
            }
        }

        @Override
        public void scen_SC_PIRI_pirateFortressAttackResult(boolean wasRejected, int defStrength, int resultShipsLost) {
            String resDesc2;
            String resDesc;
            if (wasRejected) {
                this.pi.printKeyed("game.sc_piri.attfort.cannot");
                return;
            }
            SOCGame ga = this.pi.getGame();
            SOCPlayer cpl = ga.getPlayer(ga.getCurrentPlayerNumber());
            SOCFortress fort = cpl.getFortress();
            String cplName = cpl.getName();
            this.pi.printKeyed("game.sc_piri.attfort.attacked", cplName, defStrength);
            switch (resultShipsLost) {
                case 0: {
                    resDesc = "game.sc_piri.attfort.wins";
                    break;
                }
                case 1: {
                    resDesc = "game.sc_piri.attfort.ties";
                    break;
                }
                default: {
                    resDesc = "game.sc_piri.attfort.loses";
                }
            }
            resDesc = strings.get(resDesc, cplName);
            this.pi.print(resDesc, true);
            if (resultShipsLost == 0) {
                resDesc2 = fort == null ? strings.get("game.sc_piri.attfort.wins.recaptured", cplName) : strings.get("game.sc_piri.attfort.n.more.attacks", fort.getStrength());
                this.pi.print(resDesc2, true);
            } else {
                resDesc2 = null;
            }
            if (resultShipsLost == 0 || this.pi.isClientCurrentPlayer()) {
                if (resultShipsLost > 0) {
                    this.pi.playSound(SOUND_RSRC_LOST);
                }
                StringBuffer sb = new StringBuffer(strings.get("game.sc_piri.attfort.results"));
                sb.append('\n');
                sb.append(strings.get("game.sc_piri.attfort.def.strength", defStrength));
                sb.append('\n');
                sb.append(resDesc);
                if (resDesc2 != null) {
                    sb.append('\n');
                    sb.append(resDesc2);
                }
                String s = sb.toString();
                NotifyDialog nd = new NotifyDialog(this.pi.getMainDisplay(), this.pi, s, null, true);
                nd.setNonBlockingDialogDismissListener(this.pi);
                this.pi.nbdForEvent = nd;
                EventQueue.invokeLater(nd);
            }
        }

        @Override
        public void robberMoved(int newHex, boolean isPirate) {
            this.pi.updateAtRobberMoved(newHex, isPirate);
        }

        @Override
        public void devCardDeckUpdated() {
            this.pi.updateDevCardCount();
        }

        @Override
        public void requestedDiscard(int countToDiscard) {
            this.pi.showDiscardOrGainDialog(countToDiscard, true);
        }

        @Override
        public void promptPickResources(int countToPick) {
            this.pi.showDiscardOrGainDialog(countToPick, false);
        }

        @Override
        public void playerDiscarded(SOCPlayer player, ResourceSet discards) {
            this.pi.reportDiscard(player, discards);
        }

        @Override
        public void requestedChoosePlayer(List<SOCPlayer> choices, boolean isNoneAllowed) {
            int[] pnums = new int[choices.size() + (isNoneAllowed ? 1 : 0)];
            int i = 0;
            for (SOCPlayer p : choices) {
                pnums[i++] = p.getPlayerNumber();
            }
            this.pi.showChoosePlayerDialog(choices.size(), pnums, isNoneAllowed);
        }

        @Override
        public void requestedChooseRobResourceType(SOCPlayer player) {
            this.pi.showChooseRobClothOrResourceDialog(player.getPlayerNumber());
        }

        @Override
        public void reportRobberyResult(int perpPN, int victimPN, int resType, SOCResourceSet resSet, SOCPlayerElement.PEType peType, boolean isGainLose, int amount, int victimAmount, int extraValue) {
            this.pi.reportRobberyResult(perpPN, victimPN, resType, resSet, peType, isGainLose, amount, victimAmount, extraValue);
        }

        @Override
        public void playerBankTrade(SOCPlayer player, SOCResourceSet give, SOCResourceSet get) {
            this.requestedTradeClear(player, true);
            this.playerElementUpdated(player, PlayerClientListener.UpdateType.ResourceTotalAndDetails, false, false);
            this.pi.printTradeResources(player, give, get, false, null);
        }

        @Override
        public void requestedTrade(SOCPlayer offerer, int fromPN) {
            this.pi.getPlayerHandPanel(offerer.getPlayerNumber()).updateCurrentOffer(true, false);
            SOCTradeOffer offer = offerer.getCurrentOffer();
            if (offer != null) {
                this.pi.printTradeResources(offerer, offer.getGiveSet(), offer.getGetSet(), true, null);
            }
        }

        @Override
        public void requestedTradeClear(SOCPlayer offerer, boolean isBankTrade) {
            if (isBankTrade && !this.pi.bankTradeWasFromTradePanel) {
                return;
            }
            if (offerer != null) {
                this.pi.getPlayerHandPanel(offerer.getPlayerNumber()).updateCurrentOffer(false, false);
            } else {
                for (int i = 0; i < this.pi.game.maxPlayers; ++i) {
                    this.pi.getPlayerHandPanel(i).updateCurrentOffer(false, false);
                }
            }
        }

        @Override
        public void requestedTradeRejection(SOCPlayer rejecter) {
            this.pi.getPlayerHandPanel(rejecter.getPlayerNumber()).rejectOfferShowNonClient();
        }

        @Override
        public void playerTradeAccepted(SOCPlayer offerer, SOCPlayer acceptor, SOCResourceSet toOffering, SOCResourceSet toAccepting) {
            if (toOffering == null) {
                SOCTradeOffer offer = offerer.getCurrentOffer();
                if (offer == null) {
                    return;
                }
                toAccepting = offer.getGiveSet();
                toOffering = offer.getGetSet();
            } else {
                this.playerElementUpdated(offerer, PlayerClientListener.UpdateType.ResourceTotalAndDetails, false, false);
                this.playerElementUpdated(acceptor, PlayerClientListener.UpdateType.ResourceTotalAndDetails, false, false);
            }
            if (toOffering != null) {
                this.pi.printTradeResources(offerer, toAccepting, toOffering, false, acceptor);
            }
        }

        @Override
        public void playerTradeDisallowed(int offeringPN, boolean isOffer, boolean isNotTurn) {
            this.pi.printKeyed(isNotTurn ? "base.reply.not.your.turn" : (isOffer ? "trade.msg.cant.make.offer" : "reply.common.trade.cannot_make"));
        }

        @Override
        public void requestedTradeReset(SOCPlayer playerToReset) {
            int pn = playerToReset != null ? playerToReset.getPlayerNumber() : -1;
            this.pi.hideHandMessage(pn);
        }

        @Override
        public void clearTradeOffer(SOCPlayer player, boolean updateSendCheckboxes) {
            if (player != null) {
                this.pi.hands[player.getPlayerNumber()].clearOffer(updateSendCheckboxes);
            } else {
                for (SOCHandPanel hp : this.pi.hands) {
                    hp.clearOffer(updateSendCheckboxes);
                }
            }
        }

        @Override
        public void requestedDiceRoll(int pn) {
            this.pi.updateAtRollPrompt(pn);
        }

        @Override
        public void debugFreePlaceModeToggled(boolean isEnabled) {
            this.pi.setDebugFreePlacementMode(isEnabled);
        }
    }
}

