/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import soc.client.AskDialog;
import soc.client.MainDisplay;
import soc.client.SOCPlayerInterface;
import soc.game.SOCGame;

class SOCQuitConfirmDialog
extends AskDialog {
    public static void createAndShow(MainDisplay md, SOCPlayerInterface gamePI) throws IllegalArgumentException {
        if (md == null || gamePI == null) {
            throw new IllegalArgumentException("no nulls");
        }
        SOCGame ga = gamePI.getGame();
        boolean gaOver = ga.getGameState() >= 1000 || gamePI.gameHasErrorOrDeletion;
        SOCQuitConfirmDialog qcd = new SOCQuitConfirmDialog(md, gamePI, gaOver);
        qcd.setVisible(true);
    }

    private SOCQuitConfirmDialog(MainDisplay md, SOCPlayerInterface gamePI, boolean gameIsOver) {
        super(md, gamePI, strings.get("dialog.quit.really", gamePI.getGame().getName()), strings.get(gameIsOver ? "dialog.quit.finished" : "dialog.quit.being.played"), strings.get("dialog.quit.this"), strings.get(gameIsOver ? "dialog.quit.dont" : "dialog.base.continue.playing"), gamePI.getGame().getGameState() != 0 && !gamePI.gameHasErrorOrDeletion ? strings.get("dialog.quit.reset.board") : null, gameIsOver ? 1 : 2);
    }

    @Override
    public void button1Chosen() {
        this.pi.leaveGame();
    }

    @Override
    public void button2Chosen() {
    }

    @Override
    public void button3Chosen() {
        this.pi.resetBoardRequest(false);
    }

    @Override
    public void windowCloseChosen() {
    }
}

