/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import soc.client.ColorSquare;
import soc.client.ColorSquareLarger;
import soc.client.GameMessageSender;
import soc.client.PlayerClientListener;
import soc.client.SOCPlayerInterface;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.game.SOCSpecialItem;
import soc.util.SOCStringManager;

class SOCSpecialItemDialog
extends JDialog
implements ActionListener {
    private static final SOCStringManager strings = SOCStringManager.getClientManager();
    private final String typeKey;
    private JButton[] buttons;
    private JButton bClose;
    private final SOCPlayerInterface pi;
    private final SOCGame ga;
    private PlayerClientListener.NonBlockingDialogDismissListener nbddListener;
    private volatile boolean nbddListenerCalled = false;
    private boolean didSetLocation;

    public SOCSpecialItemDialog(SOCPlayerInterface pi, String typeKey) throws IllegalArgumentException {
        super(pi, "Special Items", true);
        try {
            this.setTitle(strings.get("dialog.specitem." + typeKey + ".title"));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (!"_SC_WOND".equals(typeKey)) {
            throw new IllegalArgumentException(typeKey);
        }
        this.pi = pi;
        this.typeKey = typeKey;
        int px3 = 3 * pi.displayScale;
        Container cpane = this.getContentPane();
        if (!(cpane instanceof JPanel)) {
            cpane = new JPanel();
            this.setContentPane(cpane);
        }
        ((JPanel)cpane).setBorder(new EmptyBorder(2 * px3, 2 * px3, px3, 2 * px3));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.fill = 2;
        this.setLayout(gbl);
        Insets insPadLR = new Insets(0, px3, 0, px3);
        Insets insPadL = new Insets(0, px3, 0, 0);
        Insets insPadBottom = new Insets(0, 0, 5 * px3, 0);
        Insets insNone = gbc.insets;
        this.ga = pi.getGame();
        int numWonders = 1 + this.ga.maxPlayers;
        SOCPlayer cliPlayer = pi.getClientPlayer();
        this.didSetLocation = false;
        JLabel subtitle_prompt = new JLabel(strings.get("dialog.specitem._SC_WOND.subtitle"));
        subtitle_prompt.setHorizontalAlignment(0);
        gbc.gridwidth = 0;
        gbl.setConstraints(subtitle_prompt, gbc);
        cpane.add(subtitle_prompt);
        JLabel L = new JLabel(" ");
        gbc.gridwidth = 0;
        gbl.setConstraints(L, gbc);
        cpane.add(L);
        L = new JLabel(strings.get("dialog.specitem._SC_WOND.wonder"));
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbl.setConstraints(L, gbc);
        cpane.add(L);
        L = new JLabel(strings.get("dialog.specitem.cost"));
        gbc.gridx = -1;
        gbc.gridwidth = 5;
        gbl.setConstraints(L, gbc);
        cpane.add(L);
        L = new JLabel(strings.get("dialog.specitem._SC_WOND.requires"));
        L.setBorder(new EmptyBorder(0, 3, 0, 3));
        gbc.insets = insPadLR;
        gbc.gridwidth = 0;
        gbl.setConstraints(L, gbc);
        cpane.add(L);
        this.buttons = new JButton[numWonders];
        boolean playerOwnsWonder = cliPlayer != null && cliPlayer.getSpecialItem("_SC_WOND", 0) != null;
        boolean hasStartingCostShip = false;
        try {
            if (cliPlayer != null && !playerOwnsWonder) {
                hasStartingCostShip = this.ga.getSpecialItem(typeKey, 1).checkStartingCostPiecetype(cliPlayer, false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String buildStr = strings.get("base.build");
        if (this.ga.getGameState() < 5) {
            subtitle_prompt.setText(strings.get("dialog.specitem.start_game"));
        } else if (cliPlayer != null && !playerOwnsWonder) {
            subtitle_prompt.setText(strings.get(hasStartingCostShip ? "dialog.specitem._SC_WOND.prompt" : "dialog.specitem._SC_WOND.starting_cost"));
        }
        for (int i = 0; i < numWonders; ++i) {
            String wname;
            boolean playerCanBuildThis;
            boolean playerOwnsThis;
            SOCSpecialItem itm = this.ga.getSpecialItem(typeKey, i + 1);
            if (itm == null) continue;
            gbc.gridwidth = 1;
            SOCPlayer owner = itm.getPlayer();
            boolean bl = playerOwnsThis = playerOwnsWonder && owner == cliPlayer;
            boolean bl2 = this.ga.getGameState() >= 20 && this.ga.getGameState() < 1000 && playerOwnsWonder ? playerOwnsThis && itm.checkCost(cliPlayer) : (playerCanBuildThis = owner == null && hasStartingCostShip && itm.checkRequirements(cliPlayer, true));
            if (playerOwnsThis || !playerOwnsWonder) {
                JButton b = new JButton(buildStr);
                if (playerCanBuildThis) {
                    b.addActionListener(this);
                } else {
                    b.setEnabled(false);
                }
                gbc.insets = insPadL;
                gbl.setConstraints(b, gbc);
                cpane.add(b);
                this.buttons[i] = b;
            }
            gbc.insets = insPadLR;
            gbc.gridx = 1;
            try {
                wname = strings.get("game.specitem.sc_wond." + itm.getStringValue());
            }
            catch (MissingResourceException e) {
                wname = "WONDERNAME_" + (i + 1);
            }
            L = new JLabel(wname);
            gbl.setConstraints(L, gbc);
            cpane.add(L);
            Font labelFont = L.getFont();
            gbc.gridx = -1;
            gbc.insets = insNone;
            SOCResourceSet cost = itm.getCost();
            for (int j = 0; j < 5; ++j) {
                ColorSquareLarger sq = new ColorSquareLarger(0, false, ColorSquare.RESOURCE_COLORS[j]);
                sq.setIntValue(cost != null ? cost.getAmount(j + 1) : 0);
                gbl.setConstraints(sq, gbc);
                cpane.add(sq);
            }
            gbc.insets = insPadLR;
            JComponent itmDesc = this.buildRequirementsText(itm.req);
            if (itmDesc instanceof JTextArea) {
                itmDesc.setFont(labelFont);
            }
            gbc.gridwidth = 0;
            gbl.setConstraints(itmDesc, gbc);
            cpane.add(itmDesc);
            gbc.insets = insPadBottom;
            L = new JLabel();
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbl.setConstraints(L, gbc);
            cpane.add(L);
            StringBuffer sb = new StringBuffer();
            if (owner != null) {
                sb.append(strings.get("dialog.specitem._SC_WOND.builder", owner.getName()));
            }
            if (itm.getLevel() > 0) {
                if (owner != null) {
                    sb.append(" - ");
                }
                sb.append(strings.get("dialog.specitem._SC_WOND.current_level", itm.getLevel(), 4));
            }
            L = new JLabel(sb.toString());
            gbc.gridx = -1;
            gbc.gridwidth = 0;
            gbl.setConstraints(L, gbc);
            cpane.add(L);
        }
        if (hasStartingCostShip) {
            L = new JLabel(strings.get("dialog.specitem._SC_WOND.starting_cost"));
            gbc.insets = insPadLR;
            gbc.gridwidth = 0;
            gbl.setConstraints(L, gbc);
            cpane.add(L);
        }
        this.bClose = new JButton(strings.get("base.close"));
        this.bClose.addActionListener(this);
        JPanel bPan = new JPanel(new FlowLayout(1));
        bPan.add(this.bClose);
        gbc.gridwidth = 0;
        gbl.setConstraints(bPan, gbc);
        cpane.add(bPan);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (SOCSpecialItemDialog.this.nbddListener != null && !SOCSpecialItemDialog.this.nbddListenerCalled) {
                    SOCSpecialItemDialog.this.nbddListenerCalled = true;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SOCSpecialItemDialog.this.nbddListener.dialogDismissed(SOCSpecialItemDialog.this, true);
                        }
                    });
                }
            }
        });
        this.getRootPane().setDefaultButton(this.bClose);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SOCSpecialItemDialog.this.nbddListenerCalled = true;
                SOCSpecialItemDialog.this.dispose();
                if (SOCSpecialItemDialog.this.nbddListener != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SOCSpecialItemDialog.this.nbddListener.dialogDismissed(SOCSpecialItemDialog.this, true);
                        }
                    });
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        super.pack();
        this.setSize(400, 400);
        this.validate();
    }

    private JComponent buildRequirementsText(List<SOCSpecialItem.Requirement> reqs) {
        JComponent ret;
        if (reqs == null || reqs.isEmpty()) {
            return new JLabel("");
        }
        int n = reqs.size();
        String[] descStrings = new String[n];
        for (int i = 0; i < n; ++i) {
            String reqStr;
            SOCSpecialItem.Requirement req = reqs.get(i);
            switch (req.reqType) {
                case 'C': 
                case 'S': {
                    String sLoc;
                    if (req.atPort) {
                        sLoc = strings.get("game.aport");
                    } else if (req.atCoordList != null) {
                        try {
                            sLoc = strings.get("board.nodelist._SC_WOND." + req.atCoordList);
                        }
                        catch (MissingResourceException e) {
                            sLoc = req.atCoordList;
                        }
                    } else {
                        sLoc = null;
                    }
                    String sKey = req.reqType == 'C' ? (sLoc != null ? "specitem.req.c.at" : "specitem.req.c") : (sLoc != null ? "specitem.req.s.at" : "specitem.req.s");
                    reqStr = strings.get(sKey, req.count, sLoc);
                    break;
                }
                case 'L': {
                    reqStr = strings.get("specitem.req.rl", req.count);
                    break;
                }
                default: {
                    reqStr = strings.get("specitem.req.vp", req.count);
                }
            }
            descStrings[i] = reqStr;
        }
        if (n == 1) {
            ret = new JLabel(descStrings[0]);
        } else {
            StringBuilder sb = new StringBuilder(descStrings[0]);
            for (int i = 1; i < n; ++i) {
                sb.append("\n");
                sb.append(descStrings[i]);
            }
            JTextArea pmsg = new JTextArea(sb.toString());
            pmsg.setEditable(false);
            pmsg.setLineWrap(true);
            pmsg.setWrapStyleWord(true);
            ret = pmsg;
        }
        ret.setBorder(new EmptyBorder(0, 3, 0, 3));
        ret.setBackground(null);
        ret.setForeground(null);
        return ret;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        try {
            if (!this.didSetLocation) {
                int piX = this.pi.getInsets().left;
                int piY = this.pi.getInsets().top;
                int piWidth = this.pi.getSize().width - piX - this.pi.getInsets().right;
                this.setLocation((piX += this.pi.getLocation().x) + (piWidth - this.getWidth()) / 2, (piY += this.pi.getLocation().y) + 50);
                this.didSetLocation = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            int i;
            Object src = e.getSource();
            if (src == null) {
                return;
            }
            if (src == this.bClose) {
                this.nbddListenerCalled = true;
                this.dispose();
                if (this.nbddListener != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SOCSpecialItemDialog.this.nbddListener.dialogDismissed(SOCSpecialItemDialog.this, true);
                        }
                    });
                }
                return;
            }
            for (i = 0; i < this.buttons.length && src != this.buttons[i]; ++i) {
            }
            if (i < this.buttons.length) {
                int cpn;
                GameMessageSender messageSender = this.pi.getClient().getGameMessageSender();
                boolean askedSBP = false;
                if (!this.pi.isClientCurrentPlayer() && (cpn = this.pi.getClientPlayerNumber()) != -1 && this.ga.canAskSpecialBuild(cpn, false)) {
                    messageSender.buildRequest(this.ga, -1);
                    askedSBP = true;
                }
                if (!askedSBP) {
                    messageSender.pickSpecialItem(this.ga, this.typeKey, 1 + i, 0);
                }
                this.nbddListenerCalled = true;
                this.dispose();
                if (this.nbddListener != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SOCSpecialItemDialog.this.nbddListener.dialogDismissed(SOCSpecialItemDialog.this, false);
                        }
                    });
                }
            }
        }
        catch (Exception ex) {
            this.pi.chatPrintStackTrace(ex);
        }
    }

    public void setNonBlockingDialogDismissListener(PlayerClientListener.NonBlockingDialogDismissListener li) {
        this.nbddListener = li;
    }
}

