/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCVersionedItem;
import soc.message.SOCGameOptionInfo;

public class ServerGametypeInfo {
    public final boolean isForPractice;
    public boolean allOptionsReceived = false;
    public boolean newGameWaitingForOpts = false;
    public String gameInfoWaitingForOpts = null;
    public SOCGameOptionSet knownOpts = null;
    private SOCGameOptionSet newGameOpts = null;
    public boolean askedDefaultsAlready = false;
    public boolean defaultsReceived = false;
    public long askedDefaultsTime;
    public boolean allScenStringsReceived = false;
    public boolean allScenInfoReceived = false;
    public HashSet<String> scenKeys;
    private final Object getNewGameSync = new Object();

    public ServerGametypeInfo(boolean isForPractice) {
        this.isForPractice = isForPractice;
        this.knownOpts = SOCGameOptionSet.getAllKnownOptions();
        this.scenKeys = new HashSet();
    }

    public void noMoreOptions(boolean askedDefaults) {
        this.allOptionsReceived = true;
        if (askedDefaults) {
            this.defaultsReceived = true;
            this.askedDefaultsAlready = true;
            this.askedDefaultsTime = System.currentTimeMillis();
        }
    }

    public List<String> receiveDefaults(Map<String, SOCGameOption> servOpts, int servVersion) {
        HashSet<String> prevKnown = null;
        if (this.knownOpts == null || this.knownOpts.isEmpty()) {
            this.knownOpts = new SOCGameOptionSet(servOpts);
        } else {
            prevKnown = new HashSet<String>();
            if (servOpts != null) {
                for (String oKey : servOpts.keySet()) {
                    SOCGameOption op = SOCGameOption.copyDefaults(servOpts.get(oKey));
                    if (this.knownOpts.put(op) == null) continue;
                    prevKnown.add(oKey);
                }
            }
        }
        for (SOCGameOption opt : this.knownOpts) {
            SOCGameOption ngOpt;
            if (opt.optType == 0 || !opt.hasFlag(64) || servVersion < opt.minVersion) continue;
            if (!opt.getBoolValue()) {
                opt.setBoolValue(true);
            }
            if (this.newGameOpts == null || (ngOpt = this.newGameOpts.get(opt.key)) == null || ngOpt.getBoolValue()) continue;
            ngOpt.setBoolValue(true);
        }
        List<String> unknowns = servOpts != null ? SOCVersionedItem.findUnknowns(servOpts, prevKnown) : null;
        this.allOptionsReceived = unknowns == null;
        this.defaultsReceived = true;
        return unknowns;
    }

    public boolean receiveInfo(SOCGameOptionInfo gi) {
        boolean isUnknown;
        SOCGameOption oinfo = gi.getOptionInfo();
        boolean bl = isUnknown = oinfo.optType == 0;
        if (oinfo.key.equals("-") && isUnknown) {
            this.noMoreOptions(false);
            return true;
        }
        this.knownOpts.addKnownOption(oinfo);
        if (this.newGameOpts != null) {
            this.newGameOpts.addKnownOption(oinfo);
        }
        if (isUnknown) {
            this.knownOpts.put(oinfo);
            if (this.newGameOpts != null) {
                this.newGameOpts.remove(oinfo.key);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOCGameOptionSet getNewGameOpts() {
        Object object = this.getNewGameSync;
        synchronized (object) {
            if (this.newGameOpts == null && this.knownOpts != null) {
                this.newGameOpts = new SOCGameOptionSet(this.knownOpts, true);
            }
            return this.newGameOpts;
        }
    }
}

