/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import soc.client.SwingMainDisplay;

class ShadowedBox
extends JPanel {
    public static final int SHADOW_SIZE = 5;
    int height = 50;
    int width = 50;
    Color interior;
    private final int displayScale;

    public ShadowedBox(Color bg, Color interior, int displayScale, LayoutManager lm) {
        super(lm);
        this.displayScale = displayScale;
        if (interior != null) {
            this.setBackground(bg);
            this.setForeground(Color.black);
            this.interior = interior;
        } else {
            Color[] sysColors = SwingMainDisplay.getForegroundBackgroundColors(false, true);
            interior = sysColors[2];
            this.setBackground(interior);
            this.setForeground(sysColors[0]);
            this.interior = interior;
        }
        this.setOpaque(true);
        Dimension initSize = new Dimension(this.width, this.height);
        this.setSize(initSize);
        this.setMinimumSize(initSize);
        this.setPreferredSize(initSize);
    }

    public void setInterior(Color interior) {
        this.interior = interior;
    }

    public Color getInterior() {
        return this.interior;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension dim = this.getSize();
        int h = dim.height;
        int w = dim.width;
        int xm = 5 * this.displayScale;
        int ym = 5 * this.displayScale;
        g.setPaintMode();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        g.setColor(this.interior);
        g.fillRect(0, 0, w - xm, h - ym);
        g.setColor(Color.black);
        g.drawRect(0, 0, w - xm, h - ym);
        g.fillRect(ym, h - xm, w, h - 1);
        g.fillRect(w - ym, xm, w - 1, h);
    }
}

