/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.TextArea;
import soc.client.SOCPlayerClient;

class SnippingTextArea
extends TextArea {
    static final boolean isJava142 = System.getProperty("java.version").startsWith("1.4.2");
    static final boolean isJavaOnOSX105 = SOCPlayerClient.IS_PLATFORM_MAC_OSX && System.getProperty("os.version").startsWith("10.");
    int maximumLines = 100;
    int lines = 0;

    public SnippingTextArea(int rows, int columns, int maxLines) {
        this("", rows, columns, 1, maxLines);
    }

    public SnippingTextArea(String text, int maxLines) {
        this("", 40, 80, 1, maxLines);
    }

    public SnippingTextArea(String text, int rows, int columns, int scrollbars, int maxLines) {
        super(text, rows, columns, scrollbars);
        this.maximumLines = maxLines;
        this.lines = 1;
        this.lines += SnippingTextArea.countNewLines(text);
    }

    public int getMaximumLines() {
        return this.maximumLines;
    }

    public void setMaximumLines(int newMax) {
        this.maximumLines = newMax;
        this.snipText();
    }

    public int lines() {
        return this.lines;
    }

    @Override
    public synchronized void setText(String newString) {
        super.setText(newString);
        this.lines = SnippingTextArea.countNewLines(newString);
        this.snipText();
    }

    @Override
    public synchronized void replaceRange(String newString, int x, int y) {
        this.lines -= SnippingTextArea.countNewLines(this.getText().substring(x, y));
        super.replaceRange(newString, x, y);
        this.lines += SnippingTextArea.countNewLines(newString);
        this.snipText();
    }

    @Override
    public synchronized void insert(String newString, int x) {
        super.insert(newString, x);
        this.lines += SnippingTextArea.countNewLines(newString);
        this.snipText();
    }

    @Override
    public synchronized void append(String newString) {
        super.append(newString);
        this.lines += SnippingTextArea.countNewLines(newString);
        this.snipText();
    }

    protected static int countNewLines(String s) {
        int nLines = 0;
        int last = -1;
        while ((last = s.indexOf(10, last + 1)) > -1) {
            ++nLines;
        }
        return nLines;
    }

    public void snipText() {
        if (isJavaOnOSX105) {
            return;
        }
        try {
            while (this.lines > this.maximumLines) {
                String s = this.getText();
                int nextLine = s.indexOf(10) + 1;
                if (isJava142) {
                    super.setText(s.substring(nextLine));
                } else {
                    super.replaceRange("", 0, nextLine);
                }
                --this.lines;
            }
            if (this.isDisplayable()) {
                this.setCaretPosition(this.getText().length());
            }
        }
        catch (Throwable th) {
            System.out.println("snipText ERROR - " + th.getMessage());
            th.printStackTrace();
        }
    }
}

