/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class Sounds {
    public static final float SAMPLE_RATE_HZ = 44100.0f;
    public static final int NOTE_C4_HZ = 262;
    public static final int NOTE_E4_HZ = 330;
    public static final int NOTE_A5_HZ = 880;
    public static final int NOTE_B5_HZ = 988;
    private static final double PI_X_2 = Math.PI * 2;
    private static final AudioFormat AFMT_PCM_16_AT_SAMPLE_RATE = new AudioFormat(44100.0f, 16, 1, true, false);
    private static SourceDataLine playPCM_sdl;

    public static final int bufferLen(int msec) {
        return 2 * msec * 44100 / 1000;
    }

    public static int genChime(int hz, int msec, double vol, byte[] buf, int i0, boolean overlay) throws IllegalArgumentException, NullPointerException {
        int rmax;
        int amax;
        int imax = Sounds.bufferLen(msec) / 2;
        if (buf.length < i0 + 2 * imax) {
            throw new IllegalArgumentException("buf too short");
        }
        int ib = i0;
        int iSa = ib / 2;
        if (msec >= 40) {
            amax = 441;
            double vol0 = 0.8 * vol;
            double dVol = vol - vol0;
            int i = 0;
            while (i < amax) {
                double angle = (double)((float)iSa / (44100.0f / (float)hz)) * (Math.PI * 2);
                short val = (short)(Math.sin(angle) * 32767.0 * (vol0 + dVol * (double)i / (double)amax));
                if (overlay) {
                    short vWith = (short)(buf[ib] & 0xFF | buf[ib + 1] << 8);
                    val = (short)(val + vWith);
                }
                buf[ib] = (byte)(val & 0xFF);
                buf[++ib] = (byte)(val >> 8 & 0xFF);
                ++ib;
                ++i;
                ++iSa;
            }
        } else {
            amax = 0;
        }
        int i = rmax = imax - amax;
        while (i > 0) {
            double angle = (double)((float)iSa / (44100.0f / (float)hz)) * (Math.PI * 2);
            short val = (short)(Math.sin(angle) * (32767.0 * vol * (double)i / (double)rmax));
            if (overlay) {
                short vWith = (short)(buf[ib] & 0xFF | buf[ib + 1] << 8);
                val = (short)(val + vWith);
            }
            buf[ib] = (byte)(val & 0xFF);
            buf[++ib] = (byte)(val >> 8 & 0xFF);
            ++ib;
            --i;
            ++iSa;
        }
        return ib;
    }

    public static byte[] genChime(int hz, int msec, double vol) throws IllegalArgumentException {
        if (msec > 1000) {
            throw new IllegalArgumentException("msec");
        }
        byte[] buf = new byte[Sounds.bufferLen(msec)];
        Sounds.genChime(hz, msec, vol, buf, 0, false);
        return buf;
    }

    public static void chime(int hz, int msec, double vol) throws IllegalArgumentException, LineUnavailableException {
        Sounds.playPCMBytes(Sounds.genChime(hz, msec, vol));
    }

    public static int genTone(int hz, int msec, double vol, byte[] buf, int i0) throws IllegalArgumentException, NullPointerException {
        int imax = Sounds.bufferLen(msec) / 2;
        if (buf.length < i0 + 2 * imax) {
            throw new IllegalArgumentException("buf too short");
        }
        double vol_x_32767 = 32767.0 * vol;
        int ib = i0;
        int iSa = ib / 2;
        int i = 0;
        while (i < imax) {
            double angle = (double)((float)iSa / (44100.0f / (float)hz)) * (Math.PI * 2);
            short val = (short)(Math.sin(angle) * vol_x_32767);
            buf[ib] = (byte)(val & 0xFF);
            buf[++ib] = (byte)(val >> 8 & 0xFF);
            ++ib;
            ++i;
            ++iSa;
        }
        return ib;
    }

    public static byte[] genTone(int hz, int msec, double vol) throws IllegalArgumentException {
        if (msec > 1000) {
            throw new IllegalArgumentException("msec");
        }
        byte[] buf = new byte[Sounds.bufferLen(msec)];
        Sounds.genTone(hz, msec, vol, buf, 0);
        return buf;
    }

    public static void tone(int hz, int msec, double vol) throws IllegalArgumentException, LineUnavailableException {
        Sounds.playPCMBytes(Sounds.genTone(hz, msec, vol));
    }

    public static final Clip toClip(byte[] pcmBytes) {
        try {
            Clip c = AudioSystem.getClip();
            SourceDataLine sdl = playPCM_sdl;
            if (sdl == null) {
                playPCM_sdl = sdl = AudioSystem.getSourceDataLine(AFMT_PCM_16_AT_SAMPLE_RATE);
            }
            c.open(AFMT_PCM_16_AT_SAMPLE_RATE, pcmBytes, 0, pcmBytes.length);
            return c;
        }
        catch (LineUnavailableException e1) {
            return null;
        }
    }

    public static final void playPCMBytes(byte[] buf) throws LineUnavailableException {
        SourceDataLine sdl = playPCM_sdl;
        if (sdl != null) {
            try {
                sdl.open(AFMT_PCM_16_AT_SAMPLE_RATE);
            }
            catch (Exception e) {
                sdl = null;
            }
        }
        if (sdl == null) {
            playPCM_sdl = sdl = AudioSystem.getSourceDataLine(AFMT_PCM_16_AT_SAMPLE_RATE);
            sdl.open(AFMT_PCM_16_AT_SAMPLE_RATE);
        }
        sdl.start();
        sdl.write(buf, 0, buf.length);
        sdl.drain();
        sdl.stop();
        sdl.close();
    }

    public static final void main(String[] args) {
        try {
            Sounds.tone(880, 180, 0.9);
            Thread.sleep(60L);
            Sounds.chime(880, 180, 0.9);
            Thread.sleep(60L);
            Sounds.chime(440, 270, 0.9);
            Thread.sleep(60L);
            byte[] buf = new byte[Sounds.bufferLen(600)];
            Sounds.genChime(880, 600, 0.5, buf, 0, false);
            Sounds.genChime(330, 600, 0.5, buf, 0, true);
            Clip c1 = Sounds.toClip(buf);
            buf = new byte[Sounds.bufferLen(210)];
            int i = Sounds.genChime(330, 120, 0.9, buf, 0, false);
            Sounds.genChime(262, 90, 0.9, buf, i, false);
            Clip c2 = Sounds.toClip(buf);
            for (i = 0; i < 3; ++i) {
                c1.setFramePosition(0);
                c1.start();
                Thread.sleep(690L);
                c2.setFramePosition(0);
                c2.start();
                Thread.sleep(300L);
            }
            c1.close();
            c2.close();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
        }
    }
}

