/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import soc.client.SwingMainDisplay;

class SpeechBalloon
extends JPanel {
    public static final int SHADOW_SIZE = 5;
    public static final int BALLOON_POINT_SIZE = 12;
    private final Color behindColor;
    private final Color balloonColor;
    int height = 50;
    int width = 50;
    private boolean balloonPoint;
    private final int displayScale;

    public SpeechBalloon(Color behindColor, int displayScale, LayoutManager lm) {
        super(lm);
        this.behindColor = behindColor;
        this.displayScale = displayScale;
        Color[] colors = SwingMainDisplay.getForegroundBackgroundColors(true, false);
        if (colors == null) {
            colors = SwingMainDisplay.getForegroundBackgroundColors(false, true);
        }
        this.balloonColor = colors[2];
        this.setBackground(this.balloonColor);
        this.setForeground(colors[0]);
        this.balloonPoint = true;
        Dimension initSize = new Dimension(this.width, this.height);
        this.setSize(initSize);
        this.setMinimumSize(initSize);
        this.setPreferredSize(initSize);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public boolean getBalloonPoint() {
        return this.balloonPoint;
    }

    public void setBalloonPoint(boolean point) {
        if (this.balloonPoint == point) {
            return;
        }
        this.balloonPoint = point;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension dim = this.getSize();
        int h = dim.height;
        int w = dim.width;
        int xm = 5 * this.displayScale;
        int ym = 5 * this.displayScale;
        int bpSize = 12 * this.displayScale;
        g.setPaintMode();
        if (this.behindColor != null) {
            g.setColor(this.behindColor);
            g.fillRect(0, 0, w, h);
        }
        g.setColor(this.balloonColor);
        if (this.balloonPoint) {
            int[] xPoints = new int[]{0, bpSize, bpSize, 84 * this.displayScale / 4, w - xm, w - xm, 0, 0};
            int[] yPoints = new int[]{bpSize, bpSize, 0, bpSize, bpSize, h - ym, h - ym, bpSize};
            g.fillPolygon(xPoints, yPoints, 8);
            g.setColor(Color.BLACK);
            g.drawPolygon(xPoints, yPoints, 8);
        } else {
            g.fillRect(0, bpSize, w - xm, h - ym - bpSize);
            g.setColor(Color.BLACK);
            g.drawRect(0, bpSize, w - xm, h - ym - bpSize);
        }
        g.fillRect(ym, h - xm, w, h - 1);
        g.fillRect(w - ym, h / 6 + xm, w - 1, h);
    }
}

