/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import soc.client.ColorSquare;
import soc.client.ColorSquareListener;
import soc.client.SOCHandPanel;
import soc.game.ResourceSet;

class SquaresPanel
extends JPanel
implements MouseListener,
ColorSquareListener {
    public static final int WIDTH_PX = 96;
    public static final int HEIGHT_PX = 39;
    private final Dimension size;
    private ColorSquare[] give;
    private ColorSquare[] get;
    boolean interactive;
    boolean notAllZero;
    SOCHandPanel parentHand;
    private final int displayScale;
    private static final int shiftKeysMask = 960;

    public SquaresPanel(boolean in, int displayScale) {
        this(in, null, displayScale);
    }

    public SquaresPanel(boolean in, SOCHandPanel hand, int displayScale) {
        super(null);
        this.displayScale = displayScale;
        this.interactive = in;
        this.notAllZero = false;
        this.parentHand = hand;
        this.setFont(new Font("SansSerif", 0, 10 * displayScale));
        this.give = new ColorSquare[5];
        this.get = new ColorSquare[5];
        int sqSize = 20 * displayScale;
        for (int i = 0; i < 5; ++i) {
            Color sqColor = ColorSquare.RESOURCE_COLORS[i];
            this.get[i] = new ColorSquare(0, in, sqSize, sqSize, sqColor);
            this.give[i] = new ColorSquare(0, in, sqSize, sqSize, sqColor);
            this.add(this.get[i]);
            this.add(this.give[i]);
            this.get[i].setSquareListener(this);
            this.get[i].addMouseListener(this);
            this.give[i].setSquareListener(this);
            this.give[i].addMouseListener(this);
        }
        this.size = new Dimension(96 * displayScale, 39 * displayScale);
        this.setSize(this.size);
        this.setMinimumSize(this.size);
        this.setPreferredSize(this.size);
    }

    public void setInteractive(boolean inter) {
        if (inter == this.interactive) {
            return;
        }
        this.interactive = inter;
        for (int i = 0; i < 5; ++i) {
            this.get[i].setInteractive(inter);
            this.give[i].setInteractive(inter);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.size;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public void doLayout() {
        int lineH = 20 * this.displayScale - 1;
        int sqW = 20 * this.displayScale - 1;
        for (int i = 0; i < 5; ++i) {
            this.give[i].setSize(sqW + 1, lineH + 1);
            this.give[i].setLocation(i * sqW, 0);
            this.get[i].setSize(sqW + 1, lineH + 1);
            this.get[i].setLocation(i * sqW, lineH);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object target = e.getSource();
        if (!this.interactive) {
            return;
        }
        if (0 != (0x3C0 & e.getModifiersEx())) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            if (target == this.get[i] && this.give[i].getIntValue() > 0) {
                this.give[i].subtractValue(1);
                this.get[i].subtractValue(1);
                continue;
            }
            if (target != this.give[i] || this.get[i].getIntValue() <= 0) continue;
            this.get[i].subtractValue(1);
            this.give[i].subtractValue(1);
        }
    }

    public void setValues(int[] give, int[] get) {
        boolean notAllZ = false;
        for (int i = 0; i < 5; ++i) {
            this.give[i].setIntValue(give[i]);
            this.get[i].setIntValue(get[i]);
            if (give[i] == 0 && get[i] == 0) continue;
            notAllZ = true;
        }
        this.notAllZero = notAllZ;
    }

    public void setValues(ResourceSet give, ResourceSet get) {
        int i;
        int amt;
        int res;
        boolean notAllZ = false;
        if (give != null) {
            for (res = 1; res <= 5; ++res) {
                amt = give.getAmount(res);
                notAllZ |= amt != 0;
                this.give[res - 1].setIntValue(amt);
            }
        } else {
            for (i = 0; i < 5; ++i) {
                this.give[i].setIntValue(0);
            }
        }
        if (get != null) {
            for (res = 1; res <= 5; ++res) {
                amt = get.getAmount(res);
                notAllZ |= amt != 0;
                this.get[res - 1].setIntValue(amt);
            }
        } else {
            for (i = 0; i < 5; ++i) {
                this.get[i].setIntValue(0);
            }
        }
        this.notAllZero = notAllZ;
    }

    public void getValues(int[] giveRsrcs, int[] getRsrcs) {
        for (int i = 0; i < 5; ++i) {
            giveRsrcs[i] = this.give[i].getIntValue();
            getRsrcs[i] = this.get[i].getIntValue();
        }
    }

    public boolean containsNonZero() {
        return this.notAllZero;
    }

    @Override
    public void squareChanged(ColorSquare sq, int oldValue, int newValue) {
        boolean wasNotZero = this.notAllZero;
        if (newValue != 0) {
            this.notAllZero = true;
        } else {
            boolean notAllZ = false;
            for (int i = 0; i < 5; ++i) {
                if (0 != this.give[i].getIntValue()) {
                    notAllZ = true;
                    break;
                }
                if (0 == this.get[i].getIntValue()) continue;
                notAllZ = true;
                break;
            }
            this.notAllZero = notAllZ;
        }
        if (this.parentHand != null && wasNotZero != this.notAllZero) {
            this.parentHand.sqPanelZerosChange(this.notAllZero);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

