/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import soc.client.ChannelFrame;
import soc.client.ClientNetwork;
import soc.client.DataOutputUtils;
import soc.client.GameMessageSender;
import soc.client.MainDisplay;
import soc.client.NewGameOptionsFrame;
import soc.client.NotifyDialog;
import soc.client.PlayerClientListener;
import soc.client.SOCConnectOrPracticePanel;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.SOCPracticeAskDialog;
import soc.client.SOCQuitAllConfirmDialog;
import soc.client.ServerGametypeInfo;
import soc.client.UserPreferences;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCScenario;
import soc.game.SOCVersionedItem;
import soc.message.SOCAuthRequest;
import soc.message.SOCChannelTextMsg;
import soc.message.SOCGameOptionGetDefaults;
import soc.message.SOCGameOptionInfo;
import soc.message.SOCGameStats;
import soc.message.SOCJoinChannel;
import soc.message.SOCJoinGame;
import soc.message.SOCLocalizedStrings;
import soc.message.SOCMessage;
import soc.message.SOCNewGameWithOptionsRequest;
import soc.message.SOCScenarioInfo;
import soc.server.SOCServer;
import soc.util.SOCFeatureSet;
import soc.util.SOCGameList;
import soc.util.SOCStringManager;
import soc.util.Version;

public class SwingMainDisplay
extends JPanel
implements MainDisplay {
    public static final int DISPLAY_MIN_UNSCALED_HEIGHT = 768;
    public static final String PROP_JSETTLERS_UI_SCALE = "jsettlers.uiScale";
    public static final String PROP_JSETTLERS_UI_CONTRAST_MODE = "jsettlers.uiContrastMode";
    public static final Color DIALOG_BG_GOLDENROD = new Color(255, 230, 162);
    public static final Color JSETTLERS_BG_GREEN = new Color(97, 175, 113);
    public static final Color MISC_LABEL_FG_OFF_WHITE = new Color(252, 251, 243);
    private static final String MAIN_PANEL = "main";
    private static final String MESSAGE_PANEL = "message";
    private static final String CONNECT_OR_PRACTICE_PANEL = "connOrPractice";
    public final String NET_UNAVAIL_CAN_PRACTICE_MSG;
    public final String NEED_NICKNAME_BEFORE_JOIN;
    public final String NEED_NICKNAME_BEFORE_JOIN_2;
    public final String NEED_NICKNAME_BEFORE_JOIN_G;
    public final String NEED_NICKNAME_BEFORE_JOIN_G2;
    public final String STATUS_CANNOT_JOIN_THIS_GAME;
    private static boolean didScaleUIManagerFonts;
    private final SOCPlayerClient client;
    private final ClientNetwork net;
    private final int displayScale;
    private static boolean hasDeterminedOSColors;
    private static boolean isOSColorHighContrast;
    private static Color osColorText;
    private static Color osColorTextBG;
    private final Color miscLabelFGColor;
    private final Map<String, SOCPlayerInterface> playerInterfaces = new Hashtable<String, SOCPlayerInterface>();
    protected GameOptionsTimeoutTask gameOptsTask = null;
    protected GameOptionDefaultsTimeoutTask gameOptsDefsTask = null;
    protected boolean hasJoinedServer;
    protected final boolean hasConnectOrPractice;
    protected SOCConnectOrPracticePanel connectOrPracticePane;
    public NewGameOptionsFrame newGameOptsFrame = null;
    private final Hashtable<String, NewGameOptionsFrame> gameInfoFrames = new Hashtable();
    private JPanel mainPane;
    private GridBagLayout mainGBL;
    private GridBagConstraints mainGBC;
    private boolean mainPaneLayoutIsDone;
    private boolean mainPaneLayoutIsDone_hasChannels;
    protected JTextField nick;
    protected JPasswordField pass;
    protected JTextField status;
    private String statusOKText;
    protected JTextField channel;
    protected JList<JoinableListItem> chlist;
    protected JList<JoinableListItem> gmlist;
    protected JButton ng;
    protected JButton jc;
    protected JButton jg;
    protected JButton pg;
    protected JButton gi;
    private JLabel localTCPServerLabel;
    private JLabel versionOrlocalTCPPortLabel;
    protected JLabel messageLabel;
    protected JLabel messageLabel_top;
    protected JButton pgm;
    protected CardLayout cardLayout;
    protected Hashtable<String, ChannelFrame> channels = new Hashtable();
    protected Timer eventTimer = new Timer(true);

    public SwingMainDisplay(boolean hasConnectOrPractice, SOCPlayerClient client, int displayScaleFactor) throws IllegalArgumentException {
        if (client == null) {
            throw new IllegalArgumentException("null client");
        }
        if (displayScaleFactor < 1) {
            throw new IllegalArgumentException("displayScaleFactor: " + displayScaleFactor);
        }
        this.hasConnectOrPractice = hasConnectOrPractice;
        this.client = client;
        this.displayScale = displayScaleFactor;
        this.net = client.getNet();
        this.NET_UNAVAIL_CAN_PRACTICE_MSG = client.strings.get("pcli.error.server.unavailable");
        this.NEED_NICKNAME_BEFORE_JOIN = client.strings.get("pcli.main.join.neednickname");
        this.NEED_NICKNAME_BEFORE_JOIN_G = client.strings.get("pcli.main.join.neednickname.g");
        this.NEED_NICKNAME_BEFORE_JOIN_2 = client.strings.get("pcli.main.join.neednickname.2");
        this.NEED_NICKNAME_BEFORE_JOIN_G2 = client.strings.get("pcli.main.join.neednickname.g2");
        this.STATUS_CANNOT_JOIN_THIS_GAME = client.strings.get("pcli.main.join.cannot");
        this.setOpaque(true);
        Color[] colors = SwingMainDisplay.getForegroundBackgroundColors(false, false);
        if (colors != null) {
            this.setBackground(colors[2]);
            this.setForeground(colors[0]);
            this.miscLabelFGColor = colors[1];
        } else {
            this.miscLabelFGColor = osColorText;
        }
    }

    public static final Color[] getForegroundBackgroundColors(boolean isForLightBG, boolean wantSystemColors) {
        if (!hasDeterminedOSColors) {
            String propValue = System.getProperty(PROP_JSETTLERS_UI_CONTRAST_MODE);
            if (propValue != null) {
                if (propValue.equalsIgnoreCase("dark")) {
                    osColorTextBG = Color.BLACK;
                    osColorText = Color.WHITE;
                } else if (propValue.equalsIgnoreCase("light")) {
                    osColorTextBG = Color.WHITE;
                    osColorText = Color.BLACK;
                } else {
                    System.err.println("* Unrecognized value for jsettlers.uiContrastMode: " + propValue);
                    propValue = null;
                }
                if (propValue != null) {
                    isOSColorHighContrast = true;
                    System.err.println("High-contrast mode enabled using jsettlers.uiContrastMode=" + propValue);
                }
            }
            if (propValue == null) {
                osColorTextBG = SystemColor.text;
                osColorText = SystemColor.textText;
                Object o = Toolkit.getDefaultToolkit().getDesktopProperty("win.highContrast.on");
                if (o instanceof Boolean) {
                    isOSColorHighContrast = (Boolean)o;
                }
                if (!isOSColorHighContrast) {
                    float brightnessBG = (float)(osColorTextBG.getRed() + osColorTextBG.getGreen() + osColorTextBG.getBlue()) / 765.0f;
                    float brightnessText = (float)(osColorText.getRed() + osColorText.getGreen() + osColorText.getBlue()) / 765.0f;
                    boolean bl = isOSColorHighContrast = brightnessText > brightnessBG && brightnessBG <= 0.3f;
                    if (isOSColorHighContrast) {
                        System.err.println("High-contrast mode detected (dark background).");
                    }
                } else {
                    System.err.println("High-contrast mode detected.");
                }
            }
            hasDeterminedOSColors = true;
        }
        if (wantSystemColors) {
            return new Color[]{osColorText, osColorText, osColorTextBG};
        }
        if (isOSColorHighContrast) {
            return null;
        }
        if (isForLightBG) {
            return new Color[]{Color.BLACK, Color.BLACK, DIALOG_BG_GOLDENROD};
        }
        return new Color[]{Color.BLACK, MISC_LABEL_FG_OFF_WHITE, JSETTLERS_BG_GREEN};
    }

    public static final boolean isOSColorHighContrast() {
        if (!hasDeterminedOSColors) {
            SwingMainDisplay.getForegroundBackgroundColors(false, true);
        }
        return isOSColorHighContrast;
    }

    public static final int checkDisplayScaleFactor(Component c) throws IllegalStateException, NullPointerException {
        int uiScaleForce;
        block10: {
            try {
                String propValue = System.getProperty(PROP_JSETTLERS_UI_SCALE);
                if (propValue == null || propValue.length() <= 0) break block10;
                try {
                    int uiScale = Integer.parseInt(propValue);
                    if (uiScale > 0) {
                        System.err.println("L678: checkDisplayScaleFactor prop override -> scale=" + uiScale);
                        return uiScale;
                    }
                }
                catch (NumberFormatException uiScale) {}
            }
            catch (SecurityException propValue) {
                // empty catch block
            }
        }
        if ((uiScaleForce = UserPreferences.getPref("uiScaleForce", 0)) > 0 && uiScaleForce <= 3) {
            System.err.println("L688: checkDisplayScaleFactor user-pref override -> scale=" + uiScaleForce);
            return uiScaleForce;
        }
        GraphicsConfiguration gconf = c.getGraphicsConfiguration();
        if (gconf == null) {
            throw new IllegalStateException("needs container");
        }
        int scale = 1;
        try {
            int screenHeight = gconf.getDevice().getDisplayMode().getHeight();
            System.err.print("L549: checkDisplayScaleFactor got screenHeight=" + screenHeight);
            if (screenHeight >= 1536) {
                scale = screenHeight / 768;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        System.err.println(" -> scale=" + scale);
        return scale;
    }

    public static final void scaleUIManagerFonts(int displayScale) {
        if (displayScale <= 1 || didScaleUIManagerFonts) {
            return;
        }
        Set keySet = UIManager.getLookAndFeelDefaults().keySet();
        for (Object key : keySet.toArray(new Object[keySet.size()])) {
            Font font;
            if (key == null || !key.toString().toLowerCase().contains("font") || (font = UIManager.getDefaults().getFont(key)) == null) continue;
            UIManager.put(key, font.deriveFont(font.getSize2D() * (float)displayScale));
        }
        didScaleUIManagerFonts = true;
    }

    @Override
    public SOCPlayerClient getClient() {
        return this.client;
    }

    @Override
    public final GameMessageSender getGameMessageSender() {
        return this.client.getGameMessageSender();
    }

    @Override
    public final Container getGUIContainer() {
        return this;
    }

    @Override
    public final int getDisplayScaleFactor() {
        return this.displayScale;
    }

    public WindowAdapter createWindowAdapter() {
        return new ClientWindowAdapter(this);
    }

    @Override
    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    @Override
    public void showErrorDialog(String errMessage, String buttonText) {
        NotifyDialog.createAndShow(this, null, errMessage, buttonText, true);
    }

    @Override
    public void initVisualElements() {
        SOCStringManager strings = this.client.strings;
        this.setFont(new Font("SansSerif", 0, 12 * this.displayScale));
        this.nick = new JTextField(20);
        this.pass = new JPasswordField(20);
        this.status = new JTextField(20);
        this.status.setEditable(false);
        this.channel = new JTextField(20);
        DefaultListModel<JoinableListItem> lm = new DefaultListModel<JoinableListItem>();
        this.chlist = new JList(lm);
        this.chlist.setVisibleRowCount(10);
        this.chlist.setSelectionMode(0);
        lm.addElement(JoinableListItem.BLANK);
        lm = new DefaultListModel();
        this.gmlist = new JList(lm);
        this.gmlist.setVisibleRowCount(10);
        this.gmlist.setSelectionMode(0);
        lm.addElement(JoinableListItem.BLANK);
        this.ng = new JButton(strings.get("pcli.main.newgame"));
        this.jc = new JButton(strings.get("pcli.main.join.channel"));
        this.jg = new JButton(strings.get("pcli.main.join.game"));
        this.pg = new JButton(strings.get("pcli.main.practice"));
        this.gi = new JButton(strings.get("pcli.main.game.info"));
        if (SOCPlayerClient.IS_PLATFORM_WINDOWS && !isOSColorHighContrast) {
            this.ng.setBackground(null);
            this.jc.setBackground(null);
            this.jg.setBackground(null);
            this.pg.setBackground(null);
            this.gi.setBackground(null);
        }
        this.versionOrlocalTCPPortLabel = new JLabel();
        this.localTCPServerLabel = new JLabel();
        this.ng.setEnabled(false);
        this.jc.setEnabled(false);
        this.jg.setEnabled(false);
        this.gi.setEnabled(false);
        this.nick.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textValueChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textValueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textValueChanged();
            }

            private void textValueChanged() {
                boolean notEmpty;
                boolean bl = notEmpty = SwingMainDisplay.this.nick.getText().trim().length() > 0;
                if (notEmpty != SwingMainDisplay.this.ng.isEnabled()) {
                    SwingMainDisplay.this.ng.setEnabled(notEmpty);
                    SwingMainDisplay.this.jc.setEnabled(notEmpty);
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingMainDisplay.this.guardedActionPerform(e.getSource());
            }
        };
        this.nick.addActionListener(actionListener);
        this.pass.addActionListener(actionListener);
        this.channel.addActionListener(actionListener);
        this.chlist.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                e.consume();
                SwingMainDisplay.this.guardedActionPerform(SwingMainDisplay.this.chlist);
            }
        });
        this.gmlist.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                e.consume();
                SwingMainDisplay.this.guardedActionPerform(SwingMainDisplay.this.gmlist);
            }
        });
        this.gmlist.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean wasSel;
                boolean bl = wasSel = !((ListSelectionModel)e.getSource()).isSelectionEmpty();
                if (wasSel != SwingMainDisplay.this.jg.isEnabled()) {
                    SwingMainDisplay.this.jg.setEnabled(wasSel);
                    SwingMainDisplay.this.gi.setEnabled(wasSel && (((SwingMainDisplay)SwingMainDisplay.this).client.getNet().practiceServer != null || ((SwingMainDisplay)SwingMainDisplay.this).client.sVersion >= 1107));
                }
            }
        });
        this.ng.addActionListener(actionListener);
        this.jc.addActionListener(actionListener);
        this.jg.addActionListener(actionListener);
        this.pg.addActionListener(actionListener);
        this.gi.addActionListener(actionListener);
        this.initMainPanelLayout(true, null);
        JPanel messagePane = new JPanel(new BorderLayout());
        messagePane.setBackground(null);
        messagePane.setForeground(null);
        this.messageLabel_top = new JLabel("", 0);
        this.messageLabel_top.setVisible(false);
        messagePane.add((Component)this.messageLabel_top, "North");
        this.messageLabel = new JLabel("", 0);
        this.messageLabel.setForeground(this.miscLabelFGColor);
        messagePane.add((Component)this.messageLabel, "Center");
        this.pgm = new JButton(strings.get("pcli.message.practicebutton"));
        this.pgm.setVisible(false);
        if (SOCPlayerClient.IS_PLATFORM_WINDOWS && !isOSColorHighContrast) {
            this.pgm.setBackground(null);
        }
        messagePane.add((Component)this.pgm, "South");
        this.pgm.addActionListener(actionListener);
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.connectOrPracticePane = new SOCConnectOrPracticePanel(this);
        if (this.hasConnectOrPractice) {
            this.add((Component)this.connectOrPracticePane, CONNECT_OR_PRACTICE_PANEL);
        }
        this.add((Component)messagePane, MESSAGE_PANEL);
        if (!this.hasConnectOrPractice) {
            this.add((Component)this.connectOrPracticePane, CONNECT_OR_PRACTICE_PANEL);
        }
        this.add((Component)this.mainPane, MAIN_PANEL);
        this.messageLabel.setText(strings.get("pcli.message.connecting.serv"));
        this.validate();
    }

    private void initMainPanelLayout(boolean isStatusRow, SOCFeatureSet feats) throws IllegalArgumentException {
        JScrollPane sp;
        if (feats == null && !isStatusRow) {
            throw new IllegalArgumentException("feats");
        }
        SOCStringManager strings = this.client.strings;
        if (this.mainGBL == null) {
            this.mainGBL = new GridBagLayout();
        }
        if (this.mainGBC == null) {
            this.mainGBC = new GridBagConstraints();
        }
        if (this.mainPane == null) {
            this.mainPane = new JPanel(this.mainGBL);
            this.mainPane.setBackground(null);
            this.mainPane.setForeground(null);
            this.mainPane.setOpaque(false);
            int bsize = 4 * this.displayScale;
            this.mainPane.setBorder(BorderFactory.createEmptyBorder(0, bsize, bsize, bsize));
        } else if (this.mainPane.getLayout() == null) {
            this.mainPane.setLayout(this.mainGBL);
        }
        GridBagLayout gbl = this.mainGBL;
        GridBagConstraints c = this.mainGBC;
        c.fill = 1;
        c.gridwidth = 0;
        c.anchor = 21;
        if (isStatusRow) {
            c.weightx = 1.0;
            gbl.setConstraints(this.status, c);
            this.mainPane.add(this.status);
            c.weightx = 0.0;
            return;
        }
        boolean hasChannels = feats.isActive("ch");
        if (this.mainPaneLayoutIsDone) {
            if (hasChannels != this.mainPaneLayoutIsDone_hasChannels) {
                this.mainPane.removeAll();
                this.mainGBL = null;
                this.mainGBC = null;
                this.mainPane.setLayout(null);
                this.mainPaneLayoutIsDone = false;
                this.initMainPanelLayout(true, null);
                this.initMainPanelLayout(false, feats);
            }
            return;
        }
        this.channel.setVisible(hasChannels);
        this.chlist.setVisible(hasChannels);
        this.jc.setVisible(hasChannels);
        JLabel l = new JLabel();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        l = new JLabel(strings.get("pcli.main.label.yournickname"));
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        c.gridwidth = 1;
        c.weightx = 0.5;
        gbl.setConstraints(this.nick, c);
        this.mainPane.add(this.nick);
        c.weightx = 0.0;
        l = new JLabel(" ");
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        l = new JLabel(strings.get("pcli.main.label.optionalpw"));
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        l = new JLabel(" ");
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        c.gridwidth = 1;
        c.weightx = 0.5;
        gbl.setConstraints(this.pass, c);
        this.mainPane.add(this.pass);
        c.weightx = 0.0;
        l = new JLabel();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        l = new JLabel();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        if (hasChannels) {
            l = new JLabel(strings.get("pcli.main.label.newchannel"));
            c.gridwidth = 1;
            gbl.setConstraints(l, c);
            this.mainPane.add(l);
            c.gridwidth = 1;
            c.weightx = 0.5;
            gbl.setConstraints(this.channel, c);
            this.mainPane.add(this.channel);
            c.weightx = 0.0;
        }
        l = new JLabel();
        c.gridwidth = hasChannels ? 1 : 3;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        c.gridwidth = 1;
        gbl.setConstraints(this.pg, c);
        this.mainPane.add(this.pg);
        l = new JLabel();
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        c.gridwidth = 1;
        c.fill = 0;
        gbl.setConstraints(this.ng, c);
        this.mainPane.add(this.ng);
        c.fill = 1;
        l = new JLabel();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.localTCPServerLabel, c);
        this.mainPane.add(this.localTCPServerLabel);
        c.gridwidth = hasChannels ? 1 : 2;
        gbl.setConstraints(this.versionOrlocalTCPPortLabel, c);
        this.mainPane.add(this.versionOrlocalTCPPortLabel);
        if (hasChannels) {
            c.fill = 0;
            c.gridwidth = 1;
            gbl.setConstraints(this.jc, c);
            this.mainPane.add(this.jc);
            c.fill = 1;
        }
        l = new JLabel(" ");
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        c.gridwidth = 1;
        gbl.setConstraints(this.gi, c);
        this.mainPane.add(this.gi);
        l = new JLabel();
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        c.gridwidth = 1;
        c.fill = 0;
        gbl.setConstraints(this.jg, c);
        this.mainPane.add(this.jg);
        c.fill = 1;
        l = new JLabel();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        if (hasChannels) {
            l = new JLabel(strings.get("pcli.main.label.channels"));
            c.gridwidth = 2;
            gbl.setConstraints(l, c);
            this.mainPane.add(l);
            l = new JLabel(" ");
            c.gridwidth = 1;
            gbl.setConstraints(l, c);
            this.mainPane.add(l);
        }
        l = new JLabel(strings.get("pcli.main.label.games"));
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        this.mainPane.add(l);
        c.weighty = 1.0;
        if (hasChannels) {
            c.gridwidth = 2;
            sp = new JScrollPane(this.chlist);
            gbl.setConstraints(sp, c);
            this.mainPane.add(sp);
            l = new JLabel();
            c.gridwidth = 1;
            gbl.setConstraints(l, c);
            this.mainPane.add(l);
        }
        c.gridwidth = 0;
        sp = new JScrollPane(this.gmlist);
        gbl.setConstraints(sp, c);
        this.mainPane.add(sp);
        this.mainPaneLayoutIsDone_hasChannels = hasChannels;
        this.mainPaneLayoutIsDone = true;
    }

    @Override
    public void connect(String chost, int cport, String cpass, String cuser) {
        this.connectOrPracticePane.setServerHostPort(chost, cport);
        this.nick.setEditable(true);
        this.pass.setEditable(true);
        this.pass.setText(cpass);
        this.nick.setText(cuser);
        this.nick.requestFocusInWindow();
        if (cuser != null && cuser.trim().length() > 0) {
            this.ng.setEnabled(true);
        }
        this.cardLayout.show(this, MESSAGE_PANEL);
    }

    @Override
    public void clickPracticeButton() {
        this.guardedActionPerform(this.pgm);
    }

    private void guardedActionPerform(Object target) {
        try {
            boolean showPopupCannotJoin = false;
            if (target == this.jc || target == this.channel || target == this.chlist) {
                showPopupCannotJoin = !this.guardedActionPerform_channels(target);
            } else if (target == this.jg || target == this.ng || target == this.gmlist || target == this.pg || target == this.pgm || target == this.gi) {
                boolean bl = showPopupCannotJoin = !this.guardedActionPerform_games(target);
            }
            if (showPopupCannotJoin) {
                this.status.setText(this.STATUS_CANNOT_JOIN_THIS_GAME);
                NotifyDialog.createAndShow(this, null, this.STATUS_CANNOT_JOIN_THIS_GAME, this.client.strings.get("base.cancel"), true);
                return;
            }
            if (target == this.nick) {
                this.nick.transferFocus();
            }
        }
        catch (Throwable thr) {
            System.err.println("-- Error caught in AWT event thread: " + thr + " --");
            thr.printStackTrace();
            System.err.println("-- Error stack trace end --");
            System.err.println();
        }
    }

    private boolean guardedActionPerform_channels(Object target) {
        String errMsg;
        String ch = null;
        if (target == this.jc) {
            ch = this.channel.getText().trim();
            if (ch.length() == 0) {
                ch = null;
            }
        } else if (target == this.channel) {
            ch = this.channel.getText().trim();
        }
        if (ch == null) {
            JoinableListItem itm = this.chlist.getSelectedValue();
            if (itm == null) {
                return true;
            }
            if (itm.isUnjoinable) {
                return false;
            }
            ch = itm.name.trim();
        } else if (!ch.isEmpty() && (errMsg = this.checkNameFormat(ch)) != null) {
            this.status.setText(errMsg);
            this.channel.requestFocusInWindow();
            ch = "";
        }
        if (ch.isEmpty()) {
            return true;
        }
        ChannelFrame cf = this.channels.get(ch);
        if (cf == null) {
            if (this.channels.isEmpty() && !this.readValidNicknameAndPassword()) {
                return true;
            }
            this.status.setText(this.client.strings.get("pcli.message.talkingtoserv"));
            this.net.putNet(SOCJoinChannel.toCmd(this.client.nickname, this.client.gotPassword ? "" : this.client.password, "\t", ch));
        } else {
            cf.setVisible(true);
        }
        this.channel.setText("");
        return true;
    }

    @Override
    public boolean readValidNicknameAndPassword() {
        if (this.getValidNickname(false) == null) {
            return false;
        }
        if (!this.client.gotPassword) {
            this.client.password = this.getPassword();
            if (this.client.password == null) {
                return false;
            }
        }
        return true;
    }

    private boolean guardedActionPerform_games(Object target) {
        String gm;
        boolean isUnjoinable = false;
        if (target == this.pg || target == this.pgm) {
            gm = this.client.DEFAULT_PRACTICE_GAMENAME;
            if (0 == this.nick.getText().trim().length()) {
                this.nick.setText(this.client.strings.get("default.name.practice.player"));
            }
        } else {
            if (target == this.ng) {
                if (null != this.getValidNickname(true)) {
                    this.gameWithOptionsBeginSetup(false, false);
                } else {
                    this.nick.requestFocusInWindow();
                }
                return true;
            }
            JoinableListItem item = this.gmlist.getSelectedValue();
            if (item == null) {
                return true;
            }
            gm = item.name.trim();
            isUnjoinable = item.isUnjoinable;
        }
        if (gm.length() == 0) {
            return true;
        }
        if (target == this.gi) {
            boolean isPractice = false;
            SOCGameOptionSet opts = null;
            if (this.net.practiceServer != null && this.net.practiceServer.getGame(gm) != null) {
                isPractice = true;
                opts = this.net.practiceServer.getGameOptions(gm);
            } else if (this.client.serverGames != null && (opts = this.client.serverGames.getGameOptions(gm)) == null && this.client.serverGames.getGameOptionsString(gm) != null) {
                if (this.client.tcpServGameOpts.allOptionsReceived) {
                    opts = this.client.serverGames.parseGameOptions(gm);
                    this.client.checkGameoptsForUnknownScenario(opts);
                } else {
                    this.client.tcpServGameOpts.gameInfoWaitingForOpts = gm;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    return true;
                }
            }
            NewGameOptionsFrame ngof = this.gameInfoFrames.get(gm);
            if (ngof != null) {
                ngof.toFront();
            } else {
                this.showGameOptions(gm, opts, isPractice);
            }
            return true;
        }
        if ((isUnjoinable || this.client.serverGames != null && this.client.serverGames.isUnjoinableGame(gm)) && !this.client.gamesUnjoinableOverride.containsKey(gm)) {
            this.client.gamesUnjoinableOverride.put(gm, gm);
            return false;
        }
        SOCPlayerInterface pi = this.playerInterfaces.get(gm);
        if (pi == null && (target == this.pg || target == this.pgm) && this.net.practiceServer != null && gm.equalsIgnoreCase(this.client.DEFAULT_PRACTICE_GAMENAME)) {
            pi = this.findAnyActiveGame(true);
        }
        if (pi != null && (target == this.pg || target == this.pgm)) {
            if (pi.getGame().getGameState() == 1000) {
                this.gameWithOptionsBeginSetup(true, false);
            } else {
                new SOCPracticeAskDialog(this, pi).setVisible(true);
            }
            return true;
        }
        if (pi == null) {
            if (this.client.games.isEmpty()) {
                if (this.getValidNickname(false) == null) {
                    return true;
                }
                if (!this.client.gotPassword) {
                    this.client.password = this.getPassword();
                    if (this.client.password == null) {
                        return true;
                    }
                }
            }
            if ((target == this.pg || target == this.pgm) && null == this.net.ex_P) {
                if (target == this.pg) {
                    this.status.setText(this.client.strings.get("pcli.message.startingpractice"));
                }
                this.gameWithOptionsBeginSetup(true, false);
            } else {
                if (this.nick.isEditable() && this.getValidNickname(false) == null) {
                    this.nick.requestFocusInWindow();
                    return true;
                }
                this.status.setText(this.client.strings.get("pcli.message.talkingtoserv"));
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.net.putNet(SOCJoinGame.toCmd(this.client.nickname, this.client.gotPassword ? "" : this.client.password, "\t", gm));
            }
        } else {
            pi.setVisible(true);
        }
        return true;
    }

    protected String getValidNickname(boolean precheckOnly) {
        String n = this.nick.getText().trim();
        if (n.isEmpty()) {
            String stat = this.status.getText();
            if (stat.equals(this.NEED_NICKNAME_BEFORE_JOIN) || stat.equals(this.NEED_NICKNAME_BEFORE_JOIN_G)) {
                this.status.setText(this.client.sFeatures.isActive("ch") ? this.NEED_NICKNAME_BEFORE_JOIN_2 : this.NEED_NICKNAME_BEFORE_JOIN_G2);
            } else {
                this.status.setText(this.client.sFeatures.isActive("ch") ? this.NEED_NICKNAME_BEFORE_JOIN : this.NEED_NICKNAME_BEFORE_JOIN_G);
            }
            return null;
        }
        String errMsg = this.checkNameFormat(n);
        if (errMsg != null) {
            this.status.setText(errMsg);
            return null;
        }
        this.nick.setText(n);
        if (!precheckOnly) {
            this.client.nickname = n;
            if (this.client.practiceNickname == null) {
                this.client.practiceNickname = n;
            }
        }
        return n;
    }

    private String checkNameFormat(String n) {
        String errMsg = null;
        if (-1 != n.indexOf(124)) {
            errMsg = this.client.strings.get("netmsg.status.client.newgame_name_rejected_char", Character.valueOf('|'));
        } else if (-1 != n.indexOf(44)) {
            errMsg = this.client.strings.get("netmsg.status.client.newgame_name_rejected_char", Character.valueOf(','));
        } else if (!SOCMessage.isSingleLineAndSafe(n)) {
            errMsg = this.client.strings.get("netmsg.status.common.newgame_name_rejected");
        }
        return errMsg;
    }

    protected String getPassword() {
        if (this.client.gotPassword) {
            return this.client.password;
        }
        String p = this.pass.getText().trim();
        if (p.length() > 256) {
            this.status.setText(this.client.strings.get("account.common.password_too_long"));
            this.pass.requestFocus();
            p = null;
        }
        this.client.password = p;
        return p;
    }

    @Override
    public Timer getEventTimer() {
        return this.eventTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gameWithOptionsBeginSetup(boolean forPracticeServer, boolean didAuth) {
        boolean knowDefaults;
        boolean optsAllKnown;
        boolean askedAlready;
        ServerGametypeInfo opts;
        if (this.newGameOptsFrame != null) {
            this.newGameOptsFrame.setVisible(true);
            return;
        }
        if (!forPracticeServer && !this.client.gotPassword && this.client.sVersion >= 1119) {
            if (!this.readValidNicknameAndPassword()) {
                return;
            }
            this.client.isNGOFWaitingForAuthStatus = true;
            this.status.setText(this.client.strings.get("pcli.message.talkingtoserv"));
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.net.putNet(new SOCAuthRequest("P", this.client.getNickname(forPracticeServer), this.client.password, 1, this.net.getHost()).toCmd());
            return;
        }
        if (didAuth) {
            this.nick.setEditable(false);
            this.pass.setText("");
            this.pass.setEditable(false);
        }
        boolean fullSetIsKnown = false;
        if (forPracticeServer) {
            opts = this.client.practiceServGameOpts;
            if (!opts.allOptionsReceived) {
                fullSetIsKnown = true;
                opts.knownOpts = SOCServer.localizeKnownOptions(this.client.cliLocale, true);
                opts.receiveDefaults(null, Version.versionNumber());
            }
            if (!opts.allScenStringsReceived) {
                this.client.localizeGameScenarios(SOCServer.localizeGameScenarios(this.client.cliLocale, null, true, false, null), false, true, true);
            }
        } else {
            opts = this.client.tcpServGameOpts;
            if (!opts.allOptionsReceived && this.client.sVersion < 1107) {
                fullSetIsKnown = true;
                opts.knownOpts = null;
            }
        }
        if (fullSetIsKnown) {
            opts.allOptionsReceived = true;
            opts.defaultsReceived = true;
        }
        ServerGametypeInfo serverGametypeInfo = opts;
        synchronized (serverGametypeInfo) {
            askedAlready = opts.askedDefaultsAlready;
            optsAllKnown = opts.allOptionsReceived;
            knowDefaults = opts.defaultsReceived;
        }
        if (!(!askedAlready || optsAllKnown && knowDefaults)) {
            if (optsAllKnown && 5000L < Math.abs(System.currentTimeMillis() - opts.askedDefaultsTime)) {
                knowDefaults = true;
                opts.defaultsReceived = true;
                if (this.gameOptsDefsTask != null) {
                    this.gameOptsDefsTask.cancel();
                    this.gameOptsDefsTask = null;
                }
            } else {
                return;
            }
        }
        if (optsAllKnown && knowDefaults) {
            this.newGameOptsFrame = this.showGameOptions(null, opts.getNewGameOpts(), forPracticeServer);
            return;
        }
        this.status.setText(this.client.strings.get("pcli.message.talkingtoserv"));
        this.setCursor(Cursor.getPredefinedCursor(3));
        int cliVers = Version.versionNumber();
        if (!forPracticeServer && !opts.allScenInfoReceived && this.client.sVersion >= 2000) {
            List<SOCScenario> changeScens;
            ArrayList<String> changes = null;
            if (cliVers > this.client.sVersion && (changeScens = SOCVersionedItem.itemsNewerThanVersion(this.client.sVersion, false, SOCScenario.getAllKnownScenarios())) != null) {
                changes = new ArrayList<String>();
                for (SOCScenario sc : changeScens) {
                    changes.add(sc.key);
                }
            }
            if (cliVers != this.client.sVersion) {
                this.client.getGameMessageSender().put(new SOCScenarioInfo(changes, true).toCmd(), false);
            } else if (this.client.wantsI18nStrings(false)) {
                this.client.getGameMessageSender().put(new SOCLocalizedStrings("S", 2, (List<String>)null).toCmd(), false);
            }
        }
        opts.newGameWaitingForOpts = true;
        opts.askedDefaultsAlready = true;
        opts.askedDefaultsTime = System.currentTimeMillis();
        this.client.getGameMessageSender().put(new SOCGameOptionGetDefaults(null).toCmd(), forPracticeServer);
        if (this.gameOptsDefsTask != null) {
            this.gameOptsDefsTask.cancel();
        }
        this.gameOptsDefsTask = new GameOptionDefaultsTimeoutTask(this, this.client.tcpServGameOpts, forPracticeServer);
        this.eventTimer.schedule((TimerTask)this.gameOptsDefsTask, 5000L);
    }

    private NewGameOptionsFrame showGameOptions(String gaName, SOCGameOptionSet gameOpts, boolean forPracticeServer) {
        boolean isNew = gaName == null;
        NewGameOptionsFrame ngof = NewGameOptionsFrame.createAndShow(isNew ? null : this.playerInterfaces.get(gaName), this, gaName, gameOpts, forPracticeServer, !isNew);
        if (isNew) {
            return ngof;
        }
        this.gameInfoFrames.put(gaName, ngof);
        if (!forPracticeServer && this.client.sVersion >= 2700 && !this.nick.getText().trim().isEmpty()) {
            if (!this.client.gotPassword) {
                if (!this.readValidNicknameAndPassword()) {
                    return ngof;
                }
                this.net.putNet(new SOCAuthRequest("P", this.client.getNickname(false), this.client.password, 1, this.net.getHost()).toCmd());
            }
            this.net.putNet(new SOCGameStats(gaName, 2, null).toCmd());
        }
        return ngof;
    }

    @Override
    public void askStartGameWithOptions(String gmName, boolean forPracticeServer, SOCGameOptionSet opts, Map<String, Object> localPrefs) {
        this.client.putGameReqLocalPrefs(gmName, localPrefs);
        if (forPracticeServer) {
            this.client.startPracticeGame(gmName, opts, true);
        } else {
            String pw = this.client.gotPassword ? "" : this.client.password;
            String askMsg = this.client.sVersion >= 1107 ? SOCNewGameWithOptionsRequest.toCmd(this.client.nickname, pw, "\t", gmName, opts.getAll()) : SOCJoinGame.toCmd(this.client.nickname, pw, "\t", gmName);
            this.net.putNet(askMsg);
            System.out.flush();
            this.status.setText(this.client.strings.get("pcli.message.talkingtoserv"));
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    @Override
    public void clearWaitingStatus(boolean clearStatus) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (clearStatus) {
            this.status.setText(this.statusOKText != null ? this.statusOKText : "");
        }
    }

    protected SOCPlayerInterface findAnyActiveGame(boolean fromPracticeServer) {
        Collection<String> gameNames;
        SOCPlayerInterface pi = null;
        if (fromPracticeServer) {
            if (this.net.practiceServer == null) {
                return null;
            }
            gameNames = this.net.practiceServer.getGameNames();
        } else {
            gameNames = this.playerInterfaces.keySet();
        }
        for (String tryGm : gameNames) {
            int gs;
            if (fromPracticeServer) {
                gs = this.net.practiceServer.getGameState(tryGm);
                if (gs >= 1000 || (pi = this.playerInterfaces.get(tryGm)) == null) continue;
                break;
            }
            pi = this.playerInterfaces.get(tryGm);
            if (pi == null) continue;
            gs = pi.getGame().getGameState();
            if (gs < 1000) break;
            pi = null;
        }
        return pi;
    }

    @Override
    public boolean hasAnyActiveGame(boolean fromPracticeServer) {
        return null != this.findAnyActiveGame(fromPracticeServer);
    }

    @Override
    public void showErrorPanel(String err, boolean canPractice) throws NullPointerException {
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (err.indexOf(10) != -1) {
            err = DataOutputUtils.newlinesToHTML(err);
        }
        if (canPractice) {
            this.messageLabel_top.setText(err);
            this.messageLabel_top.setVisible(true);
            this.messageLabel.setText(this.NET_UNAVAIL_CAN_PRACTICE_MSG);
            this.pgm.setVisible(true);
        } else {
            this.messageLabel_top.setVisible(false);
            this.messageLabel.setText(err);
            this.pgm.setVisible(false);
        }
        if (canPractice) {
            this.nick.setEditable(true);
            this.pass.setText("");
            this.pass.setEditable(true);
            this.cardLayout.show(this, CONNECT_OR_PRACTICE_PANEL);
            this.connectOrPracticePane.lostServerConnection(err);
            this.revalidate();
        } else {
            this.cardLayout.show(this, MESSAGE_PANEL);
            this.revalidate();
            if (canPractice) {
                if (!this.hasAnyActiveGame(true)) {
                    this.pgm.requestFocus();
                } else {
                    this.pgm.requestFocusInWindow();
                }
            }
        }
    }

    @Override
    public void enableOptions() {
        if (this.gi != null) {
            this.gi.setEnabled(true);
        }
    }

    @Override
    public void showVersion(int vers, String versionString, String buildString, SOCFeatureSet feats) {
        if (null == this.net.localTCPServer) {
            this.versionOrlocalTCPPortLabel.setForeground(this.miscLabelFGColor);
            this.versionOrlocalTCPPortLabel.setText(this.client.strings.get("pcli.main.version", versionString));
            this.versionOrlocalTCPPortLabel.setToolTipText(this.client.strings.get("pcli.main.version.tip", versionString, buildString, Version.version(), Version.buildnum()));
        }
        this.initMainPanelLayout(false, feats);
        this.validate();
        if (this.net.practiceServer == null && vers < 1107 && this.gi != null) {
            this.gi.setEnabled(false);
        }
    }

    @Override
    public void showStatus(String statusText, boolean statusIsOK, boolean debugWarn) {
        this.status.setText(statusText);
        String string = this.statusOKText = statusIsOK ? statusText : null;
        if (debugWarn) {
            this.versionOrlocalTCPPortLabel.setText(this.versionOrlocalTCPPortLabel.getText() + this.client.strings.get("pcli.message.append.debugon"));
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void setNickname(String nm) {
        this.nick.setText(nm);
    }

    @Override
    public void focusPassword() {
        this.pass.requestFocusInWindow();
    }

    @Override
    public void setPassword(String pw) {
        this.pass.setText(pw);
    }

    @Override
    public void repaintGameAndChannelLists() {
        if (this.chlist.isVisible()) {
            this.chlist.repaint();
        }
        if (this.gmlist.isVisible()) {
            this.gmlist.repaint();
        }
    }

    @Override
    public void channelJoined(String channelName) {
        this.nick.setEditable(false);
        this.pass.setText("");
        this.pass.setEditable(false);
        this.clearWaitingStatus(true);
        if (!this.hasJoinedServer) {
            Container c = this.getParent();
            if (c instanceof Frame) {
                Frame fr = (Frame)c;
                fr.setTitle(fr.getTitle() + " [" + this.nick.getText() + "]");
            }
            this.hasJoinedServer = true;
        }
        ChannelFrame cf = new ChannelFrame(channelName, this);
        cf.setVisible(true);
        this.channels.put(channelName, cf);
    }

    @Override
    public void channelJoined(String channelName, String nickname) {
        ChannelFrame fr = this.channels.get(channelName);
        fr.print("*** " + this.client.strings.get("channel.joined", nickname) + "\n");
        fr.addMember(nickname);
    }

    @Override
    public void channelLeft(String channelName) {
        this.channels.remove(channelName);
    }

    @Override
    public void channelLeft(String channelName, String nickname) {
        ChannelFrame fr = this.channels.get(channelName);
        fr.print("*** " + this.client.strings.get("channel.left", nickname) + "\n");
        fr.deleteMember(nickname);
    }

    @Override
    public void channelMemberList(String channelName, Collection<String> members) {
        ChannelFrame fr = this.channels.get(channelName);
        for (String member : members) {
            fr.addMember(member);
        }
        fr.began();
    }

    @Override
    public void channelDeleted(String channelName) {
        this.deleteFromList(channelName, this.chlist);
    }

    @Override
    public void channelsClosed(String message) {
        for (ChannelFrame cf : this.channels.values()) {
            cf.over(message);
        }
        this.channels.clear();
        DefaultListModel lm = (DefaultListModel)this.chlist.getModel();
        lm.clear();
        lm.addElement(JoinableListItem.BLANK);
    }

    public void addToList(String thing, JList<JoinableListItem> lst) {
        JoinableListItem item = new JoinableListItem(thing, false);
        DefaultListModel lm = (DefaultListModel)lst.getModel();
        if (((JoinableListItem)lm.get(0)).equals(JoinableListItem.BLANK)) {
            lm.set(0, item);
            lst.setSelectedIndex(0);
        } else {
            lm.addElement(item);
        }
    }

    public void deleteFromList(String thing, JList<JoinableListItem> lst) {
        int c;
        DefaultListModel lm = (DefaultListModel)lst.getModel();
        if (lm.size() == 1) {
            if (((JoinableListItem)lm.get(0)).equals(thing)) {
                lm.set(0, JoinableListItem.BLANK);
                lst.clearSelection();
            }
            return;
        }
        lm.removeElement(new JoinableListItem(thing, false));
        if (lst.getSelectedIndex() == -1 && (c = lm.size()) > 0) {
            lst.setSelectedIndex(c - 1);
        }
    }

    @Override
    public void channelCreated(String channelName) {
        this.addToList(channelName, this.chlist);
    }

    @Override
    public void channelList(Collection<String> channelNames, boolean isPractice) {
        if (!isPractice) {
            this.cardLayout.show(this, MAIN_PANEL);
            this.validate();
            this.status.setText(this.client.sFeatures.isActive("ch") ? this.NEED_NICKNAME_BEFORE_JOIN : this.NEED_NICKNAME_BEFORE_JOIN_G);
        }
        for (String ch : channelNames) {
            this.addToList(ch, this.chlist);
        }
        if (!isPractice) {
            this.nick.requestFocus();
        }
    }

    @Override
    public void chatMessageBroadcast(String message) {
        for (ChannelFrame fr : this.channels.values()) {
            fr.print("::: " + message + " :::");
        }
    }

    @Override
    public void chatMessageReceived(String channelName, String nickname, String message) {
        ChannelFrame fr = this.channels.get(channelName);
        if (fr != null && !this.client.onIgnoreList(nickname)) {
            fr.print(nickname + ": " + message);
        }
    }

    @Override
    public void gameTimingStatsReceived(String gameName, long creationTimeSeconds, boolean isStarted, int durationFinishedSeconds) {
        NewGameOptionsFrame ngof = this.gameInfoFrames.get(gameName);
        if (ngof != null) {
            ngof.gameTimingStatsReceived(creationTimeSeconds, isStarted, durationFinishedSeconds);
        }
    }

    @Override
    public void dialogClosed(NewGameOptionsFrame ngof) {
        String gaName;
        if (ngof == this.newGameOptsFrame) {
            this.newGameOptsFrame = null;
        }
        if ((gaName = ngof.getExistingGameName()) != null) {
            this.gameInfoFrames.remove(gaName);
        }
    }

    @Override
    public void leaveGame(SOCGame game) {
        this.playerInterfaces.remove(game.getName());
    }

    @Override
    public PlayerClientListener gameJoined(SOCGame game, int[] layoutVS, Map<String, Object> localPrefs) {
        this.nick.setEditable(false);
        this.pass.setEditable(false);
        this.pass.setText("");
        this.clearWaitingStatus(true);
        if (!this.hasJoinedServer) {
            Container c = this.getParent();
            if (c instanceof Frame) {
                Frame fr = (Frame)c;
                fr.setTitle(fr.getTitle() + " [" + this.nick.getText() + "]");
            }
            this.hasJoinedServer = true;
        }
        final SOCPlayerInterface pi = new SOCPlayerInterface(game.getName(), this, game, layoutVS, localPrefs);
        this.playerInterfaces.put(game.getName(), pi);
        this.eventTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        pi.setVisible(true);
                        pi.toFront();
                    }
                });
            }
        }, 80L);
        return pi.getClientListener();
    }

    private void gameOptionsSetTimeoutTask() {
        if (this.gameOptsTask != null) {
            this.gameOptsTask.cancel();
        }
        this.gameOptsTask = new GameOptionsTimeoutTask(this, this.client.tcpServGameOpts);
        this.eventTimer.schedule((TimerTask)this.gameOptsTask, 5000L);
    }

    private void gameOptionsCancelTimeoutTask() {
        if (this.gameOptsTask != null) {
            this.gameOptsTask.cancel();
            this.gameOptsTask = null;
        }
    }

    @Override
    public void optionsRequested() {
        this.gameOptionsSetTimeoutTask();
    }

    @Override
    public void optionsReceived(ServerGametypeInfo opts, boolean isPractice) {
        this.gameOptionsCancelTimeoutTask();
        this.newGameOptsFrame = this.showGameOptions(null, opts.getNewGameOpts(), isPractice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optionsReceived(ServerGametypeInfo opts, boolean isPractice, boolean isDash, boolean hasAllNow) {
        String gameInfoWaiting;
        boolean newGameWaiting;
        ServerGametypeInfo serverGametypeInfo = opts;
        synchronized (serverGametypeInfo) {
            newGameWaiting = opts.newGameWaitingForOpts;
            gameInfoWaiting = opts.gameInfoWaitingForOpts;
        }
        if (!isPractice && isDash) {
            this.gameOptionsCancelTimeoutTask();
        }
        if (hasAllNow) {
            if (gameInfoWaiting != null) {
                serverGametypeInfo = opts;
                synchronized (serverGametypeInfo) {
                    opts.gameInfoWaitingForOpts = null;
                }
                SOCGameOptionSet gameOpts = this.client.serverGames.parseGameOptions(gameInfoWaiting);
                if (!isPractice) {
                    this.client.checkGameoptsForUnknownScenario(gameOpts);
                }
                this.showGameOptions(gameInfoWaiting, gameOpts, isPractice);
            } else if (newGameWaiting) {
                SOCGameOptionSet newGameOpts;
                ServerGametypeInfo serverGametypeInfo2 = opts;
                synchronized (serverGametypeInfo2) {
                    opts.newGameWaitingForOpts = false;
                    newGameOpts = opts.getNewGameOpts();
                }
                this.newGameOptsFrame = this.showGameOptions(null, newGameOpts, isPractice);
            }
        }
    }

    @Override
    public void addToGameList(boolean cannotJoin, String gameName, String gameOptsStr, boolean addToSrvList) {
        if (addToSrvList) {
            if (this.client.serverGames == null) {
                this.client.serverGames = new SOCGameList(this.client.tcpServGameOpts.knownOpts);
            }
            this.client.serverGames.addGame(gameName, gameOptsStr, cannotJoin);
        }
        JoinableListItem item = new JoinableListItem(gameName, cannotJoin);
        DefaultListModel lm = (DefaultListModel)this.gmlist.getModel();
        if (!lm.isEmpty() && ((JoinableListItem)lm.get(0)).equals(JoinableListItem.BLANK)) {
            lm.set(0, item);
            this.gmlist.setSelectedIndex(0);
            this.jg.setEnabled(true);
            this.gi.setEnabled(this.net.practiceServer != null || this.client.sVersion >= 1107);
        } else {
            lm.addElement(item);
        }
        this.gmlist.repaint();
    }

    @Override
    public boolean deleteFromGameList(String gameName, boolean isPractice, boolean withUnjoinablePrefix) {
        int c;
        DefaultListModel lm = (DefaultListModel)this.gmlist.getModel();
        if (lm.size() == 1) {
            if (((JoinableListItem)lm.get(0)).equals(gameName)) {
                lm.set(0, JoinableListItem.BLANK);
                this.gmlist.clearSelection();
                if (!isPractice && this.client.serverGames != null) {
                    this.client.serverGames.deleteGame(gameName);
                }
                this.gi.setEnabled(false);
                return true;
            }
            return false;
        }
        boolean found = lm.removeElement(new JoinableListItem(gameName, withUnjoinablePrefix));
        if (this.gmlist.getSelectedIndex() == -1 && (c = lm.size()) > 0) {
            this.gmlist.setSelectedIndex(c - 1);
        }
        if (found && !isPractice && this.client.serverGames != null) {
            this.client.serverGames.deleteGame(gameName);
        }
        return found;
    }

    @Override
    public void sendToChannel(String ch, String mes) {
        if (!this.doLocalCommand(ch, mes)) {
            this.net.putNet(new SOCChannelTextMsg(ch, this.client.nickname, mes).toCmd());
        }
    }

    public boolean doLocalCommand(String ch, String cmd) {
        ChannelFrame fr = this.channels.get(ch);
        if (cmd.startsWith("\\ignore ")) {
            String name = cmd.substring(8);
            this.client.addToIgnoreList(name);
            fr.print("* Ignoring " + name);
            this.printIgnoreList(fr);
            return true;
        }
        if (cmd.startsWith("\\unignore ")) {
            String name = cmd.substring(10);
            this.client.removeFromIgnoreList(name);
            fr.print("* Unignoring " + name);
            this.printIgnoreList(fr);
            return true;
        }
        return false;
    }

    protected void printIgnoreList(ChannelFrame fr) {
        fr.print("* Ignore list:");
        for (String s : this.client.ignoreList) {
            fr.print("* " + s);
        }
    }

    @Override
    public void printIgnoreList(SOCPlayerInterface pi) {
        pi.print("* Ignore list:");
        for (String s : this.client.ignoreList) {
            pi.print("* " + s);
        }
    }

    @Override
    public void practiceGameStarting() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void startLocalTCPServer(int tport) throws IllegalArgumentException, IllegalStateException {
        if (this.net.localTCPServer != null) {
            return;
        }
        if (this.net.isConnected()) {
            throw new IllegalStateException("Already connected to " + this.net.getHost());
        }
        if (tport < 1) {
            throw new IllegalArgumentException("Port must be positive: " + tport);
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.net.initLocalServer(tport)) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        final SOCStringManager strings = this.client.strings;
        final String tportStr = Integer.toString(tport);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NotifyDialog.createAndShow(SwingMainDisplay.this, null, strings.get("pcli.localserver.dialog", tportStr), strings.get("base.ok"), true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getSource() == SwingMainDisplay.this.localTCPServerLabel) {
                    SwingMainDisplay.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.getSource() == SwingMainDisplay.this.localTCPServerLabel) {
                    SwingMainDisplay.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        this.localTCPServerLabel.setText(strings.get("pcli.localserver.running"));
        this.localTCPServerLabel.setFont(this.getFont().deriveFont(1));
        this.localTCPServerLabel.addMouseListener(mouseListener);
        this.versionOrlocalTCPPortLabel.setText(strings.get("pcli.localserver.port", tportStr));
        this.versionOrlocalTCPPortLabel.setToolTipText(strings.get("pcli.localserver.running.tip", tportStr, Version.version(), Version.buildnum()));
        this.versionOrlocalTCPPortLabel.addMouseListener(mouseListener);
        Container parent = this.getParent();
        if (parent instanceof Frame) {
            try {
                ((Frame)parent).setTitle(strings.get("pcli.main.title.localserver", Version.version(), tportStr));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.cardLayout.show(this, MESSAGE_PANEL);
        this.net.connect(null, tport);
        if (this.connectOrPracticePane != null) {
            this.connectOrPracticePane.startedLocalServer();
        }
        if (this.nick.getText().trim().length() > 0) {
            this.ng.setEnabled(true);
        } else {
            this.nick.setEditable(true);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private static class GameOptionDefaultsTimeoutTask
    extends TimerTask {
        public SwingMainDisplay pcli;
        public ServerGametypeInfo srvOpts;
        public boolean forPracticeServer;

        public GameOptionDefaultsTimeoutTask(SwingMainDisplay c, ServerGametypeInfo opts, boolean forPractice) {
            this.pcli = c;
            this.srvOpts = opts;
            this.forPracticeServer = forPractice;
        }

        @Override
        public void run() {
            this.pcli.gameOptsDefsTask = null;
            this.srvOpts.noMoreOptions(true);
            if (this.srvOpts.newGameWaitingForOpts) {
                this.pcli.gameWithOptionsBeginSetup(this.forPracticeServer, false);
            }
        }
    }

    private static class GameOptionsTimeoutTask
    extends TimerTask {
        public SwingMainDisplay pcli;
        public ServerGametypeInfo srvOpts;

        public GameOptionsTimeoutTask(SwingMainDisplay c, ServerGametypeInfo opts) {
            this.pcli = c;
            this.srvOpts = opts;
        }

        @Override
        public void run() {
            this.pcli.gameOptsTask = null;
            this.srvOpts.noMoreOptions(false);
            this.pcli.getClient().getMessageHandler().handleGAMEOPTIONINFO(new SOCGameOptionInfo(new SOCGameOption("-", null), Version.versionNumber(), null), false);
        }
    }

    private static class ClientWindowAdapter
    extends WindowAdapter {
        private final SwingMainDisplay md;

        public ClientWindowAdapter(SwingMainDisplay md) {
            this.md = md;
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            Container c;
            SOCPlayerInterface piActive = null;
            if (piActive == null) {
                piActive = this.md.findAnyActiveGame(false);
            }
            if (piActive != null) {
                SOCQuitAllConfirmDialog.createAndShow(piActive.getMainDisplay(), piActive);
                return;
            }
            boolean canAskHostingGames = false;
            boolean isHostingActiveGames = false;
            ClientNetwork cnet = this.md.getClient().getNet();
            if (cnet.isRunningLocalServer()) {
                isHostingActiveGames = cnet.anyHostedActiveGames();
            }
            if (isHostingActiveGames && (c = this.md.getParent()) instanceof Frame) {
                canAskHostingGames = true;
                SOCQuitAllConfirmDialog.createAndShow(this.md, (Frame)c);
            }
            if (!canAskHostingGames) {
                this.md.getClient().getNet().putLeaveAll();
                System.exit(0);
            }
        }

        @Override
        public void windowOpened(WindowEvent evt) {
            if (!this.md.hasConnectOrPractice) {
                this.md.nick.requestFocus();
            }
        }
    }

    private static class JoinableListItem {
        public static final JoinableListItem BLANK = new JoinableListItem(" ", false);
        public final String name;
        public final boolean isUnjoinable;

        public JoinableListItem(String name, boolean isUnjoinable) throws IllegalArgumentException {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.isUnjoinable = isUnjoinable;
        }

        public String toString() {
            return this.isUnjoinable ? SOCPlayerClient.GAMENAME_PREFIX_CANNOT_JOIN + this.name : this.name;
        }

        public boolean equals(Object i) {
            if (i == null) {
                return false;
            }
            if (i == this) {
                return true;
            }
            if (i instanceof JoinableListItem) {
                return this.name.equals(((JoinableListItem)i).name);
            }
            if (i instanceof String) {
                return this.name.equals(i);
            }
            return super.equals(i);
        }
    }
}

