/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JLabel;
import soc.client.SOCHandPanel;
import soc.client.SOCPlayerInterface;
import soc.client.ShadowedBox;
import soc.client.SquaresPanel;
import soc.client.SwingMainDisplay;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.game.SOCTradeOffer;
import soc.util.SOCStringManager;

public class TradePanel
extends ShadowedBox
implements ActionListener {
    private static final long serialVersionUID = 2000L;
    private static final SOCStringManager strings = SOCStringManager.getClientManager();
    private static final int PANEL_MARGIN_HORIZ = 8;
    private static final int BUTTON_HEIGHT = 18;
    private static final int BUTTON_WIDTH = 55;
    private static final int BUTTON_MARGIN_COMPACT = 2;
    private static final int LABEL_LINE_HEIGHT = 14;
    private static final int LAYOUT_LINE_SPACE = 3;
    private static final int SQUARES_LAB_MIN_WIDTH = 49;
    private static final int SQUARES_LAB_MARGIN_RIGHT = 6;
    private static final int MIN_WIDTH_FROM_BUTTON_ROW = 190;
    private SOCPlayer player;
    private TradePanel panelPairOtherMember;
    private boolean panelIsCounterOffer;
    private int playerResourceButtonNumber;
    private boolean isOfferToPlayer;
    private final boolean isPlayerRow1;
    private final TPListener listener;
    private AutoRejectTask rejTimerTask;
    private final SOCHandPanel hpan;
    private final SOCPlayerInterface pi;
    private final int displayScale;
    private final JLabel line1;
    private final JLabel line2;
    private final JLabel lineBelow;
    private final JButton btn1;
    private final JButton btn2;
    private final JButton btn3;
    private final JButton[] btns;
    private boolean buttonRowVis;
    private boolean buttonVis;
    private final SquaresPanel squares;
    private final JLabel sqLabRow1;
    private final JLabel sqLabRow2;
    private int sqLabWidth;

    public TradePanel(String[] buttonTexts, String[] sqLabelTexts, boolean isPlayerRow1, boolean hasLine2, SOCHandPanel hpan, Color tradeInteriorColor, TPListener listener, int displayScale) throws IllegalArgumentException {
        super(hpan.getBackground(), tradeInteriorColor, displayScale, null);
        if (buttonTexts == null || buttonTexts.length != 3) {
            throw new IllegalArgumentException("buttonTexts");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener");
        }
        if (sqLabelTexts == null || sqLabelTexts.length != 2 && sqLabelTexts.length != 4) {
            throw new IllegalArgumentException("sqLabelTexts");
        }
        this.hpan = hpan;
        this.listener = listener;
        this.pi = hpan.getPlayerInterface();
        Font panelFont = new Font("SansSerif", 0, 10 * displayScale);
        this.setFont(panelFont);
        Color[] colors = SwingMainDisplay.getForegroundBackgroundColors(true, false);
        if (colors != null) {
            this.setForeground(colors[0]);
        }
        this.line1 = new JLabel();
        this.line2 = hasLine2 ? new JLabel() : null;
        this.lineBelow = new JLabel();
        this.squares = new SquaresPanel(true, displayScale);
        this.sqLabRow1 = new JLabel(sqLabelTexts[0]);
        this.sqLabRow2 = new JLabel(sqLabelTexts[1]);
        this.add(this.sqLabRow1);
        this.add(this.sqLabRow2);
        if (sqLabelTexts.length == 4) {
            this.sqLabRow1.setToolTipText(sqLabelTexts[2]);
            this.sqLabRow2.setToolTipText(sqLabelTexts[3]);
        }
        this.isPlayerRow1 = isPlayerRow1;
        this.displayScale = displayScale;
        this.buttonRowVis = true;
        this.buttonVis = true;
        this.add(this.line1);
        if (hasLine2) {
            this.add(this.line2);
        }
        this.lineBelow.setVisible(false);
        this.add(this.lineBelow);
        this.add(this.squares);
        this.btns = new JButton[3];
        int pix2 = 2 * displayScale;
        Insets minButtonMargin = new Insets(pix2, pix2, pix2, pix2);
        for (int i = 0; i < 3; ++i) {
            this.btns[i] = new JButton(buttonTexts[i]);
            this.btns[i].setFont(panelFont);
            this.btns[i].setMargin(minButtonMargin);
            this.add(this.btns[i]);
            this.btns[i].addActionListener(this);
        }
        this.btn1 = this.btns[0];
        this.btn2 = this.btns[1];
        this.btn3 = this.btns[2];
        for (Component co : this.getComponents()) {
            if (!(co instanceof JLabel)) continue;
            co.setFont(panelFont);
            co.setForeground(null);
            co.setBackground(null);
        }
    }

    public void setOfferCounterPartner(boolean thisIsCounterOffer, TradePanel otherMember) throws IllegalArgumentException {
        if (otherMember == null || otherMember == this) {
            throw new IllegalArgumentException("otherMember");
        }
        this.panelIsCounterOffer = thisIsCounterOffer;
        this.panelPairOtherMember = otherMember;
        this.squares.setInteractive(thisIsCounterOffer);
    }

    public SOCResourceSet[] getTradeResources() {
        int[] res1 = new int[5];
        int[] res2 = new int[5];
        this.squares.getValues(res1, res2);
        return new SOCResourceSet[]{new SOCResourceSet(res1), new SOCResourceSet(res2)};
    }

    public void setTradeResources(SOCResourceSet line1, SOCResourceSet line2) {
        this.squares.setValues(line1, line2);
        if (this.panelIsCounterOffer) {
            this.updateOfferButtons();
        }
    }

    public boolean isOfferToPlayer() {
        return this.isVisible() && this.isOfferToPlayer;
    }

    public void setTradeOffer(SOCTradeOffer offer) {
        int i;
        int cnt;
        boolean isCounterOfferVis;
        if (offer == null) {
            this.setTradeResources(null, null);
            this.isOfferToPlayer = false;
            if (this.playerResourceButtonNumber != 0 && this.player != null) {
                this.buttonVis = false;
                this.btns[this.playerResourceButtonNumber - 1].setVisible(false);
            }
            return;
        }
        SOCResourceSet give = offer.getGiveSet();
        SOCResourceSet get = offer.getGetSet();
        boolean[] offerList = offer.getTo();
        this.setTradeResources(give, get);
        this.isOfferToPlayer = this.player != null && offerList[this.player.getPlayerNumber()];
        boolean bl = isCounterOfferVis = this.panelPairOtherMember != null && this.panelPairOtherMember.isVisible();
        if (!this.isOfferToPlayer) {
            this.setButtonRowVisible(false, true);
        } else if (!this.buttonRowVis && !isCounterOfferVis) {
            this.setButtonRowVisible(true, false);
        }
        boolean mightWantAutoReject = false;
        if (this.isOfferToPlayer && this.playerResourceButtonNumber != 0 && this.player != null) {
            this.buttonVis = this.isOfferToPlayer && this.canPlayerGiveTradeResources();
            this.btns[this.playerResourceButtonNumber - 1].setVisible(this.buttonVis && this.buttonRowVis);
            if (this.isOfferToPlayer && this.buttonRowVis && !isCounterOfferVis) {
                mightWantAutoReject = true;
            } else {
                this.cancelRejectCountdown();
            }
        }
        SOCGame ga = this.hpan.getGame();
        StringBuilder names = new StringBuilder();
        for (cnt = 0; cnt < ga.maxPlayers; ++cnt) {
            if (!offerList[cnt] || ga.isSeatVacant(cnt)) continue;
            names.append(ga.getPlayer(cnt).getName());
            break;
        }
        ++cnt;
        while (cnt < ga.maxPlayers) {
            if (offerList[cnt] && !ga.isSeatVacant(cnt)) {
                names.append(", ");
                names.append(ga.getPlayer(cnt).getName());
            }
            ++cnt;
        }
        int maxChars = ga.maxPlayers > 4 || ga.hasSeaBoard ? 30 : 25;
        String names1 = strings.get("trade.offered.to", names);
        String names2 = null;
        if (names1.length() > maxChars && (i = names1.lastIndexOf(", ", maxChars)) != -1) {
            names2 = names1.substring(++i).trim();
            names1 = names1.substring(0, i).trim();
        }
        this.line1.setText(names1);
        this.line2.setText(names2 != null ? names2 : "");
        if (mightWantAutoReject) {
            int sec;
            if (this.rejTimerTask != null) {
                this.rejTimerTask.cancel();
                this.rejTimerTask = null;
            }
            if ((sec = this.pi.getBotTradeRejectSec()) > 0 && this.pi.getGame().getPlayer(offer.getFrom()).isRobot()) {
                this.lineBelow.setText(" ");
                this.lineBelow.setVisible(true);
                this.rejTimerTask = new AutoRejectTask(sec);
                this.pi.getEventTimer().scheduleAtFixedRate((TimerTask)this.rejTimerTask, 300L, 1000L);
            } else {
                this.lineBelow.setVisible(false);
                this.lineBelow.setText("");
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TradePanel.this.invalidate();
                TradePanel.this.validate();
            }
        });
    }

    public void updateOfferButtons() {
        if (this.playerResourceButtonNumber == 0) {
            return;
        }
        JButton btn = this.btns[this.playerResourceButtonNumber - 1];
        boolean hasRes = this.canPlayerGiveTradeResources();
        if (this.panelIsCounterOffer || this.panelPairOtherMember == null) {
            if (btn.isEnabled() != hasRes) {
                btn.setEnabled(hasRes);
            }
        } else {
            boolean canAccept;
            boolean bl = canAccept = this.isOfferToPlayer && hasRes;
            if (this.buttonVis != canAccept) {
                this.buttonVis = canAccept;
                btn.setVisible(this.buttonRowVis && this.buttonVis);
            }
        }
    }

    private void cancelRejectCountdown() {
        if (this.rejTimerTask != null) {
            this.rejTimerTask.cancel();
        }
        if (this.lineBelow.isVisible()) {
            this.lineBelow.setVisible(false);
        }
        this.lineBelow.setText("");
    }

    public boolean canPlayerGiveTradeResources() {
        if (this.player == null) {
            return false;
        }
        int[] res1 = new int[5];
        int[] res2 = new int[5];
        this.squares.getValues(res1, res2);
        return this.player.getResources().contains(this.isPlayerRow1 ? res1 : res2);
    }

    public void setPlayer(SOCPlayer pl, int playerResButtonNumber) {
        if (this.playerResourceButtonNumber != 0 && playerResButtonNumber == 0) {
            this.buttonVis = true;
            if (this.buttonRowVis) {
                this.btns[this.playerResourceButtonNumber - 1].setVisible(true);
            }
        }
        this.player = pl;
        this.playerResourceButtonNumber = playerResButtonNumber;
    }

    public void setButtonRowVisible(boolean shown, boolean clearLineBelow) {
        if (shown == this.buttonRowVis) {
            return;
        }
        if (clearLineBelow) {
            this.cancelRejectCountdown();
        }
        int btnVisIdx = this.playerResourceButtonNumber - 1;
        this.buttonRowVis = shown;
        for (int b = 0; b < 3; ++b) {
            if (b != btnVisIdx) {
                this.btns[b].setVisible(shown);
                continue;
            }
            this.btns[b].setVisible(shown && this.buttonVis);
        }
        this.invalidate();
    }

    public void setLine1Text(String txt) {
        if (txt == null) {
            txt = "";
        }
        this.line1.setText(txt);
    }

    public int getPreferredHeight(boolean ignoreButtonRow) {
        boolean hasLineBelow;
        int lineHeight = 14 * this.displayScale;
        int lineSpace = 3 * this.displayScale;
        int nLines = 1;
        if (this.line2 != null) {
            ++nLines;
        }
        boolean bl = hasLineBelow = this.lineBelow.getText().length() > 0;
        if (hasLineBelow) {
            ++nLines;
        }
        int h = (lineHeight + lineSpace) * nLines + lineSpace + 44 * this.displayScale + lineSpace;
        if (!ignoreButtonRow && this.buttonRowVis) {
            h += 20 * this.displayScale + lineSpace;
        }
        if (!hasLineBelow) {
            h += lineSpace;
        }
        return h;
    }

    @Override
    public Dimension getPreferredSize() {
        int bw;
        int w = 118 * this.displayScale + this.calcLabelWidth();
        if (w < (bw = 190 * this.displayScale)) {
            w = bw;
        }
        int h = this.getPreferredHeight(false);
        return new Dimension(w, h);
    }

    public int[] getCompactPreferredSize() {
        int w = 171 * this.displayScale + this.calcLabelWidth();
        int h = this.getPreferredHeight(true);
        return new int[]{w, h};
    }

    @Override
    public void doLayout() {
        Dimension dim = this.getSize();
        if (dim.width == 0 || dim.height == 0) {
            return;
        }
        int lineHeight = 14 * this.displayScale;
        int lineSpace = 3 * this.displayScale;
        boolean compactMode = dim.height < this.getPreferredHeight(false);
        int inset = 8 * this.displayScale;
        int squaresLabelW = this.calcLabelWidth() + (compactMode ? 2 : 6) * this.displayScale;
        int y = lineSpace;
        int w = dim.width - 2 * inset;
        this.line1.setBounds(inset, y, w, lineHeight);
        y += lineSpace + lineHeight;
        if (this.line2 != null) {
            if (compactMode) {
                w -= 57 * this.displayScale;
            }
            this.line2.setBounds(inset, y, w, lineHeight);
            y += lineSpace + lineHeight;
        }
        this.sqLabRow1.setBounds(inset, y, squaresLabelW, lineHeight);
        this.squares.setLocation(inset + squaresLabelW, y);
        this.sqLabRow2.setBounds(inset, y += 20 * this.displayScale, squaresLabelW, lineHeight);
        y += 20 * this.displayScale + lineSpace;
        if (compactMode) {
            int buttonX = inset + squaresLabelW + 98 * this.displayScale;
            int buttonW = 55 * this.displayScale;
            int buttonH = 18 * this.displayScale;
            int buttonMar = 2 * this.displayScale;
            int buttonY = ((dim.height / this.displayScale - 5 - 54) * this.displayScale - 2 * buttonMar) / 2;
            for (int b = 0; b < 3; ++b) {
                this.btns[b].setBounds(buttonX, buttonY, buttonW, buttonH);
                buttonY += buttonH + buttonMar;
            }
        } else if (this.buttonRowVis) {
            int buttonX = (dim.width - 5 * this.displayScale - 175 * this.displayScale) / 2;
            int buttonW = 55 * this.displayScale;
            int buttonH = 18 * this.displayScale;
            int pix5 = 5 * this.displayScale;
            for (int b = 0; b < 3; ++b) {
                this.btns[b].setBounds(buttonX, y, buttonW, buttonH);
                buttonX += pix5 + buttonW;
            }
            y += lineSpace + 18 * this.displayScale;
        }
        this.lineBelow.setBounds(inset, y, dim.width - 2 * inset, lineHeight);
    }

    private int calcLabelWidth() {
        if (this.sqLabWidth == 0) {
            FontMetrics fm = this.getFontMetrics(this.sqLabRow1.getFont());
            if (fm == null) {
                return 49 * this.displayScale;
            }
            this.sqLabWidth = Math.max(fm.stringWidth(this.sqLabRow1.getText()), fm.stringWidth(this.sqLabRow2.getText()));
        }
        return this.sqLabWidth;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object src = e.getSource();
            if (src == this.btn1) {
                this.listener.button1Clicked();
            } else if (src == this.btn2) {
                this.listener.button2Clicked();
            } else if (src == this.btn3) {
                this.listener.button3Clicked();
            }
        }
        catch (Throwable th) {
            this.pi.chatPrintStackTrace(th);
        }
    }

    private class AutoRejectTask
    extends TimerTask {
        public int secRemain;

        public AutoRejectTask(int sec) {
            this.secRemain = sec;
        }

        @Override
        public void run() {
            if (!TradePanel.this.lineBelow.isVisible() || !TradePanel.this.isVisible()) {
                TradePanel.this.lineBelow.setVisible(false);
                TradePanel.this.lineBelow.setText("");
                this.cancel();
                return;
            }
            if (this.secRemain > 0) {
                TradePanel.this.lineBelow.setText(strings.get("hpan.trade.auto_reject_countdown", this.secRemain));
                --this.secRemain;
            } else {
                TradePanel.this.lineBelow.setVisible(false);
                TradePanel.this.lineBelow.setText("");
                final TPListener lis = TradePanel.this.listener;
                if (lis != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            lis.button2Clicked();
                        }
                    });
                }
                this.cancel();
            }
        }
    }

    public static interface TPListener {
        public void button1Clicked();

        public void button2Clicked();

        public void button3Clicked();
    }
}

