/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.EventQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import soc.client.SOCPlayerInterface;

public class UserPreferences {
    private static Preferences userPrefs;

    public static boolean getPref(String prefKey, boolean dflt) {
        if (userPrefs == null) {
            return dflt;
        }
        try {
            return userPrefs.getBoolean(prefKey, dflt);
        }
        catch (RuntimeException e) {
            return dflt;
        }
    }

    public static int getPref(String prefKey, int dflt) {
        if (userPrefs == null) {
            return dflt;
        }
        try {
            return userPrefs.getInt(prefKey, dflt);
        }
        catch (RuntimeException e) {
            return dflt;
        }
    }

    public static void putPref(String prefKey, boolean val) throws NullPointerException, IllegalArgumentException {
        if (userPrefs == null) {
            return;
        }
        try {
            userPrefs.putBoolean(prefKey, val);
            UserPreferences.flushSoon();
        }
        catch (IllegalStateException e) {
            System.err.println("Error setting userPref " + prefKey + ": " + e);
        }
    }

    public static void putPref(String prefKey, int val) throws NullPointerException, IllegalArgumentException {
        if (userPrefs == null) {
            return;
        }
        try {
            userPrefs.putInt(prefKey, val);
            UserPreferences.flushSoon();
        }
        catch (IllegalStateException e) {
            System.err.println("Error setting userPref " + prefKey + ": " + e);
        }
    }

    private static void flushSoon() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    userPrefs.flush();
                }
                catch (BackingStoreException e) {
                    System.err.println("Error writing userPrefs: " + e);
                }
            }
        });
    }

    public static final void clear(String prefKeyList) {
        if (prefKeyList == null || prefKeyList.length() == 0 || userPrefs == null) {
            return;
        }
        for (String key : prefKeyList.split(",")) {
            try {
                userPrefs.remove(key);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            userPrefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        System.err.println("Cleared user preferences: " + prefKeyList);
    }

    static {
        Logger logger = null;
        Level currLevel = null;
        try {
            logger = Logger.getLogger("java.util.prefs");
            currLevel = logger.getLevel();
            logger.setLevel(Level.SEVERE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            userPrefs = Preferences.userNodeForPackage(SOCPlayerInterface.class);
            int i = UserPreferences.getPref("nonExistentDummy", 0);
            if (i != 42 && currLevel != null) {
                logger.setLevel(currLevel);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

