/*
 * Decompiled with CFR 0.152.
 */
package soc.client.stats;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import soc.client.ColorSquare;
import soc.client.SOCPlayerInterface;
import soc.client.stats.SOCGameStatistics;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.util.SOCStringManager;

public class GameStatisticsFrame
extends JFrame
implements SOCGameStatistics.Listener {
    private static final SOCStringManager strings = SOCStringManager.getClientManager();
    private final SOCPlayerInterface pi;
    private final int displayScale;
    private SOCGameStatistics.ListenerRegistration reg;
    private RollPanel rollPanel;
    private MiscStatsPanel miscPanel;
    private YourPlayerPanel yourPlayerPanel;
    private SOCGameStatistics lastStats;

    public GameStatisticsFrame(SOCPlayerInterface pi, int displayScale) {
        this.setTitle(strings.get("dialog.stats.title"));
        this.pi = pi;
        this.displayScale = displayScale;
        Container cpane = this.getContentPane();
        cpane.setLayout(new BoxLayout(cpane, 1));
        this.createControls();
        this.pack();
    }

    public void register(SOCGameStatistics stats) {
        this.reg = stats.addListener(this);
        this.statsUpdated(stats, null);
    }

    @Override
    public void dispose() {
        if (this.reg != null) {
            this.reg.unregister();
        }
        super.dispose();
    }

    @Override
    public void statsUpdated(SOCGameStatistics stats, SOCGameStatistics.GameStatisticsEvent event) {
        if (stats != null) {
            this.lastStats = stats;
        }
        if (event == null || event instanceof SOCGameStatistics.DiceRollEvent) {
            this.rollPanel.refresh(stats);
            this.miscPanel.refreshFromGame();
        }
        if (this.yourPlayerPanel != null) {
            this.yourPlayerPanel.refreshFromGame(event);
        }
    }

    @Override
    public void statsDisposing() {
        this.dispose();
    }

    private void createControls() {
        JTabbedPane tabs = new JTabbedPane();
        this.rollPanel = new RollPanel();
        tabs.addTab(strings.get("dialog.stats.dice_rolls.title"), this.rollPanel);
        this.getContentPane().add(tabs);
        int serverVersion = this.pi.getClient().getServerVersion(this.pi.getGame());
        if (serverVersion >= 2000) {
            tabs = new JTabbedPane();
            this.yourPlayerPanel = new YourPlayerPanel(serverVersion);
            tabs.addTab(strings.get("dialog.stats.your_player.title"), this.yourPlayerPanel);
            this.getContentPane().add(tabs);
        }
        tabs = new JTabbedPane();
        this.miscPanel = new MiscStatsPanel();
        tabs.addTab(strings.get("dialog.stats.other_stats.title"), this.miscPanel);
        this.getContentPane().add(tabs);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GameStatisticsFrame.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public static JLabel createStatControlRow(int rownum, String label, GridBagConstraints gbc, Container addTo) {
        gbc.gridy = rownum;
        JLabel jl = new JLabel(label);
        gbc.gridx = 0;
        gbc.anchor = 21;
        addTo.add((Component)jl, gbc);
        jl = new JLabel();
        gbc.gridx = 1;
        gbc.anchor = 21;
        addTo.add((Component)jl, gbc);
        return jl;
    }

    private class CheckActionListener
    implements ActionListener {
        private CheckActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GameStatisticsFrame.this.rollPanel.refresh(GameStatisticsFrame.this.lastStats);
        }
    }

    private class RollBar
    extends JComponent {
        private double percent;
        private int value;

        public RollBar() {
            Dimension size = new Dimension(20, 30);
            this.setDoubleBuffered(true);
            this.setMinimumSize(size);
            this.setPreferredSize(size);
            this.value = 0;
        }

        public void setValue(int value, int max) {
            if (max < 1) {
                max = 1;
            }
            if (value < 0) {
                value = 0;
            }
            this.value = value;
            this.percent = (double)value / (double)max;
            if (this.percent < 0.0) {
                this.percent = 0.0;
            }
            if (this.percent > 1.0) {
                this.percent = 1.0;
            }
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Dimension sz = this.getSize();
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, sz.width - 1, sz.height - 1);
            g.setColor(Color.BLUE);
            int h = (int)((double)(sz.height - 1) * this.percent);
            g.fillRect(1, sz.height - h, sz.width - 2, sz.height - 2);
            if (this.value > 0) {
                int y;
                Font BAR_FONT = new Font("SansSerif", 0, 12);
                int fHeight = 2 + g.getFontMetrics(BAR_FONT).getAscent();
                if (h < fHeight) {
                    g.setColor(Color.BLACK);
                    y = sz.height - h - 2;
                } else {
                    g.setColor(Color.CYAN);
                    y = sz.height - 2;
                }
                g.setFont(BAR_FONT);
                g.drawString(String.valueOf(this.value), 2, y);
            }
        }
    }

    private class RollPanel
    extends JPanel {
        int[] values;
        List<JCheckBox> playerEnabled;
        private RollBar[] displays;

        public RollPanel() {
            super(true);
            this.values = new int[13];
            this.displays = new RollBar[13];
            this.createControls();
        }

        public void refresh(SOCGameStatistics stats) {
            if (stats == null) {
                return;
            }
            StringBuilder sb = new StringBuilder("<html>");
            for (int i = 2; i < ((GameStatisticsFrame)GameStatisticsFrame.this).rollPanel.values.length; ++i) {
                int r = 0;
                if (i > 2) {
                    sb.delete(6, sb.length());
                }
                sb.append(strings.get("dialog.stats.dice_rolls.ttip_roll", i));
                SOCGame ga = GameStatisticsFrame.this.pi.getGame();
                for (SOCPlayer p : ga.getPlayers()) {
                    int v;
                    int pn = p.getPlayerNumber();
                    if (ga.isSeatVacant(pn) && p.getPublicVP() == 0 || !this.playerEnabled.get(pn).isSelected() || (v = stats.getRollCount(i, pn)) == -1) continue;
                    sb.append(this.getPlayerName(p)).append(": ").append(v).append("<br/>");
                    r += v;
                }
                sb.append("</html>");
                ((GameStatisticsFrame)GameStatisticsFrame.this).rollPanel.values[i] = r;
                ((GameStatisticsFrame)GameStatisticsFrame.this).rollPanel.displays[i].setToolTipText(sb.toString());
            }
            GameStatisticsFrame.this.rollPanel.repaint();
        }

        private void createControls() {
            JComponent lbl;
            int i;
            this.setLayout(new BoxLayout(this, 1));
            JPanel selectPanel = new JPanel();
            this.add(selectPanel);
            SOCPlayer[] players = GameStatisticsFrame.this.pi.getGame().getPlayers();
            selectPanel.setLayout(new BoxLayout(selectPanel, 0));
            JButton all = new JButton(strings.get("dialog.stats.dice_rolls.all"));
            selectPanel.add(all);
            this.playerEnabled = new ArrayList<JCheckBox>();
            SOCGame ga = GameStatisticsFrame.this.pi.getGame();
            for (int pn = 0; pn < ((GameStatisticsFrame)GameStatisticsFrame.this).pi.getGame().maxPlayers; ++pn) {
                JCheckBox cb = new JCheckBox(this.getPlayerName(players[pn]), true);
                if (ga.isSeatVacant(pn) && ga.getPlayer(pn).getPublicVP() == 0) {
                    cb.setVisible(false);
                } else {
                    cb.addActionListener(new CheckActionListener());
                }
                selectPanel.add(cb);
                this.playerEnabled.add(cb);
            }
            all.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (JCheckBox cb : RollPanel.this.playerEnabled) {
                        cb.setSelected(true);
                    }
                    RollPanel.this.refresh(GameStatisticsFrame.this.lastStats);
                }
            });
            JPanel displayPanel = new JPanel(true);
            this.add(displayPanel);
            displayPanel.setLayout(new GridLayout(2, 10));
            for (i = 2; i <= 12; ++i) {
                lbl = new RollBar();
                this.displays[i] = lbl;
                displayPanel.add(lbl);
            }
            for (i = 2; i <= 12; ++i) {
                lbl = new JLabel(String.valueOf(i));
                ((JLabel)lbl).setHorizontalAlignment(0);
                displayPanel.add(lbl);
            }
        }

        private String getPlayerName(SOCPlayer pl) {
            String plName = pl.getName();
            if (plName == null || plName.isEmpty()) {
                plName = strings.get("base.player_n", pl.getPlayerNumber());
            }
            return plName;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int i;
            int max = 0;
            for (i = 2; i < this.values.length; ++i) {
                max = Math.max(max, this.values[i]);
            }
            for (i = 2; i < this.values.length; ++i) {
                if (max <= 0) {
                    this.displays[i].setValue(0, 0);
                    continue;
                }
                this.displays[i].setValue(this.values[i], max);
            }
            super.paintComponent(g);
        }
    }

    private class YourPlayerPanel
    extends JPanel {
        private SOCPlayer pl;
        private final ColorSquare[] resRolls;
        private final ColorSquare resRollsGold;
        private final JLabel resRollsGoldLab;
        private final JLabel resTrades;

        public YourPlayerPanel(int serverVersion) throws IllegalArgumentException {
            super(true);
            this.resRolls = new ColorSquare[5];
            if (serverVersion < 2000) {
                throw new IllegalArgumentException("serverVersion");
            }
            Border pad4 = BorderFactory.createEmptyBorder(4 * GameStatisticsFrame.this.displayScale, 4 * GameStatisticsFrame.this.displayScale, 4 * GameStatisticsFrame.this.displayScale, 4 * GameStatisticsFrame.this.displayScale);
            this.setBorder(pad4);
            this.setLayout(new BoxLayout(this, 1));
            this.pl = null;
            Box rollSquaresRow = Box.createHorizontalBox();
            JLabel jl = new JLabel(strings.get("stats.rolls.resource_rolls"));
            jl.setBorder(pad4);
            rollSquaresRow.add(jl);
            rollSquaresRow.add(Box.createHorizontalGlue());
            int sqWidth = 20 * GameStatisticsFrame.this.displayScale;
            for (int rtype = 1; rtype <= 5; ++rtype) {
                ColorSquare sq = new ColorSquare(ColorSquare.RESOURCE_COLORS[rtype - 1], 0, sqWidth, sqWidth);
                sq.setMaximumSizeToCurrent();
                this.resRolls[rtype - 1] = sq;
                rollSquaresRow.add(sq);
            }
            rollSquaresRow.setAlignmentX(0.0f);
            this.add(rollSquaresRow);
            Box rollGoldRow = Box.createHorizontalBox();
            this.resRollsGoldLab = new JLabel(strings.get("stats.gold_gains.title"));
            this.resRollsGoldLab.setBorder(pad4);
            this.resRollsGoldLab.setVisible(false);
            this.resRollsGold = new ColorSquare(ColorSquare.GOLD, 0, sqWidth, sqWidth);
            this.resRollsGold.setVisible(false);
            this.resRollsGold.setMaximumSizeToCurrent();
            rollGoldRow.add(this.resRollsGoldLab);
            rollGoldRow.add(Box.createHorizontalGlue());
            rollGoldRow.add(this.resRollsGold);
            rollGoldRow.setAlignmentX(0.0f);
            this.add(rollGoldRow);
            if (serverVersion >= 2500) {
                jl = new JLabel("<html><B>" + strings.get("game.trade.stats.heading_short") + "</B> " + strings.get("game.trade.stats.heading_give_get") + "</html>");
                jl.setAlignmentX(0.0f);
                jl.setBorder(pad4);
                this.add(jl);
                this.resTrades = new JLabel();
                this.resTrades.setAlignmentX(0.0f);
                this.resTrades.setBorder(pad4);
                this.add(this.resTrades);
            } else {
                this.resTrades = null;
            }
            this.refreshFromGame(null);
        }

        public void refreshFromGame(SOCGameStatistics.GameStatisticsEvent event) {
            boolean hasSetPlayer = false;
            SOCPlayer piPlayer = GameStatisticsFrame.this.pi.getClientPlayer();
            if (this.pl != piPlayer) {
                if (this.pl == null) {
                    // empty if block
                }
                this.pl = piPlayer;
                hasSetPlayer = true;
            }
            if (this.pl == null) {
                return;
            }
            if (event == null || event instanceof SOCGameStatistics.ResourceRollReceivedEvent) {
                int prevGold;
                int gold;
                int[] rollStats = this.pl.getResourceRollStats();
                for (int rtype = 1; rtype <= 5; ++rtype) {
                    this.resRolls[rtype - 1].setIntValue(rollStats[rtype]);
                }
                if (rollStats.length > 6 && (gold = rollStats[6]) > 0 && gold != (prevGold = this.resRollsGold.getIntValue())) {
                    this.resRollsGold.setIntValue(gold);
                    if (prevGold == 0) {
                        this.resRollsGoldLab.setVisible(true);
                        this.resRollsGold.setVisible(true);
                        this.revalidate();
                    }
                }
            }
            if ((event == null || event instanceof SOCGameStatistics.ResourceTradeEvent) && this.resTrades != null) {
                StringBuilder sb = new StringBuilder();
                List<String> stats = GameStatisticsFrame.this.pi.getClientListener().playerStats(2, null, false, false);
                if (sb != null) {
                    sb.append("<html>");
                    boolean any = false;
                    for (String s : stats) {
                        if (any) {
                            sb.append("<br>");
                        } else {
                            any = true;
                        }
                        sb.append(s);
                    }
                    sb.append("</html>");
                }
                this.resTrades.setText(sb.toString());
                if (hasSetPlayer) {
                    this.revalidate();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GameStatisticsFrame.this.pack();
                        }
                    });
                }
            }
        }
    }

    private class MiscStatsPanel
    extends JPanel {
        private JLabel roundNum;

        public MiscStatsPanel() {
            super(true);
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            this.setLayout(gbl);
            gbc.ipadx = 8 * GameStatisticsFrame.this.displayScale;
            gbc.ipady = 8 * GameStatisticsFrame.this.displayScale;
            this.roundNum = GameStatisticsFrame.createStatControlRow(0, strings.get("dialog.stats.current_round"), gbc, this);
        }

        public void refreshFromGame() {
            SOCGame ga = GameStatisticsFrame.this.pi.getGame();
            this.roundNum.setText(Integer.toString(ga.getRoundCount()));
        }
    }
}

