/*
 * Decompiled with CFR 0.152.
 */
package soc.client.stats;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import soc.game.SOCGame;
import soc.game.SOCPlayer;

public class SOCGameStatistics {
    private final AtomicReference<Listener> listener = new AtomicReference();
    private final DiceRolls rolls;

    public SOCGameStatistics(SOCGame game) {
        List<SOCPlayer> ps = Arrays.asList(game.getPlayers());
        this.rolls = new DiceRolls(ps);
    }

    public void dispose() {
        Listener old = this.listener.get();
        if (old != null) {
            old.statsDisposing();
        }
    }

    public ListenerRegistration addListener(Listener statsListener) {
        Listener old = this.listener.getAndSet(statsListener);
        if (old != null) {
            old.statsDisposing();
        }
        return new ListenerRegistration(){

            @Override
            public void unregister() {
                SOCGameStatistics.this.listener.set(null);
            }
        };
    }

    protected void fire(GameStatisticsEvent evt) {
        Listener ears = this.listener.get();
        if (ears != null) {
            ears.statsUpdated(this, evt);
        }
    }

    public void diceRolled(DiceRollEvent evt) {
        try {
            this.rolls.rollCounts[evt.player.getPlayerNumber()].incrementAndGet(evt.roll);
            this.fire(evt);
        }
        catch (Exception e) {
            System.err.println("Failed updating dice roll " + evt);
            e.printStackTrace();
        }
    }

    public void resourceRollReceived() {
        this.fire(ResourceRollReceivedEvent.SINGLETON);
    }

    public void resourceTraded() {
        this.fire(ResourceTradeEvent.SINGLETON);
    }

    public int getRollCount(int roll, int pn) {
        if (roll < 2 || roll > 12) {
            return -1;
        }
        if (pn < 0 || pn >= this.rolls.rollCounts.length) {
            return -1;
        }
        return this.rolls.rollCounts[pn].get(roll);
    }

    private static class DiceRolls {
        AtomicIntegerArray[] rollCounts;

        public DiceRolls(List<SOCPlayer> players) {
            this.rollCounts = new AtomicIntegerArray[players.size()];
            for (int i = 0; i < this.rollCounts.length; ++i) {
                this.rollCounts[i] = new AtomicIntegerArray(13);
            }
        }
    }

    public static class ResourceTradeEvent
    extends GameStatisticsEvent {
        public static final ResourceTradeEvent SINGLETON = new ResourceTradeEvent();
    }

    public static class ResourceRollReceivedEvent
    extends GameStatisticsEvent {
        public static final ResourceRollReceivedEvent SINGLETON = new ResourceRollReceivedEvent();
    }

    public static class DiceRollEvent
    extends GameStatisticsEvent {
        public final int roll;
        public final SOCPlayer player;

        public DiceRollEvent(int rolledNumber, SOCPlayer rollingPlayer) {
            this.roll = rolledNumber;
            this.player = rollingPlayer;
        }

        public String toString() {
            return "DiceRollEvent[" + this.roll + " " + this.player.getName() + ":" + this.player.getPlayerNumber() + "]";
        }
    }

    public static class GameStatisticsEvent {
    }

    public static interface ListenerRegistration {
        public void unregister();
    }

    public static interface Listener {
        public void statsUpdated(SOCGameStatistics var1, GameStatisticsEvent var2);

        public void statsDisposing();
    }
}

