/*
 * Decompiled with CFR 0.152.
 */
package soc.debug;

public class D {
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int FATAL = 3;
    private static int level = 0;
    public static final boolean ebugOn = true;
    private static boolean enabled = true;

    public static void setLevel(int l) throws IllegalArgumentException {
        if (l < 0 || l > 3) {
            throw new IllegalArgumentException("level");
        }
        level = l;
    }

    public static int ebug_level() {
        return level;
    }

    public static final void ebug_enable() {
        enabled = true;
    }

    public static final void ebug_disable() {
        enabled = false;
    }

    public static final boolean ebugIsEnabled() {
        return enabled;
    }

    public static final void ebugPrintln(String text) {
        if (enabled) {
            System.out.println(text);
        }
    }

    public static final void ebugPrintln() {
        if (enabled) {
            System.out.println();
        }
    }

    public static final void ebugPrint(String text) {
        if (enabled) {
            System.out.print(text);
        }
    }

    public static final void ebugPrintlnINFO(String text) {
        if (enabled && level == 0) {
            System.out.println(text);
        }
    }

    public static final void ebugPrintlnINFO(String prefix, String text) {
        if (enabled && level == 0) {
            System.out.println(prefix + ":" + text);
        }
    }

    public static final void ebugPrintlnINFO() {
        if (enabled && level == 0) {
            System.out.println();
        }
    }

    public static final void ebugPrintINFO(String text) {
        if (enabled && level == 0) {
            System.out.print(text);
        }
    }

    public final void debug(String text) {
        D.ebugPrintln(text);
    }

    public static final void ebugPrintStackTrace(Throwable ex, String prefixMsg) {
        if (!enabled) {
            return;
        }
        if (ex == null) {
            try {
                int x = 0;
                int y = x / 0;
                System.out.print(y);
            }
            catch (Throwable th) {
                ex = th;
            }
        }
        if (prefixMsg != null) {
            StringBuilder sb = new StringBuilder(prefixMsg);
            sb.append(" - ");
            sb.append(ex.getClass().getName());
            String det = ex.getMessage();
            if (det != null) {
                sb.append(": ");
                sb.append(det);
            }
            D.ebugPrintln(sb.toString());
        }
        System.out.println("-- Exception stack trace begins -- Thread: " + Thread.currentThread().getName());
        ex.printStackTrace(System.out);
        Throwable prev = ex;
        Throwable cause = prev.getCause();
        while (cause != null && cause != prev) {
            System.out.println("** --> Nested cause exception: **");
            cause.printStackTrace(System.out);
            prev = cause;
        }
        System.out.println("-- Exception ends: " + ex.getClass().getName() + " --");
    }

    public static final void ebugFATAL(Throwable ex, String prefixMsg) {
        D.ebugPrintStackTrace(ex, prefixMsg);
    }

    public static final void ebugWARNING(String text) {
        if (enabled && level <= 1) {
            System.out.println("WARN: " + text);
        }
    }

    public static final void ebugWARNING(String prefix, String text) {
        if (enabled && level <= 1) {
            System.out.println("WARN: " + prefix + " " + text);
        }
    }

    public static final void ebugERROR(String text) {
        if (enabled && level <= 2) {
            System.out.println("ERR: " + text);
        }
    }

    public static final void ebugERROR(String prefix, String text) {
        if (enabled && level <= 2) {
            System.out.println("ERR: " + prefix + " " + text);
        }
    }
}

