/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.util.Arrays;
import java.util.List;
import soc.game.ResourceSet;

public class GameAction {
    public final ActionType actType;
    public final int param1;
    public final int param2;
    public final int param3;
    public final ResourceSet rset1;
    public final ResourceSet rset2;
    public final List<Effect> effects;
    public volatile String cannotUndoReason;

    public GameAction(ActionType aType) throws IllegalArgumentException {
        this(aType, 0, 0, 0, null, null);
    }

    public GameAction(ActionType aType, int p1, int p2, int p3) throws IllegalArgumentException {
        this(aType, p1, p2, p3, null, null, null);
    }

    public GameAction(ActionType aType, int p1, int p2, int p3, List<Effect> effects) throws IllegalArgumentException {
        this(aType, p1, p2, p3, null, null, effects);
    }

    public GameAction(GameAction copyFrom, ActionType aType, int p1, int p2, int p3) throws IllegalArgumentException, NullPointerException {
        this(aType, p1, p2, p3, copyFrom.rset1, copyFrom.rset2, copyFrom.effects);
    }

    public GameAction(ActionType aType, ResourceSet rs1, ResourceSet rs2) {
        this(aType, 0, 0, 0, rs1, rs2);
    }

    public GameAction(ActionType aType, int p1, int p2, int p3, ResourceSet rs1, ResourceSet rs2) throws IllegalArgumentException {
        this(aType, p1, p2, p3, rs1, rs2, null);
    }

    public GameAction(ActionType aType, int p1, int p2, int p3, ResourceSet rs1, ResourceSet rs2, List<Effect> effects) throws IllegalArgumentException {
        if (aType == null) {
            throw new IllegalArgumentException("aType");
        }
        this.actType = aType;
        this.param1 = p1;
        this.param2 = p2;
        this.param3 = p3;
        this.rset1 = rs1;
        this.rset2 = rs2;
        this.effects = effects;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GameAction(");
        sb.append(this.actType.toString());
        if (this.param1 != 0 || this.param2 != 0 || this.param3 != 0) {
            sb.append(", p1=").append(this.param1);
            if (this.param2 != 0 || this.param3 != 0) {
                sb.append(", p2=").append(this.param2);
                if (this.param3 != 0) {
                    sb.append(", p3=").append(this.param3);
                }
            }
        }
        if (this.rset1 != null || this.rset2 != null) {
            sb.append(", rs1=").append(this.rset1);
            if (this.rset2 != null) {
                sb.append(", rs2=").append(this.rset2);
            }
        }
        if (this.effects != null) {
            sb.append(", e=").append(this.effects);
        }
        if (this.cannotUndoReason != null) {
            sb.append(", cannotUndo=").append(this.cannotUndoReason);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof GameAction)) {
            return false;
        }
        GameAction oga = (GameAction)o;
        return this.actType == oga.actType && this.param1 == oga.param1 && this.param2 == oga.param2 && this.param3 == oga.param3 && (this.rset1 == null ? oga.rset1 == null : this.rset1.equals(oga.rset1)) && (this.rset2 == null ? oga.rset2 == null : this.rset2.equals(oga.rset2)) && (this.cannotUndoReason == null ? oga.cannotUndoReason == null : this.cannotUndoReason.equals(oga.cannotUndoReason)) && (this.effects == null ? oga.effects == null : this.effects.equals(oga.effects));
    }

    public static class Effect {
        public final EffectType eType;
        public final int[] params;

        public Effect(EffectType et) throws IllegalArgumentException {
            this(et, null);
        }

        public Effect(EffectType et, int[] p) throws IllegalArgumentException {
            if (et == null) {
                throw new IllegalArgumentException("eType");
            }
            if (p != null && p.length == 0) {
                throw new IllegalArgumentException("params");
            }
            this.eType = et;
            this.params = p;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.eType.toString());
            if (this.params != null) {
                sb.append('(');
                for (int i = 0; i < this.params.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.params[i]);
                }
                sb.append(')');
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Effect)) {
                return false;
            }
            Effect oe = (Effect)o;
            return this.eType == oe.eType && Arrays.equals(this.params, oe.params);
        }
    }

    public static enum EffectType {
        UNINITIALIZED(0),
        UNKNOWN(1),
        DEDUCT_COST_FROM_PLAYER(10),
        CHANGE_GAMESTATE(20),
        CHANGE_LONGEST_ROAD_PLAYER(30),
        CHANGE_LARGEST_ARMY_PLAYER(40),
        PLAYER_GAIN_SVP(50),
        PLAYER_GAIN_SETTLED_LANDAREA(60),
        GAME_SET_HAS_BUILT_CITY_N7C(70),
        CLOSE_SHIP_ROUTE(80),
        REVEAL_FOG_HEX(90),
        PLAYER_SET_EVENT_FLAGS(100),
        PLAYER_GAIN_INVENTORY_ITEM(110),
        PLAYER_SCEN_CLVI_RECEIVE_CLOTH(120),
        PLAYER_SCEN_FTRI_REACHED_SPECIAL_EDGE(130),
        GAME_SCEN_FTRI_PORT_REMOVED(140),
        GAME_SCEN_FTRI_PORT_PLACED(150);

        public final int value;

        private EffectType(int v) {
            this.value = v;
        }

        public static EffectType valueOf(int ti) {
            for (EffectType t : EffectType.values()) {
                if (t.value != ti) continue;
                return t;
            }
            return null;
        }
    }

    public static enum ActionType {
        UNINITIALIZED(0),
        UNKNOWN(1),
        PLACEHOLDER_CURRENT_ACTION_CANNOT_UNDO(2),
        LOG_START_TO_STARTGAME(10),
        TURN_BEGINS(20),
        ROLL_DICE(30),
        BUILD_PIECE(40),
        UNDO_BUILD_PIECE(45),
        CANCEL_BUILT_PIECE(50),
        MOVE_PIECE(60),
        UNDO_MOVE_PIECE(65),
        BUY_DEV_CARD(70),
        PLAY_DEV_CARD(80),
        DISCARD(90),
        CHOOSE_FREE_RESOURCES(100),
        CHOOSE_MOVE_ROBBER_OR_PIRATE(110),
        SHIP_CONVERT_TO_WARSHIP(111),
        MOVE_ROBBER_OR_PIRATE(120),
        CHOOSE_ROBBERY_VICTIM(130),
        CHOOSE_ROB_CLOTH_OR_RESOURCE(140),
        ROB_PLAYER(150),
        TRADE_BANK(160),
        TRADE_MAKE_OFFER(170),
        TRADE_CLEAR_OFFER(180),
        TRADE_REJECT_OFFER(190),
        TRADE_ACCEPT_OFFER(200),
        ASK_SPECIAL_BUILDING(210),
        END_TURN(220),
        GAME_OVER(230);

        public final int value;

        private ActionType(int v) {
            this.value = v;
        }

        public static ActionType valueOf(int ti) {
            for (ActionType t : ActionType.values()) {
                if (t.value != ti) continue;
                return t;
            }
            return null;
        }
    }
}

