/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import soc.game.SOCBoard4p;
import soc.game.SOCBoard6p;
import soc.game.SOCBoardLarge;
import soc.game.SOCCity;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCPlayingPiece;
import soc.game.SOCRoutePiece;
import soc.game.SOCSettlement;

public abstract class SOCBoard
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2000L;
    public static final int WATER_HEX = 0;
    public static final int CLAY_HEX = 1;
    public static final int ORE_HEX = 2;
    public static final int SHEEP_HEX = 3;
    public static final int WHEAT_HEX = 4;
    public static final int WOOD_HEX = 5;
    public static final int DESERT_HEX = 6;
    private static final int MAX_LAND_HEX = 6;
    public static final int MISC_PORT_HEX = 7;
    public static final int CLAY_PORT_HEX = 8;
    public static final int ORE_PORT_HEX = 9;
    public static final int SHEEP_PORT_HEX = 10;
    public static final int WHEAT_PORT_HEX = 11;
    public static final int WOOD_PORT_HEX = 12;
    public static final int MISC_PORT = 0;
    public static final int CLAY_PORT = 1;
    public static final int ORE_PORT = 2;
    public static final int SHEEP_PORT = 3;
    public static final int WHEAT_PORT = 4;
    public static final int WOOD_PORT = 5;
    public static final int FACING_NE = 1;
    public static final int FACING_E = 2;
    public static final int FACING_SE = 3;
    public static final int FACING_SW = 4;
    public static final int FACING_W = 5;
    public static final int FACING_NW = 6;
    public static final int WIDTH_VISUAL_ORIGINAL = 13;
    public static final int HEIGHT_VISUAL_ORIGINAL = 14;
    public static final int BOARD_ENCODING_ORIGINAL = 1;
    public static final int BOARD_ENCODING_6PLAYER = 2;
    public static final int BOARD_ENCODING_LARGE = 3;
    public static final int MAX_BOARD_ENCODING = 3;
    protected int boardWidth;
    protected int boardHeight;
    protected int minNode;
    protected int minEdge;
    protected int maxEdge;
    protected final int boardEncodingFormat;
    protected static final int MAXHEX = 221;
    protected static final int MINHEX = 17;
    private static final int MAXNODE = 220;
    private int[] hexLayout = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected int[] portsLayout;
    private int[] numberLayout = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private int[] numToHexID = new int[]{23, 57, 91, 125, 21, 55, 89, 123, 157, 19, 53, 87, 121, 155, 189, 17, 51, 85, 119, 153, 187, 221, 49, 83, 117, 151, 185, 219, 81, 115, 149, 183, 217, 113, 147, 181, 215};
    private int[] hexIDtoNum;
    protected HashMap<Integer, Integer> nodeIDtoPortType;
    private static final int[] HEXNODES = new int[]{1, 18, 33, 16, -1, -16};
    private static final int[] NODE_2_AWAY = new int[]{-9, 2, 34, 32, -2, -34, -32};
    private int robberHex = -1;
    private int prevRobberHex = -1;
    public final int max_robber_hextype;
    protected List<Integer>[] ports = new ArrayList[6];
    protected List<SOCRoutePiece> roadsAndShips = new ArrayList<SOCRoutePiece>(60);
    protected List<SOCSettlement> settlements = new ArrayList<SOCSettlement>(20);
    protected List<SOCCity> cities = new ArrayList<SOCCity>(16);
    protected Random rand = new Random();
    protected HashSet<Integer> nodesOnLand = new HashSet();
    private static final String[][] PORT_DESC_FOR_TYPE = new String[][]{{"game.port.three", "game.port.clay", "game.port.ore", "game.port.sheep", "game.port.wheat", "game.port.wood", "game.port.generic"}, {"game.aport.three", "game.aport.clay", "game.aport.ore", "game.aport.sheep", "game.aport.wheat", "game.aport.wood", "game.aport.generic"}};

    protected SOCBoard(int boardEncodingFmt, int maxRobberHextype) throws IllegalArgumentException {
        if (boardEncodingFmt < 1 || boardEncodingFmt > 3) {
            throw new IllegalArgumentException(Integer.toString(boardEncodingFmt));
        }
        this.boardEncodingFormat = boardEncodingFmt;
        this.max_robber_hextype = maxRobberHextype;
        this.ports[0] = new ArrayList<Integer>(8);
        for (int i = 1; i <= 5; ++i) {
            this.ports[i] = new ArrayList<Integer>(2);
        }
    }

    protected SOCBoard(SOCGameOptionSet gameOpts, int maxPlayers, int boardEncodingFmt) throws IllegalArgumentException {
        this(boardEncodingFmt, 6);
        if (maxPlayers != 4 && maxPlayers != 6) {
            throw new IllegalArgumentException("maxPlayers: " + maxPlayers);
        }
        this.boardWidth = 16;
        this.boardHeight = 16;
        this.hexIDtoNum = new int[238];
        for (int i = 0; i < 238; ++i) {
            this.hexIDtoNum[i] = -1;
        }
        this.initHexIDtoNumAux(23, 125, 0);
        this.initHexIDtoNumAux(21, 157, 4);
        this.initHexIDtoNumAux(19, 189, 9);
        this.initHexIDtoNumAux(17, 221, 15);
        this.initHexIDtoNumAux(49, 219, 22);
        this.initHexIDtoNumAux(81, 217, 28);
        this.initHexIDtoNumAux(113, 215, 33);
        this.initNodesOnLand();
    }

    private void initNodesOnLand() {
        int i;
        int westAdj;
        boolean is6player = this.boardEncodingFormat == 2;
        this.nodesOnLand = new HashSet();
        int n = westAdj = is6player ? 34 : 0;
        if (is6player) {
            for (i = 7; i <= 109; i += 17) {
                this.nodesOnLand.add(i);
            }
        }
        for (i = 39 - westAdj; i <= 141; i += 17) {
            this.nodesOnLand.add(i);
        }
        for (i = 37 - westAdj; i <= 173; i += 17) {
            this.nodesOnLand.add(i);
        }
        for (i = 35 - westAdj; i <= 205; i += 17) {
            this.nodesOnLand.add(i);
        }
        for (i = 50 - westAdj; i <= 220; i += 17) {
            this.nodesOnLand.add(i);
        }
        for (i = 82 - westAdj; i <= 218; i += 17) {
            this.nodesOnLand.add(i);
        }
        for (i = 114 - westAdj; i <= 216; i += 17) {
            this.nodesOnLand.add(i);
        }
        if (is6player) {
            for (i = 112; i <= 214; i += 17) {
                this.nodesOnLand.add(i);
            }
        }
    }

    private void initHexIDtoNumAux(int begin, int end, int num) {
        for (int i = begin; i <= end; i += 34) {
            this.hexIDtoNum[i] = num++;
        }
    }

    public void makeNewBoard(SOCGameOptionSet opts) {
        boolean is6player = this.boardEncodingFormat == 2;
        SOCGameOption opt_breakClumps = opts != null ? opts.get("BC") : null;
        int[] landHex = is6player ? SOCBoard6p.makeNewBoard_landHexTypes_v2 : SOCBoard4p.makeNewBoard_landHexTypes_v1;
        int[][] numPaths = is6player ? SOCBoard6p.makeNewBoard_numPaths_v2 : SOCBoard4p.makeNewBoard_numPaths_v1;
        int[] numPath = numPaths[Math.abs(this.rand.nextInt() % numPaths.length)];
        int[] numbers = is6player ? SOCBoard6p.makeNewBoard_diceNums_v2 : SOCBoard4p.makeNewBoard_diceNums_v1;
        this.makeNewBoard_placeHexes(landHex, numPath, numbers, opt_breakClumps);
        int[] portTypes = is6player ? SOCBoard6p.PORTS_TYPE_V2 : SOCBoard4p.PORTS_TYPE_V1;
        int[] portHex = new int[portTypes.length];
        System.arraycopy(portTypes, 0, portHex, 0, portTypes.length);
        this.makeNewBoard_shufflePorts(portHex, opt_breakClumps);
        if (is6player) {
            this.portsLayout = portHex;
        }
        this.nodeIDtoPortType = new HashMap();
        if (is6player) {
            for (int i = 0; i < SOCBoard6p.PORTS_FACING_V2.length; ++i) {
                int ptype = portHex[i];
                int[] nodes = this.getAdjacentNodesToEdge_arr(SOCBoard6p.PORTS_EDGE_V2[i]);
                this.placePort(ptype, -1, SOCBoard6p.PORTS_FACING_V2[i], nodes[0], nodes[1]);
            }
        } else {
            for (int i = 0; i < SOCBoard4p.PORTS_FACING_V1.length; ++i) {
                int ptype = portHex[i];
                int[] nodes = this.getAdjacentNodesToEdge_arr(SOCBoard4p.PORTS_EDGE_V1[i]);
                this.placePort(ptype, SOCBoard4p.PORTS_HEXNUM_V1[i], SOCBoard4p.PORTS_FACING_V1[i], nodes[0], nodes[1]);
            }
        }
    }

    private void makeNewBoard_placeHexes(int[] landHex, int[] numPath, int[] number, SOCGameOption optBC) throws IllegalArgumentException {
        boolean checkClumps = optBC != null && optBC.getBoolValue();
        int clumpSize = checkClumps ? optBC.getIntValue() : 0;
        boolean clumpsNotOK = checkClumps;
        do {
            for (int j = 0; j < 10; ++j) {
                for (int i = 0; i < landHex.length; ++i) {
                    int idx = Math.abs(this.rand.nextInt() % (landHex.length - i));
                    if (idx == i) continue;
                    int tmp = landHex[idx];
                    landHex[idx] = landHex[i];
                    landHex[i] = tmp;
                }
            }
            int cnt = 0;
            for (int i = 0; i < landHex.length; ++i) {
                this.hexLayout[numPath[i]] = landHex[i];
                if (landHex[i] == 6) {
                    this.robberHex = this.numToHexID[numPath[i]];
                    this.numberLayout[numPath[i]] = -1;
                    continue;
                }
                this.numberLayout[numPath[i]] = number[cnt];
                ++cnt;
            }
            if (!checkClumps) continue;
            ArrayList<Integer> unvisited = new ArrayList<Integer>();
            for (int i = 0; i < landHex.length; ++i) {
                unvisited.add(this.numToHexID[numPath[i]]);
            }
            clumpsNotOK = this.makeNewBoard_checkLandHexResourceClumps(unvisited, clumpSize);
        } while (clumpsNotOK);
    }

    protected boolean makeNewBoard_checkLandHexResourceClumps(List<Integer> unvisited, int clumpSize) throws IllegalArgumentException {
        if (clumpSize < 3) {
            return false;
        }
        boolean clumpsNotOK = false;
        while (unvisited.size() > 0) {
            List<Integer> adjacent;
            Integer hexCoordObj = unvisited.remove(0);
            int hexCoord = hexCoordObj;
            int resource = this.getHexTypeFromCoord(hexCoord);
            if (resource == -1) {
                throw new IllegalArgumentException("hex type -1 at coord 0x" + Integer.toHexString(hexCoord));
            }
            if (resource == 0 || (adjacent = this.getAdjacentHexesToHex(hexCoord, false)) == null) continue;
            ArrayList<Integer> clump = null;
            for (Integer adjCoordInt : adjacent) {
                int adjCoord = adjCoordInt;
                if (resource != this.getHexTypeFromCoord(adjCoord)) continue;
                if (clump == null) {
                    clump = new ArrayList<Integer>();
                }
                clump.add(adjCoordInt);
                unvisited.remove(adjCoordInt);
            }
            if (clump == null) continue;
            clump.add(0, hexCoordObj);
            int ic = 1;
            while (ic < clump.size()) {
                int chexCoord = (Integer)clump.get(ic);
                List<Integer> adjacent2 = this.getAdjacentHexesToHex(chexCoord, false);
                if (adjacent2 == null) {
                    ++ic;
                    continue;
                }
                boolean didInsert = false;
                for (Integer adjCoordInt : adjacent2) {
                    int adjCoord = adjCoordInt;
                    if (resource != this.getHexTypeFromCoord(adjCoord) || !unvisited.contains(adjCoordInt)) continue;
                    clump.add(ic, adjCoordInt);
                    unvisited.remove(adjCoordInt);
                    didInsert = true;
                }
                if (didInsert) continue;
                ++ic;
            }
            if (clump.size() < clumpSize) continue;
            clumpsNotOK = true;
            break;
        }
        return clumpsNotOK;
    }

    protected void makeNewBoard_shufflePorts(int[] portHex, SOCGameOption opt_breakClumps) throws IllegalStateException {
        boolean portsOK = true;
        int redoCount = 0;
        block0: do {
            int i;
            int count;
            for (count = 0; count < 10; ++count) {
                for (i = 1; i < portHex.length; ++i) {
                    int idx = Math.abs(this.rand.nextInt() % (portHex.length - i));
                    int tmp = portHex[idx];
                    portHex[idx] = portHex[i];
                    portHex[i] = tmp;
                }
            }
            if (opt_breakClumps == null || !opt_breakClumps.getBoolValue()) continue;
            portsOK = true;
            int clumpsize = opt_breakClumps.getIntValue();
            boolean ptype = 0 == portHex[0];
            count = 1;
            for (i = 1; i < portHex.length; ++i) {
                if (ptype != (0 == portHex[i])) {
                    ptype = 0 == portHex[i];
                    count = 1;
                    continue;
                }
                if (++count < clumpsize) continue;
                portsOK = false;
            }
            if (ptype != (0 == portHex[0])) continue;
            if (count == portHex.length) {
                throw new IllegalStateException("portHex types all same");
            }
            if (!portsOK) continue;
            for (i = 0; i < portHex.length && ptype == (0 == portHex[i]); ++i) {
                if (++count < clumpsize) continue;
                portsOK = false;
                if (++redoCount <= 100) continue block0;
                return;
            }
        } while (!portsOK);
    }

    protected final void placePort(int ptype, int hex, int face, int node1, int node2) {
        if (hex != -1) {
            this.hexLayout[hex] = ptype == 0 ? face + 6 : (face << 4) + ptype;
        }
        Integer node1Int = node1;
        Integer node2Int = node2;
        Integer ptypeInt = ptype;
        this.nodeIDtoPortType.put(node1Int, ptypeInt);
        this.nodeIDtoPortType.put(node2Int, ptypeInt);
        this.ports[ptype].add(node1Int);
        this.ports[ptype].add(node2Int);
    }

    public HashSet<Integer> initPlayerLegalRoads() {
        int i;
        boolean is6player = this.boardEncodingFormat == 2;
        int westAdj = is6player ? 34 : 0;
        HashSet<Integer> legalRoads = new HashSet<Integer>(97);
        if (is6player) {
            for (i = 7; i <= 92; i += 17) {
                legalRoads.add(i);
            }
            for (i = 6; i <= 108; i += 34) {
                legalRoads.add(i);
            }
        }
        for (i = 39 - westAdj; i <= 124; i += 17) {
            legalRoads.add(i);
        }
        for (i = 38 - westAdj; i <= 140; i += 34) {
            legalRoads.add(i);
        }
        for (i = 37 - westAdj; i <= 156; i += 17) {
            legalRoads.add(i);
        }
        for (i = 36 - westAdj; i <= 172; i += 34) {
            legalRoads.add(i);
        }
        for (i = 35 - westAdj; i <= 188; i += 17) {
            legalRoads.add(i);
        }
        for (i = 34 - westAdj; i <= 204; i += 34) {
            legalRoads.add(i);
        }
        for (i = 50 - westAdj; i <= 203; i += 17) {
            legalRoads.add(i);
        }
        for (i = 66 - westAdj; i <= 202; i += 34) {
            legalRoads.add(i);
        }
        for (i = 82 - westAdj; i <= 201; i += 17) {
            legalRoads.add(i);
        }
        for (i = 98 - westAdj; i <= 200; i += 34) {
            legalRoads.add(i);
        }
        for (i = 114 - westAdj; i <= 199; i += 17) {
            legalRoads.add(i);
        }
        if (is6player) {
            for (i = 96; i <= 198; i += 34) {
                legalRoads.add(i);
            }
            for (i = 112; i <= 197; i += 17) {
                legalRoads.add(i);
            }
        }
        return legalRoads;
    }

    public HashSet<Integer> initPlayerLegalSettlements() {
        HashSet<Integer> legalSettlements = new HashSet<Integer>(this.nodesOnLand);
        return legalSettlements;
    }

    public int[] getHexLayout() throws UnsupportedOperationException {
        return this.hexLayout;
    }

    public abstract int[] getLandHexCoords();

    public boolean isHexOnLand(int hexCoord) {
        int hnum = this.hexIDtoNum[hexCoord];
        if (hnum < 0) {
            return false;
        }
        return this.hexLayout[hnum] <= 6 && this.hexLayout[hnum] != 0;
    }

    public boolean isHexOnWater(int hexCoord) {
        int hnum = this.hexIDtoNum[hexCoord];
        if (hnum < 0) {
            return false;
        }
        return this.hexLayout[hnum] > 6 || this.hexLayout[hnum] == 0;
    }

    public int[] getNumberLayout() throws UnsupportedOperationException {
        return this.numberLayout;
    }

    public int[] getPortsLayout() {
        return this.portsLayout;
    }

    public abstract int[] getPortsFacing();

    public abstract int[] getPortsEdges();

    public int getRobberHex() {
        return this.robberHex;
    }

    public int getPreviousRobberHex() {
        return this.prevRobberHex;
    }

    public void setHexLayout(int[] hl) throws UnsupportedOperationException {
        this.hexLayout = hl;
        if (hl[0] == 0) {
            return;
        }
        if (this.boardEncodingFormat != 1) {
            return;
        }
        if (this.nodeIDtoPortType == null) {
            this.nodeIDtoPortType = new HashMap();
        } else {
            this.nodeIDtoPortType.clear();
        }
        for (int i = 0; i < SOCBoard4p.PORTS_FACING_V1.length; ++i) {
            int hexnum = SOCBoard4p.PORTS_HEXNUM_V1[i];
            int ptype = this.getPortTypeFromHexType(this.hexLayout[hexnum]);
            int[] nodes = this.getAdjacentNodesToEdge_arr(SOCBoard4p.PORTS_EDGE_V1[i]);
            this.placePort(ptype, -1, -1, nodes[0], nodes[1]);
        }
    }

    public void setPortsLayout(int[] portTypes) {
        int i;
        this.portsLayout = portTypes;
        if (this.nodeIDtoPortType == null) {
            this.nodeIDtoPortType = new HashMap();
        } else {
            this.nodeIDtoPortType.clear();
        }
        for (i = 0; i < this.ports.length; ++i) {
            this.ports[i].clear();
        }
        for (i = 0; i < SOCBoard6p.PORTS_FACING_V2.length; ++i) {
            int ptype = portTypes[i];
            int[] nodes = this.getAdjacentNodesToEdge_arr(SOCBoard6p.PORTS_EDGE_V2[i]);
            this.placePort(ptype, -1, SOCBoard6p.PORTS_FACING_V2[i], nodes[0], nodes[1]);
        }
    }

    private int getPortTypeFromHexType(int hexType) {
        int portType = hexType >= 7 && hexType <= 12 ? 0 : hexType & 0xF;
        return portType;
    }

    public void setNumberLayout(int[] nl) throws UnsupportedOperationException {
        this.numberLayout = nl;
    }

    public void setRobberHex(int rh, boolean rememberPrevious) throws IllegalArgumentException {
        if (rh <= 0 && rh != this.prevRobberHex) {
            throw new IllegalArgumentException();
        }
        this.prevRobberHex = rememberPrevious ? this.robberHex : -1;
        this.robberHex = rh;
    }

    public abstract int getPortsCount();

    public List<Integer> getPortCoordinates(int portType) {
        return this.ports[portType];
    }

    public int getPortTypeFromNodeCoord(int nodeCoord) {
        if (nodeCoord < 0 || this.nodeIDtoPortType == null) {
            return -1;
        }
        Integer ptype = this.nodeIDtoPortType.get(nodeCoord);
        if (ptype != null) {
            return ptype;
        }
        return -1;
    }

    public static String getPortDescForType(int portType, boolean withArticle) {
        if (portType == -1) {
            return null;
        }
        String[] portDescs = PORT_DESC_FOR_TYPE[withArticle ? 1 : 0];
        if (portType >= 0 && portType <= 5) {
            return portDescs[portType];
        }
        return portDescs[portDescs.length - 1];
    }

    public int getNumberOnHexFromCoord(int hex) {
        if (hex >= 0 && hex < this.hexIDtoNum.length) {
            return this.getNumberOnHexFromNumber(this.hexIDtoNum[hex]);
        }
        return 0;
    }

    public int getNumberOnHexFromNumber(int hex) {
        if (hex < 0 || hex >= this.numberLayout.length) {
            return 0;
        }
        int num = this.numberLayout[hex];
        if (num < 0) {
            return 0;
        }
        return num;
    }

    public int getHexNumFromCoord(int hexCoord) throws UnsupportedOperationException {
        if (hexCoord >= 0 && hexCoord < this.hexIDtoNum.length) {
            return this.hexIDtoNum[hexCoord];
        }
        return -1;
    }

    public int getHexTypeFromCoord(int hex) {
        if (hex >= 0 && hex < this.hexIDtoNum.length) {
            return this.getHexTypeFromNumber(this.hexIDtoNum[hex]);
        }
        return -1;
    }

    public int getHexTypeFromNumber(int hex) {
        if (hex < 0 || hex >= this.hexLayout.length) {
            return -1;
        }
        int hexType = this.hexLayout[hex];
        if (hexType < 7) {
            return hexType;
        }
        if (hexType >= 7 && hexType <= 12) {
            return 7;
        }
        switch (hexType & 7) {
            case 1: {
                return 8;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 12;
            }
        }
        return -1;
    }

    public void putPiece(SOCPlayingPiece pp) {
        switch (pp.getType()) {
            case 0: 
            case 3: {
                this.roadsAndShips.add((SOCRoutePiece)pp);
                break;
            }
            case 1: {
                this.settlements.add((SOCSettlement)pp);
                break;
            }
            case 2: {
                this.cities.add((SOCCity)pp);
            }
        }
    }

    public void removePiece(SOCPlayingPiece piece) {
        switch (piece.getType()) {
            case 0: 
            case 3: {
                this.roadsAndShips.remove(piece);
                break;
            }
            case 1: {
                this.settlements.remove(piece);
                break;
            }
            case 2: {
                this.cities.remove(piece);
            }
        }
    }

    public List<SOCRoutePiece> getRoadsAndShips() {
        return this.roadsAndShips;
    }

    public List<SOCSettlement> getSettlements() {
        return this.settlements;
    }

    public List<SOCCity> getCities() {
        return this.cities;
    }

    public int getBoardWidth() {
        return this.boardWidth;
    }

    public int getBoardHeight() {
        return this.boardHeight;
    }

    protected void setBoardBounds(int boardH, int boardW) {
        this.boardHeight = boardH;
        this.boardWidth = boardW;
    }

    public int getBoardEncodingFormat() {
        return this.boardEncodingFormat;
    }

    public List<Integer> getAdjacentNodesToEdge(int coord) {
        ArrayList<Integer> nodes = new ArrayList<Integer>(2);
        int[] narr = this.getAdjacentNodesToEdge_arr(coord);
        if (narr[0] >= this.minNode && narr[0] <= 220) {
            nodes.add(narr[0]);
        }
        if (narr[1] >= this.minNode && narr[1] <= 220) {
            nodes.add(narr[1]);
        }
        return nodes;
    }

    public int[] getAdjacentNodesToEdge_arr(int coord) {
        int[] nodes = new int[2];
        if (((coord & 0xF) + (coord >> 4)) % 2 == 0) {
            nodes[0] = coord + 1;
            nodes[1] = coord + 16;
        } else {
            nodes[0] = coord;
            nodes[1] = coord + 17;
        }
        return nodes;
    }

    public int getAdjacentNodeFarEndOfEdge(int edgeCoord, int nodeCoord) {
        int[] nodes = this.getAdjacentNodesToEdge_arr(edgeCoord);
        if (nodeCoord == nodes[0]) {
            return nodes[1];
        }
        return nodes[0];
    }

    public int getNodeBetweenAdjacentEdges(int edgeA, int edgeB) throws IllegalArgumentException {
        int node;
        if (((edgeA & 0xF) + (edgeA >> 4)) % 2 == 0) {
            switch (edgeB - edgeA) {
                case -16: 
                case 1: {
                    node = edgeA + 1;
                    break;
                }
                case -1: 
                case 16: {
                    node = edgeA + 16;
                    break;
                }
                default: {
                    node = -9;
                    break;
                }
            }
        } else {
            switch (edgeB - edgeA) {
                case -17: 
                case -16: 
                case -1: {
                    node = edgeA;
                    break;
                }
                case 1: 
                case 16: 
                case 17: {
                    node = edgeA + 17;
                    break;
                }
                default: {
                    node = -9;
                }
            }
        }
        if (node == -9) {
            throw new IllegalArgumentException("Edges not adjacent: 0x" + Integer.toHexString(edgeA) + ", 0x" + Integer.toHexString(edgeB));
        }
        return node;
    }

    public boolean isEdgeSameOrAdjacent(int edgeA, int edgeB) {
        if (edgeA == edgeB) {
            return true;
        }
        for (int e : this.getAdjacentEdgesToEdge(edgeA)) {
            if (e != edgeB) continue;
            return true;
        }
        return false;
    }

    public List<Integer> getAdjacentEdgesToEdge(int coord) {
        ArrayList<Integer> edges = new ArrayList<Integer>(4);
        if (((coord & 0xF) + (coord >> 4)) % 2 == 0) {
            int tmp = coord - 16;
            if (tmp >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
            if ((tmp = coord + 1) >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
            if ((tmp = coord + 16) >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
            if ((tmp = coord - 1) >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
        } else if ((coord >> 4) % 2 == 0) {
            int tmp = coord - 17;
            if (tmp >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
            if ((tmp = coord + 1) >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
            if ((tmp = coord + 17) >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
            if ((tmp = coord - 1) >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
        } else {
            int tmp = coord - 16;
            if (tmp >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
            if ((tmp = coord + 17) >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
            if ((tmp = coord + 16) >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
            if ((tmp = coord - 17) >= this.minEdge && tmp <= this.maxEdge) {
                edges.add(tmp);
            }
        }
        return edges;
    }

    public List<Integer> getAdjacentHexesToNode(int coord) {
        ArrayList<Integer> hexes = new ArrayList<Integer>(3);
        if ((coord >> 4) % 2 == 0) {
            int tmp = coord - 16;
            if (tmp >= 17 && tmp <= 221) {
                hexes.add(tmp);
            }
            if ((tmp = coord + 16) >= 17 && tmp <= 221) {
                hexes.add(tmp);
            }
            if ((tmp = coord - 18) >= 17 && tmp <= 221) {
                hexes.add(tmp);
            }
        } else {
            int tmp = coord - 33;
            if (tmp >= 17 && tmp <= 221) {
                hexes.add(tmp);
            }
            if ((tmp = coord + 1) >= 17 && tmp <= 221) {
                hexes.add(tmp);
            }
            if ((tmp = coord - 1) >= 17 && tmp <= 221) {
                hexes.add(tmp);
            }
        }
        return hexes;
    }

    public List<Integer> getAdjacentEdgesToNode(int coord) {
        ArrayList<Integer> edges = new ArrayList<Integer>(3);
        int[] edgea = this.getAdjacentEdgesToNode_arr(coord);
        for (int i = edgea.length - 1; i >= 0; --i) {
            if (edgea[i] == -9) continue;
            edges.add(edgea[i]);
        }
        return edges;
    }

    public final int[] getAdjacentEdgesToNode_arr(int coord) {
        int[] edges = new int[3];
        for (int i = 0; i < 3; ++i) {
            edges[i] = this.getAdjacentEdgeToNode(coord, i);
        }
        return edges;
    }

    public int getAdjacentEdgeToNode(int nodeCoord, int nodeDir) throws IllegalArgumentException {
        int edge;
        boolean evenOddHex = (nodeCoord >> 4) % 2 == 0;
        switch (nodeDir) {
            case 0: {
                if (evenOddHex) {
                    int tmp = nodeCoord - 17;
                    if (tmp >= this.minEdge && tmp <= this.maxEdge) {
                        edge = tmp;
                        break;
                    }
                    edge = -9;
                    break;
                }
                int tmp = nodeCoord - 17;
                if ((nodeCoord & 0xF) > 0 && tmp >= this.minEdge && tmp <= this.maxEdge) {
                    edge = tmp;
                    break;
                }
                edge = -9;
                break;
            }
            case 1: {
                if (evenOddHex) {
                    int tmp = nodeCoord;
                    if ((nodeCoord & 0xF) < 13 && tmp >= this.minEdge && tmp <= this.maxEdge) {
                        edge = tmp;
                        break;
                    }
                    edge = -9;
                    break;
                }
                int tmp = nodeCoord;
                if (tmp >= this.minEdge && tmp <= this.maxEdge) {
                    edge = tmp;
                    break;
                }
                edge = -9;
                break;
            }
            case 2: {
                if (evenOddHex) {
                    boolean hasSouthernEdge = nodeCoord < 129 || 0 != (nodeCoord - 129) % 34;
                    int tmp = nodeCoord - 1;
                    if (hasSouthernEdge && 0 < (nodeCoord & 0xF) && tmp >= this.minEdge && tmp <= this.maxEdge) {
                        edge = tmp;
                        break;
                    }
                    edge = -9;
                    break;
                }
                boolean hasNorthernEdge = nodeCoord < 24 || nodeCoord > 126 || 0 != (nodeCoord - 24) % 34;
                int tmp = nodeCoord - 16;
                if (hasNorthernEdge && tmp >= this.minEdge && tmp <= this.maxEdge) {
                    edge = tmp;
                    break;
                }
                edge = -9;
                break;
            }
            default: {
                throw new IllegalArgumentException("nodeDir out of range: " + nodeDir);
            }
        }
        return edge;
    }

    public int getEdgeBetweenAdjacentNodes(int nodeA, int nodeB) {
        int edge;
        switch (nodeA - nodeB) {
            case 17: {
                edge = nodeB;
                break;
            }
            case -17: {
                edge = nodeA;
                break;
            }
            case 15: {
                edge = nodeA - 16;
                break;
            }
            case -15: {
                edge = nodeA - 1;
                break;
            }
            default: {
                edge = -9;
            }
        }
        return edge;
    }

    public boolean isEdgeAdjacentToNode(int nodeCoord, int edgeCoord) {
        if (edgeCoord < this.minEdge || edgeCoord > this.maxEdge) {
            return false;
        }
        if (edgeCoord == nodeCoord || edgeCoord == nodeCoord - 17) {
            return true;
        }
        if ((nodeCoord & 0xF) % 2 == 1) {
            return edgeCoord == nodeCoord - 1;
        }
        return edgeCoord == nodeCoord - 16;
    }

    public boolean isNodeSameOrAdjacent(int nodeA, int nodeB) {
        return nodeA == nodeB ? true : this.isNodeAdjacentToNode(nodeA, nodeB);
    }

    public List<Integer> getAdjacentNodesToNode(int coord) {
        ArrayList<Integer> nodes = new ArrayList<Integer>(3);
        int[] nodea = this.getAdjacentNodesToNode_arr(coord);
        for (int i = nodea.length - 1; i >= 0; --i) {
            if (nodea[i] == -9) continue;
            nodes.add(nodea[i]);
        }
        return nodes;
    }

    public final int[] getAdjacentNodesToNode_arr(int coord) {
        int[] nodes = new int[3];
        for (int i = 0; i < 3; ++i) {
            nodes[i] = this.getAdjacentNodeToNode(coord, i);
        }
        return nodes;
    }

    public final boolean isNodeAdjacentToNode(int nodeA, int nodeB) {
        for (int i = 0; i < 3; ++i) {
            if (this.getAdjacentNodeToNode(nodeA, i) != nodeB) continue;
            return true;
        }
        return false;
    }

    public int getAdjacentNodeToNode(int nodeCoord, int nodeDir) throws IllegalArgumentException {
        int node;
        switch (nodeDir) {
            case 0: {
                int tmp = nodeCoord - 17;
                if (tmp >= this.minNode && tmp <= 220 && (nodeCoord & 0xF) > 0) {
                    node = tmp;
                    break;
                }
                node = -9;
                break;
            }
            case 1: {
                int tmp = nodeCoord + 17;
                if (tmp >= this.minNode && tmp <= 220 && (nodeCoord & 0xF) < 13) {
                    node = tmp;
                    break;
                }
                node = -9;
                break;
            }
            case 2: {
                if ((nodeCoord >> 4) % 2 == 0) {
                    boolean hasSouthernEdge = nodeCoord < 129 || 0 != (nodeCoord - 129) % 34;
                    int tmp = nodeCoord + 16 - 1;
                    if (hasSouthernEdge && tmp >= this.minNode && tmp <= 220) {
                        node = tmp;
                        break;
                    }
                    node = -9;
                    break;
                }
                boolean hasNorthernEdge = nodeCoord < 24 || nodeCoord > 126 || 0 != (nodeCoord - 24) % 34;
                int tmp = nodeCoord - 16 + 1;
                if (hasNorthernEdge && tmp >= this.minNode && tmp <= 220) {
                    node = tmp;
                    break;
                }
                node = -9;
                break;
            }
            default: {
                throw new IllegalArgumentException("nodeDir out of range: " + nodeDir);
            }
        }
        return node;
    }

    public int getAdjacentNodeToNode2Away(int nodeCoord, int facing) throws IllegalArgumentException {
        if (facing < 1 || facing > 6) {
            throw new IllegalArgumentException("bad facing: " + facing);
        }
        int node = nodeCoord + NODE_2_AWAY[facing];
        if (!this.isNodeOnLand(node)) {
            node = -9;
        }
        return node;
    }

    public boolean isNode2AwayFromNode(int n1, int n2) {
        int d = n2 - n1;
        for (int facing = 1; facing <= 6; ++facing) {
            if (d != NODE_2_AWAY[facing]) continue;
            return true;
        }
        return false;
    }

    public int getAdjacentEdgeToNode2Away(int node, int node2away) {
        int roadEdge = (node >> 4) % 2 == 0 ? (node2away == node - 2 || node2away == node + 32 ? node - 1 : (node2away < node ? node - 17 : node)) : (node2away == node - 32 || node2away == node + 2 ? node - 16 : (node2away > node ? node : node - 17));
        return roadEdge;
    }

    public List<Integer> getAdjacentHexesToHex(int hexCoord, boolean includeWater) {
        ArrayList<Integer> hexes = new ArrayList<Integer>();
        this.getAdjacentHexes_AddIfOK(hexes, includeWater, hexCoord, -2, 0);
        this.getAdjacentHexes_AddIfOK(hexes, includeWater, hexCoord, 0, 2);
        this.getAdjacentHexes_AddIfOK(hexes, includeWater, hexCoord, -2, -2);
        this.getAdjacentHexes_AddIfOK(hexes, includeWater, hexCoord, 2, 2);
        this.getAdjacentHexes_AddIfOK(hexes, includeWater, hexCoord, 0, -2);
        this.getAdjacentHexes_AddIfOK(hexes, includeWater, hexCoord, 2, 0);
        if (hexes.size() > 0) {
            return hexes;
        }
        return null;
    }

    private final void getAdjacentHexes_AddIfOK(List<Integer> addTo, boolean includeWater, int hexCoord, int d1, int d2) {
        int a1 = ((hexCoord & 0xF0) >> 4) + d1;
        int a2 = (hexCoord & 0xF) + d2;
        if (a1 < 1 || a1 > 13 || a2 < 1 || a2 > 13) {
            return;
        }
        hexCoord += d1 << 4;
        if ((hexCoord += d2) >= 17 && hexCoord <= 221 && this.hexIDtoNum[hexCoord] != -1 && (includeWater || this.hexLayout[this.hexIDtoNum[hexCoord]] <= 6 && this.hexLayout[this.hexIDtoNum[hexCoord]] != 0)) {
            addTo.add(hexCoord);
        }
    }

    public int getAdjacentNodeToHex(int hexCoord, int dir) throws IllegalArgumentException {
        if (dir >= 0 && dir < HEXNODES.length) {
            return hexCoord + HEXNODES[dir];
        }
        throw new IllegalArgumentException("dir");
    }

    public List<Integer> getAdjacentNodesToHex(int hexCoord) {
        int[] arr = this.getAdjacentNodesToHex_arr(hexCoord);
        ArrayList<Integer> li = new ArrayList<Integer>(6);
        for (int dir = 0; dir < 6; ++dir) {
            li.add(arr[dir]);
        }
        return li;
    }

    public int[] getAdjacentNodesToHex_arr(int hexCoord) {
        int[] node = new int[6];
        for (int dir = 0; dir < 6; ++dir) {
            node[dir] = hexCoord + HEXNODES[dir];
        }
        return node;
    }

    public int getAdjacentHexToEdge(int edgeCoord, int facing) throws IllegalArgumentException {
        int hex = 0;
        if (((edgeCoord & 0xF) + (edgeCoord >> 4)) % 2 == 0) {
            switch (facing) {
                case 2: {
                    hex = edgeCoord + 17;
                    break;
                }
                case 5: {
                    if (0 == (edgeCoord & 0xF) || 0 == (edgeCoord & 0xF0)) break;
                    hex = edgeCoord - 17;
                    break;
                }
                case 1: 
                case 6: {
                    if (0 == (edgeCoord & 0xF0)) break;
                    hex = edgeCoord + 1 - 16;
                    break;
                }
                case 3: 
                case 4: {
                    if (0 == (edgeCoord & 0xF)) break;
                    hex = edgeCoord - 1 + 16;
                }
            }
        } else if ((edgeCoord >> 4) % 2 == 0) {
            switch (facing) {
                case 6: {
                    if (0 == (edgeCoord & 0xF0)) break;
                    hex = edgeCoord - 16;
                    break;
                }
                case 3: {
                    hex = edgeCoord + 16;
                    break;
                }
                case 1: 
                case 2: {
                    if ((edgeCoord & 0xF) > 13) break;
                    hex = edgeCoord + 18;
                    break;
                }
                case 4: 
                case 5: {
                    if (0 == (edgeCoord & 0xF0) || (edgeCoord & 0xF) < 2) break;
                    hex = edgeCoord - 18;
                }
            }
        } else {
            switch (facing) {
                case 1: {
                    hex = edgeCoord + 1;
                    break;
                }
                case 4: {
                    if (0 == (edgeCoord & 0xF)) break;
                    hex = edgeCoord - 1;
                    break;
                }
                case 2: 
                case 3: {
                    if (edgeCoord >> 4 > 13) break;
                    hex = edgeCoord + 33;
                    break;
                }
                case 5: 
                case 6: {
                    if (0 == (edgeCoord & 0xF) || edgeCoord >> 4 < 2) break;
                    hex = edgeCoord - 33;
                }
            }
        }
        return hex;
    }

    public SOCPlayingPiece settlementAtNode(int nodeCoord) {
        for (SOCSettlement sOCSettlement : this.settlements) {
            if (nodeCoord != sOCSettlement.getCoordinates()) continue;
            return sOCSettlement;
        }
        for (SOCCity sOCCity : this.cities) {
            if (nodeCoord != sOCCity.getCoordinates()) continue;
            return sOCCity;
        }
        return null;
    }

    public SOCRoutePiece roadOrShipAtEdge(int edgeCoord) {
        for (SOCRoutePiece p : this.roadsAndShips) {
            if (edgeCoord != p.getCoordinates()) continue;
            return p;
        }
        return null;
    }

    public boolean isNodeOnLand(int node) {
        if (node < 0) {
            return false;
        }
        return this.nodesOnLand.contains(node);
    }

    public String nodeCoordToString(int node) {
        List<Integer> hexes = this.getAdjacentHexesToNode(node);
        if (hexes.isEmpty()) {
            return "(node 0x" + Integer.toHexString(node) + ")";
        }
        int hex = hexes.get(0);
        int number = this.getNumberOnHexFromCoord(hex);
        String str = number == 0 ? "-" : Integer.toString(number);
        for (int i = 1; i < hexes.size(); ++i) {
            hex = hexes.get(i);
            number = this.getNumberOnHexFromCoord(hex);
            str = number == 0 ? str + "/-" : str + "/" + number;
        }
        return str;
    }

    public String edgeCoordToString(int edge) {
        int number2;
        int number1;
        if (((edge & 0xF) + (edge >> 4)) % 2 == 0) {
            number1 = this.getNumberOnHexFromCoord(edge - 17);
            number2 = this.getNumberOnHexFromCoord(edge + 17);
        } else if ((edge >> 4) % 2 == 0) {
            number1 = this.getNumberOnHexFromCoord(edge - 16);
            number2 = this.getNumberOnHexFromCoord(edge + 16);
        } else {
            number1 = this.getNumberOnHexFromCoord(edge - 1);
            number2 = this.getNumberOnHexFromCoord(edge + 1);
        }
        String str = number1 + "/" + number2;
        return str;
    }

    public static class DefaultBoardFactory
    implements BoardFactory {
        public static SOCBoard staticCreateBoard(SOCGameOptionSet gameOpts, boolean largeBoard, int maxPlayers) throws IllegalArgumentException {
            if (!largeBoard) {
                if (maxPlayers == 6) {
                    return new SOCBoard6p(gameOpts);
                }
                return new SOCBoard4p(gameOpts);
            }
            return new SOCBoardLarge(gameOpts, maxPlayers, SOCBoardLarge.getBoardSize(gameOpts));
        }

        @Override
        public SOCBoard createBoard(SOCGameOptionSet gameOpts, boolean largeBoard, int maxPlayers) throws IllegalArgumentException {
            return DefaultBoardFactory.staticCreateBoard(gameOpts, largeBoard, maxPlayers);
        }
    }

    public static interface BoardFactory {
        public SOCBoard createBoard(SOCGameOptionSet var1, boolean var2, int var3) throws IllegalArgumentException;
    }
}

