/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soc.game.SOCBoard;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCPlayingPiece;
import soc.game.SOCRoutePiece;
import soc.game.SOCShip;
import soc.game.SOCVillage;
import soc.util.IntPair;

public class SOCBoardLarge
extends SOCBoard {
    private static final long serialVersionUID = 2000L;
    public static final int MIN_VERSION = 2000;
    public static final int GOLD_HEX = 7;
    public static final int FOG_HEX = 8;
    protected static final int MAX_LAND_HEX_LG = 8;
    public static final int BOARDHEIGHT_LARGE = 16;
    public static final int BOARDWIDTH_LARGE = 18;
    public static final int SPECIAL_EDGE_DEV_CARD = 1;
    public static final int SPECIAL_EDGE_SVP = 2;
    public static final String[] SPECIAL_EDGE_LAYOUT_PARTS = new String[]{"CE", "VE"};
    public static final int[] SPECIAL_EDGE_TYPES = new int[]{1, 2};
    private static final int[][] A_HEX2HEX = new int[][]{{-2, 1}, {0, 2}, {2, 1}, {2, -1}, {0, -2}, {-2, -1}};
    private static final int[][] A_NODE2HEX = new int[][]{{-256, 0}, {-256, 1}, {256, 1}, {256, 0}, {256, -1}, {-256, -1}};
    private static final int[][] A_EDGE2HEX = new int[][]{{-256, 0}, {0, 1}, {256, 0}, {256, -1}, {0, -1}, {-256, -1}};
    private static final int[][] A_EDGE2EDGE = new int[][]{{-1, -1, -1, 0, 1, -1, 1, 0}, {0, -1, 1, 0, -1, 1, 0, 1}, {0, -1, -1, 0, 1, 1, 0, 1}};
    private static final int[] NODE_TO_NODE_2_AWAY = new int[]{-9, -9, -2, 1, 0, 2, 2, 1, 2, -1, 0, -2, -2, -1};
    protected int[][] hexLayoutLg;
    protected volatile int[] cachedGetLandHexCoords;
    protected HashSet<Integer> landHexLayout;
    protected HashSet<Integer>[] landAreasLegalNodes;
    protected final int maxPlayers;
    protected int startingLandArea;
    protected HashSet<Integer> legalRoadEdges;
    protected HashSet<Integer> legalShipEdges;
    protected int[][] numberLayoutLg;
    private HashMap<String, int[]> addedLayoutParts;
    private HashMap<Integer, Integer> specialEdges = new HashMap();
    protected final HashMap<Integer, Integer> fogHiddenHexes;
    protected HashMap<Integer, SOCVillage> villages;
    private int numCloth;
    private int[] playerExcludedLandAreas;
    private int[] robberExcludedLandAreas;
    protected int portsCount;
    protected int pirateHex;
    private int prevPirateHex;

    public SOCBoardLarge(SOCGameOptionSet gameOpts, int maxPlayers, IntPair boardHeightWidth) throws IllegalArgumentException {
        super(3, 8);
        if (maxPlayers != 4 && maxPlayers != 6) {
            throw new IllegalArgumentException("maxPlayers: " + maxPlayers);
        }
        if (boardHeightWidth == null) {
            throw new IllegalArgumentException("boardHeightWidth null");
        }
        this.maxPlayers = maxPlayers;
        int bH = boardHeightWidth.a;
        int bW = boardHeightWidth.b;
        this.setBoardBounds(bH, bW);
        this.hexLayoutLg = new int[bH + 1][bW + 1];
        this.numberLayoutLg = new int[bH + 1][bW + 1];
        this.landHexLayout = new HashSet();
        this.fogHiddenHexes = new HashMap();
        this.legalRoadEdges = new HashSet();
        this.legalShipEdges = new HashSet();
        this.landAreasLegalNodes = null;
        this.startingLandArea = 0;
        for (int r = 0; r <= bH; ++r) {
            Arrays.fill(this.hexLayoutLg[r], 0);
            Arrays.fill(this.numberLayoutLg[r], 0);
        }
        this.portsCount = 0;
        this.pirateHex = 0;
        this.prevPirateHex = 0;
    }

    @Override
    public int getBoardEncodingFormat() {
        return 3;
    }

    public static IntPair getBoardSize(SOCGameOptionSet gameOpts) {
        SOCGameOption bhwOpt = null;
        if (gameOpts != null) {
            bhwOpt = gameOpts.get("_BHW");
        }
        if (bhwOpt == null || bhwOpt.getIntValue() == 0) {
            return new IntPair(16, 18);
        }
        int bhw = bhwOpt.getIntValue();
        return new IntPair(bhw >> 8, bhw & 0xFF);
    }

    @Override
    public void makeNewBoard(SOCGameOptionSet opts) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Use SOCBoardAtServer instead");
    }

    protected void initLegalRoadsFromLandNodes() throws IllegalStateException {
        this.legalRoadEdges.clear();
        HashSet<Integer> landNodes = this.nodesOnLand;
        int[] partAL = this.getAddedLayoutPart("AL");
        if (partAL != null) {
            boolean foundNodes = false;
            for (int i = 0; i < partAL.length; ++i) {
                int elem = partAL[i];
                if (elem < 0) continue;
                if (elem == 0) {
                    throw new IllegalStateException("Bad Layout Part: AL[" + i + "] == 0");
                }
                if (i == partAL.length - 1) {
                    throw new IllegalStateException("Bad Layout Part: AL[" + i + "] must be followed by LA#");
                }
                ++i;
                String nodeListKey = "N" + elem;
                int[] nodeList = this.getAddedLayoutPart(nodeListKey);
                if (nodeList == null) {
                    throw new IllegalStateException("Bad Layout Part: AL[" + i + "] == " + elem + " but Part " + nodeListKey + " missing");
                }
                if (!foundNodes) {
                    landNodes = new HashSet<Integer>(this.nodesOnLand);
                    foundNodes = true;
                }
                for (int j = 0; j < nodeList.length; ++j) {
                    landNodes.add(nodeList[j]);
                }
            }
        }
        for (Integer nodeVal : landNodes) {
            int node = nodeVal;
            for (int dir = 0; dir < 3; ++dir) {
                int nodeAdjac = this.getAdjacentNodeToNode(node, dir);
                if (!landNodes.contains(nodeAdjac)) continue;
                int edge = this.getAdjacentEdgeToNode(node, dir);
                boolean hasLand = false;
                int[] hexes = this.getAdjacentHexesToEdge_arr(edge);
                for (int i = 0; i <= 1; ++i) {
                    int htype;
                    if (hexes[i] == 0 || (htype = this.getHexTypeFromCoord(hexes[i])) == 0 || htype > 8) continue;
                    hasLand = true;
                    break;
                }
                if (!hasLand) continue;
                this.legalRoadEdges.add(edge);
            }
        }
    }

    public final void addLegalNodes(int[] nodes, int lan) {
        HashSet<Integer> area = lan > 0 ? this.landAreasLegalNodes[lan] : null;
        for (int i = 0; i < nodes.length; ++i) {
            Integer iobj = nodes[i];
            this.nodesOnLand.add(iobj);
            if (area == null) continue;
            area.add(iobj);
        }
    }

    protected void initLegalShipEdges() {
        this.legalShipEdges.clear();
        for (int r = 1; r < this.boardHeight; r += 2) {
            int rshift = r << 8;
            for (int c = r / 2 % 2 == 1 ? 1 : 2; c < this.boardWidth; c += 2) {
                if (this.hexLayoutLg[r][c] == 0) {
                    this.legalShipEdges.addAll(this.getAdjacentEdgesToHex(rshift | c));
                    continue;
                }
                if (r != 1 && r != this.boardHeight - 1 && c > 2 && c < this.boardWidth - 2) continue;
                for (int side : this.getAdjacentEdgesToHex_arr(rshift | c)) {
                    if (!this.isEdgeCoastline(side)) continue;
                    this.legalShipEdges.add(side);
                }
            }
        }
    }

    public int revealFogHiddenHexPrep(int hexCoord) throws IllegalArgumentException {
        Integer encoded = this.fogHiddenHexes.remove(hexCoord);
        if (encoded == null || this.getHexTypeFromCoord(hexCoord) != 8) {
            throw new IllegalArgumentException("Not fog: 0x" + Integer.toHexString(hexCoord));
        }
        return encoded;
    }

    boolean revealFogHiddenHex(int hexCoord, int hexType, int diceNum) throws IllegalArgumentException {
        int r = hexCoord >> 8;
        int c = hexCoord & 0xFF;
        if (this.hexLayoutLg[r][c] != 8) {
            throw new IllegalArgumentException("Not fog: 0x" + Integer.toHexString(hexCoord));
        }
        if (diceNum < 0) {
            throw new IllegalArgumentException("diceNum: " + diceNum);
        }
        boolean wasWaterRemovedLegals = false;
        this.hexLayoutLg[r][c] = hexType;
        this.numberLayoutLg[r][c] = diceNum;
        this.fogHiddenHexes.remove(hexCoord);
        if (hexType == 0) {
            this.legalShipEdges.addAll(this.getAdjacentEdgesToHex(hexCoord));
            if (this.landHexLayout.contains(hexCoord)) {
                for (Integer edgeObj : this.getAdjacentEdgesToHex(hexCoord)) {
                    if (this.isEdgeCoastline(edgeObj)) continue;
                    this.legalRoadEdges.remove(edgeObj);
                    wasWaterRemovedLegals = true;
                }
                for (Integer nodeObj : this.getAdjacentNodesToHex(hexCoord)) {
                    if (this.isNodeCoastline(nodeObj)) continue;
                    this.nodesOnLand.remove(nodeObj);
                    if (this.landAreasLegalNodes != null) {
                        for (int i = 1; i < this.landAreasLegalNodes.length; ++i) {
                            HashSet<Integer> laln = this.landAreasLegalNodes[i];
                            if (laln == null) continue;
                            laln.remove(nodeObj);
                        }
                    }
                    wasWaterRemovedLegals = true;
                }
            }
        }
        return wasWaterRemovedLegals;
    }

    @Override
    @Deprecated
    public int[] getHexLayout() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setHexLayout(int[] hl) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int[] getNumberLayout() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setNumberLayout(int[] nl) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public HashMap<String, int[]> getAddedLayoutParts() {
        if (this.addedLayoutParts != null && this.addedLayoutParts.isEmpty()) {
            return null;
        }
        return this.addedLayoutParts;
    }

    public int[] getAddedLayoutPart(String key) {
        if (this.addedLayoutParts == null) {
            return null;
        }
        return this.addedLayoutParts.get(key);
    }

    public void setAddedLayoutParts(HashMap<String, int[]> adds) {
        this.addedLayoutParts = adds != null && adds.isEmpty() ? null : adds;
        if (adds == null) {
            return;
        }
        for (int i = 0; i < SPECIAL_EDGE_LAYOUT_PARTS.length; ++i) {
            int[] edgelist = adds.get(SPECIAL_EDGE_LAYOUT_PARTS[i]);
            if (edgelist == null) continue;
            this.setSpecialEdges(edgelist, SPECIAL_EDGE_TYPES[i]);
        }
    }

    public void setAddedLayoutPart(String key, int[] v) {
        if (this.addedLayoutParts == null) {
            this.addedLayoutParts = new HashMap();
        }
        this.addedLayoutParts.put(key, v);
        for (int i = 0; i < SPECIAL_EDGE_LAYOUT_PARTS.length; ++i) {
            if (!key.equals(SPECIAL_EDGE_LAYOUT_PARTS[i])) continue;
            this.setSpecialEdges(v, SPECIAL_EDGE_TYPES[i]);
        }
    }

    public Integer drawItemFromStack() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Use SOCBoardAtServer instead");
    }

    public void putItemInStackRandomly(Integer item) throws UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException("Use SOCBoardAtServer instead");
    }

    final void placePort(int edge, int ptype) throws IllegalArgumentException {
        this.placePort(edge, this.getPortFacingFromEdge(edge), ptype);
    }

    final void placePort(int edge, int facing, int ptype) {
        int i;
        for (i = 0; i < this.portsCount && this.portsLayout[i + this.portsCount] >= 0; ++i) {
        }
        if (i == this.portsCount) {
            int[] npl = new int[3 * (this.portsCount + 1)];
            System.arraycopy(this.portsLayout, 0, npl, 0, this.portsCount);
            System.arraycopy(this.portsLayout, this.portsCount, npl, this.portsCount + 1, this.portsCount);
            System.arraycopy(this.portsLayout, 2 * this.portsCount, npl, 2 * (this.portsCount + 1), this.portsCount);
            this.portsLayout = npl;
            ++this.portsCount;
        }
        this.portsLayout[i] = ptype;
        this.portsLayout[i + this.portsCount] = edge;
        this.portsLayout[i + 2 * this.portsCount] = facing;
        int[] nodes = this.getAdjacentNodesToEdge_arr(edge);
        this.placePort(ptype, -1, facing, nodes[0], nodes[1]);
    }

    public int movePirateHexAlongPath(int numSteps) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("Use SOCBoardAtServer instead");
    }

    public void setPirateHex(int ph, boolean rememberPrevious) throws IllegalArgumentException {
        if (ph < 0) {
            throw new IllegalArgumentException();
        }
        this.prevPirateHex = rememberPrevious ? this.pirateHex : 0;
        this.pirateHex = ph;
    }

    public int getPirateHex() {
        return this.pirateHex;
    }

    public int getPreviousPirateHex() {
        return this.prevPirateHex;
    }

    public int[] getPlayerExcludedLandAreas() {
        return this.playerExcludedLandAreas;
    }

    public void setPlayerExcludedLandAreas(int[] px) {
        this.playerExcludedLandAreas = px;
    }

    public int[] getRobberExcludedLandAreas() {
        return this.robberExcludedLandAreas;
    }

    public void setRobberExcludedLandAreas(int[] rx) {
        this.robberExcludedLandAreas = rx;
    }

    @Override
    public int getNumberOnHexFromCoord(int hex) {
        return this.getNumberOnHexFromNumber(hex);
    }

    @Override
    public int getNumberOnHexFromNumber(int hex) {
        if (hex == -1) {
            return 0;
        }
        int r = hex >> 8;
        int c = hex & 0xFF;
        if (r < 0 || c < 0 || r >= this.boardHeight || c >= this.boardWidth) {
            return 0;
        }
        return this.numberLayoutLg[r][c];
    }

    @Override
    @Deprecated
    public int getHexNumFromCoord(int hexCoord) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not valid for SOCBoardLarge; try getNumberOnHexFromCoord");
    }

    @Override
    public int getHexTypeFromCoord(int hex) {
        return this.getHexTypeFromNumber(hex);
    }

    @Override
    public int getHexTypeFromNumber(int hex) {
        int r = hex >> 8;
        int c = hex & 0xFF;
        if (r <= 0 || c <= 0 || r >= this.boardHeight || c >= this.boardWidth) {
            return -1;
        }
        if (r % 2 == 0 || c % 2 != r / 2 % 2) {
            return -1;
        }
        return this.hexLayoutLg[r][c];
    }

    public SOCVillage getVillageAtNode(int nodeCoord) {
        if (this.villages == null || this.villages.isEmpty()) {
            return null;
        }
        return this.villages.get(nodeCoord);
    }

    public final boolean isEdgeCoastline(int edge) {
        boolean hasLand = false;
        boolean hasWater = false;
        int[] hexes = this.getAdjacentHexesToEdge_arr(edge);
        for (int i = 0; i <= 1; ++i) {
            if (hexes[i] != 0) {
                int htype = this.getHexTypeFromCoord(hexes[i]);
                if (htype <= 8 && htype != 0) {
                    hasLand = true;
                    continue;
                }
                hasWater = true;
                continue;
            }
            hasWater = true;
        }
        return hasLand && hasWater;
    }

    public final boolean isEdgeLegalRoad(int edge) {
        return this.legalRoadEdges.contains(edge);
    }

    public HashSet<Integer> getLandHexCoordsSet() {
        return this.landHexLayout;
    }

    @Override
    public int[] getLandHexCoords() {
        int LHL = this.landHexLayout.size();
        if (LHL == 0) {
            return null;
        }
        if (this.cachedGetLandHexCoords != null && LHL == this.cachedGetLandHexCoords.length) {
            return this.cachedGetLandHexCoords;
        }
        int[] hexCoords = new int[LHL];
        int i = 0;
        for (Integer hex : this.landHexLayout) {
            hexCoords[i++] = hex;
        }
        this.cachedGetLandHexCoords = hexCoords;
        return hexCoords;
    }

    @Override
    public void putPiece(SOCPlayingPiece pp) {
        switch (pp.getType()) {
            case 5: {
                if (this.villages == null) {
                    this.villages = new HashMap();
                }
                this.villages.put(pp.getCoordinates(), (SOCVillage)pp);
                break;
            }
            default: {
                super.putPiece(pp);
            }
        }
    }

    public void setShipsClosed(boolean closed, int[] edges, int startingIndex) throws IllegalArgumentException {
        if (edges == null) {
            return;
        }
        for (int i = startingIndex; i < edges.length; ++i) {
            int edge = edges[i];
            SOCRoutePiece rs = this.roadOrShipAtEdge(edge);
            if (!(rs instanceof SOCShip)) {
                throw new IllegalArgumentException("Not a ship at 0x" + Integer.toHexString(edge));
            }
            ((SOCShip)rs).setClosed(closed);
        }
    }

    public void addLoneLegalSettlements(SOCGame ga, int[] ls) throws IllegalArgumentException {
        if (ls == null) {
            return;
        }
        if (ls.length != ga.maxPlayers) {
            throw new IllegalArgumentException();
        }
        for (int pn = 0; pn < ls.length; ++pn) {
            if (ls[pn] == 0) continue;
            ga.getPlayer(pn).addLegalSettlement(ls[pn], false);
        }
    }

    public boolean hasSpecialEdges() {
        return !this.specialEdges.isEmpty();
    }

    public int getSpecialEdgeType(int edge) {
        Integer typeObj = this.specialEdges.get(edge);
        if (typeObj == null) {
            return 0;
        }
        return typeObj;
    }

    public Iterator<Map.Entry<Integer, Integer>> getSpecialEdges() {
        return this.specialEdges.entrySet().iterator();
    }

    public void setSpecialEdge(int edge, int seType) {
        Integer edgeObj = edge;
        if (seType != 0) {
            this.specialEdges.put(edgeObj, seType);
        } else {
            this.specialEdges.remove(edgeObj);
        }
    }

    public void setSpecialEdges(int[] edges, int seType) {
        if (seType != 0) {
            Integer setypeObj = seType;
            for (int i = 0; i < edges.length; ++i) {
                this.specialEdges.put(edges[i], setypeObj);
            }
        } else {
            for (int i = 0; i < edges.length; ++i) {
                this.specialEdges.remove(edges[i]);
            }
        }
    }

    public void clearSpecialEdges(int seType) {
        if (seType == 0) {
            return;
        }
        Iterator<Map.Entry<Integer, Integer>> seIter = this.specialEdges.entrySet().iterator();
        while (seIter.hasNext()) {
            Map.Entry<Integer, Integer> entry = seIter.next();
            if (entry.getValue() != seType) continue;
            seIter.remove();
        }
    }

    public int[] getVillageAndClothLayout() {
        if (this.villages == null || this.villages.isEmpty()) {
            return null;
        }
        int[] vcl = new int[2 * this.villages.size() + 2];
        vcl[0] = this.numCloth;
        vcl[1] = 5;
        int i = 2;
        for (SOCVillage v : this.villages.values()) {
            vcl[i++] = v.getCoordinates();
            vcl[i++] = v.diceNum;
        }
        return vcl;
    }

    public void setVillageAndClothLayout(int[] villageNodesAndDice) throws NullPointerException, IllegalArgumentException {
        int L = villageNodesAndDice.length;
        if (L < 4 || L % 2 != 0) {
            throw new IllegalArgumentException("bad length: " + L);
        }
        if (this.villages == null) {
            this.villages = new HashMap();
        }
        this.setCloth(villageNodesAndDice[0]);
        int startingCloth = villageNodesAndDice[1];
        for (int i = 2; i < L; i += 2) {
            int node = villageNodesAndDice[i];
            this.villages.put(node, new SOCVillage(node, villageNodesAndDice[i + 1], startingCloth, (SOCBoard)this));
        }
    }

    public HashMap<Integer, SOCVillage> getVillages() {
        return this.villages;
    }

    public int getCloth() {
        return this.numCloth;
    }

    public void setCloth(int numCloth) {
        this.numCloth = numCloth;
    }

    public int takeCloth(int numTake) {
        if (numTake > this.numCloth) {
            numTake = this.numCloth;
            this.numCloth = 0;
        } else {
            this.numCloth -= numTake;
        }
        return numTake;
    }

    @Override
    public boolean isHexOnLand(int hexCoord) {
        int htype = this.getHexTypeFromCoord(hexCoord);
        return htype != -1 && htype != 0 && htype <= 8;
    }

    @Override
    public boolean isHexOnWater(int hexCoord) {
        return this.getHexTypeFromCoord(hexCoord) == 0;
    }

    public boolean isHexCoastline(int hexCoord) throws IllegalArgumentException {
        int htype = this.getHexTypeFromCoord(hexCoord);
        if (htype <= 0 || htype > 8) {
            throw new IllegalArgumentException("Not land (" + htype + "): 0x" + Integer.toHexString(hexCoord));
        }
        List<Integer> adjac = this.getAdjacentHexesToHex(hexCoord, false);
        return adjac == null || adjac.size() < 6;
    }

    public boolean isHexInLandAreas(int hexCoord, int[] las) {
        if (las == null || this.landAreasLegalNodes == null) {
            return false;
        }
        int[] hnodes = this.getAdjacentNodesToHex_arr(hexCoord);
        Integer hnode0 = hnodes[0];
        for (int la : las) {
            if (la >= this.landAreasLegalNodes.length) continue;
            if (la == 0) {
                boolean foundInAny = false;
                int[] nArray = hnodes;
                int n = nArray.length;
                block1: for (int i = 0; i < n; ++i) {
                    Integer hnodeInt = nArray[i];
                    for (HashSet<Integer> lan : this.landAreasLegalNodes) {
                        if (lan == null || !lan.contains(hnodeInt)) continue;
                        foundInAny = true;
                        break block1;
                    }
                }
                if (foundInAny) continue;
                return true;
            }
            HashSet<Integer> lan = this.landAreasLegalNodes[la];
            if (lan == null || !lan.contains(hnode0)) continue;
            boolean all = true;
            for (int i = 1; i < hnodes.length; ++i) {
                if (lan.contains(hnodes[i])) continue;
                all = false;
                break;
            }
            if (!all) continue;
            return true;
        }
        return false;
    }

    public boolean isNodeInLandAreas(int nodeCoord, int[] las) {
        if (las == null || this.landAreasLegalNodes == null) {
            return false;
        }
        Integer ncInt = nodeCoord;
        for (int a : las) {
            HashSet<Integer> lan;
            if (a >= this.landAreasLegalNodes.length || (lan = this.landAreasLegalNodes[a]) == null || !lan.contains(ncInt)) continue;
            return true;
        }
        return false;
    }

    public int getNodeLandArea(int nodeCoord) {
        if (this.landAreasLegalNodes == null) {
            return this.isNodeOnLand(nodeCoord) ? 1 : 0;
        }
        Integer nodeInt = nodeCoord;
        for (int i = 1; i < this.landAreasLegalNodes.length; ++i) {
            if (!this.landAreasLegalNodes[i].contains(nodeInt)) continue;
            return i;
        }
        return 0;
    }

    public final boolean isNodeCoastline(int node) {
        List<Integer> hexes = this.getAdjacentHexesToNode(node);
        boolean hasLand = false;
        boolean hasWater = hexes.size() < 3;
        for (Integer hex : hexes) {
            int htype = this.getHexTypeFromCoord(hex);
            if (htype <= 8 && htype != 0) {
                hasLand = true;
                continue;
            }
            hasWater = true;
        }
        return hasLand && hasWater;
    }

    public int[] getLandHexLayout() {
        int LHL = this.landHexLayout.size();
        if (LHL == 0) {
            return null;
        }
        int[] lh = new int[3 * LHL];
        int i = 0;
        for (Integer hex : this.landHexLayout) {
            int hexCoord = hex;
            int r = hexCoord >> 8;
            int c = hexCoord & 0xFF;
            lh[i] = hexCoord;
            lh[++i] = this.hexLayoutLg[r][c];
            lh[++i] = this.numberLayoutLg[r][c];
            ++i;
        }
        return lh;
    }

    public void setLandHexLayout(int[] lh) {
        this.landHexLayout.clear();
        this.fogHiddenHexes.clear();
        this.nodesOnLand.clear();
        this.legalRoadEdges.clear();
        this.cachedGetLandHexCoords = null;
        for (int r = 0; r <= this.boardHeight; ++r) {
            Arrays.fill(this.hexLayoutLg[r], 0);
            Arrays.fill(this.numberLayoutLg[r], 0);
        }
        if (lh == null) {
            return;
        }
        int[] hcoords = new int[lh.length / 3];
        Integer ZERO_OBJ = 0;
        int i = 0;
        int ih = 0;
        while (i < lh.length) {
            int hexCoord = lh[i];
            ++i;
            int r = hexCoord >> 8;
            int c = hexCoord & 0xFF;
            hcoords[ih] = hexCoord;
            this.landHexLayout.add(hexCoord);
            int htype = lh[i];
            this.hexLayoutLg[r][c] = htype;
            this.numberLayoutLg[r][c] = lh[++i];
            ++i;
            if (htype == 8) {
                this.fogHiddenHexes.put(hexCoord, ZERO_OBJ);
            }
            ++ih;
        }
        this.cachedGetLandHexCoords = hcoords;
    }

    public final HashMap<Integer, Integer> getFogHiddenHexes() {
        return this.fogHiddenHexes;
    }

    public void setFogHiddenHexes(HashMap<Integer, Integer> fogHexes) {
        this.fogHiddenHexes.clear();
        if (fogHexes != null) {
            this.fogHiddenHexes.putAll(fogHexes);
        }
    }

    public int getStartingLandArea() {
        return this.startingLandArea;
    }

    public HashSet<Integer>[] getLandAreasLegalNodes() {
        return this.landAreasLegalNodes;
    }

    public HashSet<Integer> getLegalSettlements() {
        if (this.landAreasLegalNodes == null || this.startingLandArea == 0) {
            return this.nodesOnLand;
        }
        return this.landAreasLegalNodes[this.startingLandArea];
    }

    public void setLegalSettlements(Collection<Integer> psNodes, int sla, HashSet<Integer>[] lan) throws IllegalArgumentException, IllegalStateException {
        if (lan == null) {
            if (psNodes == null) {
                throw new IllegalArgumentException("both null");
            }
            this.landAreasLegalNodes = null;
            this.startingLandArea = 0;
            if (psNodes instanceof HashSet) {
                this.nodesOnLand = new HashSet<Integer>(psNodes);
            } else {
                this.nodesOnLand.clear();
                this.nodesOnLand.addAll(psNodes);
            }
        } else {
            this.landAreasLegalNodes = lan;
            this.startingLandArea = sla;
            this.nodesOnLand.clear();
            for (int i = 1; i < lan.length; ++i) {
                this.nodesOnLand.addAll(lan[i]);
            }
        }
        this.initLegalRoadsFromLandNodes();
        this.initLegalShipEdges();
    }

    @Override
    public HashSet<Integer> initPlayerLegalRoads() {
        return new HashSet<Integer>(this.legalRoadEdges);
    }

    HashSet<Integer> initPlayerLegalShips() {
        return new HashSet<Integer>(this.legalShipEdges);
    }

    @Override
    public List<Integer> getAdjacentHexesToHex(int hexCoord, boolean includeWater) {
        ArrayList<Integer> hexes = new ArrayList<Integer>();
        int r = hexCoord >> 8;
        int c = hexCoord & 0xFF;
        for (int dir = 0; dir < 6; ++dir) {
            this.getAdjacentHexes2Hex_AddIfOK(hexes, includeWater, r + A_HEX2HEX[dir][0], c + A_HEX2HEX[dir][1]);
        }
        if (hexes.size() > 0) {
            return hexes;
        }
        return null;
    }

    private final void getAdjacentHexes2Hex_AddIfOK(List<Integer> addTo, boolean includeWater, int r, int c) {
        if (!this.isHexInBounds(r, c)) {
            return;
        }
        if (includeWater || this.hexLayoutLg[r][c] <= 8 && this.hexLayoutLg[r][c] != 0) {
            addTo.add(r << 8 | c);
        }
    }

    public int getAdjacentHexToHex(int hexCoord, int facing) throws IllegalArgumentException, IndexOutOfBoundsException {
        int adjacC;
        int adjacR;
        if (facing < 1 || facing > 6) {
            throw new IllegalArgumentException("facing: " + facing);
        }
        int r = hexCoord >> 8;
        int c = hexCoord & 0xFF;
        if (!this.isHexInBounds(r, c)) {
            throw new IndexOutOfBoundsException("hexCoord not in bounds: 0x" + Integer.toHexString(hexCoord));
        }
        if (!this.isHexInBounds(adjacR = r + A_HEX2HEX[--facing][0], adjacC = c + A_HEX2HEX[facing][1])) {
            return 0;
        }
        return adjacR << 8 | adjacC;
    }

    public boolean isHexAdjacentToHex(int hex1Coord, int hex2Coord) {
        for (int dir = 0; dir < 6; ++dir) {
            if (hex2Coord != hex1Coord + A_HEX2HEX[dir][0] * 256 + A_HEX2HEX[dir][1]) continue;
            return true;
        }
        return false;
    }

    public List<Integer> getAdjacentEdgesToHex(int hexCoord) {
        ArrayList<Integer> edges = new ArrayList<Integer>(6);
        for (int dir = 0; dir < 6; ++dir) {
            edges.add(hexCoord + A_EDGE2HEX[dir][0] + A_EDGE2HEX[dir][1]);
        }
        return edges;
    }

    public int[] getAdjacentEdgesToHex_arr(int hexCoord) {
        int[] edge = new int[6];
        for (int dir = 0; dir < 6; ++dir) {
            edge[dir] = hexCoord + A_EDGE2HEX[dir][0] + A_EDGE2HEX[dir][1];
        }
        return edge;
    }

    public boolean isEdgeAdjacentToHex(int edgeCoord, int hexCoord) {
        for (int dir = 0; dir < 6; ++dir) {
            if (edgeCoord != hexCoord + A_EDGE2HEX[dir][0] + A_EDGE2HEX[dir][1]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getAdjacentNodeToHex(int hexCoord, int dir) throws IllegalArgumentException {
        if (dir >= 0 && dir <= 5) {
            return hexCoord + A_NODE2HEX[dir][0] + A_NODE2HEX[dir][1];
        }
        throw new IllegalArgumentException("dir");
    }

    @Override
    public int[] getAdjacentNodesToHex_arr(int hexCoord) {
        int[] node = new int[6];
        for (int dir = 0; dir < 6; ++dir) {
            node[dir] = hexCoord + A_NODE2HEX[dir][0] + A_NODE2HEX[dir][1];
        }
        return node;
    }

    @Override
    public int getAdjacentHexToEdge(int edgeCoord, int facing) throws IllegalArgumentException {
        if (facing < 1 || facing > 6) {
            throw new IllegalArgumentException();
        }
        int r = edgeCoord >> 8;
        int c = edgeCoord & 0xFF;
        if (r % 2 == 1) {
            switch (facing) {
                case 2: {
                    ++c;
                    break;
                }
                case 5: {
                    --c;
                    break;
                }
                case 1: 
                case 6: {
                    r -= 2;
                    break;
                }
                case 3: 
                case 4: {
                    r += 2;
                }
            }
        } else if (c % 2 != r / 2 % 2) {
            switch (facing) {
                case 6: {
                    --r;
                    break;
                }
                case 3: {
                    ++r;
                    ++c;
                    break;
                }
                case 1: 
                case 2: {
                    --r;
                    c += 2;
                    break;
                }
                case 4: 
                case 5: {
                    ++r;
                    --c;
                }
            }
        } else {
            switch (facing) {
                case 1: {
                    --r;
                    ++c;
                    break;
                }
                case 4: {
                    ++r;
                    break;
                }
                case 2: 
                case 3: {
                    ++r;
                    c += 2;
                    break;
                }
                case 5: 
                case 6: {
                    --r;
                    --c;
                }
            }
        }
        if (r > 0 && c > 0 && r < this.boardHeight && c < this.boardWidth) {
            return r << 8 | c;
        }
        return 0;
    }

    public int[] getAdjacentHexesToEdge_arr(int edgeCoord) throws IllegalArgumentException {
        int[] hexes = new int[2];
        int r = edgeCoord >> 8;
        int c = edgeCoord & 0xFF;
        if (r % 2 == 1) {
            if (c < this.boardWidth - 1) {
                hexes[0] = edgeCoord + 1;
            }
            if (c > 1) {
                hexes[1] = edgeCoord - 1;
            }
        } else if (c % 2 != r / 2 % 2) {
            if (r > 1 && c > 0) {
                hexes[0] = edgeCoord - 256;
            }
            if (r < this.boardHeight - 1 && c < this.boardWidth - 1) {
                hexes[1] = edgeCoord + 257;
            }
        } else {
            if (r > 1 && c < this.boardWidth - 1) {
                hexes[0] = edgeCoord - 256 + 1;
            }
            if (r < this.boardHeight - 1 && c > 0) {
                hexes[1] = edgeCoord + 256;
            }
        }
        return hexes;
    }

    public int[] getAdjacentHexesToEdgeEnds(int edgeCoord) throws IllegalArgumentException {
        int[] hexes = new int[2];
        int r = edgeCoord >> 8;
        int c = edgeCoord & 0xFF;
        if (r % 2 == 1) {
            if (r > 2) {
                hexes[0] = edgeCoord - 512;
            }
            if (r < this.boardHeight - 2) {
                hexes[1] = edgeCoord + 512;
            }
        } else if (c % 2 != r / 2 % 2) {
            if (r > 1 && c < this.boardWidth - 2) {
                hexes[0] = edgeCoord - 256 + 2;
            }
            if (r < this.boardHeight - 1 && c > 1) {
                hexes[1] = edgeCoord + 256 - 1;
            }
        } else {
            if (r > 1 && c > 1) {
                hexes[0] = edgeCoord - 257;
            }
            if (r < this.boardHeight - 1 && c < this.boardWidth - 2) {
                hexes[1] = edgeCoord + 258;
            }
        }
        return hexes;
    }

    @Override
    public List<Integer> getAdjacentEdgesToEdge(int coord) {
        int r = coord >> 8;
        int c = coord & 0xFF;
        int dir = r % 2 == 1 ? 0 : (c % 2 != r / 2 % 2 ? 1 : 2);
        int[] offs = A_EDGE2EDGE[dir];
        ArrayList<Integer> edge = new ArrayList<Integer>(4);
        for (int i = 0; i < 8; ++i) {
            int er = r + offs[i];
            int ec = c + offs[++i];
            if (!this.isEdgeInBounds(er, ec)) continue;
            edge.add(er << 8 | ec);
        }
        return edge;
    }

    public int getAdjacentNodeToEdge(int edgeCoord, int facing) throws IllegalArgumentException {
        if (facing < 1 || facing > 6) {
            throw new IllegalArgumentException("facing out of range");
        }
        int r = edgeCoord >> 8;
        int c = edgeCoord & 0xFF;
        boolean perpendicular = false;
        if (r % 2 == 1) {
            switch (facing) {
                case 1: 
                case 6: {
                    --r;
                    break;
                }
                case 3: 
                case 4: {
                    ++r;
                    break;
                }
                case 2: 
                case 5: {
                    perpendicular = true;
                }
            }
        } else if (c % 2 != r / 2 % 2) {
            switch (facing) {
                case 1: 
                case 2: {
                    ++c;
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 3: 
                case 6: {
                    perpendicular = true;
                }
            }
        } else {
            switch (facing) {
                case 2: 
                case 3: {
                    ++c;
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 1: 
                case 4: {
                    perpendicular = true;
                }
            }
        }
        if (perpendicular) {
            throw new IllegalArgumentException("facing " + facing + " perpendicular from edge 0x" + Integer.toHexString(edgeCoord));
        }
        return r << 8 | c;
    }

    @Override
    public List<Integer> getAdjacentNodesToEdge(int coord) {
        ArrayList<Integer> nodes = new ArrayList<Integer>(2);
        int[] narr = this.getAdjacentNodesToEdge_arr(coord);
        nodes.add(narr[0]);
        nodes.add(narr[1]);
        return nodes;
    }

    @Override
    public int[] getAdjacentNodesToEdge_arr(int coord) {
        int[] nodes = new int[2];
        int r = coord >> 8;
        if (r % 2 == 1) {
            nodes[0] = coord - 256;
            nodes[1] = coord + 256;
        } else {
            nodes[0] = coord;
            nodes[1] = coord + 1;
        }
        return nodes;
    }

    @Override
    public int getNodeBetweenAdjacentEdges(int edgeA, int edgeB) throws IllegalArgumentException {
        int node;
        switch (edgeB - edgeA) {
            case 1: {
                node = edgeB;
                break;
            }
            case -1: {
                node = edgeA;
                break;
            }
            case -257: {
                node = edgeB + 1;
                break;
            }
            case 257: {
                node = edgeA + 1;
                break;
            }
            case 256: {
                if ((edgeB >> 8) % 2 == 1) {
                    node = edgeA;
                    break;
                }
                node = edgeB;
                break;
            }
            case -256: {
                if ((edgeA >> 8) % 2 == 1) {
                    node = edgeB;
                    break;
                }
                node = edgeA;
                break;
            }
            case 255: {
                if ((edgeA >> 8) % 2 == 1 && edgeA >> 8 < edgeB >> 8) {
                    node = edgeB + 1;
                    break;
                }
                node = -9;
                break;
            }
            case -255: {
                if ((edgeB >> 8) % 2 == 1 && edgeA >> 8 > edgeB >> 8) {
                    node = edgeA + 1;
                    break;
                }
                node = -9;
                break;
            }
            default: {
                node = -9;
            }
        }
        if (node == -9) {
            throw new IllegalArgumentException("Edges not adjacent: 0x" + Integer.toHexString(edgeA) + ", 0x" + Integer.toHexString(edgeB));
        }
        return node;
    }

    @Override
    public List<Integer> getAdjacentHexesToNode(int nodeCoord) {
        boolean nodeIsY;
        int r = nodeCoord >> 8;
        int c = nodeCoord & 0xFF;
        ArrayList<Integer> hexes = new ArrayList<Integer>(3);
        boolean bl = nodeIsY = c % 2 != r / 2 % 2;
        if (nodeIsY) {
            if (r > 1) {
                hexes.add(nodeCoord - 256);
            }
            if (r < this.boardHeight - 1) {
                if (c > 1) {
                    hexes.add(nodeCoord + 256 - 1);
                }
                if (c < this.boardWidth - 1) {
                    hexes.add(nodeCoord + 256 + 1);
                }
            }
        } else {
            if (r < this.boardHeight - 1) {
                hexes.add(nodeCoord + 256);
            }
            if (r > 1) {
                if (c > 1) {
                    hexes.add(nodeCoord - 256 - 1);
                }
                if (c < this.boardWidth - 1) {
                    hexes.add(nodeCoord - 256 + 1);
                }
            }
        }
        return hexes;
    }

    @Override
    public int getAdjacentEdgeToNode(int nodeCoord, int nodeDir) throws IllegalArgumentException {
        int r = nodeCoord >> 8;
        int c = nodeCoord & 0xFF;
        switch (nodeDir) {
            case 0: {
                --c;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                boolean nodeIsY;
                boolean bl = nodeIsY = c % 2 != r / 2 % 2;
                if (nodeIsY) {
                    ++r;
                    break;
                }
                --r;
                break;
            }
            default: {
                throw new IllegalArgumentException("nodeDir out of range: " + nodeDir);
            }
        }
        if (this.isEdgeInBounds(r, c)) {
            return r << 8 | c;
        }
        return -9;
    }

    @Override
    public int getEdgeBetweenAdjacentNodes(int nodeA, int nodeB) {
        int edge;
        switch (nodeB - nodeA) {
            case 1: {
                edge = nodeA;
                break;
            }
            case -1: {
                edge = nodeB;
                break;
            }
            case 512: {
                edge = nodeA + 256;
                break;
            }
            case -512: {
                edge = nodeA - 256;
                break;
            }
            default: {
                edge = -9;
            }
        }
        return edge;
    }

    @Override
    public boolean isEdgeAdjacentToNode(int nodeCoord, int edgeCoord) {
        boolean nodeIsY;
        int edgeR = edgeCoord >> 8;
        int edgeC = edgeCoord & 0xFF;
        if (!this.isEdgeInBounds(edgeR, edgeC)) {
            return false;
        }
        if (edgeCoord == nodeCoord || edgeCoord == nodeCoord - 1) {
            return true;
        }
        int nodeC = nodeCoord & 0xFF;
        if (edgeC != nodeC) {
            return false;
        }
        int nodeR = nodeCoord >> 8;
        boolean bl = nodeIsY = nodeC % 2 != nodeR / 2 % 2;
        if (nodeIsY) {
            return edgeR == nodeR + 1;
        }
        return edgeR == nodeR - 1;
    }

    public final List<Integer> getAdjacentEdgesToNode_coastal(int node) {
        ArrayList<Integer> coastEdges = new ArrayList<Integer>(3);
        for (int edge : this.getAdjacentEdgesToNode_arr(node)) {
            if (edge == -9) continue;
            boolean hasLand = false;
            boolean hasWater = false;
            for (int hex : this.getAdjacentHexesToEdge_arr(edge)) {
                if (hex == 0) {
                    hasWater = true;
                    continue;
                }
                int htype = this.getHexTypeFromCoord(hex);
                if (htype <= 8 && htype != 0) {
                    hasLand = true;
                    continue;
                }
                hasWater = true;
            }
            if (!hasLand || !hasWater) continue;
            coastEdges.add(edge);
        }
        return coastEdges;
    }

    @Override
    public int getAdjacentNodeToNode(int nodeCoord, int nodeDir) throws IllegalArgumentException {
        int r = nodeCoord >> 8;
        int c = nodeCoord & 0xFF;
        switch (nodeDir) {
            case 0: {
                --c;
                break;
            }
            case 1: {
                ++c;
                break;
            }
            case 2: {
                int s = r / 2;
                if (s % 2 != c % 2) {
                    r += 2;
                    break;
                }
                r -= 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("nodeDir out of range: " + nodeDir);
            }
        }
        if (this.isNodeInBounds(r, c)) {
            return r << 8 | c;
        }
        return -9;
    }

    @Override
    public int getAdjacentEdgeToNode2Away(int node, int node2away) {
        boolean nodeIsY;
        int r = node >> 8;
        int c = node & 0xFF;
        int r2 = node2away >> 8;
        int c2 = node2away & 0xFF;
        boolean bl = nodeIsY = c % 2 != r / 2 % 2;
        int roadEdge = nodeIsY ? (r2 > r ? node + 256 : (c2 < c ? node - 1 : node)) : (r2 < r ? node - 256 : (c2 < c ? node - 1 : node));
        return roadEdge;
    }

    @Override
    public int getAdjacentNodeToNode2Away(int nodeCoord, int facing) throws IllegalArgumentException {
        if (facing < 1 || facing > 6) {
            throw new IllegalArgumentException("bad facing: " + facing);
        }
        int r = nodeCoord >> 8;
        int c = nodeCoord & 0xFF;
        facing *= 2;
        if (!this.isNodeInBounds(r += NODE_TO_NODE_2_AWAY[facing], c += NODE_TO_NODE_2_AWAY[++facing])) {
            return -9;
        }
        return r << 8 | c;
    }

    @Override
    public boolean isNode2AwayFromNode(int n1, int n2) {
        int dr = (n2 >> 8) - (n1 >> 8);
        int dc = (n2 & 0xFF) - (n1 & 0xFF);
        for (int facing = 1; facing <= 6; ++facing) {
            int i = 2 * facing;
            if (dr != NODE_TO_NODE_2_AWAY[i] || dc != NODE_TO_NODE_2_AWAY[i + 1]) continue;
            return true;
        }
        return false;
    }

    public final boolean isHexInBounds(int r, int c) {
        if (r <= 0 || c <= 0 || r >= this.boardHeight || c >= this.boardWidth) {
            return false;
        }
        return r % 2 == 1;
    }

    public final boolean isHexAtBoardMargin(int hexCoord) {
        int r = hexCoord >> 8;
        int c = hexCoord & 0xFF;
        return r == 1 || r == this.boardHeight - 1 || c <= 2 || c >= this.boardWidth - 2;
    }

    public final boolean isNodeInBounds(int r, int c) {
        if (r > 0 && r < this.boardHeight) {
            return c >= 0 && c <= this.boardWidth;
        }
        if (r < 0 || r > this.boardHeight) {
            return false;
        }
        if (c > 0 && c < this.boardWidth) {
            return true;
        }
        if (r == 0) {
            if (c == 0) {
                return false;
            }
            return this.boardWidth % 2 == 1;
        }
        if (c == 0) {
            return r / 2 % 2 == 0;
        }
        return this.boardWidth % 2 == r / 2 % 2;
    }

    public final boolean isEdgeInBounds(int r, int c) {
        if (c < 0) {
            return false;
        }
        if (r > 0 && r < this.boardHeight) {
            if (r % 2 == 0) {
                return c < this.boardWidth;
            }
            return c <= this.boardWidth;
        }
        if (r < 0 || r > this.boardHeight) {
            return false;
        }
        if (c == 0) {
            if (r == 0) {
                return false;
            }
            return this.isNodeInBounds(r, 0);
        }
        if (c < this.boardWidth - 1) {
            return true;
        }
        if (c == this.boardWidth) {
            return false;
        }
        return this.isNodeInBounds(r, c + 1);
    }

    @Override
    public int getPortsCount() {
        return this.portsCount;
    }

    @Override
    public void setPortsLayout(int[] portTypesAndInfo) {
        int i;
        this.portsLayout = portTypesAndInfo;
        this.portsCount = portTypesAndInfo.length / 3;
        if (this.nodeIDtoPortType == null) {
            this.nodeIDtoPortType = new HashMap();
        } else {
            this.nodeIDtoPortType.clear();
        }
        for (i = 0; i < this.ports.length; ++i) {
            this.ports[i].clear();
        }
        for (i = 0; i < this.portsCount; ++i) {
            int ptype = portTypesAndInfo[i];
            int edge = portTypesAndInfo[i + this.portsCount];
            int facing = portTypesAndInfo[i + 2 * this.portsCount];
            if (edge < 0) continue;
            int[] nodes = this.getAdjacentNodesToEdge_arr(edge);
            this.placePort(ptype, -1, facing, nodes[0], nodes[1]);
        }
    }

    @Override
    public int[] getPortsEdges() {
        int[] edge = new int[this.portsCount];
        System.arraycopy(this.portsLayout, this.portsCount, edge, 0, this.portsCount);
        return edge;
    }

    @Override
    public int[] getPortsFacing() {
        int[] facing = new int[this.portsCount];
        System.arraycopy(this.portsLayout, 2 * this.portsCount, facing, 0, this.portsCount);
        return facing;
    }

    public int getPortEdgeFromNode(int node) {
        int[] ed = this.getAdjacentEdgesToNode_arr(node);
        int n = this.portsCount;
        for (int i = 0; i < n; ++i) {
            int portEdge = this.portsLayout[n + i];
            if (portEdge < 0) continue;
            for (int j = 0; j < 3; ++j) {
                if (portEdge != ed[j]) continue;
                return portEdge;
            }
        }
        return -9;
    }

    public int getPortFacingFromEdge(int edge) throws IllegalArgumentException {
        return this.getPortFacingFromEdge(edge, false);
    }

    final int getPortFacingFromEdge(int edge, boolean skipCoastalCheck) throws IllegalArgumentException {
        int facing;
        int f2;
        int f1;
        int r = edge >> 8;
        int c = edge & 0xFF;
        if (r % 2 == 1) {
            f1 = 2;
            f2 = 5;
        } else if (c % 2 != r / 2 % 2) {
            f1 = 6;
            f2 = 3;
        } else {
            f1 = 1;
            f2 = 4;
        }
        if (skipCoastalCheck) {
            return f1;
        }
        int hex = this.getAdjacentHexToEdge(edge, f2);
        if (hex == 0 || this.getHexTypeFromCoord(hex) == 0) {
            facing = f1;
        } else {
            hex = this.getAdjacentHexToEdge(edge, f1);
            if (hex == 0 || this.getHexTypeFromCoord(hex) == 0) {
                facing = f2;
            } else {
                throw new IllegalArgumentException("Edge 0x" + Integer.toHexString(edge) + " is between land hexes");
            }
        }
        hex = this.getAdjacentHexToEdge(edge, facing);
        if (hex == 0 || this.getHexTypeFromCoord(hex) == 0) {
            throw new IllegalArgumentException("Edge 0x" + Integer.toHexString(edge) + " is between water hexes");
        }
        return facing;
    }

    public boolean canRemovePort(int edge) {
        int i;
        int n = this.portsCount;
        for (i = 0; i < n && edge != this.portsLayout[n + i]; ++i) {
        }
        if (i == n) {
            return false;
        }
        int[] portNodes = this.getAdjacentNodesToEdge_arr(edge);
        for (i = 0; i <= 1; ++i) {
            int la = this.getNodeLandArea(portNodes[i]);
            boolean ok = false;
            if (la == 0) {
                ok = true;
            } else if (this.playerExcludedLandAreas != null) {
                for (int j = 0; j < this.playerExcludedLandAreas.length; ++j) {
                    if (la != this.playerExcludedLandAreas[j]) continue;
                    ok = true;
                    break;
                }
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    public int removePort(int edge) throws IllegalArgumentException {
        int n = this.portsCount;
        for (int i = 0; i < n; ++i) {
            if (edge != this.portsLayout[n + i]) continue;
            this.portsLayout[n + i] = -1;
            int[] nodes = this.getAdjacentNodesToEdge_arr(edge);
            int node1Int = nodes[0];
            int node2Int = nodes[1];
            this.nodeIDtoPortType.remove(node1Int);
            this.nodeIDtoPortType.remove(node2Int);
            int ptype = this.portsLayout[i];
            this.ports[ptype].remove((Object)node1Int);
            this.ports[ptype].remove((Object)node2Int);
            return this.portsLayout[i];
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String edgeCoordToString(int edge) {
        int[] hexes = this.getAdjacentHexesToEdge_arr(edge);
        int[] dnums = new int[2];
        for (int i = 0; i <= 1; ++i) {
            if (hexes[i] == 0) continue;
            dnums[i] = this.getNumberOnHexFromCoord(hexes[i]);
        }
        return dnums[0] + "/" + dnums[1];
    }
}

