/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import soc.game.SOCDevCardConstants;
import soc.game.SOCGame;
import soc.game.SOCInventoryItem;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.util.SOCStringManager;

public class SOCDevCard
extends SOCInventoryItem
implements SOCDevCardConstants {
    private static final long serialVersionUID = 2000L;
    public static final SOCResourceSet COST = new SOCResourceSet(0, 1, 1, 1, 0, 0);
    private final boolean nameKeyPrecalc;
    private static final String[][] GETCARDTYPENAME_KEYS = new String[][]{{"spec.dcards.unknown", "spec.dcards.roadbuilding", "spec.dcards.discoveryplenty", "spec.dcards.monopoly", "spec.dcards.capgovhouse", "spec.dcards.market", "spec.dcards.university", "spec.dcards.temple", "spec.dcards.towerchapel", "spec.dcards.knightsoldier"}, {"spec.dcards.aunknown", "spec.dcards.aroadbuilding", "spec.dcards.adiscoveryplenty", "spec.dcards.amonopoly", "spec.dcards.acapgovhouse", "spec.dcards.amarket", "spec.dcards.auniversity", "spec.dcards.atemple", "spec.dcards.atowerchapel", "spec.dcards.aknightsoldier"}, {"UNKNOWN", "ROADS", "DISC", "MONO", "CAP", "MARKET", "UNIV", "TEMPLE", "CHAPEL", "KNIGHT"}};

    public static boolean isVPCard(int devCardType) {
        return devCardType >= 4 && devCardType <= 8;
    }

    public static String getCardTypeNameKey(int devCardType, SOCGame game, boolean withArticle) {
        if (devCardType == 9 && game != null && game.isGameOptionSet("_SC_PIRI")) {
            return withArticle ? "spec.dcards.aknightsoldier.warship" : "spec.dcards.knightsoldier.warship";
        }
        String[] keyArr = GETCARDTYPENAME_KEYS[withArticle ? 1 : 0];
        String ctname = devCardType >= 0 && devCardType < keyArr.length ? keyArr[devCardType] : keyArr[0];
        return ctname;
    }

    public static String getCardTypeName(int devCardType, SOCGame game, boolean withArticle, SOCStringManager strings) {
        String ctname = devCardType >= 0 && devCardType < GETCARDTYPENAME_KEYS[0].length ? strings.get(SOCDevCard.getCardTypeNameKey(devCardType, game, withArticle)) : "Unknown card type " + devCardType;
        return ctname;
    }

    public static String getCardTypeName(int devCardType) throws IllegalArgumentException {
        return SOCPlayingPiece.getTypeName(devCardType, GETCARDTYPENAME_KEYS[2]);
    }

    public static int getCardType(String ctypeName) throws IllegalArgumentException, NumberFormatException {
        return SOCPlayingPiece.getType(ctypeName, GETCARDTYPENAME_KEYS[2], 0);
    }

    public SOCDevCard(int type, boolean isNew) {
        this(type, SOCDevCard.isVPCard(type), isNew);
    }

    private SOCDevCard(int type, boolean isVPCard, boolean isNew) {
        super(type, !isNew && !isVPCard, isVPCard, isVPCard, false, SOCDevCard.getCardTypeNameKey(type, null, false), SOCDevCard.getCardTypeNameKey(type, null, true));
        this.nameKeyPrecalc = type > 0 && type < GETCARDTYPENAME_KEYS[0].length && type != 9;
    }

    @Override
    public String toString() {
        return "SOCDevCard{type=" + this.itype + ", playable=" + this.isPlayable() + ", isVP=" + this.isVPItem() + "}";
    }

    @Override
    public String getItemName(SOCGame game, boolean withArticle, SOCStringManager strings) {
        if (this.nameKeyPrecalc) {
            return strings.get(withArticle ? this.aStrKey : this.strKey);
        }
        return SOCDevCard.getCardTypeName(this.itype, game, withArticle, strings);
    }
}

