/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import soc.game.SOCInventoryItem;
import soc.game.SOCResourceSet;

public class SOCForceEndTurnResult {
    private int result;
    private SOCResourceSet gainLoss;
    private boolean rsrcLoss;
    private SOCInventoryItem invCard;
    private boolean updatedFP;
    private boolean updatedLP;
    public static final int FORCE_ENDTURN_MIN = 1;
    public static final int FORCE_ENDTURN_NONE = 1;
    public static final int FORCE_ENDTURN_SKIP_START_ADV = 2;
    public static final int FORCE_ENDTURN_SKIP_START_ADVBACK = 3;
    public static final int FORCE_ENDTURN_SKIP_START_TURN = 4;
    public static final int FORCE_ENDTURN_RSRC_RET_UNPLACE = 5;
    public static final int FORCE_ENDTURN_UNPLACE_ROBBER = 6;
    public static final int FORCE_ENDTURN_RSRC_DISCARD = 7;
    public static final int FORCE_ENDTURN_RSRC_DISCARD_WAIT = 8;
    public static final int FORCE_ENDTURN_LOST_CHOICE = 9;
    public static final int FORCE_ENDTURN_MAX = 9;

    public SOCForceEndTurnResult(int res) throws IllegalArgumentException {
        this(res, null, false, false, false);
    }

    public SOCForceEndTurnResult(int res, boolean updateFirstPlayer, boolean updateLastPlayer, SOCResourceSet rsrcGained) throws IllegalArgumentException {
        this(res, rsrcGained, false, updateFirstPlayer, updateLastPlayer);
    }

    public SOCForceEndTurnResult(int res, SOCInventoryItem item) throws IllegalArgumentException {
        this(res);
        this.invCard = item;
    }

    public SOCForceEndTurnResult(int res, SOCResourceSet gained) throws IllegalArgumentException {
        this(res, gained, false, false, false);
    }

    public SOCForceEndTurnResult(int res, SOCResourceSet gainedLost, boolean isLoss) throws IllegalArgumentException {
        this(res, gainedLost, isLoss, false, false);
    }

    private SOCForceEndTurnResult(int res, SOCResourceSet gainedLost, boolean isLoss, boolean updateFirstPlayer, boolean updateLastPlayer) throws IllegalArgumentException {
        if (res < 1 || res > 9) {
            throw new IllegalArgumentException("res out of range: " + res);
        }
        this.result = res;
        this.gainLoss = gainedLost;
        this.rsrcLoss = isLoss;
        this.updatedFP = updateFirstPlayer;
        this.updatedLP = updateLastPlayer;
        this.invCard = null;
    }

    public int getResult() {
        return this.result;
    }

    public SOCResourceSet getResourcesGainedLost() {
        return this.gainLoss;
    }

    public boolean isLoss() {
        return this.rsrcLoss;
    }

    public boolean didUpdateFP() {
        return this.updatedFP;
    }

    public boolean didUpdateLP() {
        return this.updatedLP;
    }

    public SOCInventoryItem getReturnedInvItem() {
        return this.invCard;
    }
}

