/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.GameAction;
import soc.game.ResourceSet;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCCity;
import soc.game.SOCDevCard;
import soc.game.SOCForceEndTurnResult;
import soc.game.SOCFortress;
import soc.game.SOCGameEvent;
import soc.game.SOCGameEventListener;
import soc.game.SOCGameOptionSet;
import soc.game.SOCInventoryItem;
import soc.game.SOCMoveRobberResult;
import soc.game.SOCOldLRStats;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerEvent;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCRoutePiece;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.game.SOCSpecialItem;
import soc.game.SOCTradeOffer;
import soc.game.SOCVersionedItem;
import soc.game.SOCVillage;
import soc.message.SOCMessage;
import soc.server.SOCBoardAtServer;
import soc.util.DataUtils;
import soc.util.IntPair;
import soc.util.SOCFeatureSet;
import soc.util.SOCGameBoardReset;

public class SOCGame
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2700L;
    public static final int NEW = 0;
    public static final int READY = 1;
    public static final int READY_RESET_WAIT_ROBOT_DISMISS = 4;
    public static final int START1A = 5;
    public static final int START1B = 6;
    public static final int START2A = 10;
    public static final int STARTS_WAITING_FOR_PICK_GOLD_RESOURCE = 14;
    public static final int START2B = 11;
    public static final int START3A = 12;
    public static final int START3B = 13;
    public static final int ROLL_OR_CARD = 15;
    public static final int PLAY1 = 20;
    public static final int PLACING_ROAD = 30;
    public static final int PLACING_SETTLEMENT = 31;
    public static final int PLACING_CITY = 32;
    public static final int PLACING_ROBBER = 33;
    public static final int PLACING_PIRATE = 34;
    public static final int PLACING_SHIP = 35;
    public static final int PLACING_FREE_ROAD1 = 40;
    public static final int PLACING_FREE_ROAD2 = 41;
    public static final int PLACING_INV_ITEM = 42;
    public static final int WAITING_FOR_DISCARDS = 50;
    public static final int WAITING_FOR_ROB_CHOOSE_PLAYER = 51;
    public static final int WAITING_FOR_DISCOVERY = 52;
    public static final int WAITING_FOR_MONOPOLY = 53;
    public static final int WAITING_FOR_ROBBER_OR_PIRATE = 54;
    public static final int WAITING_FOR_ROB_CLOTH_OR_RESOURCE = 55;
    public static final int WAITING_FOR_PICK_GOLD_RESOURCE = 56;
    public static final int SPECIAL_BUILDING = 100;
    public static final int UNDOING_ACTION = 950;
    public static final int LOADING = 990;
    public static final int LOADING_RESUMING = 992;
    public static final int OVER = 1000;
    public static final int RESET_OLD = 1001;
    private static final int VACANT = 0;
    private static final int OCCUPIED = 1;
    private static final int VACANT_PENDING_REPLACE = 2;
    public static final int VOTE_NONE = 0;
    public static final int VOTE_YES = 1;
    public static final int VOTE_NO = 2;
    public static final int MAXPLAYERS = 6;
    public static final int MAXPLAYERS_STANDARD = 4;
    public static final int MINPLAYERS = 2;
    public static final int VP_WINNER_STANDARD = 10;
    private static final int NUM_DEVCARDS_VP = 5;
    private static final int NUM_DEVCARDS_STANDARD = 25;
    private static final int NUM_DEVCARDS_6PLAYER = 34;
    public static final int VERSION_FOR_CANCEL_FREE_ROAD1 = 2500;
    public static final int VERSION_FOR_CANCEL_FREE_ROAD2 = 1117;
    public static final int VERSION_FOR_CANCEL_PLAY_CURRENT_DEV_CARD = 2700;
    public static final int VERSION_FOR_LONGEST_LARGEST_FROM_SERVER = 2400;
    public static final ResourceSet EMPTY_RESOURCES = new SOCResourceSet();
    public static SOCBoard.BoardFactory boardFactory;
    private static final int[] EMPTY_INT_ARRAY;
    boolean inUse;
    private String name;
    public boolean isAtServer;
    public transient int serverVersion;
    public transient List<Object> pendingMessagesOut;
    public transient Object savedGameModel;
    private String ownerName;
    private String ownerLocale;
    private Set<String> chatAllowList;
    public transient boolean hasHintedObserverWantsChat;
    public boolean hasDoneGameOverTasks;
    private boolean active;
    public final int vp_winner;
    public final boolean hasScenarioWinCondition;
    public boolean isPractice;
    public boolean isBotsOnly;
    private boolean hasBuiltCity;
    SOCGameEventListener gameEventListener;
    public boolean hasOldClients;
    public int clientVersionLowest;
    public int clientVersionHighest;
    private int clientVersionMinRequired;
    private SOCFeatureSet clientFeaturesRequired;
    public boolean hasMultiLocales;
    private boolean debugFreePlacement;
    private boolean debugFreePlacementStartPlaced;
    private boolean isFromBoardReset;
    public transient SOCGameBoardReset boardResetOngoingInfo;
    private int boardResetVoteRequester;
    private int[] boardResetVotes;
    private int boardResetVotesWaiting;
    private SOCBoard board;
    private final SOCGameOptionSet opts;
    private final SOCGameOptionSet knownOpts;
    private final SOCPlayer[] players;
    private int[] seats;
    private SeatLockState[] seatLocks;
    private int currentPlayerNumber;
    private int firstPlayerNumber;
    private int lastPlayerNumber;
    public final int maxPlayers;
    public final boolean hasSeaBoard;
    private int currentDice;
    private RollResult currentRoll;
    private boolean hasRolledSeven;
    private SOCMoveRobberResult robberResult;
    private int gameState;
    private int oldGameState;
    private boolean placingRobberForKnightCard;
    private boolean playingRoadBuildingCardForLastRoad;
    private boolean forcingEndTurn;
    private boolean askedSpecialBuildPhase;
    private int specialBuildPhase_afterPlayerNumber;
    private int playerWithLargestArmy;
    private int oldPlayerWithLargestArmy;
    private int playerWithLongestRoad;
    Stack<SOCOldLRStats> oldPlayerWithLongestRoad;
    private int playerWithWin;
    private int numDevCards;
    private int[] devCardDeck;
    private HashMap<String, ArrayList<SOCSpecialItem>> spItems;
    private Random rand = new Random();
    boolean allOriginalPlayers;
    Date startTime;
    private int finalDurationSeconds;
    long expiration;
    private boolean hasWarnedExpir;
    public long lastActionTime;
    private GameAction lastAction;
    private boolean robberyWithPirateNotRobber;
    private boolean movedShipThisTurn;
    private Vector<Integer> shipsPlacedThisTurn;
    private SOCInventoryItem placingItem;
    private int turnCount;
    private int roundCount;

    public SOCGame(String gameName) {
        this(gameName, true, null, null);
    }

    public SOCGame(String gameName, SOCGameOptionSet op, SOCGameOptionSet knownOpts) throws IllegalArgumentException {
        this(gameName, true, op, knownOpts);
    }

    public SOCGame(String gameName, boolean isActive) throws IllegalArgumentException {
        this(gameName, isActive, null, null);
    }

    public SOCGame(String gameName, boolean isActive, SOCGameOptionSet op, SOCGameOptionSet knownOpts) throws IllegalArgumentException {
        if (!SOCMessage.isSingleLineAndSafe(gameName)) {
            throw new IllegalArgumentException("gameName");
        }
        this.active = isActive;
        this.inUse = false;
        this.name = gameName;
        if (op != null) {
            if (knownOpts == null) {
                throw new IllegalArgumentException("knownOpts");
            }
            Map<String, String> optProblems = op.adjustOptionsToKnown(knownOpts, false, null);
            if (optProblems != null) {
                StringBuilder sb = new StringBuilder("op: unknown option(s): ");
                DataUtils.mapIntoStringBuilder(optProblems, sb, null, "; ");
                throw new IllegalArgumentException(sb.toString());
            }
            this.hasSeaBoard = op.isOptionSet("SBL");
            boolean wants6board = op.isOptionSet("PLB");
            int maxpl = op.getOptionIntValue("PL", 4, false);
            this.maxPlayers = wants6board || maxpl > 4 ? 6 : 4;
            this.vp_winner = op.getOptionIntValue("VP", 10, true);
            this.hasScenarioWinCondition = op.isOptionSet("_SC_CLVI") || op.isOptionSet("_SC_PIRI") || op.isOptionSet("_SC_WOND");
            this.clientVersionMinRequired = SOCVersionedItem.itemsMinimumVersion(op.getAll());
        } else {
            this.maxPlayers = 4;
            this.hasSeaBoard = false;
            this.vp_winner = 10;
            this.hasScenarioWinCondition = false;
            this.clientVersionMinRequired = -1;
        }
        this.knownOpts = knownOpts;
        if (boardFactory == null) {
            boardFactory = new SOCBoard.DefaultBoardFactory();
        }
        this.board = boardFactory.createBoard(op, this.hasSeaBoard, this.maxPlayers);
        this.opts = op;
        this.players = new SOCPlayer[this.maxPlayers];
        this.seats = new int[this.maxPlayers];
        this.seatLocks = new SeatLockState[this.maxPlayers];
        this.boardResetVotes = new int[this.maxPlayers];
        this.spItems = new HashMap();
        for (int i = 0; i < this.maxPlayers; ++i) {
            this.players[i] = new SOCPlayer(i, this);
            this.seats[i] = 0;
            this.seatLocks[i] = SeatLockState.UNLOCKED;
        }
        this.currentPlayerNumber = -1;
        this.firstPlayerNumber = -1;
        this.currentDice = -1;
        this.currentRoll = new RollResult();
        this.playerWithLargestArmy = -1;
        this.playerWithLongestRoad = -1;
        this.boardResetVoteRequester = -1;
        this.playerWithWin = -1;
        this.gameState = 0;
        this.turnCount = 0;
        this.roundCount = 0;
        this.forcingEndTurn = false;
        this.askedSpecialBuildPhase = false;
        this.placingRobberForKnightCard = false;
        this.oldPlayerWithLargestArmy = -2;
        this.oldPlayerWithLongestRoad = new Stack();
        this.movedShipThisTurn = false;
        if (this.hasSeaBoard) {
            this.shipsPlacedThisTurn = new Vector();
        }
        this.numDevCards = this.maxPlayers > 4 ? 34 : 25;
        if (this.active) {
            this.startTime = new Date();
        }
        this.lastActionTime = System.currentTimeMillis();
    }

    public synchronized void takeMonitor() {
        while (this.inUse) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                System.err.println("EXCEPTION IN takeMonitor() -- " + e);
            }
        }
        this.inUse = true;
    }

    public synchronized void releaseMonitor() {
        this.inUse = false;
        this.notify();
    }

    public final boolean[] getFlagFieldsForSave() {
        return new boolean[]{this.placingRobberForKnightCard, this.robberyWithPirateNotRobber, this.askedSpecialBuildPhase, this.movedShipThisTurn, this.playingRoadBuildingCardForLastRoad};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFieldsForLoad(List<Integer> cards, int oldGameState, List<Integer> shipsPlacedThisTurn, boolean placingRobberForKnightCard, boolean robberyWithPirateNotRobber, boolean askedSpecialBuildPhase, boolean movedShipThisTurn, boolean playingRoadBuildingCardForLastRoad) throws IllegalArgumentException {
        if (cards == null) {
            throw new IllegalArgumentException("cards");
        }
        int L = cards.size();
        if (this.devCardDeck == null || L > this.devCardDeck.length) {
            this.devCardDeck = new int[L];
        }
        this.numDevCards = L;
        for (int i = 0; i < L; ++i) {
            this.devCardDeck[i] = cards.get(i);
        }
        this.oldGameState = oldGameState;
        if (shipsPlacedThisTurn == null) {
            if (this.shipsPlacedThisTurn != null) {
                this.shipsPlacedThisTurn.clear();
            }
        } else if (this.shipsPlacedThisTurn == null) {
            this.shipsPlacedThisTurn = new Vector<Integer>(shipsPlacedThisTurn);
        } else {
            Vector<Integer> vector = this.shipsPlacedThisTurn;
            synchronized (vector) {
                this.shipsPlacedThisTurn.clear();
                this.shipsPlacedThisTurn.addAll(shipsPlacedThisTurn);
            }
        }
        this.placingRobberForKnightCard = placingRobberForKnightCard;
        this.robberyWithPirateNotRobber = robberyWithPirateNotRobber;
        this.askedSpecialBuildPhase = askedSpecialBuildPhase;
        this.movedShipThisTurn = movedShipThisTurn;
        this.playingRoadBuildingCardForLastRoad = playingRoadBuildingCardForLastRoad;
    }

    public boolean allOriginalPlayers() {
        return this.allOriginalPlayers;
    }

    public boolean hasHumanPlayers() {
        for (int i = 0; i < this.maxPlayers; ++i) {
            if (this.isSeatVacant(i) || this.players[i].isRobot()) continue;
            return true;
        }
        return false;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public int getDurationSeconds() {
        if (this.gameState >= 1000 && this.finalDurationSeconds != 0) {
            return this.finalDurationSeconds;
        }
        return this.startTime != null ? (int)((System.currentTimeMillis() - this.startTime.getTime() + 500L) / 1000L) : 0;
    }

    public void setTimeSinceCreated(int ageSeconds) throws IllegalArgumentException {
        if (ageSeconds < 0) {
            throw new IllegalArgumentException("ageSeconds");
        }
        long t = System.currentTimeMillis() - 1000L * (long)ageSeconds;
        if (this.startTime == null) {
            this.startTime = new Date(t);
        } else {
            this.startTime.setTime(t);
        }
        this.finalDurationSeconds = this.gameState >= 1000 ? ageSeconds : 0;
    }

    public void setDurationSecondsFinished(int durSeconds) throws IllegalStateException {
        if (durSeconds <= 0) {
            throw new IllegalArgumentException("durSeconds");
        }
        if (this.gameState < 1000 && this.gameState != 0) {
            throw new IllegalStateException("Not over: state " + this.gameState);
        }
        this.finalDurationSeconds = durSeconds;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public boolean hasWarnedExpiration() {
        return this.hasWarnedExpir;
    }

    public void setWarnedExpiration() {
        this.hasWarnedExpir = true;
    }

    public void setGameEventListener(SOCGameEventListener sel) throws IllegalStateException {
        if (sel != null && this.gameEventListener != null && this.gameEventListener != sel) {
            throw new IllegalStateException("Listener already " + this.gameEventListener + ", wants " + sel);
        }
        this.gameEventListener = sel;
    }

    public boolean hasGameEventListener() {
        return this.gameEventListener != null;
    }

    public void setExpiration(long ex) {
        this.expiration = ex;
        this.hasWarnedExpir = false;
    }

    public String getOwner() {
        return this.ownerName;
    }

    public void setOwner(String gameOwnerName, String gameOwnerLocale) throws IllegalStateException {
        if (this.ownerName != null && gameOwnerName != null) {
            throw new IllegalStateException("owner already set");
        }
        this.ownerName = gameOwnerName;
        this.ownerLocale = gameOwnerLocale;
    }

    public final String getOwnerLocale() {
        return this.ownerLocale;
    }

    public void addPlayer(String plName, int pn) throws IllegalStateException, IllegalArgumentException {
        boolean wasVacant;
        if (!SOCMessage.isSingleLineAndSafe(plName)) {
            throw new IllegalArgumentException("plName");
        }
        boolean bl = wasVacant = this.seats[pn] == 0;
        if (wasVacant && 0 == this.getAvailableSeatCount()) {
            throw new IllegalStateException("Game is full");
        }
        SOCPlayer already = this.getPlayer(plName);
        if (already != null && pn != already.getPlayerNumber()) {
            throw new IllegalStateException("Already sitting in this game");
        }
        this.players[pn].setName(plName);
        this.seats[pn] = 1;
        if (this.gameState >= 5 && this.chatAllowList != null) {
            this.setMemberChatAllowed(plName, true);
        }
        if (this.gameState > 0 && this.gameState < 1000) {
            if (wasVacant && this.gameState < 10) {
                if (pn > this.lastPlayerNumber) {
                    this.setFirstPlayer(this.firstPlayerNumber);
                } else if (pn < this.firstPlayerNumber) {
                    this.setFirstPlayer(pn);
                }
            }
            this.allOriginalPlayers = false;
        }
    }

    public void removePlayer(String plName, boolean hasReplacement) throws IllegalArgumentException {
        SOCPlayer pl = this.getPlayer(plName);
        if (pl == null) {
            throw new IllegalArgumentException("plName");
        }
        pl.setName(null);
        int n = this.seats[pl.getPlayerNumber()] = hasReplacement ? 2 : 0;
        if (!hasReplacement && this.chatAllowList != null) {
            this.setMemberChatAllowed(plName, false);
        }
    }

    public boolean isSeatVacant(int pn) {
        return this.seats[pn] != 1;
    }

    public int getAvailableSeatCount() {
        int availSeats = this.isGameOptionDefined("PL") ? this.getGameOptionIntValue("PL") : this.maxPlayers;
        for (int i = 0; i < this.maxPlayers; ++i) {
            if (this.seats[i] != 1) continue;
            --availSeats;
        }
        return availSeats;
    }

    public SeatLockState getSeatLock(int pn) {
        return this.seatLocks[pn];
    }

    public SeatLockState[] getSeatLocks() {
        return this.seatLocks;
    }

    public void setSeatLock(int pn, SeatLockState sl) throws IllegalStateException, IllegalArgumentException {
        if (sl == null) {
            throw new IllegalArgumentException("sl");
        }
        if (this.isAtServer && (this.getResetVoteActive() || sl == SeatLockState.CLEAR_ON_RESET && this.gameState == 0)) {
            throw new IllegalStateException();
        }
        this.seatLocks[pn] = sl;
    }

    public void setSeatLocks(SeatLockState[] sls) throws IllegalArgumentException {
        if (sls.length != this.maxPlayers) {
            throw new IllegalArgumentException("length");
        }
        for (int pn = 0; pn < sls.length; ++pn) {
            this.seatLocks[pn] = sls[pn];
        }
    }

    public int getPlayerCount() {
        int n = 0;
        for (int pn = 0; pn < this.seats.length; ++pn) {
            if (this.seats[pn] != 1) continue;
            ++n;
        }
        return n;
    }

    public SOCPlayer getPlayer(int pn) throws ArrayIndexOutOfBoundsException {
        return this.players[pn];
    }

    public SOCPlayer getPlayer(String nn) {
        if (nn != null) {
            for (int i = 0; i < this.maxPlayers; ++i) {
                SOCPlayer pl;
                if (this.isSeatVacant(i) || (pl = this.players[i]) == null || !nn.equals(pl.getName())) continue;
                return pl;
            }
        }
        return null;
    }

    public boolean isMemberChatAllowed(String memberName) {
        return memberName != null && this.chatAllowList != null && this.chatAllowList.contains(memberName);
    }

    public void setMemberChatAllowed(String memberName, boolean allow) throws IllegalStateException {
        if (this.chatAllowList == null) {
            throw new IllegalStateException("chatAllowList");
        }
        if (memberName == null) {
            return;
        }
        if (allow) {
            this.chatAllowList.add(memberName);
        } else {
            this.chatAllowList.remove(memberName);
        }
    }

    public Set<String> getMemberChatAllowList() {
        return this.chatAllowList != null ? Collections.unmodifiableSet(this.chatAllowList) : null;
    }

    public boolean isCurrentPlayerStubbornRobot() {
        return this.currentPlayerNumber >= 0 && this.players[this.currentPlayerNumber].isStubbornRobot();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) throws IllegalStateException, IllegalArgumentException {
        if (this.gameState != 0 && this.gameState != 990) {
            throw new IllegalStateException("gameState");
        }
        if (!SOCMessage.isSingleLineAndSafe(newName)) {
            throw new IllegalArgumentException("newName");
        }
        this.name = newName;
    }

    public SOCGameOptionSet getGameOptions() {
        return this.opts;
    }

    public boolean isGameOptionDefined(String optKey) {
        return this.opts != null ? this.opts.containsKey(optKey) : false;
    }

    public boolean isGameOptionSet(String optKey) {
        return this.opts != null ? this.opts.isOptionSet(optKey) : false;
    }

    public int getGameOptionIntValue(String optKey) {
        return this.opts != null ? this.opts.getOptionIntValue(optKey) : 0;
    }

    public int getGameOptionIntValue(String optKey, int defValue, boolean onlyIfBoolSet) {
        return this.opts != null ? this.opts.getOptionIntValue(optKey, defValue, onlyIfBoolSet) : defValue;
    }

    public String getGameOptionStringValue(String optKey) {
        return this.opts != null ? this.opts.getOptionStringValue(optKey) : null;
    }

    public int getClientVersionMinRequired() {
        return this.clientVersionMinRequired;
    }

    public SOCFeatureSet getClientFeaturesRequired() {
        return this.clientFeaturesRequired;
    }

    public void setClientFeaturesRequired(SOCFeatureSet feats) {
        this.clientFeaturesRequired = feats;
    }

    public boolean canClientJoin(SOCFeatureSet cliFeats) {
        return null == this.checkClientFeatures(cliFeats, true);
    }

    public String checkClientFeatures(SOCFeatureSet cliFeats, boolean stopAtFirstFound) {
        if (this.clientFeaturesRequired == null) {
            return null;
        }
        if (cliFeats == null) {
            return this.clientFeaturesRequired.getEncodedList();
        }
        return cliFeats.findMissingAgainst(this.clientFeaturesRequired, stopAtFirstFound);
    }

    public boolean isBoardReset() {
        return this.isFromBoardReset;
    }

    public SOCBoard getBoard() {
        return this.board;
    }

    public SOCPlayer[] getPlayers() {
        return this.players;
    }

    protected void setPlayer(int pn, SOCPlayer pl) {
        if (pl == null) {
            throw new IllegalArgumentException("null pl");
        }
        this.players[pn] = pl;
    }

    public int getCurrentPlayerNumber() {
        return this.currentPlayerNumber;
    }

    public void setCurrentPlayerNumber(int pn) {
        if (pn >= -1 && pn < this.players.length) {
            this.currentPlayerNumber = pn;
            if (pn >= 0 && (this.players[pn].getTotalVP() >= this.vp_winner || this.hasScenarioWinCondition)) {
                this.checkForWinner();
            }
        }
    }

    public int getSpecialBuildingPlayerNumberAfter() {
        return this.gameState == 100 ? this.specialBuildPhase_afterPlayerNumber : -1;
    }

    public void setSpecialBuildingPlayerNumberAfter(int pn) {
        if (pn == -1) {
            return;
        }
        if (pn < -1 || pn >= this.maxPlayers) {
            throw new IllegalArgumentException("pn");
        }
        this.specialBuildPhase_afterPlayerNumber = pn;
    }

    public int getRoundCount() {
        return this.roundCount;
    }

    public void setRoundCount(int count) {
        this.roundCount = count;
    }

    public boolean hasBuiltCity() {
        return this.hasBuiltCity;
    }

    public void setHasBuiltCity(boolean hasBuilt) {
        this.hasBuiltCity = hasBuilt;
    }

    public int getCurrentDice() {
        return this.currentDice;
    }

    public void setCurrentDice(int dr) {
        this.currentDice = dr;
        if (dr == 7) {
            this.hasRolledSeven = true;
        }
    }

    public boolean hasRolledSeven() {
        return this.hasRolledSeven;
    }

    public int getGameState() {
        return this.gameState;
    }

    public void setGameState(int gs) {
        boolean cliFirstRegularTurn;
        boolean bl = cliFirstRegularTurn = gs == 15 && !this.isAtServer && this.gameState >= 5 && this.gameState <= 13;
        if (gs >= 1000 && this.finalDurationSeconds == 0) {
            this.finalDurationSeconds = this.getDurationSeconds();
        }
        this.oldGameState = gs == 15 && this.gameState == 100 ? 20 : this.gameState;
        this.gameState = gs;
        if (this.gameState == 1000 && this.playerWithWin == -1) {
            this.checkForWinner();
        }
        if (cliFirstRegularTurn) {
            this.updateAtGameFirstTurn();
        }
    }

    private void setGameStateOVER() {
        this.gameState = 1000;
        if (this.finalDurationSeconds == 0) {
            this.finalDurationSeconds = this.getDurationSeconds();
        }
    }

    public int getResetOldGameState() throws IllegalStateException {
        if (this.gameState != 1001) {
            throw new IllegalStateException("Current state is not RESET_OLD: " + this.gameState);
        }
        return this.oldGameState;
    }

    public int getOldGameState() {
        return this.oldGameState;
    }

    public final boolean isInitialPlacement() {
        return this.gameState >= 5 && this.gameState < 15;
    }

    public final boolean isInitialPlacementRoundDone(int prevState) {
        return prevState == 6 && this.gameState == 10 || prevState == 11 && this.gameState == 12 || (prevState == 11 || prevState == 13) && this.gameState == 15;
    }

    public boolean isForcingEndTurn() {
        return this.forcingEndTurn;
    }

    public final boolean isPickResourceIncludingPirateFleet(int pn) {
        return this.gameState == 56 && this.players[pn] == this.currentRoll.sc_piri_fleetAttackVictim && this.currentRoll.sc_piri_fleetAttackRsrcs != null && this.currentRoll.sc_piri_fleetAttackRsrcs.contains(6);
    }

    public int getNumDevCards() {
        return this.numDevCards;
    }

    public void setNumDevCards(int nd) {
        this.numDevCards = nd;
    }

    public int[] getDevCardDeck() {
        int[] cards = new int[this.numDevCards];
        System.arraycopy(this.devCardDeck, 0, cards, 0, cards.length);
        return cards;
    }

    public void shuffleDevCardDeck(int cardTypeToAdd) throws IllegalStateException {
        if (cardTypeToAdd != 0) {
            if (this.numDevCards >= this.devCardDeck.length) {
                throw new IllegalStateException();
            }
            this.devCardDeck[this.numDevCards] = cardTypeToAdd;
            ++this.numDevCards;
        }
        if (this.numDevCards <= 1) {
            return;
        }
        int len = this.numDevCards;
        for (int j = 0; j < 10; ++j) {
            for (int i = 1; i < len; ++i) {
                int idx = Math.abs(this.rand.nextInt() % (len - 1));
                int tmp = this.devCardDeck[idx];
                this.devCardDeck[idx] = this.devCardDeck[i];
                this.devCardDeck[i] = tmp;
            }
        }
    }

    public Set<String> getSpecialItemTypes() {
        return this.spItems.isEmpty() ? null : this.spItems.keySet();
    }

    public ArrayList<SOCSpecialItem> getSpecialItems(String typeKey) {
        ArrayList<SOCSpecialItem> ret = this.spItems.get(typeKey);
        if (ret == null || ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    public SOCSpecialItem getSpecialItem(String typeKey, int idx) {
        ArrayList<SOCSpecialItem> li = this.spItems.get(typeKey);
        if (li == null) {
            return null;
        }
        try {
            return li.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public SOCSpecialItem getSpecialItem(String typeKey, int gi, int pi, int pn) {
        SOCSpecialItem item = null;
        if (gi != -1) {
            item = this.getSpecialItem(typeKey, gi);
        }
        if (item == null && pn != -1 && pi != -1) {
            item = this.players[pn].getSpecialItem(typeKey, pi);
        }
        return item;
    }

    public SOCSpecialItem setSpecialItem(String typeKey, int idx, SOCSpecialItem itm) throws IndexOutOfBoundsException {
        int L;
        ArrayList<SOCSpecialItem> li = this.spItems.get(typeKey);
        if (li == null) {
            li = new ArrayList();
            this.spItems.put(typeKey, li);
        }
        if (idx < (L = li.size())) {
            return li.set(idx, itm);
        }
        for (int n = idx - L; n > 0; --n) {
            li.add(null);
        }
        li.add(itm);
        return null;
    }

    public SOCInventoryItem getPlacingItem() {
        return this.placingItem;
    }

    public void setPlacingItem(SOCInventoryItem item) {
        this.placingItem = item;
    }

    public SOCPlayer getPlayerWithLargestArmy() {
        if (this.playerWithLargestArmy != -1) {
            return this.players[this.playerWithLargestArmy];
        }
        return null;
    }

    public void setPlayerWithLargestArmy(SOCPlayer pl) {
        this.playerWithLargestArmy = pl == null ? -1 : pl.getPlayerNumber();
    }

    public SOCPlayer getPlayerWithLongestRoad() {
        if (this.playerWithLongestRoad != -1) {
            return this.players[this.playerWithLongestRoad];
        }
        return null;
    }

    public void setPlayerWithLongestRoad(SOCPlayer pl) {
        this.playerWithLongestRoad = pl == null ? -1 : pl.getPlayerNumber();
    }

    public SOCPlayer getPlayerWithWin() {
        if (this.playerWithWin != -1) {
            return this.players[this.playerWithWin];
        }
        return null;
    }

    public void setPlayersLandHexCoordinates() throws IllegalStateException {
        int bef = this.board.getBoardEncodingFormat();
        if (bef != 3) {
            throw new IllegalStateException("board encoding: " + bef);
        }
        int[] landHex = this.board.getLandHexCoords();
        if (landHex == null) {
            return;
        }
        for (int i = 0; i < this.maxPlayers; ++i) {
            this.players[i].getNumbers().setLandHexCoordinates(landHex);
        }
    }

    public String gameOverMessageToPlayer(SOCPlayer pl) throws IllegalStateException {
        if (this.gameState != 1000) {
            throw new IllegalStateException("This game is not over yet");
        }
        SOCPlayer wn = this.getPlayerWithWin();
        String msg = pl != null && pl == wn ? "The game is over; you are the winner!" : (wn != null ? "The game is over; " + wn.getName() + " won." : "The game is over; no one won.");
        return msg;
    }

    protected boolean advanceTurnBackwards() {
        int prevCPN = this.currentPlayerNumber--;
        this.forcingEndTurn = false;
        if (this.currentPlayerNumber < 0) {
            this.currentPlayerNumber = this.maxPlayers - 1;
        }
        while (this.isSeatVacant(this.currentPlayerNumber)) {
            --this.currentPlayerNumber;
            if (this.currentPlayerNumber < 0) {
                this.currentPlayerNumber = this.maxPlayers - 1;
            }
            if (this.currentPlayerNumber != prevCPN) continue;
            this.setGameStateOVER();
            return false;
        }
        return true;
    }

    protected boolean advanceTurn() {
        int prevCPN = this.currentPlayerNumber++;
        this.forcingEndTurn = false;
        if (this.currentPlayerNumber == this.maxPlayers) {
            this.currentPlayerNumber = 0;
        }
        while (this.isSeatVacant(this.currentPlayerNumber)) {
            ++this.currentPlayerNumber;
            if (this.currentPlayerNumber == this.maxPlayers) {
                this.currentPlayerNumber = 0;
            }
            if (this.currentPlayerNumber != prevCPN) continue;
            this.setGameStateOVER();
            return false;
        }
        return true;
    }

    private boolean advanceTurnToSpecialBuilding() {
        if (!this.askedSpecialBuildPhase) {
            return false;
        }
        boolean alreadyInPhase = this.gameState == 100;
        int prevPlayer = this.currentPlayerNumber;
        boolean anyPlayerWantsSB = false;
        do {
            if (this.advanceTurn()) continue;
            return false;
        } while (!(anyPlayerWantsSB = this.players[this.currentPlayerNumber].hasAskedSpecialBuild()) && this.currentPlayerNumber != prevPlayer);
        if (!anyPlayerWantsSB) {
            if (alreadyInPhase) {
                this.currentPlayerNumber = this.specialBuildPhase_afterPlayerNumber;
                this.gameState = 20;
            }
            return false;
        }
        if (!alreadyInPhase) {
            if (this.players[prevPlayer].hasAskedSpecialBuild() && this.gameState == 15 && !this.players[prevPlayer].hasPlayedDevCard()) {
                this.gameState = 100;
                this.currentPlayerNumber = prevPlayer;
                if (!this.advanceTurnBackwards()) {
                    return false;
                }
                this.specialBuildPhase_afterPlayerNumber = this.currentPlayerNumber;
                this.currentPlayerNumber = prevPlayer;
            } else {
                this.gameState = 100;
                this.specialBuildPhase_afterPlayerNumber = prevPlayer;
            }
        }
        return true;
    }

    public void revealFogHiddenHex(int hexCoord, int hexType, int diceNum) throws IllegalArgumentException, IllegalStateException {
        if (!this.hasSeaBoard) {
            throw new IllegalStateException();
        }
        boolean wasWaterRemovedLegals = ((SOCBoardLarge)this.board).revealFogHiddenHex(hexCoord, hexType, diceNum);
        if (hexType == 0 || ((SOCBoardLarge)this.board).isHexAtBoardMargin(hexCoord)) {
            for (SOCPlayer pl : this.players) {
                pl.updateLegalShipsAddHex(hexCoord);
                if (!wasWaterRemovedLegals) continue;
                pl.updatePotentialsAndLegalsAroundRevealedHex(hexCoord);
            }
        }
    }

    public boolean canRemovePort(SOCPlayer pl, int edge) throws NullPointerException {
        if (!this.hasSeaBoard) {
            return false;
        }
        if (pl.getPlayerNumber() != this.currentPlayerNumber) {
            return false;
        }
        if (this.gameState != 35 && this.gameState != 40 && this.gameState != 41) {
            return false;
        }
        return ((SOCBoardLarge)this.board).canRemovePort(edge);
    }

    public SOCInventoryItem removePort(SOCPlayer pl, int edge) throws UnsupportedOperationException, NullPointerException {
        if (!this.hasSeaBoard) {
            throw new UnsupportedOperationException();
        }
        int ptype = ((SOCBoardLarge)this.board).removePort(edge);
        for (int pn = 0; pn < this.maxPlayers; ++pn) {
            this.players[pn].updatePortFlagsAfterRemove(ptype, true);
        }
        if (pl == null || !this.isAtServer) {
            pl = this.players[this.currentPlayerNumber];
        }
        boolean placeNow = pl.getPortMovePotentialLocations(false) != null;
        SOCInventoryItem port = SOCInventoryItem.createForScenario(this, -ptype, true, false, false, !placeNow);
        if (this.isAtServer) {
            if (!placeNow) {
                pl.getInventory().addItem(port);
            } else {
                this.placingItem = port;
                if (this.gameState != 950) {
                    if (this.oldGameState != 100) {
                        this.oldGameState = this.gameState == 100 ? 100 : 20;
                    }
                    this.gameState = 42;
                }
            }
            if (this.gameEventListener != null) {
                this.gameEventListener.playerEvent(this, pl, SOCPlayerEvent.REMOVED_TRADE_PORT, false, new IntPair(edge, ptype));
            }
        }
        return port;
    }

    public boolean canPlacePort(SOCPlayer pl, int edge) throws NullPointerException {
        if (!this.hasSeaBoard) {
            return false;
        }
        if (pl.getPlayerNumber() != this.currentPlayerNumber) {
            return false;
        }
        if (!((SOCBoardLarge)this.board).isEdgeCoastline(edge)) {
            return false;
        }
        boolean plHasSettleOrCity = false;
        int[] portNodes = this.board.getAdjacentNodesToEdge_arr(edge);
        for (int i = 0; i <= 1; ++i) {
            if (this.board.getPortTypeFromNodeCoord(portNodes[i]) != -1) {
                return false;
            }
            SOCPlayingPiece ppiece = this.board.settlementAtNode(portNodes[i]);
            if (ppiece == null || ppiece.getPlayerNumber() != this.currentPlayerNumber) continue;
            plHasSettleOrCity = true;
        }
        return plHasSettleOrCity;
    }

    public int placePort(int edge) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (this.gameState != 42 || this.placingItem == null) {
            throw new IllegalStateException("state " + this.gameState + ", placingItem " + this.placingItem);
        }
        int ptype = -this.placingItem.itype;
        this.placePort(this.players[this.currentPlayerNumber], edge, ptype);
        this.gameState = this.oldGameState;
        return ptype;
    }

    public void placePort(SOCPlayer pl, int edge, int ptype) throws IllegalArgumentException, UnsupportedOperationException {
        if (ptype < 0 || ptype > 5) {
            throw new IllegalArgumentException("ptype: " + ptype);
        }
        if (!this.hasSeaBoard) {
            throw new UnsupportedOperationException();
        }
        if (this.gameState == 42) {
            this.placingItem = null;
        }
        if (pl != null) {
            GameAction act;
            ((SOCBoardLarge)this.board).placePort(edge, ptype);
            pl.setPortFlag(ptype, true);
            if (this.isAtServer && this.gameState != 950 && (act = this.getLastAction()) != null && act.effects != null) {
                act.effects.add(new GameAction.Effect(GameAction.EffectType.GAME_SCEN_FTRI_PORT_PLACED, new int[]{edge, ptype}));
            }
        } else {
            ((SOCBoardLarge)this.board).placePort(edge, ((SOCBoardLarge)this.board).getPortFacingFromEdge(edge, true), ptype);
        }
    }

    public boolean canPlaceShip(SOCPlayer pl, int shipEdge) {
        if (!pl.isPotentialShip(shipEdge)) {
            return false;
        }
        SOCBoardLarge bL = (SOCBoardLarge)this.board;
        int ph = bL.getPirateHex();
        return ph == 0 || !bL.isEdgeAdjacentToHex(shipEdge, ph);
    }

    public List<Integer> getShipsPlacedThisTurn() {
        return this.shipsPlacedThisTurn != null ? new ArrayList<Integer>(this.shipsPlacedThisTurn) : null;
    }

    public void addShipPlacedThisTurn(int edge) {
        if (this.shipsPlacedThisTurn == null) {
            return;
        }
        this.shipsPlacedThisTurn.add(edge);
    }

    public void putPiece(SOCPlayingPiece pp) {
        this.putPieceCommon(pp, false);
    }

    private void putPieceCommon(SOCPlayingPiece pp, boolean isTempPiece) {
        int coord = pp.getCoordinates();
        this.lastAction = null;
        if (this.hasSeaBoard && this.isAtServer && !(pp instanceof SOCVillage) && this.gameState != 950) {
            if (pp instanceof SOCRoutePiece) {
                int[] endHexes = ((SOCBoardLarge)this.board).getAdjacentHexesToEdgeEnds(coord);
                this.putPieceCommon_checkFogHexes(endHexes, false);
            } else if (pp instanceof SOCSettlement && this.isInitialPlacement()) {
                List<Integer> adjacHexes = this.board.getAdjacentHexesToNode(coord);
                int L = adjacHexes.size();
                int[] seHexes = new int[L];
                for (int i = 0; i < L; ++i) {
                    seHexes[i] = adjacHexes.get(i);
                }
                this.putPieceCommon_checkFogHexes(seHexes, true);
            }
        }
        List<GameAction.Effect> effects = null;
        if (!(pp instanceof SOCVillage)) {
            for (int i = 0; i < this.maxPlayers; ++i) {
                List<GameAction.Effect> ef = this.players[i].putPiece(pp, isTempPiece);
                if (ef == null) continue;
                effects = ef;
            }
        }
        this.board.putPiece(pp);
        if (pp instanceof SOCFortress || pp instanceof SOCVillage) {
            return;
        }
        if (!isTempPiece && this.debugFreePlacement && this.gameState <= 13) {
            this.debugFreePlacementStartPlaced = true;
        }
        int pieceType = pp.getType();
        SOCPlayer ppPlayer = pp.getPlayer();
        if (pieceType == 2) {
            if (!isTempPiece && !this.hasBuiltCity) {
                this.hasBuiltCity = true;
                if (this.isAtServer) {
                    if (effects == null) {
                        effects = new ArrayList<GameAction.Effect>();
                    }
                    effects.add(new GameAction.Effect(GameAction.EffectType.GAME_SET_HAS_BUILT_CITY_N7C));
                }
            }
            SOCSettlement se = new SOCSettlement(ppPlayer, coord, this.board);
            for (int i = 0; i < this.maxPlayers; ++i) {
                this.players[i].removePiece(se, pp, true);
            }
            this.board.removePiece(se);
        }
        if (this.gameState == 990) {
            return;
        }
        if (!(isTempPiece || pieceType != 1 || this.gameState != 10 && this.gameState != 12)) {
            int lastInitSettle;
            boolean init3 = this.isGameOptionDefined("_SC_3IP");
            int n = lastInitSettle = init3 ? 12 : 10;
            if (this.gameState == lastInitSettle || this.debugFreePlacementStartPlaced && ppPlayer.getPieces().size() == (init3 ? 5 : 3)) {
                SOCResourceSet resources = new SOCResourceSet();
                int goldHexAdjacent = 0;
                for (int hexCoord : this.board.getAdjacentHexesToNode(coord)) {
                    switch (this.board.getHexTypeFromCoord(hexCoord)) {
                        case 1: {
                            resources.add(1, 1);
                            break;
                        }
                        case 2: {
                            resources.add(1, 2);
                            break;
                        }
                        case 3: {
                            resources.add(1, 3);
                            break;
                        }
                        case 4: {
                            resources.add(1, 4);
                            break;
                        }
                        case 5: {
                            resources.add(1, 5);
                            break;
                        }
                        case 7: {
                            if (!this.hasSeaBoard) break;
                            ++goldHexAdjacent;
                        }
                    }
                }
                ppPlayer.getResources().add(resources);
                if (goldHexAdjacent > 0) {
                    ppPlayer.setNeedToPickGoldHexResources(goldHexAdjacent);
                }
            }
        }
        int placingPN = ppPlayer.getPlayerNumber();
        int longestRoadPN = this.playerWithLongestRoad;
        if (pieceType != 2) {
            if (pp instanceof SOCRoutePiece) {
                this.updateLongestRoad(placingPN);
            } else if (pieceType == 1) {
                int[] roads = new int[this.maxPlayers];
                boolean ownRoad = false;
                boolean ownShip = false;
                for (int adjEdge : this.board.getAdjacentEdgesToNode(coord)) {
                    for (SOCRoutePiece road : this.board.getRoadsAndShips()) {
                        int roadPN;
                        if (adjEdge != road.getCoordinates()) continue;
                        int n = roadPN = road.getPlayerNumber();
                        roads[n] = roads[n] + 1;
                        if (roadPN != placingPN) continue;
                        if (road.isRoadNotShip()) {
                            ownRoad = true;
                            continue;
                        }
                        ownShip = true;
                    }
                }
                for (int i = 0; i < this.maxPlayers; ++i) {
                    if (i == placingPN || roads[i] != 2) continue;
                    this.updateLongestRoad(i);
                    break;
                }
                if (ownRoad && ownShip) {
                    this.updateLongestRoad(placingPN);
                }
            }
        }
        if (isTempPiece || this.gameState == 950) {
            return;
        }
        int[] oldNewGS = null;
        if (this.gameState == 30 || this.gameState == 31 || this.gameState == 32 || this.gameState == 35 || this.gameState == 42) {
            if (effects == null) {
                effects = new ArrayList<GameAction.Effect>();
            }
            effects.add(new GameAction.Effect(GameAction.EffectType.DEDUCT_COST_FROM_PLAYER));
        } else if (this.gameState == 40 || this.gameState == 41) {
            oldNewGS = new int[]{this.gameState, 0};
            if (effects == null) {
                effects = new ArrayList<GameAction.Effect>();
            }
            effects.add(new GameAction.Effect(GameAction.EffectType.CHANGE_GAMESTATE, oldNewGS));
        }
        if (longestRoadPN != this.playerWithLongestRoad) {
            if (effects == null) {
                effects = new ArrayList<GameAction.Effect>();
            }
            effects.add(new GameAction.Effect(GameAction.EffectType.CHANGE_LONGEST_ROAD_PLAYER, new int[]{longestRoadPN, this.playerWithLongestRoad}));
        }
        this.lastActionTime = System.currentTimeMillis();
        String cannotUndoReason = null;
        GameAction prevLast = this.lastAction;
        if (prevLast != null && prevLast.actType == GameAction.ActionType.PLACEHOLDER_CURRENT_ACTION_CANNOT_UNDO) {
            cannotUndoReason = prevLast.cannotUndoReason;
        }
        this.lastAction = new GameAction(GameAction.ActionType.BUILD_PIECE, pieceType, coord, placingPN, effects);
        if (cannotUndoReason != null) {
            this.lastAction.cannotUndoReason = cannotUndoReason;
        }
        if (pp.getType() == 3 && this.gameState != 0 && this.gameState != 990) {
            this.shipsPlacedThisTurn.add(coord);
        }
        if (this.gameState > 1 && this.oldGameState != 100) {
            this.checkForWinner();
        }
        if (this.active) {
            this.advanceTurnStateAfterPutPiece();
        }
        if (oldNewGS != null) {
            oldNewGS[1] = this.gameState;
        }
    }

    private final void putPieceCommon_checkFogHexes(int[] hexCoords, boolean initialSettlement) {
        int goldHexes = 0;
        boolean fogRevealed = false;
        for (int i = 0; i < hexCoords.length; ++i) {
            int hexCoord = hexCoords[i];
            if (hexCoord == 0 || this.board.getHexTypeFromCoord(hexCoord) != 8) continue;
            fogRevealed = true;
            int encodedHexInfo = ((SOCBoardLarge)this.board).revealFogHiddenHexPrep(hexCoord);
            int hexType = encodedHexInfo >> 8;
            int diceNum = encodedHexInfo & 0xFF;
            if (diceNum == 255) {
                diceNum = 0;
            }
            this.revealFogHiddenHex(hexCoord, hexType, diceNum);
            if (this.currentPlayerNumber != -1) {
                if (hexType >= 1 && hexType <= 5) {
                    this.players[this.currentPlayerNumber].getResources().add(1, hexType);
                } else if (hexType == 7) {
                    ++goldHexes;
                }
            }
            if (this.gameEventListener != null) {
                this.gameEventListener.gameEvent(this, SOCGameEvent.SGE_FOG_HEX_REVEALED, hexCoord);
            }
            if (!initialSettlement) break;
        }
        if (fogRevealed && this.isAtServer) {
            this.setLastActionCannotUndo("event.fog.reveal.cannot_undo");
            if (this.gameEventListener != null) {
                this.gameEventListener.gameEvent(this, SOCGameEvent.SGE_CURRENT_ACTION_UNDO_NOT_ALLOWED, 0);
            }
        }
        if (goldHexes > 0 && this.currentPlayerNumber != -1) {
            this.players[this.currentPlayerNumber].setNeedToPickGoldHexResources(goldHexes);
        }
    }

    private boolean advanceTurnStateAfterPutPiece() {
        boolean needToPickFromGold;
        if (this.currentPlayerNumber < 0) {
            return true;
        }
        if (this.gameState < 15 && !this.isAtServer) {
            return true;
        }
        boolean bl = needToPickFromGold = this.hasSeaBoard && this.players[this.currentPlayerNumber].getNeedToPickGoldHexResources() != 0;
        if (this.debugFreePlacement && !needToPickFromGold) {
            return true;
        }
        switch (this.gameState) {
            case 5: {
                if (needToPickFromGold) {
                    this.oldGameState = 5;
                    this.gameState = 14;
                    break;
                }
                this.gameState = 6;
                break;
            }
            case 6: {
                if (needToPickFromGold) {
                    this.oldGameState = 6;
                    this.gameState = 14;
                    break;
                }
                int tmpCPN = this.currentPlayerNumber + 1;
                if (tmpCPN >= this.maxPlayers) {
                    tmpCPN = 0;
                }
                while (this.isSeatVacant(tmpCPN)) {
                    if (++tmpCPN >= this.maxPlayers) {
                        tmpCPN = 0;
                    }
                    if (tmpCPN != this.currentPlayerNumber) continue;
                    this.setGameStateOVER();
                    return false;
                }
                if (tmpCPN == this.firstPlayerNumber) {
                    this.gameState = 10;
                    break;
                }
                if (!this.advanceTurn()) break;
                this.gameState = 5;
                break;
            }
            case 10: {
                if (needToPickFromGold) {
                    this.oldGameState = 10;
                    this.gameState = 14;
                    break;
                }
                this.gameState = 11;
                break;
            }
            case 11: {
                if (needToPickFromGold) {
                    this.oldGameState = 11;
                    this.gameState = 14;
                    break;
                }
                int tmpCPN = this.currentPlayerNumber - 1;
                if (tmpCPN < 0) {
                    tmpCPN = this.maxPlayers - 1;
                }
                while (this.isSeatVacant(tmpCPN)) {
                    if (--tmpCPN < 0) {
                        tmpCPN = this.maxPlayers - 1;
                    }
                    if (tmpCPN != this.currentPlayerNumber) continue;
                    this.setGameStateOVER();
                    return false;
                }
                if (tmpCPN == this.lastPlayerNumber) {
                    if (!this.isGameOptionSet("_SC_3IP")) {
                        if (!this.isAtServer) break;
                        this.gameState = 15;
                        this.updateAtGameFirstTurn();
                        break;
                    }
                    this.gameState = 12;
                    break;
                }
                if (!this.advanceTurnBackwards()) break;
                this.gameState = 10;
                break;
            }
            case 12: {
                if (needToPickFromGold) {
                    this.oldGameState = 12;
                    this.gameState = 14;
                    break;
                }
                this.gameState = 13;
                break;
            }
            case 13: {
                if (needToPickFromGold) {
                    this.oldGameState = 13;
                    this.gameState = 14;
                    break;
                }
                int tmpCPN = this.currentPlayerNumber + 1;
                if (tmpCPN >= this.maxPlayers) {
                    tmpCPN = 0;
                }
                while (this.isSeatVacant(tmpCPN)) {
                    if (++tmpCPN >= this.maxPlayers) {
                        tmpCPN = 0;
                    }
                    if (tmpCPN != this.currentPlayerNumber) continue;
                    this.setGameStateOVER();
                    return false;
                }
                if (tmpCPN == this.firstPlayerNumber) {
                    if (!this.isAtServer) break;
                    this.currentPlayerNumber = this.firstPlayerNumber;
                    this.gameState = 15;
                    this.updateAtGameFirstTurn();
                    break;
                }
                if (!this.advanceTurn()) break;
                this.gameState = 12;
                break;
            }
            case 20: {
                if (!needToPickFromGold) break;
                this.oldGameState = 20;
                this.gameState = 56;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 35: {
                if (needToPickFromGold) {
                    if (this.oldGameState != 100) {
                        this.oldGameState = 20;
                    }
                    this.gameState = 56;
                    break;
                }
                if (this.oldGameState != 100) {
                    this.gameState = 20;
                    break;
                }
                this.gameState = 100;
                break;
            }
            case 40: {
                if (needToPickFromGold) {
                    this.oldGameState = 41;
                    this.gameState = 56;
                    break;
                }
                this.gameState = 41;
                break;
            }
            case 41: {
                int nextState = this.currentDice != 0 ? 20 : 15;
                if (needToPickFromGold) {
                    this.oldGameState = nextState;
                    this.gameState = 56;
                } else {
                    this.gameState = nextState;
                }
                this.playingRoadBuildingCardForLastRoad = false;
            }
        }
        return true;
    }

    public void putTempPiece(SOCPlayingPiece pp) {
        this.oldPlayerWithLongestRoad.push(new SOCOldLRStats(this));
        this.putPieceCommon(pp, true);
    }

    public SOCShip canMoveShip(int pn, int fromEdge) {
        if (this.movedShipThisTurn || !this.hasSeaBoard || this.currentPlayerNumber != pn || this.gameState != 20) {
            return null;
        }
        if (this.shipsPlacedThisTurn.contains(fromEdge)) {
            return null;
        }
        SOCBoardLarge bL = (SOCBoardLarge)this.board;
        int ph = bL.getPirateHex();
        if (ph != 0 && bL.isEdgeAdjacentToHex(fromEdge, ph)) {
            return null;
        }
        SOCPlayer pl = this.players[pn];
        SOCRoutePiece pieceAtFrom = pl.getRoadOrShip(fromEdge);
        if (pieceAtFrom == null || pieceAtFrom.isRoadNotShip()) {
            return null;
        }
        SOCShip canShip = (SOCShip)pieceAtFrom;
        if (!pl.canMoveShip(canShip)) {
            return null;
        }
        return canShip;
    }

    public SOCShip canMoveShip(int pn, int fromEdge, int toEdge) {
        if (fromEdge == toEdge) {
            return null;
        }
        SOCPlayer pl = this.players[pn];
        if (!pl.isPotentialShipMoveTo(toEdge, fromEdge)) {
            return null;
        }
        SOCBoardLarge bL = (SOCBoardLarge)this.board;
        int ph = bL.getPirateHex();
        if (ph != 0 && bL.isEdgeAdjacentToHex(toEdge, ph)) {
            return null;
        }
        return this.canMoveShip(pn, fromEdge);
    }

    public void moveShip(SOCShip sh, int toEdge) {
        int fromEdge = sh.getCoordinates();
        this.undoPutPieceCommon(sh, false, true);
        this.putPiece(new SOCShip(sh.getPlayer(), toEdge, this.board));
        if (this.gameState == 950) {
            return;
        }
        this.movedShipThisTurn = true;
        if (this.lastAction != null && this.lastAction.actType == GameAction.ActionType.BUILD_PIECE) {
            GameAction moveAction = new GameAction(this.lastAction, GameAction.ActionType.MOVE_PIECE, sh.getType(), fromEdge, toEdge);
            moveAction.cannotUndoReason = this.lastAction.cannotUndoReason;
            this.lastAction = moveAction;
        }
    }

    public boolean canUndoMoveShip(int pn, SOCShip sh) {
        boolean ok;
        GameAction moveAct = this.lastAction;
        boolean bl = ok = pn == this.currentPlayerNumber && this.gameState == 20 && moveAct != null && moveAct.actType == GameAction.ActionType.MOVE_PIECE && moveAct.cannotUndoReason == null && moveAct.param1 == 3 && moveAct.param3 == sh.getCoordinates() && this.isGameOptionSet("UB");
        if (ok && this.isGameOptionSet("UBL") && this.players[this.currentPlayerNumber].getUndosRemaining() <= 0) {
            ok = false;
        }
        return ok;
    }

    public GameAction undoMoveShip(SOCShip sh) throws NullPointerException, IllegalStateException {
        GameAction undoAct;
        int wasMovedToEdge = sh.getCoordinates();
        GameAction moveAct = this.lastAction;
        if (moveAct == null || moveAct.actType != GameAction.ActionType.MOVE_PIECE || moveAct.param1 != 3 || moveAct.param3 != wasMovedToEdge) {
            throw new IllegalStateException("lastAction");
        }
        int wasMovedFromEdge = moveAct.param2;
        int actualGS = this.gameState;
        this.gameState = 950;
        if (this.isAtServer) {
            this.undoActionSideEffects_pre(moveAct, 3);
        }
        this.shipsPlacedThisTurn.remove((Object)wasMovedToEdge);
        this.moveShip(sh, wasMovedFromEdge);
        this.movedShipThisTurn = false;
        if (this.isAtServer) {
            this.undoActionSideEffects_post(moveAct, 3);
        }
        if (this.gameState == 950) {
            this.gameState = actualGS;
        }
        if (this.isGameOptionSet("UBL")) {
            this.players[this.currentPlayerNumber].decrementUndosRemaining();
        }
        this.lastAction = undoAct = new GameAction(moveAct, GameAction.ActionType.UNDO_MOVE_PIECE, 3, wasMovedToEdge, wasMovedFromEdge);
        this.lastActionTime = System.currentTimeMillis();
        return undoAct;
    }

    public void removeShip(SOCShip sh) {
        this.undoPutPieceCommon(sh, false, false);
    }

    public boolean canUndoPutPiece(int pn, SOCPlayingPiece pp) {
        boolean ok;
        GameAction buildAct = this.lastAction;
        int ptype = pp.getType();
        boolean bl = ok = pn == this.currentPlayerNumber && (this.gameState == 20 || this.gameState == 100) && ptype >= 0 && ptype <= 3 && buildAct != null && buildAct.actType == GameAction.ActionType.BUILD_PIECE && buildAct.cannotUndoReason == null && buildAct.param1 == ptype && buildAct.param2 == pp.getCoordinates() && buildAct.param3 == pn && this.isGameOptionSet("UB");
        if (ok && this.isGameOptionSet("UBL") && this.players[this.currentPlayerNumber].getUndosRemaining() <= 0) {
            ok = false;
        }
        return ok;
    }

    public GameAction undoPutPiece(SOCPlayingPiece pp) throws NullPointerException, IllegalStateException {
        GameAction undoAct;
        GameAction buildAct = this.lastAction;
        int ptype = pp.getType();
        int coord = pp.getCoordinates();
        if (buildAct == null || buildAct.actType != GameAction.ActionType.BUILD_PIECE || buildAct.param1 != buildAct.param1 || buildAct.param2 != coord) {
            throw new IllegalStateException("lastAction");
        }
        int actualGS = this.gameState;
        this.gameState = 950;
        if (this.isAtServer) {
            this.undoActionSideEffects_pre(buildAct, ptype);
        }
        switch (ptype) {
            case 0: 
            case 1: 
            case 3: {
                this.undoPutPieceCommon(pp, false, false);
                for (SOCPlayer pl : this.players) {
                    pl.calcLongestRoad2();
                }
                break;
            }
            case 2: {
                this.undoPutPieceCommon(pp, false, false);
                break;
            }
            default: {
                this.gameState = actualGS;
                throw new IllegalStateException("ptype: " + ptype);
            }
        }
        if (this.isAtServer) {
            this.undoActionSideEffects_post(buildAct, ptype);
        }
        if (this.gameState == 950) {
            this.gameState = actualGS;
        }
        if (this.isGameOptionSet("UBL")) {
            this.players[this.currentPlayerNumber].decrementUndosRemaining();
        }
        this.lastAction = undoAct = new GameAction(buildAct, GameAction.ActionType.UNDO_BUILD_PIECE, ptype, coord, 0);
        this.lastActionTime = System.currentTimeMillis();
        return undoAct;
    }

    protected void undoPutPieceCommon(SOCPlayingPiece pp, boolean isTempPiece, boolean isMoveOrReplacement) {
        this.board.removePiece(pp);
        for (int i = 0; i < this.maxPlayers; ++i) {
            this.players[i].undoPutPiece(pp, isMoveOrReplacement);
        }
        if (pp.getType() == 2) {
            SOCSettlement se = new SOCSettlement(pp.getPlayer(), pp.getCoordinates(), this.board);
            for (int i = 0; i < this.maxPlayers; ++i) {
                this.players[i].putPiece(se, isTempPiece);
            }
            this.board.putPiece(se);
        }
    }

    public void undoPutTempPiece(SOCPlayingPiece pp) {
        this.undoPutPieceCommon(pp, true, false);
        SOCOldLRStats oldLRStats = this.oldPlayerWithLongestRoad.pop();
        oldLRStats.restoreOldStats(this);
    }

    public void undoPutInitSettlement(SOCPlayingPiece pp) {
        if (this.gameState != 6 && this.gameState != 11 && this.gameState != 13) {
            throw new IllegalStateException("Cannot remove at this game state: " + this.gameState);
        }
        if (pp.getType() != 1) {
            throw new IllegalArgumentException("Not a settlement: type " + pp.getType());
        }
        if (pp.getCoordinates() != pp.getPlayer().getLastSettlementCoord()) {
            throw new IllegalArgumentException("Not coordinate of last settlement");
        }
        this.undoPutPieceCommon(pp, false, false);
        this.gameState = this.gameState == 6 ? 5 : (this.gameState == 11 ? 10 : 12);
    }

    protected void undoActionSideEffects_pre(GameAction actToUndo, int pieceType) {
        if (actToUndo.effects == null) {
            return;
        }
        if (this.gameState != 950) {
            throw new IllegalStateException("gameState " + this.gameState + " != UNDOING_ACTION");
        }
        for (GameAction.Effect e : actToUndo.effects) {
            switch (e.eType) {
                case CLOSE_SHIP_ROUTE: {
                    ((SOCBoardLarge)this.board).setShipsClosed(false, e.params, 0);
                    break;
                }
            }
        }
    }

    public void setLastActionCannotUndo(String reasonText) {
        GameAction lastAct = this.lastAction;
        if (lastAct == null) {
            this.lastAction = lastAct = new GameAction(GameAction.ActionType.PLACEHOLDER_CURRENT_ACTION_CANNOT_UNDO);
        }
        lastAct.cannotUndoReason = reasonText;
    }

    protected void undoActionSideEffects_post(GameAction actToUndo, int pieceType) {
        if (actToUndo.effects == null) {
            return;
        }
        if (this.gameState != 950) {
            throw new IllegalStateException("gameState " + this.gameState + " != UNDOING_ACTION");
        }
        SOCPlayer currPlayer = this.players[this.currentPlayerNumber];
        int gameStateAfterUndo = 0;
        block20: for (GameAction.Effect e : actToUndo.effects) {
            switch (e.eType) {
                case DEDUCT_COST_FROM_PLAYER: {
                    SOCResourceSet cost = null;
                    if (e.params != null) {
                        cost = new SOCResourceSet(e.params);
                    } else {
                        try {
                            cost = SOCPlayingPiece.getResourcesToBuild(pieceType);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if (cost == null) continue block20;
                    currPlayer.getResources().add(cost);
                    break;
                }
                case CHANGE_GAMESTATE: {
                    gameStateAfterUndo = e.params[0];
                    break;
                }
                case CHANGE_LONGEST_ROAD_PLAYER: {
                    int longestPNBeforePut = e.params[0];
                    this.setPlayerWithLongestRoad(longestPNBeforePut >= 0 ? this.players[longestPNBeforePut] : null);
                    break;
                }
                case PLAYER_GAIN_SVP: {
                    currPlayer.setSpecialVP(e.params[0]);
                    if (e.params.length < 3) break;
                    int prevEvents = e.params[2];
                    if (prevEvents == currPlayer.getPlayerEvents()) continue block20;
                    currPlayer.setPlayerEvents(prevEvents);
                    break;
                }
                case PLAYER_GAIN_SETTLED_LANDAREA: {
                    currPlayer.setSpecialVP(e.params[0]);
                    currPlayer.setScenarioSVPLandAreas(e.params[1]);
                    break;
                }
                case GAME_SET_HAS_BUILT_CITY_N7C: {
                    this.hasBuiltCity = false;
                    break;
                }
                case PLAYER_SET_EVENT_FLAGS: {
                    int playerEvents_bitmask = currPlayer.getPlayerEvents();
                    playerEvents_bitmask = e.params[1] == 0 ? (playerEvents_bitmask |= e.params[0]) : (playerEvents_bitmask &= ~e.params[0]);
                    currPlayer.setPlayerEvents(playerEvents_bitmask);
                    break;
                }
                case PLAYER_GAIN_INVENTORY_ITEM: {
                    currPlayer.getInventory().removeItem(e.params[1] == 1 ? 2 : (e.params[2] == 1 ? 3 : 1), e.params[0]);
                    break;
                }
                case PLAYER_SCEN_CLVI_RECEIVE_CLOTH: {
                    int nCloth = e.params[0];
                    currPlayer.setCloth(currPlayer.getCloth() - nCloth);
                    int villageNodeCoord = e.params[1];
                    if (villageNodeCoord != 0) {
                        SOCVillage vi = ((SOCBoardLarge)this.board).getVillageAtNode(villageNodeCoord);
                        if (vi == null) continue block20;
                        vi.setCloth(nCloth + vi.getCloth());
                        if (e.params[2] == 0) continue block20;
                        vi.removeTradingPlayer(currPlayer);
                        break;
                    }
                    ((SOCBoardLarge)this.board).setCloth(nCloth + ((SOCBoardLarge)this.board).getCloth());
                    break;
                }
                case PLAYER_SCEN_FTRI_REACHED_SPECIAL_EDGE: {
                    int edgeCoord = e.params[0];
                    int seType = e.params[1];
                    switch (seType) {
                        case 2: {
                            currPlayer.setSpecialVP(currPlayer.getSpecialVP() - 1);
                            break;
                        }
                        case 1: {
                            int cardType = e.params[2];
                            currPlayer.getInventory().removeDevCard(1, cardType);
                            ((SOCBoardLarge)this.board).putItemInStackRandomly(cardType);
                        }
                    }
                    ((SOCBoardLarge)this.board).setSpecialEdge(edgeCoord, seType);
                    break;
                }
                case GAME_SCEN_FTRI_PORT_REMOVED: {
                    int edgeCoord = e.params[0];
                    int portType = e.params[1];
                    this.placePort(currPlayer, edgeCoord, portType);
                    break;
                }
                case GAME_SCEN_FTRI_PORT_PLACED: {
                    int edgeCoord = e.params[0];
                    this.removePort(currPlayer, edgeCoord);
                    break;
                }
            }
        }
        if (gameStateAfterUndo > 0) {
            this.setGameState(gameStateAfterUndo);
        }
    }

    public void initAtServer() {
        this.isAtServer = true;
        this.chatAllowList = Collections.synchronizedSet(new HashSet());
        this.pendingMessagesOut = new ArrayList<Object>();
        for (int i = 0; i < this.maxPlayers; ++i) {
            this.players[i].pendingMessagesOut = new ArrayList<Object>();
            if (this.isSeatVacant(i)) continue;
            this.chatAllowList.add(this.players[i].getName());
        }
        this.lastActionTime = System.currentTimeMillis();
        this.allOriginalPlayers = true;
        this.startGame_setupDevCards();
    }

    public void startGame() {
        this.initAtServer();
        this.board.makeNewBoard(this.opts);
        if (this.hasSeaBoard) {
            this.setPlayersLandHexCoordinates();
            HashSet<Integer> psList = ((SOCBoardLarge)this.board).getLegalSettlements();
            HashSet<Integer>[] las = ((SOCBoardLarge)this.board).getLandAreasLegalNodes();
            for (int i = 0; i < this.maxPlayers; ++i) {
                this.players[i].setPotentialAndLegalSettlements(psList, true, las);
            }
        }
        this.updateAtBoardLayout();
        this.gameState = 5;
        do {
            this.currentPlayerNumber = Math.abs(this.rand.nextInt() % this.maxPlayers);
        } while (this.isSeatVacant(this.currentPlayerNumber));
        this.setFirstPlayer(this.currentPlayerNumber);
    }

    private final void startGame_setupDevCards() {
        int i;
        boolean sc_piri_devcards = this.isGameOptionSet("_SC_PIRI");
        if (this.maxPlayers > 4) {
            this.devCardDeck = new int[34];
        } else if (sc_piri_devcards && this.getGameOptionIntValue("PL", 4, false) < 4) {
            this.devCardDeck = new int[20];
            this.numDevCards = this.devCardDeck.length;
        } else {
            this.devCardDeck = new int[25];
        }
        for (i = 0; i < 14; ++i) {
            this.devCardDeck[i] = 9;
        }
        for (i = 14; i < 16; ++i) {
            this.devCardDeck[i] = 1;
        }
        for (i = 16; i < 18; ++i) {
            this.devCardDeck[i] = 3;
        }
        for (i = 18; i < 20; ++i) {
            this.devCardDeck[i] = 2;
        }
        if (!sc_piri_devcards) {
            this.devCardDeck[20] = 4;
            this.devCardDeck[21] = 5;
            this.devCardDeck[22] = 6;
            this.devCardDeck[23] = 7;
            this.devCardDeck[24] = 8;
        } else if (this.devCardDeck.length > 24) {
            for (i = 20; i <= 24; ++i) {
                this.devCardDeck[i] = 9;
            }
        }
        if (this.maxPlayers > 4) {
            for (i = 25; i < 31; ++i) {
                this.devCardDeck[i] = 9;
            }
            this.devCardDeck[31] = 1;
            this.devCardDeck[32] = 3;
            this.devCardDeck[33] = 2;
        }
        this.shuffleDevCardDeck(0);
    }

    public void setFirstPlayer(int pn) {
        this.firstPlayerNumber = pn;
        if (pn < 0) {
            this.lastPlayerNumber = -1;
            return;
        }
        this.lastPlayerNumber = pn - 1;
        if (this.lastPlayerNumber < 0) {
            this.lastPlayerNumber = this.maxPlayers - 1;
        }
        while (this.isSeatVacant(this.lastPlayerNumber)) {
            --this.lastPlayerNumber;
            if (this.lastPlayerNumber < 0) {
                this.lastPlayerNumber = this.maxPlayers - 1;
            }
            if (this.lastPlayerNumber != this.firstPlayerNumber) continue;
            D.ebugPrintlnINFO("** setFirstPlayer: Should not happen: All seats blank");
            this.lastPlayerNumber = -1;
            break;
        }
    }

    public int getFirstPlayer() {
        return this.firstPlayerNumber;
    }

    public boolean canEndTurn(int pn) {
        if (this.currentPlayerNumber != pn) {
            return false;
        }
        switch (this.gameState) {
            case 20: 
            case 100: {
                return true;
            }
            case 40: 
            case 41: {
                return this.currentDice != 0;
            }
        }
        return false;
    }

    public void endTurn() {
        if (this.gameState == 40 || this.playingRoadBuildingCardForLastRoad && this.gameState == 41) {
            this.cancelBuildRoad(this.currentPlayerNumber);
        }
        if (!this.advanceTurnToSpecialBuilding()) {
            this.gameState = 15;
            if (!this.advanceTurn()) {
                return;
            }
        }
        this.updateAtTurn();
        if (this.players[this.currentPlayerNumber].getTotalVP() >= this.vp_winner || this.hasScenarioWinCondition) {
            this.checkForWinner();
        }
    }

    public void updateAtBoardLayout() {
        if (this.isGameOptionSet("UBL")) {
            int numUndo = this.getGameOptionIntValue("UBL");
            for (int pn = 0; pn < this.maxPlayers; ++pn) {
                this.players[pn].setUndosRemaining(numUndo);
            }
        }
        if (!this.isGameOptionSet("_SC_WOND")) {
            return;
        }
        int numWonders = 1 + this.maxPlayers;
        for (int i = 1; i <= numWonders; ++i) {
            this.setSpecialItem("_SC_WOND", i, SOCSpecialItem.makeKnownItem("_SC_WOND", i));
        }
    }

    private void updateAtGameFirstTurn() {
        int[] partAL;
        int bxLAEnc;
        for (int pn = 0; pn < this.maxPlayers; ++pn) {
            this.players[pn].clearPotentialSettlements();
        }
        if (this.board instanceof SOCBoardAtServer && (bxLAEnc = ((SOCBoardAtServer)this.board).getBonusExcludeLandArea() << 8) != 0) {
            for (SOCPlayer pl : this.players) {
                pl.setStartingLandAreasEncoded(pl.getStartingLandAreasEncoded() | bxLAEnc);
            }
        }
        int[] nArray = partAL = this.board instanceof SOCBoardLarge ? ((SOCBoardLarge)this.board).getAddedLayoutPart("AL") : null;
        if (partAL != null) {
            boolean emptiedAnyNodeSet = false;
            for (int i = 0; i < partAL.length; ++i) {
                boolean doEmptyNodeSet;
                int lan;
                int elem = partAL[i];
                if (elem <= 0) continue;
                if ((lan = partAL[++i]) < 0) {
                    doEmptyNodeSet = true;
                    lan = -lan;
                } else {
                    doEmptyNodeSet = false;
                }
                String nodeListKey = "N" + elem;
                int[] nodeList = ((SOCBoardLarge)this.board).getAddedLayoutPart(nodeListKey);
                if (nodeList == null) continue;
                ((SOCBoardLarge)this.board).addLegalNodes(nodeList, lan);
                for (int j = 0; j < nodeList.length; ++j) {
                    for (int pn = this.maxPlayers - 1; pn >= 0; --pn) {
                        this.players[pn].addLegalSettlement(nodeList[j], true);
                    }
                }
                if (!doEmptyNodeSet) continue;
                emptiedAnyNodeSet = true;
                ((SOCBoardLarge)this.board).setAddedLayoutPart(nodeListKey, EMPTY_INT_ARRAY);
            }
            if (emptiedAnyNodeSet && this.gameEventListener != null) {
                this.gameEventListener.gameEvent(this, SOCGameEvent.SGE_STARTPLAY_BOARD_SPECIAL_NODES_EMPTIED, null);
            }
        }
        if (this.isAtServer) {
            this.updateAtTurn();
        }
    }

    public void updateAtTurn() {
        if (this.firstPlayerNumber == -1) {
            this.setFirstPlayer(this.currentPlayerNumber);
        }
        this.currentDice = 0;
        for (int pl = 0; pl < this.maxPlayers; ++pl) {
            this.players[pl].updateAtTurn();
        }
        SOCPlayer currPlayer = this.players[this.currentPlayerNumber];
        currPlayer.updateAtOurTurn();
        this.resetVoteClear();
        this.lastActionTime = System.currentTimeMillis();
        this.lastAction = null;
        if (this.hasSeaBoard) {
            this.movedShipThisTurn = false;
            this.shipsPlacedThisTurn.clear();
        }
        this.placingItem = null;
        this.placingRobberForKnightCard = false;
        if (this.gameState == 15) {
            ++this.turnCount;
            if (this.currentPlayerNumber == this.firstPlayerNumber) {
                ++this.roundCount;
            }
            if (this.askedSpecialBuildPhase) {
                this.askedSpecialBuildPhase = false;
                for (int pl = 0; pl < this.maxPlayers; ++pl) {
                    this.players[pl].setSpecialBuilt(false);
                }
            }
        } else if (this.gameState == 100) {
            currPlayer.setSpecialBuilt(true);
        }
    }

    public SOCForceEndTurnResult forceEndTurn() throws IllegalStateException {
        if (this.gameState < 5 || this.gameState >= 1000) {
            throw new IllegalStateException("Game not active: state " + this.gameState);
        }
        this.forcingEndTurn = true;
        SOCPlayer currPlayer = this.players[this.currentPlayerNumber];
        SOCInventoryItem itemCard = null;
        if (this.gameState == 54) {
            this.chooseMovePirate(false);
        }
        switch (this.gameState) {
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                return this.forceEndTurnStartState(true);
            }
            case 10: 
            case 11: {
                return this.forceEndTurnStartState(false);
            }
            case 14: {
                return this.forceEndTurnStartState(this.oldGameState != 10 && this.oldGameState != 11);
            }
            case 15: {
                this.gameState = 20;
                return new SOCForceEndTurnResult(1);
            }
            case 20: 
            case 100: {
                return new SOCForceEndTurnResult(1);
            }
            case 30: {
                boolean rets = this.cancelBuildRoad(this.currentPlayerNumber);
                return new SOCForceEndTurnResult(5, rets ? SOCRoad.COST : null);
            }
            case 31: {
                this.cancelBuildSettlement(this.currentPlayerNumber);
                return new SOCForceEndTurnResult(5, SOCSettlement.COST);
            }
            case 32: {
                this.cancelBuildCity(this.currentPlayerNumber);
                return new SOCForceEndTurnResult(5, SOCCity.COST);
            }
            case 35: {
                boolean rets = this.cancelBuildShip(this.currentPlayerNumber);
                return new SOCForceEndTurnResult(5, rets ? SOCShip.COST : null);
            }
            case 42: {
                itemCard = this.cancelPlaceInventoryItem(true);
                if (itemCard != null) {
                    return new SOCForceEndTurnResult(9, itemCard);
                }
                return new SOCForceEndTurnResult(1);
            }
            case 33: 
            case 34: {
                boolean isFromDevCard = this.placingRobberForKnightCard;
                this.gameState = 20;
                if (isFromDevCard) {
                    this.placingRobberForKnightCard = false;
                    itemCard = new SOCDevCard(9, false);
                    currPlayer.getInventory().addItem(itemCard);
                    int newNumKnights = currPlayer.getNumKnights() - 1;
                    if (newNumKnights >= 0) {
                        currPlayer.setNumKnights(newNumKnights);
                    }
                    if (this.currentPlayerNumber == this.playerWithLargestArmy) {
                        if (newNumKnights < 3) {
                            this.playerWithLargestArmy = -1;
                        }
                        this.updateLargestArmy();
                    }
                }
                return new SOCForceEndTurnResult(6, itemCard);
            }
            case 40: 
            case 41: {
                boolean retDevCard = this.gameState == 40 || this.playingRoadBuildingCardForLastRoad && this.gameState == 41;
                this.gameState = 20;
                if (retDevCard) {
                    itemCard = new SOCDevCard(1, false);
                    currPlayer.getInventory().addItem(itemCard);
                    return new SOCForceEndTurnResult(9, itemCard);
                }
                return new SOCForceEndTurnResult(5);
            }
            case 50: {
                return this.forceEndTurnChkDiscardOrGain(this.currentPlayerNumber, true);
            }
            case 51: {
                this.gameState = 20;
                return new SOCForceEndTurnResult(9);
            }
            case 52: {
                this.gameState = 20;
                itemCard = new SOCDevCard(2, false);
                currPlayer.getInventory().addItem(itemCard);
                return new SOCForceEndTurnResult(9, itemCard);
            }
            case 53: {
                this.gameState = 20;
                itemCard = new SOCDevCard(3, false);
                currPlayer.getInventory().addItem(itemCard);
                return new SOCForceEndTurnResult(9, itemCard);
            }
            case 55: {
                this.gameState = 20;
                return new SOCForceEndTurnResult(9);
            }
            case 56: {
                return this.forceEndTurnChkDiscardOrGain(this.currentPlayerNumber, false);
            }
        }
        throw new IllegalStateException("Internal error in force, un-handled gamestate: " + this.gameState);
    }

    private SOCForceEndTurnResult forceEndTurnStartState(boolean advTurnForward) {
        int cancelResType;
        SOCResourceSet goldPicks;
        boolean updateLastPlayer;
        int cpn = this.currentPlayerNumber;
        boolean updateFirstPlayer = cpn == this.firstPlayerNumber;
        boolean bl = updateLastPlayer = cpn == this.lastPlayerNumber;
        if (this.gameState == 14) {
            goldPicks = new SOCResourceSet();
            this.oldGameState = advTurnForward ? (this.oldGameState >= 12 ? 13 : 6) : 11;
            SOCGame.discardOrGainPickRandom(this.players[cpn].getResources(), this.players[cpn].getNeedToPickGoldHexResources(), false, goldPicks, this.rand);
            this.pickGoldHexResources(cpn, goldPicks);
            if (this.gameState == 15) {
                this.gameState = 20;
            }
            cancelResType = this.gameState == 20 ? 4 : (advTurnForward ? 2 : 3);
        } else {
            goldPicks = null;
            this.gameState = advTurnForward ? (this.gameState >= 12 ? 13 : 6) : 11;
            boolean stillActive = this.advanceTurnStateAfterPutPiece();
            if (cpn == this.currentPlayerNumber && stillActive) {
                if (advTurnForward) {
                    if (this.gameState == 6) {
                        this.gameState = 10;
                        this.advanceTurnBackwards();
                        cancelResType = 3;
                    } else {
                        this.gameState = 20;
                        cancelResType = 4;
                    }
                } else if (!this.isGameOptionSet("_SC_3IP")) {
                    this.gameState = 20;
                    cancelResType = 4;
                } else {
                    this.gameState = 12;
                    this.advanceTurn();
                    cancelResType = 2;
                }
            } else {
                cancelResType = advTurnForward ? 2 : 3;
            }
        }
        if (updateFirstPlayer) {
            this.firstPlayerNumber = this.currentPlayerNumber;
        }
        if (updateLastPlayer) {
            this.lastPlayerNumber = this.currentPlayerNumber;
        }
        return new SOCForceEndTurnResult(cancelResType, updateFirstPlayer, updateLastPlayer, goldPicks);
    }

    private SOCForceEndTurnResult forceEndTurnChkDiscardOrGain(int pn, boolean isDiscard) {
        SOCResourceSet picks = new SOCResourceSet();
        SOCResourceSet hand = this.players[pn].getResources();
        if (isDiscard) {
            SOCGame.discardOrGainPickRandom(hand, this.players[pn].getCountToDiscard(), true, picks, this.rand);
            this.discard(pn, picks);
        } else {
            SOCGame.discardOrGainPickRandom(hand, this.players[pn].getNeedToPickGoldHexResources(), false, picks, this.rand);
            this.pickGoldHexResources(pn, picks);
        }
        if (this.gameState == 50 || this.gameState == 56) {
            return new SOCForceEndTurnResult(8, picks, isDiscard);
        }
        return new SOCForceEndTurnResult(7, picks, isDiscard);
    }

    public static void discardOrGainPickRandom(SOCResourceSet fromHand, int numToPick, boolean isDiscard, SOCResourceSet picks, Random rand) throws IllegalArgumentException {
        int rsrcType;
        ArrayList<Integer> tempHand = new ArrayList<Integer>();
        if (isDiscard) {
            int totalHand = fromHand.getKnownTotal();
            if (numToPick > totalHand) {
                throw new IllegalArgumentException("Has " + totalHand + ", discard " + numToPick);
            }
            for (rsrcType = 1; rsrcType <= 5; ++rsrcType) {
                for (int i = fromHand.getAmount(rsrcType); i != 0; --i) {
                    tempHand.add(rsrcType);
                }
            }
        } else {
            int lowestNum = fromHand.getAmount(1);
            for (rsrcType = 2; rsrcType <= 5; ++rsrcType) {
                int num = fromHand.getAmount(rsrcType);
                if (num >= lowestNum) continue;
                lowestNum = num;
            }
            int toAdd = numToPick;
            ArrayList<Integer> alreadyPicked = new ArrayList<Integer>();
            do {
                for (int rsrcType2 = 1; rsrcType2 <= 5; ++rsrcType2) {
                    int num = fromHand.getAmount(rsrcType2);
                    if (num == lowestNum) {
                        tempHand.add(rsrcType2);
                        --toAdd;
                        continue;
                    }
                    if (num >= lowestNum) continue;
                    alreadyPicked.add(rsrcType2);
                }
                if (toAdd <= 0) continue;
                ++lowestNum;
                if (alreadyPicked.isEmpty()) continue;
                toAdd -= alreadyPicked.size();
                tempHand.addAll(alreadyPicked);
                alreadyPicked.clear();
            } while (toAdd > 0);
        }
        while (numToPick > 0) {
            int idx = Math.abs(rand.nextInt() % tempHand.size());
            picks.add(1, (Integer)tempHand.get(idx));
            tempHand.remove(idx);
            --numToPick;
        }
    }

    public SOCResourceSet playerDiscardOrGainRandom(int pn, boolean isDiscard) throws IllegalStateException {
        if (pn == this.currentPlayerNumber) {
            throw new IllegalStateException("Cannot call for current player, use forceEndTurn instead");
        }
        if (this.gameState != 50 && this.gameState != 56) {
            throw new IllegalStateException("gameState not WAITING_FOR_DISCARDS: " + this.gameState);
        }
        if (this.players[pn].getNeedToPickGoldHexResources() == 0 && !this.players[pn].getNeedToDiscard()) {
            throw new IllegalStateException("Player " + pn + " does not need to discard or pick");
        }
        SOCForceEndTurnResult rs = this.forceEndTurnChkDiscardOrGain(pn, isDiscard);
        return rs.getResourcesGainedLost();
    }

    public boolean canRollDice(int pn) {
        if (this.currentPlayerNumber != pn) {
            return false;
        }
        return this.gameState == 15;
    }

    public RollResult rollDice() {
        int die2;
        int die1;
        boolean okToRoll7 = !(this.isGameOptionSet("N7C") && !this.hasBuiltCity || this.isGameOptionSet("N7") && this.roundCount <= this.getGameOptionIntValue("N7"));
        do {
            die1 = Math.abs(this.rand.nextInt() % 6) + 1;
            die2 = Math.abs(this.rand.nextInt() % 6) + 1;
            this.currentDice = die1 + die2;
        } while (this.currentDice == 7 && !okToRoll7);
        this.currentRoll.update(die1, die2);
        boolean sc_piri_plGainsGold = false;
        if (this.isGameOptionSet("_SC_PIRI")) {
            int numSteps = die1 < die2 ? die1 : die2;
            int newPirateHex = ((SOCBoardLarge)this.board).movePirateHexAlongPath(numSteps);
            this.oldGameState = this.gameState;
            if (newPirateHex != 0) {
                this.movePirate(this.currentPlayerNumber, newPirateHex, numSteps);
            } else {
                this.robberResult.victims = null;
            }
            List<SOCPlayer> victims = this.robberResult.victims;
            if (victims != null && victims.size() == 1) {
                this.currentRoll.sc_piri_fleetAttackVictim = victims.get(0);
                this.currentRoll.sc_piri_fleetAttackRsrcs = this.robberResult.sc_piri_loot;
                if (this.currentRoll.sc_piri_fleetAttackRsrcs.contains(6)) {
                    SOCPlayer plGold = this.currentRoll.sc_piri_fleetAttackVictim;
                    plGold.setNeedToPickGoldHexResources(1 + plGold.getNeedToPickGoldHexResources());
                    if (this.currentDice == 7) {
                        this.hasRolledSeven = true;
                        this.oldGameState = 15;
                        this.gameState = 56;
                        return this.currentRoll;
                    }
                    sc_piri_plGainsGold = true;
                }
            } else {
                this.currentRoll.sc_piri_fleetAttackVictim = null;
                this.currentRoll.sc_piri_fleetAttackRsrcs = null;
            }
        }
        if (this.currentDice == 7) {
            this.rollDice_update7gameState();
        } else {
            boolean anyGoldHex = false;
            for (int i = 0; i < this.maxPlayers; ++i) {
                if (this.isSeatVacant(i)) continue;
                SOCPlayer pl = this.players[i];
                pl.addRolledResources(this.getResourcesGainedFromRoll(pl, this.currentDice));
                if (!this.hasSeaBoard || pl.getNeedToPickGoldHexResources() <= 0) continue;
                anyGoldHex = true;
            }
            if (sc_piri_plGainsGold) {
                anyGoldHex = true;
            }
            if (this.hasSeaBoard && this.isGameOptionSet("_SC_CLVI") && ((SOCBoardAtServer)this.board).distributeClothFromRoll(this, this.currentRoll, this.currentDice)) {
                this.checkForWinner();
            }
            if (this.gameState != 1000) {
                if (!anyGoldHex) {
                    this.gameState = 20;
                } else {
                    this.oldGameState = 20;
                    this.gameState = 56;
                }
            }
        }
        return this.currentRoll;
    }

    private final void rollDice_update7gameState() {
        this.hasRolledSeven = true;
        for (int i = 0; i < this.maxPlayers; ++i) {
            if (this.players[i].getResources().getTotal() <= 7) continue;
            this.players[i].setNeedToDiscard(true);
            this.gameState = 50;
        }
        if (this.gameState != 50) {
            this.placingRobberForKnightCard = false;
            this.oldGameState = 20;
            if (this.isGameOptionSet("_SC_PIRI")) {
                this.robberyWithPirateNotRobber = false;
                this.currentRoll.sc_robPossibleVictims = this.getPossibleVictims();
                this.gameState = this.currentRoll.sc_robPossibleVictims.isEmpty() ? 20 : 51;
            } else if (this.canChooseMovePirate()) {
                this.gameState = 54;
            } else {
                this.robberyWithPirateNotRobber = false;
                this.gameState = 33;
            }
        }
    }

    public SOCResourceSet getResourcesGainedFromRoll(SOCPlayer player, int roll) {
        SOCResourceSet resources = new SOCResourceSet();
        int robberHex = this.board.getRobberHex();
        this.getResourcesGainedFromRollPieces(roll, resources, robberHex, player.getSettlements(), 1);
        this.getResourcesGainedFromRollPieces(roll, resources, robberHex, player.getCities(), 2);
        return resources;
    }

    private final void getResourcesGainedFromRollPieces(int roll, SOCResourceSet resources, int robberHex, Collection<? extends SOCPlayingPiece> pieces, int incr) {
        for (SOCPlayingPiece sOCPlayingPiece : pieces) {
            for (int hexCoord : this.board.getAdjacentHexesToNode(sOCPlayingPiece.getCoordinates())) {
                if (hexCoord == robberHex || this.board.getNumberOnHexFromCoord(hexCoord) != roll) continue;
                switch (this.board.getHexTypeFromCoord(hexCoord)) {
                    case 1: {
                        resources.add(incr, 1);
                        break;
                    }
                    case 2: {
                        resources.add(incr, 2);
                        break;
                    }
                    case 3: {
                        resources.add(incr, 3);
                        break;
                    }
                    case 4: {
                        resources.add(incr, 4);
                        break;
                    }
                    case 5: {
                        resources.add(incr, 5);
                        break;
                    }
                    case 7: {
                        if (!this.hasSeaBoard) break;
                        resources.add(incr, 6);
                    }
                }
            }
        }
    }

    public boolean canDiscard(int pn, ResourceSet rs) {
        if (this.gameState != 50) {
            return false;
        }
        SOCResourceSet resources = this.players[pn].getResources();
        if (!this.players[pn].getNeedToDiscard()) {
            return false;
        }
        if (rs.getTotal() != this.players[pn].getCountToDiscard()) {
            return false;
        }
        return resources.contains(rs);
    }

    public void discard(int pn, ResourceSet rs) {
        this.players[pn].getResources().subtract(rs);
        this.players[pn].setNeedToDiscard(false);
        this.gameState = -1;
        for (int i = 0; i < this.maxPlayers; ++i) {
            if (!this.players[i].getNeedToDiscard()) continue;
            this.gameState = 50;
            break;
        }
        if (this.gameState == -1) {
            this.oldGameState = 20;
            this.placingRobberForKnightCard = false;
            if (!this.forcingEndTurn) {
                if (this.isGameOptionSet("_SC_PIRI")) {
                    this.robberyWithPirateNotRobber = false;
                    this.currentRoll.sc_robPossibleVictims = this.getPossibleVictims();
                    this.gameState = this.currentRoll.sc_robPossibleVictims.isEmpty() ? 20 : 51;
                } else if (this.canChooseMovePirate()) {
                    this.gameState = 54;
                } else {
                    this.robberyWithPirateNotRobber = false;
                    this.gameState = 33;
                }
            } else {
                this.gameState = 20;
            }
        }
        this.lastActionTime = System.currentTimeMillis();
    }

    public boolean canPickGoldHexResources(int pn, ResourceSet rs) {
        if (this.gameState != 56 && this.gameState != 14) {
            return false;
        }
        return rs.getTotal() == this.players[pn].getNeedToPickGoldHexResources();
    }

    public int pickGoldHexResources(int pn, SOCResourceSet rs) {
        this.players[pn].getResources().add(rs);
        this.players[pn].setNeedToPickGoldHexResources(0);
        this.lastActionTime = System.currentTimeMillis();
        if (this.gameState == 14) {
            int prevGS;
            this.gameState = prevGS = this.oldGameState;
            this.advanceTurnStateAfterPutPiece();
            return prevGS;
        }
        if (this.oldGameState == 20 || this.oldGameState == 100 || this.oldGameState == 41) {
            int[] resourceStats = this.players[pn].getResourceRollStats();
            for (int rtype = 1; rtype < resourceStats.length; ++rtype) {
                int n = rtype;
                resourceStats[n] = resourceStats[n] + rs.getAmount(rtype);
            }
        }
        this.gameState = this.oldGameState;
        if (this.gameState == 15 && this.currentDice == 7) {
            this.rollDice_update7gameState();
        } else {
            for (int i = 0; i < this.maxPlayers; ++i) {
                if (this.players[i].getNeedToPickGoldHexResources() <= 0) continue;
                this.gameState = 56;
                break;
            }
        }
        return 20;
    }

    public boolean canChooseMovePirate() {
        if (!this.hasSeaBoard) {
            return false;
        }
        if (this.isGameOptionSet("_SC_WOND")) {
            return false;
        }
        return !this.isGameOptionSet("_SC_CLVI") || this.players[this.currentPlayerNumber].hasPlayerEvent(SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE);
    }

    public void chooseMovePirate(boolean pirateNotRobber) throws IllegalStateException {
        if (this.gameState != 54) {
            throw new IllegalStateException();
        }
        this.robberyWithPirateNotRobber = pirateNotRobber;
        this.gameState = pirateNotRobber ? 34 : 33;
    }

    public boolean canMoveRobber(int pn, int co) {
        if (this.gameState != 33) {
            return false;
        }
        if (this.currentPlayerNumber != pn) {
            return false;
        }
        if (this.board.getRobberHex() == co) {
            return false;
        }
        if (this.board instanceof SOCBoardLarge && ((SOCBoardLarge)this.board).isHexInLandAreas(co, ((SOCBoardLarge)this.board).getRobberExcludedLandAreas())) {
            return false;
        }
        switch (this.board.getHexTypeFromCoord(co)) {
            case 6: {
                return !this.isGameOptionSet("RD");
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
            case 7: {
                return this.board instanceof SOCBoardLarge;
            }
        }
        return false;
    }

    public SOCMoveRobberResult moveRobber(int pn, int rh) throws IllegalArgumentException {
        if (this.robberResult == null) {
            this.robberResult = new SOCMoveRobberResult();
        } else {
            this.robberResult.clear();
        }
        this.board.setRobberHex(rh, true);
        this.placingRobberForKnightCard = false;
        this.robberyWithPirateNotRobber = false;
        this.lastActionTime = System.currentTimeMillis();
        this.lastAction = null;
        List<SOCPlayer> victims = this.getPossibleVictims();
        if (victims.isEmpty()) {
            this.gameState = this.oldGameState;
        } else if (victims.size() == 1) {
            SOCPlayer victim = victims.get(0);
            int loot = this.stealFromPlayer(victim.getPlayerNumber(), false);
            this.robberResult.setLoot(loot);
        } else {
            this.gameState = 51;
        }
        this.robberResult.setVictims(victims);
        return this.robberResult;
    }

    public boolean canMovePirate(int pn, int hco) {
        if (!this.hasSeaBoard) {
            return false;
        }
        if (this.gameState != 34) {
            return false;
        }
        if (this.currentPlayerNumber != pn) {
            return false;
        }
        if (((SOCBoardLarge)this.board).getPirateHex() == hco) {
            return false;
        }
        if (this.isGameOptionSet("_SC_CLVI") && !this.players[pn].hasPlayerEvent(SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE)) {
            return false;
        }
        return this.board.isHexOnWater(hco);
    }

    public SOCMoveRobberResult movePirate(int pn, int ph) throws IllegalArgumentException {
        return this.movePirate(pn, ph, -1);
    }

    public SOCMoveRobberResult movePirate(int pn, int ph, int pirFleetStrength) throws IllegalArgumentException {
        if (this.robberResult == null) {
            this.robberResult = new SOCMoveRobberResult();
        } else {
            this.robberResult.clear();
        }
        ((SOCBoardLarge)this.board).setPirateHex(ph, true);
        this.placingRobberForKnightCard = false;
        this.robberyWithPirateNotRobber = true;
        this.lastActionTime = System.currentTimeMillis();
        this.lastAction = null;
        List<SOCPlayer> victims = this.getPossibleVictims();
        if (victims.isEmpty()) {
            this.gameState = this.oldGameState;
        } else if (victims.size() == 1) {
            SOCPlayer victim = victims.get(0);
            int vpn = victim.getPlayerNumber();
            if (this.isGameOptionSet("_SC_PIRI")) {
                this.stealFromPlayerPirateFleet(vpn, pirFleetStrength);
            } else if (!this.canChooseRobClothOrResource(vpn)) {
                int loot = this.stealFromPlayer(vpn, false);
                this.robberResult.setLoot(loot);
            } else {
                this.gameState = 55;
            }
        } else if (!this.isGameOptionSet("_SC_PIRI")) {
            this.gameState = 51;
        }
        this.robberResult.setVictims(victims);
        return this.robberResult;
    }

    public boolean canChoosePlayer(int pn) {
        if (this.gameState != 51 && this.gameState != 55) {
            return false;
        }
        if (pn == -1) {
            if (this.gameState != 51) {
                return false;
            }
            return this.isGameOptionSet("_SC_PIRI");
        }
        for (SOCPlayer pl : this.getPossibleVictims()) {
            if (pl.getPlayerNumber() != pn) continue;
            return true;
        }
        return false;
    }

    public int choosePlayerForRobbery(int pn) {
        if (pn == -1 && this.gameState == 51) {
            this.gameState = 20;
            return 0;
        }
        if (!this.canChooseRobClothOrResource(pn)) {
            return this.stealFromPlayer(pn, false);
        }
        this.gameState = 55;
        return 0;
    }

    public boolean canChooseRobClothOrResource(int pn) {
        if (!this.hasSeaBoard || !this.robberyWithPirateNotRobber) {
            return false;
        }
        SOCPlayer pl = this.players[pn];
        return pl.getCloth() > 0 && pl.getResources().getTotal() > 0;
    }

    public SOCShip canAttackPirateFortress() {
        return this.canAttackPirateFortress(null, false);
    }

    public SOCShip canAttackPirateFortress(SOCPlayer pl, boolean checkPiecesOnly) {
        if (!checkPiecesOnly && this.gameState != 20) {
            return null;
        }
        if (pl == null) {
            pl = this.players[this.currentPlayerNumber];
        } else if (!checkPiecesOnly && pl.getPlayerNumber() != this.currentPlayerNumber) {
            return null;
        }
        SOCFortress fort = pl.getFortress();
        if (fort == null) {
            return null;
        }
        int[] edges = this.board.getAdjacentEdgesToNode_arr(fort.getCoordinates());
        Vector<SOCRoutePiece> roadsAndShips = pl.getRoadsAndShips();
        for (int i = roadsAndShips.size() - 1; i >= 0; --i) {
            SOCRoutePiece rs = roadsAndShips.get(i);
            if (!(rs instanceof SOCShip)) continue;
            int rsCoord = rs.getCoordinates();
            for (int j = 0; j < edges.length; ++j) {
                if (rsCoord != edges[j]) continue;
                return (SOCShip)rs;
            }
        }
        return null;
    }

    public int[] attackPirateFortress(SOCShip adjacent) {
        int nShipsLost;
        SOCPlayer currPlayer = this.players[this.currentPlayerNumber];
        int nWarships = currPlayer.getNumWarships();
        SOCFortress fort = currPlayer.getFortress();
        int pirStrength = 1 + this.rand.nextInt(6);
        if (nWarships < pirStrength) {
            nShipsLost = 2;
        } else if (nWarships == pirStrength) {
            nShipsLost = 1;
        } else {
            nShipsLost = 0;
            int newFortStrength = fort.getStrength() - 1;
            fort.setStrength(newFortStrength);
            if (newFortStrength == 0) {
                SOCSettlement recaptSettle = new SOCSettlement(currPlayer, fort.getCoordinates(), this.board);
                this.putPiece(recaptSettle);
                if (this.gameEventListener != null) {
                    this.gameEventListener.playerEvent(this, currPlayer, SOCPlayerEvent.PIRI_FORTRESS_RECAPTURED, true, recaptSettle);
                }
                boolean stillHasFortress = false;
                for (int pn = 0; pn < this.maxPlayers; ++pn) {
                    SOCFortress pfort;
                    if (pn == this.currentPlayerNumber || this.isSeatVacant(pn) || (pfort = this.players[pn].getFortress()) == null || pfort.getStrength() <= 0) continue;
                    stillHasFortress = true;
                    break;
                }
                if (!stillHasFortress) {
                    ((SOCBoardLarge)this.board).setPirateHex(0, true);
                    if (this.gameEventListener != null) {
                        this.gameEventListener.gameEvent(this, SOCGameEvent.SGE_PIRI_LAST_FORTRESS_FLEET_DEFEATED, null);
                    }
                }
            }
        }
        int[] retval = new int[1 + nShipsLost];
        retval[0] = pirStrength;
        if (nShipsLost > 0) {
            int shipEdge;
            retval[1] = shipEdge = adjacent.getCoordinates();
            this.removeShip(adjacent);
            if (nShipsLost > 1) {
                List<Integer> adjacEdges = this.board.getAdjacentEdgesToEdge(shipEdge);
                Vector<SOCRoutePiece> roadsAndShips = currPlayer.getRoadsAndShips();
                for (int i = roadsAndShips.size() - 1; i >= 0; --i) {
                    int rsCoord;
                    SOCRoutePiece rs = (SOCRoutePiece)roadsAndShips.get(i);
                    if (!(rs instanceof SOCShip) || !adjacEdges.contains(rsCoord = rs.getCoordinates())) continue;
                    retval[2] = rsCoord;
                    this.removeShip((SOCShip)rs);
                    break;
                }
            }
        }
        if (this.gameState < 1000) {
            this.endTurn();
        }
        return retval;
    }

    public List<SOCPlayer> getPlayersOnHex(int hex, Set<SOCPlayingPiece> collectAdjacentPieces) {
        ArrayList<SOCPlayer> playerList = new ArrayList<SOCPlayer>(3);
        int[] nodes = this.board.getAdjacentNodesToHex_arr(hex);
        for (int i = 0; i < this.maxPlayers; ++i) {
            int d;
            if (this.isSeatVacant(i)) continue;
            boolean touching = false;
            for (SOCSettlement ss : this.players[i].getSettlements()) {
                int seCoord = ss.getCoordinates();
                for (d = 0; d < 6; ++d) {
                    if (seCoord != nodes[d]) continue;
                    touching = true;
                    if (collectAdjacentPieces == null) break;
                    collectAdjacentPieces.add(ss);
                    break;
                }
                if (!touching || collectAdjacentPieces != null) continue;
                break;
            }
            if (!touching || collectAdjacentPieces != null) {
                for (SOCCity ci : this.players[i].getCities()) {
                    int ciCoord = ci.getCoordinates();
                    for (d = 0; d < 6; ++d) {
                        if (ciCoord != nodes[d]) continue;
                        touching = true;
                        if (collectAdjacentPieces == null) break;
                        collectAdjacentPieces.add(ci);
                        break;
                    }
                    if (!touching || collectAdjacentPieces != null) continue;
                    break;
                }
            }
            if (!touching) continue;
            playerList.add(this.players[i]);
        }
        return playerList;
    }

    public List<SOCPlayer> getPlayersShipsOnHex(int hex) {
        ArrayList<SOCPlayer> playerList = new ArrayList<SOCPlayer>(3);
        int[] edges = ((SOCBoardLarge)this.board).getAdjacentEdgesToHex_arr(hex);
        for (int i = 0; i < this.maxPlayers; ++i) {
            if (this.isSeatVacant(i)) continue;
            Vector<SOCRoutePiece> roads_ships = this.players[i].getRoadsAndShips();
            boolean touching = false;
            block1: for (SOCRoutePiece rs : roads_ships) {
                if (rs.isRoadNotShip()) continue;
                int shCoord = rs.getCoordinates();
                for (int d = 0; d < 6; ++d) {
                    if (shCoord != edges[d]) continue;
                    touching = true;
                    continue block1;
                }
            }
            if (!touching) continue;
            playerList.add(this.players[i]);
        }
        return playerList;
    }

    public SOCFortress getFortress(int node) {
        if (!this.isGameOptionSet("_SC_PIRI")) {
            return null;
        }
        for (int i = 0; i < this.maxPlayers; ++i) {
            SOCFortress pf = this.players[i].getFortress();
            if (pf == null || node != pf.getCoordinates()) continue;
            return pf;
        }
        return null;
    }

    public GameAction getLastAction() {
        return this.lastAction;
    }

    public void setLastAction(GameAction act) {
        GameAction prev;
        if (act != null && act.cannotUndoReason == null && (prev = this.lastAction) != null && prev.actType == GameAction.ActionType.PLACEHOLDER_CURRENT_ACTION_CANNOT_UNDO) {
            act.cannotUndoReason = this.lastAction.cannotUndoReason;
        }
        this.lastAction = act;
    }

    public boolean isPlacingRobberForKnightCard() {
        return this.placingRobberForKnightCard;
    }

    public void setPlacingRobberForKnightCard(boolean value) {
        this.placingRobberForKnightCard = value;
    }

    public SOCMoveRobberResult getRobberyResult() {
        return this.robberResult;
    }

    public boolean getRobberyPirateFlag() {
        return this.robberyWithPirateNotRobber;
    }

    public List<SOCPlayer> getPossibleVictims() {
        List<Object> candidates;
        if (this.currentRoll.sc_robPossibleVictims != null && (this.gameState == 51 || this.gameState == 55)) {
            return this.currentRoll.sc_robPossibleVictims;
        }
        if (this.isGameOptionSet("_SC_PIRI")) {
            if (this.robberyWithPirateNotRobber) {
                ArrayList<SOCPlayer> candidates2;
                int ph = ((SOCBoardLarge)this.board).getPirateHex();
                if (ph != 0) {
                    HashSet<SOCPlayingPiece> adjacPieces = new HashSet<SOCPlayingPiece>();
                    List<SOCPlayer> candidates3 = this.getPlayersOnHex(ph, adjacPieces);
                    int n = candidates3.size();
                    if (n > 1) {
                        candidates3.clear();
                    } else if (n == 1) {
                        SOCPlayer victim = candidates3.get(0);
                        int victimSettleNode = victim.getAddedLegalSettlement();
                        boolean atAdded = false;
                        for (SOCPlayingPiece pp : adjacPieces) {
                            if (victimSettleNode != pp.getCoordinates()) continue;
                            atAdded = true;
                            break;
                        }
                        if (atAdded) {
                            int[] pirateAdjacNodes = this.board.getAdjacentNodesToHex_arr(ph);
                            boolean hasOtherPlayer = false;
                            block1: for (int pn = 0; pn < this.maxPlayers; ++pn) {
                                SOCPlayer pl;
                                if (this.isSeatVacant(pn) || (pl = this.players[pn]) == victim) continue;
                                int plSettleNode = pl.getAddedLegalSettlement();
                                for (int node : pirateAdjacNodes) {
                                    if (node != plSettleNode) continue;
                                    hasOtherPlayer = true;
                                    break block1;
                                }
                            }
                            if (hasOtherPlayer) {
                                candidates3.clear();
                            }
                        }
                    }
                } else {
                    candidates2 = new ArrayList<SOCPlayer>();
                }
                return candidates2;
            }
            candidates = new ArrayList();
            for (int pn = 0; pn < this.maxPlayers; ++pn) {
                if (pn == this.currentPlayerNumber || this.isSeatVacant(pn)) continue;
                candidates.add(this.players[pn]);
            }
        } else {
            candidates = this.robberyWithPirateNotRobber ? this.getPlayersShipsOnHex(((SOCBoardLarge)this.board).getPirateHex()) : this.getPlayersOnHex(this.board.getRobberHex(), null);
        }
        ArrayList<SOCPlayer> victims = new ArrayList<SOCPlayer>();
        for (SOCPlayer sOCPlayer : candidates) {
            int pn = sOCPlayer.getPlayerNumber();
            if (pn == this.currentPlayerNumber || sOCPlayer.getResources().getTotal() <= 0 && (!this.robberyWithPirateNotRobber || sOCPlayer.getCloth() <= 0)) continue;
            victims.add(sOCPlayer);
        }
        return victims;
    }

    public int stealFromPlayer(int pn, boolean choseCloth) {
        int rpick;
        SOCPlayer victim = this.players[pn];
        int nRsrcs = victim.getResources().getTotal();
        if (nRsrcs == 0 || choseCloth) {
            rpick = 7;
            victim.setCloth(victim.getCloth() - 1);
            this.players[this.currentPlayerNumber].setCloth(this.players[this.currentPlayerNumber].getCloth() + 1);
            this.checkForWinner();
        } else {
            int[] rsrcs = new int[nRsrcs];
            int cnt = 0;
            for (int i = 1; i <= 5; ++i) {
                for (int j = 0; j < victim.getResources().getAmount(i); ++j) {
                    rsrcs[cnt] = i;
                    ++cnt;
                }
            }
            int pick = Math.abs(this.rand.nextInt() % cnt);
            rpick = rsrcs[pick];
            victim.getResources().subtract(1, rpick);
            this.players[this.currentPlayerNumber].getResources().add(1, rpick);
        }
        if (this.gameState != 1000) {
            this.gameState = this.oldGameState;
        }
        return rpick;
    }

    private void stealFromPlayerPirateFleet(int pn, int pirFleetStrength) {
        if (this.robberResult == null) {
            this.robberResult = new SOCMoveRobberResult();
        }
        this.robberResult.loot = -1;
        if (this.robberResult.sc_piri_loot == null) {
            this.robberResult.sc_piri_loot = new SOCResourceSet();
        }
        SOCResourceSet loot = this.robberResult.sc_piri_loot;
        loot.clear();
        SOCPlayer victim = this.players[pn];
        int vicStrength = victim.getNumWarships();
        if (vicStrength > pirFleetStrength) {
            loot.add(1, 6);
        }
        if (vicStrength >= pirFleetStrength) {
            return;
        }
        int nRsrcs = victim.getResources().getTotal();
        int nSteal = 1 + victim.getCities().size();
        if (nSteal > nRsrcs) {
            nSteal = nRsrcs;
        }
        int[] rsrcs = new int[nRsrcs];
        int cnt = 0;
        for (int i = 1; i <= 5; ++i) {
            for (int j = victim.getResources().getAmount(i); j > 0; --j) {
                rsrcs[cnt] = i;
                ++cnt;
            }
        }
        int k = nSteal;
        while (k > 0) {
            int pick = Math.abs(this.rand.nextInt() % cnt);
            int rpick = rsrcs[pick];
            victim.getResources().subtract(1, rpick);
            loot.add(1, rpick);
            if (k > 1 && pick < cnt - 1) {
                rsrcs[pick] = rsrcs[cnt - 1];
            }
            --k;
            --cnt;
        }
    }

    public boolean hasTradeOffers() {
        for (int i = 0; i < this.maxPlayers; ++i) {
            if (this.seats[i] != 1 || this.players[i].getCurrentOffer() == null) continue;
            return true;
        }
        return false;
    }

    public void rejectTradeOffersTo(int rejectingPN) throws IllegalArgumentException {
        for (int pn = 0; pn < this.maxPlayers; ++pn) {
            SOCTradeOffer offer = this.players[pn].getCurrentOffer();
            if (offer == null) continue;
            offer.clearWaitingReplyFrom(rejectingPN);
        }
    }

    public boolean canMakeTrade(int offering, int accepting) {
        D.ebugPrintlnINFO("*** canMakeTrade ***");
        D.ebugPrintlnINFO("*** offering = " + offering);
        D.ebugPrintlnINFO("*** accepting = " + accepting);
        if (this.gameState != 20) {
            return false;
        }
        if (this.isGameOptionSet("NT")) {
            return false;
        }
        if (this.players[offering].getCurrentOffer() == null) {
            return false;
        }
        if (this.currentPlayerNumber != offering && this.currentPlayerNumber != accepting) {
            return false;
        }
        SOCPlayer offeringPlayer = this.players[offering];
        SOCPlayer acceptingPlayer = this.players[accepting];
        SOCTradeOffer offer = offeringPlayer.getCurrentOffer();
        D.ebugPrintlnINFO("*** offer = " + offer);
        if (offer.getGiveSet().getTotal() == 0 || offer.getGetSet().getTotal() == 0) {
            return false;
        }
        D.ebugPrintlnINFO("*** offeringPlayer.getResources() = " + offeringPlayer.getResources());
        if (!offeringPlayer.getResources().contains(offer.getGiveSet())) {
            return false;
        }
        D.ebugPrintlnINFO("*** acceptingPlayer.getResources() = " + acceptingPlayer.getResources());
        return acceptingPlayer.getResources().contains(offer.getGetSet());
    }

    public void makeTrade(int offering, int accepting) {
        if (this.isGameOptionSet("NT")) {
            return;
        }
        SOCTradeOffer offer = this.players[offering].getCurrentOffer();
        SOCResourceSet offeredToGive = offer.getGiveSet();
        SOCResourceSet offeredToGet = offer.getGetSet();
        this.players[offering].makeTrade(offeredToGive, offeredToGet);
        this.players[accepting].makeTrade(offeredToGet, offeredToGive);
        this.lastActionTime = System.currentTimeMillis();
        this.lastAction = null;
    }

    public boolean canUndoBankTrade(ResourceSet undo_gave, ResourceSet undo_got) {
        if (this.lastAction == null || this.lastAction.actType != GameAction.ActionType.TRADE_BANK) {
            return false;
        }
        return this.lastAction.rset2 != null && this.lastAction.rset2.equals(undo_got) && this.lastAction.rset1.equals(undo_gave);
    }

    public boolean canMakeBankTrade(ResourceSet give, ResourceSet get) {
        if (this.gameState != 20) {
            return false;
        }
        if (this.lastAction != null && this.canUndoBankTrade(get, give)) {
            return true;
        }
        SOCPlayer currPlayer = this.players[this.currentPlayerNumber];
        if (give.getTotal() < 2 || get.getTotal() == 0) {
            return false;
        }
        if (!currPlayer.getResources().contains(give)) {
            return false;
        }
        int groupCount = 0;
        int ratio = give.getTotal() / get.getTotal();
        switch (ratio) {
            case 4: {
                for (int i = 1; i <= 5; ++i) {
                    if (give.getAmount(i) % 4 == 0) {
                        groupCount += give.getAmount(i) / 4;
                        continue;
                    }
                    return false;
                }
                break;
            }
            case 3: {
                for (int i = 1; i <= 5; ++i) {
                    if (give.getAmount(i) % 3 == 0) {
                        groupCount += give.getAmount(i) / 3;
                        if (currPlayer.getPortFlag(0)) continue;
                        return false;
                    }
                    return false;
                }
                break;
            }
            case 2: {
                for (int i = 1; i <= 5; ++i) {
                    int giveAmt = give.getAmount(i);
                    if (giveAmt <= 0) continue;
                    if (giveAmt % 2 == 0 && currPlayer.getPortFlag(i)) {
                        groupCount += giveAmt / 2;
                        continue;
                    }
                    return false;
                }
                break;
            }
        }
        return groupCount == get.getTotal();
    }

    public void makeBankTrade(SOCResourceSet give, SOCResourceSet get) {
        SOCPlayer currPlayer = this.players[this.currentPlayerNumber];
        this.lastAction = this.lastAction != null && this.canUndoBankTrade(get, give) ? null : new GameAction(GameAction.ActionType.TRADE_BANK, give, get);
        currPlayer.makeBankTrade(give, get);
        this.lastActionTime = System.currentTimeMillis();
    }

    public boolean couldBuildRoad(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        return resources.getAmount(1) >= 1 && resources.getAmount(5) >= 1 && this.players[pn].getNumPieces(0) >= 1 && this.players[pn].hasPotentialRoad();
    }

    public boolean couldBuildSettlement(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        return resources.getAmount(1) >= 1 && resources.getAmount(3) >= 1 && resources.getAmount(4) >= 1 && resources.getAmount(5) >= 1 && this.players[pn].getNumPieces(1) >= 1 && this.players[pn].hasPotentialSettlement();
    }

    public boolean couldBuildCity(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        return resources.getAmount(2) >= 3 && resources.getAmount(4) >= 2 && this.players[pn].getNumPieces(2) >= 1 && this.players[pn].hasPotentialCity();
    }

    public boolean couldBuyDevCard(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        return resources.getAmount(3) >= 1 && resources.getAmount(2) >= 1 && resources.getAmount(4) >= 1 && this.numDevCards > 0;
    }

    public boolean couldBuildShip(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        return resources.getAmount(3) >= 1 && resources.getAmount(5) >= 1 && this.players[pn].getNumPieces(3) >= 1 && this.players[pn].hasPotentialShip();
    }

    public void buyRoad(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        resources.subtract(1, 1);
        resources.subtract(1, 5);
        this.oldGameState = this.gameState;
        this.gameState = 30;
    }

    public void buySettlement(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        resources.subtract(1, 1);
        resources.subtract(1, 3);
        resources.subtract(1, 4);
        resources.subtract(1, 5);
        this.oldGameState = this.gameState;
        this.gameState = 31;
    }

    public void buyCity(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        resources.subtract(3, 2);
        resources.subtract(2, 4);
        this.oldGameState = this.gameState;
        this.gameState = 32;
    }

    public void buyShip(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        resources.subtract(1, 3);
        resources.subtract(1, 5);
        this.oldGameState = this.gameState;
        this.gameState = 35;
    }

    public boolean canCancelBuildPiece(int buildType) {
        switch (buildType) {
            case 1: {
                return this.gameState == 31 || this.gameState == 6 || this.gameState == 11 || this.gameState == 13;
            }
            case 0: {
                return this.gameState == 30 || this.gameState == 40 || this.gameState == 41;
            }
            case 2: {
                return this.gameState == 32;
            }
            case 3: {
                return this.gameState == 35 || this.gameState == 40 || this.gameState == 41;
            }
        }
        return false;
    }

    public boolean doesCancelRoadBuildingReturnCard() {
        return this.gameState == 40 || this.gameState == 41 && this.playingRoadBuildingCardForLastRoad;
    }

    public boolean cancelBuildRoad(int pn) {
        SOCPlayer player = this.players[this.currentPlayerNumber];
        if (this.gameState == 40 || this.gameState == 41) {
            if (this.gameState == 40 || this.playingRoadBuildingCardForLastRoad) {
                player.getInventory().addDevCard(1, 0, 1);
                player.setPlayedDevCard(false);
                player.updateDevCardsPlayed(1, true);
                this.gameState = 41;
            }
            this.advanceTurnStateAfterPutPiece();
            return false;
        }
        player.getResources().add(SOCRoad.COST);
        this.gameState = this.oldGameState != 100 ? 20 : 100;
        return true;
    }

    public void cancelBuildSettlement(int pn) {
        this.players[pn].getResources().add(SOCSettlement.COST);
        this.gameState = this.oldGameState != 100 ? 20 : 100;
    }

    public void cancelBuildCity(int pn) {
        this.players[pn].getResources().add(SOCCity.COST);
        this.gameState = this.oldGameState != 100 ? 20 : 100;
    }

    public boolean cancelBuildShip(int pn) {
        SOCPlayer player = this.players[this.currentPlayerNumber];
        if (this.gameState == 40 || this.gameState == 41) {
            if (this.gameState == 40 || this.playingRoadBuildingCardForLastRoad) {
                player.getInventory().addDevCard(1, 0, 1);
                player.setPlayedDevCard(false);
                player.updateDevCardsPlayed(1, true);
                this.gameState = 41;
            }
            this.advanceTurnStateAfterPutPiece();
            return false;
        }
        player.getResources().add(SOCShip.COST);
        this.gameState = this.oldGameState != 100 ? 20 : 100;
        return true;
    }

    public SOCInventoryItem cancelPlaceInventoryItem(boolean forceEndTurn) {
        if (this.placingItem != null && !forceEndTurn && !this.placingItem.canCancelPlay) {
            return null;
        }
        this.gameState = this.oldGameState;
        if (this.placingItem != null) {
            SOCInventoryItem itemCard = this.placingItem;
            this.placingItem = null;
            this.players[this.currentPlayerNumber].getInventory().addItem(itemCard);
            return itemCard;
        }
        return null;
    }

    public boolean isShipWarship(SOCShip sh) {
        int node = sh.getCoordinates();
        SOCPlayer pl = sh.getPlayer();
        int numWarships = pl.getNumWarships();
        if (0 == numWarships) {
            return false;
        }
        for (SOCRoutePiece rship : pl.getRoadsAndShips()) {
            boolean isWarship;
            if (!(rship instanceof SOCShip)) continue;
            boolean bl = isWarship = numWarships > 0;
            if (node == rship.getCoordinates()) {
                return isWarship;
            }
            if (!isWarship || 0 != --numWarships) continue;
            return false;
        }
        return false;
    }

    public void setNextDevCard(int cardType) throws IllegalStateException {
        int nextCardIdx = this.numDevCards - 1;
        if (nextCardIdx < 0 || this.devCardDeck == null) {
            throw new IllegalStateException("empty");
        }
        if (cardType == this.devCardDeck[nextCardIdx]) {
            return;
        }
        for (int i = nextCardIdx - 1; i >= 0; --i) {
            if (cardType != this.devCardDeck[i]) continue;
            int otherType = this.devCardDeck[nextCardIdx];
            this.devCardDeck[nextCardIdx] = cardType;
            this.devCardDeck[i] = otherType;
            return;
        }
        this.devCardDeck[nextCardIdx] = cardType;
    }

    public int buyDevCard() {
        --this.numDevCards;
        int card = this.devCardDeck[this.numDevCards];
        if (this.currentPlayerNumber != -1) {
            SOCResourceSet resources = this.players[this.currentPlayerNumber].getResources();
            resources.subtract(1, 2);
            resources.subtract(1, 3);
            resources.subtract(1, 4);
            this.players[this.currentPlayerNumber].getInventory().addDevCard(1, 1, card);
            this.lastActionTime = System.currentTimeMillis();
            this.lastAction = null;
            this.checkForWinner();
        }
        return card;
    }

    public boolean canPlayKnight(int pn) {
        if (this.gameState != 15 && this.gameState != 20) {
            return false;
        }
        if (this.players[pn].hasPlayedDevCard()) {
            return false;
        }
        if (!this.players[pn].getInventory().hasPlayable(9)) {
            return false;
        }
        if (!this.isGameOptionSet("_SC_PIRI")) {
            return true;
        }
        Vector<SOCRoutePiece> roadsShips = this.players[pn].getRoadsAndShips();
        int numShip = 0;
        for (SOCRoutePiece rs : roadsShips) {
            if (!(rs instanceof SOCShip)) continue;
            ++numShip;
        }
        return numShip - this.players[pn].getNumWarships() > 0;
    }

    public boolean canPlayRoadBuilding(int pn) {
        if (this.gameState != 15 && this.gameState != 20) {
            return false;
        }
        SOCPlayer player = this.players[pn];
        if (player.hasPlayedDevCard()) {
            return false;
        }
        if (!player.getInventory().hasPlayable(1)) {
            return false;
        }
        return player.getNumPieces(0) >= 1 || player.getNumPieces(3) >= 1;
    }

    public boolean canPlayDiscovery(int pn) {
        if (this.gameState != 15 && this.gameState != 20) {
            return false;
        }
        if (this.players[pn].hasPlayedDevCard()) {
            return false;
        }
        return this.players[pn].getInventory().hasPlayable(2);
    }

    public boolean canPlayMonopoly(int pn) {
        if (this.gameState != 15 && this.gameState != 20) {
            return false;
        }
        if (this.players[pn].hasPlayedDevCard()) {
            return false;
        }
        return this.players[pn].getInventory().hasPlayable(3);
    }

    public int canPlayInventoryItem(int pn, int itype) {
        if (!this.players[pn].getInventory().hasPlayable(itype)) {
            return 1;
        }
        if (this.isGameOptionSet("_SC_FTRI")) {
            if (pn != this.currentPlayerNumber || this.gameState != 20 && this.gameState != 100) {
                return 3;
            }
            if (null == this.players[pn].getPortMovePotentialLocations(false)) {
                return 4;
            }
            return 0;
        }
        return 2;
    }

    public SOCInventoryItem playInventoryItem(int itype) {
        SOCInventoryItem item = this.players[this.currentPlayerNumber].getInventory().removeItem(2, itype);
        if (item == null) {
            return null;
        }
        if (this.isGameOptionSet("_SC_FTRI")) {
            this.placingItem = item;
            this.oldGameState = this.gameState == 100 ? 100 : 20;
            this.gameState = 42;
            return item;
        }
        return null;
    }

    public void playKnight() {
        boolean isWarshipConvert = this.isGameOptionSet("_SC_PIRI");
        SOCPlayer pl = this.players[this.currentPlayerNumber];
        this.lastActionTime = System.currentTimeMillis();
        this.lastAction = null;
        pl.setPlayedDevCard(true);
        pl.updateDevCardsPlayed(9, false);
        pl.getInventory().removeDevCard(0, 9);
        if (!isWarshipConvert) {
            this.saveLargestArmyState();
            pl.incrementNumKnights();
            this.updateLargestArmy();
            this.checkForWinner();
            this.placingRobberForKnightCard = true;
            this.oldGameState = this.gameState;
            if (this.canChooseMovePirate()) {
                this.gameState = 54;
            } else {
                this.robberyWithPirateNotRobber = false;
                this.gameState = 33;
            }
        } else {
            pl.setNumWarships(1 + pl.getNumWarships());
            this.lastAction = new GameAction(GameAction.ActionType.SHIP_CONVERT_TO_WARSHIP);
        }
    }

    public void playRoadBuilding() {
        this.lastActionTime = System.currentTimeMillis();
        this.lastAction = null;
        SOCPlayer player = this.players[this.currentPlayerNumber];
        player.setPlayedDevCard(true);
        player.getInventory().removeDevCard(0, 1);
        player.updateDevCardsPlayed(1, false);
        int roadShipCount = player.getNumPieces(0) + player.getNumPieces(3);
        this.playingRoadBuildingCardForLastRoad = roadShipCount <= 1;
        this.gameState = !this.playingRoadBuildingCardForLastRoad ? 40 : 41;
    }

    public void playDiscovery() {
        this.lastActionTime = System.currentTimeMillis();
        this.lastAction = null;
        SOCPlayer pl = this.players[this.currentPlayerNumber];
        pl.setPlayedDevCard(true);
        pl.getInventory().removeDevCard(0, 2);
        pl.updateDevCardsPlayed(2, false);
        this.oldGameState = this.gameState;
        this.gameState = 52;
    }

    public void playMonopoly() {
        this.lastActionTime = System.currentTimeMillis();
        this.lastAction = null;
        SOCPlayer pl = this.players[this.currentPlayerNumber];
        pl.setPlayedDevCard(true);
        pl.getInventory().removeDevCard(0, 3);
        pl.updateDevCardsPlayed(3, false);
        this.oldGameState = this.gameState;
        this.gameState = 53;
    }

    public boolean canCancelPlayCurrentDevCard() {
        boolean ok;
        switch (this.gameState) {
            case 52: 
            case 53: {
                ok = true;
                break;
            }
            case 33: 
            case 34: 
            case 54: {
                ok = this.placingRobberForKnightCard;
                break;
            }
            case 15: 
            case 20: {
                GameAction lastAct = this.lastAction;
                ok = lastAct != null && lastAct.actType == GameAction.ActionType.SHIP_CONVERT_TO_WARSHIP;
                break;
            }
            default: {
                ok = false;
            }
        }
        return ok;
    }

    public int cancelPlayCurrentDevCard() throws IllegalStateException {
        int devCardType;
        boolean isConvertToWarship = false;
        switch (this.gameState) {
            case 52: {
                devCardType = 2;
                break;
            }
            case 53: {
                devCardType = 3;
                break;
            }
            case 33: 
            case 34: 
            case 54: {
                devCardType = 9;
                break;
            }
            case 15: 
            case 20: {
                GameAction lastAct = this.lastAction;
                if (lastAct == null || lastAct.actType != GameAction.ActionType.SHIP_CONVERT_TO_WARSHIP) {
                    throw new IllegalStateException("last not warship, gameState: " + this.gameState);
                }
                isConvertToWarship = true;
                devCardType = 9;
                break;
            }
            default: {
                throw new IllegalStateException("gameState: " + this.gameState);
            }
        }
        SOCPlayer currPl = this.players[this.currentPlayerNumber];
        currPl.setPlayedDevCard(false);
        currPl.getInventory().addDevCard(1, 0, devCardType);
        currPl.updateDevCardsPlayed(devCardType, true);
        if (isConvertToWarship) {
            int n = currPl.getNumWarships();
            if (n > 0) {
                currPl.setNumWarships(n - 1);
            }
            this.lastAction = null;
        } else {
            this.gameState = this.oldGameState;
            if (devCardType == 9) {
                currPl.setNumKnights(currPl.getNumKnights() - 1);
                this.restoreLargestArmyState();
            }
        }
        return devCardType;
    }

    public boolean canDoDiscoveryAction(ResourceSet pick) {
        if (this.gameState != 52) {
            return false;
        }
        return pick.getTotal() == 2;
    }

    public boolean canDoMonopolyAction() {
        return this.gameState == 53;
    }

    public void doDiscoveryAction(SOCResourceSet pick) {
        for (int i = 1; i <= 5; ++i) {
            this.players[this.currentPlayerNumber].getResources().add(pick.getAmount(i), i);
        }
        this.gameState = this.oldGameState;
    }

    public int[] doMonopolyAction(int rtype) {
        int sum = 0;
        int[] monoResult = new int[this.maxPlayers];
        for (int i = 0; i < this.maxPlayers; ++i) {
            if (i != this.currentPlayerNumber && !this.isSeatVacant(i)) {
                int playerHas = this.players[i].getResources().getAmount(rtype);
                if (playerHas > 0) {
                    sum += playerHas;
                    this.players[i].getResources().setAmount(0, rtype);
                }
                monoResult[i] = playerHas;
                continue;
            }
            monoResult[i] = 0;
        }
        this.players[this.currentPlayerNumber].getResources().add(sum, rtype);
        this.gameState = this.oldGameState;
        return monoResult;
    }

    public void updateLargestArmy() {
        if (!this.isAtServer && this.serverVersion >= 2400) {
            return;
        }
        int size = this.playerWithLargestArmy == -1 ? 2 : this.players[this.playerWithLargestArmy].getNumKnights();
        for (int i = 0; i < this.maxPlayers; ++i) {
            if (this.players[i].getNumKnights() <= size) continue;
            this.playerWithLargestArmy = i;
        }
    }

    public void saveLargestArmyState() {
        this.oldPlayerWithLargestArmy = this.playerWithLargestArmy;
    }

    public void restoreLargestArmyState() {
        if (this.oldPlayerWithLargestArmy >= -1) {
            this.playerWithLargestArmy = this.oldPlayerWithLargestArmy;
        }
    }

    public void updateLongestRoad(int pn) {
        if (this.isGameOptionSet("_SC_0RVP")) {
            return;
        }
        int tmpPlayerWithLR = -1;
        this.players[pn].calcLongestRoad2();
        if (!this.isAtServer && this.serverVersion >= 2400) {
            return;
        }
        int longestLength = 0;
        for (int i = 0; i < this.maxPlayers; ++i) {
            int playerLength = this.players[i].getLongestRoadLength();
            if (playerLength <= longestLength) continue;
            longestLength = playerLength;
            tmpPlayerWithLR = i;
        }
        if (longestLength < 5) {
            this.playerWithLongestRoad = -1;
        } else {
            int playersWithLR = 0;
            for (int i = 0; i < this.maxPlayers; ++i) {
                if (this.players[i].getLongestRoadLength() != longestLength) continue;
                ++playersWithLR;
            }
            if (playersWithLR == 1) {
                this.playerWithLongestRoad = tmpPlayerWithLR;
            } else if (this.playerWithLongestRoad == -1 || this.players[this.playerWithLongestRoad].getLongestRoadLength() != longestLength) {
                this.playerWithLongestRoad = -1;
            }
        }
    }

    public void checkForWinner() {
        SOCSpecialItem plWond;
        if (this.gameState == 100 || this.gameState == 990) {
            return;
        }
        int pn = this.currentPlayerNumber;
        if (pn < 0 || pn >= this.maxPlayers) {
            return;
        }
        if (this.players[pn].getTotalVP() >= this.vp_winner) {
            if (this.hasScenarioWinCondition) {
                if (this.isGameOptionSet("_SC_PIRI") && null != this.players[pn].getFortress()) {
                    return;
                }
                if (this.isGameOptionSet("_SC_WOND")) {
                    SOCSpecialItem plWond2 = this.players[pn].getSpecialItem("_SC_WOND", 0);
                    if (plWond2 == null) {
                        return;
                    }
                    for (int p = 0; p < this.maxPlayers; ++p) {
                        SOCSpecialItem pWond;
                        if (p == pn || (pWond = this.players[p].getSpecialItem("_SC_WOND", 0)) == null || pWond.getLevel() < plWond2.getLevel()) continue;
                        return;
                    }
                }
            }
            this.setGameStateOVER();
            this.playerWithWin = pn;
            return;
        }
        if (!this.hasScenarioWinCondition) {
            return;
        }
        if (this.isGameOptionSet("_SC_CLVI") && this.checkForWinner_SC_CLVI()) {
            this.currentPlayerNumber = this.playerWithWin;
            if (this.gameEventListener != null) {
                this.gameEventListener.gameEvent(this, SOCGameEvent.SGE_CLVI_WIN_VILLAGE_CLOTH_EMPTY, this.players[this.playerWithWin]);
            }
        }
        if (this.isGameOptionSet("_SC_WOND") && (plWond = this.players[pn].getSpecialItem("_SC_WOND", 0)) != null && plWond.getLevel() >= 4) {
            this.setGameStateOVER();
            this.playerWithWin = pn;
        }
    }

    private final boolean checkForWinner_SC_CLVI() {
        int nv = 0;
        HashMap<Integer, SOCVillage> allv = ((SOCBoardLarge)this.board).getVillages();
        for (SOCVillage v : allv.values()) {
            if (v.getCloth() <= 0 || ++nv < 4) continue;
            return false;
        }
        this.setGameStateOVER();
        int p = -1;
        int numWithMax = 0;
        int maxVP = 0;
        for (int pn = 0; pn < this.maxPlayers; ++pn) {
            if (this.isSeatVacant(pn)) continue;
            int vp = this.players[pn].getTotalVP();
            if (vp > maxVP) {
                maxVP = vp;
                numWithMax = 1;
                p = pn;
                continue;
            }
            if (vp != maxVP) continue;
            ++numWithMax;
        }
        if (numWithMax == 1) {
            this.playerWithWin = p;
            return true;
        }
        p = -1;
        numWithMax = 0;
        int maxCl = 0;
        for (int pn = 0; pn < this.maxPlayers; ++pn) {
            if (this.isSeatVacant(pn) || this.players[pn].getTotalVP() < maxVP) continue;
            int cl = this.players[pn].getCloth();
            if (cl > maxCl) {
                maxCl = cl;
                numWithMax = 1;
                p = pn;
                continue;
            }
            if (cl != maxCl) continue;
            ++numWithMax;
        }
        if (numWithMax == 1) {
            this.playerWithWin = p;
            return true;
        }
        do {
            if (this.players[this.currentPlayerNumber].getTotalVP() != maxVP || this.players[this.currentPlayerNumber].getCloth() != maxCl) continue;
            this.playerWithWin = p;
            break;
        } while (this.advanceTurn());
        return true;
    }

    public void destroyGame() {
        for (int i = 0; i < this.maxPlayers; ++i) {
            if (this.players[i] == null) continue;
            this.players[i].destroyPlayer();
            this.players[i] = null;
        }
        Arrays.fill(this.players, null);
        this.board = null;
        this.rand = null;
        this.pendingMessagesOut = null;
    }

    public SOCGame resetAsCopy() {
        SOCGame cp = new SOCGame(this.name, this.active, this.opts != null ? new SOCGameOptionSet(this.opts, true) : null, this.knownOpts);
        cp.isFromBoardReset = true;
        this.oldGameState = this.gameState;
        this.active = false;
        this.gameState = 1001;
        cp.isAtServer = this.isAtServer;
        cp.serverVersion = this.serverVersion;
        cp.isPractice = this.isPractice;
        cp.gameEventListener = this.gameEventListener;
        cp.ownerName = this.ownerName;
        cp.ownerLocale = this.ownerLocale;
        cp.hasMultiLocales = this.hasMultiLocales;
        cp.clientVersionLowest = this.clientVersionLowest;
        cp.clientVersionHighest = this.clientVersionHighest;
        cp.clientVersionMinRequired = this.clientVersionMinRequired;
        for (int i = 0; i < this.maxPlayers; ++i) {
            boolean wasRobot = false;
            if (this.seats[i] == 1 && this.players[i] != null && this.players[i].getName() != null && !(wasRobot = this.players[i].isRobot())) {
                cp.addPlayer(this.players[i].getName(), i);
                cp.players[i].setRobotFlag(false, false);
                cp.players[i].setFaceId(this.players[i].getFaceId());
            }
            cp.seatLocks[i] = this.seatLocks[i];
            if (wasRobot) {
                cp.seats[i] = 0;
                continue;
            }
            cp.seats[i] = this.seats[i];
            if (cp.seats[i] == 1) continue;
            cp.seatLocks[i] = SeatLockState.CLEAR_ON_RESET;
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetVoteBegin(int reqPN) throws IllegalArgumentException, IllegalStateException {
        if (this.players[reqPN].hasAskedBoardReset()) {
            throw new IllegalArgumentException("Player has already asked to reset this turn");
        }
        int numVoters = 0;
        int[] nArray = this.boardResetVotes;
        synchronized (this.boardResetVotes) {
            if (this.boardResetVoteRequester != -1) {
                throw new IllegalStateException("Already voting");
            }
            this.boardResetVoteRequester = reqPN;
            for (int i = 0; i < this.maxPlayers; ++i) {
                if (i != reqPN) {
                    this.boardResetVotes[i] = 0;
                    if (this.isSeatVacant(i) || this.players[i].isRobot()) continue;
                    ++numVoters;
                    continue;
                }
                this.boardResetVotes[i] = 1;
            }
            this.boardResetVotesWaiting = numVoters;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (this.gameState >= 15) {
                this.players[reqPN].setAskedBoardReset(true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResetVoteRequester() {
        int[] nArray = this.boardResetVotes;
        synchronized (this.boardResetVotes) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.boardResetVoteRequester;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getResetVoteActive() {
        int[] nArray = this.boardResetVotes;
        synchronized (this.boardResetVotes) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.boardResetVotesWaiting > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetVoteRegister(int pn, boolean votingYes) throws IllegalArgumentException, IllegalStateException {
        int[] nArray = this.boardResetVotes;
        synchronized (this.boardResetVotes) {
            boolean vcomplete;
            if (this.boardResetVotes[pn] != 0) {
                throw new IllegalArgumentException("Already voted: " + pn);
            }
            if (this.isSeatVacant(pn) || this.players[pn].isRobot()) {
                throw new IllegalArgumentException("Seat cannot vote: " + pn);
            }
            if (0 == this.boardResetVotesWaiting || -1 == this.boardResetVoteRequester) {
                throw new IllegalStateException("Voting is not active");
            }
            this.boardResetVotes[pn] = votingYes ? 1 : 2;
            --this.boardResetVotesWaiting;
            boolean bl = vcomplete = 0 == this.boardResetVotesWaiting;
            if (vcomplete && !this.getResetVoteResult()) {
                this.boardResetVoteRequester = -1;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return vcomplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResetPlayerVote(int pn) {
        int[] nArray = this.boardResetVotes;
        synchronized (this.boardResetVotes) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.boardResetVotes[pn];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetVoteClear() {
        if (this.boardResetVoteRequester != -1) {
            this.boardResetVoteRequester = -1;
        }
        int[] nArray = this.boardResetVotes;
        synchronized (this.boardResetVotes) {
            this.boardResetVotesWaiting = 0;
            for (int i = 0; i < this.maxPlayers; ++i) {
                this.players[i].setAskedBoardReset(false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getResetVoteResult() throws IllegalStateException {
        int[] nArray = this.boardResetVotes;
        synchronized (this.boardResetVotes) {
            if (this.boardResetVotesWaiting > 0) {
                throw new IllegalStateException("Voting is still active");
            }
            boolean vyes = true;
            for (int i = 0; i < this.maxPlayers; ++i) {
                if (this.boardResetVotes[i] != 2) continue;
                vyes = false;
                break;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return vyes;
        }
    }

    public boolean canBuyOrAskSpecialBuild(int pn) {
        return pn == this.currentPlayerNumber && (this.gameState == 20 || this.gameState == 100) || this.canAskSpecialBuild(pn, false);
    }

    public boolean isSpecialBuilding() {
        return this.gameState == 100 || this.oldGameState == 100 && this.gameState < 1000;
    }

    public boolean canAskSpecialBuild(int pn, boolean throwExceptions) throws IllegalStateException, NoSuchElementException, IllegalArgumentException {
        if (this.maxPlayers <= 4) {
            if (throwExceptions) {
                throw new IllegalStateException("not 6-player");
            }
            return false;
        }
        if (pn < 0 || pn >= this.maxPlayers) {
            if (throwExceptions) {
                throw new IllegalArgumentException("pn range");
            }
            return false;
        }
        SOCPlayer pl = this.players[pn];
        if (pl == null || this.isSeatVacant(pn)) {
            if (throwExceptions) {
                throw new IllegalArgumentException("pn not valid");
            }
            return false;
        }
        if (this.isGameOptionSet("PLP") && this.getPlayerCount() < 5) {
            if (throwExceptions) {
                throw new NoSuchElementException("house rule PLP, not enough players");
            }
            return false;
        }
        if (this.gameState < 15 || this.gameState >= 1000 || pl.hasSpecialBuilt() || pl.hasAskedSpecialBuild()) {
            if (throwExceptions) {
                throw new IllegalStateException("cannot ask at this time");
            }
            return false;
        }
        if (pn == this.currentPlayerNumber && (this.gameState != 15 || this.turnCount == 1 || pl.hasPlayedDevCard())) {
            if (throwExceptions) {
                throw new IllegalStateException("current player");
            }
            return false;
        }
        return true;
    }

    public void askSpecialBuild(int pn, boolean onlyIfCan) throws IllegalStateException, NoSuchElementException, IllegalArgumentException {
        if (!onlyIfCan || this.canAskSpecialBuild(pn, true)) {
            this.players[pn].setAskedSpecialBuild(true);
            this.askedSpecialBuildPhase = true;
        }
    }

    public boolean isDebugFreePlacement() {
        return this.debugFreePlacement;
    }

    public void setDebugFreePlacement(boolean debugOn) throws IllegalStateException {
        if (this.gameState != 20 && debugOn != this.gameState < 1000 && !this.isInitialPlacement()) {
            throw new IllegalStateException("state=" + this.gameState);
        }
        if (debugOn == this.debugFreePlacement) {
            return;
        }
        if (this.debugFreePlacementStartPlaced && this.gameState < 1000 && !debugOn) {
            boolean has3rdInitPlace = this.isGameOptionSet("_SC_3IP");
            int npieceMax = has3rdInitPlace ? 6 : 4;
            int npiece = -1;
            boolean ok = true;
            for (int i = 0; i < this.maxPlayers; ++i) {
                if (this.isSeatVacant(i)) continue;
                int n = this.players[i].getPieces().size();
                if (n > npieceMax) {
                    n = npieceMax;
                } else if (n == 1 || n == 3 || n == 5) {
                    ok = false;
                }
                if (npiece == -1) {
                    npiece = n;
                    continue;
                }
                if (npiece == n) continue;
                ok = false;
            }
            if (!ok) {
                throw new IllegalStateException("initial piece count");
            }
            if (npiece == 2) {
                this.currentPlayerNumber = this.lastPlayerNumber;
                this.gameState = 10;
            } else if (npiece == 4) {
                this.currentPlayerNumber = this.firstPlayerNumber;
                if (!has3rdInitPlace) {
                    if (this.isAtServer) {
                        this.gameState = 15;
                        this.updateAtGameFirstTurn();
                    }
                } else {
                    this.gameState = 12;
                }
            } else if (npiece == 6 && this.isAtServer) {
                this.currentPlayerNumber = this.firstPlayerNumber;
                this.gameState = 15;
                this.updateAtGameFirstTurn();
            }
        }
        this.debugFreePlacement = debugOn;
        this.debugFreePlacementStartPlaced = false;
    }

    public int getTurnCount() {
        return this.turnCount;
    }

    public String toString() {
        return "SOCGame{" + this.name + "}";
    }

    static {
        EMPTY_INT_ARRAY = new int[0];
    }

    public static class RollResult {
        public int diceA;
        public int diceB;
        public int[] cloth;
        public List<SOCVillage> clothVillages;
        public List<SOCPlayer> sc_robPossibleVictims;
        public SOCPlayer sc_piri_fleetAttackVictim;
        public SOCResourceSet sc_piri_fleetAttackRsrcs;

        public void update(int dA, int dB) {
            this.diceA = dA;
            this.diceB = dB;
            this.cloth = null;
            if (this.clothVillages != null) {
                this.clothVillages.clear();
            }
            this.sc_robPossibleVictims = null;
        }
    }

    public static enum SeatLockState {
        UNLOCKED,
        LOCKED,
        CLEAR_ON_RESET;

    }
}

