/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import soc.game.SOCGameOptionSet;
import soc.game.SOCScenario;
import soc.game.SOCVersionedItem;
import soc.message.SOCMessage;

public class SOCGameOption
extends SOCVersionedItem
implements Cloneable,
Comparable<Object> {
    public static final int FLAG_DROP_IF_UNUSED = 1;
    public static final int FLAG_INTERNAL_GAME_PROPERTY = 2;
    public static final int FLAG_INACTIVE_HIDDEN = 4;
    public static final int FLAG_ACTIVATED = 8;
    public static final int FLAG_3RD_PARTY = 16;
    public static final int FLAG_DROP_IF_PARENT_UNUSED = 32;
    public static final int FLAG_SET_AT_CLIENT_ONCE = 64;
    public static final int OTYPE_MIN = 0;
    public static final int OTYPE_UNKNOWN = 0;
    public static final int OTYPE_BOOL = 1;
    public static final int OTYPE_INT = 2;
    public static final int OTYPE_INTBOOL = 3;
    public static final int OTYPE_ENUM = 4;
    public static final int OTYPE_ENUMBOOL = 5;
    public static final int OTYPE_STR = 6;
    public static final int OTYPE_STRHIDE = 7;
    public static final int OTYPE_MAX = 7;
    public static final int VERSION_FOR_LONGER_OPTNAMES = 2000;
    public static final int VERSION_FOR_UNKNOWN_WITH_DESCRIPTION = 2700;
    public static final int TEXT_OPTION_MAX_LENGTH = 255;
    private static List<SOCGameOption> refreshList;
    public final int optType;
    public final int optFlags;
    public final boolean defaultBoolValue;
    public final int defaultIntValue;
    public final int minIntValue;
    public final int maxIntValue;
    public final String[] enumVals;
    private String clientFeat;
    private boolean boolValue;
    private int intValue;
    private String strValue;
    private transient ChangeListener optCL;
    public transient boolean userChanged;

    public SOCGameOption(String key, String desc) throws IllegalArgumentException {
        this(0, key, Integer.MAX_VALUE, Integer.MAX_VALUE, false, 0, 0, 0, null, 0, desc != null && !desc.isEmpty() ? desc : key);
    }

    public SOCGameOption(String key, int minVers, int lastModVers, boolean defaultValue, int flags, String desc) throws IllegalArgumentException {
        this(1, key, minVers, lastModVers, defaultValue, 0, 0, 0, null, flags, desc);
    }

    public SOCGameOption(String key, int minVers, int lastModVers, int defaultValue, int minValue, int maxValue, int flags, String desc) throws IllegalArgumentException {
        this(2, key, minVers, lastModVers, false, defaultValue, minValue, maxValue, null, flags, desc);
    }

    public SOCGameOption(String key, int minVers, int lastModVers, boolean defaultBoolValue, int defaultIntValue, int minValue, int maxValue, int flags, String desc) throws IllegalArgumentException {
        this(3, key, minVers, lastModVers, defaultBoolValue, defaultIntValue, minValue, maxValue, null, flags, desc);
    }

    public SOCGameOption(String key, int minVers, int lastModVers, int defaultValue, String[] enumVals, int flags, String desc) throws IllegalArgumentException {
        this(4, key, minVers, lastModVers, false, defaultValue, 1, enumVals.length, enumVals, flags, desc);
    }

    public SOCGameOption(String key, int minVers, int lastModVers, boolean defaultBoolValue, int defaultIntValue, String[] enumVals, int flags, String desc) throws IllegalArgumentException {
        this(5, key, minVers, lastModVers, defaultBoolValue, defaultIntValue, 1, enumVals.length, enumVals, flags, desc);
    }

    public SOCGameOption(String key, int minVers, int lastModVers, int maxLength, boolean hideTyping, int flags, String desc) throws IllegalArgumentException {
        this(hideTyping ? 7 : 6, key, minVers, lastModVers, false, 0, 0, maxLength, null, flags, desc);
        if (maxLength < 1 || maxLength > 255) {
            throw new IllegalArgumentException("maxLength");
        }
    }

    protected SOCGameOption(int otype, String key, int minVers, int lastModVers, boolean defaultBoolValue, int defaultIntValue, int minValue, int maxValue, String[] enumVals, int flags, String desc) throws IllegalArgumentException {
        super(key, minVers, lastModVers, otype != 0, desc);
        int L = key.length();
        if (L > 3 && !key.startsWith("DEBUG")) {
            if (L > 8) {
                throw new IllegalArgumentException("Key length > 8: " + key);
            }
            if (minVers < 2000) {
                throw new IllegalArgumentException("Key length > 3 needs minVers 2000 or newer: " + key);
            }
        }
        if (minVers < 2000 && key.contains("_")) {
            throw new IllegalArgumentException("Key with '_' needs minVers 2000 or newer: " + key);
        }
        if ((flags & 0xC) == 12) {
            throw new IllegalArgumentException("Can't set both FLAG_ACTIVATED and FLAG_INACTIVE_HIDDEN");
        }
        this.optType = otype;
        this.defaultBoolValue = defaultBoolValue;
        this.defaultIntValue = defaultIntValue;
        this.minIntValue = minValue;
        this.maxIntValue = maxValue;
        this.optFlags = flags;
        this.enumVals = enumVals;
        if (enumVals != null) {
            for (int i = enumVals.length - 1; i >= 0; --i) {
                if (SOCMessage.isSingleLineAndSafe(enumVals[i])) continue;
                throw new IllegalArgumentException("enumVal fails isSingleLineAndSafe");
            }
        }
        this.boolValue = defaultBoolValue;
        this.intValue = defaultIntValue;
        this.strValue = null;
        if (this.intValue < this.minIntValue || this.intValue > this.maxIntValue) {
            throw new IllegalArgumentException("defaultIntValue");
        }
        if (key.startsWith("_SC_")) {
            this.clientFeat = "sc";
        }
    }

    public SOCGameOption(SOCGameOption opt, String newDesc) {
        this(opt.optType, opt.key, opt.minVersion, opt.lastModVersion, opt.defaultBoolValue, opt.defaultIntValue, opt.minIntValue, opt.maxIntValue, opt.enumVals, opt.optFlags, newDesc != null ? newDesc : opt.desc);
        this.copyMiscFields(opt);
    }

    SOCGameOption(int newFlags, SOCGameOption opt) throws IllegalArgumentException {
        this(opt.optType, opt.key, opt.minVersion, opt.lastModVersion, opt.defaultBoolValue, opt.defaultIntValue, opt.minIntValue, opt.maxIntValue, opt.enumVals, newFlags, opt.desc);
        this.copyMiscFields(opt);
    }

    protected SOCGameOption(SOCGameOption enumOpt, String[] keptEnumVals) throws NullPointerException {
        this(enumOpt.optType, enumOpt.key, enumOpt.minVersion, enumOpt.lastModVersion, enumOpt.defaultBoolValue, enumOpt.defaultIntValue <= keptEnumVals.length ? enumOpt.defaultIntValue : keptEnumVals.length, 1, keptEnumVals.length, keptEnumVals, enumOpt.optFlags, enumOpt.desc);
        this.copyMiscFields(enumOpt);
    }

    protected SOCGameOption(SOCGameOption intOpt, int maxIntValue) {
        this(intOpt.optType, intOpt.key, intOpt.minVersion, intOpt.lastModVersion, intOpt.defaultBoolValue, intOpt.defaultIntValue <= maxIntValue ? intOpt.defaultIntValue : maxIntValue, intOpt.minIntValue, maxIntValue, null, intOpt.optFlags, intOpt.desc);
        this.copyMiscFields(intOpt);
    }

    public static SOCGameOption copyDefaults(SOCGameOption opt) {
        if (opt == null) {
            return null;
        }
        boolean currBool = opt.boolValue;
        int currInt = opt.intValue;
        if (currBool != opt.defaultBoolValue || currInt != opt.defaultIntValue) {
            SOCGameOption updatedOpt = new SOCGameOption(opt.optType, opt.key, opt.minVersion, opt.lastModVersion, currBool, currInt, opt.minIntValue, opt.maxIntValue, opt.enumVals, opt.optFlags, opt.desc);
            updatedOpt.copyMiscFields(opt);
            opt = updatedOpt;
        }
        return opt;
    }

    private void copyMiscFields(SOCGameOption copyFrom) {
        this.clientFeat = copyFrom.clientFeat;
    }

    public boolean hasValue() {
        return this.boolValue || this.intValue != 0 || this.strValue != null && !this.strValue.isEmpty();
    }

    public boolean isSet() {
        boolean isSet = false;
        switch (this.optType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                isSet = true;
                if (this.intValue != this.defaultIntValue || this.optType != 2 && this.optType != 4 && this.boolValue) break;
                isSet = false;
                break;
            }
            case 1: {
                isSet = this.boolValue;
                break;
            }
            case 6: 
            case 7: {
                isSet = this.strValue != null && !this.strValue.isEmpty();
            }
        }
        return isSet;
    }

    public boolean getBoolValue() {
        return this.boolValue;
    }

    public void setBoolValue(boolean v) {
        this.boolValue = v;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public void setIntValue(int v) {
        this.intValue = v < this.minIntValue ? this.minIntValue : (v > this.maxIntValue ? this.maxIntValue : v);
    }

    public String getStringValue() {
        if (this.strValue != null) {
            return this.strValue;
        }
        return "";
    }

    public void setStringValue(String v) throws IllegalArgumentException {
        if (v != null) {
            int vl = v.length();
            if (vl == 0) {
                v = null;
            } else {
                if (vl > this.maxIntValue) {
                    v = v.substring(0, this.maxIntValue);
                }
                if (!SOCMessage.isSingleLineAndSafe(v)) {
                    throw new IllegalArgumentException("new value fails isSingleLineAndSafe");
                }
            }
        }
        this.strValue = v;
    }

    public String getClientFeature() {
        return this.clientFeat;
    }

    public void setClientFeature(String clientFeat) {
        this.clientFeat = clientFeat;
    }

    @Override
    public int getMinVersion(Map<String, ? extends SOCVersionedItem> opts) {
        SOCScenario sc;
        switch (this.optType) {
            case 1: 
            case 3: 
            case 5: {
                if (this.boolValue) break;
                return -1;
            }
            case 2: 
            case 4: {
                if (!this.hasFlag(1) || this.intValue != this.defaultIntValue) break;
                return -1;
            }
            case 6: 
            case 7: {
                if (!this.hasFlag(1) || this.strValue != null && this.strValue.length() != 0) break;
                return -1;
            }
        }
        int minVers = this.minVersion;
        if (this.key.equals("SC") && (sc = SOCScenario.getScenario(this.getStringValue())) != null && sc.minVersion > minVers) {
            minVers = sc.minVersion;
        }
        if (this.key.equals("PL")) {
            SOCVersionedItem plb;
            if (opts != null && this.intValue <= 4 && (plb = opts.get("PLB")) instanceof SOCGameOption && ((SOCGameOption)plb).boolValue) {
                return 1113;
            }
            if (this.intValue > 4) {
                return 1108;
            }
        }
        return minVers;
    }

    public static final int getMaxEnumValueForVersion(String optKey, int vers) {
        return Integer.MAX_VALUE;
    }

    public static final int getMaxIntValueForVersion(String optKey, int vers) {
        if (optKey.equals("PL")) {
            if (vers >= 1108) {
                return Integer.MAX_VALUE;
            }
            return 4;
        }
        return Integer.MAX_VALUE;
    }

    public static String packKnownOptionsToString(SOCGameOptionSet knownOpts, boolean hideEmptyStringOpts, boolean hideLongNameOpts) {
        return SOCGameOption.packOptionsToString(knownOpts.getAll(), hideEmptyStringOpts, false, hideLongNameOpts ? -3 : -2);
    }

    public static String packOptionsToString(Map<String, SOCGameOption> omap, boolean hideEmptyStringOpts, boolean sortByKey) {
        return SOCGameOption.packOptionsToString(omap, hideEmptyStringOpts, sortByKey, -2);
    }

    public static String packOptionsToString(Map<String, SOCGameOption> omap, boolean hideEmptyStringOpts, boolean sortByKey, int cliVers) {
        if (omap == null || omap.size() == 0) {
            return "-";
        }
        boolean hasOptPLB = cliVers > -2 && omap.containsKey("PLB") && omap.get((Object)"PLB").boolValue;
        StringBuilder sb = new StringBuilder();
        boolean hadAny = false;
        Collection<SOCGameOption> opts = omap.values();
        if (sortByKey) {
            ArrayList<SOCGameOption> olist = new ArrayList<SOCGameOption>(opts);
            Collections.sort(olist, new Comparator<SOCGameOption>(){

                @Override
                public int compare(SOCGameOption a, SOCGameOption b) {
                    return a.key.compareTo(b.key);
                }
            });
            opts = olist;
        }
        for (SOCGameOption op : opts) {
            if (op.optType == 0 && cliVers < 2700 || hideEmptyStringOpts && (op.optType == 6 || op.optType == 7) && op.getStringValue().length() == 0 || cliVers == -3 && (op.key.length() > 3 || op.key.contains("_")) || op.hasFlag(4)) continue;
            if (hadAny) {
                sb.append(',');
            } else {
                hadAny = true;
            }
            sb.append(op.key);
            sb.append('=');
            boolean wroteValueAlready = false;
            if (cliVers > -2 && hasOptPLB && op.key.equals("PL") && cliVers < 1113 && op.intValue < 5) {
                sb.append('5');
                wroteValueAlready = true;
            }
            if (wroteValueAlready) continue;
            op.packValue(sb);
        }
        return sb.toString();
    }

    public void packValue(StringBuilder sb) {
        switch (this.optType) {
            case 1: {
                sb.append(this.boolValue ? (char)'t' : 'f');
                break;
            }
            case 2: 
            case 4: {
                sb.append(this.intValue);
                break;
            }
            case 3: 
            case 5: {
                sb.append(this.boolValue ? (char)'t' : 'f');
                sb.append(this.intValue);
                break;
            }
            case 6: 
            case 7: {
                if (this.strValue == null) break;
                sb.append(this.strValue);
                break;
            }
            default: {
                sb.append('?');
            }
        }
    }

    public static Map<String, SOCGameOption> parseOptionsToMap(String ostr, SOCGameOptionSet knownOpts) {
        if (ostr == null || ostr.equals("-")) {
            return null;
        }
        HashMap<String, SOCGameOption> ohash = new HashMap<String, SOCGameOption>();
        StringTokenizer st = new StringTokenizer(ostr, ",");
        while (st.hasMoreTokens()) {
            String nvpair = st.nextToken();
            SOCGameOption copyOpt = SOCGameOption.parseOptionNameValue(nvpair, false, knownOpts);
            if (copyOpt == null) {
                return null;
            }
            ohash.put(copyOpt.key, copyOpt);
        }
        return ohash;
    }

    public static SOCGameOptionSet parseOptionsToSet(String ostr, SOCGameOptionSet knownOpts) {
        Map<String, SOCGameOption> omap = SOCGameOption.parseOptionsToMap(ostr, knownOpts);
        if (omap == null) {
            return null;
        }
        return new SOCGameOptionSet(omap);
    }

    public static SOCGameOption parseOptionNameValue(String nvpair, boolean forceNameUpcase, SOCGameOptionSet knownOpts) throws IllegalArgumentException {
        int i = nvpair.indexOf(61);
        if (i < 1) {
            return null;
        }
        String optkey = nvpair.substring(0, i);
        String optval = nvpair.substring(i + 1);
        return SOCGameOption.parseOptionNameValue(optkey, optval, forceNameUpcase, knownOpts);
    }

    public static SOCGameOption parseOptionNameValue(String optkey, String optval, boolean forceNameUpcase, SOCGameOptionSet knownOpts) throws IllegalArgumentException {
        SOCGameOption copyOpt;
        SOCGameOption knownOpt;
        if (forceNameUpcase) {
            optkey = optkey.toUpperCase();
        }
        if ((knownOpt = knownOpts.get(optkey)) == null) {
            copyOpt = new SOCGameOption(optkey, null);
        } else {
            if (optval.length() == 0 && knownOpt.optType != 6 && knownOpt.optType != 7) {
                return null;
            }
            try {
                copyOpt = (SOCGameOption)knownOpt.clone();
            }
            catch (CloneNotSupportedException ce) {
                return null;
            }
            switch (copyOpt.optType) {
                case 1: {
                    if (optval.length() == 1) {
                        boolean bv;
                        switch (optval.charAt(0)) {
                            case 'T': 
                            case 'Y': 
                            case 't': 
                            case 'y': {
                                bv = true;
                                break;
                            }
                            case 'F': 
                            case 'N': 
                            case 'f': 
                            case 'n': {
                                bv = false;
                                break;
                            }
                            default: {
                                return null;
                            }
                        }
                        copyOpt.setBoolValue(bv);
                        break;
                    }
                    return null;
                }
                case 2: 
                case 4: {
                    try {
                        copyOpt.setIntValue(Integer.parseInt(optval));
                        break;
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                case 3: 
                case 5: {
                    try {
                        boolean bv;
                        switch (optval.charAt(0)) {
                            case 'T': 
                            case 'Y': 
                            case 't': 
                            case 'y': {
                                bv = true;
                                break;
                            }
                            case 'F': 
                            case 'N': 
                            case 'f': 
                            case 'n': {
                                bv = false;
                                break;
                            }
                            default: {
                                return null;
                            }
                        }
                        copyOpt.setBoolValue(bv);
                        copyOpt.setIntValue(Integer.parseInt(optval.substring(1)));
                        break;
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                case 6: 
                case 7: {
                    copyOpt.setStringValue(optval);
                    break;
                }
                default: {
                    copyOpt = new SOCGameOption(optkey, copyOpt.getDesc());
                }
            }
        }
        return copyOpt;
    }

    public static SOCGameOption trimEnumForVersion(SOCGameOption opt, int vers) {
        int ev = SOCGameOption.getMaxEnumValueForVersion(opt.key, vers);
        if (ev == Integer.MAX_VALUE || ev == opt.enumVals.length) {
            return opt;
        }
        String[] evkeep = new String[ev];
        System.arraycopy(opt.enumVals, 0, evkeep, 0, ev);
        return new SOCGameOption(opt, evkeep);
    }

    public static String getGroupParentKey(String optKey) throws IllegalArgumentException {
        int i;
        if (optKey == null || optKey.isEmpty()) {
            throw new IllegalArgumentException("optKey");
        }
        int kL = optKey.length();
        if (kL < 3) {
            return null;
        }
        String groupKey = kL == 3 ? optKey.substring(0, 2) : ((i = optKey.indexOf(95)) >= 1 ? optKey.substring(0, i) : null);
        return groupKey;
    }

    public static String optionTypeName(int optType) {
        String otname;
        switch (optType) {
            case 0: {
                otname = "UNKNOWN";
                break;
            }
            case 1: {
                otname = "BOOL";
                break;
            }
            case 2: {
                otname = "INT";
                break;
            }
            case 3: {
                otname = "INTBOOL";
                break;
            }
            case 4: {
                otname = "ENUM";
                break;
            }
            case 5: {
                otname = "ENUMBOOL";
                break;
            }
            case 6: {
                otname = "STR";
                break;
            }
            case 7: {
                otname = "STRHIDE";
                break;
            }
            default: {
                otname = null;
            }
        }
        return otname;
    }

    public static final List<SOCGameOption> getAndClearRefreshList() {
        List<SOCGameOption> refr = refreshList;
        refreshList = null;
        if (refr != null && refr.size() == 0) {
            refr = null;
        }
        return refr;
    }

    public void refreshDisplay() {
        if (refreshList == null) {
            refreshList = new ArrayList<SOCGameOption>();
        } else if (refreshList.contains(this)) {
            return;
        }
        refreshList.add(this);
    }

    public final boolean hasFlag(int flagMask) {
        return (this.optFlags & flagMask) == flagMask;
    }

    public void addChangeListener(ChangeListener cl) {
        this.optCL = cl;
    }

    public boolean hasChangeListener() {
        return this.optCL != null;
    }

    public ChangeListener getChangeListener() {
        return this.optCL;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.key);
        sb.append('=');
        this.packValue(sb);
        return sb.toString();
    }

    public final StringBuilder getPackedValue() {
        StringBuilder sb = new StringBuilder();
        this.packValue(sb);
        return sb;
    }

    @Override
    public int compareTo(Object other) {
        if (other instanceof SOCGameOption) {
            int rankB;
            SOCGameOption oopt = (SOCGameOption)other;
            if (this.key.equals(oopt.key)) {
                return 0;
            }
            int rankA = this.getSortRank();
            if (rankA < (rankB = oopt.getSortRank())) {
                return -1;
            }
            if (rankA > rankB) {
                return 1;
            }
            return this.desc.toLowerCase().compareTo(oopt.desc.toLowerCase());
        }
        return this.hashCode() - other.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SOCGameOption)) {
            return false;
        }
        SOCGameOption oopt = (SOCGameOption)other;
        return this.optType == oopt.optType && this.optFlags == oopt.optFlags && this.key.equals(oopt.key) && this.boolValue == oopt.boolValue && this.intValue == oopt.intValue && (this.strValue == null ? oopt.strValue == null : this.strValue.equals(oopt.strValue));
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static interface ChangeListener {
        public void valueChanged(SOCGameOption var1, Object var2, Object var3, SOCGameOptionSet var4, SOCGameOptionSet var5);
    }
}

