/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import soc.game.SOCGameOption;
import soc.game.SOCScenario;
import soc.game.SOCVersionedItem;
import soc.util.SOCFeatureSet;

public class SOCGameOptionSet
implements Iterable<SOCGameOption> {
    public static final String K_SC_SANY = "_SC_SANY";
    public static final String K_SC_SEAC = "_SC_SEAC";
    public static final String K_SC_FOG = "_SC_FOG";
    public static final String K_SC_0RVP = "_SC_0RVP";
    public static final String K_SC_3IP = "_SC_3IP";
    public static final String K_SC_CLVI = "_SC_CLVI";
    public static final String K_SC_PIRI = "_SC_PIRI";
    public static final String K_SC_FTRI = "_SC_FTRI";
    public static final String K_SC_WOND = "_SC_WOND";
    public static final String K_PLAY_FO = "PLAY_FO";
    public static final String K_PLAY_VPO = "PLAY_VPO";
    public static final String K__EXT_BOT = "_EXT_BOT";
    public static final String K__EXT_CLI = "_EXT_CLI";
    public static final String K__EXT_GAM = "_EXT_GAM";
    private final Map<String, SOCGameOption> options;

    public SOCGameOptionSet() {
        this.options = new HashMap<String, SOCGameOption>();
    }

    public SOCGameOptionSet(SOCGameOptionSet opts, boolean deepCopy) throws NullPointerException {
        if (deepCopy) {
            this.options = new HashMap<String, SOCGameOption>();
            try {
                for (SOCGameOption opt : opts.options.values()) {
                    this.options.put(opt.key, (SOCGameOption)opt.clone());
                }
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("clone failed");
            }
        } else {
            this.options = new HashMap<String, SOCGameOption>(opts.options);
        }
    }

    public SOCGameOptionSet(Map<String, SOCGameOption> opts) {
        this.options = opts != null ? new HashMap<String, SOCGameOption>(opts) : new HashMap();
    }

    public static SOCGameOptionSet getAllKnownOptions() {
        SOCGameOptionSet opts = new SOCGameOptionSet();
        SOCGameOption optPL = new SOCGameOption("PL", -1, 1108, 4, 2, 6, 0, "Maximum # players");
        opts.add(optPL);
        SOCGameOption optPLB = new SOCGameOption("PLB", 1108, 1113, false, 1, "Use 6-player board");
        optPLB.setClientFeature("6pl");
        opts.add(optPLB);
        SOCGameOption optPLP = new SOCGameOption("PLP", 1108, 2300, false, 1, "6-player board: Can Special Build only if 5 or 6 players in game");
        optPLP.setClientFeature("6pl");
        opts.add(optPLP);
        SOCGameOption optSBL = new SOCGameOption("SBL", 2000, 2000, false, 1, "Use sea board");
        optSBL.setClientFeature("sb");
        opts.add(optSBL);
        opts.add(new SOCGameOption("_BHW", 2000, 2000, 0, 0, 65535, 3, "Large board's height and width (0xRRCC) if not default (local to client only)"));
        opts.add(new SOCGameOption("RD", -1, 1107, false, 0, "Robber can't return to the desert"));
        opts.add(new SOCGameOption("N7", -1, 1107, false, 7, 1, 999, 0, "Roll no 7s during first # rounds"));
        opts.add(new SOCGameOption("N7C", -1, 1119, false, 1, "Roll no 7s until a city is built"));
        opts.add(new SOCGameOption("BC", -1, 1107, true, 4, 3, 9, 0, "Break up clumps of # or more same-type hexes/ports"));
        opts.add(new SOCGameOption("NT", 1107, 1107, false, 1, "No trading allowed between players"));
        opts.add(new SOCGameOption("VP", -1, 2000, false, 10, 10, 20, 1, "Victory points to win: #"));
        opts.add(new SOCGameOption("_VP_ALL", 2000, 2500, false, 1, "Use default VP in all scenarios"));
        opts.add(new SOCGameOption("UB", 2700, 2700, false, 65, "Allow undo piece builds and moves"));
        opts.add(new SOCGameOption("UBL", 2700, 2700, true, 7, 1, 999, 32, "Limit undos to # per player"));
        SOCGameOption optSC = new SOCGameOption("SC", 2000, 2000, 8, false, 1, "Game Scenario: #");
        optSC.setClientFeature("sc");
        opts.add(optSC);
        opts.add(new SOCGameOption(K_SC_SANY, 2000, 2000, false, 1, "Scenarios: SVP for your first settlement on any island after initial placement"));
        opts.add(new SOCGameOption(K_SC_SEAC, 2000, 2000, false, 1, "Scenarios: 2 SVP for your first settlement on each island after initial placement"));
        opts.add(new SOCGameOption(K_SC_FOG, 2000, 2000, false, 1, "Scenarios: Some hexes initially hidden by fog"));
        opts.add(new SOCGameOption(K_SC_0RVP, 2000, 2000, false, 1, "Scenarios: No longest trade route VP (no Longest Road)"));
        opts.add(new SOCGameOption(K_SC_3IP, 2000, 2000, false, 1, "Scenarios: Third initial settlement"));
        opts.add(new SOCGameOption(K_SC_CLVI, 2000, 2000, false, 1, "Scenarios: Cloth Trade with neutral villages"));
        opts.add(new SOCGameOption(K_SC_PIRI, 2000, 2000, false, 1, "Scenarios: Pirate Islands and fortresses"));
        opts.add(new SOCGameOption(K_SC_FTRI, 2000, 2000, false, 1, "Scenarios: The Forgotten Tribe"));
        opts.add(new SOCGameOption(K_SC_WOND, 2000, 2000, false, 1, "Scenarios: Wonders"));
        opts.add(new SOCGameOption(K__EXT_BOT, 2000, 2000, 255, false, 1, "Extra non-core option available for robots in this game"));
        opts.add(new SOCGameOption(K__EXT_CLI, 2000, 2000, 255, false, 1, "Extra non-core option available for clients in this game"));
        opts.add(new SOCGameOption(K__EXT_GAM, 2000, 2000, 255, false, 1, "Extra non-core option available for this game"));
        opts.add(new SOCGameOption(K_PLAY_FO, 2000, 2500, false, 5, "Show all player info and resources"));
        opts.add(new SOCGameOption(K_PLAY_VPO, 2000, 2500, false, 5, "Show all VP/dev card info"));
        optPL.addChangeListener(new SOCGameOption.ChangeListener(){

            @Override
            public void valueChanged(SOCGameOption op, Object oldValue, Object newValue, SOCGameOptionSet currentOpts, SOCGameOptionSet knownOpts) {
                if (!(oldValue instanceof Integer)) {
                    return;
                }
                int ov = (Integer)oldValue;
                int nv = (Integer)newValue;
                if (ov <= 4 && nv > 4) {
                    SOCGameOption plb = currentOpts.get("PLB");
                    if (plb == null) {
                        return;
                    }
                    plb.setBoolValue(true);
                    plb.refreshDisplay();
                }
            }
        });
        optPLB.addChangeListener(new SOCGameOption.ChangeListener(){

            @Override
            public void valueChanged(SOCGameOption op, Object oldValue, Object newValue, SOCGameOptionSet currentOpts, SOCGameOptionSet knownOpts) {
                SOCGameOption pl = currentOpts.get("PL");
                if (pl == null) {
                    return;
                }
                int numPl = pl.getIntValue();
                boolean refreshPl = false;
                if (Boolean.TRUE.equals(newValue)) {
                    if (numPl <= 4 && !pl.userChanged) {
                        pl.setIntValue(6);
                        refreshPl = true;
                    }
                } else {
                    SOCGameOption plp;
                    if (numPl > 4) {
                        pl.setIntValue(4);
                        pl.userChanged = false;
                        refreshPl = true;
                    }
                    if ((plp = currentOpts.get("PLP")) != null && plp.getBoolValue() && !plp.userChanged) {
                        plp.setBoolValue(false);
                        plp.refreshDisplay();
                    }
                }
                if (refreshPl) {
                    pl.refreshDisplay();
                }
            }
        });
        optPLP.addChangeListener(new SOCGameOption.ChangeListener(){

            @Override
            public void valueChanged(SOCGameOption op, Object oldValue, Object newValue, SOCGameOptionSet currentOpts, SOCGameOptionSet knownOpts) {
                boolean changedTo = Boolean.TRUE.equals(newValue);
                SOCGameOption plb = currentOpts.get("PLB");
                if (plb == null || plb.userChanged || changedTo == plb.getBoolValue()) {
                    return;
                }
                plb.setBoolValue(changedTo);
                plb.refreshDisplay();
            }
        });
        optSC.addChangeListener(new SOCGameOption.ChangeListener(){

            @Override
            public void valueChanged(SOCGameOption optSc, Object oldValue, Object newValue, SOCGameOptionSet currentOpts, SOCGameOptionSet knownOpts) {
                SOCGameOption sbl;
                String newSC = optSc.getStringValue();
                boolean isScenPicked = optSc.getBoolValue() && newSC.length() != 0;
                SOCGameOption vp = currentOpts.get("VP");
                if (vp != null && !vp.userChanged && !currentOpts.isOptionSet("_VP_ALL")) {
                    SOCScenario scen;
                    int newVP = vp.defaultIntValue;
                    if (isScenPicked && (scen = SOCScenario.getScenario(newSC)) != null) {
                        int scenVP;
                        SOCGameOption scOptVP;
                        Map<String, SOCGameOption> scenOpts = SOCGameOption.parseOptionsToMap(scen.scOpts, knownOpts);
                        SOCGameOption sOCGameOption = scOptVP = scenOpts != null ? scenOpts.get("VP") : null;
                        if (scOptVP != null && (scenVP = scOptVP.getIntValue()) > newVP) {
                            newVP = scenVP;
                        }
                    }
                    if (newVP != vp.getIntValue()) {
                        vp.setIntValue(newVP);
                        vp.setBoolValue(newVP != 10);
                        vp.refreshDisplay();
                    }
                }
                if ((sbl = currentOpts.get("SBL")) != null && !sbl.userChanged && isScenPicked != sbl.getBoolValue()) {
                    sbl.setBoolValue(isScenPicked);
                    sbl.refreshDisplay();
                }
            }
        });
        return opts;
    }

    public int size() {
        return this.options.size();
    }

    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    public boolean contains(SOCGameOption opt) throws NullPointerException {
        return this.options.containsKey(opt.key);
    }

    public boolean containsKey(String optKey) {
        return this.options.containsKey(optKey);
    }

    public boolean add(SOCGameOption opt) {
        return this.options.put(opt.key, opt) == null;
    }

    public SOCGameOption put(SOCGameOption opt) {
        return this.options.put(opt.key, opt);
    }

    public SOCGameOption get(String optKey) {
        return this.options.get(optKey);
    }

    public Map<String, SOCGameOption> getAll() {
        return this.options;
    }

    public Collection<SOCGameOption> values() {
        return this.options.values();
    }

    public Set<String> keySet() {
        return this.options.keySet();
    }

    @Override
    public Iterator<SOCGameOption> iterator() {
        return this.options.values().iterator();
    }

    public SOCGameOption remove(String optKey) {
        return this.options.remove(optKey);
    }

    public void clear() {
        this.options.clear();
    }

    public boolean isOptionSet(String optKey) {
        SOCGameOption op = this.options.get(optKey);
        if (op == null) {
            return false;
        }
        return op.getBoolValue();
    }

    public void setBoolOption(String boKey, SOCGameOptionSet knownOpts) throws NullPointerException {
        SOCGameOption opt = this.options.get(boKey);
        if (opt == null) {
            opt = knownOpts.getKnownOption(boKey, true);
            opt.setBoolValue(true);
            this.options.put(boKey, opt);
        } else {
            opt.setBoolValue(true);
        }
    }

    public void setIntOption(String ioKey, int ivalue, boolean bvalue, SOCGameOptionSet knownOpts) throws NullPointerException {
        SOCGameOption opt = this.options.get(ioKey);
        if (opt == null) {
            opt = knownOpts.getKnownOption(ioKey, true);
            opt.setIntValue(ivalue);
            opt.setBoolValue(bvalue);
            this.options.put(ioKey, opt);
        } else {
            opt.setIntValue(ivalue);
            opt.setBoolValue(bvalue);
        }
    }

    public int getOptionIntValue(String optKey) {
        return this.getOptionIntValue(optKey, 0, false);
    }

    public int getOptionIntValue(String optKey, int defValue, boolean onlyIfBoolSet) {
        SOCGameOption op = this.options.get(optKey);
        if (op == null) {
            return defValue;
        }
        if (onlyIfBoolSet && !op.getBoolValue()) {
            return defValue;
        }
        return op.getIntValue();
    }

    public String getOptionStringValue(String optKey) {
        SOCGameOption op = this.options.get(optKey);
        if (op == null) {
            return null;
        }
        return op.getStringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOCGameOption getKnownOption(String key, boolean clone) throws IllegalStateException {
        SOCGameOption op;
        Map<String, SOCGameOption> map = this.options;
        synchronized (map) {
            op = this.options.get(key);
        }
        if (op == null) {
            return null;
        }
        if (clone) {
            try {
                op = (SOCGameOption)op.clone();
            }
            catch (CloneNotSupportedException ce) {
                throw new IllegalStateException("Clone failed!", ce);
            }
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addKnownOption(SOCGameOption onew) {
        boolean hadOld;
        String oKey = onew.key;
        Map<String, SOCGameOption> map = this.options;
        synchronized (map) {
            SOCGameOption oldcopy = this.options.remove(oKey);
            boolean bl = hadOld = oldcopy != null;
            if (onew.optType != 0) {
                SOCGameOption.ChangeListener cl;
                if (hadOld && (cl = oldcopy.getChangeListener()) != null) {
                    onew.addChangeListener(cl);
                }
                this.options.put(oKey, onew);
            }
        }
        return !hadOld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(String optKey) throws IllegalArgumentException {
        Map<String, SOCGameOption> map = this.options;
        synchronized (map) {
            SOCGameOption orig = this.options.get(optKey);
            if (orig == null) {
                throw new IllegalArgumentException("unknown: " + optKey);
            }
            if (!orig.hasFlag(4)) {
                if (orig.hasFlag(8)) {
                    return;
                }
                throw new IllegalArgumentException("not inactive: " + optKey);
            }
            this.options.put(optKey, new SOCGameOption((orig.optFlags | 8) & 0xFFFFFFFB, orig));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKnownOptionCurrentValue(SOCGameOption ocurr) throws IllegalArgumentException {
        String oKey = ocurr.key;
        Map<String, SOCGameOption> map = this.options;
        synchronized (map) {
            SOCGameOption oKnown = this.options.get(oKey);
            if (oKnown == null) {
                return;
            }
            switch (oKnown.optType) {
                case 1: {
                    oKnown.setBoolValue(ocurr.getBoolValue());
                    break;
                }
                case 2: 
                case 4: {
                    oKnown.setIntValue(ocurr.getIntValue());
                    break;
                }
                case 3: 
                case 5: {
                    oKnown.setBoolValue(ocurr.getBoolValue());
                    oKnown.setIntValue(ocurr.getIntValue());
                    break;
                }
                case 6: 
                case 7: {
                    oKnown.setStringValue(ocurr.getStringValue());
                }
            }
        }
    }

    public List<SOCGameOption> optionsNewerThanVersion(int vers, boolean checkValues, boolean trimEnums) {
        return this.implOptionsVersionCheck(vers, false, checkValues, trimEnums);
    }

    public List<SOCGameOption> optionsForVersion(int vers) {
        return this.implOptionsVersionCheck(vers, true, false, true);
    }

    /*
     * WARNING - void declaration
     */
    private List<SOCGameOption> implOptionsVersionCheck(int vers, boolean getAllForVersion, boolean checkValues, boolean trimEnums) throws IllegalArgumentException {
        ListIterator<SOCGameOption> li;
        List<SOCGameOption> uopt = SOCVersionedItem.implItemsVersionCheck(vers, getAllForVersion, checkValues, this.options);
        if (!checkValues) {
            Object actives;
            if (uopt != null) {
                li = uopt.listIterator();
                while (li.hasNext()) {
                    SOCGameOption sOCGameOption = li.next();
                    if (!sOCGameOption.hasFlag(4)) continue;
                    li.remove();
                }
            }
            if ((actives = this.optionsWithFlag(8, vers)) != null) {
                if (uopt != null) {
                    for (SOCGameOption opt : uopt) {
                        ((SOCGameOptionSet)actives).remove(opt.key);
                    }
                } else {
                    uopt = new ArrayList<SOCGameOption>();
                }
                Iterator<SOCGameOption> iterator = ((SOCGameOptionSet)actives).iterator();
                while (iterator.hasNext()) {
                    SOCGameOption aopt = iterator.next();
                    uopt.add(aopt);
                }
            }
            if (!getAllForVersion && !trimEnums) {
                for (SOCGameOption sOCGameOption : this.options.values()) {
                    if (0 == (sOCGameOption.optFlags & 0x10) || 0 != (sOCGameOption.optFlags & 4)) continue;
                    if (uopt != null) {
                        if (uopt.contains(sOCGameOption)) {
                            continue;
                        }
                    } else {
                        uopt = new ArrayList<SOCGameOption>();
                    }
                    uopt.add(sOCGameOption);
                }
            }
            if (uopt != null && uopt.isEmpty()) {
                uopt = null;
            }
        }
        if (uopt != null && trimEnums) {
            li = uopt.listIterator();
            while (li.hasNext()) {
                void var7_17;
                int iv;
                boolean bl = false;
                SOCGameOption opt2 = li.next();
                if (opt2.lastModVersion <= vers || opt2.minVersion > vers) continue;
                if (opt2.enumVals != null) {
                    int ev = SOCGameOption.getMaxEnumValueForVersion(opt2.key, vers);
                    if (ev < opt2.enumVals.length) {
                        opt2 = SOCGameOption.trimEnumForVersion(opt2, vers);
                        boolean bl2 = true;
                    }
                } else if (opt2.maxIntValue != opt2.minIntValue && (iv = SOCGameOption.getMaxIntValueForVersion(opt2.key, vers)) != opt2.maxIntValue && iv != Integer.MAX_VALUE) {
                    opt2 = new SOCGameOption(opt2, iv);
                    boolean bl3 = true;
                }
                if (var7_17 == false) continue;
                li.set(opt2);
            }
        }
        return uopt;
    }

    public Map<String, String> adjustOptionsToKnown(SOCGameOptionSet knownOpts, boolean doServerPreadjust, SOCFeatureSet limitedCliFeats) throws IllegalArgumentException {
        SOCGameOption op;
        Object okv;
        boolean allKnown;
        if (knownOpts == null) {
            throw new IllegalArgumentException("null");
        }
        String unknownScenario = null;
        if (doServerPreadjust) {
            String scKey;
            Iterator<String> ki = this.options.keySet().iterator();
            while (ki.hasNext()) {
                SOCGameOption op2 = this.options.get(ki.next());
                if (0 == (op2.optFlags & 2)) continue;
                ki.remove();
            }
            int wantedVP = 0;
            boolean using_VP_ALL = false;
            SOCGameOption opt = this.options.get("VP");
            SOCGameOption knownOptVP = knownOpts.get("VP");
            if (opt == null) {
                if (knownOptVP != null && knownOptVP.getBoolValue()) {
                    wantedVP = knownOptVP.getIntValue();
                }
            } else if (opt.getBoolValue()) {
                wantedVP = opt.getIntValue();
            } else if (knownOptVP != null) {
                if (knownOptVP.getBoolValue()) {
                    wantedVP = knownOptVP.getIntValue();
                } else {
                    this.options.remove("VP");
                }
            }
            if ((opt = this.options.get("SC")) != null && (scKey = opt.getStringValue()).length() > 0) {
                SOCScenario sc = SOCScenario.getScenario(scKey);
                if (sc == null) {
                    unknownScenario = scKey;
                } else {
                    Map<String, SOCGameOption> scOpts = SOCGameOption.parseOptionsToMap(sc.scOpts, knownOpts);
                    boolean with_VP_ALL = knownOpts.isOptionSet("_VP_ALL");
                    using_VP_ALL = with_VP_ALL && knownOpts.isOptionSet("VP") && !this.isOptionSet("VP");
                    opt = this.options.get("VP");
                    SOCGameOption scOptVP = scOpts.get("VP");
                    if (scOptVP != null) {
                        if (!(opt != null && opt.getBoolValue() || scOptVP.getIntValue() <= wantedVP || !scOptVP.getBoolValue() || wantedVP != 0 && with_VP_ALL)) {
                            wantedVP = 0;
                        } else {
                            scOpts.remove("VP");
                        }
                    }
                    this.options.putAll(scOpts);
                }
            }
            if (wantedVP > 0) {
                SOCGameOption optVP = this.options.get("VP");
                if (optVP == null && (optVP = knownOpts.getKnownOption("VP", true)) != null) {
                    this.options.put("VP", optVP);
                }
                if (optVP != null) {
                    optVP.setBoolValue(true);
                    optVP.setIntValue(wantedVP);
                }
            }
            if (!using_VP_ALL) {
                this.options.remove("_VP_ALL");
            } else if (!this.options.containsKey("_VP_ALL")) {
                this.add(knownOpts.getKnownOption("_VP_ALL", true));
            }
            opt = this.options.get("PL");
            SOCGameOption optPLP = this.options.get("PLP");
            if (opt != null && opt.getIntValue() > 4 || optPLP != null && optPLP.getBoolValue()) {
                this.setBoolOption("PLB", knownOpts);
            }
        }
        TreeMap<String, String> optProblems = new TreeMap<String, String>();
        if (unknownScenario != null) {
            allKnown = false;
            optProblems.put("SC", "unknown scenario " + unknownScenario);
        } else {
            allKnown = true;
        }
        Iterator<Map.Entry<String, SOCGameOption>> ikv = this.options.entrySet().iterator();
        block10: while (ikv.hasNext()) {
            okv = ikv.next();
            try {
                op = okv.getValue();
            }
            catch (ClassCastException ce) {
                throw new IllegalArgumentException("wrong class, expected gameoption");
            }
            SOCGameOption knownOp = knownOpts.get(op.key);
            if (knownOp == null) {
                allKnown = false;
                optProblems.put(op.key, "unknown");
                continue;
            }
            if (knownOp.hasFlag(4)) {
                allKnown = false;
                optProblems.put(op.key, "inactive");
                continue;
            }
            if (knownOp.optType != op.optType) {
                allKnown = false;
                optProblems.put(op.key, "optType mismatch (" + knownOp.optType + " != " + op.optType + ")");
                continue;
            }
            if (knownOp.lastModVersion != op.lastModVersion) {
                allKnown = false;
                optProblems.put(op.key, "lastModVersion mismatch (" + knownOp.lastModVersion + " != " + op.lastModVersion + ")");
            }
            switch (op.optType) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int iv = op.getIntValue();
                    if (iv < knownOp.minIntValue) {
                        iv = knownOp.minIntValue;
                        op.setIntValue(iv);
                    } else if (iv > knownOp.maxIntValue) {
                        iv = knownOp.maxIntValue;
                        op.setIntValue(iv);
                    }
                    if (!knownOp.hasFlag(1) || op.isSet()) continue block10;
                    ikv.remove();
                    break;
                }
                case 1: {
                    if (!knownOp.hasFlag(1) || op.getBoolValue()) break;
                    ikv.remove();
                    break;
                }
                case 6: 
                case 7: {
                    if (!knownOp.hasFlag(1) || op.isSet()) break;
                    ikv.remove();
                }
            }
        }
        if (doServerPreadjust) {
            ikv = this.options.entrySet().iterator();
            while (ikv.hasNext()) {
                SOCGameOption par;
                String parentKey;
                okv = ikv.next();
                try {
                    op = okv.getValue();
                }
                catch (ClassCastException ce) {
                    throw new IllegalArgumentException("wrong class, expected gameoption");
                }
                if (!op.hasFlag(32) || (parentKey = SOCGameOption.getGroupParentKey(op.key)) == null || (par = this.options.get(parentKey)) != null && par.isSet()) continue;
                ikv.remove();
            }
        }
        if (doServerPreadjust && allKnown && limitedCliFeats != null) {
            Map<String, SOCGameOption> unsupportedOpts = this.optionsNotSupported(limitedCliFeats);
            if (unsupportedOpts != null) {
                allKnown = false;
                for (String okey : unsupportedOpts.keySet()) {
                    optProblems.put(okey, "requires missing feature(s)");
                }
            } else {
                Map<String, SOCGameOption> trimmedOpts = this.optionsTrimmedForSupport(limitedCliFeats);
                if (trimmedOpts != null) {
                    for (SOCGameOption opt : trimmedOpts.values()) {
                        this.options.put(opt.key, opt);
                    }
                }
            }
        }
        if (allKnown) {
            return null;
        }
        return optProblems;
    }

    public Map<String, SOCGameOption> optionsNotSupported(SOCFeatureSet cliFeats) {
        HashMap<String, SOCGameOption> ret = null;
        for (SOCGameOption opt : this.options.values()) {
            String cliFeat = opt.getClientFeature();
            if (cliFeat == null || cliFeats != null && cliFeats.isActive(cliFeat)) continue;
            if (ret == null) {
                ret = new HashMap<String, SOCGameOption>();
            }
            ret.put(opt.key, opt);
        }
        return ret;
    }

    public Map<String, SOCGameOption> optionsTrimmedForSupport(SOCFeatureSet cliFeats) {
        if (cliFeats != null && cliFeats.isActive("6pl")) {
            return null;
        }
        SOCGameOption pl = this.getKnownOption("PL", false);
        if (pl == null) {
            return null;
        }
        HashMap<String, SOCGameOption> ret = new HashMap<String, SOCGameOption>();
        ret.put("PL", new SOCGameOption(pl, 4));
        return ret;
    }

    public SOCGameOptionSet optionsWithFlag(int flagMask, int minVers) {
        HashMap<String, SOCGameOption> ret = null;
        boolean ignoreInactives = 0 == (flagMask & 4);
        for (SOCGameOption opt : this.options.values()) {
            if (minVers != 0 && opt.minVersion > minVers || ignoreInactives && 0 != (opt.optFlags & 4) || !opt.hasFlag(flagMask)) continue;
            if (ret == null) {
                ret = new HashMap<String, SOCGameOption>();
            }
            ret.put(opt.key, opt);
        }
        return ret != null ? new SOCGameOptionSet(ret) : null;
    }

    public String toString() {
        return this.options.toString();
    }
}

