/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soc.game.SOCDevCard;
import soc.game.SOCInventoryItem;

public class SOCInventory
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2000L;
    public static final int OLD = 0;
    public static final int NEW = 1;
    public static final int PLAYABLE = 2;
    public static final int KEPT = 3;
    private final List<SOCInventoryItem> news = new ArrayList<SOCInventoryItem>();
    private final List<SOCInventoryItem> playables = new ArrayList<SOCInventoryItem>();
    private final List<SOCInventoryItem> kept = new ArrayList<SOCInventoryItem>();

    public SOCInventory() {
    }

    public SOCInventory(SOCInventory set) throws CloneNotSupportedException {
        this();
        for (SOCInventoryItem c : set.news) {
            this.news.add(c.clone());
        }
        for (SOCInventoryItem c : set.playables) {
            this.playables.add(c.clone());
        }
        for (SOCInventoryItem c : set.kept) {
            this.kept.add(c.clone());
        }
    }

    public void clear() {
        this.news.clear();
        this.playables.clear();
        this.kept.clear();
    }

    public List<SOCInventoryItem> getByState(int cState) throws IllegalArgumentException {
        switch (cState) {
            case 1: {
                return this.news;
            }
            case 2: {
                return this.playables;
            }
            case 3: {
                return this.kept;
            }
        }
        throw new IllegalArgumentException("Unknown state: " + cState);
    }

    public List<SOCInventoryItem> getByStateAndType(int state, int itype) throws IllegalArgumentException {
        ArrayList<SOCInventoryItem> ret = null;
        for (SOCInventoryItem itm : this.getByState(state)) {
            if (itm.itype != itype) continue;
            if (ret == null) {
                ret = new ArrayList<SOCInventoryItem>();
            }
            ret.add(itm);
        }
        return ret;
    }

    public boolean hasPlayable(int ctype) {
        for (SOCInventoryItem c : this.playables) {
            if (c.itype != ctype) continue;
            return true;
        }
        return false;
    }

    public int getAmount(int ctype) {
        int amt = 0;
        for (SOCInventoryItem c : this.news) {
            if (c.itype != ctype) continue;
            ++amt;
        }
        for (SOCInventoryItem c : this.playables) {
            if (c.itype != ctype) continue;
            ++amt;
        }
        for (SOCInventoryItem c : this.kept) {
            if (c.itype != ctype) continue;
            ++amt;
        }
        return amt;
    }

    public int getAmount(int age, int ctype) {
        List<SOCInventoryItem> clist = SOCDevCard.isVPCard(ctype) ? this.kept : (age == 1 ? this.news : this.playables);
        int amt = 0;
        for (SOCInventoryItem c : clist) {
            if (!(c instanceof SOCDevCard) || c.itype != ctype) continue;
            ++amt;
        }
        return amt;
    }

    public int getAmountByState(int state, int itype) throws IllegalArgumentException {
        List<SOCInventoryItem> ilist;
        switch (state) {
            case 1: {
                ilist = this.news;
                break;
            }
            case 2: {
                ilist = this.playables;
                break;
            }
            case 3: {
                ilist = this.kept;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state: " + state);
            }
        }
        int amt = 0;
        for (SOCInventoryItem c : ilist) {
            if (c.itype != itype) continue;
            ++amt;
        }
        return amt;
    }

    public int getTotal() {
        return this.news.size() + this.playables.size() + this.kept.size();
    }

    public void addItem(SOCInventoryItem item) {
        if (item.isPlayable()) {
            this.playables.add(item);
        } else if (item.isKept()) {
            this.kept.add(item);
        } else {
            this.news.add(item);
        }
    }

    public void addDevCard(int amt, int age, int ctype) {
        List<SOCInventoryItem> clist;
        boolean isNew;
        if (SOCDevCard.isVPCard(ctype)) {
            isNew = false;
            clist = this.kept;
        } else {
            isNew = age == 1;
            List<SOCInventoryItem> list = clist = isNew ? this.news : this.playables;
        }
        while (amt > 0) {
            clist.add(new SOCDevCard(ctype, isNew));
            --amt;
        }
    }

    public void add(SOCInventory inv) throws CloneNotSupportedException {
        if (inv == null) {
            return;
        }
        for (SOCInventoryItem c : inv.news) {
            this.news.add(c.clone());
        }
        for (SOCInventoryItem c : inv.playables) {
            this.playables.add(c.clone());
        }
        for (SOCInventoryItem c : inv.kept) {
            this.kept.add(c.clone());
        }
    }

    public boolean keepPlayedItem(int itype) {
        Iterator<SOCInventoryItem> iIter = this.playables.iterator();
        while (iIter.hasNext()) {
            SOCInventoryItem c = iIter.next();
            if (c.itype != itype) continue;
            iIter.remove();
            this.kept.add(c);
            return true;
        }
        return false;
    }

    public SOCInventoryItem removeItem(int state, int itype) throws IllegalArgumentException {
        List<SOCInventoryItem> ilist;
        switch (state) {
            case 1: {
                ilist = this.news;
                break;
            }
            case 2: {
                ilist = this.playables;
                break;
            }
            case 3: {
                ilist = this.kept;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state: " + state);
            }
        }
        Iterator<SOCInventoryItem> iIter = ilist.iterator();
        while (iIter.hasNext()) {
            SOCInventoryItem c = iIter.next();
            if (c.itype != itype) continue;
            iIter.remove();
            return c;
        }
        if (itype != 0) {
            return this.removeItem(state, 0);
        }
        return null;
    }

    public void removeDevCard(int age, int ctype) {
        List<SOCInventoryItem> clist = SOCDevCard.isVPCard(ctype) ? this.kept : (age == 1 ? this.news : this.playables);
        Iterator<SOCInventoryItem> cIter = clist.iterator();
        while (cIter.hasNext()) {
            SOCInventoryItem c = cIter.next();
            if (!(c instanceof SOCDevCard) || c.itype != ctype) continue;
            cIter.remove();
            return;
        }
        if (ctype != 0) {
            this.removeDevCard(age, 0);
        }
    }

    public int getNumVPItems() {
        int sum = 0;
        for (SOCInventoryItem c : this.playables) {
            if (!c.isVPItem()) continue;
            ++sum;
        }
        for (SOCInventoryItem c : this.kept) {
            if (!c.isVPItem()) continue;
            ++sum;
        }
        return sum;
    }

    public int getNumUnplayed() {
        return this.news.size() + this.playables.size();
    }

    public void newToOld() {
        for (SOCInventoryItem c : this.news) {
            c.newToOld();
            this.playables.add(c);
        }
        this.news.clear();
    }
}

