/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import soc.game.SOCBoard;
import soc.game.SOCGame;
import soc.util.SOCStringManager;

public class SOCInventoryItem
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2000L;
    public final int itype;
    private boolean playable;
    private final boolean kept;
    private final boolean vpItem;
    public final boolean canCancelPlay;
    protected final String strKey;
    protected final String aStrKey;

    public static final SOCInventoryItem createForScenario(SOCGame ga, int type, boolean isPlayable, boolean isKept, boolean isVP, boolean canCancel) {
        if (ga.isGameOptionSet("_SC_FTRI")) {
            return new SOCInventoryItem(type, isPlayable, isKept, isVP, canCancel, SOCBoard.getPortDescForType(-type, false), SOCBoard.getPortDescForType(-type, true));
        }
        return new SOCInventoryItem(type, isPlayable, isKept, isVP, canCancel, "game.invitem.unknown", "game.aninvitem.unknown");
    }

    public static final boolean isPlayForPlacement(SOCGame ga, int type) {
        return ga.isGameOptionSet("_SC_FTRI");
    }

    public SOCInventoryItem(int type, boolean isPlayable, boolean isKept, boolean isVP, boolean canCancel, String strKey, String aStrKey) {
        this.itype = type;
        this.playable = isPlayable;
        this.kept = isKept;
        this.vpItem = isVP;
        this.canCancelPlay = canCancel;
        this.strKey = strKey;
        this.aStrKey = aStrKey;
    }

    public boolean isNew() {
        return !this.playable && !this.kept;
    }

    public boolean isPlayable() {
        return this.playable;
    }

    public boolean isKept() {
        return this.kept;
    }

    public boolean isVPItem() {
        return this.vpItem;
    }

    public void newToOld() {
        this.playable = true;
    }

    public String getItemName(SOCGame game, boolean withArticle, SOCStringManager strings) {
        return strings.get(withArticle ? this.aStrKey : this.strKey);
    }

    public SOCInventoryItem clone() throws CloneNotSupportedException {
        return (SOCInventoryItem)super.clone();
    }

    public String toString() {
        return "SOCInventoryItem{itype=" + this.itype + ", playable?=" + this.playable + ", kept?=" + this.kept + ", strKey=" + this.strKey + "}@" + Integer.toHexString(this.hashCode());
    }
}

