/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.GameAction;
import soc.game.ResourceSet;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCCity;
import soc.game.SOCDevCardConstants;
import soc.game.SOCFortress;
import soc.game.SOCGame;
import soc.game.SOCInventory;
import soc.game.SOCInventoryItem;
import soc.game.SOCLRPathData;
import soc.game.SOCPlayerEvent;
import soc.game.SOCPlayerNumbers;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCRoutePiece;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.game.SOCSpecialItem;
import soc.game.SOCTradeOffer;
import soc.game.SOCVillage;
import soc.message.SOCMessage;
import soc.util.IntPair;
import soc.util.NodeLenVis;

public class SOCPlayer
implements SOCDevCardConstants,
Serializable,
Cloneable {
    private static final long serialVersionUID = 2700L;
    public static final int ROAD_COUNT = 15;
    public static final int SETTLEMENT_COUNT = 5;
    public static final int CITY_COUNT = 4;
    public static final int SHIP_COUNT = 15;
    public static final int FIRST_HUMAN_FACE_ID = 1;
    public static int STUBBORN_ROBOT_FORCE_END_TURN_THRESHOLD = 2;
    public static final int TRADE_STATS_ARRAY_LEN = 8;
    public static final int TRADE_STATS_INDEX_BANK = 6;
    public static final int TRADE_STATS_INDEX_PLAYER_ALL = 7;
    private String name;
    private int playerNumber;
    private SOCGame game;
    private int[] numPieces;
    private int numWarships;
    private Vector<SOCPlayingPiece> pieces;
    private Vector<SOCRoutePiece> roadsAndShips;
    private Vector<SOCSettlement> settlements;
    private Vector<SOCCity> cities;
    private SOCFortress fortress;
    private HashMap<String, ArrayList<SOCSpecialItem>> spItems;
    protected int lastSettlementCoord;
    protected int lastRoadCoord;
    private int longestRoadLength;
    private final Vector<SOCLRPathData> lrPaths;
    private SOCResourceSet resources;
    private SOCResourceSet rolledResources;
    int forcedEndTurnCount;
    private int[] resourceStats;
    private SOCResourceSet[] tradeStatsGive;
    private SOCResourceSet[] tradeStatsGet;
    private SOCInventory inventory;
    private int numKnights;
    private List<Integer> devCardsPlayed;
    public int numRBCards = 0;
    public int numDISCCards = 0;
    public int numMONOCards = 0;
    private int buildingVP;
    private int specialVP;
    private ArrayList<SpecialVPInfo> svpInfo;
    private int finalTotalVP;
    private int undosRemaining;
    private int numCloth;
    private boolean needToDiscard;
    private int needToPickGoldHexResources;
    private Vector<Integer> roadNodes;
    private Hashtable<Integer, int[]> roadNodeGraph;
    private HashSet<Integer> legalRoads;
    private HashSet<Integer> legalSettlements;
    private int addedLegalSettlement;
    private HashSet<Integer> legalShips;
    private HashSet<Integer> legalShipsRestricted;
    private HashSet<Integer> potentialRoads;
    private HashSet<Integer> potentialSettlements;
    private HashSet<Integer> potentialCities;
    private HashSet<Integer> potentialShips;
    private boolean hasPotentialSettlesInitInFog;
    private boolean[] ports;
    private SOCTradeOffer currentOffer;
    private long currentOfferTimeMillis;
    private boolean playedDevCard;
    private boolean boardResetAskedThisTurn;
    private boolean askedSpecialBuild;
    private boolean hasSpecialBuiltThisTurn;
    private int playerEvents_bitmask;
    private int scenario_svpFromEachLandArea_bitmask;
    private int startingLandArea1;
    private int startingLandArea2;
    private boolean robotFlag;
    private boolean builtInRobotFlag;
    private int faceId;
    private SOCPlayerNumbers ourNumbers;
    private boolean askedDiscardTwiceThisTurn;
    public transient List<Object> pendingMessagesOut;
    private SOCVillage isTradeRouteFarEndClosed_foundVillage;

    public SOCPlayer(SOCPlayer player, String newName) throws IllegalArgumentException, IllegalStateException {
        int i;
        if (player.game == null) {
            throw new IllegalArgumentException("game");
        }
        this.game = player.game;
        this.name = newName != null ? newName : player.name;
        this.playerNumber = player.playerNumber;
        this.numPieces = (int[])player.numPieces.clone();
        this.pieces = new Vector<SOCPlayingPiece>(player.pieces);
        this.roadsAndShips = new Vector<SOCRoutePiece>(player.roadsAndShips);
        this.settlements = new Vector<SOCSettlement>(player.settlements);
        this.cities = new Vector<SOCCity>(player.cities);
        this.spItems = new HashMap();
        if (!player.spItems.isEmpty()) {
            for (String optKey : player.spItems.keySet()) {
                ArrayList<SOCSpecialItem> old = player.spItems.get(optKey);
                if (old.isEmpty()) continue;
                ArrayList<SOCSpecialItem> anew = new ArrayList<SOCSpecialItem>();
                int L = old.size();
                try {
                    for (int i2 = 0; i2 < L; ++i2) {
                        SOCSpecialItem itm = old.get(i2);
                        anew.add(itm != null ? itm.clone() : null);
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                this.spItems.put(optKey, anew);
            }
        }
        this.fortress = player.fortress;
        this.numWarships = player.numWarships;
        this.longestRoadLength = player.longestRoadLength;
        this.lrPaths = new Vector<SOCLRPathData>(player.lrPaths);
        this.resources = player.resources.copy();
        this.resourceStats = new int[player.resourceStats.length];
        System.arraycopy(player.resourceStats, 0, this.resourceStats, 0, player.resourceStats.length);
        this.tradeStatsGive = new SOCResourceSet[player.tradeStatsGive.length];
        this.tradeStatsGet = new SOCResourceSet[player.tradeStatsGive.length];
        for (i = 0; i < player.tradeStatsGive.length; ++i) {
            this.tradeStatsGive[i] = new SOCResourceSet(player.tradeStatsGive[i]);
            this.tradeStatsGet[i] = new SOCResourceSet(player.tradeStatsGet[i]);
        }
        this.rolledResources = player.rolledResources.copy();
        try {
            this.inventory = new SOCInventory(player.inventory);
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Internal error, cards should be cloneable", e);
        }
        this.numKnights = player.numKnights;
        this.buildingVP = player.buildingVP;
        this.specialVP = player.specialVP;
        this.finalTotalVP = 0;
        this.undosRemaining = player.undosRemaining;
        this.numRBCards = player.numRBCards;
        this.numDISCCards = player.numDISCCards;
        this.numMONOCards = player.numMONOCards;
        if (player.devCardsPlayed != null) {
            this.devCardsPlayed = new ArrayList<Integer>(player.devCardsPlayed);
        }
        this.playedDevCard = player.playedDevCard;
        this.needToDiscard = player.needToDiscard;
        this.needToPickGoldHexResources = player.needToPickGoldHexResources;
        this.boardResetAskedThisTurn = player.boardResetAskedThisTurn;
        this.askedSpecialBuild = player.askedSpecialBuild;
        this.hasSpecialBuiltThisTurn = player.hasSpecialBuiltThisTurn;
        this.robotFlag = player.robotFlag;
        this.builtInRobotFlag = player.builtInRobotFlag;
        this.faceId = player.faceId;
        this.ourNumbers = new SOCPlayerNumbers(player.ourNumbers);
        this.ports = new boolean[6];
        for (i = 0; i <= 5; ++i) {
            this.ports[i] = player.ports[i];
        }
        this.roadNodes = new Vector<Integer>(player.roadNodes);
        this.roadNodeGraph = new Hashtable((int)((float)player.roadNodeGraph.size() * 1.4f));
        for (Integer rnKey : player.roadNodeGraph.keySet()) {
            int[] rnArr = player.roadNodeGraph.get(rnKey);
            this.roadNodeGraph.put(rnKey, (int[])rnArr.clone());
        }
        this.legalRoads = new HashSet<Integer>(player.legalRoads);
        this.legalSettlements = new HashSet<Integer>(player.legalSettlements);
        this.legalShips = new HashSet<Integer>(player.legalShips);
        this.potentialRoads = new HashSet<Integer>(player.potentialRoads);
        this.potentialSettlements = new HashSet<Integer>(player.potentialSettlements);
        this.potentialCities = new HashSet<Integer>(player.potentialCities);
        this.potentialShips = new HashSet<Integer>(player.potentialShips);
        this.addedLegalSettlement = player.addedLegalSettlement;
        if (player.legalShipsRestricted != null) {
            this.legalShipsRestricted = new HashSet<Integer>(player.legalShipsRestricted);
        }
        this.currentOffer = player.currentOffer != null ? new SOCTradeOffer(player.currentOffer) : null;
        this.playerEvents_bitmask = player.playerEvents_bitmask;
        this.scenario_svpFromEachLandArea_bitmask = player.scenario_svpFromEachLandArea_bitmask;
        this.startingLandArea1 = player.startingLandArea1;
        this.startingLandArea2 = player.startingLandArea2;
    }

    public SOCPlayer(int pn, SOCGame ga) throws IllegalArgumentException {
        if (ga == null) {
            throw new IllegalArgumentException("game");
        }
        this.game = ga;
        this.playerNumber = pn;
        this.numPieces = new int[6];
        this.numPieces[0] = 15;
        this.numPieces[1] = 5;
        this.numPieces[2] = 4;
        this.numPieces[3] = ga.hasSeaBoard ? 15 : 0;
        if (ga.isGameOptionSet("_SC_PIRI")) {
            this.numPieces[1] = this.numPieces[1] - 1;
        }
        this.pieces = new Vector(24);
        this.roadsAndShips = new Vector(15);
        this.settlements = new Vector(5);
        this.cities = new Vector(4);
        this.spItems = new HashMap();
        this.longestRoadLength = 0;
        this.lrPaths = new Vector();
        this.resources = new SOCResourceSet();
        this.resourceStats = new int[7];
        this.tradeStatsGive = new SOCResourceSet[8];
        this.tradeStatsGet = new SOCResourceSet[8];
        for (int i = 0; i < 8; ++i) {
            this.tradeStatsGive[i] = new SOCResourceSet();
            this.tradeStatsGet[i] = new SOCResourceSet();
        }
        this.rolledResources = new SOCResourceSet();
        this.inventory = new SOCInventory();
        this.numKnights = 0;
        this.buildingVP = 0;
        this.specialVP = 0;
        this.playedDevCard = false;
        this.needToDiscard = false;
        this.needToPickGoldHexResources = 0;
        this.boardResetAskedThisTurn = false;
        this.askedSpecialBuild = false;
        this.hasSpecialBuiltThisTurn = false;
        this.robotFlag = false;
        this.builtInRobotFlag = false;
        this.faceId = 1;
        SOCBoard board = ga.getBoard();
        this.ourNumbers = new SOCPlayerNumbers(board);
        this.ports = new boolean[6];
        this.roadNodes = new Vector(20);
        this.roadNodeGraph = new Hashtable();
        this.potentialRoads = new HashSet();
        this.potentialCities = new HashSet();
        this.potentialShips = new HashSet();
        if (!this.game.hasSeaBoard) {
            this.legalRoads = board.initPlayerLegalRoads();
            this.legalSettlements = board.initPlayerLegalSettlements();
            this.legalShips = new HashSet();
            this.potentialSettlements = new HashSet<Integer>(this.legalSettlements);
        } else {
            this.legalRoads = new HashSet();
            this.legalSettlements = new HashSet();
            this.legalShips = new HashSet();
            this.potentialSettlements = new HashSet();
        }
        this.currentOffer = null;
    }

    public void clearPotentialSettlements() {
        this.potentialSettlements.clear();
        this.hasPotentialSettlesInitInFog = false;
    }

    void updateAtTurn() {
        this.rolledResources.clear();
        this.setCurrentOffer(null);
        this.askedDiscardTwiceThisTurn = false;
    }

    void updateAtOurTurn() {
        this.inventory.newToOld();
        this.playedDevCard = false;
        if (this.needToPickGoldHexResources > 0) {
            this.needToPickGoldHexResources = 0;
        }
    }

    public void setName(String na) throws IllegalArgumentException {
        if (na != null && !SOCMessage.isSingleLineAndSafe(na)) {
            throw new IllegalArgumentException("na");
        }
        this.name = na;
        this.forcedEndTurnCount = 0;
    }

    public String getName() {
        return this.name;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public SOCGame getGame() {
        return this.game;
    }

    public boolean hasPlayedDevCard() {
        return this.playedDevCard;
    }

    public void setPlayedDevCard(boolean value) {
        this.playedDevCard = value;
    }

    public synchronized void updateDevCardsPlayed(int ctype, boolean isCancel) {
        switch (ctype) {
            case 2: {
                if (isCancel) {
                    --this.numDISCCards;
                    break;
                }
                ++this.numDISCCards;
                break;
            }
            case 3: {
                if (isCancel) {
                    --this.numMONOCards;
                    break;
                }
                ++this.numMONOCards;
                break;
            }
            case 1: {
                if (isCancel) {
                    --this.numRBCards;
                    break;
                }
                ++this.numRBCards;
            }
        }
        if (this.devCardsPlayed == null) {
            this.devCardsPlayed = new ArrayList<Integer>();
        }
        if (isCancel) {
            for (int i = this.devCardsPlayed.size() - 1; i >= 0; --i) {
                if (this.devCardsPlayed.get(i) != ctype) continue;
                this.devCardsPlayed.remove(i);
                break;
            }
        } else {
            this.devCardsPlayed.add(ctype);
        }
    }

    public List<Integer> getDevCardsPlayed() {
        if (this.devCardsPlayed == null) {
            return null;
        }
        return new ArrayList<Integer>(this.devCardsPlayed);
    }

    public boolean hasAskedBoardReset() {
        return this.boardResetAskedThisTurn;
    }

    public void setAskedBoardReset(boolean value) {
        this.boardResetAskedThisTurn = value;
    }

    public boolean hasAskedSpecialBuild() {
        return this.askedSpecialBuild;
    }

    public void setAskedSpecialBuild(boolean set) {
        this.askedSpecialBuild = set;
    }

    public boolean hasSpecialBuilt() {
        return this.hasSpecialBuiltThisTurn;
    }

    public void setSpecialBuilt(boolean set) {
        this.hasSpecialBuiltThisTurn = set;
    }

    public void setNeedToDiscard(boolean value) {
        this.needToDiscard = value;
    }

    public boolean getNeedToDiscard() {
        return this.needToDiscard;
    }

    public int getCountToDiscard() {
        return this.resources.getTotal() / 2;
    }

    public void setNeedToPickGoldHexResources(int numRes) {
        int d = numRes - this.needToPickGoldHexResources;
        this.needToPickGoldHexResources = numRes;
        if (d > 0) {
            this.resourceStats[6] = this.resourceStats[6] + d;
        }
    }

    public int getNeedToPickGoldHexResources() {
        return this.needToPickGoldHexResources;
    }

    public void setRobotFlag(boolean isRobot, boolean isBuiltIn) {
        this.robotFlag = isRobot;
        this.builtInRobotFlag = isBuiltIn;
    }

    public boolean isRobot() {
        return this.robotFlag;
    }

    public boolean isBuiltInRobot() {
        return this.builtInRobotFlag;
    }

    public boolean isStubbornRobot() {
        return this.robotFlag && this.forcedEndTurnCount >= STUBBORN_ROBOT_FORCE_END_TURN_THRESHOLD;
    }

    public void addForcedEndTurn() {
        ++this.forcedEndTurnCount;
    }

    public void setFaceId(int id) {
        this.faceId = id;
    }

    public int getFaceId() {
        return this.faceId;
    }

    public SOCPlayerNumbers getNumbers() {
        return this.ourNumbers;
    }

    public boolean hasAskedDiscardTwiceThisTurn() {
        return this.askedDiscardTwiceThisTurn;
    }

    public void setAskedDiscardTwiceThisTurn() {
        this.askedDiscardTwiceThisTurn = true;
    }

    public int getNumPieces(int ptype) throws ArrayIndexOutOfBoundsException {
        return this.numPieces[ptype];
    }

    public void setNumPieces(int ptype, int amt) {
        this.numPieces[ptype] = amt;
    }

    public int getNumWarships() {
        return this.numWarships;
    }

    public void setNumWarships(int count) {
        this.numWarships = count;
    }

    public Vector<SOCPlayingPiece> getPieces() {
        return this.pieces;
    }

    public Vector<SOCRoutePiece> getRoadsAndShips() {
        return this.roadsAndShips;
    }

    public SOCRoutePiece getRoadOrShip(int edge) {
        for (SOCRoutePiece roadOrShip : this.roadsAndShips) {
            if (roadOrShip.getCoordinates() != edge) continue;
            return roadOrShip;
        }
        return null;
    }

    public SOCShip getMostRecentShip() {
        for (int i = this.roadsAndShips.size() - 1; i >= 0; --i) {
            SOCRoutePiece rs = this.roadsAndShips.get(i);
            if (!(rs instanceof SOCShip)) continue;
            return (SOCShip)rs;
        }
        return null;
    }

    public Vector<SOCSettlement> getSettlements() {
        return this.settlements;
    }

    public SOCPlayingPiece getSettlementOrCityAtNode(int node) {
        for (SOCSettlement sett : this.settlements) {
            if (sett.getCoordinates() != node) continue;
            return sett;
        }
        for (SOCCity city : this.cities) {
            if (city.getCoordinates() != node) continue;
            return city;
        }
        return null;
    }

    public Vector<SOCCity> getCities() {
        return this.cities;
    }

    public ArrayList<SOCSpecialItem> getSpecialItems(String typeKey) {
        ArrayList<SOCSpecialItem> ret = this.spItems.get(typeKey);
        if (ret == null || ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    public SOCSpecialItem getSpecialItem(String typeKey, int idx) {
        ArrayList<SOCSpecialItem> li = this.spItems.get(typeKey);
        if (li == null) {
            return null;
        }
        try {
            return li.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public SOCSpecialItem setSpecialItem(String typeKey, int idx, SOCSpecialItem itm) throws IndexOutOfBoundsException {
        int L;
        ArrayList<SOCSpecialItem> li = this.spItems.get(typeKey);
        if (li == null) {
            li = new ArrayList();
            this.spItems.put(typeKey, li);
        }
        if (idx < (L = li.size())) {
            return li.set(idx, itm);
        }
        for (int n = idx - L; n > 0; --n) {
            li.add(null);
        }
        li.add(itm);
        return null;
    }

    public SOCFortress getFortress() {
        return this.fortress;
    }

    public int getCloth() {
        return this.numCloth;
    }

    public void setCloth(int numCloth) {
        this.numCloth = numCloth;
    }

    public boolean canMoveShip(SOCShip sh) {
        int shipEdge;
        int[] shipNodes;
        if (sh.isClosed()) {
            return false;
        }
        SOCBoard board = this.game.getBoard();
        SOCPlayingPiece pp = board.settlementAtNode((shipNodes = board.getAdjacentNodesToEdge_arr(shipEdge = sh.getCoordinates()))[0]);
        if (pp != null && pp.getPlayerNumber() != this.playerNumber) {
            pp = null;
        }
        boolean clearPastNode0 = null == pp && !this.doesTradeRouteContinuePastNode(board, true, shipEdge, -9, shipNodes[0]);
        pp = board.settlementAtNode(shipNodes[1]);
        if (pp != null && pp.getPlayerNumber() != this.playerNumber) {
            pp = null;
        }
        boolean clearPastNode1 = null == pp && !this.doesTradeRouteContinuePastNode(board, true, shipEdge, -9, shipNodes[1]);
        return clearPastNode0 || clearPastNode1;
    }

    private final boolean doesTradeRouteContinuePastEdge(int edge, boolean wantShip) {
        SOCBoard board = this.game.getBoard();
        int[] edgeNodes = board.getAdjacentNodesToEdge_arr(edge);
        for (int i = 0; i < 2; ++i) {
            SOCPlayingPiece sc = board.settlementAtNode(edgeNodes[i]);
            if (!(sc != null ? sc.getPlayerNumber() == this.playerNumber : this.doesTradeRouteContinuePastNode(board, wantShip, edge, -9, edgeNodes[i]))) continue;
            return true;
        }
        return false;
    }

    private final boolean doesTradeRouteContinuePastNode(SOCBoard board, boolean wantShip, int rsEdge, int ignoreEdge, int node) {
        boolean routeContinues = false;
        int openEdgesCount = ignoreEdge != -9 && this.game.isGameOptionSet("_SC_PIRI") ? 3 : 0;
        int[] adjEdges = board.getAdjacentEdgesToNode_arr(node);
        for (int i = 0; i < 3; ++i) {
            if (adjEdges[i] != rsEdge && adjEdges[i] != ignoreEdge) continue;
            adjEdges[i] = -9;
        }
        for (SOCRoutePiece rs : this.roadsAndShips) {
            int edge = rs.getCoordinates();
            for (int i = 0; i < 3; ++i) {
                if (edge != adjEdges[i] || rs.isRoadNotShip() == wantShip) continue;
                routeContinues = true;
                if (openEdgesCount == 0) break;
                --openEdgesCount;
                break;
            }
            if (!routeContinues || openEdgesCount >= 2) continue;
            break;
        }
        if (openEdgesCount == 0) {
            return routeContinues;
        }
        return openEdgesCount == 2;
    }

    private List<SOCShip> checkTradeRouteFarEndClosed(SOCShip newShipEdge, int edgeFarNode) throws IllegalStateException, IllegalArgumentException {
        if (!this.game.hasSeaBoard) {
            throw new IllegalStateException();
        }
        ArrayList<ArrayList<Object>> encounteredSelf = new ArrayList<ArrayList<Object>>();
        HashSet<Integer> alreadyVisited = new HashSet<Integer>();
        this.isTradeRouteFarEndClosed_foundVillage = null;
        List<SOCShip> segment = this.isTradeRouteFarEndClosed(newShipEdge, edgeFarNode, alreadyVisited, encounteredSelf);
        if (segment == null) {
            return null;
        }
        for (SOCShip sh : segment) {
            sh.setClosed();
        }
        if (this.isTradeRouteFarEndClosed_foundVillage != null) {
            boolean flagNew;
            boolean gotCloth = this.isTradeRouteFarEndClosed_foundVillage.addTradingPlayer(this);
            boolean bl = flagNew = !this.hasPlayerEvent(SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE);
            if (flagNew) {
                this.setPlayerEvent(SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE);
            }
            if ((flagNew || gotCloth) && this.game.gameEventListener != null) {
                this.game.gameEventListener.playerEvent(this.game, this, SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE, flagNew, this.isTradeRouteFarEndClosed_foundVillage);
            }
        }
        if (encounteredSelf.size() > 0) {
            for (int i = 0; i < encounteredSelf.size(); ++i) {
                boolean flagNew;
                List<SOCShip> recheck;
                ArrayList self = (ArrayList)encounteredSelf.get(i);
                int farNode = (Integer)self.get(0);
                SOCShip nearestShip = (SOCShip)self.get(1);
                if (nearestShip.isClosed()) continue;
                ArrayList<ArrayList<Object>> reSelf = new ArrayList<ArrayList<Object>>();
                HashSet<Integer> reAlready = new HashSet<Integer>();
                this.isTradeRouteFarEndClosed_foundVillage = null;
                if (self.size() == 2) {
                    recheck = this.isTradeRouteFarEndClosed(nearestShip, farNode, reAlready, reSelf);
                } else {
                    int nextNearEdge = ((SOCShip)self.get(2)).getCoordinates();
                    recheck = this.isTradeRouteFarEndClosed(nearestShip, ((SOCBoardLarge)this.game.getBoard()).getNodeBetweenAdjacentEdges(nearestShip.getCoordinates(), nextNearEdge), reAlready, reSelf);
                }
                if (recheck == null) continue;
                segment.addAll(recheck);
                for (SOCShip sh : recheck) {
                    sh.setClosed();
                }
                if (this.isTradeRouteFarEndClosed_foundVillage == null) continue;
                boolean gotCloth = this.isTradeRouteFarEndClosed_foundVillage.addTradingPlayer(this);
                boolean bl = flagNew = !this.hasPlayerEvent(SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE);
                if (flagNew) {
                    this.setPlayerEvent(SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE);
                }
                if (!flagNew && !gotCloth || this.game.gameEventListener == null) continue;
                this.game.gameEventListener.playerEvent(this.game, this, SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE, flagNew, this.isTradeRouteFarEndClosed_foundVillage);
            }
        }
        return segment;
    }

    private List<SOCShip> isTradeRouteFarEndClosed(SOCShip edgeFirstShip, int edgeFarNode, HashSet<Integer> alreadyVisited, List<ArrayList<Object>> encounteredSelf) throws ClassCastException, IllegalArgumentException {
        if (edgeFirstShip.isClosed()) {
            throw new IllegalArgumentException("closed(0x" + Integer.toHexString(edgeFirstShip.getCoordinates()) + ')');
        }
        SOCBoardLarge board = (SOCBoardLarge)this.game.getBoard();
        boolean boardHasVillages = this.game.isGameOptionSet("_SC_CLVI");
        ArrayList<SOCShip> segment = new ArrayList<SOCShip>();
        SOCShip edgeShip = edgeFirstShip;
        segment.add(edgeShip);
        int edge = edgeShip.getCoordinates();
        int node = edgeFarNode;
        boolean foundClosedEnd = false;
        SOCPlayingPiece pp = null;
        while (edge != 0 && !foundClosedEnd) {
            Integer edgeInt = edge;
            if (alreadyVisited.contains(edgeInt)) {
                ArrayList<Serializable> already = new ArrayList<Serializable>();
                already.add(Integer.valueOf(node));
                already.addAll(segment);
                encounteredSelf.add(already);
                return null;
            }
            alreadyVisited.add(edgeInt);
            pp = board.settlementAtNode(node);
            if (pp != null) {
                if (pp.getPlayerNumber() != this.playerNumber) break;
                foundClosedEnd = true;
                break;
            }
            if (boardHasVillages && (pp = board.getVillageAtNode(node)) != null) {
                foundClosedEnd = true;
                break;
            }
            int[] nodeEdges = board.getAdjacentEdgesToNode_arr(node);
            SOCPlayingPiece nextShip1 = null;
            SOCShip nextShip2 = null;
            for (int i = 0; i < 3; ++i) {
                SOCRoutePiece rs;
                if (nodeEdges[i] == edge || nodeEdges[i] == -9 || (rs = this.getRoadOrShip(nodeEdges[i])) == null || rs.isRoadNotShip()) continue;
                if (nextShip1 == null) {
                    nextShip1 = (SOCShip)rs;
                    continue;
                }
                nextShip2 = (SOCShip)rs;
            }
            if (nextShip1 == null) break;
            if (nextShip2 == null) {
                edge = nextShip1.getCoordinates();
                node = board.getAdjacentNodeFarEndOfEdge(edge, node);
                segment.add((SOCShip)nextShip1);
                continue;
            }
            if (nextShip2.isClosed()) {
                foundClosedEnd = true;
                break;
            }
            int encounterSize = encounteredSelf.size();
            List<SOCShip> shipsFrom1 = this.isTradeRouteFarEndClosed((SOCShip)nextShip1, board.getAdjacentNodeFarEndOfEdge(nextShip1.getCoordinates(), node), alreadyVisited, encounteredSelf);
            List<SOCShip> shipsFrom2 = this.isTradeRouteFarEndClosed(nextShip2, board.getAdjacentNodeFarEndOfEdge(nextShip2.getCoordinates(), node), alreadyVisited, encounteredSelf);
            if (encounterSize != encounteredSelf.size()) {
                ArrayList<Serializable> already = new ArrayList<Serializable>();
                already.add(Integer.valueOf(node));
                already.addAll(segment);
                encounteredSelf.add(already);
            }
            if (shipsFrom1 == null) {
                if (shipsFrom2 == null) {
                    return null;
                }
                segment.addAll(shipsFrom2);
                return segment;
            }
            if (shipsFrom2 == null) {
                segment.addAll(shipsFrom1);
                return segment;
            }
            segment.addAll(shipsFrom1);
            segment.addAll(shipsFrom2);
            return segment;
        }
        if (!foundClosedEnd) {
            return null;
        }
        if (pp instanceof SOCVillage) {
            this.isTradeRouteFarEndClosed_foundVillage = (SOCVillage)pp;
        }
        return segment;
    }

    public int getLastSettlementCoord() {
        return this.lastSettlementCoord;
    }

    public int getLastRoadCoord() {
        return this.lastRoadCoord;
    }

    public int getLongestRoadLength() {
        return this.longestRoadLength;
    }

    public Vector<SOCLRPathData> getLRPaths() {
        return this.lrPaths;
    }

    public void setLRPaths(List<SOCLRPathData> lrList) {
        this.lrPaths.clear();
        for (SOCLRPathData pd : lrList) {
            this.lrPaths.add(pd);
        }
    }

    public void setLastSettlementCoord(int node) {
        this.lastSettlementCoord = node;
    }

    public void setLongestRoadLength(int len) {
        this.longestRoadLength = len;
    }

    public SOCResourceSet getResources() {
        return this.resources;
    }

    public int[] getResourceRollStats() {
        return this.resourceStats;
    }

    public void setResourceRollStats(int[] stats) throws IllegalArgumentException {
        if (stats == null || stats.length < this.resourceStats.length) {
            throw new IllegalArgumentException("stats.length < " + this.resourceStats.length);
        }
        System.arraycopy(stats, 0, this.resourceStats, 0, this.resourceStats.length);
    }

    public void addRolledResources(SOCResourceSet rolled) {
        int gold;
        if (this.game.hasSeaBoard && (gold = rolled.getAmount(6)) > 0) {
            this.needToPickGoldHexResources += gold;
            this.resourceStats[6] = this.resourceStats[6] + gold;
            rolled.setAmount(0, 6);
        }
        this.rolledResources.setAmounts(rolled);
        this.resources.add(rolled);
        for (int rtype = 1; rtype < this.resourceStats.length; ++rtype) {
            int n = rtype;
            this.resourceStats[n] = this.resourceStats[n] + rolled.getAmount(rtype);
        }
    }

    public SOCResourceSet getRolledResources() {
        return this.rolledResources;
    }

    public SOCResourceSet[][] getResourceTradeStats() {
        return new SOCResourceSet[][]{this.tradeStatsGive, this.tradeStatsGet};
    }

    public void setResourceTradeStats(ResourceSet[][] stats) {
        int ttype;
        if (stats == null || stats.length != 2) {
            throw new IllegalArgumentException("stats");
        }
        int n = stats[0].length;
        if (n > 8) {
            n = 8;
        } else if (n < 8) {
            for (ttype = n; ttype < 8; ++ttype) {
                this.tradeStatsGive[ttype].clear();
                this.tradeStatsGet[ttype].clear();
            }
        }
        for (ttype = 0; ttype < n; ++ttype) {
            ResourceSet gave = stats[0][ttype];
            ResourceSet got = stats[1][ttype];
            if (gave != null) {
                this.tradeStatsGive[ttype].setAmounts(gave);
            } else {
                this.tradeStatsGive[ttype].clear();
            }
            if (got != null) {
                this.tradeStatsGet[ttype].setAmounts(got);
                continue;
            }
            this.tradeStatsGet[ttype].clear();
        }
    }

    public SOCInventory getInventory() {
        return this.inventory;
    }

    public boolean hasUnplayedDevCards() {
        return 0 < this.inventory.getNumUnplayed();
    }

    public int getNumKnights() {
        return this.numKnights;
    }

    public void setNumKnights(int nk) {
        this.numKnights = nk;
    }

    public void incrementNumKnights() {
        ++this.numKnights;
    }

    public boolean hasLongestRoad() {
        SOCPlayer p = this.game.getPlayerWithLongestRoad();
        if (p == null) {
            return false;
        }
        return p.getPlayerNumber() == this.playerNumber;
    }

    public boolean hasLargestArmy() {
        SOCPlayer p = this.game.getPlayerWithLargestArmy();
        if (p == null) {
            return false;
        }
        return p.getPlayerNumber() == this.playerNumber;
    }

    public int getUndosRemaining() {
        return this.undosRemaining;
    }

    public void setUndosRemaining(int newRemain) {
        this.undosRemaining = newRemain;
    }

    public void decrementUndosRemaining() throws IllegalStateException {
        if (this.undosRemaining <= 0) {
            throw new IllegalStateException("undosRemaining");
        }
        --this.undosRemaining;
    }

    public int getSpecialVP() {
        return this.specialVP;
    }

    public void setSpecialVP(int svp) {
        this.specialVP = svp;
    }

    public int getPublicVP() {
        if (this.finalTotalVP > 0) {
            return this.finalTotalVP;
        }
        int vp = this.buildingVP + this.specialVP + this.numCloth / 2;
        if (this.hasLongestRoad()) {
            vp += 2;
        }
        if (this.hasLargestArmy()) {
            vp += 2;
        }
        return vp;
    }

    public int getTotalVP() {
        if (this.finalTotalVP > 0) {
            return this.finalTotalVP;
        }
        int vp = this.getPublicVP();
        return vp += this.inventory.getNumVPItems();
    }

    public void forceFinalVP(int score) {
        if (this.game.getGameState() != 1000) {
            return;
        }
        this.finalTotalVP = score;
    }

    public void addSpecialVPInfo(int svp, String desc) {
        if (this.svpInfo == null) {
            this.svpInfo = new ArrayList();
        }
        this.svpInfo.add(new SpecialVPInfo(svp, desc));
    }

    public ArrayList<SpecialVPInfo> getSpecialVPInfo() {
        return this.svpInfo;
    }

    public void setSpecialVPInfo(ArrayList<SpecialVPInfo> info) {
        if (info != null && info.isEmpty()) {
            info = null;
        }
        this.svpInfo = info;
    }

    public int getPlayerEvents() {
        return this.playerEvents_bitmask;
    }

    public void setPlayerEvents(int events) {
        this.playerEvents_bitmask = events;
    }

    public final boolean hasPlayerEvent(SOCPlayerEvent spe) {
        return 0 != (this.playerEvents_bitmask & spe.flagValue);
    }

    private final void setPlayerEvent(SOCPlayerEvent spe) throws IllegalStateException {
        int bit = spe.flagValue;
        if (this.game.isAtServer && 0 != (this.playerEvents_bitmask & bit)) {
            throw new IllegalStateException("Already set: 0x" + Integer.toHexString(bit));
        }
        this.playerEvents_bitmask |= bit;
    }

    private final void clearPlayerEvent(SOCPlayerEvent spe) {
        this.playerEvents_bitmask &= ~spe.flagValue;
    }

    public int getScenarioSVPLandAreas() {
        return this.scenario_svpFromEachLandArea_bitmask;
    }

    public void setScenarioSVPLandAreas(int las) {
        this.scenario_svpFromEachLandArea_bitmask = las;
    }

    public int getStartingLandAreasEncoded() {
        return this.startingLandArea2 << 8 | this.startingLandArea1;
    }

    public void setStartingLandAreasEncoded(int slas) {
        this.startingLandArea1 = slas & 0xFF;
        this.startingLandArea2 = slas >> 8 & 0xFF;
    }

    public Vector<Integer> getRoadNodes() {
        return this.roadNodes;
    }

    public SOCTradeOffer getCurrentOffer() {
        return this.currentOffer;
    }

    public void setCurrentOffer(SOCTradeOffer offer) {
        this.currentOffer = offer;
        this.currentOfferTimeMillis = System.currentTimeMillis();
    }

    public long getCurrentOfferTime() {
        return this.currentOfferTimeMillis;
    }

    public void makeTrade(ResourceSet give, ResourceSet get) {
        this.resources.add(get);
        this.resources.subtract(give, !this.game.isAtServer);
        this.tradeStatsGive[7].add(give);
        this.tradeStatsGet[7].add(get);
    }

    public void makeBankTrade(ResourceSet give, ResourceSet get) {
        this.resources.subtract(give, !this.game.isAtServer);
        this.resources.add(get);
        boolean notUndo = give.getTotal() > get.getTotal();
        SOCResourceSet gaveCopy = new SOCResourceSet(notUndo ? give : get);
        SOCResourceSet gotCopy = new SOCResourceSet(notUndo ? get : give);
        boolean has_3_1_port = this.ports[0];
        for (int rtype = 1; rtype <= 5; ++rtype) {
            int gotAmt;
            int statIndex;
            int amt = gaveCopy.getAmount(rtype);
            if (amt == 0) continue;
            if (this.ports[rtype]) {
                statIndex = rtype;
                gotAmt = amt / 2;
            } else {
                if (!has_3_1_port) continue;
                statIndex = 0;
                gotAmt = amt / 3;
            }
            gaveCopy.subtract(amt);
            SOCResourceSet gotForType = gotCopy.subtract(gotAmt);
            if (notUndo) {
                this.tradeStatsGive[statIndex].add(amt, rtype);
                this.tradeStatsGet[statIndex].add(gotForType);
                continue;
            }
            this.tradeStatsGive[statIndex].subtract(amt, rtype);
            this.tradeStatsGet[statIndex].subtract(gotForType);
        }
        if (gaveCopy.getTotal() > 0) {
            if (notUndo) {
                this.tradeStatsGive[6].add(gaveCopy);
                this.tradeStatsGet[6].add(gotCopy);
            } else {
                this.tradeStatsGive[6].subtract(gaveCopy);
                this.tradeStatsGet[6].subtract(gotCopy);
            }
        }
    }

    public boolean isConnectedByRoad(int node1, int node2) {
        int[] adjac = this.roadNodeGraph.get(node1);
        if (adjac == null) {
            return false;
        }
        for (int i = 2; i >= 0; --i) {
            if (node2 != adjac[i]) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceShip_debugFreePlace(int shipEdge) {
        if (!this.game.hasSeaBoard || this.playerNumber == this.game.getCurrentPlayerNumber()) {
            return true;
        }
        return !this.game.isGameOptionSet("_SC_FTRI") || !((SOCBoardLarge)this.game.getBoard()).canRemovePort(shipEdge);
    }

    public List<GameAction.Effect> putPiece(SOCPlayingPiece piece, boolean isTempPiece) throws IllegalArgumentException {
        List<GameAction.Effect> effects = null;
        if (piece.getPlayerNumber() == this.playerNumber) {
            if (!(piece instanceof SOCFortress)) {
                this.pieces.addElement(piece);
            }
            SOCBoard board = this.game.getBoard();
            switch (piece.getType()) {
                case 0: {
                    this.numPieces[0] = this.numPieces[0] - 1;
                    effects = this.putPiece_roadOrShip((SOCRoutePiece)piece, board, isTempPiece);
                    break;
                }
                case 1: {
                    List<GameAction.Effect> ef;
                    int newSettleArea;
                    List<SOCShip> newlyClosed;
                    int settlementNode = piece.getCoordinates();
                    if (this.fortress != null && this.fortress.getCoordinates() == settlementNode) {
                        this.fortress = null;
                        if (isTempPiece) {
                            throw new IllegalArgumentException("temporary fortress settlement");
                        }
                    } else {
                        this.numPieces[1] = this.numPieces[1] - 1;
                    }
                    if ((newlyClosed = this.putPiece_settlement_checkTradeRoutes((SOCSettlement)piece, board)) != null && this.game.isAtServer) {
                        if (effects == null) {
                            effects = new ArrayList<GameAction.Effect>();
                        }
                        int L = newlyClosed.size();
                        int[] edges = new int[L];
                        for (int i = 0; i < L; ++i) {
                            edges[i] = newlyClosed.get(i).getCoordinates();
                        }
                        effects.add(new GameAction.Effect(GameAction.EffectType.CLOSE_SHIP_ROUTE, edges));
                    }
                    this.settlements.addElement((SOCSettlement)piece);
                    this.lastSettlementCoord = settlementNode;
                    ++this.buildingVP;
                    this.ourNumbers.updateNumbers(piece, board);
                    int portType = board.getPortTypeFromNodeCoord(settlementNode);
                    if (portType != -1) {
                        this.setPortFlag(portType, true);
                    }
                    if (!(board instanceof SOCBoardLarge) || null == ((SOCBoardLarge)board).getLandAreasLegalNodes()) break;
                    if (this.game.isInitialPlacement()) {
                        newSettleArea = ((SOCBoardLarge)board).getNodeLandArea(settlementNode);
                        if (newSettleArea == 0) break;
                        if (this.startingLandArea1 == 0) {
                            this.startingLandArea1 = newSettleArea;
                            break;
                        }
                        if (this.startingLandArea2 != 0 || newSettleArea == this.startingLandArea1) break;
                        this.startingLandArea2 = newSettleArea;
                        break;
                    }
                    newSettleArea = ((SOCBoardLarge)board).getNodeLandArea(settlementNode);
                    if (newSettleArea == 0 || newSettleArea == this.startingLandArea1 || newSettleArea == this.startingLandArea2 || (ef = this.putPiece_settlement_checkScenarioSVPs((SOCSettlement)piece, newSettleArea, isTempPiece)) == null) break;
                    if (effects != null) {
                        effects.addAll(ef);
                        break;
                    }
                    effects = ef;
                    break;
                }
                case 2: {
                    this.numPieces[2] = this.numPieces[2] - 1;
                    this.cities.addElement((SOCCity)piece);
                    this.buildingVP += 2;
                    this.ourNumbers.updateNumbers(piece, board);
                    break;
                }
                case 3: {
                    this.numPieces[3] = this.numPieces[3] - 1;
                    effects = this.putPiece_roadOrShip((SOCShip)piece, board, isTempPiece);
                    break;
                }
                case 4: {
                    if (isTempPiece) {
                        throw new IllegalArgumentException("temporary fortress");
                    }
                    if (this.fortress != null) {
                        throw new IllegalArgumentException("already has fortress");
                    }
                    this.fortress = (SOCFortress)piece;
                }
            }
        }
        this.updatePotentials(piece);
        return effects;
    }

    private List<GameAction.Effect> putPiece_roadOrShip(SOCRoutePiece piece, SOCBoard board, boolean isTempPiece) {
        int j;
        List<GameAction.Effect> effects = null;
        if (piece instanceof SOCShip && !isTempPiece) {
            effects = this.putPiece_roadOrShip_checkNewShipTradeRouteAndSpecialEdges((SOCShip)piece, (SOCBoardLarge)board);
        }
        this.roadsAndShips.addElement(piece);
        this.lastRoadCoord = piece.getCoordinates();
        List<Integer> nodes = board.getAdjacentNodesToEdge(piece.getCoordinates());
        int[] nodeCoords = new int[2];
        int i = 0;
        for (Integer node : nodes) {
            nodeCoords[i] = node;
            ++i;
            if (this.roadNodes.contains(node)) continue;
            this.roadNodes.addElement(node);
        }
        int node0 = nodeCoords[0];
        int node1 = nodeCoords[1];
        Integer node0Int = node0;
        Integer node1Int = node1;
        int[] rnArr = this.roadNodeGraph.get(node0Int);
        if (rnArr == null) {
            rnArr = new int[3];
            this.roadNodeGraph.put(node0Int, rnArr);
            rnArr[0] = node1;
        } else {
            for (j = 0; j < 3 && node1 != rnArr[j]; ++j) {
                if (0 != rnArr[j]) continue;
                rnArr[j] = node1;
                break;
            }
        }
        rnArr = this.roadNodeGraph.get(node1Int);
        if (rnArr == null) {
            rnArr = new int[3];
            this.roadNodeGraph.put(node1Int, rnArr);
            rnArr[0] = node0;
        } else {
            for (j = 0; j < 3 && node0 != rnArr[j]; ++j) {
                if (0 != rnArr[j]) continue;
                rnArr[j] = node0;
                break;
            }
        }
        return effects;
    }

    private List<GameAction.Effect> putPiece_roadOrShip_checkNewShipTradeRouteAndSpecialEdges(SOCShip newShip, SOCBoardLarge board) throws IllegalArgumentException {
        int seType;
        if (this.game.isAtServer && this.game.getGameState() == 990) {
            return null;
        }
        boolean boardHasVillages = this.game.isGameOptionSet("_SC_CLVI");
        int edge = newShip.getCoordinates();
        int[] edgeNodes = board.getAdjacentNodesToEdge_arr(edge);
        ArrayList<GameAction.Effect> effects = null;
        List<SOCShip> allNewlyClosed = null;
        for (int i = 0; i < 2; ++i) {
            boolean flagNew;
            int edgeFarNode;
            List<SOCShip> closedRoute;
            SOCPlayingPiece pp = board.settlementAtNode(edgeNodes[i]);
            if (pp != null) {
                if (pp.getPlayerNumber() != this.playerNumber) {
                    pp = null;
                }
            } else if (boardHasVillages) {
                pp = board.getVillageAtNode(edgeNodes[i]);
            }
            if (pp == null || (closedRoute = this.checkTradeRouteFarEndClosed(newShip, edgeFarNode = edgeNodes[1 - i])) == null) continue;
            if (this.game.isAtServer) {
                if (allNewlyClosed != null) {
                    allNewlyClosed.addAll(closedRoute);
                } else {
                    allNewlyClosed = closedRoute;
                }
            }
            if (!(pp instanceof SOCVillage)) break;
            boolean gotCloth = ((SOCVillage)pp).addTradingPlayer(this);
            boolean bl = flagNew = !this.hasPlayerEvent(SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE);
            if (flagNew) {
                this.setPlayerEvent(SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE);
            }
            if (!flagNew && !gotCloth) break;
            if (this.game.gameEventListener != null) {
                this.game.gameEventListener.playerEvent(this.game, this, SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE, flagNew, pp);
            }
            if (!this.game.isAtServer) break;
            if (effects == null) {
                effects = new ArrayList();
            }
            if (flagNew) {
                effects.add(new GameAction.Effect(GameAction.EffectType.PLAYER_SET_EVENT_FLAGS, new int[]{SOCPlayerEvent.CLOTH_TRADE_ESTABLISHED_VILLAGE.flagValue, 1}));
            }
            if (!gotCloth) break;
            effects.add(new GameAction.Effect(GameAction.EffectType.PLAYER_SCEN_CLVI_RECEIVE_CLOTH, new int[]{1, pp.getCoordinates(), 1}));
            break;
        }
        if (allNewlyClosed != null && this.game.isAtServer) {
            int L = allNewlyClosed.size();
            int[] edges = new int[L];
            for (int i = 0; i < L; ++i) {
                edges[i] = ((SOCShip)allNewlyClosed.get(i)).getCoordinates();
            }
            if (effects == null) {
                effects = new ArrayList();
            }
            effects.add(new GameAction.Effect(GameAction.EffectType.CLOSE_SHIP_ROUTE, edges));
        }
        if ((seType = board.getSpecialEdgeType(edge)) != 0) {
            if (this.game.isAtServer && effects == null) {
                effects = new ArrayList<GameAction.Effect>();
            }
            switch (seType) {
                case 1: {
                    int cardtype;
                    board.setSpecialEdge(edge, 0);
                    if (this.game.isAtServer) {
                        Integer ctypeObj = board.drawItemFromStack();
                        cardtype = ctypeObj != null ? ctypeObj : 9;
                        newShip.player.getInventory().addDevCard(1, 1, cardtype);
                        effects.add(new GameAction.Effect(GameAction.EffectType.PLAYER_SCEN_FTRI_REACHED_SPECIAL_EDGE, new int[]{edge, seType, cardtype}));
                    } else {
                        cardtype = 0;
                    }
                    if (this.game.gameEventListener == null) break;
                    this.game.gameEventListener.playerEvent(this.game, newShip.player, SOCPlayerEvent.DEV_CARD_REACHED_SPECIAL_EDGE, false, new IntPair(edge, cardtype));
                    break;
                }
                case 2: {
                    board.setSpecialEdge(edge, 0);
                    ++this.specialVP;
                    ++newShip.specialVP;
                    if (newShip.specialVP == 1) {
                        newShip.specialVPEvent = SOCPlayerEvent.SVP_REACHED_SPECIAL_EDGE;
                    }
                    if (this.game.isAtServer) {
                        effects.add(new GameAction.Effect(GameAction.EffectType.PLAYER_SCEN_FTRI_REACHED_SPECIAL_EDGE, new int[]{edge, seType}));
                    }
                    if (this.game.gameEventListener == null) break;
                    this.game.gameEventListener.playerEvent(this.game, newShip.player, SOCPlayerEvent.SVP_REACHED_SPECIAL_EDGE, false, edge);
                    break;
                }
                default: {
                    System.err.println("L2549: warning: No handler for reaching SEType " + seType);
                }
            }
        }
        if (this.game.isGameOptionSet("_SC_FTRI") && board.canRemovePort(edge)) {
            SOCInventoryItem portItem = this.game.removePort(this, edge);
            int newGameState = this.game.getGameState();
            if (this.game.isAtServer && portItem != null && newGameState != 950) {
                if (effects == null) {
                    effects = new ArrayList();
                }
                effects.add(new GameAction.Effect(GameAction.EffectType.GAME_SCEN_FTRI_PORT_REMOVED, new int[]{edge, -portItem.itype}));
                if (newGameState != 42) {
                    effects.add(new GameAction.Effect(GameAction.EffectType.PLAYER_GAIN_INVENTORY_ITEM, new int[]{portItem.itype, portItem.isPlayable() ? 1 : 0, portItem.isKept() ? 1 : 0, portItem.isVPItem() ? 1 : 0, portItem.canCancelPlay ? 1 : 0}));
                }
            }
        }
        return effects;
    }

    private List<SOCShip> putPiece_settlement_checkTradeRoutes(SOCSettlement newSettle, SOCBoard board) {
        List<SOCShip> newlyClosed = null;
        int[] nodeEdges = board.getAdjacentEdgesToNode_arr(newSettle.getCoordinates());
        for (int i = 0; i < 3; ++i) {
            int edgeFarNode;
            List<SOCShip> segment;
            SOCShip sh;
            SOCRoutePiece pp;
            int edge = nodeEdges[i];
            if (edge == -9 || !((pp = this.getRoadOrShip(edge)) instanceof SOCShip) || (sh = (SOCShip)pp).isClosed() || (segment = this.checkTradeRouteFarEndClosed(sh, edgeFarNode = ((SOCBoardLarge)board).getAdjacentNodeFarEndOfEdge(edge, newSettle.getCoordinates()))) == null) continue;
            if (newlyClosed != null) {
                newlyClosed.addAll(segment);
                continue;
            }
            newlyClosed = segment;
        }
        return newlyClosed;
    }

    private final List<GameAction.Effect> putPiece_settlement_checkScenarioSVPs(SOCSettlement newSettle, int newSettleArea, boolean isTempPiece) {
        int laBit;
        ArrayList<GameAction.Effect> effects = null;
        if (!this.hasPlayerEvent(SOCPlayerEvent.SVP_SETTLED_ANY_NEW_LANDAREA) && this.game.isGameOptionSet("_SC_SANY")) {
            int prevSVP = this.specialVP++;
            int prevEvents = this.getPlayerEvents();
            this.setPlayerEvent(SOCPlayerEvent.SVP_SETTLED_ANY_NEW_LANDAREA);
            newSettle.specialVP = 1;
            newSettle.specialVPEvent = SOCPlayerEvent.SVP_SETTLED_ANY_NEW_LANDAREA;
            if (!isTempPiece) {
                if (this.game.gameEventListener != null) {
                    this.game.gameEventListener.playerEvent(this.game, this, SOCPlayerEvent.SVP_SETTLED_ANY_NEW_LANDAREA, true, newSettle);
                }
                if (this.game.isAtServer) {
                    if (effects == null) {
                        effects = new ArrayList<GameAction.Effect>();
                    }
                    effects.add(new GameAction.Effect(GameAction.EffectType.PLAYER_GAIN_SVP, new int[]{prevSVP, 1, prevEvents, SOCPlayerEvent.SVP_SETTLED_ANY_NEW_LANDAREA.flagValue}));
                }
            }
        }
        if (0 == ((laBit = 1 << newSettleArea - 1) & this.scenario_svpFromEachLandArea_bitmask) && this.game.isGameOptionSet("_SC_SEAC")) {
            int prevSVP = this.specialVP;
            int prevLAs = this.scenario_svpFromEachLandArea_bitmask;
            this.scenario_svpFromEachLandArea_bitmask |= laBit;
            this.specialVP += 2;
            newSettle.specialVP = 2;
            newSettle.specialVPEvent = SOCPlayerEvent.SVP_SETTLED_EACH_NEW_LANDAREA;
            if (!isTempPiece) {
                if (this.game.gameEventListener != null) {
                    this.game.gameEventListener.playerEvent(this.game, this, SOCPlayerEvent.SVP_SETTLED_EACH_NEW_LANDAREA, true, newSettle);
                }
                if (this.game.isAtServer) {
                    if (effects == null) {
                        effects = new ArrayList();
                    }
                    effects.add(new GameAction.Effect(GameAction.EffectType.PLAYER_GAIN_SETTLED_LANDAREA, new int[]{prevSVP, prevLAs, this.scenario_svpFromEachLandArea_bitmask}));
                }
            }
        }
        return effects;
    }

    public void undoPutPiece(SOCPlayingPiece piece) {
        this.undoPutPiece(piece, false);
    }

    public void undoPutPiece(SOCPlayingPiece piece, boolean isMoveOrReplacement) {
        boolean ours = piece.getPlayerNumber() == this.playerNumber;
        int pieceCoord = piece.getCoordinates();
        Integer pieceCoordInt = pieceCoord;
        SOCBoard board = this.game.getBoard();
        switch (piece.getType()) {
            case 0: 
            case 3: {
                boolean isCoastline;
                if (ours) {
                    this.removePiece(piece, null, isMoveOrReplacement);
                    break;
                }
                boolean bl = isCoastline = this.game.hasSeaBoard && ((SOCBoardLarge)board).isEdgeCoastline(pieceCoord);
                if (piece.getType() == 0) {
                    this.legalRoads.add(pieceCoordInt);
                    if (isCoastline && (this.legalShipsRestricted == null || this.legalShipsRestricted.contains(pieceCoordInt))) {
                        this.legalShips.add(pieceCoordInt);
                    }
                } else {
                    if (this.legalShipsRestricted == null || this.legalShipsRestricted.contains(pieceCoordInt)) {
                        this.legalShips.add(pieceCoordInt);
                    }
                    if (isCoastline) {
                        this.legalRoads.add(pieceCoordInt);
                    }
                }
                List<Integer> adjEdges = board.getAdjacentEdgesToEdge(pieceCoord);
                for (SOCRoutePiece rs : this.roadsAndShips) {
                    for (Integer edgeObj : adjEdges) {
                        int edge = edgeObj;
                        if (rs.getCoordinates() != edge) continue;
                        this.updatePotentials(rs);
                    }
                }
                break;
            }
            case 1: {
                if (ours) {
                    this.removePiece(piece, null, isMoveOrReplacement);
                    this.ourNumbers.undoUpdateNumbers(piece, board);
                    int portType = board.getPortTypeFromNodeCoord(pieceCoord);
                    if (portType != -1) {
                        this.updatePortFlagsAfterRemove(portType, false);
                    }
                }
                this.undoPutPieceAuxSettlement(pieceCoord);
                for (int adjNode : board.getAdjacentNodesToNode(pieceCoord)) {
                    this.undoPutPieceAuxSettlement(adjNode);
                }
                if (!ours || this.game.getGameState() != 11 && this.game.getGameState() != 13) break;
                this.resources.clear();
                break;
            }
            case 2: {
                if (!ours) break;
                this.removePiece(piece, null, isMoveOrReplacement);
                this.potentialCities.add(pieceCoordInt);
                this.ourNumbers.undoUpdateNumbers(piece, board);
                this.ourNumbers.undoUpdateNumbers(piece, board);
            }
        }
    }

    protected void undoPutPieceAuxSettlement(int settlementNode) {
        int adjNode;
        Iterator<Serializable> iterator;
        Integer settleNodeInt = settlementNode;
        boolean haveNeighbor = false;
        SOCBoard board = this.game.getBoard();
        List<Integer> adjNodes = board.getAdjacentNodesToNode(settlementNode);
        for (SOCSettlement settlement : board.getSettlements()) {
            iterator = adjNodes.iterator();
            while (iterator.hasNext()) {
                adjNode = iterator.next();
                if (adjNode != settlement.getCoordinates()) continue;
                haveNeighbor = true;
                break;
            }
            if (!haveNeighbor) continue;
            break;
        }
        if (!haveNeighbor) {
            for (SOCCity city : board.getCities()) {
                iterator = adjNodes.iterator();
                while (iterator.hasNext()) {
                    adjNode = iterator.next();
                    if (adjNode != city.getCoordinates()) continue;
                    haveNeighbor = true;
                    break;
                }
                if (!haveNeighbor) continue;
                break;
            }
            if (!haveNeighbor && board.isNodeOnLand(settlementNode)) {
                this.legalSettlements.add(settleNodeInt);
                if (this.game.getGameState() < 15) {
                    this.potentialSettlements.add(settleNodeInt);
                } else {
                    boolean adjRoad = false;
                    List<Integer> adjEdges = board.getAdjacentEdgesToNode(settlementNode);
                    for (SOCRoutePiece rs : this.roadsAndShips) {
                        for (int adjEdge : adjEdges) {
                            if (rs.getCoordinates() != adjEdge) continue;
                            adjRoad = true;
                            break;
                        }
                        if (!adjRoad) continue;
                        break;
                    }
                    if (adjRoad) {
                        this.potentialSettlements.add(settleNodeInt);
                    }
                }
            }
        }
    }

    public void removePiece(SOCPlayingPiece piece, SOCPlayingPiece replacementPiece) {
        this.removePiece(piece, replacementPiece, false);
    }

    public void removePiece(SOCPlayingPiece piece, SOCPlayingPiece replacementPiece, boolean isMoveOrReplacement) {
        D.ebugPrintlnINFO("--- SOCPlayer.removePiece(" + piece + ")");
        int pieceCoord = piece.getCoordinates();
        Integer pieceCoordInt = pieceCoord;
        int ptype = piece.getType();
        Enumeration<SOCPlayingPiece> pEnum = this.pieces.elements();
        SOCBoard board = this.game.getBoard();
        block5: while (pEnum.hasMoreElements()) {
            SOCPlayingPiece p = pEnum.nextElement();
            if (ptype != p.getType() || pieceCoord != p.getCoordinates()) continue;
            this.pieces.removeElement(p);
            if (p.specialVP != 0) {
                if (replacementPiece == null || replacementPiece.player != piece.player) {
                    if (!isMoveOrReplacement) {
                        this.removePieceUpdateSpecialVP(p);
                    }
                } else {
                    replacementPiece.specialVP = p.specialVP;
                    replacementPiece.specialVPEvent = p.specialVPEvent;
                }
            }
            switch (ptype) {
                case 0: 
                case 3: {
                    boolean isCoastlineTransition;
                    int j;
                    int shipsPlaced;
                    this.roadsAndShips.removeElement(p);
                    int n = ptype;
                    this.numPieces[n] = this.numPieces[n] + 1;
                    if (ptype == 3 && this.numWarships > (shipsPlaced = 15 - this.numPieces[ptype])) {
                        this.numWarships = shipsPlaced;
                    }
                    int[] edgeNodeCoords = new int[2];
                    List<Integer> nodes = board.getAdjacentNodesToEdge(pieceCoord);
                    int i = 0;
                    for (Integer nodeInt : nodes) {
                        edgeNodeCoords[i] = nodeInt;
                        ++i;
                        List<Integer> adjEdges = board.getAdjacentEdgesToNode(nodeInt);
                        boolean match = false;
                        for (SOCRoutePiece rs : this.roadsAndShips) {
                            int rdEdge = rs.getCoordinates();
                            Iterator iterator = adjEdges.iterator();
                            while (iterator.hasNext()) {
                                int adjEdge = (Integer)iterator.next();
                                if (rdEdge != adjEdge) continue;
                                match = true;
                                break;
                            }
                            if (!match) continue;
                            break;
                        }
                        if (match) continue;
                        this.roadNodes.removeElement(nodeInt);
                        this.potentialSettlements.remove(nodeInt);
                    }
                    int node0 = edgeNodeCoords[0];
                    int node1 = edgeNodeCoords[1];
                    Integer node0Int = node0;
                    Integer node1Int = node1;
                    int[] rnArr = this.roadNodeGraph.get(node0Int);
                    if (rnArr != null) {
                        for (j = 0; j < 3; ++j) {
                            if (node1 != rnArr[j]) continue;
                            rnArr[j] = 0;
                            break;
                        }
                    }
                    if ((rnArr = this.roadNodeGraph.get(node1Int)) != null) {
                        for (j = 0; j < 3; ++j) {
                            if (node0 != rnArr[j]) continue;
                            rnArr[j] = 0;
                            break;
                        }
                    }
                    boolean bl = this.game.hasSeaBoard && ((SOCBoardLarge)board).isEdgeCoastline(pieceCoord) && this.doesTradeRouteContinuePastEdge(pieceCoord, ptype == 0) ? true : (isCoastlineTransition = false);
                    if (ptype == 0) {
                        this.potentialRoads.add(pieceCoordInt);
                        this.legalRoads.add(pieceCoordInt);
                        if (isCoastlineTransition && (this.legalShipsRestricted == null || this.legalShipsRestricted.contains(pieceCoordInt))) {
                            this.potentialShips.add(pieceCoordInt);
                            this.legalShips.add(pieceCoordInt);
                        }
                    } else {
                        this.potentialShips.add(pieceCoordInt);
                        this.legalShips.add(pieceCoordInt);
                        if (isCoastlineTransition) {
                            this.potentialRoads.add(pieceCoordInt);
                            this.legalRoads.add(pieceCoordInt);
                        }
                    }
                    List<Integer> adjEdges = board.getAdjacentEdgesToEdge(pieceCoord);
                    for (Integer adjEdge : adjEdges) {
                        int nodeBetween;
                        SOCPlayingPiece settleBetween;
                        if (!this.potentialRoads.contains(adjEdge) && !this.potentialShips.contains(adjEdge) || (settleBetween = board.settlementAtNode(nodeBetween = board.getNodeBetweenAdjacentEdges(adjEdge, pieceCoord))) != null && settleBetween.getPlayerNumber() == this.playerNumber) continue;
                        boolean isPotentialRoad = false;
                        int adjEdgeID = adjEdge;
                        int[] adjNodes = board.getAdjacentNodesToEdge_arr(adjEdgeID);
                        block12: for (int ni = 0; ni < 2 && !isPotentialRoad; ++ni) {
                            SOCPlayingPiece aPiece;
                            boolean blocked = false;
                            int adjNode = adjNodes[ni];
                            SOCPlayingPiece sOCPlayingPiece = aPiece = adjNode == nodeBetween ? settleBetween : board.settlementAtNode(adjNode);
                            if (aPiece != null && aPiece.getPlayerNumber() != this.playerNumber) {
                                blocked = true;
                            }
                            if (blocked) continue;
                            for (int adjAdjEdge : board.getAdjacentEdgesToNode(adjNode)) {
                                if (adjAdjEdge != adjEdgeID) {
                                    for (SOCRoutePiece ourRS : this.roadsAndShips) {
                                        if (ourRS.getCoordinates() != adjAdjEdge) continue;
                                        isPotentialRoad = true;
                                        break;
                                    }
                                }
                                if (!isPotentialRoad) continue;
                                continue block12;
                            }
                        }
                        if (ptype == 0) {
                            if (isPotentialRoad && this.legalRoads.contains(adjEdge)) {
                                this.potentialRoads.add(adjEdge);
                                continue;
                            }
                            this.potentialRoads.remove(adjEdge);
                            continue;
                        }
                        if (isPotentialRoad && this.legalShips.contains(adjEdge)) {
                            this.potentialShips.add(adjEdge);
                            continue;
                        }
                        this.potentialShips.remove(adjEdge);
                    }
                    break block5;
                }
                case 1: {
                    this.settlements.removeElement(p);
                    this.numPieces[1] = this.numPieces[1] + 1;
                    --this.buildingVP;
                    break;
                }
                case 2: {
                    this.cities.removeElement(p);
                    this.numPieces[2] = this.numPieces[2] + 1;
                    this.buildingVP -= 2;
                }
            }
            break;
        }
    }

    private final void removePieceUpdateSpecialVP(SOCPlayingPiece p) {
        if (this.game.getGameState() == 950) {
            return;
        }
        this.specialVP -= p.specialVP;
        switch (p.specialVPEvent) {
            case SVP_SETTLED_ANY_NEW_LANDAREA: {
                this.clearPlayerEvent(p.specialVPEvent);
                break;
            }
        }
    }

    void updatePortFlagsAfterRemove(int portType, boolean removedPort) {
        boolean wasOurSolePortOfType;
        SOCBoard board = this.game.getBoard();
        int nPort = board.getPortCoordinates(portType).size() / 2;
        boolean bl = removedPort ? nPort == 0 : (wasOurSolePortOfType = nPort <= 1);
        if (wasOurSolePortOfType) {
            this.setPortFlag(portType, false);
        } else {
            boolean havePortType = false;
            for (SOCSettlement settlement : this.settlements) {
                if (board.getPortTypeFromNodeCoord(settlement.getCoordinates()) != portType) continue;
                havePortType = true;
                break;
            }
            if (!havePortType) {
                for (SOCCity city : this.cities) {
                    if (board.getPortTypeFromNodeCoord(city.getCoordinates()) != portType) continue;
                    havePortType = true;
                    break;
                }
            }
            this.setPortFlag(portType, havePortType);
        }
    }

    void updateLegalShipsAddHex(int hexCoord) {
        SOCBoardLarge board = (SOCBoardLarge)this.game.getBoard();
        int htype = board.getHexTypeFromCoord(hexCoord);
        if (htype != 0 && !board.isHexAtBoardMargin(hexCoord)) {
            return;
        }
        for (int edge : board.getAdjacentEdgesToHex_arr(hexCoord)) {
            if (htype != 0 && !board.isEdgeCoastline(edge)) continue;
            Integer edgeInt = edge;
            if (this.legalShipsRestricted != null && !this.legalShipsRestricted.contains(edgeInt)) continue;
            this.legalShips.add(edgeInt);
        }
    }

    void updatePotentialsAndLegalsAroundRevealedHex(int hexCoord) {
        SOCBoardLarge board = (SOCBoardLarge)this.game.getBoard();
        for (Integer edgeObj : board.getAdjacentEdgesToHex(hexCoord)) {
            if (!this.legalRoads.contains(edgeObj) || board.isEdgeLegalRoad(edgeObj)) continue;
            this.legalRoads.remove(edgeObj);
            this.potentialRoads.remove(edgeObj);
        }
        for (Integer nodeObj : board.getAdjacentNodesToHex(hexCoord)) {
            if (!this.legalSettlements.contains(nodeObj) || board.isNodeOnLand(nodeObj)) continue;
            this.legalSettlements.remove(nodeObj);
            this.potentialSettlements.remove(nodeObj);
        }
    }

    public void updatePotentials(SOCPlayingPiece piece) {
        int id = piece.getCoordinates();
        Integer idInt = id;
        SOCBoard board = this.game.getBoard();
        boolean ours = piece.getPlayerNumber() == this.playerNumber;
        int ptype = piece.getType();
        switch (ptype) {
            case 0: 
            case 3: {
                int edge;
                int[] edges;
                int node;
                int ni;
                this.potentialRoads.remove(idInt);
                this.legalRoads.remove(idInt);
                this.potentialShips.remove(idInt);
                this.legalShips.remove(idInt);
                if (!ours) break;
                int[] nodes = board.getAdjacentNodesToEdge_arr(id);
                for (ni = 0; ni < 2; ++ni) {
                    node = nodes[ni];
                    boolean blocked = false;
                    SOCPlayingPiece p = board.settlementAtNode(node);
                    if (p != null && p.getPlayerNumber() != this.playerNumber) {
                        blocked = true;
                    }
                    if (blocked) continue;
                    edges = board.getAdjacentEdgesToNode_arr(node);
                    for (int i = 0; i < 3; ++i) {
                        edge = edges[i];
                        if (edge == -9) continue;
                        Integer edgeInt = edge;
                        if (ptype == 0) {
                            if (!this.legalRoads.contains(edgeInt)) continue;
                            this.potentialRoads.add(edgeInt);
                            continue;
                        }
                        if (!this.legalShips.contains(edgeInt)) continue;
                        this.potentialShips.add(edgeInt);
                    }
                    Integer nodeInt = node;
                    if (!this.legalSettlements.contains(nodeInt)) continue;
                    this.potentialSettlements.add(nodeInt);
                }
                if (ptype != 3 || !this.game.isGameOptionSet("_SC_PIRI")) break;
                for (ni = 0; ni < 2; ++ni) {
                    int i;
                    node = nodes[ni];
                    boolean foundOtherShips = false;
                    edges = board.getAdjacentEdgesToNode_arr(node);
                    for (i = 0; i < 3; ++i) {
                        edge = edges[i];
                        if (edge == -9 || edge == id || !(this.getRoadOrShip(edge) instanceof SOCShip)) continue;
                        foundOtherShips = true;
                        break;
                    }
                    if (!foundOtherShips) continue;
                    for (i = 0; i < 3; ++i) {
                        this.potentialShips.remove(edges[i]);
                    }
                }
                break;
            }
            case 1: {
                int i;
                this.potentialSettlements.remove(idInt);
                this.legalSettlements.remove(idInt);
                int[] adjac = board.getAdjacentNodesToNode_arr(id);
                for (i = 0; i < 3; ++i) {
                    if (adjac[i] == -9) continue;
                    Integer adjacNodeInt = adjac[i];
                    this.potentialSettlements.remove(adjacNodeInt);
                    this.legalSettlements.remove(adjacNodeInt);
                }
                if (ours) {
                    this.potentialCities.add(idInt);
                    adjac = board.getAdjacentEdgesToNode_arr(id);
                    for (i = 0; i < 3; ++i) {
                        int tmp = adjac[i];
                        if (tmp == -9) continue;
                        Integer tmpEdgeInt = tmp;
                        if (this.legalRoads.contains(tmpEdgeInt)) {
                            this.potentialRoads.add(tmpEdgeInt);
                        }
                        if (!this.legalShips.contains(tmpEdgeInt)) continue;
                        this.potentialShips.add(tmpEdgeInt);
                    }
                } else {
                    HashSet<Integer> ourRoads = new HashSet<Integer>();
                    for (SOCPlayingPiece p : this.pieces) {
                        if (!(p instanceof SOCRoutePiece)) continue;
                        ourRoads.add(p.getCoordinates());
                    }
                    adjac = board.getAdjacentEdgesToNode_arr(id);
                    for (int i2 = 0; i2 < 3; ++i2) {
                        Integer tmpInt;
                        int tmp = adjac[i2];
                        if (tmp == -9 || !this.potentialRoads.contains(tmpInt = Integer.valueOf(tmp)) && !this.potentialShips.contains(tmpInt)) continue;
                        int[] enodes = board.getAdjacentNodesToEdge_arr(tmp);
                        int farNode = enodes[0] == id ? enodes[1] : enodes[0];
                        int[] farEdges = board.getAdjacentEdgesToNode_arr(farNode);
                        boolean foundOurRoad = false;
                        for (int ie = 0; ie < 3; ++ie) {
                            int farEdge = farEdges[ie];
                            if (farEdge == tmp || !ourRoads.contains(farEdge)) continue;
                            foundOurRoad = true;
                            break;
                        }
                        if (foundOurRoad) continue;
                        this.potentialRoads.remove(tmpInt);
                        this.potentialShips.remove(tmpInt);
                    }
                }
                break;
            }
            case 2: {
                this.potentialCities.remove(idInt);
            }
        }
    }

    public HashSet<Integer> getPotentialSettlements() {
        return this.potentialSettlements;
    }

    public int[] getPotentialSettlements_arr() {
        int L = this.potentialSettlements.size();
        if (L == 0) {
            return null;
        }
        int[] pset = new int[L];
        Iterator<Integer> it = this.potentialSettlements.iterator();
        int i = 0;
        while (it.hasNext()) {
            pset[i] = it.next();
            ++i;
        }
        return pset;
    }

    public void setPotentialAndLegalSettlements(Collection<Integer> psList, boolean setLegalsToo, HashSet<Integer>[] legalLandAreaNodes) throws NullPointerException {
        SOCBoardLarge board;
        this.clearPotentialSettlements();
        this.potentialSettlements.addAll(psList);
        this.hasPotentialSettlesInitInFog = false;
        if (this.game.hasSeaBoard && !psList.isEmpty() && this.game.getGameState() < 15) {
            board = (SOCBoardLarge)this.game.getBoard();
            HashSet<Integer> fogNodes = new HashSet<Integer>();
            for (int hex : board.getFogHiddenHexes().keySet()) {
                fogNodes.addAll(board.getAdjacentNodesToHex(hex));
            }
            fogNodes.retainAll(psList);
            boolean bl = this.hasPotentialSettlesInitInFog = !fogNodes.isEmpty();
        }
        if (setLegalsToo && this.game.hasSeaBoard) {
            this.legalSettlements.clear();
            board = (SOCBoardLarge)this.game.getBoard();
            if (legalLandAreaNodes != null) {
                for (int i = 1; i < legalLandAreaNodes.length; ++i) {
                    this.legalSettlements.addAll(legalLandAreaNodes[i]);
                }
            } else {
                this.legalSettlements.addAll(board.getLegalSettlements());
            }
            this.legalRoads = this.game.getBoard().initPlayerLegalRoads();
            if (!board.getLandHexCoordsSet().isEmpty()) {
                if (!this.game.isGameOptionSet("_SC_PIRI")) {
                    this.legalShips = board.initPlayerLegalShips();
                } else {
                    this.legalShips.clear();
                }
            }
        }
    }

    public boolean hasPotentialSettlementsInitialInFog() {
        return this.hasPotentialSettlesInitInFog;
    }

    public Set<Integer> getLegalSettlements() {
        return this.legalSettlements;
    }

    public void addLegalSettlement(int node, boolean checkAdjacents) {
        if (node == 0) {
            return;
        }
        if (checkAdjacents) {
            SOCBoard board = this.game.getBoard();
            int[] adjacNodes = board.getAdjacentNodesToNode_arr(node);
            for (int i = 0; i < 3; ++i) {
                if (adjacNodes[i] == -9 || null == board.settlementAtNode(adjacNodes[i])) continue;
                return;
            }
        }
        this.legalSettlements.add(node);
        this.addedLegalSettlement = node;
    }

    public boolean canPlaceSettlement(int node) {
        SOCBoardLarge board;
        if (!this.isPotentialSettlement(node)) {
            return false;
        }
        return !this.game.hasSeaBoard || !(board = (SOCBoardLarge)this.game.getBoard()).isNodeInLandAreas(node, board.getPlayerExcludedLandAreas());
    }

    public boolean isPotentialSettlement(int node) {
        return this.potentialSettlements.contains(node);
    }

    public void clearPotentialSettlement(int node) {
        this.potentialSettlements.remove(node);
    }

    public boolean isLegalSettlement(int node) {
        return this.legalSettlements.contains(node);
    }

    public int getAddedLegalSettlement() {
        return this.addedLegalSettlement;
    }

    public boolean isPotentialCity(int node) {
        return this.potentialCities.contains(node);
    }

    public void clearPotentialCity(int node) {
        this.potentialCities.remove(node);
    }

    public boolean isPotentialRoad(int edge) {
        if (edge == -1) {
            edge = 0;
        }
        return this.potentialRoads.contains(edge);
    }

    public void clearPotentialRoad(int edge) {
        if (edge == -1) {
            edge = 0;
        }
        this.potentialRoads.remove(edge);
    }

    public boolean isLegalRoad(int edge) {
        if (edge == -1) {
            edge = 0;
        } else if (edge < 0) {
            return false;
        }
        return this.legalRoads.contains(edge);
    }

    public boolean isPotentialShipMoveTo(int toEdge, int fromEdge) {
        int[] edgeNodes;
        SOCBoard board;
        SOCPlayingPiece pp;
        if (!this.potentialShips.contains(toEdge)) {
            if (this.game.isGameOptionSet("_SC_PIRI") && null != this.legalShipsRestricted) {
                if (this.getRoadOrShip(toEdge) != null || !this.legalShipsRestricted.contains(toEdge)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((pp = (board = this.game.getBoard()).settlementAtNode((edgeNodes = board.getAdjacentNodesToEdge_arr(toEdge))[0])) != null && pp.getPlayerNumber() != this.playerNumber) {
            pp = null;
        }
        if (pp != null || this.doesTradeRouteContinuePastNode(board, true, toEdge, fromEdge, edgeNodes[0])) {
            return true;
        }
        pp = board.settlementAtNode(edgeNodes[1]);
        if (pp != null && pp.getPlayerNumber() != this.playerNumber) {
            pp = null;
        }
        return pp != null || this.doesTradeRouteContinuePastNode(board, true, toEdge, fromEdge, edgeNodes[1]);
    }

    public boolean isPotentialShip(int edge) {
        return this.potentialShips.contains(edge);
    }

    public void clearPotentialShip(int edge) {
        this.potentialShips.remove(edge);
    }

    public boolean isLegalShip(int edge) {
        if (edge < 0) {
            return false;
        }
        return this.legalShips.contains(edge);
    }

    public HashSet<Integer> getRestrictedLegalShips() {
        return this.legalShipsRestricted;
    }

    public void setRestrictedLegalShips(int[] edgeList) {
        if (this.legalShipsRestricted != null) {
            this.legalShipsRestricted.clear();
        }
        if (edgeList == null) {
            if (this.legalShipsRestricted != null) {
                this.legalShipsRestricted = null;
                this.legalShips.addAll(((SOCBoardLarge)this.game.getBoard()).initPlayerLegalShips());
            }
            return;
        }
        HashSet<Integer> lse = this.legalShipsRestricted;
        if (lse == null) {
            lse = new HashSet();
            this.legalShipsRestricted = lse;
        }
        for (int i = 0; i < edgeList.length; ++i) {
            int edge = edgeList[i];
            if (edge > 0) {
                lse.add(edge);
                continue;
            }
            int incr = 0 == ((edge = -edge) & 0x100) ? 1 : 2;
            for (int ed = edgeList[i - 1] + incr; ed <= edge; ed += incr) {
                lse.add(ed);
            }
        }
        this.legalShips.clear();
        this.legalShips.addAll(lse);
    }

    public boolean hasPotentialRoad() {
        return !this.potentialRoads.isEmpty();
    }

    public boolean hasTwoPotentialRoads() {
        int S = this.potentialRoads.size();
        if (S == 0) {
            return false;
        }
        if (S > 1) {
            return true;
        }
        Integer[] edges = this.potentialRoads.toArray(new Integer[1]);
        if (edges == null || edges.length == 0) {
            return false;
        }
        SOCRoad tmpRoad = new SOCRoad(this, (int)edges[0], null);
        this.game.putTempPiece(tmpRoad);
        boolean hasAnother = !this.potentialRoads.isEmpty();
        this.game.undoPutTempPiece(tmpRoad);
        return hasAnother;
    }

    public boolean hasPotentialSettlement() {
        return !this.potentialSettlements.isEmpty();
    }

    public boolean hasPotentialCity() {
        return !this.potentialCities.isEmpty();
    }

    public boolean hasPotentialShip() {
        return !this.potentialShips.isEmpty();
    }

    public boolean canBuildInitialPieceType(int pieceType) throws IllegalStateException {
        boolean ok;
        if (this.game.getGameState() > 13) {
            throw new IllegalStateException();
        }
        int pieceCountMax = this.game.isGameOptionSet("_SC_3IP") ? 6 : 4;
        int pieceCount = this.pieces.size();
        if (pieceCount >= pieceCountMax) {
            return true;
        }
        boolean pieceCountOdd = pieceCount % 2 == 1;
        switch (pieceType) {
            case 1: {
                ok = !pieceCountOdd;
                break;
            }
            case 3: {
                if (!this.game.hasSeaBoard) {
                    return false;
                }
            }
            case 0: {
                ok = pieceCountOdd;
                break;
            }
            default: {
                ok = false;
            }
        }
        return ok;
    }

    public int calcLongestRoad2() {
        this.lrPaths.removeAllElements();
        SOCBoard board = this.game.getBoard();
        Stack<NodeLenVis<Object>> pending = new Stack<NodeLenVis<Object>>();
        int longest = 0;
        for (Integer rn : this.roadNodes) {
            int pathStartNodeCoord = rn;
            pending.push(new NodeLenVis(pathStartNodeCoord, 0, new Vector()));
            while (!pending.isEmpty()) {
                SOCPlayingPiece settlementAtNodeCoord;
                NodeLenVis curNode = (NodeLenVis)pending.pop();
                int coord = curNode.node;
                int len = curNode.len;
                Vector<IntPair> visited = curNode.vis;
                boolean pathEnd = false;
                if (len > 0) {
                    settlementAtNodeCoord = board.settlementAtNode(coord);
                    if (settlementAtNodeCoord != null && settlementAtNodeCoord.getPlayerNumber() != this.playerNumber) {
                        pathEnd = true;
                    }
                } else {
                    settlementAtNodeCoord = null;
                }
                if (!pathEnd) {
                    pathEnd = true;
                    int[] adjacNodes = board.getAdjacentNodesToNode_arr(coord);
                    for (int ni = adjacNodes.length - 1; ni >= 0; --ni) {
                        Object rsFromNode;
                        int j = adjacNodes[ni];
                        if (j == -9 || !this.isConnectedByRoad(coord, j)) continue;
                        if (this.game.hasSeaBoard) {
                            rsFromNode = this.getRoadOrShip(board.getEdgeBetweenAdjacentNodes(coord, j));
                            if (len > 0 && (rsFromNode == null || ((SOCRoutePiece)rsFromNode).isRoadNotShip() != curNode.inboundRS.isRoadNotShip() && settlementAtNodeCoord == null)) {
                                continue;
                            }
                        } else {
                            rsFromNode = null;
                        }
                        IntPair pair = new IntPair(coord, j);
                        boolean match = false;
                        for (IntPair vis : visited) {
                            if (!vis.equals(pair)) continue;
                            match = true;
                            break;
                        }
                        if (match) continue;
                        Vector<IntPair> newVis = new Vector<IntPair>(visited);
                        newVis.addElement(pair);
                        pending.push(new NodeLenVis<IntPair>(j, len + 1, newVis, (SOCRoutePiece)rsFromNode));
                        pathEnd = false;
                    }
                }
                if (!pathEnd) continue;
                if (len > longest) {
                    longest = len;
                }
                boolean addNewPath = true;
                Vector<SOCLRPathData> trash = new Vector<SOCLRPathData>();
                for (SOCLRPathData oldPathData : this.lrPaths) {
                    Vector<IntPair> nodePairs = oldPathData.getNodePairs();
                    boolean intersection = false;
                    for (IntPair vis : visited) {
                        for (IntPair np : nodePairs) {
                            if (!np.equals(vis)) continue;
                            intersection = true;
                            break;
                        }
                        if (!intersection) continue;
                        break;
                    }
                    if (!intersection) continue;
                    if (oldPathData.getLength() < len) {
                        trash.addElement(oldPathData);
                        continue;
                    }
                    addNewPath = false;
                }
                if (!trash.isEmpty()) {
                    for (SOCLRPathData oldPathData : trash) {
                        this.lrPaths.removeElement(oldPathData);
                    }
                }
                if (!addNewPath) continue;
                SOCLRPathData newPathData = new SOCLRPathData(pathStartNodeCoord, coord, len, visited);
                this.lrPaths.addElement(newPathData);
            }
        }
        this.longestRoadLength = longest;
        return longest;
    }

    public List<Integer> getPortMovePotentialLocations(boolean all) {
        int node;
        if (!this.game.hasSeaBoard) {
            return null;
        }
        SOCBoardLarge board = (SOCBoardLarge)this.game.getBoard();
        ArrayList<Integer> coastalNodes = new ArrayList<Integer>();
        for (SOCPlayingPiece iterator : this.settlements) {
            node = iterator.getCoordinates();
            if (!board.isNodeCoastline(node) || -1 != board.getPortTypeFromNodeCoord(node)) continue;
            coastalNodes.add(node);
        }
        for (SOCPlayingPiece sOCPlayingPiece : this.cities) {
            node = sOCPlayingPiece.getCoordinates();
            if (!board.isNodeCoastline(node) || -1 != board.getPortTypeFromNodeCoord(node)) continue;
            coastalNodes.add(node);
        }
        if (coastalNodes.isEmpty()) {
            return null;
        }
        ArrayList<Integer> potentialEdges = new ArrayList<Integer>();
        Iterator iterator = coastalNodes.iterator();
        while (iterator.hasNext()) {
            node = (Integer)iterator.next();
            for (int edge : board.getAdjacentEdgesToNode_coastal(node)) {
                if (-1 != board.getPortTypeFromNodeCoord(board.getAdjacentNodeFarEndOfEdge(edge, node))) continue;
                potentialEdges.add(edge);
                if (all) continue;
                return potentialEdges;
            }
        }
        return potentialEdges.isEmpty() ? null : potentialEdges;
    }

    public void setPortFlag(int portType, boolean value) {
        this.ports[portType] = value;
    }

    public boolean getPortFlag(int portType) {
        return this.ports[portType];
    }

    public boolean[] getPortFlags() {
        return this.ports;
    }

    public StringBuffer numpieces(StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer("{");
        } else {
            sb.append("{");
        }
        for (int i = 0; i < this.numPieces.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.numPieces[i]);
        }
        sb.append("}");
        return sb;
    }

    public boolean hasSettlementOrCityAtNode(int node) {
        return null != this.getSettlementOrCityAtNode(node);
    }

    public boolean hasSettlementAtNode(int node) {
        for (SOCSettlement p : this.settlements) {
            if (p.getCoordinates() != node) continue;
            return true;
        }
        return false;
    }

    public boolean hasCityAtNode(int node) {
        for (SOCCity p : this.cities) {
            if (p.getCoordinates() != node) continue;
            return true;
        }
        return false;
    }

    public boolean hasRoadOrShipAtEdge(int edge) {
        return null != this.getRoadOrShip(edge);
    }

    public void destroyPlayer() {
        this.game = null;
        this.numPieces = null;
        this.pieces.removeAllElements();
        this.pieces = null;
        this.roadsAndShips.removeAllElements();
        this.roadsAndShips = null;
        this.settlements.removeAllElements();
        this.settlements = null;
        this.cities.removeAllElements();
        this.cities = null;
        this.spItems.clear();
        this.spItems = null;
        this.fortress = null;
        this.resources = null;
        this.resourceStats = null;
        this.tradeStatsGive = null;
        this.tradeStatsGet = null;
        this.inventory = null;
        this.ourNumbers = null;
        this.ports = null;
        this.roadNodes.removeAllElements();
        this.roadNodes = null;
        this.roadNodeGraph.clear();
        this.roadNodeGraph = null;
        if (this.legalRoads != null) {
            this.legalRoads.clear();
            this.legalRoads = null;
            this.legalSettlements.clear();
            this.legalSettlements = null;
            this.legalShips.clear();
            this.legalShips = null;
            if (this.legalShipsRestricted != null) {
                this.legalShipsRestricted.clear();
                this.legalShipsRestricted = null;
            }
            this.potentialRoads.clear();
            this.potentialRoads = null;
            this.potentialSettlements.clear();
            this.potentialSettlements = null;
            this.potentialCities.clear();
            this.potentialCities = null;
            this.potentialShips.clear();
            this.potentialShips = null;
        }
        this.currentOffer = null;
    }

    public String toString() {
        return "Player[" + this.playerNumber + ' ' + this.name + ']';
    }

    public static class SpecialVPInfo {
        public final int svp;
        public final String desc;

        public SpecialVPInfo(int svp, String desc) {
            this.svp = svp;
            this.desc = desc;
        }
    }
}

